/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.hive.HiveDatabase;
import oracle.javatools.db.hive.HiveDatabaseDescriptor;
import oracle.javatools.db.hive.HiveDatabaseImpl;

public class HiveDatabaseCreator
extends BaseDatabaseCreator {
    protected Database createDatabaseImpl(String connStore, String name, Connection conn) throws DBException {
        HiveDatabaseImpl retval = null;
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String dbName = dmd.getDatabaseProductName();
                if (dbName.startsWith("Apache Hive")) {
                    int dbVer = dmd.getDatabaseMajorVersion();
                    int dbVer2 = dmd.getDatabaseMinorVersion();
                    int ver = dbVer == 0 && dbVer2 <= 12 ? 12 : (dbVer == 0 && dbVer2 == 13 ? 13 : 14);
                    retval = new HiveDatabaseImpl(connStore, name, conn, ver);
                }
            }
            catch (SQLException sqe) {
                DBLog.getLogger((Object)((Object)this)).fine(sqe.getMessage());
            }
        }
        return retval;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        HiveDatabaseDescriptor retval = null;
        if (HiveDatabaseImpl.class.isAssignableFrom(providerClass)) {
            retval = new HiveDatabaseDescriptor(12);
        }
        return retval;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(String type, int ver) {
        return "Hive".equals(type) ? new HiveDatabaseDescriptor(ver) : null;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Database db) {
        return db instanceof HiveDatabase ? new HiveDatabaseDescriptor(db.getDatabaseVersion()) : null;
    }
}

