/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import java.util.Map;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.hive.HiveBucketPropertiesValidator;
import oracle.javatools.db.hive.HiveDDLGenerator;
import oracle.javatools.db.hive.HiveDatabaseImpl;
import oracle.javatools.db.hive.HivePartitionPropertiesValidator;
import oracle.javatools.db.hive.HivePartitionValidator;
import oracle.javatools.db.hive.HiveSkewPropertiesValidator;
import oracle.javatools.db.hive.HiveStoragePropertiesValidator;
import oracle.javatools.db.hive.HiveTableValidator;
import oracle.javatools.db.hive.resource.HiveBundle;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;

public class HiveDatabaseDescriptor
extends JdbcDatabaseDescriptor {
    private final int m_version;

    HiveDatabaseDescriptor(int version) {
        super(HiveDatabaseImpl.class);
        this.m_version = version;
    }

    @Override
    public String getDatabaseType() {
        return "Hive";
    }

    @Override
    public int getDatabaseVersion() {
        return this.m_version;
    }

    @Override
    public int getCasePolicy() {
        return 1;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "`";
    }

    @Override
    public int getMaxNameLength(String type) {
        return Integer.MAX_VALUE;
    }

    public String getDefaultSchemaName() {
        return "default";
    }

    public String getSchemaDisplayName() {
        return APIBundle.get((String)"DATABASE");
    }

    @Override
    protected void registerDataTypes(DataTypeCache cache) {
        cache.setResourceBundle(HiveBundle.getBundle());
        if (this.m_version == 12) {
            cache.registerDataType("TINYINT");
            cache.registerDataType("SMALLINT");
            cache.registerDataType("INT");
            cache.registerDataType("BIGINT");
            cache.registerDataType("BOOLEAN");
            cache.registerDataType("FLOAT");
            cache.registerDataType("DOUBLE");
            cache.registerDataType("STRING");
            cache.registerDataType("BINARY");
            cache.registerDataType("DATE");
            cache.registerDataType("TIMESTAMP");
            cache.registerDataType("DECIMAL");
            cache.registerDataType("VARCHAR");
            cache.registerDataType("ARRAY");
            cache.registerDataType("MAP");
            cache.registerDataType("STRUCT");
            cache.registerDataType("UNIONTYPE");
        } else if (this.m_version == 13) {
            cache.registerDataType("CHAR");
            cache.registerDataType("DECIMAL");
        }
    }

    @Override
    public void validateName(String type, String name) throws InvalidNameException {
        if (!"HivePartition".equals(type)) {
            super.validateName(type, name);
        }
    }

    public DataTypeUsage createDefaultTypeUsage() {
        DataType type = this.getDataType("STRING");
        assert (type != null);
        DataTypeUsage retval = type == null ? super.createDefaultTypeUsage() : type.createDefaultUsage();
        return retval;
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider pro) {
        Map<String, DBObjectValidator> retval = super.getValidators(pro);
        retval.put("HiveStorageProperties", new HiveStoragePropertiesValidator(pro));
        retval.put("HiveBucketProperties", new HiveBucketPropertiesValidator(pro));
        retval.put("HivePartitionProperties", new HivePartitionPropertiesValidator(pro));
        retval.put("HiveSkewProperties", new HiveSkewPropertiesValidator(pro));
        retval.put("HivePartition", new HivePartitionValidator(pro));
        retval.put("TABLE", (DBObjectValidator)new HiveTableValidator(pro));
        retval.remove("VIEW");
        return retval;
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        return new HiveDDLGenerator(pro);
    }
}

