/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.BaseDatabaseDescriptor;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeSynonym;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.jdbc.JdbcDDLGenerator;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ViewValidator;

public class JdbcDatabaseDescriptor
extends BaseDatabaseDescriptor {
    private static final int MAX_NAME_LENGTH = 500;
    private static final char QUOTE_IDENTIFIER = '\'';
    private String m_quoteIdent;
    private int m_casePolicy = -1;
    private Database m_db;

    public JdbcDatabaseDescriptor(Class<? extends Database> clz) {
        super(clz);
    }

    public JdbcDatabaseDescriptor(Database db) {
        this(db.getClass());
        this.m_db = db;
    }

    public int getCasePolicy() {
        Connection c;
        if (this.m_casePolicy < 0 && this.m_db != null && (c = this.m_db.getConnection()) != null) {
            try {
                DatabaseMetaData dm = c.getMetaData();
                boolean lower = dm.storesLowerCaseIdentifiers();
                boolean lowerQuoted = dm.storesLowerCaseQuotedIdentifiers();
                boolean mixed = dm.storesMixedCaseIdentifiers();
                boolean mixedQuoted = dm.storesMixedCaseQuotedIdentifiers();
                boolean upper = dm.storesUpperCaseIdentifiers();
                boolean upperQuoted = dm.storesUpperCaseQuotedIdentifiers();
                this.m_casePolicy = lower ? 1 : (upper ? 2 : 0);
            }
            catch (SQLException e) {
                this.getLogger().log(Level.WARNING, "Could not get case policy for {0}: {1}", new Object[]{this.m_db.getConnectionName(), e.getMessage()});
            }
        }
        return this.m_casePolicy < 0 ? 0 : this.m_casePolicy;
    }

    public String getIdentifierQuoteString() {
        Connection c;
        if (this.m_db != null && this.m_quoteIdent == null && (c = this.m_db.getConnection()) != null) {
            try {
                DatabaseMetaData dm = c.getMetaData();
                this.m_quoteIdent = dm.getIdentifierQuoteString();
            }
            catch (SQLException e) {
                this.getLogger().log(Level.WARNING, "Could not get quote string for {0}: {1}", new Object[]{this.m_db.getConnectionName(), e.getMessage()});
            }
        }
        return this.m_quoteIdent == null ? String.valueOf('\'') : this.m_quoteIdent;
    }

    public int getMaxNameLength(String type) {
        return 500;
    }

    public void validateName(String type, String name) throws InvalidNameException {
        JdbcDatabaseDescriptor.validateIdentifier((String)name, (char)'\'', (int)500, null, (boolean)true, null, (int)this.getCasePolicy(), (boolean)this.allowSurrogatesInIdentifierValidation());
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider pro) {
        Map<String, DBObjectValidator> v = super.getValidators(pro);
        v.put("VIEW", (DBObjectValidator)new ViewValidator(pro));
        return v;
    }

    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        return new JdbcDDLGenerator(pro);
    }

    public boolean isCompatibleWith(DatabaseDescriptor other) {
        boolean retval = DataTypeRegistry.isGenericJdbcClass((Class)this.getDatabaseClass()) ? false : super.isCompatibleWith(other);
        return retval;
    }

    public String getDatabaseType() {
        return "Generic JDBC";
    }

    public int getDatabaseVersion() {
        return 0;
    }

    public Collection<String> getReservedWords() {
        return Collections.emptySet();
    }

    public SQLQueryBuilderFactory getSQLQueryBuilderFactory() {
        return new OracleSQLQueryBuilderFactory();
    }

    protected void registerDataTypes(DataTypeCache cache) {
        if (this.getDatabaseType().equals("Generic JDBC") && this.getDatabaseVersion() == 0) {
            for (Field f : JdbcDatabase.class.getDeclaredFields()) {
                try {
                    if (!f.getName().startsWith("ANSI_") || !Modifier.isStatic(f.getModifiers()) || !DataType.class.equals(f.getType())) continue;
                    DataType dt = (DataType)f.get(null);
                    if (dt instanceof PredefinedDataType) {
                        cache.registerDataTypeResource((PredefinedDataType)dt);
                        continue;
                    }
                    if (!(dt instanceof DataTypeSynonym)) continue;
                    cache.registerDataType(dt);
                }
                catch (Exception e) {
                    DBLog.logStackTrace((String)f.getName(), (Throwable)e);
                }
            }
        }
    }
}

