/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.GenericComparator;
import oracle.javatools.db.marshal.DBObjectHandler;
import oracle.javatools.db.marshal.DBObjectRefsSAXHelper;
import oracle.javatools.db.marshal.DBObjectSAXHelper;
import oracle.javatools.db.marshal.DBObjectXMLHandler;
import oracle.javatools.db.marshal.PartialParseUnsupportedException;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.ModelUtil;
import org.xml.sax.SAXException;

public class DBObject2XML
extends DBObjectXMLHandler {
    private static final String HEADER = "<?xml version = '1.0' encoding = 'UTF-8'?>\n";
    private static final String INDENT = "  ";
    private static final String NEWLINE = "\n";
    static final String COMPOSITE = "composite";
    static final String ENTRY = "entry";
    static final String KEY = "key";
    static final String VALUE = "value";
    static final String CLASS = "class";
    private Map<Class, Boolean> m_stringInfo;
    private Map<String, Class<? extends DBObject>> m_oldClzMappings;

    public DBObject2XML() {
        this(null);
    }

    public DBObject2XML(String namespace) {
        this(namespace, null);
    }

    public DBObject2XML(String namespace, Map<String, Class<? extends DBObject>> oldClzMappings) {
        super(namespace);
        this.m_oldClzMappings = oldClzMappings;
    }

    private Iterable<PropertyInfo> getBeanPropertyInfos(Object bean, boolean excludeTransient) {
        PropertyCriteria crit;
        if (excludeTransient) {
            crit = new PropertyCriteria();
            crit.addPredicate(info -> !info.isGetTransient() && !info.isSetTransient());
        } else {
            crit = PropertyCriteria.createEmptyCriteria();
        }
        crit.setIncludeExtra(false);
        Map infos = PropertyHelper.getPropertyInfos(bean.getClass(), null, (PropertyCriteria)crit);
        TreeSet<PropertyInfo> sorted = new TreeSet<PropertyInfo>();
        sorted.addAll(infos.values());
        return sorted;
    }

    protected boolean toStringConverterAvailable(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.toStringConverterAvailable(obj.getClass());
    }

    protected boolean toStringConverterAvailable(Class clz) {
        if (this.m_stringInfo == null) {
            this.m_stringInfo = new HashMap<Class, Boolean>();
        } else if (this.m_stringInfo.containsKey(clz)) {
            return this.m_stringInfo.get(clz);
        }
        boolean boo = ToStringManager.converterAvailable((Class)clz);
        this.m_stringInfo.put(clz, boo);
        return boo;
    }

    public void write(List<? extends DBObject> objs, Writer writer) throws IOException {
        writer.write(HEADER);
        if (objs.size() > 1) {
            if (!(writer instanceof BufferedWriter)) {
                writer = new BufferedWriter(writer);
            }
            this.writeOpenTag(null, COMPOSITE, null, "", writer);
            writer.write(NEWLINE);
            for (DBObject dBObject : objs) {
                this.writeObject(dBObject, INDENT, writer);
            }
            this.writeEndTag(COMPOSITE, "", writer);
            writer.flush();
        } else {
            this.writeObject(objs.get(0), "", writer);
        }
    }

    private void writeObject(Object obj, String indent, Writer writer) throws IOException {
        String tagName = this.getDefaultTagName(obj);
        if (!(writer instanceof BufferedWriter)) {
            writer = new BufferedWriter(writer);
        }
        this.writeObject(obj, tagName, null, indent, writer);
        writer.flush();
    }

    private String getDefaultTagName(Object obj) {
        if (obj instanceof DBObject) {
            return DBObject2XML.convertType(((DBObject)obj).getType());
        }
        return obj.getClass().getName();
    }

    private void writeObject(Object obj, String tagName, Class defaultClass, String indent, Writer writer) throws IOException {
        this.writeObject(obj, null, tagName, defaultClass, indent, writer);
    }

    private void writeObject(Object obj, Object parent, String tagName, Class defaultClass, String indent, Writer writer) throws IOException {
        if (this.toStringConverterAvailable(obj)) {
            String string = obj instanceof String ? (String)obj : ToStringManager.toString((Object)obj);
            if ((string = DBObject2XML.encodeText(string)) != null) {
                this.writeOpenTag(obj, tagName, defaultClass, indent, writer);
                writer.write(string);
                this.writeEndTag(tagName, "", writer);
            }
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            ArrayList<String> ignoreTheseProps = new ArrayList<String>();
            if (parent != null && tagName.equals("properties")) {
                for (PropertyInfo info : this.getBeanPropertyInfos(parent, false)) {
                    ignoreTheseProps.add(info.getPropertyName());
                }
            }
            TreeMap<Object, Object> entries = new TreeMap<Object, Object>((Comparator<Object>)new GenericComparator());
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                if (ignoreTheseProps.contains(key)) continue;
                entries.put(key, entry.getValue());
            }
            if (entries.size() > 0) {
                this.writeOpenTag(obj, tagName, defaultClass, indent, writer);
                writer.write(NEWLINE);
                this.writeEntries(entries, indent + INDENT, writer);
                this.writeEndTag(tagName, indent, writer);
            }
        } else if (obj instanceof Object[]) {
            Object[] valueA = (Object[])obj;
            if (ModelUtil.hasNonNullElement((Object[])valueA)) {
                this.writeOpenTag(obj, tagName, defaultClass, indent, writer);
                writer.write(NEWLINE);
                for (int i = 0; i < valueA.length; ++i) {
                    Class<?> compClz = defaultClass.getComponentType();
                    String childTag = tagName;
                    childTag = childTag.equals("indexes") ? "index" : (childTag.endsWith("s") ? childTag.substring(0, childTag.length() - 1) : childTag + "Item");
                    if (valueA[i] == null) continue;
                    this.writeObject(valueA[i], childTag, compClz, indent + INDENT, writer);
                }
                this.writeEndTag(tagName, indent, writer);
            }
        } else if (obj instanceof TemporaryObjectID) {
            TemporaryObjectID tempID = (TemporaryObjectID)obj;
            DBLog.logIllegalState((String)("Trying to save TemporaryObjectID of type " + tempID.getType() + " to XML: " + tempID.toString()));
        } else {
            this.writeOpenTag(obj, tagName, defaultClass, indent, writer);
            writer.write(NEWLINE);
            this.writeProperties(obj, indent + INDENT, writer);
            this.writeEndTag(tagName, indent, writer);
        }
    }

    private void writeOpenTag(Object obj, String tagName, Class defaultClass, String indent, Writer writer) throws IOException {
        writer.write(indent);
        writer.write("<");
        writer.write(tagName);
        if (defaultClass != null && defaultClass != Map.class && obj != null && obj.getClass() != ToStringManager.wrapPrimitive((Class)defaultClass)) {
            writer.write(" ");
            writer.write(CLASS);
            writer.write("=\"");
            writer.write(obj.getClass().getName());
            writer.write("\"");
        }
        String namespace = this.getNamespace();
        if (!ModelUtil.hasLength((String)indent) && ModelUtil.hasLength((String)namespace)) {
            writer.write(" xmlns=\"");
            writer.write(namespace);
            writer.write("\"");
        }
        writer.write(">");
    }

    private void writeProperties(Object obj, String indent, Writer writer) throws IOException {
        for (PropertyInfo prop : this.getBeanPropertyInfos(obj, true)) {
            String name = prop.getPropertyName();
            Object value = prop.getPropertyValue(obj);
            if (value == null) continue;
            if ("ID".equals(name) && value instanceof BaseObjectID) {
                Object identifier;
                if (!(value instanceof IdentifierBasedID) || (identifier = ((IdentifierBasedID)value).getIdentifier()) == null) continue;
                this.writeOpenTag(value, "ID", DBObjectID.class, indent, writer);
                writer.write(NEWLINE);
                this.writeObject(identifier, "identifier", Object.class, indent + INDENT, writer);
                this.writeEndTag("ID", indent, writer);
                continue;
            }
            if ("schema".equals(name)) {
                if (!(value instanceof Schema)) continue;
                String schemaName = ((Schema)value).getName();
                this.writeOpenTag(value, "schema", Schema.class, indent, writer);
                writer.write(NEWLINE);
                this.writeObject(schemaName, "name", String.class, indent + INDENT, writer);
                this.writeEndTag("schema", indent, writer);
                continue;
            }
            this.writeObject(value, obj, name, prop.getPropertyClass(), indent, writer);
        }
    }

    private void writeEntries(Map<Object, Object> map, String indent, Writer writer) throws IOException {
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            this.writeOpenTag(null, ENTRY, null, indent, writer);
            writer.write(NEWLINE);
            Object key = entry.getKey();
            if (key instanceof String) {
                String newIndent = indent + INDENT;
                this.writeOpenTag(null, KEY, null, newIndent, writer);
                writer.write((String)key);
                this.writeEndTag(KEY, "", writer);
                Object value = entry.getValue();
                if (value != null) {
                    this.writeObject(value, VALUE, value instanceof Object[] ? Object[].class : Object.class, newIndent, writer);
                }
            } else {
                new UnsupportedOperationException("map keys must be strings").printStackTrace();
            }
            this.writeEndTag(ENTRY, indent, writer);
        }
    }

    private void writeEndTag(String name, String indent, Writer writer) throws IOException {
        writer.write(indent);
        writer.write("</" + name + ">\n");
    }

    protected List<DBObject> readImpl(Reader reader, DBObjectProvider pro, Schema schema) throws IOException {
        return this.read(reader, pro, false);
    }

    protected List<DBObject> readInfoImpl(Reader reader, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        try {
            return this.read(reader, pro, true);
        }
        catch (IOException ioe) {
            Throwable rootCause;
            Throwable cause = ioe.getCause();
            if (cause instanceof SAXException && (rootCause = cause.getCause()) instanceof PartialParseUnsupportedException) {
                throw (PartialParseUnsupportedException)rootCause;
            }
            throw ioe;
        }
    }

    private List<DBObject> read(Reader reader, DBObjectProvider pro, boolean idNameOnly) throws IOException {
        DBObjectSAXHelper helper = new DBObjectSAXHelper(this.getNamespace(), idNameOnly, this);
        helper.setProvider(pro);
        if (this.m_oldClzMappings != null) {
            helper.setTypeMappings(this.m_oldClzMappings);
        }
        DBObject2XML.read(reader, helper, idNameOnly);
        return helper.getDBObjects();
    }

    static String convertType(String type) {
        boolean upper = DBObject2XML.isUpperCase(type);
        StringBuilder buff = new StringBuilder(upper ? type.toLowerCase() : type);
        if (!upper) {
            DBObject2XML.changeCase(buff, 0);
        }
        int i = buff.indexOf(" ");
        while (i > -1) {
            buff.deleteCharAt(i);
            DBObject2XML.changeCase(buff, i);
            i = buff.indexOf(" ", i);
        }
        return buff.toString();
    }

    private static boolean isUpperCase(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isLowerCase(c) || c == ' ') continue;
            return false;
        }
        return true;
    }

    private static void changeCase(StringBuilder buff, int index) {
        char c = buff.charAt(index);
        if (Character.isUpperCase(c)) {
            buff.setCharAt(index, Character.toLowerCase(c));
        } else {
            buff.setCharAt(index, Character.toUpperCase(c));
        }
    }

    private static boolean isNonValidXMLChar(char current) {
        return !(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff');
    }

    private static String encodeText(String in) {
        if (!ModelUtil.hasLength((String)in)) {
            return in;
        }
        StringBuilder out = new StringBuilder();
        block7: for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (DBObject2XML.isNonValidXMLChar(c)) {
                out = null;
                break;
            }
            switch (c) {
                case '<': {
                    out.append("&lt;");
                    continue block7;
                }
                case '>': {
                    out.append("&gt;");
                    continue block7;
                }
                case '&': {
                    out.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    out.append("&apos;");
                    continue block7;
                }
                default: {
                    out.append(c);
                }
            }
        }
        if (out == null) {
            out = new StringBuilder();
            out.append("<![CDATA[");
            out.append(in);
            out.append("]]>");
        }
        return out.toString();
    }

    protected void readIDsImpl(DBObjectHandler.UnmarshalledIDs ids, Reader reader, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        DBObjectRefsSAXHelper helper = new DBObjectRefsSAXHelper(this.getNamespace(), ids, this.getIDClassPatterns(), this.getParsedProperties());
        helper.setProvider(pro);
        DBObject2XML.read(reader, helper, false);
        if (schema != null) {
            String sname = schema.getName();
            for (DBObjectID id : ids.getObjectIDs()) {
                ((BaseObjectID)id).setSchemaName(sname);
            }
        }
    }

    protected Collection<String> getIDClassPatterns() {
        HashSet<String> patterns = new HashSet<String>();
        patterns.add("oracle\\.javatools\\.db\\..*ID");
        return patterns;
    }

    protected Collection<String> getParsedProperties() {
        HashSet<String> props = new HashSet<String>();
        props.add("queryString");
        return props;
    }
}

