/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.util.ModelUtil;

class DatabaseLinkBuilder
extends OracleDBObjectBuilder<DatabaseLink> {
    DatabaseLinkBuilder(BaseOracleDatabase db) {
        super(db, "DATABASE LINK");
    }

    public DatabaseLink createObject(String name, Schema schema, DBObjectID id) {
        DatabaseLink dbl = (DatabaseLink)super.createObject(name, schema, id);
        dbl.setPublic(this.getDatabase().isPublicSchema(schema));
        return dbl;
    }

    protected void fillInObject(DatabaseLink dblink) throws DBException {
        QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)dblink, this.getQuery(), dblink, dblink.getSchema());
        try {
            this.fillInObjectImpl(wrap, dblink);
        }
        catch (DBException dbe) {
            if (dbe.getMessage().contains("ORA-31603")) {
                DBLog.getLogger((Object)((Object)this)).warning("Querying some database link properties with dbms_metadata failed permission check");
                QueryWrapper wrapUpWarm = this.getDatabase().newQueryWrapper((SystemObject)dblink, this.getBackupQuery(), dblink, dblink.getSchema());
                this.fillInObjectImpl(wrapUpWarm, dblink);
            }
            throw dbe;
        }
    }

    private void fillInObjectImpl(final QueryWrapper wrap, final DatabaseLink dblink) throws DBException {
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        String username = rs.getString(1);
                        if ("CURRENT_USER".equals(username)) {
                            dblink.setConnectToUser(Boolean.valueOf(true));
                        } else if (ModelUtil.hasLength((String)username)) {
                            dblink.setConnectToUser(Boolean.valueOf(false));
                            dblink.setUsername(username);
                            dblink.setPasswordX(null);
                            dblink.setPasswordX(rs.getString(5));
                        }
                        String host = rs.getString(2);
                        dblink.setHost(host);
                        String created = rs.getString(3);
                        dblink.setCreated(created);
                        String authusr = rs.getString(4);
                        if (authusr != null) {
                            dblink.setShared(true);
                            dblink.setAuthentificationUsername(authusr);
                            dblink.setAuthentificationPassword(null);
                            dblink.setAuthentificationPasswordX(rs.getString(6));
                        }
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)dblink, ex);
                }
            }
        };
        wrap.executeQuery(r);
        dblink.setPublic("PUBLIC".equals(dblink.getSchema().getName()));
    }

    private String getQuery() {
        if (this.getDatabase() instanceof Oracle10g) {
            return "WITH API AS (SELECT ? NAME \n             ,      (SELECT SUBSTR(GLOBAL_NAME,INSTR(GLOBAL_NAME,'.')) FROM GLOBAL_NAME) GNAME\n             ,      DBL2.DB_LINK\n             ,      DBL2.OWNER\n             ,      TO_CHAR(DBMS_METADATA.GET_XML('DB_LINK',DBL2.DB_LINK,DBL2.OWNER)) XML\n             FROM   SYS.ALL_DB_LINKS DBL2)\nSELECT /*OracleDictionaryQueries.ALL_DATABASE_LINK_OBJECT_QUERY*/\n       DBL.USERNAME, DBL.HOST, DBL.CREATED,\n       REGEXP_REPLACE(REGEXP_SUBSTR(A.XML, '<AUTHUSR>.*AUTHUSR>',1,1,'n'),'<\\/*AUTHUSR>',null) AUTHUSR,\n       REGEXP_REPLACE(REGEXP_SUBSTR(A.XML, '<PASSWORDX>.*PASSWORDX>',1,1,'n'),'<\\/*PASSWORDX>',null) PASSWORDX,\n       REGEXP_REPLACE(REGEXP_SUBSTR(A.XML, '<AUTHPWDX>.*AUTHPWDX>',1,1,'n'),'<\\/*AUTHPWDX>',null) AUTHPWDX\nFROM  API A\n,     SYS.ALL_DB_LINKS DBL\nWHERE DBL.OWNER = A.OWNER\nAND   DBL.DB_LINK = A.DB_LINK\nAND   DBL.OWNER = ?\nAND   ( DBL.DB_LINK = A.NAME OR DBL.DB_LINK = A.NAME||A.GNAME )";
        }
        return "WITH API AS (SELECT ? NAME \n             ,      (SELECT SUBSTR(GLOBAL_NAME,INSTR(GLOBAL_NAME,'.')) FROM GLOBAL_NAME) GNAME\n             ,      DBL2.DB_LINK\n             ,      DBL2.OWNER\n             ,      TO_CHAR(DBMS_METADATA.GET_XML('DB_LINK',DBL2.DB_LINK,DBL2.OWNER)) XML\n             FROM   SYS.ALL_DB_LINKS DBL2)\nSELECT /*OracleDictionaryQueries.ALL_DATABASE_LINK_OBJECT_QUERY*/\n       DBL.USERNAME, DBL.HOST, DBL.CREATED,\n       NULL AUTHUSR,\n       NULL PASSWORDX,\n       NULL AUTHPWDX\nFROM  API A\n,     SYS.ALL_DB_LINKS DBL\nWHERE DBL.OWNER = A.OWNER\nAND   DBL.DB_LINK = A.DB_LINK\nAND   DBL.OWNER = ?\nAND   ( DBL.DB_LINK = A.NAME OR DBL.DB_LINK = A.NAME||A.GNAME )";
    }

    private String getBackupQuery() {
        return "WITH API AS (SELECT ? NAME \n             ,      (SELECT SUBSTR(GLOBAL_NAME,INSTR(GLOBAL_NAME,'.')) FROM GLOBAL_NAME) GNAME\n             ,      DBL2.DB_LINK\n             ,      DBL2.OWNER\n             FROM   SYS.ALL_DB_LINKS DBL2)\nSELECT /*OracleDictionaryQueries.ALL_DATABASE_LINK_OBJECT_BACKUP_QUERY*/\n       DBL.USERNAME, DBL.HOST, DBL.CREATED,\n       null AUTHUSR,\n       null PASSWORDX,\n       null AUTHPWDX\nFROM  API A\n,     SYS.ALL_DB_LINKS DBL\nWHERE DBL.OWNER = A.OWNER\nAND   DBL.DB_LINK = A.DB_LINK\nAND   DBL.OWNER = ?\nAND   ( DBL.DB_LINK = A.NAME OR DBL.DB_LINK = A.NAME||A.GNAME )";
    }
}

