/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.util.ArrayList;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ora.Oracle9iR2;
import oracle.javatools.db.ora.OracleTablespaceBuilder;
import oracle.javatools.db.ora.RecycledObject;
import oracle.javatools.db.ora.RecycledObjectBuilder;

public class Oracle10g
extends Oracle9iR2 {
    Oracle10g(String connStore, String connName, Connection conn, int version) {
        super(connStore, connName, conn, version);
    }

    @Override
    protected void registerBuilders() {
        super.registerBuilders();
        this.registerBuilder("RECYCLEBIN", (DBObjectBuilder)new RecycledObjectBuilder(this));
        this.registerBuilder("TABLESPACE", (DBObjectBuilder)new OracleTablespaceBuilder(this));
    }

    protected void finishDelete(SystemObject[] objs) {
        super.finishDelete(objs);
        ArrayList<SchemaObject> undropped = new ArrayList<SchemaObject>();
        for (SystemObject so : objs) {
            if (!(so instanceof RecycledObject)) continue;
            try {
                SchemaObject ud = this.getObject(((RecycledObject)so).getOriginalType(), ((RecycledObject)so).getSchema(), ((RecycledObject)so).getOriginalName());
                if (ud == null) continue;
                undropped.add(ud);
            }
            catch (DBException dbe) {
                this.getLogger().warning(dbe.getMessage());
            }
        }
        if (undropped.size() > 0) {
            this.fireObjectsAdded(undropped);
        }
    }
}

