/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.MultitenantContainerInfo;
import oracle.javatools.db.ora.Oracle11gR2;
import oracle.javatools.db.resource.APIBundle;

public class Oracle12c
extends Oracle11gR2 {
    private MultitenantContainerInfo m_containerInfo;

    Oracle12c(String connStore, String connName, Connection conn, int version) {
        super(connStore, connName, conn, version);
    }

    @Override
    public MultitenantContainerInfo getMultitenantContainerInfo() {
        if (this.m_containerInfo == null) {
            QueryWrapper wrap = this.newQueryWrapper(null, "SELECT /*OracleDictionaryQueries.CONTAINER_QUERY*/ SYS_CONTEXT('USERENV','CON_ID') id,SYS_CONTEXT('USERENV','CON_NAME') name FROM SYS.DUAL", new Object[0]);
            try {
                wrap.executeQuery(rs -> this.processContainerResultSet(rs));
            }
            catch (DBException dbe) {
                this.getLogger().warning(APIBundle.format((String)"MT_CONTAINER_ERR", (Object[])new Object[]{this.getConnectionName(), dbe.getMessage()}));
            }
        }
        return this.m_containerInfo;
    }

    private void processContainerResultSet(ResultSet rs) throws DBException, SQLException {
        if (rs.next()) {
            this.m_containerInfo = new MultitenantContainerInfo(rs.getInt(1), rs.getString(2));
        }
    }

    @Override
    public boolean supportsDatabaseChangeNotification() {
        MultitenantContainerInfo mci;
        boolean retval = super.supportsDatabaseChangeNotification();
        if (retval && (mci = this.getMultitenantContainerInfo()) != null) {
            retval = !mci.isPluggableDatabase();
        }
        return retval;
    }
}

