/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.IntStream;
import oracle.i18n.util.OraSQLUtil;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseDatabaseDescriptor;
import oracle.javatools.db.BuiltInObjectCache;
import oracle.javatools.db.ColumnSequenceProcessor;
import oracle.javatools.db.ConstraintIndexHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.View;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.extension.DelegateDDLGenerator;
import oracle.javatools.db.ora.ExternalTablePropertiesBuilder;
import oracle.javatools.db.ora.Indextype;
import oracle.javatools.db.ora.LocalTablePartitionModelIDBuilder;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDatabaseFactory;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleDatabaseXE;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.db.ora.OracleNumberDataType;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.ReferencePartitionModelIDBuilder;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameter;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterBuilder;
import oracle.javatools.db.ora.ddl.OracleDDLGenerator;
import oracle.javatools.db.ora.resource.OracleFunctionsBundle;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderFactory;
import oracle.javatools.db.ora.sql.SqlUsageUtil;
import oracle.javatools.db.ora.validators.DatabaseLinkValidator;
import oracle.javatools.db.ora.validators.DirectoryValidator;
import oracle.javatools.db.ora.validators.ExternalTablePropsValidator;
import oracle.javatools.db.ora.validators.IOTPropertiesValidator;
import oracle.javatools.db.ora.validators.InMemoryColumnPropertiesValidator;
import oracle.javatools.db.ora.validators.InMemoryPropertiesValidator;
import oracle.javatools.db.ora.validators.IndexPartitionValidator;
import oracle.javatools.db.ora.validators.IndexPartitionsValidator;
import oracle.javatools.db.ora.validators.LOBDescriptorValidator;
import oracle.javatools.db.ora.validators.MaterializedViewLogValidator;
import oracle.javatools.db.ora.validators.MaterializedViewValidator;
import oracle.javatools.db.ora.validators.NestedTablePropertiesValidator;
import oracle.javatools.db.ora.validators.OracleColumnPropertiesValidator;
import oracle.javatools.db.ora.validators.OracleColumnValidator;
import oracle.javatools.db.ora.validators.OracleConstraintValidator;
import oracle.javatools.db.ora.validators.OracleDataTypeUsageValidator;
import oracle.javatools.db.ora.validators.OracleIndexValidator;
import oracle.javatools.db.ora.validators.OracleTablePropertiesValidator;
import oracle.javatools.db.ora.validators.OracleTableValidator;
import oracle.javatools.db.ora.validators.OracleTablespacePropertiesValidator;
import oracle.javatools.db.ora.validators.OracleTablespaceValidator;
import oracle.javatools.db.ora.validators.StoragePropertiesValidator;
import oracle.javatools.db.ora.validators.TablePartitionValidator;
import oracle.javatools.db.ora.validators.TablePartitionsValidator;
import oracle.javatools.db.ora.validators.XMLTypeColumnPropertiesValidator;
import oracle.javatools.db.plsql.DefaultSourceOptions;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.parser.PlSqlParserFactory;
import oracle.javatools.db.plsql.parser.PlSqlParserFactoryImpl;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SqlAliasExpander;
import oracle.javatools.db.util.DBObjectSet;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.FileSpecificationValidator;
import oracle.javatools.db.validators.IdentityColumnPropertiesValidator;
import oracle.javatools.db.validators.PlSqlValidator;
import oracle.javatools.db.validators.SequenceValidator;
import oracle.javatools.db.validators.SynonymValidator;
import oracle.javatools.db.validators.TriggerValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ViewValidator;
import oracle.javatools.db.validators.XMLSchemaValidator;
import oracle.javatools.util.ModelUtil;
import oracle.sql.CharacterSet;

public class OracleDatabaseDescriptor
extends BaseDatabaseDescriptor {
    public static final String FEATURE_ORACLE_EXTERNAL_TABLE_PROJECT_COLUMN = "ORACLE_EXTERNAL_TABLE_PROJECT_COLUMN";
    public static final char QUOTE_IDENTIFIER = '\"';
    private static final int MAX_NAME_LEN = 30;
    private static final int MAX_DATABASE_LINK_NAME_LEN = 128;
    private static final int MAX_FILE_NAME_LEN = 256;
    private static final int MAX_JAVA_NAME_LEN = 4000;
    private static final char PERIOD = '.';
    private static final String ALLOWED_CHARS = "_$#";
    private static final String CTXSYS = "CTXSYS";
    private static final String EFXSYS = "EFXSYS";
    private static final String MDSYS = "MDSYS";
    private static final String ORDSYS = "ORDSYS";
    private static final String SYS = "SYS";
    private static final String XDB = "XDB";
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "DUAL", "ELSE", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MLSLABEL", "MODE", "MODIFY", "NOAUDIT", "NOCOMPRESS", "NOT", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PRIVILEGES", "PUBLIC", "RAW", "RENAME", "RESOURCE", "REVOKE", "ROW", "ROWID", "ROWNUM", "ROWS", "SELECT", "SESSION", "SET", "SHARE", "SIZE", "SMALLINT", "START", "SUCCESSFUL", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TO", "TRIGGER", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2", "VIEW", "WHENEVER", "WHERE", "WITH"));
    private final int m_version;

    public OracleDatabaseDescriptor(Class<? extends OracleDatabase> databaseClass) {
        this(databaseClass, OracleDatabaseDescriptor.getDatabaseVersion(databaseClass));
    }

    public OracleDatabaseDescriptor(int version) {
        this(OracleDatabaseDescriptor.getDatabaseClass(version), version);
    }

    protected OracleDatabaseDescriptor(Class<? extends OracleDatabase> databaseClass, int version) {
        super(databaseClass);
        this.m_version = version;
    }

    private String getDatabaseCharsetName() {
        return null;
    }

    private CharacterSet getDatabaseCharset() {
        return null;
    }

    public String getDatabaseType() {
        return "Oracle Database";
    }

    public int getDatabaseVersion() {
        return this.m_version;
    }

    public int getCasePolicy() {
        return 2;
    }

    @Override
    public List<UpdateProcessor> getUpdateProcessors() {
        List<UpdateProcessor> retval = super.getUpdateProcessors();
        retval.add(0, new ColumnSequenceProcessor());
        retval.add(new ConstraintIndexHelper.Processor());
        return retval;
    }

    public void validateEncoding(String string, Object property) throws ValidationException {
        CharacterSet charSet = this.getDatabaseCharset();
        if (charSet != null) {
            try {
                charSet.convert(string);
            }
            catch (SQLException sqe) {
                throw new ValidationException(null, APIBundle.format((String)"COMMENT_NOT_ENCODABLE", (Object[])new Object[]{string, this.getDatabaseCharsetName()}));
            }
            catch (Throwable t) {
                this.getLogger().log(DBLog.getExceptionLogLevel(), "Error validating encoding", t);
            }
        }
    }

    public String getIdentifierQuoteString() {
        return "\"";
    }

    public int getMaxNameLength(String type) {
        return OracleDatabaseDescriptor.getMaxIndentifierLength(type);
    }

    protected boolean needsQuoting(String internalName) {
        boolean retval = true;
        if (ModelUtil.hasLength((String)internalName) && internalName.length() == internalName.trim().length()) {
            try {
                OracleDatabaseDescriptor.validateIdentifier(null, internalName, this.allowSurrogatesInIdentifierValidation());
                retval = !internalName.equals(internalName.toUpperCase());
            }
            catch (InvalidNameException ine) {
                retval = true;
            }
        }
        return retval;
    }

    public void validateName(String type, String externalName) throws InvalidNameException {
        OracleDatabaseDescriptor.validateIdentifier(type, externalName, this.allowSurrogatesInIdentifierValidation());
        String charSetName = this.getDatabaseCharsetName();
        if (ModelUtil.hasLength((String)charSetName)) {
            try {
                if (!OraSQLUtil.isValidIdentifier((String)externalName, (String)charSetName)) {
                    throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_IN_CHARSET", (Object[])new Object[]{externalName, charSetName}));
                }
            }
            catch (UnsupportedEncodingException e) {
                this.getLogger().log(Level.WARNING, e.getMessage());
            }
            CharacterSet charSet = this.getDatabaseCharset();
            if (charSet != null) {
                String internalName = this.getInternalName(externalName, type);
                try {
                    if (charSet.encodedByteLength(internalName) > this.getMaxNameLength(type)) {
                        throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_TOO_LONG", (Object[])new Object[]{externalName}));
                    }
                }
                catch (SQLException e) {
                    this.getLogger().warning("Could not determine encoded byte length: " + e.getMessage());
                }
                catch (Throwable t) {
                    this.getLogger().log(DBLog.getExceptionLogLevel(), "Error determining encoded byte length", t);
                }
            }
        } else if (this.getIdeCharset() != null) {
            try {
                if (!this.canEncode(externalName)) {
                    throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_IN_CHARSET", (Object[])new Object[]{externalName, this.getIdeCharset().name()}));
                }
                String internalName = this.getInternalName(externalName, type);
                byte[] bytes = internalName.getBytes(this.getIdeCharset().name());
                if (bytes.length > this.getMaxNameLength(type)) {
                    throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_TOO_LONG", (Object[])new Object[]{externalName}));
                }
            }
            catch (UnsupportedEncodingException e) {
                this.getLogger().log(Level.WARNING, "Unsupported encoding: " + e.getMessage());
            }
        }
    }

    public String getExternalName(String name, String objectType) {
        if (ModelUtil.hasLength((String)name)) {
            if ("DATABASE LINK".equals(objectType)) {
                boolean isQuotedName;
                String externalName = "";
                int length = name.length();
                boolean bl = isQuotedName = name.charAt(0) == '\"' && name.indexOf(34, 1) == length - 1;
                if (isQuotedName) {
                    return name;
                }
                int searchFor = name.charAt(0) == '\"' ? 34 : 46;
                int startIdx = 0;
                while (startIdx < length) {
                    int srchIdx = startIdx + (searchFor == 34 ? 1 : 0);
                    int endIdx = name.indexOf(searchFor, srchIdx);
                    int n = endIdx > -1 ? endIdx + (searchFor == 34 ? 1 : 0) : (endIdx = length);
                    if (startIdx == endIdx) {
                        return name;
                    }
                    String component = name.substring(startIdx, endIdx);
                    externalName = externalName + (this.isValidName("DATABASE LINK", component) ? component : '\"' + component + '\"');
                    startIdx = endIdx + 1;
                    if (startIdx == length) {
                        return name;
                    }
                    if (startIdx >= length) continue;
                    externalName = externalName + '.';
                    searchFor = name.charAt(startIdx) == '\"' ? 34 : 46;
                }
                return this.isValidName("DATABASE LINK", externalName) ? externalName : name;
            }
            if ("XML SCHEMA".equals(objectType)) {
                return name;
            }
        }
        return super.getExternalName(name, objectType);
    }

    public String getInternalName(String name, String objectType) {
        if (ModelUtil.hasLength((String)name) && "DATABASE LINK".equals(objectType)) {
            return name.toUpperCase().replaceAll(String.valueOf('\"'), "");
        }
        if (ModelUtil.hasLength((String)name) && "XML SCHEMA".equals(objectType)) {
            return name;
        }
        return super.getInternalName(name, objectType);
    }

    public String getPublicSchemaName() {
        return "PUBLIC";
    }

    public boolean allowSurrogatesInIdentifierValidation() {
        return true;
    }

    private static void validateIdentifier(String type, String identifier, boolean allowSurrogates) throws InvalidNameException {
        String string = identifier = identifier == null ? "" : identifier;
        if ("DATABASE LINK".equals(type)) {
            OracleDatabaseDescriptor.validateDbLinkName(identifier);
        } else if (!"XML SCHEMA".equals(type)) {
            OracleDatabaseDescriptor.validateIdentifier((String)identifier, (char)'\"', (int)OracleDatabaseDescriptor.getMaxIndentifierLength(type), (String)("FILE_SPECIFICATION".equals(type) ? '.' + ALLOWED_CHARS : ALLOWED_CHARS), (String)String.valueOf('\"'), (boolean)true, (Set)RESERVED_WORDS, (int)2, (boolean)allowSurrogates);
        }
    }

    public static boolean isValidOracleIdentifier(String name, boolean allowSurrogates) {
        try {
            OracleDatabaseDescriptor.validateIdentifier(null, name, allowSurrogates);
        }
        catch (InvalidNameException ine) {
            return false;
        }
        return true;
    }

    public static int getMaxIndentifierLength(String type) {
        return "DATABASE LINK".equals(type) ? 128 : ("JAVA CLASS".equals(type) || "JAVA SOURCE".equals(type) || "JAVA RESOURCE".equals(type) || "XML SCHEMA".equals(type) ? 4000 : ("FILE_SPECIFICATION".equals(type) ? 256 : 30));
    }

    private static void validateDbLinkName(String identifier) throws InvalidNameException {
        boolean isQuotedName;
        String link = identifier.replaceAll("\"", "");
        int linkLength = link.codePointCount(0, link.length());
        if (linkLength < 1) {
            throw new InvalidNameException(null, APIBundle.get((String)"INVALID_IDENTIFIER_NO_NAME"));
        }
        if (linkLength > 128) {
            throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_TOO_LONG", (Object[])new Object[]{identifier}));
        }
        int length = identifier.length();
        boolean bl = isQuotedName = identifier.charAt(0) == '\"' && identifier.indexOf(34, 1) == length - 1;
        if (isQuotedName) {
            identifier = identifier.substring(1, length - 1);
            length = identifier.length();
        }
        int searchFor = identifier.charAt(0) == '\"' ? 34 : 46;
        int startIdx = 0;
        while (startIdx < length) {
            int srchIdx = startIdx + (searchFor == 34 ? 1 : 0);
            int endIdx = identifier.indexOf(searchFor, srchIdx);
            int n = endIdx > -1 ? endIdx + (searchFor == 34 ? 1 : 0) : (endIdx = length);
            if (startIdx == endIdx || endIdx < length && identifier.charAt(endIdx) != '.') {
                throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_MISSING_DB_LINK_COMPONENT", (Object[])new Object[]{identifier}));
            }
            String component = identifier.substring(startIdx, endIdx);
            OracleDatabaseDescriptor.validateDbLinkNameComponent(isQuotedName ? '\"' + component + '\"' : component);
            startIdx = endIdx + 1;
            if (startIdx == length) {
                throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_MISSING_DB_LINK_COMPONENT", (Object[])new Object[]{identifier}));
            }
            if (startIdx >= length) continue;
            searchFor = identifier.charAt(startIdx) == '\"' ? 34 : 46;
        }
    }

    private boolean canEncode(String name) {
        boolean canEncode = true;
        Charset cs = this.getIdeCharset();
        if (cs != null) {
            try {
                CharsetEncoder charsetEncoder = cs.newEncoder();
                if (charsetEncoder != null) {
                    canEncode = charsetEncoder.canEncode(name);
                }
            }
            catch (UnsupportedOperationException uoe) {
                this.getLogger().log(Level.FINE, "Charset " + cs.displayName() + " does not support encoding.");
            }
            catch (IllegalStateException ise) {
                this.getLogger().log(DBLog.getExceptionLogLevel(), "Cannot use encoder to test name", ise);
            }
        }
        return canEncode;
    }

    private static void validateDbLinkNameComponent(String component) throws InvalidNameException {
        boolean isQuoted = component.charAt(0) == '\"' && component.indexOf(34, 1) == component.length() - 1;
        boolean hasIllegalChar = false;
        if (isQuoted) {
            component = component.substring(1, component.length() - 1);
        }
        boolean bl = hasIllegalChar = component.indexOf(34) != -1;
        if (!hasIllegalChar) {
            IntStream codePoints = component.codePoints();
            PrimitiveIterator.OfInt iter = codePoints.iterator();
            while (iter.hasNext()) {
                boolean isAlphaNumeric;
                Integer codePoint = (Integer)iter.next();
                boolean bl2 = isAlphaNumeric = Character.isAlphabetic(codePoint) || Character.isDigit(codePoint);
                if (!Character.isSupplementaryCodePoint(codePoint) && (isAlphaNumeric || ALLOWED_CHARS.indexOf(codePoint) >= 0 || isQuoted && String.valueOf('.').indexOf(codePoint) != -1)) continue;
                hasIllegalChar = true;
                break;
            }
        }
        if (hasIllegalChar) {
            throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_ILLEGAL_CHARACTER", (Object[])new Object[]{component}));
        }
        if (!isQuoted) {
            if (!Character.isAlphabetic(component.codePointAt(0))) {
                throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_NON_ALPHA_START", (Object[])new Object[]{component}));
            }
            if (RESERVED_WORDS.contains(component.toUpperCase())) {
                throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_RESERVED_WORD", (Object[])new Object[]{component.toUpperCase()}));
            }
        }
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider pro) {
        Map<String, DBObjectValidator> v = super.getValidators(pro);
        v.put("COLUMN", new OracleColumnValidator(pro));
        v.put("DataTypeUsage", new OracleDataTypeUsageValidator(pro));
        v.put("TABLE", (DBObjectValidator)new OracleTableValidator(pro));
        v.put("INDEX", (DBObjectValidator)new OracleIndexValidator(pro));
        v.put("CONSTRAINT", new OracleConstraintValidator(pro));
        v.put("SYNONYM", (DBObjectValidator)new SynonymValidator(pro));
        v.put("SEQUENCE", (DBObjectValidator)new SequenceValidator(pro));
        v.put("VIEW", (DBObjectValidator)new ViewValidator(pro));
        v.put("IdentityColumnProperties", new IdentityColumnPropertiesValidator(pro));
        v.put("OracleInMemoryProperties", new InMemoryPropertiesValidator(pro));
        v.put("OracleInMemoryColumnProperties", new InMemoryColumnPropertiesValidator(pro));
        v.put("OracleStorageProperties", new StoragePropertiesValidator(pro));
        if (!OracleLite.class.isAssignableFrom(this.getDatabaseClass())) {
            v.put("MATERIALIZED VIEW", (DBObjectValidator)new MaterializedViewValidator(pro));
            v.put("MATERIALIZED VIEW LOG", (DBObjectValidator)new MaterializedViewLogValidator(pro));
            v.put("XML SCHEMA", (DBObjectValidator)new XMLSchemaValidator(pro));
            v.put("PACKAGE", (DBObjectValidator)new PlSqlValidator(pro));
            v.put("PACKAGE BODY", (DBObjectValidator)new PlSqlValidator(pro, true));
            v.put("PROCEDURE", (DBObjectValidator)new PlSqlValidator(pro));
            v.put("FUNCTION", (DBObjectValidator)new PlSqlValidator(pro));
            v.put("TRIGGER", (DBObjectValidator)new TriggerValidator(pro));
            v.put("TYPE", (DBObjectValidator)new PlSqlValidator(pro));
            v.put("TYPE BODY", (DBObjectValidator)new PlSqlValidator(pro, true));
            v.put("IOT PROPERTIES", new IOTPropertiesValidator(pro));
            v.put("EXTERNAL TABLE PROPERTIES", new ExternalTablePropsValidator(pro));
            v.put("PARTITION MODEL", new TablePartitionsValidator(pro));
            v.put("PARTITION", new TablePartitionValidator(pro));
            v.put("LOB DESCRIPTOR", new LOBDescriptorValidator(pro));
            v.put("INDEX PARTITION MODEL", new IndexPartitionsValidator(pro));
            v.put("INDEX PARTITION", new IndexPartitionValidator(pro));
            v.put("DIRECTORY", (DBObjectValidator)new DirectoryValidator(pro));
            v.put("DATABASE LINK", (DBObjectValidator)new DatabaseLinkValidator(pro));
            v.put("OracleColumnProperties", new OracleColumnPropertiesValidator(pro));
            v.put("XMLTypeColumnProperties", new XMLTypeColumnPropertiesValidator(pro));
            v.put("OracleNestedTableProperties", new NestedTablePropertiesValidator(pro));
            v.put("OracleTableProperties", new OracleTablePropertiesValidator(pro));
        }
        if (Oracle10g.class.isAssignableFrom(this.getDatabaseClass())) {
            v.put("TABLESPACE", new OracleTablespaceValidator(pro));
            v.put("OracleTablespaceProperties", new OracleTablespacePropertiesValidator(pro));
            v.put("FILE_SPECIFICATION", new FileSpecificationValidator(pro));
        }
        return v;
    }

    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        Class dbClz = this.getDatabaseClass();
        OracleDDLGenerator ddlgen = new OracleDDLGenerator(dbClz, this.getDatabaseVersion(), pro);
        if (DBObjectRegistry.isActive()) {
            ddlgen = new DelegateDDLGenerator((DDLGenerator)ddlgen, (DatabaseDescriptor)this, dbClz, pro);
        }
        return ddlgen;
    }

    public Collection<String> listPreferredDataTypeNames() {
        return Arrays.asList("VARCHAR2", "NUMBER", "DATE", "CLOB", "BLOB");
    }

    public SQLQueryBuilderFactory getSQLQueryBuilderFactory() {
        return new OracleSQLQueryBuilderFactory();
    }

    @Override
    public DerivedPropertyBuilder getDerivedPropertyBuilder(Class<? extends AbstractBuildableObject> objClz, DBObjectProvider pro) {
        DerivedPropertyBuilder retval = OracleExternalTableProperties.class.equals(objClz) ? new ExternalTablePropertiesBuilder((AbstractDBObjectProvider)pro) : (BigDataAccessParameter.class.equals(objClz) ? new BigDataAccessParameterBuilder((AbstractDBObjectProvider)pro) : (OracleTablePartitions.class.equals(objClz) ? new ReferencePartitionModelIDBuilder((AbstractDBObjectProvider)pro) : (OracleIndexPartitions.class.equals(objClz) ? new LocalTablePartitionModelIDBuilder((AbstractDBObjectProvider)pro) : super.getDerivedPropertyBuilder(objClz, pro))));
        return retval;
    }

    public PlSqlParserFactory getPlSqlParserFactory(DBObjectProvider pro) {
        return new PlSqlParserFactoryImpl(pro);
    }

    public boolean supportsRowID(DBObjectProvider pro, String objectName) {
        boolean retval = false;
        if (ModelUtil.hasLength((String)objectName)) {
            if (pro instanceof Database) {
                String stmt = "SELECT ROWID FROM " + objectName + " WHERE 1=2";
                StatementWrapper wrap = new StatementWrapper((Database)pro, new String[]{stmt});
                try {
                    wrap.execute();
                    retval = true;
                }
                catch (DBException dbe) {
                    retval = false;
                }
            } else if (pro != null) {
                try {
                    String[] types;
                    Schema schema = null;
                    PlSqlToken tk = PlSqlTokenizer.tokenize((String)objectName, (String[])new String[0]);
                    if (((PlSqlToken)tk.getNextCodeToken()).matches(".")) {
                        schema = pro.getSchema(pro.getInternalName(tk.getSource()));
                        tk = (PlSqlToken)tk.getNextCodeToken(2);
                        objectName = tk.getSource();
                    }
                    objectName = pro.getInternalName(objectName);
                    if (schema == null) {
                        schema = pro.getDefaultSchema();
                    }
                    DBObjectSet done = new DBObjectSet();
                    for (String type : types = new String[]{"TABLE", "VIEW", "MATERIALIZED VIEW", "SYNONYM"}) {
                        SchemaObject obj = pro.getObject(type, schema, objectName);
                        if (!this.supportsRowID(pro, obj, (Set<SchemaObject>)done)) continue;
                        retval = true;
                        break;
                    }
                }
                catch (DBException dbe) {
                    retval = false;
                }
            }
        }
        return retval;
    }

    private boolean supportsRowID(DBObjectProvider pro, SchemaObject obj, Set<SchemaObject> done) throws DBException {
        boolean retval = false;
        if (obj != null) {
            done.add(obj);
            if (obj instanceof Synonym) {
                SchemaObject refobj;
                DBObjectID id = ((Synonym)obj).getReference();
                if (id != null && !done.contains(refobj = (SchemaObject)id.resolveID())) {
                    retval = this.supportsRowID(pro, refobj, done);
                }
            } else if (obj instanceof Table) {
                retval = true;
            } else if (obj instanceof View) {
                View view = (View)obj;
                DBUtil.ensureDerivedPropertiesBuilt((DBObject)view, (DBObjectProvider)pro);
                SQLQuery query = view.getSQLQuery();
                if (query != null && query.isDeclarative()) {
                    boolean bl = retval = query.getGroupByObject() == null && query.getHierarchicalQueryObject() == null && query.getSetOperator() == null;
                    if (retval) {
                        for (SelectObject so : query.getSelectObjects()) {
                            Function func;
                            SQLFragment frag = so.getExpression();
                            if (!(frag instanceof Function) || !(func = (Function)frag).isDistinct() && !func.isGrouping()) continue;
                            retval = false;
                            break;
                        }
                    }
                    if (retval) {
                        // empty if block
                    }
                }
            }
        }
        return retval;
    }

    public boolean isXE() {
        return OracleDatabaseXE.class.isAssignableFrom(this.getDatabaseClass());
    }

    public boolean isCompatibleWith(DatabaseDescriptor other) {
        Class<? extends OracleDatabase> otherClz;
        boolean retval = super.isCompatibleWith(other);
        if (retval && "Oracle Database".equals(this.getDatabaseType()) && OracleDatabaseXE.class.isAssignableFrom(otherClz = OracleDatabaseDescriptor.getDatabaseClass(other.getDatabaseVersion())) && !this.isXE()) {
            retval = false;
        }
        return retval;
    }

    public Collection<String> getReservedWords() {
        return RESERVED_WORDS;
    }

    protected <T extends SystemObject> Collection<T> listBuiltInObjectsImpl(DBObjectCriteria<T> criteria) {
        criteria.setDatabaseDescriptor((DatabaseDescriptor)this);
        Collection retval = super.listBuiltInObjectsImpl(criteria);
        if (this.isXE()) {
            Iterator iter = retval.iterator();
            while (iter.hasNext()) {
                SystemObject obj = (SystemObject)iter.next();
                if (!(obj instanceof Type) || !ORDSYS.equals(DBUtil.getSchemaName((DBObject)obj))) continue;
                iter.remove();
            }
        }
        return retval;
    }

    public DataType getDataType(String typeName) {
        if (typeName.startsWith("TIMESTAMP")) {
            typeName = "TIMESTAMP";
        } else if (typeName.startsWith("INTERVAL YEAR")) {
            typeName = "INTERVAL YEAR";
        } else if (typeName.startsWith("INTERVAL DAY")) {
            typeName = "INTERVAL DAY";
        }
        return super.getDataType(typeName);
    }

    protected void registerDataTypes(DataTypeCache cache) {
        String type = this.getDatabaseType();
        if ("Oracle Database".equals(type)) {
            int version = this.getDatabaseVersion();
            if (version == 120) {
                cache.registerDataType("NVARCHAR2");
                cache.registerDataType("RAW");
                cache.registerDataType("VARCHAR2");
                cache.registerDataTypeSynonym("CHAR VARYING", "VARCHAR2");
                cache.registerDataTypeSynonym("CHARACTER VARYING", "VARCHAR2");
                cache.registerDataTypeSynonym("VARCHAR", "VARCHAR2");
                cache.registerDataTypeSynonym("NATIONAL CHAR VARYING", "NVARCHAR2");
                cache.registerDataTypeSynonym("NATIONAL CHARACTER VARYING", "NVARCHAR2");
                cache.registerDataTypeSynonym("NCHAR VARYING", "NVARCHAR2");
            } else if (version == 100) {
                cache.registerDataType("BINARY_DOUBLE");
                cache.registerDataType("BINARY_FLOAT");
            } else if (version == 92) {
                cache.registerDataType("INTERVAL DAY");
                cache.registerDataType("INTERVAL YEAR");
            } else if (version == 91) {
                cache.registerDataType("CHAR");
                cache.registerDataType("TIMESTAMP");
                cache.registerDataType("VARCHAR2");
                cache.registerDataTypeSynonym("CHARACTER", "CHAR");
                cache.registerDataTypeSynonym("CHAR VARYING", "VARCHAR2");
                cache.registerDataTypeSynonym("CHARACTER VARYING", "VARCHAR2");
                cache.registerDataTypeSynonym("VARCHAR", "VARCHAR2");
            } else if (version == 82) {
                cache.registerDataType("UROWID");
            } else if (version == 81) {
                cache.registerDataType("BFILE");
                cache.registerDataType("BLOB");
                cache.registerDataType("CLOB");
                cache.registerDataType("NCHAR");
                cache.registerDataType("NCLOB");
                cache.registerDataType("NVARCHAR2");
                cache.registerDataTypeSynonym("NATIONAL CHAR", "NCHAR");
                cache.registerDataTypeSynonym("NATIONAL CHAR VARYING", "NVARCHAR2");
                cache.registerDataTypeSynonym("NATIONAL CHARACTER", "NCHAR");
                cache.registerDataTypeSynonym("NATIONAL CHARACTER VARYING", "NVARCHAR2");
                cache.registerDataTypeSynonym("NCHAR VARYING", "NVARCHAR2");
            } else if (version == 0) {
                cache.registerDataType("CHAR");
                cache.registerDataType("DATE");
                cache.registerDataType("DOUBLE PRECISION");
                cache.registerDataType("FLOAT");
                cache.registerDataType("INT");
                cache.registerDataType("INTEGER");
                cache.registerDataType("LONG RAW");
                cache.registerDataType("LONG");
                cache.registerDataType((DataType)new OracleNumberDataType(0));
                cache.registerDataType("RAW");
                cache.registerDataType("REAL");
                cache.registerDataType("ROWID");
                cache.registerDataType("SMALLINT");
                cache.registerDataType("VARCHAR2");
                cache.registerDataTypeSynonym("CHARACTER", "CHAR");
                cache.registerDataTypeSynonym("CHAR VARYING", "VARCHAR2");
                cache.registerDataTypeSynonym("CHARACTER VARYING", "VARCHAR2");
                cache.registerDataTypeSynonym("LONG VARCHAR", "LONG");
                cache.registerDataTypeSynonym("VARCHAR", "VARCHAR2");
                cache.registerDataTypeSynonym("DEC", "NUMBER");
                cache.registerDataTypeSynonym("DECIMAL", "NUMBER");
                cache.registerDataTypeSynonym("NUMERIC", "NUMBER");
            }
        }
    }

    protected void registerBuiltInObjects(BuiltInObjectCache cache) {
        String type = this.getDatabaseType();
        if ("Oracle Database".equals(type)) {
            int version = this.getDatabaseVersion();
            if (version == 110) {
                this.registerComplexTypes(cache, ORDSYS, "ORDDICOM");
                this.registerBuiltInIndextypes(cache, MDSYS, "RTREE_INDEX", "SEM_INDEXTYPE", "SPATIAL_INDEX");
                this.registerBuiltInIndextypes(cache, SYS, "XMLTABLEINDEX");
            } else if (version == 102) {
                this.registerComplexTypes(cache, MDSYS, "SDO_TOPO_GEOMETRY");
            } else if (version == 100) {
                this.registerComplexTypes(cache, MDSYS, "SDO_GEORASTER");
                this.registerComplexTypes(cache, ORDSYS, "SI_AVERAGECOLOR", "SI_COLOR", "SI_COLORHISTOGRAM", "SI_FEATURELIST", "SI_POSITIONALCOLOR", "SI_STILLIMAGE", "SI_TEXTURE");
                this.registerBuiltInIndextypes(cache, EFXSYS, "EXPFILTER");
                this.registerBuiltInIndextypes(cache, XDB, "XDBHI_IDTYP", "XMLINDEX");
            } else if (version == 91) {
                this.registerComplexTypes(cache, SYS, "ANYDATA", "ANYDATASET", "ANYTYPE", "DBURITYPE", "HTTPURITYPE", "URITYPE", "XDBURITYPE", "XMLTYPE");
                this.registerComplexTypes(cache, ORDSYS, "ORDDOC", "ORDIMAGESIGNATURE");
                this.registerComplexTypes(cache, "PUBLIC", "XMLTYPE");
                this.registerBuiltInIndextypes(cache, XDB, "PATH_INDEX", "XDBHI_IDTYP");
            } else if (version == 82) {
                this.registerComplexTypes(cache, ORDSYS, "ORDIMAGE", "ORDAUDIO", "ORDVIDEO", "ORDSOURCE");
                this.registerComplexTypes(cache, MDSYS, "SDO_GEOMETRY", "SDO_ORDINATE_ARRAY", "SDO_ELEM_INFO_ARRAY", "SDO_POINT_TYPE");
                this.registerBuiltInIndextypes(cache, CTXSYS, "CONTEXT", "CTXCAT", "CTXRULE", "CTXPATH");
                this.registerBuiltInIndextypes(cache, ORDSYS, "ORDIMAGEINDEX");
                this.registerBuiltInIndextypes(cache, MDSYS, "SPATIAL_INDEX", "RTREE_INDEX");
            }
        }
    }

    private void registerBuiltInIndextypes(BuiltInObjectCache cache, String schemaName, String ... indextypeNames) {
        if (indextypeNames != null) {
            Schema schema = new Schema(schemaName);
            for (int i = 0; i < indextypeNames.length; ++i) {
                Indextype it = new Indextype(indextypeNames[i], schema);
                cache.registerBuiltInObject((SystemObject)it);
            }
        }
    }

    private void registerComplexTypes(BuiltInObjectCache cache, String schemaName, String ... typeNames) {
        if (typeNames != null) {
            for (String typeName : typeNames) {
                cache.registerBuiltInObject("TYPE", schemaName, typeName);
            }
        }
    }

    @Override
    public SqlAliasExpander getSqlAliasExpander(DBObjectProvider pro, Schema defaultSchema) {
        if ("Y".equals(System.getProperty("oracle.javatools.db.ora.sql.SqlUsageUtil"))) {
            return new SqlUsageUtil();
        }
        return super.getSqlAliasExpander(pro, defaultSchema);
    }

    public DBObjectLister getTriggerLister(DBObjectProvider pro) {
        if (pro instanceof OracleDatabaseImpl) {
            return new OracleTriggerLister((OracleDatabaseImpl)pro);
        }
        return super.getTriggerLister(pro);
    }

    protected void initialiseDefaultSourceOptions(DefaultSourceOptions opts) {
        opts.setUseCreateOrReplace(true);
        opts.setIncludeTerminators(false);
        opts.setEnableTriggers(true);
    }

    public String getBuiltInFunctionDescription(BuiltInFunction bif) {
        String desc;
        try {
            desc = OracleFunctionsBundle.get(bif.getName());
        }
        catch (MissingResourceException e) {
            desc = null;
        }
        return desc;
    }

    public static int getDatabaseVersion(Class<? extends OracleDatabase> clz) {
        return OracleDatabaseFactory.getDatabaseVersion(clz);
    }

    private static Class<? extends OracleDatabase> getDatabaseClass(int version) {
        return OracleDatabaseFactory.getDatabaseClass(version);
    }

    private static class OracleTriggerLister
    extends DBObjectLister {
        protected OracleTriggerLister(OracleDatabaseImpl database) {
            super((DBObjectProvider)database);
        }

        private OracleDatabaseImpl getDatabase() {
            return (OracleDatabaseImpl)this.getProvider();
        }

        public Collection<DBObjectLister.ObjectInfo> listObjects(DBObjectCriteria criteria) throws DBException {
            final HashSet<DBObjectLister.ObjectInfo> retval = new HashSet<DBObjectLister.ObjectInfo>();
            Collection types = criteria.getTypes();
            if (types.size() != 1 || !types.contains("TABLE") && !types.contains("VIEW") && !types.contains("SCHEMA")) {
                throw new IllegalArgumentException("Criteria for just one of TABLE, VIEW or SCHEMA expected");
            }
            final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)null, "SELECT  /*OracleDictionaryQueries.ALL_TRIGGERS_FOR_BASE_OBJECT_QUERY*/\n       O.OBJECT_TYPE, T.OWNER, T.TRIGGER_NAME, O.OBJECT_ID\nFROM   SYS.ALL_TRIGGERS T\n,      SYS.ALL_OBJECTS O\nWHERE  T.BASE_OBJECT_TYPE = ?\nAND    ( T.TABLE_OWNER = ? OR T.BASE_OBJECT_TYPE = 'DATABASE' )\nAND    ( ( T.BASE_OBJECT_TYPE IN ( 'TABLE','VIEW') AND T.TABLE_NAME LIKE ? ) OR\n         ( T.BASE_OBJECT_TYPE IN ( 'SCHEMA','DATABASE') AND T.TABLE_NAME IS NULL ) \n       )\nAND    O.OBJECT_TYPE = 'TRIGGER'\nAND    O.OWNER = T.OWNER\nAND    O.OBJECT_NAME = T.TRIGGER_NAME", types.toArray()[0], criteria.getSchemaName(), criteria.getNameLike());
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet curs) throws DBException {
                    try {
                        while (curs.next()) {
                            String type = curs.getString(1);
                            Schema schema = this.getDatabase().getSchema(curs.getString(2));
                            String name = curs.getString(3);
                            BigInteger id = new BigInteger(curs.getString(4));
                            retval.add(new DBObjectLister.ObjectInfo(type, schema, name, (Object)id));
                        }
                    }
                    catch (SQLException e) {
                        wrap.throwDBException(e);
                    }
                }
            };
            wrap.executeQuery(r);
            return retval;
        }
    }
}

