/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.compilation.CompilationErrorInfo;
import oracle.javatools.db.compilation.CompilationResults;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.execute.PlSqlWrapper;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.Indextype;
import oracle.javatools.db.ora.IndextypeBuilder;
import oracle.javatools.db.ora.OracleTriggerBuilder;
import oracle.javatools.db.ora.PlSqlSourceBuilder;
import oracle.javatools.db.plsql.PlSqlCompilerOptions;
import oracle.javatools.db.plsql.PlSqlIdentifier;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.plsql.parser.PlSqlParserFactory;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.InvalidSQLException;
import oracle.javatools.db.util.DBObjectIDMap;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;
import oracle.jdbc.OracleConnection;

public class OracleDatabaseImpl
extends BaseOracleDatabase {
    protected static final String CTXSYS = "CTXSYS";
    protected static final String EFXSYS = "EFXSYS";
    protected static final String MDSYS = "MDSYS";
    protected static final String ORDSYS = "ORDSYS";
    protected static final String SYS = "SYS";
    protected static final String XDB = "XDB";
    private static final Map<String, MultiMap<String, Indextype>> s_builtinIndextypes = new HashMap<String, MultiMap<String, Indextype>>();
    private final Map<DBObjectID, Collection<String>> m_objPrivMap = new DBObjectIDMap(true);
    private static final String ERRORS_QUERY = "SELECT /*OracleDatabaseImpl.ALL_ERRORS_QUERY*/\n       A.OWNER, A.TYPE, A.NAME,        A.LINE, A.POSITION, REPLACE(A.TEXT, CHR(10), ' ') TEXT, 'ERROR' ATTRIBUTE FROM SYS.ALL_ERRORS A WHERE A.NAME = ? AND A.TYPE = ? AND A.OWNER = ? ";
    private static final String ERRORS_QUERY_10G = "SELECT /*OracleDatabaseImpl.ALL_ERRORS_QUERY_10G*/\n       A.OWNER, A.TYPE, A.NAME,        A.LINE, A.POSITION, REPLACE(A.TEXT, CHR(10), ' ') TEXT, A.ATTRIBUTE FROM SYS.ALL_ERRORS A WHERE A.NAME = ? AND A.TYPE = ? AND A.OWNER = ? ";
    private static final String SET_WARNINGS_FLAG = "BEGIN /*OracleDatabaseImpl.ALL_SET_WARNINGS_FLAG*/\n       DBMS_WARNING.ADD_WARNING_SETTING_CAT( ?, ? , ? ); END;";
    private static final String ENABLE_DEBUG = "ALTER /*OracleDatabaseImpl.ALL_ENABLE_DEBUG*/\n       SESSION SET PLSQL_DEBUG = TRUE";
    private static final String DISABLE_DEBUG = "ALTER /*OracleDatabaseImpl.ALL_DISABLE_DEBUG*/\n       SESSION SET PLSQL_DEBUG = FALSE";
    private static final String TEST_SQL_STMT = "declare cols integer; cid  integer; tab dbms_sql.desc_tab;begin cid := dbms_sql.open_cursor; dbms_sql.parse(cid,?,dbms_sql.native); dbms_sql.describe_columns(cid,cols,tab); dbms_sql.close_cursor(cid);exception when others then ? := dbms_sql.last_error_position; ? := sqlerrm; dbms_sql.close_cursor(cid);end;";
    private static String s_api_version = null;
    private Boolean m_partitioning;
    private Boolean m_debugInfo;
    private String m_compatibleLevel;

    OracleDatabaseImpl(String storeName, String connName, Connection conn, int version) {
        super(storeName, connName, conn, "Oracle Database", version);
    }

    protected Boolean isConnectionClosedImpl(SQLException sqe, Connection conn) {
        int errorCode;
        Boolean retval = this.implementsInterface(conn, "oracle.ucp.jdbc.ValidConnection") ? Boolean.valueOf(sqe != null && sqe.getErrorCode() == 31) : (conn instanceof OracleConnection && !this.implementsInterface(conn, "weblogic.jdbc.extensions.WLConnection") ? (sqe == null ? Boolean.valueOf(false) : Boolean.valueOf((errorCode = sqe.getErrorCode()) == 17008 || errorCode == 2396 || errorCode == 2399 || errorCode == 1012)) : super.isConnectionClosedImpl(sqe, conn));
        return retval;
    }

    private boolean implementsInterface(Connection conn, String iface) {
        boolean retval = false;
        block0: for (Class<?> clz = conn.getClass(); clz != null; clz = clz.getSuperclass()) {
            for (Class<?> ifc : clz.getInterfaces()) {
                if (!ifc.getName().equals(iface)) continue;
                retval = true;
                break block0;
            }
        }
        return retval;
    }

    @Override
    public void clearAllCaches() {
        super.clearAllCaches();
        this.m_partitioning = null;
        this.m_debugInfo = null;
    }

    protected void reconnected(Connection c) {
        super.reconnected(c);
        this.setSQLTraceOnIfReqd(c);
    }

    public boolean supportsJava() {
        return false;
    }

    public boolean hasObjectPrivilege(SystemObject object, String priv) {
        if (object != null && priv != null) {
            String schemaName;
            Schema schema;
            if (object instanceof SchemaObject) {
                schema = ((SchemaObject)object).getSchema();
                schemaName = schema == null ? null : schema.getName();
            } else {
                schema = null;
                schemaName = SYS;
            }
            if (this.hasSystemPrivilege(object.getType(), schema, priv)) {
                return true;
            }
            Collection<String> cachedPrivs = this.m_objPrivMap.get(object.getID());
            if (cachedPrivs == null) {
                final ArrayList<String> privs = new ArrayList<String>();
                cachedPrivs = privs;
                this.m_objPrivMap.put(object.getID(), cachedPrivs);
                final QueryWrapper privsWrap = this.newQueryWrapper(object, "SELECT /*OracleDictionaryQueries.OBJECT_ALTER_CHECK*/ \n       PRIVILEGE \nFROM SYS.ALL_TAB_PRIVS\nWHERE TABLE_SCHEMA = ?\nAND TABLE_NAME = ?\nAND GRANTEE IN (SELECT USER FROM SYS.DUAL\n                UNION ALL\n                SELECT 'PUBLIC' FROM SYS.DUAL\n                UNION ALL\n                SELECT ROLE FROM SYS.SESSION_ROLES)", schemaName, object.getName());
                QueryWrapper.QueryRunnable privsRun = new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet rs) throws DBException {
                        try {
                            while (rs.next()) {
                                privs.add(rs.getString(1));
                            }
                        }
                        catch (SQLException ex) {
                            privsWrap.throwDBException(ex);
                        }
                    }
                };
                try {
                    privsWrap.executeQuery(privsRun);
                }
                catch (DBException dbe) {
                    this.getLogger().warning(APIBundle.format((String)"PRIVS_LOAD_ERR", (Object[])new Object[]{this.getConnectionName(), dbe.getMessage()}));
                }
            }
            String privToCheck = "MODIFY".equals(priv) ? "ALTER" : priv;
            return cachedPrivs.contains(privToCheck);
        }
        return false;
    }

    public boolean supportsPartitioning() {
        if (this.m_partitioning == null) {
            QueryWrapper wrap = this.newQueryWrapper(null, "SELECT /*OracleDictionaryQueries.ALL_PARTITIONING_QUERY*/\n       VALUE FROM V$OPTION WHERE PARAMETER='Partitioning'", new Object[0]);
            try {
                this.m_partitioning = Boolean.valueOf(wrap.executeSingleCellQuery());
            }
            catch (DBException dbe) {
                this.getLogger().warning(APIBundle.format((String)"PARTITION_CHECK_ERR", (Object[])new Object[]{this.getConnectionName(), dbe.getMessage()}));
                if (dbe instanceof CancelledException) {
                    return false;
                }
                this.m_partitioning = Boolean.FALSE;
            }
        }
        return this.m_partitioning;
    }

    public String getCompatibleLevel() {
        block3: {
            if (this.m_compatibleLevel == null) {
                QueryWrapper wrap = this.newQueryWrapper(null, "SELECT /*OracleDictionaryQueries.COMPATIBILITY_QUERY*/ value FROM database_compatible_level", new Object[0]);
                try {
                    this.m_compatibleLevel = wrap.executeSingleCellQuery();
                }
                catch (DBException dbe) {
                    this.getLogger().warning(APIBundle.format((String)"COMPATIBLE_LEVEL_ERR", (Object[])new Object[]{this.getConnectionName(), dbe.getMessage()}));
                    if (dbe instanceof CancelledException) break block3;
                    this.m_compatibleLevel = "";
                }
            }
        }
        return this.m_compatibleLevel;
    }

    @Deprecated
    public final String getNLSSessionValue(String parameter) {
        return this.getSessionParameterValue(parameter);
    }

    @Override
    protected void registerBuilders() {
        super.registerBuilders();
        this.registerBuilder("TRIGGER", (DBObjectBuilder)new OracleTriggerBuilder(this));
        this.registerBuilder("FUNCTION", (DBObjectBuilder)new PlSqlSourceBuilder(this, "FUNCTION"));
        this.registerBuilder("PROCEDURE", (DBObjectBuilder)new PlSqlSourceBuilder(this, "PROCEDURE"));
        this.registerBuilder("PACKAGE", (DBObjectBuilder)new PlSqlSourceBuilder(this, "PACKAGE"));
        this.registerBuilder("PACKAGE BODY", (DBObjectBuilder)new PlSqlSourceBuilder(this, "PACKAGE BODY"));
        this.registerBuilder("INDEXTYPE", (DBObjectBuilder)new IndextypeBuilder(this));
    }

    protected boolean hasRole(String role) {
        boolean retval;
        block4: {
            retval = false;
            if (role != null) {
                try {
                    String[] cachedRoles;
                    Schema currSchema = this.getSchema(this.getUserName());
                    if (currSchema == null || (cachedRoles = (String[])currSchema.getProperty("USER_ROLES")) == null) break block4;
                    for (String cachedRole : cachedRoles) {
                        if (!role.equals(cachedRole)) continue;
                        retval = true;
                        break;
                    }
                }
                catch (DBException dbe) {
                    this.getLogger().warning(APIBundle.format((String)"PRIVS_LOAD_ERR", (Object[])new Object[]{this.getConnectionName(), dbe.getMessage()}));
                }
            }
        }
        return retval;
    }

    protected boolean hasPrivilege(String priv) {
        boolean retval;
        block4: {
            retval = false;
            if (priv != null) {
                try {
                    String[] cachedPrivs;
                    Schema currSchema = this.getSchema(this.getUserName());
                    if (currSchema == null || (cachedPrivs = (String[])currSchema.getProperty("USER_PRIVS")) == null) break block4;
                    for (String cachePriv : cachedPrivs) {
                        if (!priv.equals(cachePriv)) continue;
                        retval = true;
                        break;
                    }
                }
                catch (DBException dbe) {
                    this.getLogger().warning(APIBundle.format((String)"PRIVS_LOAD_ERR", (Object[])new Object[]{this.getConnectionName(), dbe.getMessage()}));
                }
            }
        }
        return retval;
    }

    protected boolean isConnectionAliveImpl(Connection conn) throws SQLException, DBException {
        boolean retval;
        OracleConnection oc = this.getOracleConnection(conn);
        if (oc != null) {
            try {
                int ping = oc.pingDatabase();
                retval = ping == 0;
            }
            catch (SQLException sqe) {
                retval = false;
            }
        } else {
            retval = super.isConnectionAliveImpl(conn);
        }
        return retval;
    }

    private OracleConnection getOracleConnection(Connection conn) {
        OracleConnection retval = null;
        if (conn instanceof OracleConnection) {
            retval = (OracleConnection)conn;
        } else {
            try {
                if (conn.isWrapperFor(OracleConnection.class)) {
                    retval = conn.unwrap(OracleConnection.class);
                }
            }
            catch (Throwable t) {
                retval = null;
            }
        }
        return retval;
    }

    public CompilationResults submitDatabaseSource(String schemaName, String source) {
        ArrayList<String> sources = new ArrayList<String>();
        sources.add(source);
        return this.submitDatabaseSources(schemaName, sources).get(0);
    }

    public List<CompilationResults> submitDatabaseSources(String schemaName, List<String> sources) {
        int i;
        ArrayList<CompilationResults> results = new ArrayList();
        ArrayList<PlSqlIdentifier> ids = new ArrayList<PlSqlIdentifier>();
        CompilationResults[] failedSubmits = new CompilationResults[sources.size()];
        this.setCompilerOptions();
        PlSqlParserFactory fac = this.getDescriptor().getPlSqlParserFactory((DBObjectProvider)this);
        String requiredSchema = this.getUserName();
        if (ModelUtil.hasLength((String)schemaName)) {
            requiredSchema = schemaName;
        }
        for (i = 0; i < sources.size(); ++i) {
            try {
                CancelledException.checkInterrupt();
                String source = sources.get(i);
                PlSqlParser parser = fac.createParser(source);
                PlSqlToken nameToken = parser.getNameToken();
                String name = nameToken == null ? null : this.getInternalName(nameToken.getSource());
                PlSqlToken schemaToken = parser.getSchemaToken();
                String schemaInSource = schemaToken == null ? null : this.getInternalName(schemaToken.getSource());
                if (ModelUtil.hasLength(schemaInSource) && ModelUtil.areDifferent((Object)requiredSchema, (Object)schemaInSource) || !ModelUtil.hasLength((String)schemaInSource) && ModelUtil.areDifferent((Object)requiredSchema, (Object)this.getUserName())) {
                    int start = schemaToken == null ? nameToken.getStart() : schemaToken.getStart();
                    int end = nameToken.getEnd();
                    StringBuilder sb = new StringBuilder(source);
                    sb.replace(start, end + 1, this.getExternalName(requiredSchema) + "." + this.getExternalName(name));
                    source = sb.toString();
                    parser = fac.createParser(source);
                }
                source = "CREATE OR REPLACE\n" + source.substring(parser.getStartOffsetOfObject(), parser.getEndOffsetOfObject() + 1);
                PlSqlIdentifier id = PlSqlIdentifier.getPlSqlIdentifier((String)source, (String)requiredSchema, (boolean)true);
                ids.add(id);
                StatementWrapper wrap = new StatementWrapper((Database)this, new String[]{source});
                wrap.execute();
                continue;
            }
            catch (DBException e) {
                CompilationResults cr = new CompilationResults();
                cr.setSubmitFailed(true);
                cr.addError(new CompilationErrorInfo(1, 1, e.getMessage()));
                failedSubmits[i] = cr;
            }
        }
        results = this.getCompilationResults(ids);
        for (i = 0; i < sources.size(); ++i) {
            if (failedSubmits[i] == null) continue;
            results.remove(i);
            results.add(i, failedSubmits[i]);
        }
        return results;
    }

    public void setCompilerOptions() {
        Boolean debugInfo;
        GlobalSettings settings = GlobalSettings.getInstance();
        PlSqlCompilerOptions opts = settings == null ? null : settings.getPlSqlCompilerOptions();
        Boolean bl = debugInfo = opts == null ? Boolean.FALSE : Boolean.valueOf(opts.isGeneratePlSqlDebugInfo());
        if (ModelUtil.areDifferent((Object)this.m_debugInfo, (Object)debugInfo)) {
            this.m_debugInfo = debugInfo;
            this.generateDebugInfo();
        }
        this.setWarningFlags(opts);
    }

    private void generateDebugInfo() {
        try {
            StatementWrapper w = new StatementWrapper((Database)this, new String[]{this.m_debugInfo != false ? ENABLE_DEBUG : DISABLE_DEBUG});
            w.execute();
        }
        catch (DBException e) {
            this.getLogger().warning(e.getMessage());
        }
    }

    private void setWarningFlags(PlSqlCompilerOptions opts) {
        if (this.getDatabaseVersion() >= 100 && opts != null) {
            for (PlSqlCompilerOptions.WarningCategory category : PlSqlCompilerOptions.WarningCategory.values()) {
                PlSqlCompilerOptions.WarningValue value = opts.getWarningValue(category);
                if (value == null) continue;
                try {
                    PlSqlWrapper w = new PlSqlWrapper((Database)this, SET_WARNINGS_FLAG, new Object[]{category.name(), value.name(), "SESSION"});
                    w.executePlSql(new PlSqlWrapper.PlSqlRunnable(){});
                }
                catch (DBException e) {
                    this.getLogger().warning(e.getMessage());
                }
            }
        }
    }

    private String getErrorQuery() {
        return this.getDatabaseVersion() >= 100 ? ERRORS_QUERY_10G : ERRORS_QUERY;
    }

    public void testSQLStatement(final String sql) throws DBException {
        PlSqlWrapper wrap = new PlSqlWrapper((Database)this, TEST_SQL_STMT, new Object[]{sql});
        wrap.executePlSql(new PlSqlWrapper.PlSqlRunnable(){

            public void prepareCall(CallableStatement cs) throws SQLException, DBException {
                cs.registerOutParameter(2, 4);
                cs.registerOutParameter(3, 12);
            }

            public void processCall(CallableStatement cs) throws SQLException, DBException {
                int errorPosition = cs.getInt(2);
                String errorMessage = cs.getString(3);
                if (errorPosition > 0) {
                    throw new InvalidSQLException(sql, errorMessage, Integer.valueOf(errorPosition));
                }
            }
        });
    }

    public List<CompilationResults> getCompilationResults(List<PlSqlIdentifier> plsqlIds) {
        ArrayList<CompilationResults> retval;
        block5: {
            retval = new ArrayList<CompilationResults>();
            final HashMap<PlSqlIdentifier, CompilationResults> map = new HashMap<PlSqlIdentifier, CompilationResults>();
            ArrayList<QueryWrapper> wrappers = new ArrayList<QueryWrapper>();
            for (PlSqlIdentifier plsqlID : plsqlIds) {
                QueryWrapper wrap = new QueryWrapper((Database)this, this.getErrorQuery(), new Object[]{plsqlID.getName(), plsqlID.getPlsqlType() == null ? null : plsqlID.getPlsqlType().toString(), plsqlID.getSchemaName()});
                wrappers.add(wrap);
                map.put(plsqlID, new CompilationResults());
            }
            try {
                CancelledException.checkInterrupt();
                if (wrappers.size() <= 0) break block5;
                final QueryWrapper wrap = QueryWrapper.union((QueryWrapper[])wrappers.toArray(new QueryWrapper[wrappers.size()]));
                QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet rs) throws DBException {
                        try {
                            while (rs.next()) {
                                String schema = rs.getString("OWNER");
                                String type = rs.getString("TYPE");
                                String name = rs.getString("NAME");
                                PlSqlIdentifier id = new PlSqlIdentifier(name, schema, PlSqlIdentifier.PlSqlType.valueOf((String)type.replaceAll(" ", "_")));
                                CompilationResults cr = (CompilationResults)map.get(id);
                                CompilationErrorInfo info = new CompilationErrorInfo(rs.getInt("LINE"), rs.getInt("POSITION"), rs.getString("TEXT"), "WARNING".equals(rs.getString("ATTRIBUTE")));
                                cr.addError(info);
                            }
                        }
                        catch (SQLException ex) {
                            wrap.throwDBException(ex);
                        }
                    }
                };
                wrap.executeQuery(r);
                for (PlSqlIdentifier plsqlID : plsqlIds) {
                    retval.add((CompilationResults)map.get(plsqlID));
                }
            }
            catch (DBException e) {
                for (PlSqlIdentifier plsqlID : plsqlIds) {
                    CompilationResults cr = new CompilationResults(plsqlID.getName(), plsqlID.getPlsqlType().toString());
                    cr.setSubmitFailed(true);
                    cr.addError(new CompilationErrorInfo(1, 1, e.getMessage()));
                }
            }
        }
        return retval;
    }

    protected String queryCurrentSchemaName() throws DBException {
        String retval = null;
        if (this.getConnection() instanceof OracleConnection) {
            ConnectionWrapper wrap = new ConnectionWrapper((Database)this, APIBundle.get((String)"GET_CURR_SCHEMA"));
            ConnectionWrapper.SQLCallable<String> callable = new ConnectionWrapper.SQLCallable<String>(wrap){

                public String call() throws SQLException {
                    return ((OracleConnection)this.getConnection()).getCurrentSchema();
                }
            };
            retval = (String)wrap.call((ConnectionWrapper.SQLCallable)callable);
        }
        return retval;
    }

    public Database createStandaloneDatabase(Schema schema) throws DBException {
        StatementWrapper wrap;
        Connection c;
        Database retval = null;
        if (schema != null && (c = this.createDuplicateConnection()) != null && (wrap = new StatementWrapper(this.getConnectionName(), c, new String[]{"ALTER SESSION SET current_schema = " + this.getExternalName(schema.getName(), "SCHEMA")})).execute()) {
            retval = DatabaseFactory.createStandaloneDatabase((String)this.getConnectionName(), (Connection)c);
        }
        return retval;
    }

    static Collection<String> listBuiltInIndextypeSchemas(Class providerClass) {
        HashSet<String> schemas = new HashSet<String>();
        while (providerClass != null && !providerClass.equals(Object.class)) {
            Map indextypeMap = (Map)s_builtinIndextypes.get(providerClass.getName());
            if (indextypeMap != null) {
                schemas.addAll(indextypeMap.keySet());
            }
            providerClass = providerClass.getSuperclass();
        }
        return schemas;
    }

    static Collection<Indextype> listBuiltInIndextypes(Class providerClass, String schemaName) {
        Collection retval = null;
        while (providerClass != null && !providerClass.equals(Object.class)) {
            Collection indextypes;
            Map indextypeMap = (Map)s_builtinIndextypes.get(providerClass.getName());
            if (indextypeMap != null && (indextypes = (Collection)indextypeMap.get(schemaName)) != null) {
                retval = indextypes;
            }
            providerClass = providerClass.getSuperclass();
        }
        return retval == null ? Collections.emptyList() : retval;
    }

    static void registerBuiltInIndextypes(Class providerClass, String schemaName, String ... indextypeNames) {
        if (indextypeNames != null) {
            MultiMap indextypeMap = s_builtinIndextypes.get(providerClass.getName());
            if (indextypeMap == null) {
                indextypeMap = new MultiMap();
                s_builtinIndextypes.put(providerClass.getName(), (MultiMap<String, Indextype>)indextypeMap);
            }
            Schema schema = new Schema(schemaName);
            for (int i = 0; i < indextypeNames.length; ++i) {
                Indextype it = new Indextype(indextypeNames[i], schema);
                it.setID((DBObjectID)new ReferenceID((DBObject)it));
                indextypeMap.add((Object)schemaName, (Object)it);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAPIVersionForSQLTrace() {
        String ade_view_root;
        if (s_api_version == null && ModelUtil.hasLength((String)(ade_view_root = System.getenv("ADE_VIEW_ROOT")))) {
            FileReader fr = null;
            try {
                fr = new FileReader(ade_view_root + "/ade_info.vmd");
            }
            catch (FileNotFoundException e) {
                return null;
            }
            try {
                String record = null;
                try (BufferedReader br = new BufferedReader(fr);){
                    while ((record = br.readLine()) != null) {
                        if (record.startsWith("VIEW_LABEL")) {
                            s_api_version = record.substring(record.indexOf(" ")).trim();
                        }
                        if (!record.startsWith("VIEW_TRANS_NAME")) continue;
                        String txn = record.substring(record.indexOf(" ")).trim();
                        if (ModelUtil.areDifferent((Object)txn, (Object)"NONE")) {
                            s_api_version = s_api_version + "/" + txn;
                        }
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return s_api_version;
    }

    public static void setAPIVersionForSQLTrace(String v) {
        s_api_version = v;
    }

    private void setSQLTraceOnIfReqd(Connection c) {
        String dbSqlTraceProp = System.getProperty("db-sqltrace");
        if (ModelUtil.hasLength((String)dbSqlTraceProp)) {
            String[] actualConnParts = new String[]{};
            if (c instanceof OracleConnection) {
                Properties p = ((OracleConnection)c).getProperties();
                String s = (String)p.get("database") + ":" + ((String)p.get("user")).toLowerCase();
                actualConnParts = s.split(":");
            }
            String[] propParts = dbSqlTraceProp.split(",");
            boolean doThisConnection = false;
            String activity = null;
            block4: for (int i = 0; i < propParts.length && !doThisConnection; ++i) {
                int j;
                String[] propSubParts = propParts[i].split(":");
                activity = propSubParts[0];
                String[] propConnParts = new String[4];
                for (j = 0; j < propSubParts.length - 1 && j < propConnParts.length; ++j) {
                    propConnParts[j] = propSubParts[j + 1];
                }
                while (j < 4) {
                    propConnParts[j] = "";
                    ++j;
                }
                propConnParts[3] = propConnParts[3].toLowerCase();
                doThisConnection = true;
                for (j = 0; j < actualConnParts.length && j < 4; ++j) {
                    if (propConnParts[j].equals("")) continue;
                    if (j == 0) {
                        String shorter = propConnParts[j].length() > actualConnParts[j].length() ? actualConnParts[j] : propConnParts[j];
                        String longer = propConnParts[j].length() > actualConnParts[j].length() ? propConnParts[j] : actualConnParts[j];
                        shorter = shorter + '.';
                        if ((longer = longer + '.').startsWith(shorter)) continue;
                        doThisConnection = false;
                        continue block4;
                    }
                    if (propConnParts[j].equals(actualConnParts[j])) continue;
                    doThisConnection = false;
                    continue block4;
                }
            }
            if (doThisConnection) {
                StatementWrapper x = new StatementWrapper((Database)this, new String[]{"ALTER SESSION SET SQL_TRACE=TRUE"});
                try {
                    x.execute();
                }
                catch (DBException propSubParts) {
                    // empty catch block
                }
                String query = "SELECT /* :DB-API:" + this.getUserName() + ":" + activity + ":" + OracleDatabaseImpl.getAPIVersionForSQLTrace() + ":" + " */ 1 FROM SYS.DUAL";
                QueryWrapper y = new QueryWrapper((Database)this, query);
                try {
                    QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                        public void processResultSet(ResultSet rs) throws DBException {
                        }
                    };
                    y.executeQuery(r);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
        }
    }
}

