/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.NumericDataType;

public class OracleNumberDataType
extends NumericDataType {
    private static final NumericDataType.MinMaxValue MIN_MAX_FLOAT = new NumericDataType.MinMaxValue("1.0e-130", "9.9999999999999999999999999999999999999e+125", NumericDataType.MinMaxValue.FLOAT);

    public OracleNumberDataType() {
        this(65535);
    }

    public OracleNumberDataType(int domain) {
        super(domain, "NUMBER", "NUMBER[(<precision>[, <scale>])]", new DataTypeAttribute[]{new DataTypeAttribute("precision", "DATATYPE_ATTRIBUTE_LABEL_PRECISION", null, null, true, false), new DataTypeAttribute("scale", "DATATYPE_ATTRIBUTE_LABEL_SCALE", -84L, Long.valueOf(127L), Long.valueOf(0L), false)}, MIN_MAX_FLOAT);
        this.setSQLType(2);
    }

    public String getDDL(DataTypeUsage dataTypeUsage) {
        String ddl = this.getName();
        String precision = DataTypeHelper.getStringAttributeValue((DataTypeUsage)dataTypeUsage, (String)"precision");
        Long scale = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"scale");
        if (precision != null) {
            ddl = ddl + '(' + precision + (scale == null ? "" : ", " + scale) + ')';
        } else if (scale != null) {
            ddl = ddl + "(*, " + scale + ')';
        }
        return ddl;
    }
}

