/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableBuilder;

class OracleStoragePropertiesBuilder
extends OracleDBObjectBuilder<OracleStorageProperties> {
    private final String m_query;
    private final Object[] m_queryParams;

    public OracleStoragePropertiesBuilder(BaseOracleDatabase db, String query, Object ... queryParams) {
        super(db, "OracleStorageProperties");
        this.m_query = query;
        this.m_queryParams = queryParams;
    }

    protected void fillInObject(final OracleStorageProperties props) throws DBException {
        SystemObject par = DBUtil.getSystemObject((DBObject)props);
        if (par != null) {
            QueryWrapper wrap = this.getDatabase().newQueryWrapper(par, this.m_query, this.m_queryParams);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException, SQLException {
                    if (rs.next()) {
                        OracleTableBuilder.populateSegmentAttributes(props, rs, OracleStoragePropertiesBuilder.this.getDatabase());
                    }
                }
            };
            wrap.executeQuery(r);
        }
    }
}

