/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnSequenceProcessor;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleColumnPropertiesBuilder;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDictionaryQueries;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleInMemoryColumnProperties;
import oracle.javatools.db.ora.OracleInMemoryProperties;
import oracle.javatools.db.ora.OracleIndexBuilder;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleRelationBuilder;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleStoragePropertiesBuilder;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.OracleTablePartitionsBuilder;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.ora.OracleTablespaceUtil;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class OracleTableBuilder<T extends Table>
extends OracleRelationBuilder<T> {
    public static final BigInteger MAXEXTENTS_UNLIMITED = BigInteger.valueOf(0x7FFFFFFDL);
    private static final String ENABLED = "ENABLED";
    private static final String DIRECT_LOAD_OPERATIONS = "DIRECT LOAD ONLY";
    private static final String ALL_OPERATIONS = "FOR ALL OPERATIONS";
    private static final String OLTP = "OLTP";
    private static final String BASIC = "BASIC";
    private static final String ADVANCED = "ADVANCED";
    private static final String QUERY_LOW = "QUERY LOW";
    private static final String QUERY_HIGH = "QUERY HIGH";
    private static final String ARCHIVE_LOW = "ARCHIVE LOW";
    private static final String ARCHIVE_HIGH = "ARCHIVE HIGH";
    private static final String ROW_LEVEL_LOCKING = "ROW LEVEL LOCKING";
    private static final String QUERY_LOW_ROW_LEVEL_LOCKING = "QUERY LOW ROW LEVEL LOCKING";
    private static final String QUERY_HIGH_ROW_LEVEL_LOCKING = "QUERY HIGH ROW LEVEL LOCKING";
    private static final String ARCHIVE_LOW_ROW_LEVEL_LOCKING = "ARCHIVE LOW ROW LEVEL LOCKING";
    private static final String ARCHIVE_HIGH_ROW_LEVEL_LOCKING = "ARCHIVE HIGH ROW LEVEL LOCKING";

    protected OracleTableBuilder(BaseOracleDatabase db) {
        this(db, "TABLE");
    }

    protected OracleTableBuilder(BaseOracleDatabase db, String type) {
        super(db, type);
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"indexes"}, depends={"TableType", "constraints"})
    public void fillInIndexes(T table) throws DBException {
        OracleIndexBuilder ib = (OracleIndexBuilder)this.getDatabase().getBuilderForType("INDEX");
        ib.fillInIndexes((Table)table);
        this.updateTimestamp((AbstractBuildableObject)table, true);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"TableType", "NESTED TABLE", "OBJECT TABLE", "PARTITIONED TABLE"})
    public void fillInTableType(T table) throws DBException {
        String query = this.getTableTypeQuery();
        if (query == null) {
            table.setProperty("TableType", (Object)Table.TableType.NORMAL);
            table.setProperty("NESTED TABLE", null);
            table.setProperty("PARTITIONED TABLE", null);
            table.setProperty("OBJECT TABLE", null);
        } else {
            final Holder tryObjectQuery = new Holder((Object)true);
            QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)table, query, table.getSchema(), table);
            wrap.executeQuery(new QueryWrapper.QueryRunnable((Table)table, wrap){
                final /* synthetic */ Table val$table;
                final /* synthetic */ QueryWrapper val$wrap;
                {
                    this.val$table = table;
                    this.val$wrap = queryWrapper;
                }

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        if (rs.next()) {
                            tryObjectQuery.set((Object)false);
                            this.val$table.setProperty("OBJECT TABLE", null);
                            OracleTableBuilder.this.setTableType(this.val$table, rs);
                        }
                    }
                    catch (SQLException ex) {
                        this.val$wrap.throwDBException((DBObject)this.val$table, ex);
                    }
                }
            });
            if (((Boolean)tryObjectQuery.get()).booleanValue()) {
                QueryWrapper wrap2 = this.getDatabase().newQueryWrapper((SystemObject)table, this.convertToObjectQuery(query), table.getSchema(), table);
                wrap2.executeQuery(new QueryWrapper.QueryRunnable((Table)table, wrap){
                    final /* synthetic */ Table val$table;
                    final /* synthetic */ QueryWrapper val$wrap;
                    {
                        this.val$table = table;
                        this.val$wrap = queryWrapper;
                    }

                    public void processResultSet(ResultSet rs) throws DBException {
                        try {
                            if (rs.next()) {
                                this.val$table.setProperty("OBJECT TABLE", (Object)Boolean.TRUE);
                                OracleTableBuilder.this.setTableType(this.val$table, rs);
                            }
                        }
                        catch (SQLException ex) {
                            this.val$wrap.throwDBException((DBObject)this.val$table, ex);
                        }
                    }
                });
            }
        }
    }

    private void setTableType(Table table, ResultSet rs) throws SQLException {
        boolean isNestedTable = "YES".equals(rs.getString(5));
        boolean isPartitionedTable = "YES".equals(rs.getString(4));
        Table.TableType type = Table.TableType.NORMAL;
        if ("IOT".equals(rs.getString(3))) {
            type = Table.TableType.INDEX_ORGANIZED;
        } else if ("Y".equals(rs.getString(1))) {
            String s = rs.getString(2);
            if ("SYS$SESSION".equals(s)) {
                type = Table.TableType.SESSION_TEMP;
            } else if ("SYS$TRANSACTION".equals(s)) {
                type = Table.TableType.TRANSACTION_TEMP;
            }
        } else if (!isNestedTable && "1".equals(rs.getString(6))) {
            type = Table.TableType.EXTERNAL;
        }
        table.setProperty("TableType", (Object)type);
        table.setProperty("NESTED TABLE", (Object)(isNestedTable ? Boolean.TRUE : null));
        table.setProperty("PARTITIONED TABLE", (Object)(isPartitionedTable ? Boolean.TRUE : null));
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleStorageProperties", "OracleExternalTableProperties", "OracleTableProperties", "OracleInMemoryProperties"}, depends={"TableType", "OBJECT TABLE", "NESTED TABLE", "PARTITIONED TABLE"})
    public void fillInBaseProperties(T table) throws DBException {
        boolean isObjectTable = Boolean.TRUE.equals(table.getProperty("OBJECT TABLE"));
        String query = this.getTableQuery();
        if (isObjectTable) {
            query = this.convertToObjectQuery(query);
        }
        QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)table, query, table.getSchema(), table);
        wrap.executeQuery(new QueryWrapper.QueryRunnable((Table)table, wrap){
            final /* synthetic */ Table val$table;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$table = table;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        OracleTableBuilder.this.setBasePropertiesFromRS(this.val$table, rs);
                    }
                }
                catch (SQLException ex) {
                    this.val$wrap.throwDBException((DBObject)this.val$table, ex);
                }
            }
        });
    }

    protected void setBasePropertiesFromRS(T table, ResultSet rs) throws SQLException, DBException {
        boolean isPartitionedTable = Boolean.TRUE.equals(table.getProperty("PARTITIONED TABLE"));
        Table.TableType type = (Table.TableType)table.getProperty("TableType");
        OracleTableProperties otp = OracleTableBuilder.getOracleTableProperties(table, rs.getString(15), rs.getString(16), rs.getString(17), this.getDatabase());
        if (otp.getParallelDegree() != null || otp.getTableCompression() != null) {
            table.setProperty("OracleTableProperties", (Object)otp);
        }
        if (type == Table.TableType.INDEX_ORGANIZED) {
            if (isPartitionedTable) {
                table.setProperty("OracleStorageProperties", (Object)this.getSegmentAttributeProperties("select /*OracleDictionaryQueries.ALL_PARTITIONED_IOT_DEFAULT_STORAGE_PROPERTIES_QUERY*/\n       def_tablespace_name TABLESPACE_NAME,\n       def_pct_free PCT_FREE, null PCT_USED,\n       def_ini_trans INI_TRANS, def_max_trans MAX_TRANS,\n       decode(def_initial_extent, 'DEFAULT', null, def_initial_extent) INITIAL_EXTENT,\n       decode(def_next_extent, 'DEFAULT', null, def_next_extent) NEXT_EXTENT,\n       decode(def_min_extents, 'DEFAULT', null, def_min_extents) MIN_EXTENTS,\n       decode(def_max_extents, 'DEFAULT', null, def_max_extents) MAX_EXTENTS,\n       decode(def_pct_increase, 'DEFAULT', null, def_pct_increase) PCT_INCREASE,\n       decode(def_freelists, 0, null, def_freelists) FREELISTS,\n       decode(def_freelist_groups, 0, null, def_freelist_groups) FREELIST_GROUPS,\n       decode(def_logging, 'NONE', null, def_logging) LOGGING,\n       def_buffer_pool BUFFER_POOL\nfrom   sys.all_part_indexes\nwhere  owner = ?\nand    index_name = ?\n", table, OracleTableBuilder.getQueryObject(table).getName()));
            } else {
                table.setProperty("OracleStorageProperties", (Object)this.getSegmentAttributeProperties(OracleDictionaryQueries.TABLE_IOT_STORAGE_PROPERTIES_QUERY, table, table.getName()));
            }
        } else if (type == Table.TableType.EXTERNAL) {
            table.setProperty("OracleExternalTableProperties", (Object)this.getExternalTableProperties(table));
        } else if (isPartitionedTable) {
            table.setProperty("OracleStorageProperties", (Object)this.getSegmentAttributeProperties("select /*OracleDictionaryQueries.ALL_PARTITIONED_TABLE_DEFAULT_STORAGE_PROPERTIES_QUERY*/\n       def_tablespace_name TABLESPACE_NAME,\n       def_pct_free PCT_FREE, def_pct_used PCT_USED,\n       def_ini_trans INI_TRANS, def_max_trans MAX_TRANS,\n       decode(def_initial_extent, 'DEFAULT', null, def_initial_extent) INITIAL_EXTENT,\n       decode(def_next_extent, 'DEFAULT', null, def_next_extent) NEXT_EXTENT,\n       decode(def_min_extents, 'DEFAULT', null, def_min_extents) MIN_EXTENTS,\n       decode(def_max_extents, 'DEFAULT', null, def_max_extents) MAX_EXTENTS,\n       decode(def_pct_increase, 'DEFAULT', null, def_pct_increase) PCT_INCREASE,\n       decode(def_freelists, 0, null, def_freelists) FREELISTS,\n       decode(def_freelist_groups, 0, null, def_freelist_groups) FREELIST_GROUPS,\n       decode(def_logging, 'NONE', null, def_logging) LOGGING,\n       def_buffer_pool BUFFER_POOL\nfrom   sys.all_part_tables\nwhere  owner = ?\nand    table_name = ?\n", table, table.getName()));
        } else {
            table.setProperty("OracleStorageProperties", (Object)OracleTableBuilder.getSegmentAttributeProperties(rs, this.getDatabase()));
        }
        OracleTableBuilder.fillInMemoryProperties(table, rs, this.getDatabase());
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleInMemoryColumnProperties"}, depends={"columns", "OracleInMemoryProperties"})
    public void buildInMemoryColumnProperties(T tab) throws DBException {
        boolean build = false;
        BaseOracleDatabase db = this.getDatabase();
        if (db.getDatabaseVersion() >= 12102) {
            OracleInMemoryProperties props = (OracleInMemoryProperties)tab.getProperty("OracleInMemoryProperties");
            boolean bl = build = props == null || props.isInMemory();
        }
        if (build) {
            final HashMap map = new HashMap();
            QueryWrapper wrap = db.newQueryWrapper((SystemObject)tab, "SELECT /**OracleDictionaryQueries.TABLE_IM_SELECTIVE_COLUMNS_QUERY*/\n COLUMN_NAME, INMEMORY_COMPRESSION \nFROM V$IM_COLUMN_LEVEL \nWHERE OWNER = ? AND TABLE_NAME = ?", DBUtil.getSchema(tab), tab);
            try {
                wrap.executeQuery(new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet rs) throws DBException, SQLException {
                        while (rs.next()) {
                            String comp = rs.getString("INMEMORY_COMPRESSION");
                            if (rs.wasNull() || comp == null || "DEFAULT".equals(comp)) continue;
                            String col = rs.getString("COLUMN_NAME");
                            if (rs.wasNull()) continue;
                            map.put(col, comp);
                        }
                    }
                });
            }
            catch (DBException dbe) {
                Throwable cause = dbe.getCause();
                if (cause instanceof SQLException && ((SQLException)cause).getErrorCode() == 942) {
                    this.getLogger().fine("Could not build inMemoryColumnProperties");
                }
                throw dbe;
            }
            if (!map.isEmpty()) {
                ArrayList<OracleInMemoryColumnProperties> imcps = new ArrayList<OracleInMemoryColumnProperties>();
                for (Column col : tab.getColumns()) {
                    String colName = col.getName();
                    String comp = (String)map.get(colName);
                    if (comp == null) continue;
                    OracleInMemoryColumnProperties cp = (OracleInMemoryColumnProperties)this.newObject(OracleInMemoryColumnProperties.class, null);
                    if (comp.equals("NO INMEMORY")) {
                        cp.setInMemory(false);
                    } else {
                        cp.setInMemoryCompression((OracleInMemoryProperties.InMemoryCompression)DBUtil.findEnumFromString((String)comp, OracleInMemoryProperties.InMemoryCompression.class));
                    }
                    cp.setColumnIDs(new DBObjectID[]{col.getID()});
                    cp.setID((DBObjectID)new NameBasedID("OracleInMemoryColumnProperties", colName, tab.getID()));
                    imcps.add(cp);
                }
                tab.setProperty("OracleInMemoryColumnProperties", (Object)imcps.toArray(new OracleInMemoryColumnProperties[imcps.size()]));
            }
        }
    }

    static OracleStorageProperties getStorageProperties(ResultSet rs) throws SQLException {
        OracleStorageProperties properties = new OracleStorageProperties();
        OracleTableBuilder.populateStorageProperties(properties, rs);
        return properties;
    }

    static void populateStorageProperties(OracleStorageProperties properties, ResultSet rs) throws SQLException {
        BigInteger bigMaxExt;
        BigDecimal initialExtent = rs.getBigDecimal("INITIAL_EXTENT");
        properties.setInitialExtent(rs.wasNull() ? null : initialExtent.toBigInteger());
        BigDecimal nextExtent = rs.getBigDecimal("NEXT_EXTENT");
        properties.setNextExtent(rs.wasNull() ? null : nextExtent.toBigInteger());
        BigDecimal minExtents = rs.getBigDecimal("MIN_EXTENTS");
        properties.setMinExtent(rs.wasNull() ? null : minExtents.toBigInteger());
        BigDecimal maxExtents = rs.getBigDecimal("MAX_EXTENTS");
        BigInteger bigInteger = bigMaxExt = rs.wasNull() ? null : maxExtents.toBigInteger();
        if (bigMaxExt != null && bigMaxExt.equals(MAXEXTENTS_UNLIMITED)) {
            bigMaxExt = BigInteger.ZERO;
        }
        properties.setMaxExtent(bigMaxExt);
        int pctIncrease = rs.getInt("PCT_INCREASE");
        properties.setPercentIncrease(rs.wasNull() ? null : Integer.valueOf(pctIncrease));
        int freelists = rs.getInt("FREELISTS");
        properties.setFreelists(rs.wasNull() ? null : Integer.valueOf(freelists));
        int freelistGroups = rs.getInt("FREELIST_GROUPS");
        properties.setFreelistGroups(rs.wasNull() ? null : Integer.valueOf(freelistGroups));
        String s = rs.getString("BUFFER_POOL");
        properties.setBufferMode(ModelUtil.hasLength((String)s) ? OracleStorageProperties.BufferModes.valueOf((String)s) : null);
    }

    private OracleStorageProperties getSegmentAttributeProperties(String query, T table, String objectName) throws DBException {
        OracleStorageProperties retval = new OracleStorageProperties();
        OracleStoragePropertiesBuilder builder = new OracleStoragePropertiesBuilder(this.getDatabase(), query, table.getSchema(), objectName);
        this.getDatabase().setOracleBuilder(retval, builder);
        return retval;
    }

    public static OracleStorageProperties getSegmentAttributeProperties(ResultSet rs, BaseOracleDatabase db) throws SQLException {
        OracleStorageProperties properties = new OracleStorageProperties();
        OracleTableBuilder.populateSegmentAttributes(properties, rs, db);
        return properties;
    }

    static void populateSegmentAttributes(OracleStorageProperties properties, ResultSet rs, BaseOracleDatabase db) throws SQLException {
        String tablespaceName;
        OracleTableBuilder.populateStorageProperties(properties, rs);
        int free = rs.getInt("PCT_FREE");
        properties.setPercentFree(rs.wasNull() ? null : Integer.valueOf(free));
        int used = rs.getInt("PCT_USED");
        properties.setPercentUsed(rs.wasNull() ? null : Integer.valueOf(used));
        int ini = rs.getInt("INI_TRANS");
        properties.setInitrans(rs.wasNull() || ini == 0 ? null : Integer.valueOf(ini));
        if (db.getDatabaseVersion() == 92) {
            int maxT = rs.getInt("MAX_TRANS");
            properties.setInitrans(rs.wasNull() || maxT == 0 ? null : Integer.valueOf(maxT));
        }
        if (ModelUtil.hasLength((String)(tablespaceName = rs.getString("TABLESPACE_NAME")))) {
            properties.setTablespaceID(OracleTablespaceUtil.getTablespaceID((DBObjectProvider)db, tablespaceName));
        }
        OracleTableBuilder.setLogging(rs, properties);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleIndexOrganizedTableProperties"}, depends={"columns", "constraints", "TableType"})
    public void fillInIOTProperties(T table) throws DBException {
        if (table.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED) {
            table.setProperty("OracleIndexOrganizedTableProperties", (Object)this.getIotProperties(table));
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleTablePartitions"}, depends={"columns", "constraints", "TableType", "PARTITIONED TABLE"})
    public void fillInTablePartitions(T table) throws DBException {
        boolean isExternal = table.getProperty("TableType") == Table.TableType.EXTERNAL;
        boolean isPartitionedTable = Boolean.TRUE.equals(table.getProperty("PARTITIONED TABLE"));
        if (isPartitionedTable && !isExternal) {
            table.setProperty("OracleTablePartitions", (Object)this.getOracleTablePartitions(table));
        }
    }

    @Override
    protected void setupOracleColumnProperties(T table, Column col, DataType type) {
        BaseOracleDatabase db = this.getDatabase();
        if (type == null || OracleColumnPropertiesBuilder.needColumnProperties(db, table, col, type)) {
            OracleColumnProperties props = (OracleColumnProperties)this.newObject(OracleColumnProperties.class, null);
            OracleColumnPropertiesBuilder builder = new OracleColumnPropertiesBuilder(db);
            db.setOracleBuilder(props, builder);
            col.setProperty("OracleColumnProperties", (Object)props);
            props.setID((DBObjectID)new NameBasedID((DBObject)props, col.getID()));
        }
    }

    protected OracleTablePartitions getOracleTablePartitions(T table) throws DBException {
        final Holder holder = new Holder();
        ArrayList colIDs = new ArrayList();
        final BaseOracleDatabase db = this.getDatabase();
        QueryWrapper wrap = db.newQueryWrapper((SystemObject)table, OracleTableBuilder.getTablePartitionsTypeQuery(this.getDatabase()), table.getSchema(), table);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Table)table, colIDs){
            final /* synthetic */ Table val$table;
            final /* synthetic */ List val$colIDs;
            {
                this.val$table = table;
                this.val$colIDs = list;
            }

            public void processResultSet(ResultSet rs) throws DBException, SQLException {
                while (rs.next()) {
                    OracleTablePartitions partitions = (OracleTablePartitions)holder.get();
                    OracleTablePartitions.PartitionType partitionType = null;
                    OracleTablePartitions.PartitionType subpartitionType = null;
                    if (partitions == null) {
                        partitionType = OracleTableBuilder.this.getPartitionType(rs.getString(1));
                        subpartitionType = OracleTableBuilder.this.getPartitionType(rs.getString(2));
                        if (partitionType != null) {
                            OracleTablePartitionsBuilder builder = new OracleTablePartitionsBuilder(db);
                            partitions = new OracleTablePartitions(partitionType, OracleTablePartitions.ObjectType.PARTITION);
                            db.setOracleBuilder(partitions, builder);
                            holder.set((Object)partitions);
                            NameBasedID parid = new NameBasedID((DBObject)partitions, this.val$table.getID());
                            partitions.setID((DBObjectID)parid);
                            if (subpartitionType != null && (OracleTablePartitions.PartitionType.HASH == subpartitionType || OracleTablePartitions.PartitionType.LIST == subpartitionType || OracleTablePartitions.PartitionType.RANGE == subpartitionType)) {
                                OracleTablePartitions subpartitionModel = new OracleTablePartitions(subpartitionType, OracleTablePartitions.ObjectType.SUBPARTITION);
                                subpartitionModel.setID((DBObjectID)new NameBasedID((DBObject)subpartitionModel, (DBObjectID)parid));
                                partitions.setSubpartitionModel(subpartitionModel);
                                db.setOracleBuilder(subpartitionModel, builder);
                            }
                        }
                    }
                    if (partitions == null) continue;
                    if (OracleTablePartitions.PartitionType.REFERENCE == partitionType) {
                        FKConstraint fk = (FKConstraint)this.val$table.getConstraint(rs.getString(4));
                        if (fk == null) continue;
                        partitions.setReferenceConstraintID(fk.getID());
                        continue;
                    }
                    Column col = this.val$table.getColumn(rs.getString(3));
                    if (col == null) continue;
                    this.val$colIDs.add(col.getID());
                }
            }
        };
        wrap.executeQuery(r);
        OracleTablePartitions retval = (OracleTablePartitions)holder.get();
        if (!colIDs.isEmpty()) {
            retval.setPartitionColumns(colIDs.toArray(new DBObjectID[colIDs.size()]));
        }
        return retval;
    }

    private OracleIndexOrganizedTableProperties getIotProperties(T table) throws DBException {
        OracleIndexOrganizedTableProperties properties = new OracleIndexOrganizedTableProperties();
        properties.setID((DBObjectID)new NameBasedID((DBObject)properties, table.getID()));
        this.populateIotPropsFromAllIndexes(table, properties);
        this.populateIotPropsFromAllTables(table, properties);
        return properties;
    }

    private void populateIotPropsFromAllIndexes(T table, final OracleIndexOrganizedTableProperties properties) throws DBException {
        QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)table, OracleDictionaryQueries.TABLE_IOT_INDEX_QUERY, table.getSchema(), OracleTableBuilder.getQueryObject(table));
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Table)table, wrap){
            final /* synthetic */ Table val$table;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$table = table;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        int pctThreshold = rs.getInt(1);
                        properties.setPctThreshold(rs.wasNull() ? null : Integer.valueOf(pctThreshold));
                        int compression = rs.getInt(2);
                        properties.setKeyCompression(rs.wasNull() ? null : Integer.valueOf(compression));
                        int includeColumnId = rs.getInt(3);
                        Column includeColumn = null;
                        if (!rs.wasNull()) {
                            Column[] columns = this.val$table.getColumns();
                            Column column = includeColumn = includeColumnId > 0 && includeColumnId <= columns.length ? columns[includeColumnId - 1] : null;
                        }
                        if (includeColumn != null) {
                            properties.setIncludeColumn(includeColumn.getID());
                        }
                    }
                }
                catch (SQLException sqe) {
                    this.val$wrap.throwDBException(sqe);
                }
            }
        };
        wrap.executeQuery(r);
    }

    private void populateIotPropsFromAllTables(T table, final OracleIndexOrganizedTableProperties properties) throws DBException {
        QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)table, OracleDictionaryQueries.TABLE_IOT_MAPPING_AND_OVERFLOW_QUERY, table.getSchema(), table);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Table)table, wrap){
            final /* synthetic */ Table val$table;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$table = table;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        if (rs.getString("IOT_TYPE").equals("IOT_OVERFLOW")) {
                            properties.setOverflowable(true);
                            if (Boolean.TRUE.equals(this.val$table.getProperty("PARTITIONED TABLE"))) {
                                String overflowTableName = rs.getString("TABLE_NAME");
                                properties.setOverflowProperties(OracleTableBuilder.this.getSegmentAttributeProperties("select /*OracleDictionaryQueries.ALL_PARTITIONED_TABLE_DEFAULT_STORAGE_PROPERTIES_QUERY*/\n       def_tablespace_name TABLESPACE_NAME,\n       def_pct_free PCT_FREE, def_pct_used PCT_USED,\n       def_ini_trans INI_TRANS, def_max_trans MAX_TRANS,\n       decode(def_initial_extent, 'DEFAULT', null, def_initial_extent) INITIAL_EXTENT,\n       decode(def_next_extent, 'DEFAULT', null, def_next_extent) NEXT_EXTENT,\n       decode(def_min_extents, 'DEFAULT', null, def_min_extents) MIN_EXTENTS,\n       decode(def_max_extents, 'DEFAULT', null, def_max_extents) MAX_EXTENTS,\n       decode(def_pct_increase, 'DEFAULT', null, def_pct_increase) PCT_INCREASE,\n       decode(def_freelists, 0, null, def_freelists) FREELISTS,\n       decode(def_freelist_groups, 0, null, def_freelist_groups) FREELIST_GROUPS,\n       decode(def_logging, 'NONE', null, def_logging) LOGGING,\n       def_buffer_pool BUFFER_POOL\nfrom   sys.all_part_tables\nwhere  owner = ?\nand    table_name = ?\n", this.val$table, overflowTableName));
                                continue;
                            }
                            properties.setOverflowProperties(OracleTableBuilder.getSegmentAttributeProperties(rs, OracleTableBuilder.this.getDatabase()));
                            continue;
                        }
                        properties.setMapped(true);
                    }
                }
                catch (SQLException x) {
                    this.val$wrap.throwDBException((DBObject)this.val$table, x);
                }
            }
        };
        wrap.executeQuery(r);
    }

    private OracleExternalTableProperties getExternalTableProperties(T table) throws DBException {
        final Holder holder = new Holder();
        BaseOracleDatabase db = this.getDatabase();
        String query = OracleTableBuilder.getExternalTableQuery(db);
        if (query != null) {
            final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)table, query, table.getSchema(), table);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Table)table){
                final /* synthetic */ Table val$table;
                {
                    this.val$table = table;
                }

                public void processResultSet(ResultSet rs) throws DBException {
                    block8: {
                        try {
                            String pc;
                            if (!rs.next()) break block8;
                            OracleExternalTableProperties properties = (OracleExternalTableProperties)OracleTableBuilder.this.newObject(OracleExternalTableProperties.class, null);
                            properties.setAccessDriverType(rs.getString(1));
                            Integer rejectLimit = null;
                            String rejectLimitString = rs.getString(2);
                            if ("UNLIMITED".equals(rejectLimitString)) {
                                rejectLimit = -1;
                            } else {
                                try {
                                    rejectLimit = Integer.valueOf(rejectLimitString);
                                }
                                catch (NumberFormatException nfe) {
                                    OracleTableBuilder.this.getLogger().severe("rejectLimit " + nfe.getMessage());
                                }
                            }
                            properties.setRejectLimit(rejectLimit);
                            if (rs.getString(4) != null) {
                                properties.setAccessParameters(rs.getString(4).trim());
                            }
                            if ((pc = rs.getString(5)) != null && !pc.equals("null")) {
                                properties.setProjectColumn(OracleExternalTableProperties.ProjectColumn.valueOf((String)pc));
                            }
                            properties.setDefaultDirectory(OracleTableBuilder.this.getDirectory(rs.getString(6), rs.getString(7)));
                            holder.set((Object)properties);
                        }
                        catch (SQLException sqe) {
                            wrap.throwDBException((DBObject)this.val$table, sqe);
                        }
                    }
                }
            };
            wrap.executeQuery(r);
            OracleExternalTableProperties properties = (OracleExternalTableProperties)holder.get();
            if (properties != null) {
                this.populateLocAndDir(table, properties);
            }
        }
        return (OracleExternalTableProperties)holder.get();
    }

    private void populateLocAndDir(T table, final OracleExternalTableProperties properties) throws DBException {
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)table, "select /*OracleDictionaryQueries.ALL_TABLE_EXT_LOCATIONS_QUERY*/\n       LOCATION, DIRECTORY_OWNER, DIRECTORY_NAME \nfrom   SYS.ALL_EXTERNAL_LOCATIONS \nwhere  OWNER = ?\nand    TABLE_NAME = ?\n", table.getSchema(), table);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Table)table){
            final /* synthetic */ Table val$table;
            {
                this.val$table = table;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        properties.addLocationSpecifier(OracleTableBuilder.this.getDirectory(rs.getString(2), rs.getString(3)), rs.getString(1));
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)this.val$table, sqe);
                }
            }
        };
        wrap.executeQuery(r);
    }

    private DBObjectID getDirectory(String owner, String name) {
        if (ModelUtil.hasLength((String)name)) {
            return new ReferenceID("DIRECTORY", owner, name);
        }
        return null;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"AUTO_GENERATED_SEQUENCE_TRIGGER"})
    public void fillInColumnSequenceColumns(T relation) throws DBException {
        BaseOracleDatabase db = this.getDatabase();
        String query = this.getColSeqTriggerQuery(db);
        if (query != null) {
            final HashMap trigMap = new HashMap();
            final QueryWrapper wrap = db.newQueryWrapper((SystemObject)relation, query, relation.getSchema(), relation);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet curs) throws DBException {
                    try {
                        while (curs.next()) {
                            String trigName = curs.getString(1);
                            String line = curs.getString(2);
                            StringBuilder sb = (StringBuilder)trigMap.get(trigName);
                            if (sb == null) {
                                sb = new StringBuilder();
                                trigMap.put(trigName, sb);
                            }
                            sb.append(line);
                        }
                    }
                    catch (SQLException e) {
                        wrap.throwDBException(e);
                    }
                }
            };
            wrap.executeQuery(r);
            for (Map.Entry e : trigMap.entrySet()) {
                String trigName = (String)e.getKey();
                String source = ((StringBuilder)e.getValue()).toString();
                for (ColumnSequenceProcessor.ColumnInfo info : ColumnSequenceProcessor.getColumnInfos(source, (DBObjectProvider)db)) {
                    Column col = relation.getColumn(info.getColumnName());
                    if (col == null) continue;
                    Schema seqSchema = null;
                    seqSchema = info.getSequenceSchemaName() != null ? db.getSchema(info.getSequenceSchemaName()) : relation.getSchema();
                    DBObjectID seqID = this.getColSeqID("SEQUENCE", seqSchema, info.getSequenceName());
                    DBObjectID trgID = this.getColSeqID("TRIGGER", relation.getSchema(), trigName);
                    col.setProperty("AUTO_GENERATED_SEQUENCE", (Object)seqID);
                    col.setProperty("AUTO_GENERATED_SEQUENCE_TRIGGER", (Object)trgID);
                    col.setProperty("ColumnSequenceExpander.TriggerNullCheck", (Object)info.isCheckForNull());
                }
            }
        }
    }

    private DBObjectID getColSeqID(String type, Schema schema, String name) throws DBException {
        DBObjectID ret = null;
        SchemaObject object = this.getDatabase().getObject(type, schema, name);
        if (object != null) {
            ret = object.getID();
        }
        return ret;
    }

    private String getTableTypeQuery() {
        BaseOracleDatabase db = this.getDatabase();
        String type = db.getDatabaseType();
        int version = db.getDatabaseVersion();
        String retval = "Oracle Lite".equals(type) || version < 81 ? null : (version <= 82 ? "SELECT /*OracleDictionaryQueries.TABLE_TYPE_ORACLE8_QUERY(SYS.ALL_TABLES)*/\n 'N' TEMPORARY, null DURATION, IOT_TYPE, PARTITIONED, NESTED, null EXTERNAL_TAB\nFROM SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?" : "SELECT /*OracleDictionaryQueries.ALL_TABLE_TYPE_QUERY*/\n A.TEMPORARY, A.DURATION, A.IOT_TYPE, A.PARTITIONED, A.NESTED,\n ( SELECT 1 FROM SYS.ALL_EXTERNAL_TABLES E    WHERE E.OWNER = A.OWNER AND E.TABLE_NAME = A.TABLE_NAME ) EXTERNAL_TAB\nFROM SYS.ALL_TABLES A \nWHERE A.OWNER = ? AND A.TABLE_NAME = ?");
        return retval;
    }

    private static String getExternalTableQuery(BaseOracleDatabase db) {
        String type = db.getDatabaseType();
        int version = db.getDatabaseVersion();
        String retval = "Oracle Lite".equals(type) || version <= 82 ? null : (version <= 92 ? "select /*OracleDictionaryQueries.ALL_TABLE_EXTERNAL_TAB_ORACLE9i_QUERY*/\n       TYPE_NAME, REJECT_LIMIT, ACCESS_TYPE, ACCESS_PARAMETERS, null, \n       DEFAULT_DIRECTORY_OWNER, DEFAULT_DIRECTORY_NAME \nfrom   SYS.ALL_EXTERNAL_TABLES \nwhere  OWNER = ? \nand    TABLE_NAME = ? \n" : "select /*OracleDictionaryQueries.ALL_TABLE_EXTERNAL_TAB_QUERY*/\n       TYPE_NAME, REJECT_LIMIT, ACCESS_TYPE, ACCESS_PARAMETERS, PROPERTY, \n       DEFAULT_DIRECTORY_OWNER, DEFAULT_DIRECTORY_NAME \nfrom   SYS.ALL_EXTERNAL_TABLES \nwhere  OWNER = ? \nand    TABLE_NAME = ? \n");
        return retval;
    }

    protected String getTableQuery() {
        return OracleTableBuilder.getTableQuery(this.getDatabase());
    }

    private String convertToObjectQuery(String query) {
        String retval = null;
        if (this.getDatabase().getDatabaseVersion() > 81) {
            Pattern p1 = Pattern.compile("ALL_TABLES", 2);
            retval = p1.matcher(query).replaceAll("ALL_OBJECT_TABLES");
        }
        return retval;
    }

    private String getColSeqTriggerQuery(BaseOracleDatabase db) {
        String type = db.getDatabaseType();
        return "Oracle Lite".equals(type) ? null : "SELECT /*OracleDictionaryQueries.ALL_TABLE_COLSEQ_TRIGGERS_QUERY*/\n       S.NAME, S.TEXT\nFROM   SYS.ALL_SOURCE S\nWHERE  S.OWNER = ? \nAND    S.TYPE = 'TRIGGER'\nAND EXISTS (SELECT 1\n            FROM   SYS.ALL_TRIGGERS T\n            WHERE  T.OWNER = S.OWNER\n            AND    T.TABLE_NAME = ? \n            AND    T.TRIGGER_NAME = S.NAME\n            AND    T.TABLE_OWNER = S.OWNER\n            AND    T.BASE_OBJECT_TYPE = 'TABLE'\n            AND    T.TRIGGER_TYPE LIKE '%EACH ROW'\n            AND    T.TRIGGERING_EVENT LIKE '%INSERT%'\n            AND EXISTS (SELECT 1\n                        FROM   SYS.ALL_SOURCE S2\n                        WHERE  S2.OWNER = S.OWNER\n                        AND    S2.NAME = S.NAME\n                        AND    S2.TYPE = S2.TYPE\n                        AND    S2.TEXT LIKE '%<<COLUMN_SEQUENCES>>%'\n                        )\n             )\nORDER BY S.NAME, S.LINE";
    }

    static void setLOBCache(LOBDescriptor lobDescriptor, String cache) {
        lobDescriptor.setLOBCache((LOBDescriptor.LOBCache)(cache.equals("YES") ? LOBDescriptor.LOBCache.CACHE : (cache.equals("NO") ? LOBDescriptor.LOBCache.NOCACHE : (cache.equals("CACHEREADS") ? LOBDescriptor.LOBCache.CACHE_READS : null))));
    }

    static OracleTableProperties getOracleTableProperties(DBObject object, String compression, String compressFor, String parallelDegree, BaseOracleDatabase db) {
        OracleTableProperties otp = new OracleTableProperties();
        OracleTableProperties.OracleTableCompression tableCompression = OracleTableProperties.OracleTableCompression.NOCOMPRESS;
        if (object instanceof MaterializedView || object instanceof TablePartition || object instanceof Table && (Table.TableType)object.getProperty("TableType") == Table.TableType.NORMAL) {
            if (compression != null) {
                tableCompression = compression.equals(ENABLED) ? (compressFor == null || compressFor.equals(BASIC) ? OracleTableProperties.OracleTableCompression.COMPRESS : (compressFor.equals(DIRECT_LOAD_OPERATIONS) ? OracleTableProperties.OracleTableCompression.COMPRESS_FOR_DIRECT_LOAD_OPERATIONS : (compressFor.equals(ALL_OPERATIONS) ? OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ALL_OPERATIONS : (compressFor.equals(ADVANCED) ? OracleTableProperties.OracleTableCompression.ROW_STORE_COMPRESS_ADVANCED : (compressFor.equals(OLTP) ? OracleTableProperties.OracleTableCompression.COMPRESS_FOR_OLTP : (compressFor.equals(ROW_LEVEL_LOCKING) ? OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_ROW_LEVEL_LOCKING : (compressFor.equals(QUERY_LOW) ? OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_LOW : (compressFor.equals(QUERY_HIGH) ? OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_HIGH : (compressFor.equals(ARCHIVE_LOW) ? OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_LOW : (compressFor.equals(ARCHIVE_HIGH) ? OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_HIGH : (compressFor.equals(QUERY_LOW_ROW_LEVEL_LOCKING) ? OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_FOR_QUERY_LOW_ROW_LEVEL_LOCKING : (compressFor.equals(QUERY_HIGH_ROW_LEVEL_LOCKING) ? OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_FOR_QUERY_HIGH_ROW_LEVEL_LOCKING : (compressFor.equals(ARCHIVE_LOW_ROW_LEVEL_LOCKING) ? OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_FOR_ARCHIVE_LOW_ROW_LEVEL_LOCKING : (compressFor.equals(ARCHIVE_HIGH_ROW_LEVEL_LOCKING) ? OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_FOR_ARCHIVE_HIGH_ROW_LEVEL_LOCKING : OracleTableProperties.OracleTableCompression.COMPRESS)))))))))))))) : OracleTableProperties.OracleTableCompression.NOCOMPRESS;
            }
            otp.setTableCompression(tableCompression);
        }
        if (parallelDegree != null) {
            Integer degree;
            if ((parallelDegree = parallelDegree.trim()).equals("DEFAULT")) {
                degree = 0;
            } else {
                try {
                    degree = Integer.parseInt(parallelDegree);
                }
                catch (NumberFormatException nfe) {
                    DBLog.getLogger(OracleTableBuilder.class).warning(nfe.getMessage());
                    degree = null;
                }
            }
            otp.setParallelDegree(degree);
        }
        return otp;
    }

    static DBObject getQueryObject(Table table) {
        if (Table.TableType.INDEX_ORGANIZED == table.getProperty("TableType")) {
            for (Constraint constraint : table.getConstraints()) {
                if (!(constraint instanceof PKConstraint)) continue;
                return constraint;
            }
        }
        return table;
    }

    static void setLogging(ResultSet rs, OracleStorageProperties storageProps) throws SQLException {
        String logging = rs.getString("LOGGING");
        if (!rs.wasNull() && logging != null && !logging.equalsIgnoreCase("NONE")) {
            storageProps.setLogging("YES".equalsIgnoreCase(logging) ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    static String getTableQuery(OracleDatabase db) {
        int ver;
        String retval = null;
        retval = "Oracle Lite".equals(db.getDatabaseType()) ? "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_OLITE_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       null FREELISTS, null FREELIST_GROUPS, null LOGGING,\n       null BUFFER_POOL, null COMPRESSION, null COMPRESS_FOR, null DEGREE, null CACHE \nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?" : ((ver = db.getDatabaseVersion()) >= 12102 ? "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_QUERY(SYS.ALL_TABLES)*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, COMPRESSION,\n       COMPRESS_FOR, DEGREE, CACHE, INMEMORY, INMEMORY_COMPRESSION, \n       INMEMORY_PRIORITY, INMEMORY_DISTRIBUTE, INMEMORY_DUPLICATE \nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?" : (ver >= 110 ? "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_QUERY(SYS.ALL_TABLES)*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, COMPRESSION,\n       COMPRESS_FOR, DEGREE, CACHE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?" : (ver >= 100 ? "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE10_QUERY(SYS.ALL_TABLES)*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, COMPRESSION,\n       null COMPRESS_FOR, DEGREE, CACHE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?" : (ver >= 91 ? "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE9_QUERY(SYS.ALL_TABLES)*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, null COMPRESSION,\n       null COMPRESS_FOR, DEGREE, CACHE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?" : (ver >= 81 ? "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE8_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, null COMPRESSION,\n       null COMPRESS_FOR, DEGREE, CACHE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?" : "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE7_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, null LOGGING, null BUFFER_POOL, null COMPRESSION,\n       null COMPRESSION_FOR, 1 DEGREE, CACHE \nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?")))));
        return retval;
    }

    private static String getTablePartitionsTypeQuery(OracleDatabase db) {
        String retval = null;
        retval = db.getDatabaseVersion() >= 110 ? "select /*OracleDictionaryQueries.ALL_TABLE_PARTITIONS_TYPE_QUERY*/\n       apt.partitioning_type, apt.subpartitioning_type, apkc.column_name, apt.ref_ptn_constraint_name\nfrom   sys.all_part_tables apt, sys.all_part_key_columns apkc\nwhere  apt.owner = ?\nand    apt.table_name = ?\nand    apkc.owner = apt.owner\nand    apkc.name  = apt.table_name\nand    apkc.object_type = 'TABLE'\norder by apkc.column_position" : "select /*OracleDictionaryQueries.ALL_TABLE_PARTITIONS_TYPE_QUERY*/\n       apt.partitioning_type, apt.subpartitioning_type, apkc.column_name\nfrom   sys.all_part_tables apt, sys.all_part_key_columns apkc\nwhere  apt.owner = ?\nand    apt.table_name = ?\nand    apkc.owner = apt.owner\nand    apkc.name  = apt.table_name\nand    apkc.object_type = 'TABLE'\norder by apkc.column_position";
        return retval;
    }

    static void fillInMemoryProperties(DBObject obj, ResultSet rs, BaseOracleDatabase db) throws SQLException {
        if (db.getDatabaseVersion() >= 12102) {
            String inmem = rs.getString(OracleTableBuilder.getInMemoryColumnName(null, obj));
            if (!rs.wasNull()) {
                OracleInMemoryProperties imp = new OracleInMemoryProperties();
                if (ENABLED.equals(inmem)) {
                    imp.setInMemory(true);
                    OracleInMemoryProperties.InMemoryCompression comp = (OracleInMemoryProperties.InMemoryCompression)OracleTableBuilder.parseEnumFromRS(rs, OracleTableBuilder.getInMemoryColumnName("COMPRESSION", obj), OracleInMemoryProperties.InMemoryCompression.class);
                    imp.setInMemoryCompression(comp);
                    OracleInMemoryProperties.InMemoryPriority pri = (OracleInMemoryProperties.InMemoryPriority)OracleTableBuilder.parseEnumFromRS(rs, OracleTableBuilder.getInMemoryColumnName("PRIORITY", obj), OracleInMemoryProperties.InMemoryPriority.class);
                    imp.setInMemoryPriority(pri);
                    OracleInMemoryProperties.InMemoryDuplicate dup = (OracleInMemoryProperties.InMemoryDuplicate)OracleTableBuilder.parseEnumFromRS(rs, OracleTableBuilder.getInMemoryColumnName("DUPLICATE", obj), OracleInMemoryProperties.InMemoryDuplicate.class);
                    imp.setInMemoryDuplicate(dup);
                    OracleInMemoryProperties.InMemoryDistribute dis = (OracleInMemoryProperties.InMemoryDistribute)OracleTableBuilder.parseEnumFromRS(rs, OracleTableBuilder.getInMemoryColumnName("DISTRIBUTE", obj), OracleInMemoryProperties.InMemoryDistribute.class);
                    imp.setInMemoryDistribute(dis);
                } else {
                    imp.setInMemory(false);
                }
                obj.setProperty("OracleInMemoryProperties", (Object)imp);
            }
        }
    }

    private static String getInMemoryColumnName(String suffix, DBObject obj) {
        StringBuilder buff = new StringBuilder();
        if (obj instanceof OracleTablespaceProperties) {
            buff.append("DEF_");
        }
        buff.append("INMEMORY");
        if (suffix != null) {
            buff.append("_").append(suffix);
        }
        return buff.toString();
    }

    private static <T extends Enum> T parseEnumFromRS(ResultSet rs, String col, Class<? extends Enum> enumClz) throws SQLException {
        Enum retval = null;
        String colVal = rs.getString(col);
        if (!rs.wasNull()) {
            retval = DBUtil.findEnumFromString((String)colVal, enumClz);
        }
        return (T)retval;
    }

    private OracleTablePartitions.PartitionType getPartitionType(String partTypeString) {
        OracleTablePartitions.PartitionType retval;
        try {
            retval = OracleTablePartitions.PartitionType.valueOf((String)partTypeString);
        }
        catch (IllegalArgumentException e) {
            retval = null;
        }
        return retval;
    }
}

