/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AutoExtendProperties;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBSQLException;
import oracle.javatools.db.FileSpecification;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.resource.APIBundle;

public class OracleTablespaceBuilder
extends OracleDBObjectBuilder<Tablespace> {
    private static final String ENABLED = "ENABLED";
    private static final String DIRECT_LOAD_OPERATIONS = "DIRECT LOAD ONLY";
    private static final String ALL_OPERATIONS = "FOR ALL OPERATIONS";
    private static final String OLTP = "OLTP";
    private static final String BASIC = "BASIC";
    private static final String QUERY_LOW = "QUERY LOW";
    private static final String QUERY_HIGH = "QUERY HIGH";
    private static final String ARCHIVE_LOW = "ARCHIVE LOW";
    private static final String ARCHIVE_HIGH = "ARCHIVE HIGH";
    private static final String AUTO = "AUTO";
    private static final String LOGGING = "LOGGING";
    private static final String NO = "NO";
    private static final String YES = "YES";
    private static final String ONLINE = "ONLINE";
    private static final String OFFLINE = "OFFLINE";
    private static final String AVAILABLE = "AVAILABLE";
    private static final String NOGUARANTEE = "NOGUARANTEE";
    private static final String GUARANTEE = "GUARANTEE";
    private static final String UNIFORM = "UNIFORM";
    private static final String TEMPORARY = "TEMPORARY";
    private static final String UNDO = "UNDO";
    private static final String PERMANENT = "PERMANENT";
    private static final String DICTIONARY = "DICTIONARY";
    private static final String LOCAL = "LOCAL";

    public OracleTablespaceBuilder(BaseOracleDatabase db) {
        super(db, "TABLESPACE");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"TablespaceType", "OracleTablespaceProperties", "fileType"})
    public void buildTablespace(final Tablespace tbsp) throws DBException {
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)tbsp, this.getTablespaceQuery(), tbsp);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        OracleTablespaceBuilder.this.fillInTablespaceProps(rs, tbsp);
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)tbsp, sqe);
                }
            }
        };
        wrap.executeQuery(r);
    }

    private OracleTablespaceProperties fillInTablespaceProps(ResultSet rs, Tablespace tbsp) throws SQLException {
        BigDecimal uniform;
        OracleTablespaceProperties.ExtentManagementType extentMgmt;
        BaseOracleDatabase db = this.getDatabase();
        OracleTablespaceProperties.ExtentManagementType extentManagementType = extentMgmt = LOCAL.equals(rs.getString(12)) ? OracleTablespaceProperties.ExtentManagementType.LOCAL : OracleTablespaceProperties.ExtentManagementType.DICTIONARY;
        if (rs.getString(1).equals(NO)) {
            tbsp.setFileType(Tablespace.FileType.SMALLFILE);
        } else {
            tbsp.setFileType(Tablespace.FileType.BIGFILE);
        }
        String tbspTypeString = rs.getString(2);
        Tablespace.TablespaceType tbspType = tbspTypeString.equals(TEMPORARY) ? Tablespace.TablespaceType.TEMPORARY : (tbspTypeString.equals(UNDO) ? Tablespace.TablespaceType.UNDO : Tablespace.TablespaceType.PERMANENT);
        tbsp.setProperty("TablespaceType", (Object)tbspType);
        OracleTablespaceProperties otp = new OracleTablespaceProperties();
        int size = rs.getInt(3);
        otp.setBlockSize(rs.wasNull() ? null : Integer.valueOf(size));
        if (tbspType == Tablespace.TablespaceType.PERMANENT) {
            String defTabComp;
            if (extentMgmt == OracleTablespaceProperties.ExtentManagementType.DICTIONARY) {
                int min = rs.getInt(3);
                otp.setMinExtent(rs.wasNull() ? null : Integer.valueOf(min));
            }
            if ((defTabComp = rs.getString(5)).equals(ENABLED)) {
                String compressFor = rs.getString(6);
                if (compressFor == null || compressFor.equals(BASIC)) {
                    otp.setDefaultTableCompression(OracleTableProperties.OracleTableCompression.COMPRESS);
                } else if (compressFor.equals(DIRECT_LOAD_OPERATIONS)) {
                    otp.setDefaultTableCompression(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_DIRECT_LOAD_OPERATIONS);
                } else if (compressFor.equals(ALL_OPERATIONS)) {
                    otp.setDefaultTableCompression(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ALL_OPERATIONS);
                } else if (compressFor.equals(OLTP)) {
                    otp.setDefaultTableCompression(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_OLTP);
                } else if (compressFor.equals(QUERY_LOW)) {
                    otp.setDefaultTableCompression(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_LOW);
                } else if (compressFor.equals(QUERY_HIGH)) {
                    otp.setDefaultTableCompression(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_HIGH);
                } else if (compressFor.equals(ARCHIVE_LOW)) {
                    otp.setDefaultTableCompression(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_LOW);
                } else {
                    otp.setDefaultTableCompression(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_HIGH);
                }
            } else {
                otp.setDefaultTableCompression(OracleTableProperties.OracleTableCompression.NOCOMPRESS);
            }
            OracleTableBuilder.fillInMemoryProperties((DBObject)otp, rs, db);
            otp.setSegmentManagement(rs.getString(7).equals(AUTO) ? OracleTablespaceProperties.SegmentManagement.AUTO : OracleTablespaceProperties.SegmentManagement.MANUAL);
            otp.setLogging(rs.getString(8).equals(LOGGING) ? OracleTablespaceProperties.LoggingType.LOGGING : OracleTablespaceProperties.LoggingType.NOLOGGING);
            otp.setForceLogging(!rs.getString(9).equals(NO));
            String onlineStatus = rs.getString(10);
            if (onlineStatus.equals(ONLINE)) {
                otp.setOnlineStatus(OracleTablespaceProperties.OnlineStatus.ONLINE);
            } else if (onlineStatus.equals(OFFLINE)) {
                otp.setOnlineStatus(OracleTablespaceProperties.OnlineStatus.OFFLINE);
            }
        }
        if (tbspType == Tablespace.TablespaceType.UNDO) {
            String retention = rs.getString(11);
            if (retention.equals(NOGUARANTEE)) {
                otp.setRetention(OracleTablespaceProperties.RetentionType.NOGUARANTEE);
            } else if (retention.equals(GUARANTEE)) {
                otp.setRetention(OracleTablespaceProperties.RetentionType.GUARANTEE);
            }
        }
        if (tbspType == Tablespace.TablespaceType.TEMPORARY) {
            db.setOracleBuilder(otp, new OTPBuilder(db));
        }
        otp.setExtentManagementType(extentMgmt);
        otp.setAutoAllocate(!rs.getString(13).equals(UNIFORM));
        if (extentMgmt == OracleTablespaceProperties.ExtentManagementType.DICTIONARY) {
            this.fillInStorageProps(rs, otp);
        }
        if (!otp.isAutoAllocate() && (uniform = rs.getBigDecimal(15)) != null) {
            otp.setUniformSize(uniform.toBigInteger());
        }
        tbsp.setProperty("OracleTablespaceProperties", (Object)otp);
        return otp;
    }

    private void fillInStorageProps(ResultSet rs, OracleTablespaceProperties otp) throws SQLException {
        if (Tablespace.TablespaceType.PERMANENT == otp.getParent().getProperty("TablespaceType")) {
            BigInteger bigMaxExt;
            OracleStorageProperties osp = new OracleStorageProperties();
            BigDecimal initialExtent = rs.getBigDecimal(14);
            osp.setInitialExtent(initialExtent == null ? null : initialExtent.toBigInteger());
            BigDecimal nextExtent = rs.getBigDecimal(15);
            osp.setNextExtent(nextExtent == null ? null : nextExtent.toBigInteger());
            BigDecimal minExtents = rs.getBigDecimal(16);
            osp.setMinExtent(minExtents == null ? null : minExtents.toBigInteger());
            BigDecimal maxExtents = rs.getBigDecimal(17);
            BigInteger bigInteger = bigMaxExt = maxExtents == null ? null : maxExtents.toBigInteger();
            if (bigMaxExt != null && bigMaxExt.equals(OracleTableBuilder.MAXEXTENTS_UNLIMITED)) {
                bigMaxExt = BigInteger.ZERO;
            }
            osp.setMaxExtent(bigMaxExt);
            int pctIncrease = rs.getInt(18);
            osp.setPercentIncrease(rs.wasNull() ? null : Integer.valueOf(pctIncrease));
            otp.setProperty("OracleStorageProperties", (Object)osp);
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"fileSpecifications"}, depends={"OracleTablespaceProperties"})
    public void fillInDataFiles(final Tablespace tbsp) throws DBException {
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)tbsp, "SELECT /*OracleDictionaryQueries.DBA_TABLESPACE_DATA_FILES_QUERY*/ \n       FILE_NAME,      BYTES\n,      MAXBYTES\n,      AUTOEXTENSIBLE\n,      INCREMENT_BY\n,      STATUS\nFROM   SYS.DBA_DATA_FILES\nWHERE  TABLESPACE_NAME = ?\nUNION\nSELECT FILE_NAME, BYTES\n,      MAXBYTES\n,      AUTOEXTENSIBLE\n,      INCREMENT_BY\n,      STATUS\nFROM   SYS.DBA_TEMP_FILES\nWHERE  TABLESPACE_NAME = ?", tbsp, tbsp);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        FileSpecification fileSpec = new FileSpecification();
                        String fullPath = rs.getString(1);
                        if (fullPath.indexOf("\\") != -1) {
                            fileSpec.setDirectory(fullPath.substring(0, fullPath.lastIndexOf("\\")));
                            fileSpec.setName(fullPath.substring(fullPath.lastIndexOf("\\") + 1, fullPath.length()));
                        } else if (fullPath.indexOf("/") != -1) {
                            fileSpec.setDirectory(fullPath.substring(0, fullPath.lastIndexOf("/")));
                            fileSpec.setName(fullPath.substring(fullPath.lastIndexOf("/") + 1, fullPath.length()));
                        } else {
                            fileSpec.setName(fullPath);
                        }
                        BigDecimal size = rs.getBigDecimal(2);
                        if (size != null && !rs.wasNull()) {
                            fileSpec.setFileSize(size.toBigInteger());
                        }
                        AutoExtendProperties aep = new AutoExtendProperties();
                        String autoExtend = rs.getString(4);
                        if (autoExtend != null && autoExtend.equals(OracleTablespaceBuilder.YES)) {
                            BigDecimal max = rs.getBigDecimal(3);
                            aep.setMaxSize(max == null ? null : max.toBigInteger());
                            OracleTablespaceProperties otp = (OracleTablespaceProperties)tbsp.getProperty("OracleTablespaceProperties");
                            Integer blockSize = otp.getBlockSize();
                            BigDecimal next = rs.getBigDecimal(5);
                            if (blockSize != null) {
                                next = next.multiply(BigDecimal.valueOf(blockSize.intValue()));
                            }
                            aep.setNextSize(next == null ? null : next.toBigInteger());
                            aep.setAutoExtendOn(true);
                        } else {
                            aep.setAutoExtendOn(false);
                        }
                        fileSpec.setAutoExtendProperties(aep);
                        String statusString = rs.getString(6);
                        Object status = OracleTablespaceBuilder.AVAILABLE.equals(statusString) || OracleTablespaceBuilder.ONLINE.equals(statusString) ? FileSpecification.FileStatus.ONLINE : (OracleTablespaceBuilder.OFFLINE.equals(statusString) ? FileSpecification.FileStatus.OFFLINE : null);
                        fileSpec.setStatus(status);
                        fileSpec.setID((DBObjectID)new NameBasedID((DBObject)fileSpec, tbsp.getID()));
                        tbsp.addFileSpecification(fileSpec);
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)tbsp, sqe);
                }
            }
        };
        try {
            wrap.executeQuery(r);
        }
        catch (DBSQLException dbe) {
            Throwable t = dbe.getCause();
            if (t instanceof SQLException && ((SQLException)t).getErrorCode() == 942) {
                this.getLogger().warning(APIBundle.format((String)"TABLESPACE_FILESPEC_LOAD_ERR", (Object[])new Object[]{tbsp.getName(), dbe.getMessage()}));
            }
            throw dbe;
        }
    }

    private String getTablespaceQuery() {
        String query = null;
        String type = this.getDatabase().getDatabaseType();
        int version = this.getDatabase().getDatabaseVersion();
        query = "Oracle Lite".equals(type) || version <= 92 ? "SELECT NULL\n,      UT.CONTENTS\n,      UT.BLOCK_SIZE\n,      UT.MIN_EXTLEN\n,      UT.DEF_TAB_COMPRESSION\n,      NULL\n,      UT.SEGMENT_SPACE_MANAGEMENT\n,      UT.LOGGING\n,      UT.FORCE_LOGGING\n,      UT.STATUS\n,      NULL\n/* Extent Management Properties */\n,      UT.EXTENT_MANAGEMENT\n,      UT.ALLOCATION_TYPE\n/* Storage Properties */\n,      UT.INITIAL_EXTENT\n,      UT.NEXT_EXTENT\n,      UT.MIN_EXTENTS\n,      UT.MAX_EXTENTS\n,      UT.PCT_INCREASE\nFROM  SYS.USER_TABLESPACES UT \nWHERE   UT.TABLESPACE_NAME = ?" : (version >= 12102 ? "SELECT UT.BIGFILE\n,      UT.CONTENTS\n,      UT.BLOCK_SIZE\n,      UT.MIN_EXTLEN\n,      UT.DEF_TAB_COMPRESSION\n,      UT.COMPRESS_FOR\n,      UT.SEGMENT_SPACE_MANAGEMENT\n,      UT.LOGGING\n,      UT.FORCE_LOGGING\n,      UT.STATUS\n,      UT.RETENTION/* Extent Management Properties */\n,      UT.EXTENT_MANAGEMENT\n,      UT.ALLOCATION_TYPE\n/* Storage Properties */\n,      UT.INITIAL_EXTENT\n,      UT.NEXT_EXTENT\n,      UT.MIN_EXTENTS\n,      UT.MAX_EXTENTS\n,      UT.PCT_INCREASE\n/* In-Memory Properties */\n,      UT.DEF_INMEMORY\n,      UT.DEF_INMEMORY_COMPRESSION\n,      UT.DEF_INMEMORY_PRIORITY\n,      UT.DEF_INMEMORY_DUPLICATE\n,      UT.DEF_INMEMORY_DISTRIBUTE\nFROM  SYS.USER_TABLESPACES UT \nWHERE   UT.TABLESPACE_NAME = ?" : (version >= 110 ? "SELECT UT.BIGFILE\n,      UT.CONTENTS\n,      UT.BLOCK_SIZE\n,      UT.MIN_EXTLEN\n,      UT.DEF_TAB_COMPRESSION\n,      UT.COMPRESS_FOR\n,      UT.SEGMENT_SPACE_MANAGEMENT\n,      UT.LOGGING\n,      UT.FORCE_LOGGING\n,      UT.STATUS\n,      UT.RETENTION/* Extent Management Properties */\n,      UT.EXTENT_MANAGEMENT\n,      UT.ALLOCATION_TYPE\n/* Storage Properties */\n,      UT.INITIAL_EXTENT\n,      UT.NEXT_EXTENT\n,      UT.MIN_EXTENTS\n,      UT.MAX_EXTENTS\n,      UT.PCT_INCREASE\nFROM  SYS.USER_TABLESPACES UT \nWHERE   UT.TABLESPACE_NAME = ?" : "SELECT UT.BIGFILE\n,      UT.CONTENTS\n,      UT.BLOCK_SIZE\n,      UT.MIN_EXTLEN\n,      UT.DEF_TAB_COMPRESSION\n,      NULL\n,      UT.SEGMENT_SPACE_MANAGEMENT\n,      UT.LOGGING\n,      UT.FORCE_LOGGING\n,      UT.STATUS\n,      UT.RETENTION\n/* Extent Management Properties */\n,      UT.EXTENT_MANAGEMENT\n,      UT.ALLOCATION_TYPE\n/* Storage Properties */\n,      UT.INITIAL_EXTENT\n,      UT.NEXT_EXTENT\n,      UT.MIN_EXTENTS\n,      UT.MAX_EXTENTS\n,      UT.PCT_INCREASE\nFROM  SYS.USER_TABLESPACES UT\nWHERE UT.TABLESPACE_NAME = ?"));
        return query;
    }

    public static class OTPBuilder
    extends OracleDBObjectBuilder<OracleTablespaceProperties> {
        OTPBuilder(BaseOracleDatabase db) {
            super(db, "OracleTablespaceProperties");
        }

        protected boolean canBuildComponents() {
            return true;
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"tablespaceGroup"}, depends={"TablespaceType"})
        public void buildTablespaceGroup(OracleTablespaceProperties otp) throws DBException {
            Tablespace tbsp = (Tablespace)otp.getParent();
            QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)tbsp, "SELECT /*OracleDictionaryQueries.DBA_TABLESPACE_GROUP_QUERY*/ \ngroup_name FROM sys.dba_tablespace_groups WHERE tablespace_name = ?", tbsp);
            try {
                otp.setTablespaceGroup(wrap.executeSingleCellQuery());
            }
            catch (DBException dbe) {
                Throwable cause = dbe.getCause();
                if (cause instanceof SQLException && ((SQLException)cause).getErrorCode() == 942) {
                    this.getLogger().fine("Could not build tablespaceGroup");
                }
                throw dbe;
            }
        }
    }
}

