/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.ide.util.Assert;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleDictionaryQueries;
import oracle.javatools.db.plsql.Trigger;

public class OracleTriggerBuilder
extends OracleDBObjectBuilder<Trigger> {
    OracleTriggerBuilder(BaseOracleDatabase db) {
        super(db, "TRIGGER");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"baseObjectID", "baseType", "columnIDs", "code", "enabled", "events", "referencingNewAs", "referencingOldAs", "source", "statementLevel", "timing", "whenClause"})
    public void fillInTrigger(final Trigger trigger) throws DBException {
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)trigger, this.getQueryString(), trigger.getSchema(), trigger);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        trigger.setCode(rs.getString(8));
                        String s = rs.getString(1);
                        OracleTriggerBuilder.parseBaseType(s, trigger);
                        Trigger.BaseType baseType = trigger.getBaseType();
                        s = rs.getString(2);
                        OracleTriggerBuilder.parseTriggerType(s, trigger);
                        OracleTriggerBuilder.parseTriggeringEvent(rs.getString(3), trigger);
                        s = rs.getString(4);
                        Schema tSchema = s != null ? OracleTriggerBuilder.this.getSchema(s) : null;
                        OracleTriggerBuilder.parseOwnerAndName(tSchema, rs.getString(5), trigger, (DBObjectProvider)OracleTriggerBuilder.this.getDatabase());
                        if (baseType == Trigger.BaseType.VIEW || baseType == Trigger.BaseType.TABLE && !trigger.isStatementLevel()) {
                            OracleTriggerBuilder.parseReferencingNames(rs.getString(6), trigger);
                        }
                        trigger.setWhenClause(rs.getString(7));
                        trigger.setEnabled(!"DISABLED".equals(rs.getString(9)));
                        ArrayList<NameBasedID> columnIDs = new ArrayList<NameBasedID>();
                        s = rs.getString(10);
                        while (s != null) {
                            String listed = rs.getString(11);
                            if ("Y".equals(listed) || "YES".equals(listed)) {
                                NameBasedID refID = new NameBasedID("COLUMN", s, trigger.getBaseObjectID());
                                columnIDs.add(refID);
                            }
                            s = rs.next() ? rs.getString(10) : null;
                        }
                        trigger.setColumnIDs(columnIDs.toArray(new DBObjectID[columnIDs.size()]));
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)trigger, ex);
                }
            }
        };
        wrap.executeQuery(r);
        trigger.setSource(this.getSource(trigger));
    }

    protected String getQueryString() {
        if (this.getDatabase().getDatabaseVersion() < 82) {
            return OracleDictionaryQueries.TRIGGER_PROPS_ORACLE8_QUERY;
        }
        return "SELECT /*OracleDictionaryQueries.ALL_TRIGGER_PROPS_QUERY*/\n       A.BASE_OBJECT_TYPE, A.TRIGGER_TYPE, A.TRIGGERING_EVENT, A.TABLE_OWNER, A.TABLE_NAME, A.REFERENCING_NAMES, A.WHEN_CLAUSE, A.TRIGGER_BODY, A.STATUS, B.COLUMN_NAME, B.COLUMN_LIST FROM SYS.ALL_TRIGGERS A, SYS.ALL_TRIGGER_COLS B WHERE A.OWNER = B.TRIGGER_OWNER(+) AND A.TRIGGER_NAME = B.TRIGGER_NAME(+) AND A.OWNER = ? AND A.TRIGGER_NAME = ?";
    }

    private static void parseBaseType(String s, Trigger trigger) {
        Trigger.BaseType baseType = null;
        if (s != null) {
            s = s.trim();
            baseType = Trigger.BaseType.valueOf((String)s);
        }
        trigger.setBaseType(baseType);
    }

    private static void parseTriggerType(String s, Trigger trigger) {
        switch (trigger.getBaseType()) {
            case VIEW: {
                if (!"INSTEAD OF".equals(s)) break;
                trigger.setTiming(Trigger.Timing.INSTEAD_OF);
                break;
            }
            case TABLE: {
                if ("BEFORE STATEMENT".equals(s)) {
                    trigger.setTiming(Trigger.Timing.BEFORE);
                    trigger.setStatementLevel(true);
                    break;
                }
                if ("BEFORE EACH ROW".equals(s)) {
                    trigger.setTiming(Trigger.Timing.BEFORE);
                    trigger.setStatementLevel(false);
                    break;
                }
                if ("AFTER STATEMENT".equals(s)) {
                    trigger.setTiming(Trigger.Timing.AFTER);
                    trigger.setStatementLevel(true);
                    break;
                }
                if (!"AFTER EACH ROW".equals(s)) break;
                trigger.setTiming(Trigger.Timing.AFTER);
                trigger.setStatementLevel(false);
                break;
            }
            case SCHEMA: 
            case DATABASE: {
                if ("BEFORE EVENT".equals(s)) {
                    trigger.setTiming(Trigger.Timing.BEFORE);
                    break;
                }
                if (!"AFTER EVENT".equals(s)) break;
                trigger.setTiming(Trigger.Timing.AFTER);
                break;
            }
        }
    }

    private static void parseTriggeringEvent(String s, Trigger t) {
        ArrayList<String> events = new ArrayList<String>();
        if (s != null) {
            StringTokenizer tkn = new StringTokenizer(s, " ");
            while (tkn.hasMoreTokens()) {
                String evt = tkn.nextToken();
                if ("OR".equalsIgnoreCase(evt)) continue;
                events.add(evt);
            }
        }
        t.setEvents(events.toArray(new String[events.size()]));
    }

    private static void parseOwnerAndName(Schema owner, String name, Trigger t, DBObjectProvider pro) {
        SchemaObject obj = null;
        String baseType = "TABLE";
        switch (t.getBaseType()) {
            case DATABASE: {
                break;
            }
            case SCHEMA: {
                t.setBaseObjectID(owner.getID());
                break;
            }
            case VIEW: {
                baseType = "VIEW";
            }
            case TABLE: {
                try {
                    obj = pro.getObject(baseType, owner, name);
                }
                catch (DBException e) {
                    Assert.printStackTrace();
                    return;
                }
                if (obj == null) break;
                t.setBaseObjectID(obj.getID());
            }
        }
    }

    private static void parseReferencingNames(String s, Trigger t) {
        if (s != null) {
            String[] names = new String[2];
            boolean foundAs = false;
            int idx = -1;
            StringTokenizer tkn = new StringTokenizer(s, " ");
            while (tkn.hasMoreTokens()) {
                String value = tkn.nextToken();
                if (foundAs) {
                    if (idx != -1) {
                        names[idx] = value;
                    }
                    idx = -1;
                    foundAs = false;
                    continue;
                }
                if ("AS".equals(value)) {
                    foundAs = true;
                    continue;
                }
                if ("OLD".equals(value)) {
                    idx = 0;
                    continue;
                }
                if ("NEW".equals(value)) {
                    idx = 1;
                    continue;
                }
                idx = -1;
            }
            if (!"OLD".equals(names[0])) {
                t.setReferencingOldAs(names[0]);
            }
            if (!"NEW".equals(names[1])) {
                t.setReferencingNewAs(names[1]);
            }
        }
    }

    private final String getSource(final Trigger trg) throws DBException {
        String result = null;
        final StringBuffer buf = new StringBuffer();
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)trg, "SELECT /*OracleDictionaryQueries.ALL_TRIGGER_SOURCE_QUERY*/\n       TEXT FROM SYS.ALL_SOURCE WHERE TYPE = 'TRIGGER' AND OWNER = ? AND NAME = ? ORDER BY LINE", trg.getSchema(), trg);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        String line = rs.getString(1);
                        if (line != null) {
                            buf.append(line);
                            if (line.endsWith("\n")) continue;
                            buf.append('\n');
                            continue;
                        }
                        buf.append('\n');
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)trg, ex);
                }
            }
        };
        wrap.executeQuery(r);
        if (buf.length() > 0) {
            result = buf.toString();
        }
        if (result == null) {
            DDL ddl = this.getProvider().getDescriptor().getDDLGenerator((DBObjectProvider)this.getProvider()).getCreateDDL(new DDLOptions(false, false), new DBObject[]{trg});
            result = ddl.toString();
        }
        StringBuilder sb = new StringBuilder("CREATE OR REPLACE\n");
        sb.append(result.trim());
        result = sb.toString();
        return result;
    }
}

