/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddl;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import oracle.javatools.db.AbstractIncrementer;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ddl.BundleDDLGenerator;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDatabaseDescriptor;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.ora.OracleTablespaceUtil;
import oracle.javatools.db.ora.ddl.OracleDDLSupport;
import oracle.javatools.db.ora.ddl.OracleDDLType;
import oracle.javatools.db.ora.ddl.OracleStatementType;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.ModelUtil;

public class OracleDDLGenerator
extends BundleDDLGenerator<OracleDDLType> {
    private final int m_version;

    public OracleDDLGenerator(Class<? extends OracleDatabase> oraClz, DBObjectProvider pro) {
        this(oraClz, OracleDatabaseDescriptor.getDatabaseVersion(oraClz), pro);
    }

    public OracleDDLGenerator(Class<? extends OracleDatabase> oraClz, int version, DBObjectProvider pro) {
        super(oraClz, pro, OracleDDLSupport.getInstance().getBundles(oraClz, version));
        this.registerTokens();
        this.m_version = version;
    }

    protected OracleDDLType getDDLType(String key) {
        return OracleDDLType.getDDLType((String)key);
    }

    private int getDatabaseVersion() {
        return this.m_version;
    }

    protected void registerTokens() {
        this.registerSimpleDropDDL("FUNCTION");
        this.registerSimpleDropDDL("SEQUENCE");
        this.registerSimpleDropDDL("MATERIALIZED VIEW");
        this.registerSimpleDropDDL("PROCEDURE");
        this.registerSimpleDropDDL("TRIGGER");
        this.registerSimpleDropDDL("PACKAGE");
        this.registerSimpleDropDDL("PACKAGE BODY");
        this.registerSimpleDropDDL("TYPE BODY");
        for (Map.Entry<String, TokenGenerator> entry : OracleDDLSupport.getInstance().getGlobalTokenGenerators().entrySet()) {
            this.registerTokenGenerator(entry.getKey(), entry.getValue());
        }
        this.registerTopLevelChild("TABLE", "indexes", "INDEX");
        this.registerTopLevelChild("MATERIALIZED VIEW", "indexes", "INDEX");
    }

    protected final void registerSimpleDropDDL(String type) {
        this.registerDropDDL(type, OracleDDLSupport.getInstance().getSimpleDropDDL(), (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.DROP));
    }

    protected DDL<OracleDDLType> finish(DDLOptions options, DDL<OracleDDLType> ddl) {
        String spoolFile;
        if (ddl != null) {
            ddl.remove((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.NOOP));
        }
        if (ModelUtil.hasLength((String)(spoolFile = options.getSpoolFile())) && ddl != null && ddl.get((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SPOOLON)).isEmpty()) {
            ddl.append((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SPOOLON), MessageFormat.format("SPOOL {0}\n", spoolFile));
            ddl.append((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SPOOLOFF), "SPOOL OFF");
        }
        if (!(!options.isSqlBlankLines() || ddl == null || ddl.get((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.CMT)).isEmpty() && ddl.get((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.CMC)).isEmpty())) {
            ddl.append((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SET_SQLBLANKLINES_ON), "SET SQLBLANKLINES ON");
        }
        return super.finish(options, ddl);
    }

    public boolean supportsProperty(Class<? extends DBObject> objClz, String prop) {
        boolean supportsProperty = super.supportsProperty(objClz, prop);
        if (Table.class.isAssignableFrom(objClz) && "PARTITIONED TABLE".equals(Property.stripProperties((String)prop))) {
            supportsProperty = this.supportsProperty(objClz, "OracleTablePartitions");
        }
        return supportsProperty;
    }

    public boolean canCreateProperty(SystemObject obj, String prop) {
        boolean supportsProperty = super.canCreateProperty(obj, prop);
        if (supportsProperty) {
            prop = Property.stripProperties((String)prop);
            if (obj instanceof Tablespace) {
                Tablespace tbsp = (Tablespace)obj;
                Tablespace.TablespaceType tbspType = (Tablespace.TablespaceType)tbsp.getProperty("TablespaceType");
                String propsPath = "OracleTablespaceProperties";
                Tablespace.TablespaceType onlyThisType = OracleTablespaceUtil.getTypeSpecificProperties().get(prop);
                if (onlyThisType != null) {
                    boolean bl = supportsProperty = onlyThisType == tbspType;
                    if (supportsProperty && prop.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "OracleStorageProperties"}))) {
                        OracleTablespaceProperties otp = (OracleTablespaceProperties)tbsp.getProperty("OracleTablespaceProperties");
                        supportsProperty = otp == null || otp.getExtentManagementType() != OracleTablespaceProperties.ExtentManagementType.LOCAL;
                    }
                } else if (prop.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "autoAllocate"})) || prop.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "uniformSize"}))) {
                    OracleTablespaceProperties otp = (OracleTablespaceProperties)tbsp.getProperty("OracleTablespaceProperties");
                    supportsProperty = otp != null && otp.getExtentManagementType() == OracleTablespaceProperties.ExtentManagementType.LOCAL;
                }
            } else if (obj instanceof Table) {
                Table table = (Table)obj;
                Table.TableType tableType = (Table.TableType)table.getProperty("TableType");
                if (prop.contains("OracleInMemoryProperties") || prop.contains("OracleInMemoryColumnProperties")) {
                    supportsProperty = tableType == Table.TableType.NORMAL;
                } else if (prop.endsWith("virtualExpressionSource")) {
                    supportsProperty = tableType.equals((Object)Table.TableType.NORMAL);
                } else if (prop.equals(Property.createPath((String[])new String[]{"OracleTableProperties", "tableCompression"}))) {
                    supportsProperty = tableType == Table.TableType.NORMAL;
                } else if (prop.startsWith("OracleExternalTableProperties")) {
                    supportsProperty = tableType == Table.TableType.EXTERNAL;
                } else if (prop.startsWith("OracleIndexOrganizedTableProperties")) {
                    supportsProperty = tableType == Table.TableType.INDEX_ORGANIZED;
                } else if (prop.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions"}))) {
                    OracleTablePartitions.PartitionType partitionType;
                    OracleTablePartitions partitions = (OracleTablePartitions)obj.getProperty("OracleTablePartitions");
                    OracleTablePartitions.PartitionType partitionType2 = partitionType = partitions == null ? null : partitions.getPartitionType();
                    if (prop.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions", "referenceConstraintID"}))) {
                        supportsProperty = partitionType == OracleTablePartitions.PartitionType.REFERENCE;
                    } else if (prop.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions", "partitionColumns"}))) {
                        supportsProperty = partitionType != null && partitionType != OracleTablePartitions.PartitionType.REFERENCE;
                    } else if (prop.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions", "subpartitionModel", "partitionType"})) || prop.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions", "subpartitionModel", "partitionColumns"}))) {
                        supportsProperty = partitionType != null && partitionType != OracleTablePartitions.PartitionType.REFERENCE && partitionType != OracleTablePartitions.PartitionType.HASH;
                    } else if (prop.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions", "partitions", "values"})) || prop.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions", "partitions", "valuesLessThan"}))) {
                        supportsProperty = partitionType != OracleTablePartitions.PartitionType.REFERENCE;
                    } else if (prop.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions", "partitions", "segmentAttributes"}))) {
                        supportsProperty = partitionType != OracleTablePartitions.PartitionType.HASH || prop.endsWith("tablespaceID") || prop.endsWith("segmentAttributes");
                    } else if (prop.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions", "subpartitionModel", "partitions", "segmentAttributes"}))) {
                        OracleTablePartitions subpartitions = partitions.getSubpartitionModel();
                        supportsProperty = subpartitions == null || prop.endsWith("tablespaceID") || prop.endsWith("segmentAttributes");
                    }
                } else if (tableType == Table.TableType.EXTERNAL) {
                    if (prop.startsWith("constraints") || prop.startsWith("indexes") || prop.startsWith("OracleTablePartitions") || prop.startsWith("OracleStorageProperties") || prop.equals("Comment") || prop.equals(Property.createPath((String[])new String[]{"columns", "notNull"})) || prop.equals(Property.createPath((String[])new String[]{"columns", "default"})) || prop.equals(Property.createPath((String[])new String[]{"columns", "Comment"}))) {
                        supportsProperty = false;
                    }
                } else if (tableType == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP) {
                    if (prop.startsWith("OracleTablePartitions")) {
                        supportsProperty = false;
                    } else if (prop.startsWith("OracleStorageProperties")) {
                        supportsProperty = this.getDatabaseVersion() >= 110 ? prop.equals("OracleStorageProperties") || prop.equals(Property.createPath((String[])new String[]{"OracleStorageProperties", "tablespaceID"})) : false;
                    }
                }
            } else if (obj instanceof Index) {
                Index index = (Index)obj;
                Index.IndexType indexType = index.getIndexType();
                if (prop.equals("reverse")) {
                    Table parent = index.getTable();
                    supportsProperty = parent != null && parent.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED ? false : indexType == Index.IndexType.NORMAL || indexType == Index.IndexType.UNIQUE;
                } else if (prop.equals("domainIndextype") || prop.equals("domainIndextypeParameters")) {
                    supportsProperty = indexType == Index.IndexType.DOMAIN;
                } else if (prop.equals("keyCompression")) {
                    if (indexType == Index.IndexType.DOMAIN || indexType == Index.IndexType.BITMAP) {
                        supportsProperty = false;
                    }
                } else if (prop.startsWith(Property.createPath((String[])new String[]{"OracleIndexPartitions", "partitions", "subpartitions", "partitions", "segmentAttributes"}))) {
                    supportsProperty = prop.endsWith("segmentAttributes") || prop.endsWith("tablespaceID");
                }
            }
        } else if (obj instanceof Table && "PARTITIONED TABLE".equals(prop)) {
            supportsProperty = this.canCreateProperty(obj, "OracleTablePartitions");
        }
        return supportsProperty;
    }

    public Collection getAllowedPropertyValues(DBObject originalObject, DBObject updatedObject, String property) {
        Collection<Object> retval = null;
        int dbVersion = this.getDatabaseVersion();
        String subPartitionType = Property.createPath((String[])new String[]{"OracleTablePartitions", "subpartitionModel", "partitionType"});
        if (updatedObject instanceof Relation && property.equals(subPartitionType)) {
            OracleTablePartitions otp = (OracleTablePartitions)updatedObject.getProperty("OracleTablePartitions");
            retval = otp != null ? this.getSubPartitionTypes() : Collections.emptyList();
        } else if (updatedObject instanceof Relation && property.equals(Property.createPath((String[])new String[]{"OracleTablePartitions", "partitionType"}))) {
            DBObject parent = updatedObject.getParent();
            if (parent instanceof OracleTablePartitions) {
                retval = this.getSubPartitionTypes();
            } else {
                ArrayList vals = new ArrayList();
                vals.add(OracleTablePartitions.PartitionType.HASH);
                vals.add(OracleTablePartitions.PartitionType.LIST);
                vals.add(OracleTablePartitions.PartitionType.RANGE);
                if (dbVersion >= 110 && !(updatedObject instanceof MaterializedView) && updatedObject.getProperty("TableType") != Table.TableType.INDEX_ORGANIZED) {
                    vals.add(OracleTablePartitions.PartitionType.REFERENCE);
                }
                retval = vals;
            }
        } else if (property.equals("LOBCache")) {
            Table parent = (Table)DBUtil.findParentOfType((DBObject)updatedObject, Table.class);
            if (parent != null && parent.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED) {
                retval = Arrays.asList(LOBDescriptor.LOBCache.NOCACHE, LOBDescriptor.LOBCache.CACHE_READS);
            }
        } else if (property.equals("onDeleteAction")) {
            retval = Arrays.asList(FKConstraint.ReferentialAction.NO_ACTION, FKConstraint.ReferentialAction.CASCADE, FKConstraint.ReferentialAction.SET_NULL);
        } else if ((updatedObject instanceof Tablespace || updatedObject instanceof OracleTablespaceProperties) && originalObject == null && Property.getLastProperty((String)property).equals("onlineStatus")) {
            ArrayList vals = new ArrayList();
            vals.add(null);
            vals.add(OracleTablespaceProperties.OnlineStatus.ONLINE);
            vals.add(OracleTablespaceProperties.OnlineStatus.OFFLINE);
            retval = vals;
        } else {
            String lastProperty = Property.getLastProperty((String)property);
            if ("tableCompression".equals(lastProperty) || "defaultTableCompression".equals(lastProperty)) {
                ArrayList vals = new ArrayList();
                if (originalObject == null) {
                    vals.add(null);
                }
                vals.add(OracleTableProperties.OracleTableCompression.NOCOMPRESS);
                vals.add(OracleTableProperties.OracleTableCompression.COMPRESS);
                if (dbVersion == 110) {
                    vals.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ALL_OPERATIONS);
                    vals.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_DIRECT_LOAD_OPERATIONS);
                } else if (dbVersion == 112) {
                    vals.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_OLTP);
                    vals.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_LOW);
                    vals.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_HIGH);
                    vals.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_LOW);
                    vals.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_HIGH);
                } else if (dbVersion >= 120) {
                    vals.add(OracleTableProperties.OracleTableCompression.ROW_STORE_COMPRESS_ADVANCED);
                    vals.add(OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_ROW_LEVEL_LOCKING);
                    vals.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_LOW);
                    vals.add(OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_FOR_QUERY_LOW_ROW_LEVEL_LOCKING);
                    vals.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_HIGH);
                    vals.add(OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_FOR_QUERY_HIGH_ROW_LEVEL_LOCKING);
                    vals.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_LOW);
                    vals.add(OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_FOR_ARCHIVE_LOW_ROW_LEVEL_LOCKING);
                    vals.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_HIGH);
                    vals.add(OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_FOR_ARCHIVE_HIGH_ROW_LEVEL_LOCKING);
                }
                retval = vals;
            } else if ("constraintType".equals(lastProperty)) {
                Relation rel = (Relation)DBUtil.findParentOfType((DBObject)updatedObject, Relation.class);
                Object ttype = rel == null ? null : rel.getProperty("TableType");
                boolean temp = ttype == Table.TableType.TRANSACTION_TEMP || ttype == Table.TableType.SESSION_TEMP;
                ArrayList vals = new ArrayList();
                vals.add("PKConstraint");
                vals.add("UniqueConstraint");
                vals.add("CheckConstraint");
                if (!temp) {
                    vals.add("FKConstraint");
                }
                retval = vals;
            } else if ("accessDriverType".equals(lastProperty)) {
                ArrayList vals = new ArrayList();
                vals.add("ORACLE_LOADER");
                vals.add("ORACLE_DATAPUMP");
                if (dbVersion >= 12102) {
                    vals.add("ORACLE_BIGDATA");
                    vals.add("ORACLE_HIVE");
                    vals.add("ORACLE_HDFS");
                }
                retval = vals;
            }
        }
        if (retval == null) {
            retval = super.getAllowedPropertyValues(originalObject, updatedObject, property);
        }
        return retval;
    }

    public Collection<String> getRestrictingProperties(Class<? extends SystemObject> objClz, String property) {
        ArrayList<String> retval = new ArrayList<String>();
        if (Table.class.isAssignableFrom(objClz)) {
            boolean tableOnly = objClz.equals(Table.class);
            if (tableOnly && (property.equals("Comment") || property.startsWith("OracleStorageProperties") || property.startsWith("OracleTableProperties"))) {
                retval.add("TableType");
            } else if (tableOnly && property.equals(Property.createPath((String[])new String[]{"OracleExternalTableProperties", "accessParameters"}))) {
                retval.add(Property.createPath((String[])new String[]{"OracleExternalTableProperties", "accessDriverType"}));
            } else if (property.equals(Property.createPath((String[])new String[]{"OracleTablePartitions", "partitionColumns"})) || property.equals(Property.createPath((String[])new String[]{"OracleTablePartitions", "referenceConstraintID"})) || property.equals(Property.createPath((String[])new String[]{"OracleTablePartitions", "partitionColumns"})) || property.equals(Property.createPath((String[])new String[]{"OracleTablePartitions", "subpartitionModel", "partitionType"})) || property.equals(Property.createPath((String[])new String[]{"OracleTablePartitions", "subpartitionModel", "partitionColumns"}))) {
                retval.add(Property.createPath((String[])new String[]{"OracleTablePartitions", "partitionType"}));
            }
        } else if (objClz.equals(Index.class)) {
            if (property.equals("reverse") || property.equals("keyCompression") || property.equals("domainIndextype") || property.equals("domainIndextypeParameters")) {
                retval.add("indexType");
            } else if (property.equals(Property.createPath((String[])new String[]{"OracleIndexPartitions", "globalPartitionColumns"}))) {
                retval.add("columnExpressions");
            }
        } else if (objClz.equals(Tablespace.class)) {
            if (OracleTablespaceUtil.getTypeSpecificProperties().containsKey(property)) {
                retval.add("TablespaceType");
            }
            if (property.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "OracleStorageProperties"})) || property.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "autoAllocate"})) || property.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "uniformSize"}))) {
                retval.add(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "extentManagementType"}));
            }
        }
        return retval;
    }

    private Collection<OracleTablePartitions.PartitionType> getSubPartitionTypes() {
        ArrayList<OracleTablePartitions.PartitionType> retval = new ArrayList<OracleTablePartitions.PartitionType>();
        int dbVersion = this.getDatabaseVersion();
        retval.add(OracleTablePartitions.PartitionType.HASH);
        retval.add(OracleTablePartitions.PartitionType.LIST);
        if (dbVersion >= 110) {
            retval.add(OracleTablePartitions.PartitionType.RANGE);
        }
        return retval;
    }

    protected boolean canCreate(Class<? extends SystemObject> objClass, String prop) {
        boolean canCreate = super.canCreate(objClass, prop);
        if (!canCreate) {
            if (Table.class.isAssignableFrom(objClass) && Property.stripProperties((String)prop).equals("PARTITIONED TABLE")) {
                canCreate = this.canCreate(objClass, "OracleTablePartitions");
            } else if (Table.class.equals(objClass)) {
                canCreate = this.isSupportedColumnSequenceProperty(prop, "columns");
            }
        }
        return canCreate;
    }

    protected boolean canChangeWithAlter(SystemObject orig, SystemObject update, String prop) {
        boolean canChange = super.canChangeWithAlter(orig, update, prop);
        if (canChange && update instanceof MaterializedViewLog) {
            MaterializedViewLog mvl = (MaterializedViewLog)update;
            if ("objectIdLogged".equals(prop) && Boolean.FALSE.equals(mvl.getObjectIdLogged()) || "primaryKeyLogged".equals(prop) && Boolean.FALSE.equals(mvl.getPrimaryKeyLogged()) || "rowidLogged".equals(prop) && Boolean.FALSE.equals(mvl.getRowidLogged()) || "sequenceLogged".equals(prop) && Boolean.FALSE.equals(mvl.getSequenceLogged())) {
                canChange = false;
            }
        }
        return canChange;
    }

    private boolean isSupportedColumnSequenceProperty(String prop, String base) {
        String[] path;
        String toTest = null;
        if (base == null) {
            toTest = prop;
        } else if (base != null && (path = Property.getProperties((String)prop)).length == 2 && base.equals(path[0])) {
            toTest = path[1];
        }
        return toTest != null && "AUTO_GENERATED_SEQUENCE".equals(toTest) || "AUTO_GENERATED_SEQUENCE_TRIGGER".equals(toTest) || "ColumnSequenceExpander.TriggerNullCheck".equals(toTest);
    }

    public Object getImplicitDefaultValue(DBObject obj, String property) {
        Object retval = null;
        if (obj instanceof MaterializedView && "Comment".equals(Property.stripProperties((String)property))) {
            retval = "snapshot table for snapshot " + DBUtil.getFullyQualifiedName((DBObject)obj, (boolean)true);
        } else if (obj instanceof AbstractIncrementer) {
            if ("maxValue".equals(property)) {
                int ver = this.getDatabaseVersion();
                retval = ver >= 111 ? new BigInteger("9999999999999999999999999999") : new BigInteger("999999999999999999999999999");
            } else if ("minValue".equals(property)) {
                retval = BigInteger.ONE;
            }
        }
        return retval;
    }

    protected Nullable.NullBehaviour getNullBehaviour(PropertyInfo info, boolean edit) {
        String propName = info.getPropertyName();
        Nullable.NullBehaviour retval = "startWith".equals(propName) ? Nullable.NullBehaviour.NULL_MEANS_NOT_SPECIFIED_AND_IGNORE : (this.isSupportedColumnSequenceProperty(propName, null) ? Nullable.NullBehaviour.NULL_MEANS_NOT_SPECIFIED_AND_IGNORE : super.getNullBehaviour(info, edit));
        return retval;
    }
}

