/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import java.util.HashMap;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.owb.OMBPropsStatementBuilder;
import oracle.javatools.db.ora.owb.OMBSinglePropertyResolver;

class OMBIndexPartitioningPropsBuilder
extends OMBPropsStatementBuilder<OracleIndexPartitions> {
    public OMBIndexPartitioningPropsBuilder(Object forOtp) {
        super((OracleIndexPartitions)forOtp);
        this.registerPropertyMappings();
        this.buildSetProperties();
    }

    @Override
    public void registerPropertyMappings() {
        this.registerPropertyMapping("partitionType", new OMBIndexPartitionTypePropResolver());
        HashMap<String, String> typeMap = new HashMap<String, String>();
        typeMap.put("GLOBAL_RANGE", "RANGE");
        typeMap.put("GLOBAL_HASH", "HASH");
        typeMap.put("LOCAL_HASH", "HASH");
        this.registerSubstitutionValues("TYPE", typeMap);
        this.registerPropertyMapping("globalHashQuantity", "HASH_QUANTITY");
    }

    public final class OMBIndexPartitionTypePropResolver
    implements OMBSinglePropertyResolver {
        @Override
        public String resolvePropertyValue() {
            OracleIndexPartitions oip = (OracleIndexPartitions)OMBIndexPartitioningPropsBuilder.this.getContextObject();
            if (oip.getPartitionType().equals((Object)OracleTablePartitions.PartitionType.HASH) && oip.getGlobalHashQuantity() != null) {
                return "HASH BY QUANTITY";
            }
            return oip.getPartitionType().toString();
        }

        @Override
        public String resolvePropertyName() {
            return "TYPE";
        }
    }
}

