/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import java.util.HashMap;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.owb.OMBPropsStatementBuilder;
import oracle.javatools.db.ora.owb.OMBSinglePropertyResolver;
import oracle.javatools.db.ora.owb.OMBStoragePropsBuilder;
import oracle.javatools.db.property.Property;

class OMBMatViewPropsBuilder
extends OMBStoragePropsBuilder<MaterializedView> {
    public OMBMatViewPropsBuilder(Object forMV) {
        super((MaterializedView)forMV, Property.createPath((String[])new String[]{"properties", "OracleStorageProperties"}));
        this.registerPropertyMappings();
        this.buildSetProperties();
    }

    @Override
    public void registerPropertyMappings() {
        super.registerPropertyMappings();
        this.registerPropertyMapping("buildType", "BUILD");
        if (((MaterializedView)this.getContextObject()).getRefreshMode().equals((Object)MaterializedView.RefreshMode.SPECIFY)) {
            this.registerPropertyMapping("firstRefresh", new OMBStartsWithPropResolver());
            this.registerPropertyMapping("interval", "NEXTDATE");
        }
        String parallelProp = Property.createPath((String[])new String[]{"properties", "OracleTableProperties", "parallelDegree"});
        this.registerPropertyMapping(parallelProp, new String[]{"PARALLEL_ACCESS_MODE", "PARALLEL_DEGREE"});
        HashMap<String, String> parallelMap = new HashMap<String, String>();
        parallelMap.put("$DEFAULT$", "PARALLEL");
        this.registerSubstitutionValues("PARALLEL_ACCESS_MODE", (HashMap)parallelMap);
        this.registerPropertyMapping("queryRewrite", "QUERY_REWRITE");
        HashMap<String, String> rewriteMap = new HashMap<String, String>();
        rewriteMap.put("true", "ENABLE");
        rewriteMap.put("false", "DISABLE");
        this.registerSubstitutionValues("QUERY_REWRITE", (HashMap)rewriteMap);
        this.registerPropertyMapping("refreshMethod", "REFRESH");
        this.registerPropertyMapping("refreshMode", "REFRESH_ON");
        HashMap<String, String> refreshOnMap = new HashMap<String, String>();
        refreshOnMap.put("NEVER", "$IGNORE$");
        refreshOnMap.put("SPECIFY", "$IGNORE$");
        this.registerSubstitutionValues("REFRESH_ON", (HashMap)refreshOnMap);
        this.registerPropertyMapping("useNoIndex", "USING_INDEX_MODE");
        HashMap<String, String> usingIndexMap = new HashMap<String, String>();
        usingIndexMap.put("true", "USING_NO_INDEX");
        usingIndexMap.put("false", "USING_INDEX");
        this.registerSubstitutionValues("USING_INDEX_MODE", (HashMap)usingIndexMap);
        this.registerPropertyMapping("rollbackSegmentType", "ROLLBACK");
        HashMap<String, String> rollbackTypeMap = new HashMap<String, String>();
        rollbackTypeMap.put("MASTER", "DEFAULT MASTER");
        rollbackTypeMap.put("LOCAL", "DEFAULT LOCAL");
        rollbackTypeMap.put("NONE", "NONE");
        this.registerSubstitutionValues("ROLLBACK", (HashMap)rollbackTypeMap);
        this.registerPropertyMapping("rollbackSegmentName", new OMBRollbackSegPropResolver());
        this.registerPropertyMapping("viewText", new OMBPropsStatementBuilder.OMBViewQueryPropResolver(this, (Relation)((MaterializedView)this.getContextObject())));
        String base = Property.createPath((String[])new String[]{"properties", "MatViewIndexStorageProperties"});
        this.registerPropertyMapping(Property.createPath((String[])new String[]{base, "bufferMode"}), "DEFAULTINDEXBUFFERPOOL");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{base, "freelistGroups"}), "DEFAULTINDEXFREELISTGROUPS");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{base, "freelists"}), "DEFAULTINDEXFREELISTS");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{base, "initialExtent"}), "DEFAULTINDEXINITIAL");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{base, "initrans"}), "DEFAULTINDEXINITRANS");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{base, "maxtrans"}), "DEFAULTINDEXMAXTRANS");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{base, "maxExtent"}), "DEFAULTINDEXMAXEXTENTS");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{base, "minExtent"}), "DEFAULTINDEXMINEXTENTS");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{base, "nextExtent"}), "DEFAULTINDEXNEXT");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{base, "percentIncrease"}), "DEFAULTINDEXPCTINCREASE");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{base, "tablespaceID", "name"}), "DEFAULT_INDEX_TABLESPACE");
    }

    public final class OMBStartsWithPropResolver
    implements OMBSinglePropertyResolver {
        @Override
        public String resolvePropertyValue() {
            MaterializedView mv = (MaterializedView)OMBMatViewPropsBuilder.this.getContextObject();
            StringBuilder buffer = new StringBuilder();
            if (mv.getFirstRefresh() != null) {
                buffer.append(mv.getFirstRefresh());
            }
            return buffer.toString();
        }

        @Override
        public String resolvePropertyName() {
            return "STARTWITH";
        }
    }

    public final class OMBRollbackSegPropResolver
    implements OMBSinglePropertyResolver {
        @Override
        public String resolvePropertyValue() {
            return ((MaterializedView)OMBMatViewPropsBuilder.this.getContextObject()).getRollbackSegmentName();
        }

        @Override
        public String resolvePropertyName() {
            if (((MaterializedView)OMBMatViewPropsBuilder.this.getContextObject()).getRollbackSegmentType().equals((Object)MaterializedView.RollbackSegmentType.LOCAL)) {
                return "ROLLBACKSEGMENTLOCAL";
            }
            return "ROLLBACKSEGMENTMASTER";
        }
    }
}

