/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.sql.Keywords;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilder;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.ora.sql.ParserRules;
import oracle.javatools.db.ora.sxml.SQLFragmentSXMLGenerator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.FunctionUsage;
import oracle.javatools.db.sql.GroupByExpression;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.token.Token;

public final class ExpressionContext
implements Keywords,
ParserRules {
    private final DBObjectProvider m_provider;
    private final OracleSQLQueryBuilder m_queryBuilder;
    private final SQLQuery m_query;
    private final Object m_queryContext;
    private final SQLFragment m_creating;
    private final Schema m_defaultSchema;
    private final OracleSQLQueryBuilderHelper m_helper;

    ExpressionContext(OracleSQLQueryBuilder builder, SQLQuery query, DBObjectProvider pro, Schema defaultSchema, OracleSQLQueryBuilderHelper helper, Object queryContext, SQLFragment creating) {
        this.m_queryBuilder = builder;
        this.m_query = query;
        this.m_provider = pro;
        this.m_defaultSchema = defaultSchema;
        this.m_helper = helper;
        this.m_queryContext = queryContext;
        this.m_creating = creating;
    }

    public Object getQueryContext() {
        return this.m_queryContext;
    }

    public SQLFragment getCreating() {
        return this.m_creating;
    }

    public OracleSQLQueryBuilderHelper getHelper() {
        return this.m_helper;
    }

    public SQLQuery getQuery() {
        return this.m_query;
    }

    public OracleSQLQueryBuilder getQueryBuilder() {
        return this.m_queryBuilder;
    }

    public DBObjectProvider getProvider() {
        return this.m_provider;
    }

    public Schema getDefaultSchema() {
        return this.m_defaultSchema;
    }

    public String getDefaultSchemaName() {
        return this.m_defaultSchema == null ? null : this.m_defaultSchema.getName();
    }

    public FromObject findFromObject(String alias, FromObject creating) {
        FromObject from = this.m_queryBuilder.getFromObject(alias, creating);
        if (from == null) {
            for (OracleSQLQueryBuilder parent = (OracleSQLQueryBuilder)this.m_queryBuilder.getParentBuilder(); parent != null && from == null; parent = (OracleSQLQueryBuilder)parent.getParentBuilder()) {
                from = parent.getFromObject(alias);
            }
        }
        return from;
    }

    public SQLFragment[] getArgList(Object func, ParseNode node) throws SQLQueryException {
        List<ParseNode> kids = this.m_helper.getOrderedChildren(node);
        int openParenIndex = this.m_helper.getKeywordIndex(kids, "(");
        int closeParenIndex = this.m_helper.getKeywordIndex(kids, ")");
        if (closeParenIndex == -1) {
            closeParenIndex = kids.size();
        }
        int start = openParenIndex + 1;
        return this.getArgList(func, kids, start, closeParenIndex);
    }

    public SQLFragment[] getArgList(Object func, List<ParseNode> os, int start, int finish) throws SQLQueryException {
        boolean hasTrimFrom;
        SQLFragment trimChar = null;
        int fromIdx = this.m_helper.getKeywordIndex(os, "FROM");
        boolean bl = hasTrimFrom = fromIdx != -1 && fromIdx < finish;
        if (this.m_helper.isKeyword(os.get(start), "DISTINCT", "ALL")) {
            ++start;
        } else if (this.m_helper.isKeyword(os.get(start), "LEADING", "TRAILING", "BOTH")) {
            if (!this.m_helper.isKeyword(os.get(++start), "FROM")) {
                trimChar = this.createFragment(os.get(start), this.m_creating, func);
                ++start;
            }
            ++start;
        } else if (hasTrimFrom) {
            trimChar = this.createFragment(os.get(start), this.m_creating, func);
            ++start;
            ++start;
        }
        List<List<ParseNode>> pargs = this.m_helper.getCommaSeparatedList(os.subList(start, finish));
        if (finish == start + 1 && func instanceof GroupByExpression && GroupByExpression.GroupingType.GROUPING_SETS.equals((Object)((GroupByExpression)func).getGroupByType())) {
            pargs = this.m_helper.getCommaSeparatedList(os.get(start));
        }
        ArrayList<SQLFragment> args = new ArrayList<SQLFragment>();
        for (List<ParseNode> parg : pargs) {
            if (parg == null || parg.size() != 1) continue;
            SQLFragment arg = this.createFragment(parg.get(0), this.m_creating, func);
            args.add(arg);
        }
        if (trimChar != null) {
            args.add(trimChar);
        }
        SQLFragment[] argsL = args.toArray(new SQLFragment[args.size()]);
        return argsL;
    }

    private DBObjectID findObjectID(DBObject parent, PlSqlToken tk) {
        block9: {
            String tokVal;
            block8: {
                String[] types = new String[]{"FUNCTION", "PACKAGE", "TYPE"};
                tokVal = this.m_provider.getInternalName(tk.getSource(true));
                if (!(parent instanceof Schema)) break block8;
                for (String objType : types) {
                    SchemaObject so = null;
                    try {
                        so = this.m_provider.getObject(objType, (Schema)parent, tokVal);
                    }
                    catch (DBException e) {
                        so = null;
                    }
                    if (so == null) continue;
                    if (((PlSqlToken)tk.getNextCodeToken()).getType() == Token.Type.END_MARKER) {
                        return so.getID();
                    }
                    if (((PlSqlToken)tk.getNextCodeToken()).matches(".")) {
                        return this.findObjectID((DBObject)so, (PlSqlToken)tk.getNextCodeToken(2));
                    }
                    return null;
                }
                break block9;
            }
            if (parent == null) break block9;
            for (DBObject kid : parent.getOwnedObjects()) {
                if (kid.getName() == null || !kid.getName().equals(tokVal)) continue;
                if (((PlSqlToken)tk.getNextCodeToken()).getType() == Token.Type.END_MARKER) {
                    return kid.getID();
                }
                if (((PlSqlToken)tk.getNextCodeToken()).matches(".")) {
                    return this.findObjectID(kid, (PlSqlToken)tk.getNextCodeToken(2));
                }
                return null;
            }
        }
        return null;
    }

    public DBObjectID findIdForFunctionString(String str) {
        PlSqlToken startTk;
        DBObjectID retval = null;
        PlSqlToken tk = startTk = PlSqlTokenizer.tokenize((String)str, (String[])new String[0]);
        PlSqlToken endTk = null;
        while (tk.getType() != Token.Type.END_MARKER) {
            tk = (PlSqlToken)tk.getNextToken();
        }
        endTk = (PlSqlToken)tk.getPrevCodeToken();
        retval = this.findObjectID((DBObject)this.m_defaultSchema, startTk);
        if (retval == null) {
            try {
                Schema schema = this.m_provider.getSchema(this.m_provider.getInternalName(startTk.getSource(true)));
                if (schema != null && ((PlSqlToken)startTk.getNextCodeToken()).matches(".")) {
                    retval = this.findObjectID((DBObject)schema, (PlSqlToken)startTk.getNextCodeToken(2));
                }
            }
            catch (DBException e) {
                DBLog.getLogger((Object)this).fine(e.getMessage());
            }
        }
        if (retval == null) {
            String[] chunks = str.split("\\.");
            ReferenceID parId = null;
            for (String chunk : chunks) {
                Schema schema = parId == null ? this.m_defaultSchema : null;
                ReferenceID refId = new ReferenceID("UNSPECIFIED_TYPE", schema, chunk);
                refId.setProvider(this.m_provider);
                refId.setParent(parId);
                retval = refId;
                parId = refId;
            }
        }
        return retval;
    }

    public SQLFragment createFunction(String source, BuiltInFunction func, String distinctQualifierSource, boolean isDistinct, SQLFragment[] argsL) throws SQLQueryException {
        FunctionUsage retval = null;
        if (SQLFragmentSXMLGenerator.isInCompoundExpressionGroup(func.getName())) {
            retval = this.m_queryBuilder.createFunction(func.getName(), argsL, source);
            if (retval == null) {
                this.m_queryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_UNKNOWN_FUNC", (Object[])new Object[]{func})));
            }
            ((Function)retval).setDistinct(isDistinct);
            ((Function)retval).setDistinctSource(distinctQualifierSource);
        } else {
            retval = new FunctionUsage();
            retval.setObjectID(this.findIdForFunctionString(func.getName()));
            retval.setArguments(argsL);
        }
        return retval;
    }

    public List<List<ParseNode>> getCompoundExpression(List<ParseNode> kids, int start) {
        kids = this.m_helper.getOrderedChildren(kids.get(start));
        List<List<ParseNode>> pes = this.m_helper.getCommaSeparatedList(kids.subList(this.m_helper.getKeywordIndex(kids, "(") + 1, this.m_helper.getKeywordIndex(kids, ")")));
        return pes;
    }

    public ExpressionList createExpressionList(List<List<ParseNode>> pes, SQLFragment creating) throws SQLQueryException {
        SelectObject[] arguments = new SelectObject[pes.size()];
        int i = 0;
        for (List<ParseNode> n : pes) {
            ParseNode node = n.get(0);
            SQLFragment expr = this.createFragment(node, creating);
            String alias = null;
            if (n.size() > 1 && this.m_helper.isLeaf(n.get(1))) {
                alias = this.m_helper.getContent(n.get(1));
            }
            arguments[i] = new SelectObject(expr, alias);
            ++i;
        }
        ExpressionList retval = new ExpressionList((SQLFragment[])arguments);
        return retval;
    }

    public SQLFragment createFragment(ParseNode node, SQLFragment creating) throws SQLQueryException {
        return this.createFragment(node, creating, null);
    }

    public SQLFragment createFragment(ParseNode node, SQLFragment creating, Object queryContext) throws SQLQueryException {
        return this.m_queryBuilder.createFragment(node, creating, queryContext, this.m_helper);
    }
}

