/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.WindowFunction;

public class WindowFunctionBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        WindowFunction retval = null;
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        if (helper.isRule(node, "analytic_function")) {
            List<ParseNode> kids = helper.getOrderedChildren(node);
            String functionName = helper.getContent(kids.get(0));
            functionName = functionName.toUpperCase();
            ParseNode functionNode = node;
            if (helper.isRule(kids.get(0), "count")) {
                functionNode = kids.get(0);
                ArrayList<ParseNode> newKids = new ArrayList<ParseNode>();
                for (ParseNode kid : kids) {
                    newKids.addAll(helper.getOrderedChildren(kid));
                }
                kids.clear();
                kids.addAll(newKids);
                functionName = helper.getContent(kids.get(0));
                functionName = functionName.toUpperCase();
            }
            BuiltInFunction func = null;
            boolean grouping = false;
            DatabaseDescriptor desc = context.getProvider().getDescriptor();
            for (BuiltInFunction bif : desc.listBuiltInFunctions(functionName)) {
                if (func == null) {
                    func = bif;
                }
                if (!bif.isAggregate()) continue;
                grouping = true;
            }
            if (func != null) {
                WindowFunction windowFunction = new WindowFunction();
                windowFunction.setFunction(func.getName());
                windowFunction.setGrouping(grouping);
                if (helper.isKeyword(kids.get(2), "DISTINCT")) {
                    windowFunction.setGrouping(true);
                    windowFunction.setDistinct(true);
                    windowFunction.setDistinctSource(helper.getContent(kids.get(2)));
                } else if (helper.isKeyword(kids.get(2), "ALL")) {
                    windowFunction.setGrouping(true);
                    windowFunction.setDistinct(false);
                    windowFunction.setDistinctSource(helper.getContent(kids.get(2)));
                }
                SQLFragment[] args = context.getArgList(windowFunction, functionNode);
                windowFunction.setArguments(args);
                int i = helper.getKeywordIndex(kids, "WITHIN");
                if (i >= 0) {
                    this.processWithinGroup(kids, i, windowFunction, context);
                }
                if ((i = helper.getKeywordIndex(kids, "FROM")) >= 0) {
                    this.processFrom(kids, i, windowFunction, context);
                }
                if ((i = helper.getKeywordIndex(kids, "NULLS")) >= 0) {
                    this.processNulls(kids, i - 1, windowFunction, context);
                }
                if ((i = helper.getKeywordIndex(kids, "OVER")) >= 0) {
                    this.processOver(kids, i + 2, windowFunction, context);
                }
                if ((i = helper.getRuleIndex(kids, "over_clause")) >= 0) {
                    this.processOver(kids.get(i), windowFunction, context);
                }
                retval = windowFunction;
            }
        }
        return retval;
    }

    private void processOver(ParseNode overClause, WindowFunction windowFunction, ExpressionContext context) throws SQLQueryException {
        List<ParseNode> kids = context.getHelper().getOrderedChildren(overClause);
        this.processOver(kids, 2, windowFunction, context);
    }

    private void processOver(List<ParseNode> kids, int i, WindowFunction windowFunction, ExpressionContext context) throws SQLQueryException {
        ParseNode windowingClauseNode = null;
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        if (helper.isRule(kids.get(i), "analytic_clause", "query_partition_clause")) {
            ParseNode queryPartitionClauseNode = null;
            ParseNode orderByClauseNode = null;
            if (helper.isRule(kids.get(i), "query_partition_clause")) {
                queryPartitionClauseNode = kids.get(i);
            } else if (helper.isRule(kids.get(i), "order_by_clause")) {
                orderByClauseNode = kids.get(i);
            } else if (helper.isRule(kids.get(i), "windowing_clause")) {
                windowingClauseNode = kids.get(i);
            } else {
                List<ParseNode> kidskids = helper.getOrderedChildren(kids.get(i));
                for (ParseNode n : kidskids) {
                    if (helper.isRule(n, "query_partition_clause")) {
                        queryPartitionClauseNode = n;
                        continue;
                    }
                    if (helper.isRule(n, "order_by_clause")) {
                        orderByClauseNode = n;
                        continue;
                    }
                    if (!helper.isRule(n, "windowing_clause")) continue;
                    windowingClauseNode = n;
                }
            }
            if (queryPartitionClauseNode != null) {
                this.processQueryPartitionClause(windowFunction, queryPartitionClauseNode, context);
            }
            if (orderByClauseNode != null) {
                this.processOrderBy(windowFunction, orderByClauseNode, context);
            }
            ++i;
        }
        if (windowingClauseNode != null) {
            this.buildBounds(windowingClauseNode, windowFunction, context);
        }
    }

    private void processQueryPartitionClause(WindowFunction windowFunction, ParseNode queryPartitionClauseNode, ExpressionContext context) throws SQLQueryException {
        ExpressionList queryPartition = (ExpressionList)context.createFragment(queryPartitionClauseNode, (SQLFragment)windowFunction);
        windowFunction.setPartitionBy(queryPartition.getArguments());
    }

    private void processOrderBy(WindowFunction windowFunction, ParseNode orderByClauseNode, ExpressionContext context) throws SQLQueryException {
        ExpressionList orderBy = (ExpressionList)context.createFragment(orderByClauseNode, (SQLFragment)windowFunction);
        SQLFragment[] obargs = orderBy.getArguments();
        OrderByObject[] orderByObjects = new OrderByObject[obargs.length];
        for (int ia = 0; ia < obargs.length; ++ia) {
            orderByObjects[ia] = (OrderByObject)obargs[ia];
        }
        windowFunction.setOrderBy(orderByObjects);
    }

    private void buildBounds(ParseNode node, WindowFunction windowFunction, ExpressionContext context) throws SQLQueryException {
        int i;
        List<ParseNode> kids;
        WindowFunction.WindowFunctionBound[] bounds = null;
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        if (helper.isKeyword((kids = helper.getOrderedChildren(node)).get(i = 0), "ROWS")) {
            windowFunction.setClauseType(WindowFunction.ClauseType.ROWS);
        } else if (helper.isKeyword(kids.get(i), "RANGE")) {
            windowFunction.setClauseType(WindowFunction.ClauseType.RANGE);
        }
        int boundCount = 1;
        if (helper.isKeyword(kids.get(++i), "BETWEEN")) {
            boundCount = 2;
            ++i;
        }
        bounds = new WindowFunction.WindowFunctionBound[boundCount];
        for (int bi = 0; bi < boundCount; ++bi) {
            bounds[bi] = new WindowFunction.WindowFunctionBound();
            if (helper.isKeyword(kids.get(i), "UNBOUNDED") && helper.isKeyword(kids.get(i + 1), "PRECEDING")) {
                i += 2;
                bounds[bi].setBoundType(WindowFunction.BoundType.PRECEDING);
            } else if (helper.isKeyword(kids.get(i), "UNBOUNDED") && helper.isKeyword(kids.get(i + 1), "FOLLOWING")) {
                i += 2;
                bounds[bi].setBoundType(WindowFunction.BoundType.FOLLOWING);
            } else if (helper.isKeyword(kids.get(i), "CURRENT") && helper.isKeyword(kids.get(i + 1), "ROW")) {
                i += 2;
                bounds[bi].setBoundType(WindowFunction.BoundType.CURRENT_ROW);
            } else {
                SQLFragment expr = context.createFragment(kids.get(i), (SQLFragment)windowFunction);
                bounds[bi].setBoundExpr(new SQLFragment[]{expr});
                if (helper.isKeyword(kids.get(++i), "PRECEDING")) {
                    bounds[bi].setBoundType(WindowFunction.BoundType.PRECEDING);
                } else if (helper.isKeyword(kids.get(i), "FOLLOWING")) {
                    bounds[bi].setBoundType(WindowFunction.BoundType.FOLLOWING);
                }
                ++i;
            }
            if (i >= kids.size() || !helper.isKeyword(kids.get(i), "and")) continue;
            ++i;
        }
        windowFunction.setBounds((SQLFragment[])bounds);
    }

    private void processWithinGroup(List<ParseNode> kids, int index, WindowFunction windowFunction, ExpressionContext context) throws SQLQueryException {
        int i = index + 3;
        this.processOrderBy(windowFunction, kids.get(i), context);
    }

    private void processNulls(List<ParseNode> kids, int i, WindowFunction windowFunction, ExpressionContext context) {
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        if (helper.isKeyword(kids.get(i), "RESPECT")) {
            windowFunction.setNullPolicy(WindowFunction.NullPolicy.RESPECT);
        } else if (helper.isKeyword(kids.get(i), "IGNORE")) {
            windowFunction.setNullPolicy(WindowFunction.NullPolicy.IGNORE);
        }
    }

    private void processFrom(List<ParseNode> kids, int i, WindowFunction windowFunction, ExpressionContext context) {
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        if (helper.isKeyword(kids.get(i + 1), "FIRST")) {
            windowFunction.setFromPolicy(WindowFunction.FromPolicy.FIRST);
        } else if (helper.isKeyword(kids.get(i + 1), "LAST")) {
            windowFunction.setFromPolicy(WindowFunction.FromPolicy.LAST);
        }
    }
}

