/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.math.BigInteger;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FileSpecification;
import oracle.javatools.db.Index;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.View;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleInMemoryProperties;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.ora.XMLTypeColumnProperties;
import oracle.javatools.db.ora.sxml.ColumnSXMLGenerator;
import oracle.javatools.db.ora.sxml.ColumnSequenceSXMLGenerator;
import oracle.javatools.db.ora.sxml.ConstraintSXMLGenerator;
import oracle.javatools.db.ora.sxml.DataTypeSXMLGenerator;
import oracle.javatools.db.ora.sxml.InMemorySXMLGenerator;
import oracle.javatools.db.ora.sxml.IndexPartitionSXMLGenerator;
import oracle.javatools.db.ora.sxml.MatViewLogSXMLGenerator;
import oracle.javatools.db.ora.sxml.MatViewSXMLGenerator;
import oracle.javatools.db.ora.sxml.OracleTablespacePropsSXMLGenerator;
import oracle.javatools.db.ora.sxml.PartitionSXMLGenerator;
import oracle.javatools.db.ora.sxml.PhysicalPropsSXMLGenerator;
import oracle.javatools.db.ora.sxml.PlSqlMethodGenerator;
import oracle.javatools.db.ora.sxml.SQLFragmentSXMLGenerator;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLValueConverter;
import oracle.javatools.db.ora.sxml.TriggerSXMLGenerator;
import oracle.javatools.db.ora.sxml.UnsupportedTypeForSXMLException;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.ModelUtil;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;

class SXMLMappings {
    private final Map<String, List<Mapping>> m_mappings;
    private final Map<String, String> m_nameMap;
    private final Map<String, List<Class<? extends SXMLFragmentGenerator>>> m_genMap;
    private final Map<String, String> m_xsdMap = new HashMap<String, String>();
    private final Set<Class<? extends Enum>> m_toStringEnums;

    SXMLMappings() {
        this.m_mappings = new HashMap<String, List<Mapping>>();
        this.m_nameMap = new HashMap<String, String>();
        this.m_nameMap.put("TYPE", "TYPE_SPEC");
        this.m_genMap = new HashMap<String, List<Class<? extends SXMLFragmentGenerator>>>();
        this.m_toStringEnums = new HashSet<Class<? extends Enum>>();
        YNBooleanConverter ynCon = new YNBooleanConverter();
        InverseBooleanConverter invBooCon = new InverseBooleanConverter();
        CommaSeperatingStringArrayConverter commaCon = new CommaSeperatingStringArrayConverter();
        this.registerXSD("TABLE", "kustable.xsd");
        this.registerXSD("MATERIALIZED VIEW", "kusmv.xsd");
        this.registerXSD("MATERIALIZED VIEW LOG", "kusmvl.xsd");
        this.registerXSD("SEQUENCE", "kusseq.xsd");
        this.registerXSD("SYNONYM", "kussyn.xsd");
        this.registerXSD("TRIGGER", "kustrig.xsd");
        this.registerXSD("INDEX", "kusindex.xsd");
        this.registerXSD("VIEW", "kusview.xsd");
        this.registerXSD("TYPE", "kustype.xsd");
        this.registerXSD("TYPE BODY", "kustypb.xsd");
        this.registerXSD("TABLESPACE", "kustbls.xsd");
        this.registerXSD("COMPOSITE", "kuscomp.xsd");
        this.cache("TABLE", "GLOBAL_TEMPORARY", "TableType", new ValueCheckingConverter(Table.TableType.TRANSACTION_TEMP, Table.TableType.SESSION_TEMP));
        this.cache("TABLE", "SCHEMA", "schema", "name");
        this.cache("TABLE", "NAME", "name");
        this.cache("TABLE", "RELATIONAL_TABLE/COL_LIST//COL_LIST_ITEM", "columns");
        this.cache("TABLE", "RELATIONAL_TABLE/ON_COMMIT", "TableType", new TempTableTypeConverter());
        this.registerGen("TABLE", PhysicalPropsSXMLGenerator.class);
        this.registerGen("TABLE", ColumnSXMLGenerator.class);
        this.cache("TABLE", "RELATIONAL_TABLE/TABLE_PROPERTIES/PARALLEL", Property.createPath((String[])new String[]{"OracleTableProperties", "parallelDegree"}), new ParallelConverter());
        this.cache("TABLE", "CUSTOMER_AREA/ODB_PROPERTY_LIST/COMMENT", "Comment");
        this.cache("COLUMN", "NAME", "name");
        this.cache("COLUMN", "VIRTUAL", "virtualExpressionSource");
        this.cache("COLUMN", "DEFAULT", "default");
        this.cache("COLUMN", "IDENTITY_COLUMN", "identityProperties");
        this.cache("COLUMN", "NOT_NULL", "notNull", new ColumnNotNullConverter());
        this.cache("COLUMN", "CUSTOMER_AREA/ODB_PROPERTY_LIST/COMMENT", "Comment");
        this.registerGen("COLUMN", DataTypeSXMLGenerator.class);
        this.registerGen("COLUMN", ColumnSequenceSXMLGenerator.class);
        this.registerGen("TABLE", ConstraintSXMLGenerator.class);
        this.cache("CONSTRAINT", "NAME", "name");
        this.cache("CONSTRAINT", "COL_LIST//COL_LIST_ITEM/NAME", "columnIDs");
        this.cache("CONSTRAINT", "DISABLE", "enabled", invBooCon);
        this.registerGen("TABLE", PartitionSXMLGenerator.class);
        this.registerGen("MATERIALIZED VIEW", PartitionSXMLGenerator.class);
        this.registerGen("PARTITION MODEL", PartitionSXMLGenerator.class);
        this.cache("PARTITION MODEL", "COL_LIST//COL_LIST_ITEM/NAME", "partitionColumns");
        this.cache("PARTITION MODEL", "CONSTRAINT", "referenceConstraintID");
        this.cache("PARTITION MODEL", "PARTITION_LIST//PARTITION_LIST_ITEM", "partitions");
        this.cache("PARTITION", "NAME", "name");
        this.cache("PARTITION", "VALUES", "values", commaCon);
        this.cache("PARTITION", "PHYSICAL_PROPERTIES/INMEMORY", "OracleInMemoryProperties");
        this.cache("PARTITION", "PHYSICAL_PROPERTIES/HEAP_TABLE/SEGMENT_ATTRIBUTES", "segmentAttributes");
        this.cache("PARTITION", "PHYSICAL_PROPERTIES/HEAP_TABLE/COMPRESS", Property.createPath((String[])new String[]{"OracleTableProperties", "tableCompression"}), new TableCompressionConverter());
        this.registerGen("PARTITION", PartitionSXMLGenerator.class);
        this.registerGen("PARTITION", ColumnSXMLGenerator.class);
        this.cache("PARTITION_HASH", "NAME", "name");
        this.cache("PARTITION_HASH", "SEGMENT_ATTRIBUTES/TABLESPACE", "segmentAttributes", "tablespaceID");
        this.cache("PARTITION_HASH", "COMPRESS", Property.createPath((String[])new String[]{"OracleTableProperties", "tableCompression"}), new TableCompressionConverter());
        this.cache("PARTITION_HASH", "INMEMORY", "OracleInMemoryProperties");
        this.registerGen("PARTITION_HASH", ColumnSXMLGenerator.class);
        this.cache("PARTITION_SUB", "NAME", "name");
        this.cache("PARTITION_SUB", "VALUES", "values", commaCon);
        this.cache("PARTITION_SUB", "INMEMORY", "OracleInMemoryProperties");
        this.cache("PARTITION_SUB", "TABLESPACE", "segmentAttributes", "tablespaceID");
        this.cache("PARTITION_SUB", "COMPRESS", Property.createPath((String[])new String[]{"OracleTableProperties", "tableCompression"}), new TableCompressionConverter());
        this.cache("PARTITION_SUB", "COMPRESS_LEVEL", Property.createPath((String[])new String[]{"OracleTablespaceProperties", "tableCompression"}), new CompressionLevelConverter());
        this.registerGen("PARTITION_SUB", ColumnSXMLGenerator.class);
        this.cache("OracleStorageProperties", "PCTFREE", "percentFree");
        this.cache("OracleStorageProperties", "PCTUSED", "percentUsed");
        this.cache("OracleStorageProperties", "INITRANS", "initrans");
        this.cache("OracleStorageProperties", "STORAGE/INITIAL", "initialExtent");
        this.cache("OracleStorageProperties", "STORAGE/NEXT", "nextExtent");
        this.cache("OracleStorageProperties", "STORAGE/MINEXTENTS", "minExtent");
        this.cache("OracleStorageProperties", "STORAGE/MAXEXTENTS", "maxExtent", new MaxExtentConverter());
        this.cache("OracleStorageProperties", "STORAGE/PCTINCREASE", "percentIncrease");
        this.cache("OracleStorageProperties", "STORAGE/FREELISTS", "freelists");
        this.cache("OracleStorageProperties", "STORAGE/FREELIST_GROUPS", "freelistGroups");
        this.cache("OracleStorageProperties", "STORAGE/BUFFER_POOL", "bufferMode");
        this.cache("OracleStorageProperties", "TABLESPACE", "tablespaceID");
        this.cache("OracleStorageProperties", "LOGGING", "logging", ynCon);
        this.cache("OracleColumnProperties", "LOB_PROPERTIES/STORAGE_TABLE", "LOBProperties");
        this.cache("OracleColumnProperties", "VARRAY_PROPERTIES/STORE_AS", "VAProperties", new VAAsLOBConverter());
        this.cache("OracleColumnProperties", "VARRAY_PROPERTIES/LOB_PROPERTIES/STORAGE_TABLE", "VAProperties");
        this.cache("OracleColumnProperties", "NESTED_TABLE_PROPERTIES", "nestedTableProperties");
        this.cache("OracleColumnProperties", "XMLTYPE_PROPERTIES", "XMLTypeColumnProperties");
        this.cache("OracleNestedTableProperties", "STORAGE_TABLE/SCHEMA", "!schema");
        this.cache("OracleNestedTableProperties", "STORAGE_TABLE/NAME", "tableName");
        this.cache("OracleNestedTableProperties", "RETURN_AS", "returnAs");
        HashMap<Boolean, String> imStatusMap = new HashMap<Boolean, String>();
        imStatusMap.put(true, "ENABLE");
        imStatusMap.put(false, "DISABLE");
        this.cache("OracleInMemoryProperties", "STATE", "inMemory", new ValueMappingConverter(imStatusMap));
        this.cache("OracleInMemoryProperties", "PRIORITY", "inMemoryPriority");
        this.cache("OracleInMemoryProperties", "COMPRESSION", "inMemoryCompression");
        this.cache("OracleInMemoryProperties", "DISTRIBUTE", "inMemoryDistribute");
        this.cache("OracleInMemoryProperties", "DUPLICATE", "inMemoryDuplicate");
        this.registerEnumAsToString(OracleInMemoryProperties.InMemoryCompression.class);
        this.registerEnumAsToString(OracleInMemoryProperties.InMemoryPriority.class);
        this.registerEnumAsToString(OracleInMemoryProperties.InMemoryDuplicate.class);
        this.registerEnumAsToString(OracleInMemoryProperties.InMemoryDistribute.class);
        this.registerGen("OracleInMemoryProperties", InMemorySXMLGenerator.class);
        this.cache("LOB DESCRIPTOR", "SCHEMA", "!schema");
        this.cache("LOB DESCRIPTOR", "NAME", "LOBSegName");
        this.cache("LOB DESCRIPTOR", "TABLESPACE", "storage", "tablespaceID");
        this.cache("LOB DESCRIPTOR", "STORAGE_IN_ROW", "storageInRow");
        this.cache("LOB DESCRIPTOR", "STORAGE/INITIAL", "storage", "initialExtent");
        this.cache("LOB DESCRIPTOR", "STORAGE/NEXT", "storage", "nextExtent");
        this.cache("LOB DESCRIPTOR", "STORAGE/MINEXTENTS", "storage", "minExtent");
        this.cache("LOB DESCRIPTOR", "STORAGE/MAXEXTENTS", Property.createPath((String[])new String[]{"storage", "maxExtent"}), new MaxExtentConverter());
        this.cache("LOB DESCRIPTOR", "STORAGE/PCTINCREASE", "storage", "percentIncrease");
        this.cache("LOB DESCRIPTOR", "STORAGE/LOBRETENTION", "retention", new LOBRetentionConverter());
        this.cache("LOB DESCRIPTOR", "STORAGE/FREELISTS", "storage", "freelists");
        this.cache("LOB DESCRIPTOR", "STORAGE/FREELIST_GROUPS", "storage", "freelistGroups");
        this.cache("LOB DESCRIPTOR", "STORAGE/BUFFER_POOL", "storage", "bufferMode");
        this.cache("LOB DESCRIPTOR", "CHUNK", "chunk");
        this.cache("LOB DESCRIPTOR", "PCTVERSION", "pctVersion");
        this.cache("LOB DESCRIPTOR", "CACHE", "LOBCache", new LOBCacheConverter());
        this.cache("LOB DESCRIPTOR", "LOGGING", Property.createPath((String[])new String[]{"storage", "logging"}), ynCon);
        this.cache("XMLTypeColumnProperties", "XMLTYPE_STORAGE/STORE_AS", "storeAs", new XMLTypeColumnStoreAsConverter());
        this.cache("XMLTypeColumnProperties", "XMLSCHEMA", "elementID", "parent", "name");
        this.cache("XMLTypeColumnProperties", "ELEMENT", "elementID");
        this.cache("XMLTypeColumnProperties", "ALLOW_ANYSCHEMA", "allowAnySchema");
        this.cache("XMLTypeColumnProperties", "DISALLOW_NONSCHEMA", "allowNonSchema", invBooCon);
        this.cache("COLUMN", "CUSTOMER_AREA/ODB_PROPERTY_LIST/XMLTYPE_COLUMN_XMLSCHEMA_OWNER", "OracleColumnProperties", "XMLTypeColumnProperties", "elementID", "parent", "schemaName");
        this.cache("IOT PROPERTIES", "MAPPING_TABLE", "mapped");
        this.cache("IOT PROPERTIES", "PCTTHRESHOLD", "pctThreshold");
        this.cache("IOT PROPERTIES", "KEYCOMPRESS", "keyCompression", new KeyCompressionConverter(false));
        this.cache("IOT PROPERTIES", "OVERFLOW/INCLUDING", "includeColumn", "name");
        this.cache("IOT PROPERTIES", "OVERFLOW/SEGMENT_ATTRIBUTES", "overflowProperties");
        this.cache("EXTERNAL TABLE PROPERTIES", "ACCESS_DRIVER_TYPE", "accessDriverType");
        this.cache("EXTERNAL TABLE PROPERTIES", "DEFAULT_DIRECTORY", "defaultDirectory", "name");
        this.cache("EXTERNAL TABLE PROPERTIES", "ACCESS_PARAMETERS", "accessParameters");
        this.cache("EXTERNAL TABLE PROPERTIES", "LOCATION//LOCATION_ITEM", "locationSpecifiers");
        this.cache("EXTERNAL TABLE PROPERTIES", "REJECT_LIMIT", "rejectLimit", new ValueMappingConverter(Collections.singletonMap(-1, "UNLIMITED")));
        String locSpec = "LOCATION_SPECIFIER";
        this.cache("LOCATION_SPECIFIER", "DIRECTORY", "directory", "name");
        this.cache("LOCATION_SPECIFIER", "NAME", "specifier");
        this.cache("INDEX", "UNIQUE", "indexType", new ValueCheckingConverter(Index.IndexType.UNIQUE));
        this.cache("INDEX", "BITMAP", "indexType", new ValueCheckingConverter(Index.IndexType.BITMAP));
        this.cache("INDEX", "SCHEMA", "schema", "name");
        this.cache("INDEX", "NAME", "name");
        this.cache("INDEX", "TABLE_INDEX/ON_TABLE/SCHEMA", "table", "schema", "name");
        this.cache("INDEX", "TABLE_INDEX/ON_TABLE/NAME", "table", "name");
        this.cache("INDEX", "TABLE_INDEX/INDEX_ATTRIBUTES", "OracleStorageProperties", new TempTableIndexCheckerConverter());
        this.cache("INDEX", "TABLE_INDEX/INDEX_ATTRIBUTES/KEYCOMPRESS", "keyCompression", new KeyCompressionConverter(false));
        this.cache("INDEX", "CUSTOMER_AREA/ODB_PROPERTY_LIST/KEYCOMPRESS", "keyCompression", new KeyCompressionConverter(true));
        this.cache("INDEX", "TABLE_INDEX/INDEX_ATTRIBUTES/PARALLEL", "parallelDegree", new ParallelConverter(ParallelConverter.OwnerType.INDEX));
        this.cache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES/INDEXTYPE/SCHEMA", "domainIndextype", "schemaName");
        this.cache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES/INDEXTYPE/SCHEMA", "domainIndextype", "schema", "name");
        this.cache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES/INDEXTYPE/NAME", "domainIndextype", "name");
        this.cache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES/PARALLEL", "parallelDegree", new ParallelConverter(ParallelConverter.OwnerType.DOMAIN_INDEX));
        this.cache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES/PARAMETERS", "domainIndextypeParameters");
        this.cache("INDEX", "CUSTOMER_AREA/ODB_PROPERTY_LIST/SYSTEM_GENERATED", "systemGenerated", new YNBooleanConverter());
        this.cache("INDEX", "TABLE_INDEX/INDEX_ATTRIBUTES/REVERSE", "reverse");
        this.registerGen("INDEX", IndexPartitionSXMLGenerator.class);
        this.registerGen("INDEX PARTITION", IndexPartitionSXMLGenerator.class);
        this.cache("INDEX PARTITION MODEL", "PARTITION_LIST//PARTITION_LIST_ITEM", "partitions");
        this.cache("INDEX PARTITION", "NAME", "name");
        this.cache("INDEX PARTITION", "VALUES", "valuesLessThan", commaCon);
        this.cache("INDEX PARTITION", "SEGMENT_ATTRIBUTES", "segmentAttributes");
        this.cache("INDEX PARTITION", "KEYCOMPRESS", "useKeyCompression", new YNBooleanConverter());
        this.cache("INDEX PARTITION", "PARAMETERS", "domainParameters");
        this.cache("VIEW", "SCHEMA", "schema", "name");
        this.cache("VIEW", "NAME", "name");
        this.cache("VIEW", "READ_ONLY", "restriction", new ValueCheckingConverter(View.Restriction.READ_ONLY));
        this.cache("VIEW", "COL_LIST//COL_LIST_ITEM", "columns");
        this.cache("VIEW", "CUSTOMER_AREA/ODB_PROPERTY_LIST/FORCE_ON_CREATE", "forceOnCreate");
        this.cache("VIEW", "CUSTOMER_AREA/ODB_PROPERTY_LIST/CHECK_OPTION", "restriction", new ValueCheckingConverter(View.Restriction.CHECK_OPTION));
        this.cache("VIEW", "CUSTOMER_AREA/ODB_PROPERTY_LIST/COMMENT", "Comment");
        this.cache("SEQUENCE", "SCHEMA", "schema", "name");
        this.cache("SEQUENCE", "NAME", "name");
        this.cache("SEQUENCE", "START_WITH", "startWith");
        this.cache("SEQUENCE", "INCREMENT", "incrementBy");
        this.cache("SEQUENCE", "MINVALUE", "minValue");
        this.cache("SEQUENCE", "MAXVALUE", "maxValue");
        this.cache("SEQUENCE", "CYCLE", "cycleFlag");
        this.cache("SEQUENCE", "CACHE", "cacheFlag", new CacheFlagConverter());
        this.cache("SEQUENCE", "CACHE", "cacheSize");
        this.cache("SEQUENCE", "ORDER", "orderFlag");
        this.cache("TRIGGER", "SCHEMA", "schema", "name");
        this.cache("TRIGGER", "NAME", "name");
        this.cache("TRIGGER", "TRIGGER_TYPE", "timing");
        this.cache("TRIGGER", "WHEN_CONDITION", "whenClause");
        this.cache("TRIGGER", "PLSQL_BLOCK", "code");
        this.cache("TRIGGER", "DISABLE", "enabled", invBooCon);
        this.registerGen("TRIGGER", TriggerSXMLGenerator.class);
        this.cache("MATERIALIZED VIEW", "SCHEMA", "schema", "name");
        this.cache("MATERIALIZED VIEW", "NAME", "name");
        this.cache("MATERIALIZED VIEW", "PHYSICAL_PROPERTIES/HEAP_TABLE", (String[])null);
        this.cache("MATERIALIZED VIEW", "PHYSICAL_PROPERTIES/HEAP_TABLE/SEGMENT_ATTRIBUTES", "OracleStorageProperties");
        this.cache("MATERIALIZED VIEW", "PHYSICAL_PROPERTIES/HEAP_TABLE/COMPRESS", Property.createPath((String[])new String[]{"OracleTableProperties", "tableCompression"}), new TableCompressionConverter());
        this.cache("MATERIALIZED VIEW", "PHYSICAL_PROPERTIES/INMEMORY", "OracleInMemoryProperties");
        this.cache("MATERIALIZED VIEW", "CACHE", "cache");
        this.cache("MATERIALIZED VIEW", "PARALLEL", Property.createPath((String[])new String[]{"OracleTableProperties", "parallelDegree"}), new ParallelConverter(ParallelConverter.OwnerType.MATERIALIZED_VIEW));
        this.cache("MATERIALIZED VIEW", "BUILD", "buildType");
        this.cache("MATERIALIZED VIEW", "ON_PREBUILT_TABLE", "onPrebuilt", new ValueCheckingConverter(MaterializedView.PrebuiltType.UNSPECIFIED_PRECISION));
        this.cache("MATERIALIZED VIEW", "ON_PREBUILT_TABLE/REDUCED_PRECISION", "onPrebuilt", new YNBooleanConverter(MaterializedView.PrebuiltType.WITH_REDUCED_PRECISION, MaterializedView.PrebuiltType.WITHOUT_REDUCED_PRECISION));
        this.cache("MATERIALIZED VIEW", "USING_NO_INDEX", "defaultIndex", new InverseBooleanConverter(Boolean.FALSE));
        this.cache("MATERIALIZED VIEW", "INDEX_ATTRIBUTES", "MatViewIndexStorageProperties");
        this.cache("MATERIALIZED VIEW", "NEVER_REFRESH", "refreshMode", new ValueCheckingConverter(MaterializedView.RefreshMode.NEVER));
        this.cache("MATERIALIZED VIEW", "REFRESH", "refreshMode", new InverseValueCheckingConverter(MaterializedView.RefreshMode.NEVER));
        this.cache("MATERIALIZED VIEW", "REFRESH/FAST", "refreshMethod", new MVRefreshValueCheckingConverter(MaterializedView.RefreshMethod.FAST));
        this.cache("MATERIALIZED VIEW", "REFRESH/ON_COMMIT", "refreshMode", new ValueCheckingConverter(MaterializedView.RefreshMode.COMMIT));
        this.cache("MATERIALIZED VIEW", "REFRESH/COMPLETE", "refreshMethod", new MVRefreshValueCheckingConverter(MaterializedView.RefreshMethod.COMPLETE));
        this.cache("MATERIALIZED VIEW", "REFRESH/START_WITH", "nextRefreshDate", new MVRefreshStartWithConverter());
        this.cache("MATERIALIZED VIEW", "REFRESH/NEXT", "interval", new MVRefreshConverter());
        this.cache("MATERIALIZED VIEW", "REFRESH/WITH_PRIMARY_KEY", "keyType", new MVRefreshValueCheckingConverter(MaterializedView.RefreshWith.PRIMARY_KEY));
        this.cache("MATERIALIZED VIEW", "REFRESH/WITH_ROWID", "keyType", new MVRefreshValueCheckingConverter(MaterializedView.RefreshWith.ROWID));
        this.cache("MATERIALIZED VIEW", "REFRESH/CONSTRAINTS", "usingConstraints", new MVRefreshConverter());
        this.cache("MATERIALIZED VIEW", "QUERY_REWRITE", "queryRewrite");
        this.cache("MATERIALIZED VIEW", "CUSTOMER_AREA/ODB_PROPERTY_LIST/COMMENT", "Comment");
        this.registerGen("MATERIALIZED VIEW", MatViewSXMLGenerator.class);
        this.cache("MATERIALIZED VIEW LOG", "ON_TABLE/SCHEMA", "schema", "name");
        this.cache("MATERIALIZED VIEW LOG", "ON_TABLE/NAME", "masterTableID");
        this.cache("MATERIALIZED VIEW LOG", "SEGMENT_ATTRIBUTES", "OracleStorageProperties");
        this.cache("MATERIALIZED VIEW LOG", "CACHE", "cache");
        this.cache("MATERIALIZED VIEW LOG", "PARALLEL", "parallelDegree", new ParallelConverter(ParallelConverter.OwnerType.MATERIALIZED_VIEW));
        this.cache("MATERIALIZED VIEW LOG", "RECORDS/OBJECT_ID", "objectIdLogged");
        this.cache("MATERIALIZED VIEW LOG", "RECORDS/PRIMARY_KEY", "primaryKeyLogged");
        this.cache("MATERIALIZED VIEW LOG", "RECORDS/ROWID", "rowidLogged");
        this.cache("MATERIALIZED VIEW LOG", "RECORDS/SEQUENCE", "sequenceLogged");
        this.cache("MATERIALIZED VIEW LOG", "INCLUDING_NEW_VALUES", "newValues");
        this.registerGen("MATERIALIZED VIEW LOG", MatViewLogSXMLGenerator.class);
        this.cache("SYNONYM", "SCHEMA", "schema", "name");
        this.cache("SYNONYM", "NAME", "name");
        this.cache("SYNONYM", "OBJECT_SCHEMA", "reference", "schema", "name");
        this.cache("SYNONYM", "OBJECT_SCHEMA", "reference", "schemaName");
        this.cache("SYNONYM", "OBJECT_NAME", "reference", "name");
        this.cache("SYNONYM", "DB_LINK", "reference", "databaseName");
        this.registerGen("TYPE", DataTypeSXMLGenerator.class);
        this.cache("TYPE", "SCHEMA", "schema", "name");
        this.cache("TYPE", "NAME", "name");
        this.cache("TYPE", "OID", "OID");
        this.cache("TYPE", "OBJECT", "typeCode", new ValueCheckingConverter("OBJECT"));
        this.cache("TYPE", "OBJECT/AUTHID_CURRENT_USER", "authidCurrentUser", new ComplexTypeObjectConverter(true));
        this.cache("TYPE", "OBJECT/SQLJ_OBJECT_TYPE/NAME", "sqljExternalName");
        this.cache("TYPE", "OBJECT/SQLJ_OBJECT_TYPE/SQLDATA", "sqljUsing", new ValueCheckingConverter(Type.SQLJUsingType.SQLData));
        this.cache("TYPE", "OBJECT/SQLJ_OBJECT_TYPE/CUSTOMDATUM", "sqljUsing", new ValueCheckingConverter(Type.SQLJUsingType.CustomDatum));
        this.cache("TYPE", "OBJECT/SQLJ_OBJECT_TYPE/ORADATA", "sqljUsing", new ValueCheckingConverter(Type.SQLJUsingType.OraData));
        this.cache("TYPE", "OBJECT/UNDER/SCHEMA", "underTypeReference", "schema", "name");
        this.cache("TYPE", "OBJECT/UNDER/NAME", "underTypeReference", "name");
        this.cache("TYPE", "OBJECT/ATTRIBUTE_LIST//ATTRIBUTE_LIST_ITEM", "attributes");
        this.cache("TYPE", "OBJECT/ELEMENT_LIST//ELEMENT_LIST_ITEM", "methods");
        this.cache("TYPE", "OBJECT/NOT_FINAL", "final", new ComplexTypeObjectConverter(false));
        this.cache("TYPE", "OBJECT/NOT_INSTANTIABLE", "instantiable", new ComplexTypeObjectConverter(false));
        this.cache("TYPE", "VARRAY", "collectionType", new ValueCheckingConverter("VARYING ARRAY"));
        this.cache("TYPE", "NESTED_TABLE", "collectionType", new ValueCheckingConverter("TABLE"));
        this.cache("TYPE", "CUSTOMER_AREA/ODB_PROPERTY_LIST/PLSQL_BLOCK", "source");
        this.cache("TYPE BODY", "SCHEMA", "schema", "name");
        this.cache("TYPE BODY", "NAME", "name");
        this.cache("TYPE BODY", "PLSQL_BLOCK", "source");
        this.registerGen("TypeAttribute", DataTypeSXMLGenerator.class);
        this.cache("TypeAttribute", "NAME", "name");
        this.cache("TypeAttribute", "EXTERNAL_NAME", "sqljExternalName");
        this.registerGen("TypeMethod", PlSqlMethodGenerator.class);
        this.cache("TypeMethod", "OVERRIDING", "overriding");
        this.cache("TypeMethod", "FINAL", "final");
        this.cache("TypeMethod", "NOT_INSTANTIABLE", "instantiable", new InverseBooleanConverter());
        this.registerGen("PlSqlParameter", DataTypeSXMLGenerator.class);
        this.cache("PlSqlParameter", "NAME", "name");
        this.cache("PlSqlParameter", "OUT", "mode", new ValueCheckingConverter(PlSqlParameter.Mode.OUT));
        this.cache("PlSqlParameter", "IN_OUT", "mode", new ValueCheckingConverter(PlSqlParameter.Mode.INOUT));
        this.cache("PlSqlParameter", "NO_COPY", "noCopy");
        this.registerGen("VIEW", SQLFragmentSXMLGenerator.class);
        this.registerGen("MATERIALIZED VIEW", SQLFragmentSXMLGenerator.class);
        this.registerGen("INDEX", SQLFragmentSXMLGenerator.class);
        this.registerGen("CONSTRAINT", SQLFragmentSXMLGenerator.class);
        this.cache("IdentityColumnProperties", "SCHEMA", "parent", "parent", "schema", "name");
        this.cache("IdentityColumnProperties", "START_WITH", "startWith");
        this.cache("IdentityColumnProperties", "INCREMENT", "incrementBy");
        this.cache("IdentityColumnProperties", "MINVALUE", "minValue");
        this.cache("IdentityColumnProperties", "MAXVALUE", "maxValue");
        this.cache("IdentityColumnProperties", "CYCLE", "cycleFlag");
        this.cache("IdentityColumnProperties", "CACHE", "cacheFlag", new CacheFlagConverter());
        this.cache("IdentityColumnProperties", "CACHE", "cacheSize");
        this.cache("IdentityColumnProperties", "ORDER", "orderFlag");
        this.cache("TABLESPACE", "BIGFILE", "fileType", new ValueCheckingConverter(Tablespace.FileType.BIGFILE));
        this.cache("TABLESPACE", "TYPE", "TablespaceType");
        this.cache("TABLESPACE", "NAME", "name");
        this.cache("TABLESPACE", "DATAFILE_LIST//DATAFILE_LIST_ITEM", "fileSpecifications");
        this.registerGen("TABLESPACE", OracleTablespacePropsSXMLGenerator.class);
        this.cache("TABLESPACE", "BLOCKSIZE", "OracleTablespaceProperties", "blockSize");
        this.cache("TABLESPACE", "LOGGING", Property.createPath((String[])new String[]{"OracleTablespaceProperties", "logging"}), new YNBooleanConverter(OracleTablespaceProperties.LoggingType.LOGGING, OracleTablespaceProperties.LoggingType.NOLOGGING));
        this.cache("TABLESPACE", "FORCE_LOGGING", "OracleTablespaceProperties", "forceLogging");
        this.cache("TABLESPACE", "DEFAULT/COMPRESS", Property.createPath((String[])new String[]{"OracleTablespaceProperties", "defaultTableCompression"}), new TableCompressionConverter());
        this.cache("TABLESPACE", "DEFAULT/COMPRESS_LEVEL", Property.createPath((String[])new String[]{"OracleTablespaceProperties", "defaultTableCompression"}), new CompressionLevelConverter());
        this.cache("TABLESPACE", "DEFAULT/STORAGE/INITIAL", "OracleTablespaceProperties", "OracleStorageProperties", "initialExtent");
        this.cache("TABLESPACE", "DEFAULT/STORAGE/NEXT", "OracleTablespaceProperties", "OracleStorageProperties", "nextExtent");
        this.cache("TABLESPACE", "DEFAULT/STORAGE/MINEXTENTS", "OracleTablespaceProperties", "OracleStorageProperties", "minExtent");
        this.cache("TABLESPACE", "DEFAULT/STORAGE/MAXEXTENTS", Property.createPath((String[])new String[]{"OracleTablespaceProperties", "OracleStorageProperties", "maxExtent"}), new MaxExtentConverter());
        this.cache("TABLESPACE", "DEFAULT/STORAGE/PCTINCREASE", "OracleTablespaceProperties", "OracleStorageProperties", "percentIncrease");
        this.cache("TABLESPACE", "DEFAULT/INMEMORY", "OracleTablespaceProperties", "OracleInMemoryProperties");
        this.cache("TABLESPACE", "OFFLINE", Property.createPath((String[])new String[]{"OracleTablespaceProperties", "onlineStatus"}), new ValueCheckingConverter(OracleTablespaceProperties.OnlineStatus.OFFLINE, OracleTablespaceProperties.OnlineStatus.OFFLINE_NORMAL, OracleTablespaceProperties.OnlineStatus.OFFLINE_TEMPORARY, OracleTablespaceProperties.OnlineStatus.OFFLINE_IMMEDIATE));
        this.cache("TABLESPACE", "TABLESPACE_GROUP", "OracleTablespaceProperties", "tablespaceGroup");
        this.cache("TABLESPACE", "EXTENT_MANAGEMENT/TYPE", "OracleTablespaceProperties", "extentManagementType");
        this.cache("TABLESPACE", "EXTENT_MANAGEMENT/ALLOCATION_TYPE", Property.createPath((String[])new String[]{"OracleTablespaceProperties", "autoAllocate"}), new AutoAllocateConverter());
        this.cache("TABLESPACE", "EXTENT_MANAGEMENT/SIZE", "OracleTablespaceProperties", "uniformSize");
        this.cache("TABLESPACE", "SEGMENT_SPACE_MANAGEMENT", "OracleTablespaceProperties", "segmentManagement");
        this.cache("TABLESPACE", "RETENTION_GUARANTEE", Property.createPath((String[])new String[]{"OracleTablespaceProperties", "retention"}), new ValueCheckingConverter(OracleTablespaceProperties.RetentionType.GUARANTEE));
        this.cache("FILE_SPECIFICATION", "NAME", "directory", new FileNameConverter(true));
        this.cache("FILE_SPECIFICATION", "NAME", "name", new FileNameConverter(false));
        this.cache("FILE_SPECIFICATION", "SIZE", "fileSize");
        this.cache("FILE_SPECIFICATION", "REUSE", "reuse");
        this.cache("FILE_SPECIFICATION", "AUTOEXTEND/NEXT", Property.createPath((String[])new String[]{"autoExtendProperties", "nextSize"}));
        this.cache("FILE_SPECIFICATION", "AUTOEXTEND/MAXSIZE", Property.createPath((String[])new String[]{"autoExtendProperties", "maxSize"}), new MaxExtentConverter());
    }

    String getNodeName(String objType) {
        if (this.m_nameMap.containsKey(objType)) {
            return this.m_nameMap.get(objType);
        }
        return objType.replaceAll(" ", "_");
    }

    boolean hasMappings(String type) {
        return this.m_mappings.containsKey(type);
    }

    Iterator<Mapping> getMappings(String type) {
        if (!this.m_mappings.containsKey(type)) {
            if (this.m_genMap.containsKey(type)) {
                return new ArrayList().iterator();
            }
            throw new UnsupportedTypeForSXMLException(type);
        }
        return this.m_mappings.get(type).iterator();
    }

    Iterator<Class<? extends SXMLFragmentGenerator>> getGenerators(String type) {
        ArrayList<Class<? extends SXMLFragmentGenerator>> list = new ArrayList<Class<? extends SXMLFragmentGenerator>>();
        if (this.m_genMap.containsKey(type)) {
            list.addAll((Collection)this.m_genMap.get(type));
        }
        list.addAll(this.getAdditionalGenerators(type));
        if (list.size() > 0) {
            return list.iterator();
        }
        return null;
    }

    private List<Class<? extends SXMLFragmentGenerator>> getAdditionalGenerators(String type) {
        ArrayList list = new ArrayList();
        DBCore.getInstance().populateFactoryList(SXMLFragmentGenerator.class, list);
        ArrayList<Class<? extends SXMLFragmentGenerator>> retval = new ArrayList<Class<? extends SXMLFragmentGenerator>>();
        for (SXMLFragmentGenerator g : list) {
            if (!g.supportsType(type)) continue;
            retval.add(g.getClass());
        }
        return retval;
    }

    Iterator<String> getGeneratorTypes() {
        return this.m_genMap.keySet().iterator();
    }

    private void registerXSD(String type, String xsd) {
        this.m_xsdMap.put(type, xsd);
    }

    XMLSchema getXSD(String type) {
        String xsd = this.m_xsdMap.get(type);
        if (xsd != null) {
            String res = this.getClass().getPackage().getName().replaceAll("\\.", "/") + "/xsd/" + xsd;
            URL url = this.getClass().getClassLoader().getResource(res);
            try {
                XSDBuilder builder = new XSDBuilder();
                return builder.build(url);
            }
            catch (Exception e) {
                DBLog.logStackTrace((Throwable)e);
            }
        }
        return null;
    }

    private void registerEnumAsToString(Class<? extends Enum> enumClz) {
        this.m_toStringEnums.add(enumClz);
    }

    boolean useToString(Class<? extends Enum> enumClz) {
        return this.m_toStringEnums.contains(enumClz);
    }

    void registerGen(String type, Class<? extends SXMLFragmentGenerator> gen) {
        List<Class<? extends SXMLFragmentGenerator>> cache = this.m_genMap.get(type);
        if (cache == null) {
            cache = new ArrayList<Class<? extends SXMLFragmentGenerator>>();
            this.m_genMap.put(type, cache);
        }
        cache.add(gen);
    }

    protected void cache(String type, String elementPath, String ... props) {
        String propertyPath = props == null ? null : Property.createPath((String[])props);
        this.cache(type, elementPath, propertyPath, (SXMLValueConverter)null);
    }

    protected void cache(String type, String elementPath, String propertyPath, SXMLValueConverter con) {
        List<Mapping> cache = this.m_mappings.get(type);
        if (cache == null) {
            cache = new ArrayList<Mapping>();
            this.m_mappings.put(type, cache);
        }
        cache.add(new Mapping(elementPath, propertyPath, con));
    }

    protected void uncache(String type, String elementPath, String ... props) {
        String propertyPath = props == null || props.length == 0 ? null : Property.createPath((String[])props);
        List<Mapping> cache = this.m_mappings.get(type);
        if (cache == null) {
            return;
        }
        for (int i = 0; i < cache.size(); ++i) {
            Mapping mapping = cache.get(i);
            if (!mapping.getElementPath().equals(elementPath) || !ModelUtil.areEqual((Object)mapping.getPropertyPath(), (Object)propertyPath)) continue;
            cache.remove(mapping);
            break;
        }
    }

    static DBObjectProvider getProvider(DBObject obj, boolean up) {
        if (obj.getID() instanceof BaseObjectID && ((BaseObjectID)obj.getID()).getProvider() != null) {
            return ((BaseObjectID)obj.getID()).getProvider();
        }
        if (up && obj.getParent() != null) {
            return SXMLMappings.getProvider(obj.getParent(), true);
        }
        for (DBObject kid : obj.getOwnedObjects()) {
            DBObjectProvider p = SXMLMappings.getProvider(kid, false);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    private static class CompressionLevelConverter
    implements SXMLValueConverter {
        private static final String LOW = "LOW";

        private CompressionLevelConverter() {
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (propValue == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_LOW || propValue == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_LOW) {
                return LOW;
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            OracleTableProperties.OracleTableCompression tableComp = null;
            if (owner instanceof OracleTablespaceProperties) {
                tableComp = ((OracleTablespaceProperties)owner).getDefaultTableCompression();
            } else if (owner instanceof OracleTableProperties) {
                tableComp = ((OracleTableProperties)owner).getTableCompression();
            }
            if (LOW.equals(propValue)) {
                if (tableComp == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_HIGH) {
                    tableComp = OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_LOW;
                } else if (tableComp == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_HIGH) {
                    tableComp = OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_LOW;
                }
            }
            return tableComp;
        }
    }

    private static class AutoAllocateConverter
    implements SXMLValueConverter {
        private AutoAllocateConverter() {
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            OracleTablespaceProperties otp;
            if (owner instanceof Tablespace && (otp = (OracleTablespaceProperties)((Tablespace)owner).getProperty("OracleTablespaceProperties")) != null && otp.getExtentManagementType() != null) {
                if (Boolean.TRUE.equals(propValue)) {
                    return "AUTOALLOCATE";
                }
                return "UNIFORM";
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue.equals("AUTOALLOCATE")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    private static class FileNameConverter
    implements SXMLValueConverter {
        private boolean m_isDirectory;

        public FileNameConverter(boolean isDirectory) {
            this.m_isDirectory = isDirectory;
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (!this.m_isDirectory && owner instanceof FileSpecification && ModelUtil.hasLength((String)((FileSpecification)owner).getDirectory())) {
                return ((FileSpecification)owner).getDirectory() + "/" + propValue;
            }
            return propValue == null ? null : propValue;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            int fileSep = 47;
            String retval = null;
            if (propValue instanceof String) {
                retval = (String)propValue;
            }
            if (retval != null) {
                if (retval.indexOf(fileSep) == -1) {
                    fileSep = 92;
                }
                if (this.m_isDirectory) {
                    retval = retval.indexOf(fileSep) != -1 ? retval.substring(0, retval.lastIndexOf(fileSep)) : null;
                } else if (retval.indexOf(fileSep) != -1) {
                    retval = retval.substring(retval.lastIndexOf(fileSep) + 1, retval.length());
                }
            }
            return retval;
        }
    }

    static class MaxExtentConverter
    implements SXMLValueConverter {
        MaxExtentConverter() {
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (propValue instanceof BigInteger) {
                BigInteger maxextent = (BigInteger)propValue;
                return maxextent.min(OracleTableBuilder.MAXEXTENTS_UNLIMITED);
            }
            return propValue;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            BigInteger maxextent = null;
            if (propValue instanceof BigInteger) {
                maxextent = (BigInteger)propValue;
            } else if (propValue instanceof String) {
                try {
                    maxextent = new BigInteger((String)propValue);
                }
                catch (NumberFormatException nfe) {
                    maxextent = null;
                }
            }
            if (maxextent != null) {
                return maxextent.min(OracleTableBuilder.MAXEXTENTS_UNLIMITED);
            }
            return propValue;
        }
    }

    static class TempTableIndexCheckerConverter
    implements SXMLValueConverter {
        TempTableIndexCheckerConverter() {
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            Table.TableType tt;
            if (owner instanceof Index && ((Index)owner).getTable() != null && ((tt = (Table.TableType)((Index)owner).getTable().getProperty("TableType")) == Table.TableType.SESSION_TEMP || tt == Table.TableType.TRANSACTION_TEMP)) {
                return null;
            }
            return propValue;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            return propValue;
        }
    }

    static class XMLTypeColumnStoreAsConverter
    implements SXMLValueConverter {
        XMLTypeColumnStoreAsConverter() {
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (XMLTypeColumnProperties.StoreAs.CLOB.equals(propValue)) {
                return "LOB";
            }
            if (XMLTypeColumnProperties.StoreAs.BINARY_XML.equals(propValue)) {
                return "BINARY_XML";
            }
            return "OBJECT_RELATIONAL";
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            if ("LOB".equals(propValue)) {
                return XMLTypeColumnProperties.StoreAs.CLOB;
            }
            if ("BINARY_XML".equals(propValue)) {
                return XMLTypeColumnProperties.StoreAs.BINARY_XML;
            }
            return XMLTypeColumnProperties.StoreAs.OBJECT_RELATIONAL;
        }
    }

    static class ComplexTypeObjectConverter
    implements SXMLValueConverter {
        private Boolean m_val;

        public ComplexTypeObjectConverter(Boolean val) {
            this.m_val = val;
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (owner instanceof Type && propValue instanceof Boolean && this.m_val.equals(propValue) && "OBJECT".equals(((Type)owner).getTypeCode())) {
                return true;
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            if (owner instanceof Type && "OBJECT".equals(((Type)owner).getTypeCode())) {
                return this.m_val;
            }
            return this.m_val == false;
        }
    }

    static class KeyCompressionConverter
    implements SXMLValueConverter {
        private boolean m_retainZero;

        public KeyCompressionConverter(boolean retainZero) {
            this.m_retainZero = retainZero;
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (propValue instanceof Integer) {
                if (!this.m_retainZero && Integer.valueOf(0).equals(propValue)) {
                    Index index = null;
                    if (owner instanceof OracleIndexOrganizedTableProperties) {
                        OracleIndexOrganizedTableProperties props = (OracleIndexOrganizedTableProperties)owner;
                        DBObject parent = props.getParent();
                        if (parent instanceof Table) {
                            for (Constraint c : ((Table)parent).getConstraints()) {
                                if (!(c instanceof PKConstraint)) continue;
                                DBObjectID indexid = ((PKConstraint)c).getIndexID();
                                try {
                                    index = (Index)indexid.resolveID();
                                }
                                catch (DBException dBException) {}
                                break;
                            }
                        }
                    } else {
                        index = owner instanceof Index ? (Index)owner : null;
                    }
                    if (index != null) {
                        int reserved;
                        Index.IndexType type = index.getIndexType();
                        int numExpr = index.getColumnExpressions().length;
                        if (numExpr - (reserved = Index.IndexType.NORMAL.equals((Object)type) ? 0 : (Index.IndexType.UNIQUE.equals((Object)type) ? 1 : numExpr)) > 0) {
                            return numExpr - reserved;
                        }
                    }
                }
                return propValue;
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue instanceof String) {
                if ("Y".equals(propValue)) {
                    return 0;
                }
                if ("N".equals(propValue)) {
                    return null;
                }
                return propValue;
            }
            return null;
        }
    }

    static class TableCompressionConverter
    implements SXMLValueConverter {
        TableCompressionConverter() {
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (propValue == null) {
                return owner instanceof TablePartition ? "N" : null;
            }
            if (propValue == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_HIGH || propValue == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_LOW) {
                return "ARCHIVE";
            }
            if (propValue == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_HIGH || propValue == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_LOW) {
                return "QUERY";
            }
            if (propValue == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_OLTP) {
                return "OLTP";
            }
            if (propValue == OracleTableProperties.OracleTableCompression.COMPRESS) {
                return "BASIC";
            }
            if (propValue == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ALL_OPERATIONS) {
                return "ALL";
            }
            if (propValue == OracleTableProperties.OracleTableCompression.COMPRESS_FOR_DIRECT_LOAD_OPERATIONS) {
                return "DIRECT_LOAD";
            }
            return "N";
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue == null) {
                return owner instanceof TablePartition ? "NOCOMPRESS" : null;
            }
            if ("N".equals(propValue)) {
                return OracleTableProperties.OracleTableCompression.NOCOMPRESS;
            }
            if ("OLTP".equals(propValue)) {
                return OracleTableProperties.OracleTableCompression.COMPRESS_FOR_OLTP;
            }
            if ("ALL".equals(propValue)) {
                return OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ALL_OPERATIONS;
            }
            if ("OLTP".equals(propValue)) {
                return OracleTableProperties.OracleTableCompression.COMPRESS_FOR_OLTP;
            }
            if ("ARCHIVE".equals(propValue)) {
                return OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_HIGH;
            }
            if ("QUERY".equals(propValue)) {
                return OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_HIGH;
            }
            return "COMPRESS";
        }
    }

    static class MVRefreshStartWithConverter
    implements SXMLValueConverter {
        private static final String PREFIX = "GREATEST(SYSDATE,TO_DATE('";
        private static final String SUFFIX = "','YYYY.MM.DD.HH24.MI.SS'))";
        private static final String FORMAT_MASK = "yyyy.MM.dd.HH.mm.ss";
        private static final String OLD_FORMAT_MASK = "EEE MMM dd HH:mm:ss zzz yyyy";

        MVRefreshStartWithConverter() {
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (propValue instanceof Date) {
                StringBuilder sb = new StringBuilder();
                Date d = (Date)propValue;
                SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_MASK);
                sb.append(PREFIX);
                sb.append(sdf.format(d));
                sb.append(SUFFIX);
                return sb.toString();
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue instanceof String) {
                SimpleDateFormat sdf;
                String str = (String)propValue;
                if (str.startsWith(PREFIX) && str.endsWith(SUFFIX)) {
                    str = str.substring(PREFIX.length(), str.length() - SUFFIX.length());
                    sdf = new SimpleDateFormat(FORMAT_MASK);
                } else {
                    sdf = new SimpleDateFormat(OLD_FORMAT_MASK);
                }
                try {
                    return sdf.parse(str);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    static class MVRefreshConverter
    implements SXMLValueConverter {
        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (owner instanceof MaterializedView && ((MaterializedView)owner).getRefreshMode() == MaterializedView.RefreshMode.NEVER) {
                return false;
            }
            return propValue;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            return propValue;
        }
    }

    class MVRefreshValueCheckingConverter
    extends ValueCheckingConverter {
        MVRefreshValueCheckingConverter(Object ... values) {
            super(values);
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (owner instanceof MaterializedView && ((MaterializedView)owner).getRefreshMode() == MaterializedView.RefreshMode.NEVER) {
                return false;
            }
            return super.getXMLValue(owner, propValue);
        }
    }

    static class ColumnNotNullConverter
    implements SXMLValueConverter {
        ColumnNotNullConverter() {
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (owner != null && owner instanceof Column && ((Column)owner).getRelation() instanceof View) {
                return false;
            }
            return propValue;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            return true;
        }
    }

    static class TempTableTypeConverter
    implements SXMLValueConverter {
        TempTableTypeConverter() {
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (propValue == Table.TableType.TRANSACTION_TEMP) {
                return "DELETE";
            }
            if (propValue == Table.TableType.SESSION_TEMP) {
                return "PRESERVE";
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            throw new UnsupportedOperationException("Done be PhysicalPropsSXMLGenerator.readNode()");
        }
    }

    static class CacheFlagConverter
    implements SXMLValueConverter {
        CacheFlagConverter() {
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (propValue != null && !((Boolean)propValue).booleanValue()) {
                return 0;
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue != null && propValue.equals("0")) {
                return false;
            }
            return propValue != null;
        }
    }

    static class ValueMappingConverter
    implements SXMLValueConverter {
        private final Map<?, ?> m_map;

        public ValueMappingConverter(Map<?, ?> map) {
            this.m_map = map;
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            Object retval = this.m_map.containsKey(propValue) ? this.m_map.get(propValue) : propValue;
            return retval;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            Object retval = propValue;
            for (Map.Entry<?, ?> entry : this.m_map.entrySet()) {
                if (!ModelUtil.areEqual(entry.getValue(), (Object)propValue)) continue;
                retval = entry.getKey();
                break;
            }
            return retval;
        }
    }

    static class ParallelConverter
    implements SXMLValueConverter {
        private OwnerType m_ownerTypeContext;

        ParallelConverter() {
            this.m_ownerTypeContext = OwnerType.TABLE;
        }

        ParallelConverter(OwnerType ownerType) {
            this.m_ownerTypeContext = ownerType;
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            Integer degree;
            if (propValue == null) {
                return null;
            }
            if (this.m_ownerTypeContext == OwnerType.INDEX || this.m_ownerTypeContext == OwnerType.DOMAIN_INDEX) {
                Index idx;
                Index index = idx = owner instanceof Index ? (Index)owner : null;
                if (idx == null || this.m_ownerTypeContext == OwnerType.DOMAIN_INDEX && idx.getDomainIndextype() == null || this.m_ownerTypeContext == OwnerType.INDEX && idx.getDomainIndextype() != null) {
                    return null;
                }
            }
            return (degree = (Integer)propValue) == 0 ? "AUTOMATIC" : degree;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            if ("AUTOMATIC".equals(propValue)) {
                return 0;
            }
            return propValue;
        }

        static enum OwnerType {
            TABLE,
            MATERIALIZED_VIEW,
            INDEX,
            DOMAIN_INDEX;

        }
    }

    static class CommaSeperatingStringArrayConverter
    implements SXMLValueConverter {
        CommaSeperatingStringArrayConverter() {
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            StringBuffer buff = new StringBuffer();
            if (propValue != null) {
                Object[] s = (Object[])propValue;
                for (int i = 0; i < s.length; ++i) {
                    if (buff.length() > 0) {
                        buff.append(", ");
                    }
                    buff.append(s[i]);
                }
            }
            return buff.length() > 0 ? buff.toString() : null;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue instanceof String) {
                PlSqlToken startTk;
                PlSqlToken endTk = startTk = PlSqlTokenizer.tokenize((String)((String)propValue), (String[])new String[0]);
                ArrayList<String> chunks = new ArrayList<String>();
                int parens = 0;
                while (true) {
                    boolean reachedEnd;
                    boolean bl = reachedEnd = endTk.getType() == Token.Type.END_MARKER;
                    if (endTk.matches("(")) {
                        ++parens;
                    } else if (endTk.matches(")")) {
                        --parens;
                    } else if (reachedEnd || endTk.matches(",") && parens == 0) {
                        chunks.add(startTk.getSource(false, endTk.getPrevToken()));
                        startTk = (PlSqlToken)endTk.getNextToken();
                    }
                    if (reachedEnd) break;
                    endTk = (PlSqlToken)endTk.getNextToken();
                }
                String[] retval = new String[chunks.size()];
                for (int i = 0; i < chunks.size(); ++i) {
                    retval[i] = ((String)chunks.get(i)).trim();
                }
                return retval;
            }
            return null;
        }
    }

    class InverseValueCheckingConverter
    implements SXMLValueConverter {
        private Object m_value;

        InverseValueCheckingConverter(Object value) {
            this.m_value = value;
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            return !ModelUtil.areEqual((Object)propValue, (Object)this.m_value);
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue instanceof Boolean) {
                return (Boolean)propValue != false ? null : this.m_value;
            }
            return propValue == null ? this.m_value : null;
        }
    }

    class ValueCheckingConverter
    implements SXMLValueConverter {
        private Object[] m_values;

        ValueCheckingConverter(Object ... values) {
            this.m_values = values;
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            for (Object o : this.m_values) {
                if (!ModelUtil.areEqual((Object)propValue, (Object)o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue instanceof Boolean) {
                return (Boolean)propValue != false ? this.m_values[0] : null;
            }
            return this.m_values[0];
        }
    }

    static class VAAsLOBConverter
    implements SXMLValueConverter {
        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (propValue != null) {
                return "LOB";
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            return propValue != null;
        }
    }

    static class LOBRetentionConverter
    implements SXMLValueConverter {
        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (((Boolean)propValue).booleanValue()) {
                return "AUTO";
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            return propValue != null;
        }
    }

    static class LOBCacheConverter
    implements SXMLValueConverter {
        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (ModelUtil.areEqual((Object)LOBDescriptor.LOBCache.CACHE, (Object)propValue)) {
                return "Y";
            }
            if (ModelUtil.areEqual((Object)LOBDescriptor.LOBCache.NOCACHE, (Object)propValue)) {
                return "N";
            }
            if (ModelUtil.areEqual((Object)LOBDescriptor.LOBCache.CACHE_READS, (Object)propValue)) {
                return "READS";
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            if (ModelUtil.areEqual((Object)"Y", (Object)propValue)) {
                return LOBDescriptor.LOBCache.CACHE;
            }
            if (ModelUtil.areEqual((Object)"N", (Object)propValue)) {
                return LOBDescriptor.LOBCache.NOCACHE;
            }
            if (ModelUtil.areEqual((Object)"READS", (Object)propValue)) {
                return LOBDescriptor.LOBCache.CACHE_READS;
            }
            return null;
        }
    }

    static class YNBooleanConverter
    implements SXMLValueConverter {
        private Object m_yes;
        private Object m_no;

        public YNBooleanConverter() {
        }

        public YNBooleanConverter(Object yes, Object no) {
            this.m_yes = yes;
            this.m_no = no;
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (this.m_yes != null) {
                if (ModelUtil.areEqual((Object)this.m_yes, (Object)propValue)) {
                    return "Y";
                }
                if (ModelUtil.areEqual((Object)this.m_no, (Object)propValue)) {
                    return "N";
                }
                return null;
            }
            return propValue == null ? null : ((Boolean)propValue != false ? "Y" : "N");
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue == null) {
                return null;
            }
            if (this.m_yes != null) {
                if (ModelUtil.areEqual((Object)"Y", (Object)propValue)) {
                    return this.m_yes;
                }
                if (ModelUtil.areEqual((Object)"N", (Object)propValue)) {
                    return this.m_no;
                }
                return null;
            }
            if (propValue instanceof Boolean) {
                return propValue;
            }
            if (ModelUtil.areEqual((Object)"Y", (Object)propValue)) {
                return true;
            }
            if (ModelUtil.areEqual((Object)"N", (Object)propValue)) {
                return false;
            }
            return null;
        }
    }

    static class InverseBooleanConverter
    implements SXMLValueConverter {
        private final Boolean m_nullValue;

        InverseBooleanConverter() {
            this(null);
        }

        InverseBooleanConverter(Boolean nullValue) {
            this.m_nullValue = nullValue;
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (propValue == null) {
                return this.m_nullValue;
            }
            return Boolean.FALSE.equals(propValue);
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            return Boolean.FALSE;
        }
    }

    static class Mapping {
        private String m_elemPath;
        private String m_propPath;
        private SXMLValueConverter m_con;

        Mapping(String elemPath, String propPath, SXMLValueConverter con) {
            this.m_elemPath = elemPath;
            this.m_propPath = propPath;
            this.m_con = con;
        }

        String getElementPath() {
            return this.m_elemPath;
        }

        String getPropertyPath() {
            return this.m_propPath;
        }

        SXMLValueConverter getConverter() {
            return this.m_con;
        }
    }
}

