/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlDatatype;
import oracle.javatools.db.plsql.PlSqlSchemaObjectBody;
import oracle.javatools.db.plsql.PlSqlSchemaObjectSpec;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlStatement;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.PlSqlVariable;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.parser.AbstractPlSqlBuilder;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.plsql.parser.PlSqlParserHelper;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.Tokenizer;
import oracle.javatools.util.Tuple;

public class SQLDevPlSqlParserImpl
extends PlSqlParser {
    private final List<PlSqlToken> m_plsqlTokens;
    private final SqlEarley m_earleyInstance = SqlEarley.getInstance();
    private List<LexerToken> m_lexerTokens;
    private LazyNode m_parseRootNode;
    private Boolean m_isWrapped;
    private PlSqlToken m_typeToken;
    private PlSqlToken m_nameToken;
    private Integer m_endOffsetOfObject;
    private List<PlSqlParser.Issue> m_issues = null;
    private static final Map<Token, Token.Type> s_map = new HashMap<Token, Token.Type>();

    SQLDevPlSqlParserImpl(DBObjectProvider pro, PlSqlSourceObject pso, String source) {
        super(pro, pso, source);
        this.m_plsqlTokens = new ArrayList<PlSqlToken>();
        String src = this.getSource();
        int length = src == null ? 0 : src.length();
        PlSqlTokenImpl first = new PlSqlTokenImpl(Token.Type.END_MARKER, -1, null);
        first.setEnd(-1);
        this.m_plsqlTokens.add(first);
        PlSqlTokenImpl last = new PlSqlTokenImpl(Token.Type.END_MARKER, length + 1, null);
        last.setEnd(length + 1);
        this.m_plsqlTokens.add(last);
    }

    public synchronized List<LexerToken> getLexerTokens() throws CancelledException {
        if (this.m_lexerTokens == null) {
            String src = this.getSource();
            if (src != null) {
                List lexerTokens = LexerToken.parse((String)src);
                CancelledException.checkInterrupt();
                if (lexerTokens.size() <= 0 || !"CREATE".equalsIgnoreCase(((LexerToken)lexerTokens.get((int)0)).content)) {
                    lexerTokens.add(0, new LexerToken((CharSequence)"CREATE", 0, 0, Token.IDENTIFIER));
                }
                if (!";".equals(((LexerToken)lexerTokens.get((int)(lexerTokens.size() - 1))).content)) {
                    int len = this.getSource().length();
                    lexerTokens.add(new LexerToken((CharSequence)";", len, len, Token.OPERATION));
                }
                LazyNode root = StackParser.getInstance().parse(lexerTokens);
                CancelledException.checkInterrupt();
                this.m_lexerTokens = lexerTokens;
                this.m_parseRootNode = root;
            } else {
                this.m_lexerTokens = null;
                this.m_parseRootNode = null;
            }
        }
        return this.m_lexerTokens;
    }

    public synchronized ParseNode getParseRootNode() throws CancelledException {
        this.getLexerTokens();
        return this.m_parseRootNode;
    }

    public PlSqlToken getTokenAtOffset(int offset) throws CancelledException {
        return this.getTokenAtOffsetImpl(offset, false);
    }

    public Object getParseNode(DBObjectPlSqlFragment frag) throws CancelledException {
        ParseNode ret = null;
        ParseNode parseRootNode = this.getParseRootNode();
        if (parseRootNode != null) {
            boolean expandIfReqd = !(frag instanceof PlSqlSchemaObjectSpec) && !(frag instanceof PlSqlSchemaObjectBody);
            ParseNode pnode = this.getRealParseNode(parseRootNode, expandIfReqd);
            ret = this.findParseNode(pnode, frag, true);
        }
        return ret;
    }

    public DBObjectPlSqlFragment createFragment(DBObjectPlSqlFragment parentFragment, Object ppNode, Object pNode) throws CancelledException {
        PlSqlStatement.Type type;
        Object retval;
        PlSqlToken tk;
        int end;
        int start;
        block35: {
            ArrayList<String> rules;
            block42: {
                block40: {
                    block41: {
                        block36: {
                            block39: {
                                block38: {
                                    block37: {
                                        block34: {
                                            ParseNode parseNode = this.getRealParseNode(pNode, false);
                                            start = this.getStartOffset(parseNode);
                                            end = this.getEndOffset(parseNode);
                                            tk = this.getTokenAtOffset(start);
                                            rules = new ArrayList<String>();
                                            for (int i = 0; i < parseNode.content().length; ++i) {
                                                int c = parseNode.content()[i];
                                                if (c == -1) continue;
                                                rules.add(this.m_earleyInstance.allSymbols[c]);
                                            }
                                            retval = null;
                                            type = null;
                                            if (!(pNode instanceof DummyParseNode)) break block34;
                                            if (tk.matches("CURSOR")) {
                                                retval = AbstractPlSqlBuilder.createPlSqlSubProgram(this.getRoot());
                                                type = PlSqlStatement.Type.CURSOR;
                                            } else {
                                                retval = tk.matches("TYPE") || tk.matches("SUBTYPE") ? AbstractPlSqlBuilder.createFragment(PlSqlDatatype.class) : AbstractPlSqlBuilder.createFragment(PlSqlVariable.class);
                                            }
                                            break block35;
                                        }
                                        if (!(parentFragment instanceof PlSqlSubProgram)) break block36;
                                        if (!rules.contains("basic_decl_item")) break block37;
                                        if (tk.matches("TYPE") || tk.matches("SUBTYPE")) {
                                            retval = AbstractPlSqlBuilder.createFragment(PlSqlDatatype.class);
                                        } else if (tk.matches("CURSOR")) {
                                            retval = AbstractPlSqlBuilder.createFragment(PlSqlSubProgram.class);
                                            type = PlSqlStatement.Type.CURSOR;
                                        } else {
                                            retval = AbstractPlSqlBuilder.createFragment(PlSqlVariable.class);
                                        }
                                        break block35;
                                    }
                                    if (!rules.contains("seq_of_stmts")) break block38;
                                    if (tk.matches("for")) {
                                        retval = AbstractPlSqlBuilder.createFragment(PlSqlBlock.class);
                                        type = PlSqlStatement.Type.FOR_LOOP;
                                    } else if (((String)rules.get(0)).endsWith("stmt")) {
                                        retval = AbstractPlSqlBuilder.createFragment(PlSqlStatement.class);
                                    } else {
                                        retval = AbstractPlSqlBuilder.createFragment(PlSqlBlock.class);
                                        type = PlSqlStatement.Type.BEGIN;
                                    }
                                    break block35;
                                }
                                if (!rules.contains("select")) break block39;
                                retval = AbstractPlSqlBuilder.createFragment(PlSqlStatement.class);
                                break block35;
                            }
                            if (!"excptn_handler".equals(rules.get(0))) break block35;
                            retval = AbstractPlSqlBuilder.createFragment(PlSqlStatement.class);
                            type = PlSqlStatement.Type.EX_WHEN;
                            break block35;
                        }
                        if (!(parentFragment instanceof PlSqlSchemaObjectSpec) && !(parentFragment instanceof PlSqlSchemaObjectBody)) break block40;
                        if (!(ppNode instanceof LazyNode) && (!(ppNode instanceof ParseNode) || !rules.contains("subprg_d"))) break block35;
                        if (!tk.matches("procedure")) break block41;
                        retval = AbstractPlSqlBuilder.createFragment(PlSqlSubProgram.class);
                        type = PlSqlStatement.Type.PROCEDURE;
                        break block35;
                    }
                    if (!tk.matches("function")) break block35;
                    retval = AbstractPlSqlBuilder.createFragment(PlSqlSubProgram.class);
                    type = PlSqlStatement.Type.FUNCTION;
                    break block35;
                }
                if (!(parentFragment instanceof Trigger)) break block42;
                if (!rules.contains("block_stmt")) break block35;
                retval = AbstractPlSqlBuilder.createFragment(PlSqlBlock.class);
                type = PlSqlStatement.Type.BEGIN;
                break block35;
            }
            if ("BLOCK".equals(parentFragment.getType()) || "STATEMENT".equals(parentFragment.getType())) {
                if ("block_stmt".equals(rules.get(0))) {
                    retval = AbstractPlSqlBuilder.createFragment(PlSqlBlock.class);
                    type = PlSqlStatement.Type.BEGIN;
                } else if ("elsif_clause_opt".equals(rules.get(0))) {
                    retval = AbstractPlSqlBuilder.createFragment(PlSqlStatement.class);
                    type = PlSqlStatement.Type.ELSIF;
                } else if ("else_clause_opt".equals(rules.get(0))) {
                    retval = AbstractPlSqlBuilder.createFragment(PlSqlStatement.class);
                    type = PlSqlStatement.Type.ELSE;
                } else if ("identifier".equals(rules.get(0)) && ((PlSqlToken)tk.getPrevCodeToken()).matches("FOR")) {
                    retval = AbstractPlSqlBuilder.createFragment(PlSqlVariable.class);
                } else if (rules.contains("basic_decl_item")) {
                    if (tk.matches("TYPE") || tk.matches("SUBTYPE")) {
                        retval = AbstractPlSqlBuilder.createFragment(PlSqlDatatype.class);
                    } else if (tk.matches("CURSOR")) {
                        retval = AbstractPlSqlBuilder.createFragment(PlSqlSubProgram.class);
                        type = PlSqlStatement.Type.CURSOR;
                    } else {
                        retval = AbstractPlSqlBuilder.createFragment(PlSqlVariable.class);
                    }
                } else {
                    for (String rule : rules) {
                        if (!rule.endsWith("stmt")) continue;
                        if (tk.matches("for")) {
                            retval = AbstractPlSqlBuilder.createFragment(PlSqlBlock.class);
                            type = PlSqlStatement.Type.FOR_LOOP;
                            break;
                        }
                        retval = AbstractPlSqlBuilder.createFragment(PlSqlStatement.class);
                        break;
                    }
                }
            }
        }
        if (retval != null) {
            retval.setStartOffset(Integer.valueOf(start));
            retval.setEndOffset(Integer.valueOf(end));
            if (retval instanceof PlSqlStatement) {
                if ("STATEMENT".equals(retval.getType())) {
                    if (type == null) {
                        try {
                            type = PlSqlStatement.Type.valueOf((String)tk.getSource(true));
                        }
                        catch (Exception e) {
                            type = PlSqlStatement.Type.STATEMENT;
                        }
                    }
                    ((PlSqlStatement)retval).setStatementType(PlSqlStatement.Type.STATEMENT);
                }
                ((PlSqlStatement)retval).setStatementType(type);
            }
        }
        return retval;
    }

    public List<Tuple<PlSqlToken, PlSqlToken>> getAlterStatements() throws CancelledException {
        ArrayList<Tuple<PlSqlToken, PlSqlToken>> ret = new ArrayList<Tuple<PlSqlToken, PlSqlToken>>();
        PlSqlSourceObject root = this.getRoot();
        ParseNode parseRootNode = this.getParseRootNode();
        if (root instanceof Type && parseRootNode != null) {
            ParseNode pn = this.getRealParseNode(parseRootNode, true);
            Type type = (Type)root;
            String path = "OBJECT".equals(type.getTypeCode()) ? ".../alt_ty_a_statement" : ".../alt_array_a_statement";
            List<ParseNode> nodes = this.findNodes(pn, path);
            for (ParseNode child : nodes) {
                PlSqlToken tk1 = this.getTokenAtOffset(this.getStartOffset(child));
                PlSqlToken tk2 = this.getTokenAtOffset(this.getEndOffset(child));
                ret.add((Tuple<PlSqlToken, PlSqlToken>)new Tuple((Object)tk1, (Object)tk2));
            }
        } else if (root instanceof Trigger && parseRootNode != null) {
            ParseNode pn = this.getRealParseNode(parseRootNode, true);
            int rootTo = pn.to;
            ParseNode lastChild = null;
            Iterator nodes = pn.children().iterator();
            while (nodes.hasNext()) {
                ParseNode child;
                lastChild = child = (ParseNode)nodes.next();
            }
            if (rootTo != lastChild.to) {
                LexerToken bob = this.getLexerTokens().get(lastChild.to);
                if ("ALTER".equalsIgnoreCase(bob.content)) {
                    PlSqlToken tk1 = this.getTokenAtOffset(bob.begin);
                    PlSqlToken tk2 = this.getTokenAtOffset(root.getEndOffset());
                    ret.add((Tuple<PlSqlToken, PlSqlToken>)new Tuple((Object)tk1, (Object)tk2));
                }
            }
        }
        return ret;
    }

    public int getStartOffset(Object parseNode) throws IllegalArgumentException, CancelledException {
        ParseNode pnode = this.getRealParseNode(parseNode, false);
        int from = pnode.from;
        List<LexerToken> lexerTokens = this.getLexerTokens();
        if (from >= lexerTokens.size()) {
            from = lexerTokens.size() - 1;
        }
        LexerToken tk = lexerTokens.get(from);
        return tk.begin;
    }

    public int getStartOffsetOfObject() throws CancelledException {
        PlSqlToken tk = this.getTypeToken();
        return tk == null ? 0 : tk.getStart();
    }

    public int getEndOffset(Object parseNode) throws IllegalArgumentException, CancelledException {
        ParseNode pnode = this.getRealParseNode(parseNode, false);
        int to = pnode.to;
        List<LexerToken> lexerTokens = this.getLexerTokens();
        if (to > lexerTokens.size()) {
            to = lexerTokens.size();
        }
        LexerToken tk = lexerTokens.get(to - 1);
        return tk.end - 1;
    }

    public int getEndOffsetOfObject() throws CancelledException {
        if (this.m_endOffsetOfObject == null) {
            PlSqlToken tk = this.getTokenAtOffset(this.getSource().length() - 1);
            if (tk != null) {
                List alters;
                PlSqlSourceObject root = this.getRoot();
                if ((root instanceof Type || root instanceof Trigger) && (alters = this.getLocationOffsets("ALTER")).size() > 0) {
                    PlSqlSearch search = new PlSqlSearch("alter " + this.getRoot().getType() + " [? .] " + this.getRoot().getName());
                    for (Integer altPos : alters) {
                        PlSqlToken altTk = this.getTokenAtOffset(altPos);
                        if (!search.matches(altTk)) continue;
                        tk = (PlSqlToken)search.getStartToken().getPrevCodeToken();
                        break;
                    }
                }
                if (!tk.isCode()) {
                    tk = (PlSqlToken)tk.getPrevCodeToken();
                }
                this.m_endOffsetOfObject = tk.getEnd();
            }
            if (this.m_endOffsetOfObject == null) {
                this.m_endOffsetOfObject = 0;
            }
        }
        return this.m_endOffsetOfObject;
    }

    public PlSqlToken getNameToken() throws CancelledException {
        if (this.m_nameToken == null) {
            PlSqlUtil.TypeAndNameInfo info = PlSqlUtil.getTypeAndNameFromSource(this.getSource(), this.getProvider().getDescriptor());
            this.m_nameToken = this.getTokenAtOffset(info.getNameEnd());
        }
        return this.m_nameToken;
    }

    public PlSqlToken getSchemaToken() throws CancelledException {
        PlSqlToken tk = this.getNameToken();
        if (tk != null && ((PlSqlToken)tk.getPrevToken()).matches(".")) {
            return (PlSqlToken)((PlSqlToken)tk.getPrevCodeToken()).getPrevCodeToken();
        }
        return null;
    }

    public PlSqlToken getTypeToken() throws CancelledException {
        if (this.m_typeToken == null) {
            PlSqlUtil.TypeAndNameInfo info = PlSqlUtil.getTypeAndNameFromSource(this.getSource(), this.getProvider().getDescriptor());
            this.m_typeToken = this.getTokenAtOffset(info.getTypeStart());
        }
        return this.m_typeToken;
    }

    public Object getParseNode(int offset) throws CancelledException {
        ParseNode ret = this.getParseNodeImpl(this.getParseRootNode(), offset);
        return ret;
    }

    public boolean isWrapped() throws CancelledException {
        PlSqlToken tk;
        if (this.m_isWrapped == null && (tk = this.getNameToken()) != null && (tk = (PlSqlToken)tk.getNextCodeToken()) != null) {
            this.m_isWrapped = tk.matches("WRAPPED");
        }
        return this.m_isWrapped == null ? false : this.m_isWrapped;
    }

    public List<PlSqlParser.Issue> getIssues() throws CancelledException {
        if (this.m_issues == null) {
            PlSqlSourceObject root = this.getRoot();
            if (root instanceof Type && "COLLECTION".equals(((Type)root).getTypeCode())) {
                this.m_issues = Collections.emptyList();
            } else {
                int alterStart = -1;
                Iterator<Tuple<PlSqlToken, PlSqlToken>> iterator = this.getAlterStatements().iterator();
                if (iterator.hasNext()) {
                    Tuple<PlSqlToken, PlSqlToken> alter = iterator.next();
                    alterStart = ((PlSqlToken)alter.getFirst()).getStart();
                }
                if (alterStart > -1 && root instanceof PlSqlSourceObject) {
                    PlSqlSourceObject pso = root;
                    SQLDevPlSqlParserImpl delegate = new SQLDevPlSqlParserImpl(this.getProvider(), null, pso.getSource().substring(0, alterStart));
                    this.m_issues = delegate.getIssues();
                } else {
                    this.m_issues = PlSqlParserHelper.getIssues(this.getLexerTokens(), (LazyNode)this.getParseRootNode(), this.getSource());
                }
            }
        }
        return this.m_issues;
    }

    public List<PlSqlParser.Issue> getIssues(String source) {
        return PlSqlParserHelper.getIssues(this.getSource());
    }

    public List getChildParseNodes(DBObjectPlSqlFragment frag, Object parseNode) throws IllegalArgumentException, CancelledException {
        LazyNode ln;
        boolean expandIfReqd = frag != null && !(frag instanceof PlSqlSchemaObjectSpec) && !(frag instanceof PlSqlSchemaObjectBody);
        ParseNode pn = this.getRealParseNode(parseNode, expandIfReqd);
        ArrayList<ParseNode> ret = new ArrayList<ParseNode>();
        ret.addAll(pn.children());
        String rule = this.getRuleZero(pn);
        if ("if_stmt".equals(rule)) {
            this.flattenElsif(ret);
        } else if ("elsif_clause_opt".equals(rule)) {
            this.pruneElsif(ret);
        }
        if (pn instanceof LazyNode && (ln = (LazyNode)pn).isAs()) {
            int start;
            int end = start = ln.from + 1;
            for (ParseNode kid : ln.children()) {
                LazyNode lkid = (LazyNode)kid;
                if (kid.from == end) {
                    start = kid.to;
                } else if (lkid.isProcedure()) {
                    this.createDummyNodes(start, lkid.from - 1, ret);
                    start = kid.to;
                }
                end = kid.to;
            }
            if (start == ln.from + 1) {
                this.createDummyNodes(start, ln.to - 1, ret);
            }
        }
        return ret;
    }

    private void flattenElsif(List<ParseNode> list) {
        for (int index = 0; index < list.size(); ++index) {
            ParseNode pn = list.get(index);
            String rule = this.getRuleZero(pn);
            if (!"elsif_clause_opt".equals(rule)) continue;
            ParseNode child = (ParseNode)pn.children().iterator().next();
            String childRule = this.getRuleZero(child);
            if (!"elsif_clause_opt".equals(childRule)) break;
            list.add(index, child);
            this.flattenElsif(list);
            break;
        }
    }

    private void pruneElsif(List<ParseNode> list) {
        boolean done = false;
        do {
            if ("'THEN'".equals(this.getRuleZero(list.get(0)))) {
                done = true;
            }
            list.remove(0);
        } while (!list.isEmpty() && !done);
    }

    private String getRuleZero(ParseNode pn) {
        String ret = null;
        int rule = pn.content()[0];
        if (rule > 0) {
            ret = this.m_earleyInstance.allSymbols[rule];
        }
        return ret == null ? "" : ret;
    }

    protected Object[] getPropertyNodesImpl(DBObjectPlSqlFragment frag, String property) throws CancelledException {
        boolean expandIfLazy = !"parameters".equals(property);
        ParseNode parentNode = this.getRealParseNode(this.getParseRootNode(), expandIfLazy);
        ParseNode pnode = this.findParseNode(parentNode, frag, false);
        if ("parameters".equals(property)) {
            PlSqlToken tk;
            PlSqlToken tkEnd;
            ArrayList<ParseNode> ret = new ArrayList<ParseNode>();
            PlSqlSearch search = new PlSqlSearch("{PROCEDURE|FUNCTION} ? [<parens (...)>]");
            PlSqlToken tkStart = this.getTokenAtOffset(this.getStartOffset(pnode));
            if (search.isWithin(tkStart, tkEnd = this.getTokenAtOffset(this.getEndOffset(pnode))) && (tk = search.getNamedMatchStartToken("parens")) != null) {
                if (pnode instanceof LazyNode) {
                    for (ParseNode dec : pnode.descendants()) {
                        PlSqlToken tk2 = this.getTokenAtOffset(this.getStartOffset(dec));
                        if (tk2 != tk) continue;
                        pnode = this.getRealParseNode(dec, true);
                        break;
                    }
                }
                ret.addAll(this.findNodes(pnode, ".../prm_spec"));
            }
            return ret.toArray(new Object[ret.size()]);
        }
        if (frag instanceof Trigger) {
            String ruleToFind = null;
            if ("timing".equals(property)) {
                ruleToFind = ".../simple_dml_trigger|instead_of_dml_trigger|system_trigger";
            } else if ("events".equals(property)) {
                ruleToFind = ".../dml_event_clause|database_or_ddl_event|*,database_or_ddl_event";
            } else if ("baseObjectID".equals(property)) {
                ruleToFind = ".../'ON'";
            } else if ("columnIDs".equals(property)) {
                pnode = (ParseNode)this.getPropertyNode(frag, "events");
                if (pnode != null) {
                    ruleToFind = ".../updateof_column|identifier,updateof_column";
                }
            } else if ("referencingNewAs".equals(property)) {
                ruleToFind = ".../referencing_clause";
            } else if ("statementLevel".equals(property)) {
                ruleToFind = ".../rowOpt";
            } else if ("whenClause".equals(property)) {
                ruleToFind = ".../when_condition";
            } else if ("code".equals(property)) {
                ruleToFind = ".../block_stmt";
            }
            if (ruleToFind != null) {
                ArrayList<ParseNode> ret = new ArrayList<ParseNode>();
                ret.addAll(this.findNodes(pnode, ruleToFind));
                return ret.toArray(new Object[ret.size()]);
            }
        } else if (frag instanceof Type) {
            ArrayList<ParseNode> ret = new ArrayList<ParseNode>();
            for (ParseNode field : this.findNodes(pnode, ".../adt_field")) {
                if ("attributes".equals(property) && this.findNodes(field, "decl_id").size() > 0) {
                    ret.add(field);
                    continue;
                }
                if (!"methods".equals(property) || this.findNodes(field, "subprg_d").size() <= 0) continue;
                ret.add(field);
            }
            return ret.toArray(new Object[ret.size()]);
        }
        return new Object[0];
    }

    private ParseNode getParseNodeImpl(ParseNode parent, int offset) throws CancelledException {
        ParseNode ret = parent;
        if (parent != null) {
            for (ParseNode child : parent.children()) {
                if (this.getStartOffset(child) > offset || this.getEndOffset(child) < offset) continue;
                ret = this.getParseNodeImpl(child, offset);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlSqlToken getTokenAtOffsetImpl(int offset, boolean incEndMarkers) throws CancelledException {
        PlSqlToken ret = null;
        List<PlSqlToken> list = this.m_plsqlTokens;
        synchronized (list) {
            String src = this.getSource();
            if (src != null && offset >= 0 && offset < src.length()) {
                Tuple<Integer, Boolean> ptIndexInfo = this.getIndexAtOffset(offset, this.m_plsqlTokens);
                if (((Boolean)ptIndexInfo.getSecond()).booleanValue()) {
                    ret = this.m_plsqlTokens.get((Integer)ptIndexInfo.getFirst());
                } else {
                    List<LexerToken> lexerTokens = this.getLexerTokens();
                    Tuple<Integer, Boolean> ltIndexInfo = this.getIndexAtOffset(offset, lexerTokens);
                    int ltIndexStart = (Integer)ltIndexInfo.getFirst();
                    int ltIndexEnd = ltIndexStart + 1;
                    if (((Boolean)ltIndexInfo.getSecond()).booleanValue()) {
                        LexerToken tk = lexerTokens.get(ltIndexStart);
                        if (this.isInTwoCharOperator(ltIndexStart)) {
                            if (this.isInTwoCharOperator(ltIndexStart - 1)) {
                                --ltIndexStart;
                                --ltIndexEnd;
                            }
                        } else {
                            ret = this.createPlSqlToken(offset, (Integer)ptIndexInfo.getFirst() + 1, true, ltIndexStart, ltIndexEnd);
                        }
                    }
                    if (ret == null) {
                        ret = this.createPlSqlToken(offset, (Integer)ptIndexInfo.getFirst() + 1, false, ltIndexStart, ltIndexEnd);
                    }
                }
            } else if (incEndMarkers) {
                if (offset < 0) {
                    ret = this.m_plsqlTokens.get(0);
                } else if (offset >= this.getSource().length()) {
                    ret = this.m_plsqlTokens.get(this.m_plsqlTokens.size() - 1);
                }
            }
        }
        return ret;
    }

    private boolean isInTwoCharOperator(int index) throws CancelledException {
        List<LexerToken> lexerTokens = this.getLexerTokens();
        LexerToken tk = lexerTokens.get(index);
        if (tk.type == Token.OPERATION && tk.end - tk.begin == 1) {
            if (index > 0) {
                LexerToken tkBefore = lexerTokens.get(index - 1);
                if (tkBefore.type == Token.OPERATION && tkBefore.end - tkBefore.begin == 1 && tkBefore.end == tk.begin) {
                    return PlSqlTokenizer.getTwoCharOperators().contains(tkBefore.content + tk.content);
                }
            }
            if (index < lexerTokens.size() - 1) {
                LexerToken tkNext = lexerTokens.get(index + 1);
                if (tkNext.type == Token.OPERATION && tkNext.end - tkNext.begin == 1 && tkNext.begin == tk.end) {
                    return PlSqlTokenizer.getTwoCharOperators().contains(tk.content + tkNext.content);
                }
            }
        }
        return false;
    }

    private Tuple<Integer, Boolean> getIndexAtOffset(int offset, List list) {
        return this.getIndexAtOffset(offset, list, 0, list.size() - 1, false);
    }

    private Tuple<Integer, Boolean> getIndexAtOffset(int offset, List list, int startIndex, int endIndex, boolean scan) {
        int endOffset;
        if (endIndex - startIndex < 10) {
            scan = true;
        }
        if (scan) {
            int index;
            for (index = startIndex; index <= endIndex && index < list.size(); ++index) {
                int startOffset = this.getStart(list, index);
                int endOffset2 = this.getEnd(list, index);
                if (startOffset <= offset) {
                    if (endOffset2 < offset) continue;
                    return new Tuple((Object)index, (Object)true);
                }
                if (endOffset2 >= offset) break;
            }
            return new Tuple((Object)(index - 1), (Object)false);
        }
        int startOffset = this.getStart(list, startIndex);
        int index = (int)(0L + (long)startIndex + (0L + (long)endIndex - (long)startIndex) * (0L + (long)offset - (long)startOffset) / (0L + (long)(endOffset = this.getStart(list, endIndex)) - (long)startOffset));
        if (index < 0) {
            index = 0;
        } else if (index >= list.size()) {
            index = list.size() - 1;
        }
        int start = this.getStart(list, index);
        int end = this.getEnd(list, index);
        if (start <= offset && end >= offset) {
            return new Tuple((Object)index, (Object)true);
        }
        if (index == startIndex) {
            return this.getIndexAtOffset(offset, list, startIndex, endIndex, true);
        }
        if (start < offset) {
            return this.getIndexAtOffset(offset, list, index, endIndex, false);
        }
        return this.getIndexAtOffset(offset, list, startIndex, index, false);
    }

    private int getStart(List list, int index) {
        Object o = list.get(index);
        if (o instanceof LexerToken) {
            return ((LexerToken)o).begin;
        }
        if (o instanceof PlSqlToken) {
            return ((PlSqlToken)o).getStart();
        }
        throw new IllegalArgumentException("expected LexerToken or PlSqlToken in list");
    }

    private int getEnd(List list, int index) {
        Object o = list.get(index);
        if (o instanceof LexerToken) {
            return ((LexerToken)o).end - 1;
        }
        if (o instanceof PlSqlToken) {
            return ((PlSqlToken)o).getEnd();
        }
        throw new IllegalArgumentException("expected LexerToken or PlSqlToken in list");
    }

    private PlSqlToken createPlSqlToken(int offset, int ptIndex, boolean ltBased, int ltIndexStart, int ltIndexEnd) throws CancelledException {
        List<LexerToken> lexerTokens = this.getLexerTokens();
        PlSqlToken beforeTK = this.m_plsqlTokens.get(ptIndex - 1);
        PlSqlToken afterTK = this.m_plsqlTokens.get(ptIndex);
        PlSqlTokenImpl firstTk = null;
        PlSqlTokenImpl lastTk = null;
        PlSqlTokenImpl retTk = null;
        if (ltBased) {
            LexerToken lt = lexerTokens.get(ltIndexStart);
            firstTk = retTk = new PlSqlTokenImpl(lt.begin, lt.end - 1, this.getType(lt.type));
            lastTk = retTk;
            this.m_plsqlTokens.add(ptIndex, retTk);
        } else {
            int pos = 0;
            if (ltIndexStart >= 0) {
                pos = lexerTokens.get((int)ltIndexStart).end;
            }
            int pos2 = this.getSource().length();
            if (ltIndexEnd < lexerTokens.size()) {
                pos2 = lexerTokens.get((int)ltIndexEnd).begin;
            }
            if (pos < 0) {
                pos = lexerTokens.size() > ltIndexStart + 1 ? lexerTokens.get((int)(ltIndexStart + 1)).begin : pos2;
            }
            if (pos == pos2) {
                --pos;
                if (this.isInTwoCharOperator(ltIndexStart) && this.isInTwoCharOperator(ltIndexEnd)) {
                    ++pos2;
                }
            }
            String str = this.getSource().substring(pos, pos2);
            PlSqlToken t = PlSqlTokenizer.tokenize((String)str, (Tokenizer.TokenFactory)new TokenFac(pos));
            while (t.getNextToken() != null) {
                t = (PlSqlToken)t.getNextToken();
            }
            t = (PlSqlToken)t.getPrevToken();
            lastTk = t;
            while (t.getType() != Token.Type.END_MARKER) {
                this.m_plsqlTokens.add(ptIndex, t);
                if (t.getEnd() >= offset) {
                    retTk = t;
                }
                firstTk = t;
                t = (PlSqlToken)t.getPrevToken();
            }
        }
        if (beforeTK.getEnd() == firstTk.getStart() - 1) {
            beforeTK.setNextToken((oracle.javatools.db.token.Token)firstTk);
            firstTk.setPrevToken((oracle.javatools.db.token.Token)beforeTK);
        } else {
            firstTk.setPrevToken(null);
        }
        if (afterTK.getStart() == lastTk.getEnd() + 1) {
            afterTK.setPrevToken((oracle.javatools.db.token.Token)lastTk);
            lastTk.setNextToken((oracle.javatools.db.token.Token)afterTK);
        } else {
            lastTk.setNextToken(null);
        }
        return retTk;
    }

    private Token.Type getType(Token token) {
        Token.Type ret = s_map.get(token);
        if (ret == null) {
            ret = Token.Type.UNKNOWN;
        }
        return ret;
    }

    private ParseNode findParseNode(ParseNode root, DBObjectPlSqlFragment frag, boolean strict) throws CancelledException {
        int fragStart;
        if (frag instanceof PlSqlSourceObject) {
            PlSqlToken tk = this.getTokenAtOffset(0);
            if (tk != null && !tk.isCode()) {
                tk = (PlSqlToken)tk.getNextCodeToken();
            }
            fragStart = tk != null ? tk.getStart() : frag.getStartOffset().intValue();
        } else {
            fragStart = frag.getStartOffset();
        }
        int fragEnd = frag.getEndOffset();
        int nodeStart = this.getStartOffset(root);
        int nodeEnd = this.getEndOffset(root);
        if (nodeStart == fragStart && nodeEnd == fragEnd) {
            return root;
        }
        if (nodeStart <= fragStart && nodeEnd >= fragEnd) {
            for (ParseNode kid : root.children()) {
                ParseNode ret = this.findParseNode(kid, frag, strict);
                if (ret == null) continue;
                return ret;
            }
            return strict ? null : root;
        }
        if (nodeStart == 0 && fragStart == 0 && !strict) {
            return root;
        }
        return null;
    }

    private void createDummyNodes(int start, int end, List<ParseNode> ret) throws CancelledException {
        List<LexerToken> lexerTokens = this.getLexerTokens();
        Integer nodeStart = null;
        boolean pragma = false;
        for (int currIdx = start; currIdx <= end; ++currIdx) {
            if (nodeStart == null) {
                nodeStart = currIdx;
                LexerToken firstToken = lexerTokens.get(nodeStart);
                String firstTokenStr = firstToken.content;
                pragma = "PRAGMA".equalsIgnoreCase(firstTokenStr);
            }
            LexerToken lt = lexerTokens.get(currIdx);
            if (lt.type != Token.OPERATION || !";".equals(lt.content)) continue;
            if (!pragma) {
                DummyParseNode tl = new DummyParseNode(nodeStart, currIdx + 1);
                ret.add(tl);
            }
            nodeStart = null;
        }
    }

    private ParseNode getRealParseNode(Object parseNode, boolean expandIfLazy) throws IllegalArgumentException, CancelledException {
        if (parseNode == null) {
            throw new IllegalArgumentException("parse node must not be null");
        }
        if (!(parseNode instanceof ParseNode)) {
            throw new IllegalArgumentException("parse node must be a ParseNode");
        }
        ParseNode pNode = (ParseNode)parseNode;
        if (pNode instanceof LazyNode) {
            LazyNode lNode = (LazyNode)pNode;
            ParseNode branch = lNode.getBranch();
            if (branch != null) {
                pNode = branch;
            } else if (expandIfLazy) {
                try {
                    ((LazyNode)pNode).expandInterruptably();
                }
                catch (InterruptedException e) {
                    throw new CancelledException();
                }
                branch = lNode.getBranch();
                if (branch != null) {
                    pNode = branch;
                }
            }
        }
        return pNode;
    }

    private String getSourceImpl() {
        return super.getSource();
    }

    protected List<ParseNode> findNodes(ParseNode root, String path) {
        ArrayList<ParseNode> ret = new ArrayList<ParseNode>();
        this.findNodes(root, Arrays.asList(path.split("\\/")), false, ret);
        return ret;
    }

    private void findNodes(ParseNode root, List<String> path, boolean deep, List<ParseNode> ret) {
        int pSize = path.size();
        if (pSize > 0) {
            ArrayList<String> tail = new ArrayList<String>(path);
            String head = deep ? (String)tail.get(0) : (String)tail.remove(0);
            if ("...".equals(head)) {
                if (tail.size() == 0) {
                    throw new IllegalArgumentException("Cannot end with ...");
                }
                String next = (String)tail.get(0);
                if ("...".equals(next)) {
                    throw new IllegalArgumentException("Cannot use .../...");
                }
                ArrayList<ParseNode> nextLevel = new ArrayList<ParseNode>();
                this.findNodes(root, tail, true, nextLevel);
                if (tail.size() == 1) {
                    ret.addAll(nextLevel);
                } else {
                    for (ParseNode child : nextLevel) {
                        this.findNodes(child, tail, false, ret);
                    }
                }
            } else {
                String[] options = head.split("\\|");
                for (ParseNode child : root.children()) {
                    boolean match = false;
                    for (String option : options) {
                        String[] chunks;
                        int[] content = child.content();
                        if (content == null || content.length <= 0 || content.length < (chunks = option.replaceAll("\\\\,", "/").split(",")).length) continue;
                        match = true;
                        for (int i = 0; i < chunks.length; ++i) {
                            String chunk = chunks[i].replaceAll("/", ",");
                            String parseRule = this.m_earleyInstance.allSymbols[content[i]];
                            if (chunk.contains("*")) {
                                String pattStr = chunk.replaceAll("\\*", ".*");
                                Pattern patt = Pattern.compile(pattStr);
                                if (patt.matcher(parseRule).matches()) continue;
                                match = false;
                                break;
                            }
                            if (chunk.equals(parseRule)) continue;
                            match = false;
                            break;
                        }
                        if (match) break;
                    }
                    if (match) {
                        if (deep || tail.size() == 0) {
                            ret.add(child);
                            continue;
                        }
                        this.findNodes(child, tail, false, ret);
                        continue;
                    }
                    if (!deep) continue;
                    this.findNodes(child, tail, deep, ret);
                }
            }
        } else {
            throw new IllegalArgumentException("No more path");
        }
    }

    static {
        s_map.put(Token.COMMENT, Token.Type.MULTI_LINE_COMMENT);
        s_map.put(Token.DIGITS, Token.Type.ALPHANUMERIC);
        s_map.put(Token.DQUOTED_STRING, Token.Type.DOUBLE_QUOTED_STRING);
        s_map.put(Token.IDENTIFIER, Token.Type.ALPHANUMERIC);
        s_map.put(Token.LINE_COMMENT, Token.Type.SINGLE_LINE_COMMENT);
        s_map.put(Token.OPERATION, Token.Type.PUNCTUATION);
        s_map.put(Token.QUOTED_STRING, Token.Type.SINGLE_QUOTED_STRING);
        s_map.put(Token.WS, Token.Type.WHITESPACE);
    }

    private class DummyParseNode
    extends ParseNode {
        private DummyParseNode(int begin, int end) {
            super(begin, end, -1, -1, null);
        }
    }

    private class TokenFac
    implements Tokenizer.TokenFactory {
        private final int m_offset;

        TokenFac(int offset) {
            this.m_offset = offset;
        }

        public oracle.javatools.db.token.Token createToken(Token.Type type, int start, oracle.javatools.db.token.Token prev) {
            PlSqlTokenImpl ret = new PlSqlTokenImpl(type, start + this.m_offset, prev);
            return ret;
        }

        public void setEnd(oracle.javatools.db.token.Token tk, int end) {
            tk.setEnd(end + this.m_offset);
        }
    }

    private class PlSqlTokenImpl
    extends PlSqlToken {
        PlSqlTokenImpl(int start, int end, Token.Type type) {
            super(type, start, null);
            this.setEnd(end);
        }

        PlSqlTokenImpl(Token.Type type, int start, oracle.javatools.db.token.Token prev) {
            super(type, start, (PlSqlToken)prev);
        }

        protected String getFullSource() {
            return SQLDevPlSqlParserImpl.this.getSourceImpl();
        }

        public PlSqlToken getNextToken() {
            PlSqlToken ret = (PlSqlToken)super.getNextToken();
            if (ret == null && this.getType() != Token.Type.END_MARKER) {
                try {
                    ret = SQLDevPlSqlParserImpl.this.getTokenAtOffsetImpl(this.getEnd() + 1, true);
                }
                catch (CancelledException e) {
                    DBLog.getLogger((Object)((Object)this)).fine(e.getMessage());
                    ret = (PlSqlToken)SQLDevPlSqlParserImpl.this.m_plsqlTokens.get(SQLDevPlSqlParserImpl.this.m_plsqlTokens.size() - 1);
                }
            }
            return ret;
        }

        public PlSqlToken getPrevToken() {
            PlSqlToken ret = (PlSqlToken)super.getPrevToken();
            if (ret == null && this.getType() != Token.Type.END_MARKER) {
                try {
                    ret = SQLDevPlSqlParserImpl.this.getTokenAtOffsetImpl(this.getStart() - 1, true);
                }
                catch (CancelledException e) {
                    DBLog.getLogger((Object)((Object)this)).fine(e.getMessage());
                    ret = (PlSqlToken)SQLDevPlSqlParserImpl.this.m_plsqlTokens.get(0);
                }
            }
            return ret;
        }

        public PlSqlToken getTokenAt(int pos) {
            PlSqlToken ret = null;
            try {
                ret = SQLDevPlSqlParserImpl.this.getTokenAtOffsetImpl(pos, false);
            }
            catch (CancelledException e) {
                DBLog.getLogger((Object)((Object)this)).fine(e.getMessage());
                ret = null;
            }
            return ret;
        }
    }
}

