/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.util.ArrayList;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.plsql.parser.PlSqlSourceObjectBuilder;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.Tuple;

public class TriggerBuilder
extends PlSqlSourceObjectBuilder<Trigger> {
    private String m_triggerNew;
    private String m_triggerOld;

    public TriggerBuilder(AbstractDBObjectProvider pro) {
        super(pro, "TRIGGER");
    }

    @Override
    protected void buildObjectProperties(Trigger trigger, PlSqlParser parser) throws CancelledException {
        Object codeNode;
        Object rowLevelNode;
        Object baseItemNode;
        Object eventsNode;
        Object timimngNode = parser.getPropertyNode((DBObjectPlSqlFragment)trigger, "timing");
        if (timimngNode != null) {
            PlSqlToken tk = parser.getTokenAtOffset(parser.getStartOffset(timimngNode));
            if (tk.matches("before")) {
                trigger.setTiming(Trigger.Timing.BEFORE);
            } else if (tk.matches("after")) {
                trigger.setTiming(Trigger.Timing.AFTER);
            } else if (tk.matches("instead")) {
                trigger.setTiming(Trigger.Timing.INSTEAD_OF);
            }
        }
        if ((eventsNode = parser.getPropertyNode((DBObjectPlSqlFragment)trigger, "events")) != null) {
            PlSqlToken tk;
            ArrayList<String> events = new ArrayList<String>();
            int end = parser.getEndOffset(eventsNode);
            PlSqlToken evtStartTk = tk = parser.getTokenAtOffset(parser.getStartOffset(eventsNode));
            PlSqlToken evtEndTk = tk;
            while (tk != null && tk.getType() != Token.Type.END_MARKER) {
                if (evtStartTk == null) {
                    evtStartTk = tk;
                }
                if (tk.matches("or") || tk.matches("on") || tk.getStart() > end) {
                    if (evtStartTk.matches("UPDATE") && evtEndTk != evtStartTk && ((PlSqlToken)evtStartTk.getNextCodeToken()).matches("OF")) {
                        evtEndTk = evtStartTk;
                    }
                    events.add(evtStartTk.getSource(true, (Token)evtEndTk));
                    if (!tk.matches("or")) break;
                    evtStartTk = null;
                }
                evtEndTk = tk;
                tk = (PlSqlToken)tk.getNextCodeToken();
            }
            trigger.setEvents(events.toArray(new String[events.size()]));
        }
        if ((baseItemNode = parser.getPropertyNode((DBObjectPlSqlFragment)trigger, "baseObjectID")) != null) {
            Trigger.BaseType baseType = null;
            Schema baseSchema = null;
            DBObjectID baseObjectID = null;
            ArrayList<ReferenceID> columnIDs = new ArrayList<ReferenceID>();
            String tableName = null;
            Relation rel = null;
            ArrayList<String> names = new ArrayList<String>();
            String nestedTableToCheck = null;
            baseType = null;
            PlSqlToken tk = parser.getTokenAtOffset(parser.getStartOffset(baseItemNode));
            if (tk.matches("ON")) {
                tk = (PlSqlToken)tk.getNextCodeToken();
            }
            if (tk.matches("NESTED")) {
                tk = (PlSqlToken)tk.getNextCodeToken(2);
                nestedTableToCheck = this.getProvider().getInternalName(tk.getSource());
                tk = (PlSqlToken)tk.getNextCodeToken(2);
            }
            if (tk.getNextCodeToken() != null && ((PlSqlToken)tk.getNextCodeToken()).matches(".")) {
                String name = this.getProvider().getInternalName(tk.getSource());
                try {
                    baseSchema = this.getProvider().getSchema(name);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (baseSchema == null) {
                    baseSchema = new Schema(name);
                    baseSchema.setID((DBObjectID)new ReferenceID((DBObject)baseSchema));
                }
                names.add(baseSchema.getName());
                tk = (PlSqlToken)tk.getNextCodeToken(2);
            } else {
                baseSchema = trigger.getSchema();
            }
            if (tk.matches("SCHEMA")) {
                baseType = Trigger.BaseType.SCHEMA;
                baseObjectID = baseSchema == null ? null : baseSchema.getID();
                this.buildReference(parser, (PlSqlCodeFragment)trigger, names, tk.getStart(), tk.getEnd(), true);
            } else if (tk.matches("DATABASE")) {
                baseType = Trigger.BaseType.DATABASE;
                baseObjectID = null;
            } else {
                tableName = this.getProvider().getInternalName(tk.getSource());
                try {
                    rel = (Relation)this.getProvider().getObject("TABLE", baseSchema, tableName);
                    if (rel == null) {
                        rel = (Relation)this.getProvider().getObject("VIEW", baseSchema, tableName);
                    }
                }
                catch (DBException name) {
                    // empty catch block
                }
                if (rel == null && trigger.getBaseObjectID() instanceof TemporaryObjectID) {
                    DBObject obj = null;
                    try {
                        obj = trigger.getBaseObjectID().resolveID();
                        if (obj != null && obj.getName().equals(tableName) && ("TABLE".equals(obj.getType()) || "VIEW".equals(obj.getType()))) {
                            rel = (Relation)obj;
                        }
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                }
                if (rel == null) {
                    String type;
                    if (trigger.getTiming() == Trigger.Timing.INSTEAD_OF) {
                        baseType = Trigger.BaseType.VIEW;
                        type = "VIEW";
                    } else {
                        baseType = Trigger.BaseType.TABLE;
                        type = "TABLE";
                    }
                    baseObjectID = new ReferenceID(type, baseSchema, tableName);
                } else {
                    baseObjectID = rel.getID();
                    baseType = rel instanceof Table ? Trigger.BaseType.TABLE : Trigger.BaseType.VIEW;
                }
                names.add(tableName);
                this.buildReference(parser, (PlSqlCodeFragment)trigger, names, tk.getStart(), tk.getEnd(), true);
                Object columnsNode = parser.getPropertyNode((DBObjectPlSqlFragment)trigger, "columnIDs");
                if (columnsNode != null) {
                    String lastColToken = ",";
                    PlSqlToken colTk = parser.getTokenAtOffset(parser.getStartOffset(columnsNode));
                    int end = parser.getEndOffset(columnsNode);
                    while (colTk.getStart() <= end) {
                        if (lastColToken.equals(",")) {
                            Column col;
                            String colName = this.getProvider().getInternalName(colTk.getSource());
                            ReferenceID colID = null;
                            if (rel != null && (col = (Column)DBUtil.findChildByName((DBObject)rel, (String)"columns", (String)colName, (DBObjectProvider)this.getProvider())) != null) {
                                colID = col.getID();
                                names.clear();
                                names.add(tableName);
                                names.add(col.getName());
                                this.buildReference(parser, (PlSqlCodeFragment)trigger, names, colTk.getStart(), colTk.getEnd(), true);
                            }
                            if (colID == null) {
                                colID = new ReferenceID("COLUMN", baseObjectID, colName, null, null);
                            }
                            columnIDs.add(colID);
                        }
                        lastColToken = colTk.getSource();
                        colTk = (PlSqlToken)colTk.getNextCodeToken();
                    }
                }
            }
            trigger.setBaseType(baseType);
            trigger.setBaseObjectID(baseObjectID);
            trigger.setColumnIDs(columnIDs.toArray(new DBObjectID[columnIDs.size()]));
        }
        this.m_triggerOld = "OLD";
        this.m_triggerNew = "NEW";
        Object referencingNode = parser.getPropertyNode((DBObjectPlSqlFragment)trigger, "referencingNewAs");
        if (referencingNode != null) {
            int end = parser.getEndOffset(referencingNode);
            PlSqlToken tk = parser.getTokenAtOffset(parser.getStartOffset(referencingNode));
            while (tk.getStart() <= end && tk.getNextCodeToken(2) != null) {
                if (tk.matches("OLD") && ((PlSqlToken)tk.getNextCodeToken()).matches("AS")) {
                    tk = (PlSqlToken)((PlSqlToken)tk.getNextCodeToken()).getNextCodeToken();
                    String refOldAs = this.getProvider().getInternalName(tk.getSource());
                    trigger.setReferencingOldAs(refOldAs);
                    this.m_triggerOld = refOldAs;
                } else if (tk.matches("NEW") && ((PlSqlToken)tk.getNextCodeToken()).matches("AS")) {
                    tk = (PlSqlToken)((PlSqlToken)tk.getNextCodeToken()).getNextCodeToken();
                    String refNewAs = this.getProvider().getInternalName(tk.getSource());
                    trigger.setReferencingNewAs(refNewAs);
                    this.m_triggerNew = refNewAs;
                }
                tk = (PlSqlToken)tk.getNextCodeToken();
            }
        }
        trigger.setStatementLevel((rowLevelNode = parser.getPropertyNode((DBObjectPlSqlFragment)trigger, "statementLevel")) == null);
        Object whenNode = parser.getPropertyNode((DBObjectPlSqlFragment)trigger, "whenClause");
        if (whenNode != null) {
            PlSqlToken first = parser.getTokenAtOffset(parser.getStartOffset(whenNode));
            if (first.matches("WHEN")) {
                first = (PlSqlToken)first.getNextCodeToken();
            }
            PlSqlToken last = parser.getTokenAtOffset(parser.getEndOffset(whenNode));
            if (this.getProvider().getDescriptor().getDatabaseType().equals("Oracle Database") && first.matches("(") && last.matches(")") && first.getNextCodeToken() != last) {
                first = (PlSqlToken)first.getNextCodeToken();
                last = (PlSqlToken)last.getPrevCodeToken();
            }
            trigger.setWhenClause(first.getSource(false, (Token)last));
        }
        if ((codeNode = parser.getPropertyNode((DBObjectPlSqlFragment)trigger, "code")) != null) {
            String code = trigger.getSource().substring(parser.getStartOffset(codeNode));
            if (code != null) {
                code = code.trim();
            }
            trigger.setCode(code);
        }
        PlSqlSearch search = new PlSqlSearch("alter trigger ?. <state {enable|disable}>");
        for (Tuple tup : parser.getAlterStatements()) {
            if (!search.matches((PlSqlToken)tup.getFirst())) continue;
            trigger.setEnabled(search.getNamedMatchStartToken("state").matches("enabled"));
        }
    }
}

