/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.plsql.PlSqlAttribute;
import oracle.javatools.db.plsql.PlSqlComparator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.sql.AbstractSQLQueryBuilder;
import oracle.javatools.db.sql.ColumnKeywordUsage;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.PlSqlUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentExpressionBuilder;
import oracle.javatools.db.sql.SQLFragmentUtils;
import oracle.javatools.db.sql.SQLFragmentWithDatatype;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.util.DBObjectSet;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public class SQLDerivedPropertySupport {
    public static DerivedPropertyBuilder createCheckConstraintBuilder(DBObjectProvider pro) {
        return new CheckConstraintConditionBuilder((AbstractDBObjectProvider)pro);
    }

    public static DerivedPropertyBuilder createVirtualExpressionBuilder(DBObjectProvider pro) {
        return new VirtualExpressionBuilder((AbstractDBObjectProvider)pro);
    }

    public static DerivedPropertyBuilder createIndexExpressionBuilder(DBObjectProvider pro) {
        return new IndexExpressionBuilder((AbstractDBObjectProvider)pro);
    }

    private static void alwaysQuoteColumnUsages(DBObject obj) {
        if (obj instanceof ColumnUsage) {
            ((ColumnUsage)obj).setAlwaysQuote(true);
        }
        for (DBObject kid : obj.getOwnedObjects()) {
            SQLDerivedPropertySupport.alwaysQuoteColumnUsages(kid);
        }
    }

    private static SQLFragment getExpressionOrFail(DBObjectProvider provider, Relation relation, SQLFragmentExpressionBuilder.ExpressionType type, String expression, String propertyName) throws SQLQueryException {
        SQLFragment retval = SQLFragmentExpressionBuilder.getExpressionOrFail((DBObjectProvider)provider, (Relation)relation, (SQLFragmentExpressionBuilder.ExpressionType)type, (String)expression);
        if (retval != null && retval.getName() == null) {
            retval.setName(propertyName);
        }
        return retval;
    }

    public static class SynonymUsageBuilder
    extends DerivedPropertyBuilder<SynonymUsage> {
        public SynonymUsageBuilder(AbstractDBObjectProvider pro) {
            super(pro, "SQLFragment");
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"referenceChain"})
        public void buildReferenceChain(SynonymUsage su) throws DBException {
            DBObject syn;
            DBObjectID id = su.getObjectID();
            if (id != null && (syn = id.resolveID()) instanceof Synonym) {
                List objs = DBUtil.getSynonymReferenceChain((Synonym)((Synonym)syn));
                DBObjectID[] ids = new DBObjectID[objs.size()];
                for (int i = 0; i < ids.length; ++i) {
                    ids[i] = ((SchemaObject)objs.get(i)).getID();
                }
                su.setReferenceChain(ids);
            }
        }
    }

    public static class SQLQueryViewColumnDTUBuilder
    extends DerivedPropertyBuilder<Column> {
        private static final String BIND_DEFAULT = "null";
        private SQLQuery m_sqlQuery;
        private int m_columnIndex;
        private final List<Tuple<String, DataTypeUsage>> m_columnInfos;

        public SQLQueryViewColumnDTUBuilder(AbstractDBObjectProvider pro, SQLQuery sqlQuery, int columnIndex, List<Tuple<String, DataTypeUsage>> columnInofs) {
            super(pro, "COLUMN");
            this.m_sqlQuery = sqlQuery;
            this.m_columnIndex = columnIndex;
            this.m_columnInfos = columnInofs;
        }

        protected boolean canCacheBuildFailure(Column object, String prop) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @AbstractDBObjectBuilder.PropertyBuilder(value={"dataTypeUsage"})
        public void buildDataTypeUsage(Column col) throws SQLQueryException {
            if (col != null) {
                DBObject par = col.getParent();
                AbstractDBObjectProvider pro = this.getProvider();
                if (pro instanceof Database) {
                    List<Tuple<String, DataTypeUsage>> infos = null;
                    String query = this.m_sqlQuery.getSQLText();
                    if (query != null) {
                        List<Tuple<String, DataTypeUsage>> list = this.m_columnInfos;
                        synchronized (list) {
                            try {
                                if (this.m_columnInfos.isEmpty()) {
                                    this.m_columnInfos.addAll(SQLQueryViewColumnDTUBuilder.getColumnInfo((Database)pro, query));
                                }
                                infos = this.m_columnInfos;
                            }
                            catch (DBException e) {
                                this.getLogger().warning(e.getMessage());
                            }
                        }
                        if (infos != null) {
                            if (par instanceof Relation) {
                                Column[] cols = ((Relation)par).getColumns();
                                if (cols.length != infos.size()) {
                                    throw new IllegalStateException("Mismatch of columns");
                                }
                                for (int i = 0; i < cols.length; ++i) {
                                    cols[i].setDataTypeUsage((DataTypeUsage)infos.get(i).getSecond());
                                }
                            } else if (this.m_columnIndex < infos.size()) {
                                col.setDataTypeUsage((DataTypeUsage)infos.get(this.m_columnIndex).getSecond());
                            } else {
                                col.setDataTypeUsage(new DataTypeUsage());
                            }
                        }
                    }
                } else {
                    List sels;
                    SelectObject[] sos = SQLFragmentUtils.getSelectObjects((SQLQuery)this.m_sqlQuery);
                    boolean needToExpand = true;
                    for (int i = 0; i < sos.length; ++i) {
                        needToExpand = false;
                        if (!(sos[i].getExpression() instanceof ColumnKeywordUsage)) continue;
                        needToExpand = true;
                        break;
                    }
                    if (this.m_columnIndex < (sels = needToExpand ? SQLFragmentUtils.expandStarColumns((SQLQuery)this.m_sqlQuery) : Arrays.asList(sos)).size()) {
                        SQLFragment expr = ((SelectObject)sels.get(this.m_columnIndex)).getExpression();
                        DataTypeUsage dtu = this.findDTU(expr);
                        col.setDataTypeUsage(dtu);
                    }
                }
            }
        }

        private DataTypeUsage findDTU(SQLFragment expr) {
            SQLFragmentWithDatatype frag;
            DBObjectID dtID;
            DataTypeUsage dtu = null;
            if (expr instanceof ColumnUsage) {
                ColumnUsage cu = (ColumnUsage)expr;
                try {
                    Column refCol = (Column)cu.getObjectID().resolveID();
                    if (refCol != null && (dtu = refCol.getDataTypeUsage()) != null) {
                        dtu = (DataTypeUsage)dtu.copyTo(null);
                        dtu.setID(TemporaryObjectID.createID((DBObject)dtu));
                    }
                }
                catch (DBException e) {
                    this.getLogger().fine(e.getMessage());
                }
            } else if (expr instanceof SelectObjectUsage) {
                SelectObjectUsage sou = (SelectObjectUsage)expr;
                DBObjectID sid = sou.getSelectObjectID();
                if (sid != null) {
                    try {
                        SelectObject so = (SelectObject)sid.resolveID();
                        return this.findDTU(so.getExpression());
                    }
                    catch (DBException e) {
                        this.getLogger().fine(e.getMessage());
                    }
                }
            } else if (expr instanceof PlSqlUsage) {
                PlSqlUsage pu = (PlSqlUsage)expr;
                try {
                    DBObject attr = pu.getObjectID().resolveID();
                    if (attr instanceof PlSqlAttribute && (dtu = ((PlSqlAttribute)attr).getDataTypeUsage()) != null) {
                        dtu = (DataTypeUsage)dtu.copyTo(null);
                        dtu.setID(TemporaryObjectID.createID((DBObject)dtu));
                    }
                }
                catch (DBException e) {
                    this.getLogger().fine(e.getMessage());
                }
            } else if (expr instanceof SQLFragmentWithDatatype && (dtID = (frag = (SQLFragmentWithDatatype)expr).getDataTypeID()) != null) {
                DBObject dt;
                try {
                    dt = dtID.resolveID();
                }
                catch (DBException e) {
                    dt = null;
                }
                if (dt instanceof DataType) {
                    dtu = ((DataType)dt).createDefaultUsage();
                } else {
                    dtu = new DataTypeUsage();
                    dtu.setDataTypeID(dtID);
                }
            }
            return dtu;
        }

        public static List<Tuple<String, DataTypeUsage>> getColumnInfo(Database db, String query) throws DBException {
            final ArrayList colMetadata = new ArrayList();
            final QueryWrapper qw = new QueryWrapper(db, SQLQueryViewColumnDTUBuilder.convertBindValues(query));
            qw.executeQuery(1, new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        ResultSetMetaData md = rs.getMetaData();
                        int columnCount = md.getColumnCount();
                        for (int i = 1; i < columnCount + 1; ++i) {
                            colMetadata.add(new ColumnMetadata(md, i));
                        }
                    }
                    catch (SQLException sqe) {
                        qw.throwDBException(sqe);
                    }
                }
            });
            ArrayList<Tuple<String, DataTypeUsage>> ret = new ArrayList<Tuple<String, DataTypeUsage>>(colMetadata.size());
            for (ColumnMetadata col : colMetadata) {
                DataTypeUsage dtu = DataTypeHelper.getDataTypeUsage((DBObjectProvider)db, null, (String)col.m_typeName, (int)col.m_size, (int)col.m_precision, (int)col.m_scale);
                ret.add((Tuple<String, DataTypeUsage>)new Tuple((Object)col.m_colName, (Object)dtu));
            }
            return ret;
        }

        private static String convertBindValues(String sqlText) {
            PlSqlToken tk = PlSqlTokenizer.tokenize((String)sqlText, (String[])new String[0]);
            StringBuffer sb = new StringBuffer();
            while (tk.getType() != Token.Type.END_MARKER) {
                if (tk.matches(":") && ((PlSqlToken)tk.getNextToken()).isCode()) {
                    sb.append(BIND_DEFAULT);
                    tk = (PlSqlToken)tk.getNextToken();
                } else {
                    sb.append(tk.getSource());
                }
                tk = (PlSqlToken)tk.getNextToken();
            }
            return sb.toString().trim();
        }

        private static class ColumnMetadata {
            private final String m_colName;
            private final String m_typeName;
            private final int m_precision;
            private final int m_scale;
            private final int m_size;

            ColumnMetadata(ResultSetMetaData md, int sqlIndex) throws SQLException {
                this.m_colName = md.getColumnName(sqlIndex);
                this.m_typeName = md.getColumnTypeName(sqlIndex);
                this.m_precision = md.getPrecision(sqlIndex);
                this.m_scale = md.getScale(sqlIndex);
                this.m_size = this.m_precision;
            }
        }
    }

    public static class SQLQueryColumnsBuilder
    extends DerivedPropertyBuilder<Relation> {
        private final DBObjectSet<Column> m_colCache = new DBObjectSet();

        public SQLQueryColumnsBuilder(AbstractDBObjectProvider pro, String type) {
            super(pro, type);
        }

        protected boolean canCacheBuildFailure(Relation object, String prop) {
            return false;
        }

        public Collection<String> clearDerivedProperties(Relation obj, String property, DBObjectChange change) {
            if (!DBUtil.needsBuilding((DBObject)obj, (String)"columns")) {
                for (Column col : obj.getColumns()) {
                    this.m_colCache.add((Object)col);
                }
            }
            return super.clearDerivedProperties((AbstractBuildableObject)obj, property, change);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @AbstractDBObjectBuilder.PropertyBuilder(value={"columns"})
        public void buildColumns(Relation rel) throws SQLQueryException {
            block19: {
                ArrayList<Column> columns = new ArrayList<Column>();
                try {
                    SQLQueryBuilder b;
                    SQLQuery query;
                    Column[] colsFromQuery = null;
                    Column[] colsFromOrigRelation = null;
                    List qcis = null;
                    List origQcis = null;
                    if (rel instanceof SQLQueryOwner && (query = ((SQLQueryOwner)rel).getSQLQuery()) != null && (b = SQLQueryBuilderFactory.findOrCreateBuilder((SQLQuery)query, (DBObjectProvider)this.getProvider())) instanceof AbstractSQLQueryBuilder) {
                        try {
                            AbstractSQLQueryBuilder builder = (AbstractSQLQueryBuilder)b;
                            colsFromQuery = builder.getColumns();
                            qcis = builder.getQueryColumnInfos();
                        }
                        catch (SQLQueryException sqlqe) {
                            qcis = null;
                        }
                    }
                    if (colsFromQuery == null) break block19;
                    boolean checkOrigRelColumns = false;
                    for (int i = 0; i < colsFromQuery.length; ++i) {
                        if (colsFromQuery[i].getName() != null) continue;
                        checkOrigRelColumns = true;
                        break;
                    }
                    if (checkOrigRelColumns) {
                        Relation origRel = (Relation)TemporaryObjectID.findOriginalObject((DBObject)rel);
                        if (origRel instanceof SQLQueryOwner) {
                            SQLQueryBuilder b2;
                            colsFromOrigRelation = origRel.getColumns();
                            SQLQuery query2 = ((SQLQueryOwner)origRel).getSQLQuery();
                            if (query2 != null && (b2 = SQLQueryBuilderFactory.findOrCreateBuilder((SQLQuery)query2, (DBObjectProvider)this.getProvider())) instanceof AbstractSQLQueryBuilder) {
                                try {
                                    AbstractSQLQueryBuilder builder = (AbstractSQLQueryBuilder)b2;
                                    origQcis = builder.getQueryColumnInfos();
                                }
                                catch (SQLQueryException sqlqe) {
                                    origQcis = null;
                                }
                            }
                        }
                        if (colsFromOrigRelation != null && origQcis != null) {
                            PlSqlComparator comp = new PlSqlComparator();
                            block10: for (int i = 0; i < colsFromQuery.length; ++i) {
                                if (colsFromQuery[i].getName() != null) continue;
                                AbstractSQLQueryBuilder.QueryColumnInfo qci = (AbstractSQLQueryBuilder.QueryColumnInfo)qcis.get(i);
                                for (int j = 0; j < origQcis.size(); ++j) {
                                    AbstractSQLQueryBuilder.QueryColumnInfo origQci = (AbstractSQLQueryBuilder.QueryColumnInfo)origQcis.get(j);
                                    if (origQci.getName() != null || comp.compare(qci.getExpression(), origQci.getExpression()) != 0) continue;
                                    colsFromQuery[i].setName(colsFromOrigRelation[j].getName());
                                    continue block10;
                                }
                            }
                        }
                    }
                    for (int i = 0; i < colsFromQuery.length; ++i) {
                        Column colToUse = colsFromQuery[i];
                        for (Column col : this.m_colCache) {
                            if (col.getName() == null || !col.getName().equals(colToUse.getName())) continue;
                            colToUse = col;
                            this.m_colCache.remove((Object)col);
                            break;
                        }
                        columns.add(colToUse);
                    }
                }
                catch (DBException e) {
                    columns.clear();
                    this.getLogger().warning(e.getMessage());
                }
                finally {
                    rel.setColumns(columns.toArray(new Column[columns.size()]));
                    this.m_colCache.clear();
                }
            }
            this.maintainConstraints(rel);
        }

        private void maintainConstraints(Relation rel) {
            Constraint[] cons = rel.getConstraints();
            if (cons != null && cons.length > 0) {
                Column[] cols = rel.getColumns();
                HashSet<String> colnames = new HashSet<String>();
                for (Column col : cols) {
                    colnames.add(col.getName());
                }
                DBObjectSet newCons = new DBObjectSet();
                for (Constraint c : cons) {
                    if (c instanceof ColumnConstraint) {
                        ArrayList<DBObjectID> colIDs = new ArrayList<DBObjectID>();
                        for (DBObjectID colID : ((ColumnConstraint)c).getColumnIDs()) {
                            if (!colnames.contains(DBUtil.getDBObjectName((DBObjectID)colID))) continue;
                            colIDs.add(colID);
                        }
                        if (colIDs.size() <= 0) continue;
                        ((ColumnConstraint)c).setColumnIDs(colIDs.toArray(new DBObjectID[colIDs.size()]));
                        newCons.add(c);
                        continue;
                    }
                    newCons.add(c);
                }
                rel.setConstraints(newCons.toArray(new Constraint[newCons.size()]));
            }
        }
    }

    public static class IndexExpressionBuilder
    extends DerivedFromColumnsBuilder<IndexObject> {
        private IndexExpressionBuilder(AbstractDBObjectProvider pro) {
            super(pro, "IndexObject");
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"expression"})
        public boolean buildColumnExpression(IndexObject idxObj) throws SQLQueryException {
            String source;
            boolean retval = false;
            Relation tab = (Relation)DBUtil.findParentOfType((DBObject)idxObj, Relation.class);
            if (tab != null && ModelUtil.hasLength((String)(source = idxObj.getExpressionSource()))) {
                retval = true;
                SQLFragment newfrag = SQLDerivedPropertySupport.getExpressionOrFail((DBObjectProvider)this.getProvider(), tab, SQLFragmentExpressionBuilder.ExpressionType.ITEM, source, "expression");
                if (newfrag != null && (!(newfrag instanceof ColumnUsage) || IndexObject.OrderType.DESC.equals((Object)idxObj.getOrderType()))) {
                    SQLDerivedPropertySupport.alwaysQuoteColumnUsages((DBObject)newfrag);
                }
                idxObj.setExpression(newfrag);
            }
            return retval;
        }
    }

    public static class CheckConstraintConditionBuilder
    extends DerivedFromColumnsBuilder<CheckConstraint> {
        private CheckConstraintConditionBuilder(AbstractDBObjectProvider pro) {
            super(pro, "CONSTRAINT");
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"checkConditionFragment"})
        public boolean buildConditionFragment(CheckConstraint cc) throws SQLQueryException {
            String condition;
            boolean retval = false;
            Relation rel = cc.getRelation();
            if (rel != null && ModelUtil.hasLength((String)(condition = cc.getCheckCondition()))) {
                retval = true;
                SQLFragment newfrag = SQLDerivedPropertySupport.getExpressionOrFail((DBObjectProvider)this.getProvider(), rel, SQLFragmentExpressionBuilder.ExpressionType.CONDITION, condition, "checkConditionFragment");
                cc.setCheckConditionFragment(newfrag);
            }
            return retval;
        }
    }

    public static class VirtualExpressionBuilder
    extends DerivedFromColumnsBuilder<Column> {
        private VirtualExpressionBuilder(AbstractDBObjectProvider pro) {
            super(pro, "COLUMN");
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"virtualExpression"})
        public boolean buildVirtualExpression(Column col) throws SQLQueryException {
            String source;
            boolean retval = false;
            Relation rel = col.getRelation();
            if (rel != null && ModelUtil.hasLength((String)(source = col.getVirtualExpressionSource()))) {
                retval = true;
                SQLFragment newfrag = SQLDerivedPropertySupport.getExpressionOrFail((DBObjectProvider)this.getProvider(), rel, SQLFragmentExpressionBuilder.ExpressionType.ITEM, source, "virtualExpression");
                if (newfrag != null) {
                    SQLDerivedPropertySupport.alwaysQuoteColumnUsages((DBObject)newfrag);
                }
                col.setVirtualExpression(newfrag);
            }
            return retval;
        }
    }

    static class DerivedFromColumnsBuilder<T extends AbstractBuildableObject>
    extends DerivedPropertyBuilder<T> {
        DerivedFromColumnsBuilder(AbstractDBObjectProvider pro, String type) {
            super(pro, type);
        }

        protected Object getFailureCacheValue(T object, String sourceProp) {
            Relation rel;
            Object retval = super.getFailureCacheValue(object, sourceProp);
            if (retval instanceof String && (rel = (Relation)DBUtil.findParentOfType(object, Relation.class)) != null) {
                Column[] cols = rel.getColumns();
                Object[] names = new String[cols.length];
                for (int i = 0; i < cols.length; ++i) {
                    String name = cols[i].getName();
                    if (name != null) {
                        name = name.replace(",", ",,");
                    }
                    names[i] = name;
                }
                Arrays.sort(names);
                retval = (String)retval + Arrays.toString(names);
            }
            return retval;
        }
    }
}

