/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sybase.anywhere;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.stream.IntStream;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sybase.AdaptiveServerDDLGenerator;
import oracle.javatools.db.sybase.anywhere.AdaptiveServerAnywhereDatabase;

public class AdaptiveServerAnywhereDescriptor
extends JdbcDatabaseDescriptor {
    public static final int MAX_NAME_LENGTH = 128;
    public static final char OPEN_QUOTE_IDENTIFIER = '[';
    public static final char CLOSE_QUOTE_IDENTIFIER = ']';
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "BACKUP", "BEGIN", "BETWEEN", "BIGINT", "BINARY", "BIT", "BOTTOM", "BREAK", "BY", "CALL", "CAPABILITY", "CASCADE", "CASE", "CAST", "CHAR", "CHAR_CONVERT", "CHARACTER", "CHECK", "CHECKPOINT", "CLOSE", "COMMENT", "COMMIT", "CONNECT", "CONSTRAINT", "CONTAINS", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CUBE", "CURRENT", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATE", "DBSPACE", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELETE", "DELETING", "DESC", "DISTINCT", "DO", "DOUBLE", "DROP", "DYNAMIC", "ELSE", "ELSEIF", "ENCRYPTED", "END", "ENDIF", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTING", "EXISTS", "EXTERNLOGIN", "FETCH", "FIRST", "FLOAT", "FOR", "FORCE", "FOREIGN", "FORWARD", "FROM", "FULL", "GOTO", "GRANT", "GROUP", "HAVING", "HOLDLOCK", "IDENTIFIED", "IF", "IN", "INDEX", "INDEX_LPAREN", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INSERTING", "INSTALL", "INSTEAD", "INT", "INTEGER", "INTEGRATED", "INTERSECT", "INTO", "IQ", "IS", "ISOLATION", "JOIN", "KEY", "LATERAL", "LEFT", "LIKE", "LOCK", "LOGIN", "LONG", "MATCH", "MEMBERSHIP", "MESSAGE", "MODE", "MODIFY", "NATURAL", "NEW", "NO", "NOHOLDLOCK", "NOT", "NOTIFY", "NULL", "NUMERIC", "OF", "OFF", "ON", "OPEN", "OPTION", "OPTIONS", "OR", "ORDER", "OTHERS", "OUT", "OUTER", "OVER", "PASSTHROUGH", "PRECISION", "PREPEARE", "PRIMARY", "PRINT", "PRIVILEGES", "PROC", "PROCEDURE", "PUBLICATION", "RAISERROR", "READTEXT", "REAL", "REFERENCE", "REFERENCES", "RELEASE", "REMOTE", "REMOVE", "RENAME", "REORGANIZE", "RESOURCE", "RESTORE", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "ROLLBACK", "ROLLUP", "SAVE", "SAVEPOINT", "SCROLL", "SELECT", "SENSITIVE", "SESSION", "SET", "SETUSER", "SHARE", "SMALLINT", "SOME", "SQLCODE", "SQLSTATE", "START", "STOP", "SUBTRANS", "SUBTRANSACTION", "SYNCHRONIZE", "SYNTAX_ERROR", "TABLE", "TEMPORARY", "TEXTSIZE", "THEN", "TIME", "TIMESTAMP", "TINYINT", "TO", "TOP", "TRAN", "TRIGGER", "TRUNCATE", "TSEQUAL", "UNBOUNDED", "UNION", "UNIQUE", "UNKNOWN", "UNSIGNED", "UPDATE", "UPDATING", "USER", "USING", "VALIDATE", "VALUES", "VARBINARY", "VARCHAR", "VARIABLE", "VARYING", "VIEW", "WAIT", "WAITFOR", "WHEN", "WHERE", "WHILE", "WINDOW", "WITH", "WITH_CUBE", "WITH_LPAREN", "WITH_ROLLUP", "WITHIN", "WORK", "WRITETEXT"));

    public AdaptiveServerAnywhereDescriptor(Class<? extends AdaptiveServerAnywhereDatabase> clz) {
        super(clz);
    }

    @Override
    public int getCasePolicy() {
        return 3;
    }

    @Override
    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    @Override
    public int getMaxNameLength(String type) {
        return 128;
    }

    @Override
    public void validateName(String type, String name) throws InvalidNameException {
        boolean isValid = true;
        String reason = "";
        try {
            AdaptiveServerAnywhereDescriptor.validateIdentifier((String)name, (char)'\"', (int)128, (String)"_$#@", (boolean)false, (Set)RESERVED_WORDS, (int)this.getCasePolicy(), (boolean)this.allowSurrogatesInIdentifierValidation());
        }
        catch (InvalidNameException ine) {
            isValid = false;
            reason = ine.getMessage();
        }
        char firstChar = name.charAt(0);
        if (isValid && firstChar != '\"' && !Character.isAlphabetic(name.codePointAt(0)) && firstChar != '_' && firstChar != '$' && firstChar != '#' && firstChar != '@') {
            throw new InvalidNameException(null, APIBundle.get((String)"INVALID_IDENTIFIER_ILLEGAL_CHARACTER"));
        }
        if (!isValid && firstChar == '[' && name.indexOf(91, 1) == -1 && name.indexOf(93, 1) == name.length() - 1 && name.length() > 2 && name.length() < 131) {
            isValid = true;
        }
        if (!isValid) {
            throw new InvalidNameException(null, reason);
        }
        String unquotedName = firstChar == '\"' ? name.substring(1, name.length() - 1) : name;
        Integer lastCodePoint = 0;
        IntStream codePoints = name.codePoints();
        PrimitiveIterator.OfInt iter = codePoints.iterator();
        while (iter.hasNext()) {
            Integer thisCodePoint = (Integer)iter.next();
            if (Character.isISOControl(thisCodePoint) || "\"".indexOf(thisCodePoint) != -1 || "\\".indexOf(lastCodePoint) != -1 && "\\".indexOf(thisCodePoint) != -1) {
                throw new InvalidNameException(null, APIBundle.get((String)"INVALID_IDENTIFIER_ILLEGAL_CHARACTER"));
            }
            lastCodePoint = thisCodePoint;
        }
        for (int idx = 0; idx < unquotedName.length(); ++idx) {
            if (name.charAt(idx) != '\'' || ++idx != unquotedName.length() - 1 && name.charAt(idx) == '\'') continue;
            throw new InvalidNameException(null, APIBundle.get((String)"INVALID_IDENTIFIER_ILLEGAL_CHARACTER"));
        }
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        return new AdaptiveServerDDLGenerator(this.getDatabaseClass(), pro);
    }

    @Override
    public Collection<String> getReservedWords() {
        return RESERVED_WORDS;
    }

    @Override
    public String getDatabaseType() {
        return "SybaseAnywhere";
    }

    @Override
    protected void registerDataTypes(DataTypeCache cache) {
        if (this.getDatabaseVersion() == 0) {
            cache.registerDataType("BIGINT");
            cache.registerDataType("BINARY");
            cache.registerDataType("BIT");
            cache.registerDataType("CHARACTER VARYING");
            cache.registerDataType("CHARACTER");
            cache.registerDataType("DATE");
            cache.registerDataType("DATETIME");
            cache.registerDataType("DECIMAL");
            cache.registerDataType("DOUBLE PRECISION");
            cache.registerDataType("DOUBLE");
            cache.registerDataType("FLOAT");
            cache.registerDataType("IMAGE");
            cache.registerDataType("INT");
            cache.registerDataType("INTEGER");
            cache.registerDataType("LONG BINARY");
            cache.registerDataType("LONG VARCHAR");
            cache.registerDataType("MONEY");
            cache.registerDataType("NUMERIC");
            cache.registerDataType("REAL");
            cache.registerDataType("SMALLDATETIME");
            cache.registerDataType("SMALLINT");
            cache.registerDataType("SMALLMONEY");
            cache.registerDataType("TEXT");
            cache.registerDataType("TIME");
            cache.registerDataType("TIMESTAMP");
            cache.registerDataType("TINYINT");
            cache.registerDataType("UNIQUEIDENTIFIER");
            cache.registerDataType("UNIQUEIDENTIFIERSTR");
            cache.registerDataType("VARBINARY");
            cache.registerDataType("VARCHAR");
            cache.registerDataType("XML");
        }
    }
}

