/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.ConstraintIndexHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class ConstraintValidator<T extends Constraint>
extends AbstractChildDBObjectValidator<T> {
    public ConstraintValidator(DBObjectProvider prov) {
        super(prov);
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection retval = super.listAlwaysValidProperties();
        retval.add("deferrableState");
        retval.add("onDeleteAction");
        return retval;
    }

    @DBObjectValidator.PropertyValidator(value={"enabled"}, level=ValidationLevel.FULL)
    public void validateEnabled(Constraint orig, Constraint con) throws ValidationException {
        Relation rel;
        Table.TableType tableType;
        if (con instanceof PKConstraint && (tableType = (Table.TableType)(rel = con.getRelation()).getProperty("TableType")) == Table.TableType.INDEX_ORGANIZED && !con.isEnabled()) {
            throw new ValidationException((DBObject)con, APIBundle.get((String)"IOT_PROPERTY_ERROR_DISABLED_PRIMARY_KEY"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"indexID"}, level=ValidationLevel.FULL)
    public void validateIndexID(Constraint orig, Constraint con) throws ValidationException {
        if (con instanceof UniqueConstraint) {
            DBObjectID indexID = ((UniqueConstraint)con).getIndexID();
            Relation parent = con.getRelation();
            if (parent != null && indexID != null) {
                Index index = (Index)parent.findOwnedObject(indexID);
                if (index == null) {
                    throw new ValidationException((DBObject)con, APIBundle.format((String)"CONIDX_MISSING_INDEX_ERR", (Object[])new Object[]{DBUtil.getDBObjectName((DBObjectID)indexID), con.getName()}));
                }
                ConstraintIndexHelper.validateIndexForConstraint(index, (UniqueConstraint)con, this.getProvider(), true);
            }
        }
    }

    protected void handleMissingConstraintIndex(Constraint con, DBObjectID indexID) throws ValidationException {
        throw new ValidationException((DBObject)con, APIBundle.format((String)"CONIDX_MISSING_INDEX_ERR", (Object[])new Object[]{DBUtil.getDBObjectName((DBObjectID)indexID), con.getName()}));
    }

    @DBObjectValidator.PropertyValidator(value={"checkConditionFragment", "checkCondition"})
    public void validateCheckCondition(ValidationContext<Constraint> context) throws ValidationException {
        Constraint con = (Constraint)context.getUpdatedObject();
        if (con instanceof CheckConstraint) {
            Relation parent = (Relation)con.getParent();
            String condition = ((CheckConstraint)con).getCheckCondition();
            if (!ModelUtil.hasLength((String)condition)) {
                throw new ValidationException((DBObject)con, APIBundle.format((String)"CC_ERROR_NO_CONDITION", (Object[])new Object[]{con.getName()}));
            }
            if (context.getLevel() == ValidationLevel.FULL) {
                try {
                    this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder((DBObject)con);
                    DBUtil.ensureObjectBuilt((DBObject)con, (String[])new String[]{"checkConditionFragment"});
                    SQLFragment exp = ((CheckConstraint)con).getCheckConditionFragment();
                    for (String[] nameComponents : ParserUtils.getColumnNames((SQLFragment)exp)) {
                        String colName = this.getProvider().getInternalName(nameComponents[0]);
                        Column column = (Column)DBUtil.findChildByName((DBObject)parent, (String)"columns", (String)colName, (DBObjectProvider)this.getProvider());
                        if (column != null) continue;
                        throw new SQLQueryException(APIBundle.format((String)"CC_ERROR_INVALID_COLUMN", (Object[])new Object[]{this.getProvider().getExternalName(colName)}));
                    }
                }
                catch (DBException dbe) {
                    throw new ValidationException((DBObject)con, "checkCondition", APIBundle.format((String)"CC_ERROR_PARSING_CONDITION", (Object[])new Object[]{con.getName(), dbe.getMessage()}));
                }
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"columnIDs"})
    public void validateColumns(ValidationContext<Constraint> context) throws ValidationException {
        Constraint con = (Constraint)context.getUpdatedObject();
        if (con instanceof ColumnConstraint) {
            DBObjectID[] colIDs = ((ColumnConstraint)con).getColumnIDs();
            if (colIDs == null || colIDs.length == 0) {
                throw new ValidationException((DBObject)con, APIBundle.get((String)(con instanceof FKConstraint ? "FK_ERROR_NO_COLUMNS" : "PK_ERROR_NO_COLUMNS")));
            }
            if (context.getLevel() == ValidationLevel.FULL) {
                DBObjectID refID;
                Column[] conCols = this.getConstraintColumns((ColumnConstraint)con);
                this.validateConstraintColumns((ColumnConstraint)con, conCols);
                if (con instanceof UniqueConstraint) {
                    this.checkIsUniqueDefinition(con);
                } else if (con instanceof FKConstraint && (refID = ((FKConstraint)con).getReferenceID()) != null && !(refID instanceof ReferenceID)) {
                    this.checkColumnsMatch((FKConstraint)con);
                }
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"referenceID"})
    public void validateReference(ValidationContext<Constraint> context) throws ValidationException {
        Constraint con = (Constraint)context.getUpdatedObject();
        if (con instanceof FKConstraint) {
            FKConstraint fk = (FKConstraint)con;
            DBObjectID refID = fk.getReferenceID();
            if (refID == null) {
                throw new ValidationException((DBObject)con, APIBundle.get((String)"FK_ERROR_NO_REF_CON"));
            }
            if (context.getLevel() == ValidationLevel.FULL && refID instanceof ReferenceID) {
                ReferenceID nbfk = (ReferenceID)refID;
                this.getProvider().validateName("CONSTRAINT", nbfk.getName());
                BaseObjectID parID = (BaseObjectID)nbfk.getParent();
                if (parID == null) {
                    throw new ValidationException((DBObject)con, APIBundle.get((String)"FK_ERROR_NO_REF_CON"));
                }
                this.getProvider().validateName("SCHEMA", parID.getSchemaName());
                this.getProvider().validateName("TABLE", parID.getName());
                String[] refColNames = nbfk.getChildObjectNames();
                DBObjectID[] cols = fk.getColumnIDs();
                if (refColNames.length > 0 && refColNames.length != cols.length) {
                    throw new ValidationException((DBObject)fk, APIBundle.format((String)"FK_ERROR_MISMATCHED_COLUMN_COUNT", (Object[])new Object[]{cols.length, refColNames.length}));
                }
                for (String colName : refColNames) {
                    this.getProvider().validateName("COLUMN", colName);
                }
            }
        }
    }

    protected void validateConstraintColumns(ColumnConstraint con, Column[] conCols) throws ValidationException {
        if (conCols.length == 0) {
            throw new ValidationException((DBObject)con, APIBundle.get((String)(con instanceof FKConstraint ? "FK_ERROR_NO_COLUMNS" : "PK_ERROR_NO_COLUMNS")));
        }
        if (this.areDuplicateColumns(conCols)) {
            throw new ValidationException((DBObject)con, APIBundle.get((String)"CONSTRAINT_ERROR_DUPLICATE_COLUMN"));
        }
        if (con instanceof PKConstraint) {
            this.checkColumnDataType((Constraint)con, conCols, "PK_ERROR_INVALID_COLUMN_TYPE");
        } else if (con instanceof UniqueConstraint) {
            this.checkColumnDataType((Constraint)con, conCols, "UK_ERROR_INVALID_COLUMN_TYPE");
        } else if (con instanceof FKConstraint) {
            this.checkColumnDataType((Constraint)con, conCols, "FK_ERROR_INVALID_COLUMN_TYPE");
        }
    }

    public boolean isCompatibleDataTypes(DataType fkColDataType, DataType refColDataType) {
        return this.getProvider().getDescriptor().isValidFKDataType(fkColDataType, refColDataType);
    }

    protected boolean isValidConstraintDatatype(String dataTypeName, DataTypeUsage dataTypeUsage) {
        return true;
    }

    private void checkColumnsMatch(FKConstraint fk) throws ValidationException {
        DBObjectID[] cols = fk.getColumnIDs();
        DBObjectID id = fk.getReferenceID();
        UniqueConstraint refCon = null;
        try {
            refCon = (UniqueConstraint)id.resolveID();
        }
        catch (DBException dbe) {
            this.logException(dbe, Level.FINE);
        }
        if (refCon != null && cols != null) {
            Column[] refCols;
            try {
                refCols = this.getConstraintColumns((ColumnConstraint)refCon);
            }
            catch (ValidationException ve) {
                ValidationException newVE = new ValidationException((DBObject)fk, APIBundle.format((String)"FK_ERROR_INVALID_REF_CON", (Object[])new Object[]{refCon.getName()}));
                newVE.setRelatedObjects(new DBObject[]{refCon});
                throw newVE;
            }
            if (cols.length == refCols.length) {
                ve = null;
                for (int i = 0; i < cols.length; ++i) {
                    Column refCol = refCols[i];
                    Column localCol = (Column)fk.getRelation().findOwnedObject(cols[i]);
                    if (refCol == null || localCol == null) continue;
                    String refColName = refCol.getName();
                    DataType colDataType = null;
                    DataType refColDataType = null;
                    try {
                        colDataType = DataTypeHelper.getDataType((DataTypeUsage)localCol.getDataTypeUsage());
                        refColDataType = DataTypeHelper.getDataType((DataTypeUsage)refCol.getDataTypeUsage());
                    }
                    catch (DBException dbe) {
                        this.logException(dbe, Level.FINE);
                    }
                    if (this.isCompatibleDataTypes(colDataType, refColDataType)) continue;
                    ValidationException dtVE = new ValidationException((DBObject)fk, APIBundle.format((String)"FK_ERROR_MISMATCHED_COLUMN_TYPES", (Object[])new Object[]{localCol.getName(), colDataType == null ? null : colDataType.getName(), refColName, refColDataType == null ? null : refColDataType.getName()}));
                    dtVE.setRelatedObjects(new DBObject[]{refCon});
                    ve = (ValidationException)((Object)DBException.append(ve, (DBException)((Object)dtVE)));
                }
                if (ve != null) {
                    throw ve;
                }
            } else {
                throw new ValidationException((DBObject)fk, APIBundle.format((String)"FK_ERROR_MISMATCHED_COLUMN_COUNT", (Object[])new Object[]{cols.length, refCols.length}));
            }
        }
    }

    private void checkColumnDataType(Constraint con, Column[] cols, String errorMessage) throws ValidationException {
        for (int i = 0; i < cols.length; ++i) {
            Column col = cols[i];
            if (col == null || col.getParent() instanceof SQLQueryOwner) continue;
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType((DataTypeUsage)col.getDataTypeUsage());
            }
            catch (DBException dbe) {
                this.logException(dbe, Level.FINE);
            }
            if (dataType == null) {
                throw new ValidationException((DBObject)con, APIBundle.format((String)"COLUMN_ERROR_MISSING_TYPE", (Object[])new Object[]{col.getName()}));
            }
            if (this.isValidConstraintDatatype(dataType.getName(), col.getDataTypeUsage())) continue;
            throw new ValidationException((DBObject)con, APIBundle.format((String)errorMessage, (Object[])new Object[]{col.getName()}));
        }
    }

    protected void checkIsUniqueDefinition(Constraint con) throws ValidationException {
        Relation rel = con.getRelation();
        DBObjectID[] conColumns = ((UniqueConstraint)con).getColumnIDs();
        for (Constraint other : rel.getConstraints()) {
            if (!(other instanceof UniqueConstraint) || DBUtil.areNamesAndTypesEqual((DBObject)other, (DBObject)con) || !this.areIdenticalColumnLists(rel, conColumns, ((UniqueConstraint)other).getColumnIDs())) continue;
            throw new ValidationException((DBObject)con, APIBundle.format((String)"UK_ERROR_DUPLICATE_DEFINITION", (Object[])new Object[]{this.getConstraintTypeDisplayName(con), con.getName(), this.getConstraintTypeDisplayName(other), other.getName()}));
        }
    }

    private boolean areIdenticalColumnLists(Relation rel, DBObjectID[] thisConsColumns, DBObjectID[] otherConsColumns) {
        boolean retval = false;
        if (thisConsColumns.length == otherConsColumns.length) {
            retval = true;
            for (int i = 0; i < thisConsColumns.length; ++i) {
                String otherColName;
                String thisColName = this.getColumnName(thisConsColumns[i], rel);
                if (!ModelUtil.areDifferent((Object)thisColName, (Object)(otherColName = this.getColumnName(otherConsColumns[i], rel)))) continue;
                retval = false;
                break;
            }
        }
        return retval;
    }

    private String getColumnName(DBObjectID colID, Relation rel) {
        String retval = null;
        if (colID instanceof TemporaryObjectID) {
            retval = ((TemporaryObjectID)colID).getDBObject().getName();
        } else if (colID instanceof NameBasedID) {
            retval = ((NameBasedID)colID).getName();
        }
        if (!ModelUtil.hasLength((String)retval)) {
            for (Column col : rel.getColumns()) {
                if (!col.getID().equals(colID, true)) continue;
                retval = col.getName();
                break;
            }
        }
        return retval;
    }

    protected String getConstraintTypeDisplayName(Constraint constraint) {
        return DisplayNames.getTypeDisplayName((String)constraint.getConstraintType());
    }

    private boolean areDuplicateColumns(Column[] cols) {
        boolean result = false;
        block0: for (int i = 0; i < cols.length - 1 && !result; ++i) {
            if (null == cols[i]) continue;
            for (int j = i + 1; j < cols.length; ++j) {
                if (!cols[i].equals((Object)cols[j])) continue;
                result = true;
                continue block0;
            }
        }
        return result;
    }

    public static void validateOnePK(Constraint[] cons) throws ValidationException {
        boolean hasPK = false;
        for (int i = 0; i < cons.length; ++i) {
            String cType = cons[i].getConstraintType();
            if (!"PKConstraint".equals(cType)) continue;
            if (hasPK) {
                throw new ValidationException((DBObject)cons[i], APIBundle.get((String)"CONSTRAINTS_INFO_ERROR_DUP_PK"));
            }
            hasPK = true;
        }
    }

    private Column[] getConstraintColumns(ColumnConstraint con) throws ValidationException {
        ArrayList<Column> retval = new ArrayList<Column>();
        Relation parent = con.getRelation();
        if (parent == null) {
            throw new ValidationException((DBObject)con, APIBundle.format((String)"CONSTRAINT_ERROR_ORPHANED_CONSTRAINT", (Object[])new Object[0]));
        }
        ValidationException ve = null;
        DBObjectID[] colIDs = con.getColumnIDs();
        for (int i = 0; i < colIDs.length; ++i) {
            if (colIDs[i] == null) {
                ve = (ValidationException)((Object)DBException.append(ve, (DBException)((Object)new ValidationException((DBObject)con, APIBundle.format((String)"CONSTRAINT_ERROR_MISSING_COLUMN_INDEX", (Object[])new Object[]{i})))));
                continue;
            }
            Column c = (Column)parent.findOwnedObject(colIDs[i]);
            if (c == null) {
                ve = (ValidationException)((Object)DBException.append((DBException)((Object)ve), (DBException)((Object)new ValidationException((DBObject)con, APIBundle.format((String)"CONSTRAINT_ERROR_MISSING_COLUMN", (Object[])new Object[]{DBUtil.getDBObjectName((DBObjectID)colIDs[i])})))));
            }
            retval.add(c);
        }
        if (ve != null) {
            throw ve;
        }
        return retval.toArray(new Column[retval.size()]);
    }

    public boolean initializeWithDefaultName() {
        return false;
    }
}

