/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import oracle.ide.inspector.CategoryCollectionDisplay;
import oracle.ide.inspector.CategoryTabbedPane;
import oracle.ide.inspector.PropertyCategoryPanel;
import oracle.ide.inspector.SearchIterator;

class SearchableCategoryTabbedPane
extends CategoryTabbedPane {
    SearchableCategoryTabbedPane(CategoryCollectionDisplay categoryCollectionDisplay) {
        super(categoryCollectionDisplay);
    }

    @Override
    public void currentCategoryUpdated(String currentCategory) {
        this.categoryCollectionDisplay.updateCurrentCategory(currentCategory);
    }

    @Override
    public void categorySelectionChanged(PropertyCategoryPanel selectedPanel) {
        this.categoryCollectionDisplay.categorySelected(selectedPanel);
    }

    @Override
    public boolean findTextInComponent(Component c, String searchText, boolean searchForward, boolean searchRepeat) {
        return this.categoryCollectionDisplay.findTextInComponent(c, searchText, searchForward, searchRepeat);
    }

    @Override
    public boolean findText(String searchText, boolean searchForward, boolean searchRepeat) {
        this.updateCategoryFromCurrentTab();
        boolean clearSearchResults = false;
        SearchIterator iter = new SearchIterator(searchForward, this.getSelectedIndex(), this.getTabCount());
        while (iter.hasNext()) {
            int tabIndex = iter.next();
            Component c = this.getComponentAt(tabIndex);
            if (clearSearchResults) {
                this.findTextInComponent(c, "", searchForward, false);
            }
            if (this.findTextInComponent(c, searchText, searchForward, searchRepeat)) {
                this.setSelectedIndex(tabIndex);
                return true;
            }
            clearSearchResults = true;
        }
        return false;
    }
}

