/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.pack;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.ivy.core.pack.ArchivePacking;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;

public class ZipPacking
extends ArchivePacking {
    private static final String[] NAMES = new String[]{"zip", "jar", "war"};

    public String[] getNames() {
        return NAMES;
    }

    public String getUnpackedExtension(String ext) {
        if ((ext.endsWith("zip") || ext.endsWith("jar") || ext.endsWith("war")) && (ext = ext.substring(0, ext.length() - 3)).endsWith(".")) {
            ext = ext.substring(0, ext.length() - 1);
        }
        return ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpack(InputStream packed, File dest) throws IOException {
        ZipInputStream zip = null;
        try {
            zip = new ZipInputStream(packed);
            ZipEntry entry = null;
            while ((entry = zip.getNextEntry()) != null) {
                File f = new File(dest, entry.getName());
                Message.verbose("\t\texpanding " + entry.getName() + " to " + f);
                File dirF = f.getParentFile();
                if (dirF != null) {
                    dirF.mkdirs();
                }
                if (entry.isDirectory()) {
                    f.mkdirs();
                } else {
                    this.writeFile(zip, f);
                }
                f.setLastModified(entry.getTime());
            }
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(InputStream zip, File f) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(f);
        try {
            FileUtil.copy(zip, out, null, false);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }
}

