/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.boot;

import java.util.ArrayList;
import java.util.List;

final class JavaVersion {
    JavaVersion() {
    }

    String maxVersion() {
        return System.getProperty("ide.java.maxversion", this.defaultMaxVersion());
    }

    String minVersion() {
        return System.getProperty("ide.java.minversion", this.defaultMinVersion());
    }

    private String defaultMaxVersion() {
        return "1.9";
    }

    private String defaultMinVersion() {
        return "1.8";
    }

    String currentVersion() {
        return System.getProperty("java.version");
    }

    boolean isSupported() {
        ParsedVersion minVersion = this.parseVersion(this.minVersion());
        ParsedVersion maxVersion = this.parseVersion(this.maxVersion());
        ParsedVersion curVersion = this.parseVersion(this.currentVersion());
        return curVersion.compareTo(minVersion) >= 0 && curVersion.compareTo(maxVersion) < 0;
    }

    ParsedVersion parseVersion(String versionString) {
        ParsedVersion parsedVersion;
        block9: {
            versionString = versionString.trim();
            parsedVersion = new ParsedVersion();
            Integer number = null;
            boolean parsingAfterUnderscore = false;
            try {
                for (int i = 0; i < versionString.length(); ++i) {
                    char c = versionString.charAt(i);
                    if (Character.isDigit(c)) {
                        if (number == null) {
                            number = 0;
                        }
                        number = number * 10 + Integer.parseInt(versionString.substring(i, i + 1));
                        continue;
                    }
                    if (parsingAfterUnderscore) break;
                    if (c == '.' && number != null) {
                        parsedVersion.version.add(number);
                        number = null;
                        continue;
                    }
                    if (c != '_' || number == null) break;
                    parsedVersion.version.add(number);
                    number = null;
                    parsingAfterUnderscore = true;
                }
                if (parsingAfterUnderscore) {
                    parsedVersion.release = number;
                } else if (number != null) {
                    parsedVersion.version.add(number);
                }
            }
            catch (NumberFormatException ex) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError((Object)"Invalid version string");
            }
        }
        return parsedVersion;
    }

    static class ParsedVersion
    implements Comparable<ParsedVersion> {
        List<Integer> version = new ArrayList<Integer>(3);
        Integer release;

        private ParsedVersion() {
        }

        @Override
        public int compareTo(ParsedVersion other) {
            int size = this.version.size();
            int otherSize = other.version.size();
            if (size != 0 || otherSize != 0) {
                int x;
                if (size == 0) {
                    return -1;
                }
                if (otherSize == 0) {
                    return 1;
                }
                for (x = 0; x < size; ++x) {
                    int number = this.version.get(x);
                    if (x >= otherSize) {
                        if (number == 0) continue;
                        return 1;
                    }
                    int otherNumber = other.version.get(x);
                    if (number == otherNumber) continue;
                    return number - otherNumber;
                }
                for (x = size; x < other.version.size(); ++x) {
                    if (other.version.get(x) == 0) continue;
                    return -1;
                }
            }
            if (this.release == null) {
                return other.release == null || other.release == 0 ? 0 : -1;
            }
            if (other.release == null) {
                return this.release == 0 ? 0 : 1;
            }
            int result = this.release - other.release;
            return result;
        }
    }
}

