/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.io.File;
import java.io.IOException;
import oracle.ideimpl.deferredupdate.UpdateArb;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;

public class CreateFile
extends AtomicTask {
    private final File _file;
    private boolean _createdFile;

    public CreateFile(File file) {
        this._file = file;
    }

    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        if (this._file.exists()) {
            if (this._file.isDirectory()) {
                throw new TaskFailedException(UpdateArb.format("DIRECTORY_IN_THE_WAY", this._file));
            }
            this._createdFile = false;
            return;
        }
        try {
            if (!this._file.createNewFile()) {
                throw new TaskFailedException(UpdateArb.format("CREATE_FILE_FAILED", this._file));
            }
            this._createdFile = true;
        }
        catch (IOException ioe) {
            throw new TaskFailedException(UpdateArb.format("CREATE_FILE_FAILED", this._file), ioe);
        }
    }

    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
        if (this._createdFile && !this._file.delete()) {
            throw new TaskFailedException(UpdateArb.format("DELETE_FAILED", this._file));
        }
    }
}

