/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLKey;
import oracle.ide.net.URLPath;
import oracle.javatools.util.WeakCache;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.locator.ArrayClassLocator;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.DirURLClassLocator;
import oracle.jdeveloper.java.locator.JarClassPathClassLocator;
import oracle.jdeveloper.java.locator.JarURLClassLocator;
import oracle.jdeveloper.java.locator.PathClassLocator;

public class ClassLocatorFactory {
    private static final WeakCache<URLKey, BaseClassLocator> _sourceLocatorCache = new WeakCache();
    private static final WeakCache<URLKey, BaseClassLocator> _classLocatorCache = new WeakCache();

    public static ClassLocatorFactory getInstance() {
        return JavaModelFactory.getInstance().getLocatorFactory();
    }

    private static BaseClassLocator createURLClassLocator(URL rootURL, int fileType) {
        return JarUtil.isJarURL((URL)rootURL) ? new JarURLClassLocator(rootURL, fileType) : new DirURLClassLocator(rootURL, fileType);
    }

    private static URL sanitize(URL url) {
        if (!JarUtil.isJarURL((URL)url)) {
            String suffix = URLFileSystem.getSuffix((URL)url);
            if (".jar".equals(suffix) || ".zip".equals(suffix)) {
                return URLFactory.newJarURL((URL)url, null);
            }
            String path = url.getPath();
            if (path != null && path.length() > 0 && path.charAt(path.length() - 1) != '/') {
                return URLFactory.replacePathPart((URL)url, (String)(path + "/"));
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseClassLocator getSourceLocator(URL rootURL) {
        if (rootURL != null) {
            rootURL = ClassLocatorFactory.sanitize(rootURL);
            URLKey key = URLKey.getInstance((URL)rootURL);
            WeakCache<URLKey, BaseClassLocator> weakCache = _sourceLocatorCache;
            synchronized (weakCache) {
                BaseClassLocator locator = (BaseClassLocator)_sourceLocatorCache.get((Object)key);
                if (locator == null) {
                    locator = ClassLocatorFactory.createURLClassLocator(rootURL, 2);
                    _sourceLocatorCache.put((Object)key.intern(), (Object)locator);
                }
                return locator;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseClassLocator getClassLocator(URL rootURL) {
        if (rootURL != null) {
            rootURL = ClassLocatorFactory.sanitize(rootURL);
            URLKey key = URLKey.getInstance((URL)rootURL);
            WeakCache<URLKey, BaseClassLocator> weakCache = _classLocatorCache;
            synchronized (weakCache) {
                BaseClassLocator locator = (BaseClassLocator)_classLocatorCache.get((Object)key);
                if (locator == null) {
                    locator = ClassLocatorFactory.createURLClassLocator(rootURL, 1);
                    _classLocatorCache.put((Object)key.intern(), (Object)locator);
                }
                return JarUtil.isJarURL((URL)rootURL) ? new JarClassPathClassLocator(rootURL, locator) : locator;
            }
        }
        return null;
    }

    public BaseClassLocator getSourceLocator(URLPath urlPath) {
        try {
            return this.createArrayClassLocator(urlPath, 2, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public BaseClassLocator getSourceLocatorInterruptibly(URLPath urlPath) throws InterruptedException {
        return this.createArrayClassLocator(urlPath, 2, true);
    }

    public BaseClassLocator getClassLocator(URLPath urlPath) {
        try {
            return this.createArrayClassLocator(urlPath, 1, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public BaseClassLocator getClassLocatorInterruptibly(URLPath urlPath) throws InterruptedException {
        return this.createArrayClassLocator(urlPath, 1, true);
    }

    private BaseClassLocator createArrayClassLocator(URLPath urlPath, int fileType, boolean checkInterrupt) throws InterruptedException {
        if (urlPath != null) {
            int urlCount;
            URL[] urls = urlPath.getEntries();
            int n = urlCount = urls != null ? urls.length : 0;
            if (urlCount == 0) {
                return BaseClassLocator.EMPTY_LOCATOR;
            }
            BaseClassLocator[] locators = new BaseClassLocator[urlCount];
            for (int i = 0; i < urlCount; ++i) {
                if (checkInterrupt) {
                    ClassLocatorFactory.checkInterrupt();
                }
                URL url = urls[i];
                BaseClassLocator locator = fileType == 2 ? this.getSourceLocator(url) : this.getClassLocator(url);
                locators[i] = BaseClassLocator.ensureValid(locator);
            }
            return new ArrayClassLocator(locators);
        }
        return null;
    }

    public BaseClassLocator getPathLocator(URLPath sourcePath, URLPath classPath) {
        if (sourcePath != null || classPath != null) {
            return PathClassLocator.getInstance(sourcePath, classPath);
        }
        return null;
    }

    public BaseClassLocator getPathLocatorInterruptibly(URLPath sourcePath, URLPath classPath) throws InterruptedException {
        if (sourcePath != null || classPath != null) {
            return PathClassLocator.getInstanceInterruptibly(sourcePath, classPath);
        }
        return null;
    }

    private static void checkInterrupt() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }
}

