/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLKey;
import oracle.javatools.util.ArraySortedSet;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ModularizedJdkURLFileSystemHelper;
import oracle.jdeveloper.java.locator.ModularizedPackageEntry;

public class ModularizedJdkClassLocator
extends BaseClassLocator {
    private static final String MODULES_PATH_NAME = "/modules/";
    private String actualModulesPathName;
    private static final Map<URLKey, WeakReference<ModularizedJdkClassLocator>> INSTANCES;
    private volatile Map<String, ModularizedPackageEntry> _packageMap;
    private long _lastJrtfsJarTimestamp = -1L;
    private final URL _jrtfsjar;
    private FileSystem _fs;
    private List<String> _moduleNames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModularizedJdkClassLocator getInstance(URL jrtfsjar) {
        Map<URLKey, WeakReference<ModularizedJdkClassLocator>> map = INSTANCES;
        synchronized (map) {
            URLKey key = URLKey.getInstance((URL)jrtfsjar);
            WeakReference<ModularizedJdkClassLocator> ref = INSTANCES.get(key);
            if (ref != null) {
                ModularizedJdkClassLocator locator = (ModularizedJdkClassLocator)ref.get();
                if (locator != null) {
                    return locator;
                }
                INSTANCES.remove(key);
            }
            return new ModularizedJdkClassLocator(jrtfsjar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModularizedJdkClassLocator(URL jrtfsjar) {
        this._jrtfsjar = URLFactory.intern((URL)jrtfsjar);
        Map<URLKey, WeakReference<ModularizedJdkClassLocator>> map = INSTANCES;
        synchronized (map) {
            INSTANCES.put(URLKey.getInstance((URL)this._jrtfsjar), new WeakReference<ModularizedJdkClassLocator>(this));
        }
        this._lastJrtfsJarTimestamp = URLFileSystem.lastModified((URL)this._jrtfsjar);
    }

    protected void finalize() throws Throwable {
        if (this._fs != null) {
            this._fs.close();
        }
    }

    @Override
    public void getPackages(String packagePrefix, Collection<String> out) {
        this.buildIndex();
        ModularizedPackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            out.addAll(entry.getSubpackageNamesAsList());
        }
    }

    @Override
    public void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        this.buildIndexInterruptibly();
        ModularizedJdkClassLocator.checkInterrupt();
        ModularizedPackageEntry entry = this.findPackageInterruptibly(packagePrefix);
        if (entry != null) {
            out.addAll(entry.getSubpackageNamesAsList());
        }
    }

    @Override
    public void getClassesInPackage(String packagePrefix, Collection<String> out) {
        this.buildIndex();
        try {
            this.getClassesInPackageImpl(packagePrefix, out, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        this.buildIndexInterruptibly();
        this.getClassesInPackageImpl(packagePrefix, out, true);
    }

    @Override
    public void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        this.buildIndex();
        try {
            this.getAllClassesImpl(out, filter, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        this.buildIndexInterruptibly();
        this.getAllClassesImpl(out, filter, true);
    }

    @Override
    public void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        this.buildIndex();
        try {
            this.getAllPackagesImpl(out, filter, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        this.buildIndexInterruptibly();
        this.getAllPackagesImpl(out, filter, true);
    }

    @Override
    public void buildIndex() {
        try {
            this.buildIndexImpl(false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void buildIndexInterruptibly() throws InterruptedException {
        this.buildIndexImpl(true);
    }

    @Override
    public URL getURL(String fqClassName) {
        this.buildIndex();
        try {
            return this.getURLImpl(fqClassName, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        this.buildIndexInterruptibly();
        return this.getURLImpl(fqClassName, true);
    }

    public URL getModuleInfoURL(String moduleName) {
        this.buildIndex();
        try {
            return this.getModuleInfoURLImpl(moduleName, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    public URL getModuleInfoURLInterruptibly(String moduleName) throws InterruptedException {
        this.buildIndexInterruptibly();
        return this.getModuleInfoURLImpl(moduleName, true);
    }

    @Override
    public URL getSourceURL(String fqClassName) {
        return null;
    }

    @Override
    public URL getClassURL(String fqClassName) {
        this.buildIndex();
        return this.getURL(fqClassName);
    }

    @Override
    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        this.buildIndexInterruptibly();
        return this.getURLInterruptibly(fqClassName);
    }

    @Override
    public URL getResourceURL(String resourceName) {
        return null;
    }

    @Override
    public String getModuleNameOfClass(String fqClassName) {
        this.buildIndex();
        try {
            return this.getModuleNameOfClassImpl(fqClassName, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public String getModuleNameOfClassInterruptibly(String fqClassName) throws InterruptedException {
        this.buildIndex();
        return this.getModuleNameOfClassImpl(fqClassName, true);
    }

    private String getModuleNameOfClassImpl(String fqClassName, boolean checkInterrupt) throws InterruptedException {
        String moduleIndex = this.getModuleIndexForClass(fqClassName, checkInterrupt);
        return moduleIndex != null ? this.getModuleName(moduleIndex) : null;
    }

    boolean classExists(String moduleIndex, String className) {
        this.buildIndex();
        String module = this.getModuleName(moduleIndex);
        if (module != null) {
            String[] pieces = className.replace('\\', '/').split("/");
            String[] allPieces = new String[1 + pieces.length];
            allPieces[0] = module;
            for (int x = 0; x < pieces.length; ++x) {
                allPieces[1 + x] = pieces[x];
            }
            Path path = this._fs.getPath(this.actualModulesPathName, allPieces);
            return Files.exists(path, LinkOption.NOFOLLOW_LINKS);
        }
        return false;
    }

    private String getModuleName(String moduleIndex) {
        try {
            return this._moduleNames.get(Integer.parseInt(moduleIndex, 16));
        }
        catch (Exception ex) {
            assert (false);
            return null;
        }
    }

    boolean packageExists(String name) {
        this.buildIndex();
        return this.findPackage(name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getBytes(String moduleIndex, String fqClassName) throws IOException {
        this.buildIndex();
        String module = this.getModuleName(moduleIndex);
        if (module != null) {
            String[] pieces = fqClassName.replace('\\', '/').split("/");
            String[] allPieces = new String[1 + pieces.length];
            allPieces[0] = module;
            for (int x = 0; x < pieces.length; ++x) {
                allPieces[1 + x] = pieces[x];
            }
            Path path = this._fs.getPath(this.actualModulesPathName, allPieces);
            if (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
                try (InputStream inputStream = null;){
                    int read;
                    inputStream = Files.newInputStream(path, StandardOpenOption.READ);
                    byte[] bytes = new byte[4096];
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    while ((read = inputStream.read(bytes)) >= 0) {
                        out.write(bytes);
                    }
                    byte[] byArray = out.toByteArray();
                    return byArray;
                }
            }
        }
        return new byte[0];
    }

    long getLastModified() {
        return this._lastJrtfsJarTimestamp;
    }

    boolean isLocal() {
        return URLFileSystem.isLocal((URL)this._jrtfsjar);
    }

    private ModularizedPackageEntry findPackage(String packageName) {
        return this._packageMap.get(packageName);
    }

    private ModularizedPackageEntry findPackageInterruptibly(String packageName) throws InterruptedException {
        return this._packageMap.get(packageName);
    }

    private synchronized void buildIndexImpl(boolean checkInterrupt) throws InterruptedException {
        if (checkInterrupt) {
            ModularizedJdkClassLocator.checkInterrupt();
        }
        long timestamp = URLFileSystem.lastModified((URL)this._jrtfsjar);
        if (this._packageMap != null && timestamp == this._lastJrtfsJarTimestamp) {
            return;
        }
        this._moduleNames = new ArrayList<String>();
        HashMap<String, String> _moduleToIndex = new HashMap<String, String>();
        this._lastJrtfsJarTimestamp = timestamp;
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{this._jrtfsjar});
            this._fs = FileSystems.newFileSystem(URI.create("jrt:/"), Collections.emptyMap(), (ClassLoader)loader);
            HashMap<String, Collection<String>> packageToClassMap = new HashMap<String, Collection<String>>(512);
            HashMap<String, Collection<String>> packageToSubMap = new HashMap<String, Collection<String>>(512);
            for (Path rootDir : this._fs.getRootDirectories()) {
                if (checkInterrupt) {
                    ModularizedJdkClassLocator.checkInterrupt();
                }
                Stream<Path> rootDirStream = Files.list(rootDir);
                Iterator rootDirIter = rootDirStream.iterator();
                while (rootDirIter.hasNext()) {
                    Path rootDirPath;
                    String rootDirPathString;
                    if (checkInterrupt) {
                        ModularizedJdkClassLocator.checkInterrupt();
                    }
                    if (!MODULES_PATH_NAME.equals((rootDirPathString = (rootDirPath = (Path)rootDirIter.next()).toString()).replace('\\', '/') + "/")) continue;
                    this.actualModulesPathName = rootDirPathString;
                    Stream<Path> moduleStream = Files.list(rootDirPath);
                    Iterator moduleIter = moduleStream.iterator();
                    while (moduleIter.hasNext()) {
                        String moduleIndex;
                        Path modulePath;
                        String moduleName;
                        if (checkInterrupt) {
                            ModularizedJdkClassLocator.checkInterrupt();
                        }
                        if ((moduleName = (modulePath = (Path)moduleIter.next()).toString()).startsWith(this.actualModulesPathName)) {
                            moduleName = moduleName.substring(this.actualModulesPathName.length() + 1);
                        }
                        if ((moduleIndex = (String)_moduleToIndex.get(moduleName)) == null) {
                            moduleIndex = Integer.toHexString(this._moduleNames.size()) + "/";
                            this._moduleNames.add(moduleName);
                            _moduleToIndex.put(moduleName, moduleIndex);
                        }
                        this.indexClasses(moduleIndex, moduleName, modulePath, packageToClassMap, packageToSubMap, checkInterrupt);
                    }
                }
            }
            ArraySortedSet allKeys = new ArraySortedSet(100);
            allKeys.addAll(packageToClassMap.keySet());
            allKeys.addAll(packageToSubMap.keySet());
            HashMap<String, ModularizedPackageEntry> finalPackageMap = new HashMap<String, ModularizedPackageEntry>(allKeys.size());
            for (String packageName : allKeys) {
                if (checkInterrupt) {
                    ModularizedJdkClassLocator.checkInterrupt();
                }
                Collection classes = (Collection)packageToClassMap.get(packageName);
                Collection subs = (Collection)packageToSubMap.get(packageName);
                if ((classes == null || classes.isEmpty()) && (subs == null || subs.isEmpty())) continue;
                finalPackageMap.put(packageName, new ModularizedPackageEntry(packageName, classes, subs));
            }
            this._packageMap = finalPackageMap;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void indexClasses(String moduleIndex, String moduleName, Path dirPath, Map<String, Collection<String>> packageToClassMap, Map<String, Collection<String>> packageToSubMap, boolean checkInterrupt) throws IOException, InterruptedException {
        if (Files.isDirectory(dirPath, LinkOption.NOFOLLOW_LINKS)) {
            if (checkInterrupt) {
                ModularizedJdkClassLocator.checkInterrupt();
            }
            Stream<Path> stream = Files.list(dirPath);
            Iterator streamIter = stream.iterator();
            while (streamIter.hasNext()) {
                Path path;
                String pathName;
                if (checkInterrupt) {
                    ModularizedJdkClassLocator.checkInterrupt();
                }
                if ((pathName = (path = (Path)streamIter.next()).toString()).endsWith(".class")) {
                    this.indexClassMaps(moduleIndex, pathName.substring(this.actualModulesPathName.length() + 1 + moduleName.length() + 1), packageToClassMap, packageToSubMap);
                    continue;
                }
                this.indexClasses(moduleIndex, moduleName, path, packageToClassMap, packageToSubMap, checkInterrupt);
            }
        }
    }

    private void indexClassMaps(String moduleIndex, String classEntry, Map<String, Collection<String>> packageToClassMap, Map<String, Collection<String>> packageToSubMap) {
        int suffixDot = classEntry.lastIndexOf(46);
        String fqName = classEntry.substring(0, suffixDot).replace('\\', '.').replace('/', '.');
        int lastDot = fqName.lastIndexOf(46);
        String packagePrefix = lastDot != -1 ? fqName.substring(0, lastDot) : "";
        String className = lastDot != -1 ? fqName.substring(lastDot + 1) : fqName;
        boolean existingPackage = true;
        ArraySortedSet classList = packageToClassMap.get(packagePrefix);
        if (classList == null) {
            classList = new ArraySortedSet(75);
            packageToClassMap.put(packagePrefix, (Collection<String>)classList);
            existingPackage = false;
        }
        className = moduleIndex + new String(className);
        classList.add(className);
        if (existingPackage) {
            return;
        }
        if (packagePrefix.length() == 0) {
            return;
        }
        ModularizedJdkClassLocator.indexPackageMaps(packagePrefix, packageToSubMap);
    }

    private static void indexPackageMaps(String packagePrefix, Map<String, Collection<String>> packageToSubMap) {
        String outer = "";
        int pos = 0;
        boolean done = false;
        while (!done) {
            int nextDot = packagePrefix.indexOf(46, pos);
            if (nextDot == -1) {
                done = true;
                nextDot = packagePrefix.length();
            }
            String sub = packagePrefix.substring(pos, nextDot);
            ArraySortedSet subList = packageToSubMap.get(outer);
            if (subList == null) {
                subList = new ArraySortedSet(20);
                packageToSubMap.put(outer, (Collection<String>)subList);
            }
            subList.add((String)sub);
            outer = packagePrefix.substring(0, nextDot);
            pos = nextDot + 1;
        }
    }

    private void getClassesInPackageImpl(String packagePrefix, Collection<String> out, boolean checkInterrupt) throws InterruptedException {
        ModularizedPackageEntry entry;
        if (checkInterrupt) {
            ModularizedJdkClassLocator.checkInterrupt();
        }
        ModularizedPackageEntry modularizedPackageEntry = entry = checkInterrupt ? this.findPackageInterruptibly(packagePrefix) : this.findPackage(packagePrefix);
        if (entry != null) {
            out.addAll(entry.getTopLevelClassNamesAsList());
        }
    }

    private void getAllClassesImpl(Collection<String> out, ClassNameFilter filter, boolean checkInterrupt) throws InterruptedException {
        for (ModularizedPackageEntry entry : this._packageMap.values()) {
            if (checkInterrupt) {
                ModularizedJdkClassLocator.checkInterrupt();
            }
            String packageName = entry._packageName;
            List<String> classNames = entry.getTopLevelClassNamesAsList();
            for (String className : classNames) {
                if (checkInterrupt) {
                    ModularizedJdkClassLocator.checkInterrupt();
                }
                boolean acceptName = true;
                if (filter != null) {
                    acceptName = filter.acceptClassName(className, packageName);
                }
                if (!acceptName) continue;
                String fqName = ModularizedJdkClassLocator.buildFQName(packageName, className);
                out.add(fqName);
            }
        }
    }

    private void getAllPackagesImpl(Collection<String> out, PackageNameFilter filter, boolean checkInterrupt) throws InterruptedException {
        for (String packagePrefix : this._packageMap.keySet()) {
            if (checkInterrupt) {
                ModularizedJdkClassLocator.checkInterrupt();
            }
            if (packagePrefix.length() <= 0 || filter != null && !filter.acceptPackageName(packagePrefix)) continue;
            out.add(packagePrefix);
        }
    }

    private URL getURLImpl(String fqClassName, boolean checkInterrupt) throws InterruptedException {
        String moduleIndex = this.getModuleIndexForClass(fqClassName, checkInterrupt);
        if (moduleIndex != null) {
            return ModularizedJdkURLFileSystemHelper.createClassURL(this._jrtfsjar.getPath(), moduleIndex, fqClassName);
        }
        return null;
    }

    private URL getModuleInfoURLImpl(String moduleName, boolean checkInterrupt) throws InterruptedException {
        ModularizedPackageEntry foundEntry;
        if (moduleName == null || moduleName.isEmpty()) {
            return null;
        }
        ModularizedPackageEntry modularizedPackageEntry = foundEntry = checkInterrupt ? this.findPackageInterruptibly("") : this.findPackage("");
        if (foundEntry == null) {
            return null;
        }
        List<String[]> namesAndIndices = foundEntry.getClassNamesAndModuleIndices();
        for (String[] nameAndIndex : namesAndIndices) {
            if (!"module-info".equals(nameAndIndex[0]) || !moduleName.equals(this.getModuleName(nameAndIndex[1]))) continue;
            return ModularizedJdkURLFileSystemHelper.createClassURL(this._jrtfsjar.getPath(), nameAndIndex[1], nameAndIndex[0]);
        }
        return null;
    }

    private String getModuleIndexForClass(String fqClassName, boolean checkInterrupt) throws InterruptedException {
        int countCascades;
        String[] nameCascades = ModularizedJdkClassLocator.getNameCascades(fqClassName);
        int countParts = countCascades = nameCascades.length;
        if (countCascades > 0) {
            ModularizedPackageEntry foundEntry;
            String packagePrefix = countCascades > 1 ? nameCascades[countCascades - 2] : "";
            ModularizedPackageEntry modularizedPackageEntry = foundEntry = checkInterrupt ? this.findPackageInterruptibly(packagePrefix) : this.findPackage(packagePrefix);
            if (foundEntry == null) {
                return null;
            }
            String[] nameParts = ModularizedJdkClassLocator.getNameParts(fqClassName);
            String className = nameParts[countParts - 1];
            return foundEntry.getModuleIndexForClass(className);
        }
        return null;
    }

    static {
        URLFileSystem.registerHelper((String)"mjdk", (URLFileSystemHelper)new ModularizedJdkURLFileSystemHelper());
        URLStreamHandlerFactory factory = new URLStreamHandlerFactory(){

            @Override
            public URLStreamHandler createURLStreamHandler(String protocol) {
                if ("mjdk".equals(protocol)) {
                    return new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL u) throws IOException {
                            return null;
                        }
                    };
                }
                return null;
            }
        };
        URLFileSystem.addURLStreamHandlerFactory((String)"mjdk", (URLStreamHandlerFactory)factory);
        INSTANCES = new HashMap<URLKey, WeakReference<ModularizedJdkClassLocator>>();
    }
}

