/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.annotation;

import java.lang.reflect.Method;
import oracle.bali.xml.beanmodel.annotation.MethodIdentifierException;
import oracle.bali.xml.beanmodel.annotation.Operation;
import oracle.bali.xml.beanmodel.annotation.PropertyType;

public class MethodIdentifier {
    private final Operation _operation;
    private final PropertyType _propertyType;

    public static MethodIdentifier create(Operation operation, PropertyType propertyType) throws MethodIdentifierException {
        if (operation == null) {
            throw new MethodIdentifierException("MethodIdentifier.create passed null operation");
        }
        if (propertyType == null) {
            throw new MethodIdentifierException("MethodIdentifier.create passed null propertyType");
        }
        return new MethodIdentifier(operation, propertyType);
    }

    public static MethodIdentifier createFromMethod(Method method) throws MethodIdentifierException {
        if (method == null) {
            throw new IllegalArgumentException("MethodIdentifier.createFromMethod passed null method");
        }
        Operation operation = method.getAnnotation(Operation.class);
        if (operation == null) {
            throw new MethodIdentifierException("Missing required @Operation annotation on method: " + method);
        }
        PropertyType propertyType = method.getAnnotation(PropertyType.class);
        if (propertyType == null) {
            throw new MethodIdentifierException("Missing required @PropertyType annotation on method: " + method);
        }
        return new MethodIdentifier(operation, propertyType);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MethodIdentifier) {
            MethodIdentifier other = (MethodIdentifier)object;
            return this._operation.equals(other._operation) && this._propertyType.equals(other._propertyType);
        }
        return false;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 1;
        result = 37 * result + this._operation.hashCode();
        result = 37 * result + this._propertyType.hashCode();
        return result;
    }

    public String toString() {
        return "MethodIdentifier: " + this._operation + " " + this._propertyType;
    }

    private MethodIdentifier(Operation operation, PropertyType propertyType) {
        this._operation = operation;
        this._propertyType = propertyType;
    }
}

