/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml.dtd.grammar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.jdeveloper.xml.dtd.grammar.DtdElement;
import oracle.jdeveloper.xml.dtd.grammar.DtdGrammar;
import oracle.jdeveloper.xml.dtd.grammar.Entity;
import oracle.jdeveloper.xml.dtd.grammar.Notation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarUtils {
    private static final HashMap _predefinedEntities = new HashMap(13);
    private static final HashMap _predefinedEntityValues;

    public static boolean areNamesCaseSensitive(GrammarProvider provider, String namespaceURI) {
        if (provider == null) {
            return true;
        }
        Grammar grammar = provider.getGrammarForNamespace(namespaceURI);
        if (!(grammar instanceof DtdGrammar)) {
            return true;
        }
        return ((DtdGrammar)grammar).isCaseSensitive();
    }

    public static String getRootElementName(GrammarProvider provider, String namespaceURI) {
        Grammar grammar = provider.getGrammarForNamespace(namespaceURI);
        if (!(grammar instanceof DtdGrammar)) {
            return null;
        }
        return ((DtdGrammar)grammar).getRootElementName();
    }

    public static Notation getNotation(GrammarProvider provider, String namespaceUri, String notationName) {
        Map<String, Notation> notations = GrammarUtils.getNotations(provider, namespaceUri);
        return notations.get(notationName);
    }

    public static Entity getEntity(GrammarProvider provider, String namespaceUri, String entityName) {
        Map<String, Entity> entities = GrammarUtils.getEntities(provider, namespaceUri);
        return entities.get(entityName);
    }

    public static Map<String, Entity> getEntities(GrammarProvider provider, String namespaceUri) {
        Grammar grammar = provider.getGrammarForNamespace(namespaceUri);
        if (!(grammar instanceof DtdGrammar)) {
            return _predefinedEntities;
        }
        return ((DtdGrammar)grammar).getEntities();
    }

    public static Map<String, Entity> getEntityValues(GrammarProvider provider, String namespaceURI) {
        Grammar grammar = provider.getGrammarForNamespace(namespaceURI);
        return GrammarUtils.getEntityValues(grammar);
    }

    public static Map<String, Entity> getEntityValues(Grammar grammar) {
        if (!(grammar instanceof DtdGrammar)) {
            return _predefinedEntityValues;
        }
        return ((DtdGrammar)grammar).getEntityValues();
    }

    private static Map<String, Notation> getNotations(GrammarProvider provider, String namespaceUri) {
        Grammar grammar = provider.getGrammarForNamespace(namespaceUri);
        if (!(grammar instanceof DtdGrammar)) {
            return Collections.EMPTY_MAP;
        }
        return ((DtdGrammar)grammar).getNotations();
    }

    public static boolean isStartTagRequired(GrammarProvider provider, String namespace, String elementName) {
        ElementDef elDef = GrammarUtils.getElementDef(provider, namespace, elementName);
        if (!(elDef instanceof DtdElement)) {
            return true;
        }
        return ((DtdElement)elDef).isStartTagRequired();
    }

    public static boolean isEndTagRequired(GrammarProvider provider, String namespace, String elementName) {
        ElementDef elDef = GrammarUtils.getElementDef(provider, namespace, elementName);
        if (!(elDef instanceof DtdElement)) {
            return true;
        }
        return ((DtdElement)elDef).isEndTagRequired();
    }

    private static final ElementDef getElementDef(GrammarProvider provider, String namespaceURI, String elementName) {
        Grammar grammar = provider.getGrammarForNamespace(namespaceURI);
        if (grammar == null) {
            return null;
        }
        return grammar.getElementDefByName(elementName);
    }

    static Wildcard getMatchingWildcard(ComplexType complexType, String namespace) {
        return TypeUtils.getMatchingWildcard(GrammarUtils.getElementWildcards(complexType), namespace);
    }

    private static List getElementWildcards(ComplexType complexType) {
        ArrayList wildcards = new ArrayList();
        if (complexType != null) {
            ContentGroup group = complexType.getContentGroup();
            GrammarUtils._addGroupWildcards(group, wildcards);
        }
        return wildcards;
    }

    private static void _addGroupWildcards(ContentGroup group, List wildcards) {
        Collection groupComponents;
        if (group != null && (groupComponents = group.getComponents()) != null) {
            for (GrammarComponent component : groupComponents) {
                if (component instanceof Wildcard) {
                    Wildcard wildcard = (Wildcard)component;
                    wildcards.add(wildcard);
                    continue;
                }
                if (!(component instanceof ContentGroup)) continue;
                ContentGroup subGroup = (ContentGroup)component;
                GrammarUtils._addGroupWildcards(subGroup, wildcards);
            }
        }
    }

    static {
        _predefinedEntities.put("amp", new XmlEntity("amp", "&"));
        _predefinedEntities.put("lt", new XmlEntity("lt", "<"));
        _predefinedEntities.put("gt", new XmlEntity("gt", ">"));
        _predefinedEntities.put("apos", new XmlEntity("apos", "'"));
        _predefinedEntities.put("quot", new XmlEntity("quot", "\""));
        _predefinedEntityValues = new HashMap(13);
        _predefinedEntityValues.put("&", new XmlEntity("amp", "&"));
        _predefinedEntityValues.put("<", new XmlEntity("lt", "<"));
        _predefinedEntityValues.put(">", new XmlEntity("gt", ">"));
        _predefinedEntityValues.put("'", new XmlEntity("apos", "'"));
        _predefinedEntityValues.put("\"", new XmlEntity("quot", "\""));
    }

    private static class XmlEntity
    implements Entity {
        private final String name;
        private final String value;

        private XmlEntity(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getSystemId() {
            return null;
        }

        public String getPublicId() {
            return null;
        }

        public String getNotationName() {
            return null;
        }
    }
}

