/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.dtd.parser;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.common.ElementDefReference;
import oracle.jdeveloper.xml.dtd.grammar.DtdComplexType;
import oracle.jdeveloper.xml.dtd.grammar.DtdContentGroup;
import oracle.jdeveloper.xml.dtd.grammar.DtdElement;
import oracle.jdeveloper.xml.dtd.grammar.DtdLoader;
import oracle.jdeveloper.xml.dtd.grammar.GrammarFactory;
import oracle.jdevimpl.xml.dtd.parser.ParserConstants;
import oracle.jdevimpl.xml.dtd.parser.ParserError;
import oracle.jdevimpl.xml.dtd.parser.XMLCharReader;
import oracle.jdevimpl.xml.dtd.parser.XMLEntity;
import oracle.jdevimpl.xml.dtd.parser.XMLReader;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DtdElementContentParser
implements ParserConstants {
    private static final int OPTIONAL = 0;
    private static final int MANDATORY = 1;
    private static final int ONE_MANY = 2;
    private static final int ZERO_MANY = 3;
    private DtdLoader loader;
    private boolean isXML;
    private static SimpleType TEXT = GrammarFactory.getBuiltInType(3);
    private ComplexType TEXT_TYPE;
    private boolean element;
    private boolean pcdata;

    public DtdElementContentParser(DtdLoader loader, boolean xml) {
        this.isXML = xml;
        this.loader = loader;
        this.TEXT_TYPE = GrammarFactory.getTextType(loader.getNamespace());
    }

    public Content parseContent(String s) throws SAXException, IOException {
        ParserError error = new ParserError();
        XMLCharReader charreader = new XMLCharReader(s, "", "");
        XMLReader reader = new XMLReader(null, error, null);
        reader.pushXMLReader(charreader);
        return this.parseContent(error, reader);
    }

    public synchronized Content parseContent(ParserError error, XMLReader reader) throws SAXException, IOException {
        this.reset();
        Content retValue = new Content();
        retValue.type = reader.tryRead(cEMPTY, 0, cEMPTY.length) ? GrammarFactory.getEmptyType(this.loader.getNamespace()) : (reader.tryRead(cCDATA, 0, cCDATA.length) ? this.TEXT_TYPE : this.parseModel(error, reader));
        return retValue;
    }

    private void reset() {
        this.element = false;
        this.pcdata = false;
    }

    private ComplexType parseModel(ParserError error, XMLReader reader) throws SAXException, IOException {
        ComplexType model = null;
        DtdContentGroup group = null;
        if (reader.tryRead(cANY, 0, cANY.length)) {
            model = GrammarFactory.getWildcardType(this.loader.getNamespace());
        } else if (reader.tryRead(40)) {
            reader.push('(');
            group = this.parseGroup(error, reader);
        }
        if (model != null || group != null) {
            if (model == null) {
                int variety = 6;
                if (this.element) {
                    variety = this.pcdata ? 4 : 3;
                } else if (this.pcdata) {
                    variety = 5;
                }
                group = this.parseInclExcl(error, reader, group);
                model = new DtdComplexType(group, this.loader.getNamespace(), variety);
            }
            return model;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DtdContentGroup parseGroup(ParserError error, XMLReader reader) throws SAXException, IOException {
        reader.skipWhiteSpace();
        if (!reader.tryRead(40)) {
            error.error0(285, 0);
            return null;
        }
        reader.skipWhiteSpace();
        DtdContentGroup dtdGroup = null;
        boolean enableContentReuse = false;
        if (enableContentReuse) {
            reader.resolveInternalEntity(false);
            try {
                if (reader.peek() == 37) {
                    reader.tryRead(37);
                    XMLEntity entity = reader.parser.parseEntity(true);
                    if (entity == null) {
                        error.error0(285, 0);
                        DtdContentGroup dtdContentGroup = null;
                        return dtdContentGroup;
                    }
                    reader.skipWhiteSpace();
                    if (reader.tryRead(41)) {
                        dtdGroup = new DtdContentGroup(7);
                        dtdGroup.addComponent(TEXT);
                    } else {
                        reader.pushEntityRef(entity);
                    }
                }
            }
            finally {
                reader.resolveInternalEntity(true);
            }
        }
        if (dtdGroup == null) {
            dtdGroup = this.parseGroupList(error, reader);
        }
        if (dtdGroup != null) {
            int quantifier = DtdElementContentParser.parseQuantifier(error, reader);
            DtdElementContentParser.appllyQuantifier(dtdGroup, quantifier);
        }
        return dtdGroup;
    }

    private DtdContentGroup parseGroupList(ParserError error, XMLReader reader) throws SAXException, IOException {
        reader.skipWhiteSpace();
        DtdContentGroup dtdGroup = null;
        GrammarComponent head = this.parseQualElem(error, reader);
        reader.skipWhiteSpace();
        int variety = 10;
        if (reader.tryRead(124)) {
            variety = 8;
        } else if (reader.tryRead(44)) {
            variety = 9;
        } else if (reader.tryRead(38)) {
            variety = 7;
        }
        if (variety != 10) {
            dtdGroup = new DtdContentGroup(variety);
            if (head != null) {
                dtdGroup.addComponent(head);
            }
            this.parseGroupList2(error, reader, dtdGroup);
        } else if (head != null) {
            dtdGroup = new DtdContentGroup(7);
            dtdGroup.addComponent(head);
        }
        reader.skipWhiteSpace();
        if (!reader.tryRead(41)) {
            error.error0(285, 0);
        }
        return dtdGroup;
    }

    private DtdContentGroup parseInclExcl(ParserError error, XMLReader reader, DtdContentGroup content) throws SAXException, IOException {
        DtdContentGroup group = content;
        reader.skipWhiteSpace();
        if (reader.tryRead(43)) {
            List<GrammarComponent> extraElements = this.parseList(error, reader);
            if (extraElements != null && extraElements.size() > 0) {
                group.includeElements(extraElements);
            }
        } else if (reader.tryRead(45)) {
            if (reader.tryRead(45)) {
                reader.push('-');
                reader.push('-');
            } else {
                List<GrammarComponent> excludedElements = this.parseList(error, reader);
                if (excludedElements != null) {
                    group.excludeElements(excludedElements);
                }
            }
        }
        return group;
    }

    private void parseGroupList(ParserError error, XMLReader reader, DtdContentGroup group) throws SAXException, IOException {
        GrammarComponent elem = this.parseQualElem(error, reader);
        reader.skipWhiteSpace();
        int variety = 10;
        if (reader.tryRead(124)) {
            variety = 8;
        } else if (reader.tryRead(44)) {
            variety = 9;
        } else if (reader.tryRead(38)) {
            variety = 7;
        }
        reader.skipWhiteSpace();
        if (variety != 10) {
            if (variety != group.getVariety()) {
                error.error0(110, 0);
            }
            if (this.isXML && elem == TEXT) {
                error.error0(110, 0);
            } else if (elem != null) {
                group.addComponent(elem);
            }
            this.parseGroupList(error, reader, group);
        } else if (elem != null) {
            group.addComponent(elem);
        }
    }

    private void parseGroupList2(ParserError error, XMLReader reader, DtdContentGroup group) throws SAXException, IOException {
        int variety = 10;
        do {
            GrammarComponent elem = this.parseQualElem(error, reader);
            reader.skipWhiteSpace();
            variety = reader.tryRead(124) ? 8 : (reader.tryRead(44) ? 9 : (reader.tryRead(38) ? 7 : 10));
            reader.skipWhiteSpace();
            if (variety == 10) {
                if (elem == null) continue;
                group.addComponent(elem);
                continue;
            }
            if (variety != group.getVariety()) {
                error.error0(110, 0);
            }
            if (this.isXML && elem == TEXT) {
                error.error0(110, 0);
                continue;
            }
            if (elem == null) continue;
            group.addComponent(elem);
        } while (variety != 10);
    }

    private List<GrammarComponent> parseList(ParserError error, XMLReader reader) throws SAXException, IOException {
        reader.skipWhiteSpace();
        if (!reader.tryRead(40)) {
            error.error0(285, 0);
            return null;
        }
        reader.skipWhiteSpace();
        LinkedList<GrammarComponent> list = new LinkedList<GrammarComponent>();
        GrammarComponent element = this.parseLeaf(error, reader);
        if (element != null) {
            list.add(element);
        }
        reader.skipWhiteSpace();
        while (!reader.tryRead(41)) {
            if (!reader.tryRead(124)) {
                error.error0(285, 0);
                break;
            }
            reader.skipWhiteSpace();
            element = this.parseLeaf(error, reader);
            if (element == null) break;
            list.add(element);
            reader.skipWhiteSpace();
        }
        return list;
    }

    private GrammarComponent parseQualElem(ParserError error, XMLReader reader) throws SAXException, IOException {
        reader.skipWhiteSpace();
        GrammarComponent leaf = null;
        if (reader.tryRead(40)) {
            reader.push('(');
            leaf = this.parseGroup(error, reader);
        } else if (reader.tryRead(35)) {
            String name = DtdElementContentParser.readName(reader);
            if (name != "PCDATA") {
                error.error0(110, 0);
                return null;
            }
            leaf = TEXT;
            this.pcdata = true;
        } else {
            String name = DtdElementContentParser.readName(reader);
            ElementDef dtdElement = this.loader.getContentElement(name);
            leaf = DtdElementContentParser.appllyQuantifier(dtdElement, DtdElementContentParser.parseQuantifier(error, reader));
            this.element = true;
        }
        return leaf;
    }

    private GrammarComponent parseLeaf(ParserError error, XMLReader reader) throws SAXException, IOException {
        reader.skipWhiteSpace();
        GrammarComponent leaf = null;
        if (reader.tryRead(35)) {
            String name = DtdElementContentParser.readName(reader);
            if (name != "PCDATA") {
                error.error0(110, 0);
            } else {
                leaf = TEXT;
            }
        } else if (reader.tryRead(40)) {
            error.error0(110, 0);
        } else {
            String name = DtdElementContentParser.readName(reader);
            if (name != null) {
                leaf = this.loader.getContentElement(name);
            }
        }
        return leaf;
    }

    private static int parseQuantifier(ParserError error, XMLReader reader) throws SAXException, IOException {
        if (reader.tryRead(42)) {
            return 3;
        }
        if (reader.tryRead(43)) {
            return 2;
        }
        if (reader.tryRead(63)) {
            return 0;
        }
        return 1;
    }

    private static String readName(XMLReader reader) throws SAXException, IOException {
        reader.skipWhiteSpace();
        String s = reader.scanQName();
        reader.skipWhiteSpace();
        return s;
    }

    private static DtdContentGroup getGroup(GrammarComponent component) {
        if (component instanceof DtdContentGroup) {
            return (DtdContentGroup)component;
        }
        if (component == TEXT || component instanceof DtdElement) {
            DtdContentGroup group = new DtdContentGroup(7);
            group.setOccurs(1, 1);
            group.addComponent(component);
            return group;
        }
        Thread.dumpStack();
        return null;
    }

    private static GrammarComponent appllyQuantifier(ElementDef element, int quantifier) {
        switch (quantifier) {
            case 1: {
                return element;
            }
        }
        MutableInteger min = new MutableInteger(0);
        MutableInteger max = new MutableInteger(1);
        DtdElementContentParser.appllyQuantifier(quantifier, min, max);
        return new ElementDefReference(element, min.intValue(), max.intValue());
    }

    private static void appllyQuantifier(DtdContentGroup group, int quantifier) {
        MutableInteger min = new MutableInteger(0);
        MutableInteger max = new MutableInteger(1);
        DtdElementContentParser.appllyQuantifier(quantifier, min, max);
        group.setOccurs(min.intValue(), max.intValue());
    }

    private static void appllyQuantifier(int quantifier, MutableInteger min, MutableInteger max) {
        switch (quantifier) {
            case 0: {
                min.set(0);
                max.set(1);
                break;
            }
            case 1: {
                min.set(1);
                max.set(1);
                break;
            }
            case 2: {
                min.set(1);
                max.set(-1);
                break;
            }
            case 3: {
                min.set(0);
                max.set(-1);
                break;
            }
            default: {
                min.set(0);
                max.set(1);
            }
        }
    }

    private static final class MutableInteger
    extends Number {
        private int value;

        public MutableInteger(int value) {
            this.value = value;
        }

        public int get() {
            return this.value;
        }

        public void set(int value) {
            this.value = value;
        }

        public int intValue() {
            return this.value;
        }

        public long longValue() {
            return this.value;
        }

        public float floatValue() {
            return this.value;
        }

        public double doubleValue() {
            return this.value;
        }

        public int preincrement() {
            return ++this.value;
        }

        public int predecrement() {
            return --this.value;
        }

        public int postincrement() {
            return this.value++;
        }

        public int postdecrement() {
            return this.value--;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static class Content {
        public ComplexType type;

        Content() {
        }
    }
}

