/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.SharedPropertiesAdapter;
import oracle.ide.model.SharedPropertiesManager;
import oracle.ide.model.Workspace;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdevimpl.runner.extres.ExtensionResources;

public class RunConfigurationReader
extends SharedPropertiesAdapter {
    public static final String DATA_KEY = "oracle.jdeveloper.runner.RunConfigurations";
    public static final String RUN_CONFIGURATION_LIST = "runConfigurationList";
    public static final String RUN_CONFIGURATION_DEFINITIONS = "runConfigurationDefinitions";
    public static final String RUN_CONFIGURATION_NAME = "name";
    public static final String RUN_CONFIGURATION_ACTIVE_NAME = "activeName";
    public static final String REMOTE_DEBUGGING_PROFILING = "remoteDebuggingProfiling";

    private RunConfigurationReader(HashStructure hash) {
        super(hash);
    }

    static List<String> getRunConfigurationNames(Project project) {
        boolean useWorkspaceRunConfigurations;
        ArrayList<String> defaultNames = new ArrayList<String>();
        boolean bl = useWorkspaceRunConfigurations = project == null ? false : SharedPropertiesManager.get().isUsingSharedProperties(project, DATA_KEY);
        if (useWorkspaceRunConfigurations) {
            defaultNames.add(ExtensionResources.get("RUN_CONFIGURATION_SHARED_NAME"));
        } else {
            defaultNames.add(ExtensionResources.get("RUN_CONFIGURATION_DEFAULT_NAME"));
        }
        if (project == null || project.getWorkspace() == null) {
            return defaultNames;
        }
        PropertyStorage ps = RunConfigurationReader.getActivePropertyStorage((Project)project, (String)DATA_KEY);
        HashStructure properties = ps.getProperties();
        if (properties == null || !properties.containsKey(DATA_KEY)) {
            return defaultNames;
        }
        HashStructure phs = properties.getHashStructure(DATA_KEY);
        RunConfigurationReader reader = new RunConfigurationReader(phs);
        ListStructure runConfigList = reader.getRunConfigurationList();
        if (runConfigList == null) {
            return defaultNames;
        }
        HashStructure definitions = reader.getRunConfigurationDefinitions();
        if (definitions == null) {
            return defaultNames;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < runConfigList.size(); ++i) {
            HashStructure runConfig;
            Object object;
            String name = runConfigList.get(i).toString();
            if (!definitions.containsKey(name) || !((object = definitions.getObject(name)) instanceof HashStructure) || !(runConfig = (HashStructure)object).containsKey(RUN_CONFIGURATION_NAME)) continue;
            names.add(runConfig.getObject(RUN_CONFIGURATION_NAME).toString());
        }
        return names.size() > 0 ? names : defaultNames;
    }

    static String getActiveRunConfigurationName(Project project, Workspace workspace) {
        boolean useWorkspacePropertyStorage = project == null ? false : SharedPropertiesManager.get().isUsingSharedProperties(project, DATA_KEY);
        HashStructure userProperties = null;
        String activeName = null;
        if (useWorkspacePropertyStorage && workspace != null) {
            userProperties = workspace.getUserPropertiesOnly();
        } else if (!useWorkspacePropertyStorage && project != null) {
            userProperties = project.getUserPropertiesOnly();
        }
        if (userProperties != null) {
            activeName = userProperties.getString(RUN_CONFIGURATION_ACTIVE_NAME);
        }
        if (project == null) {
            project = Ide.getActiveProject();
        }
        if (project == null) {
            project = Ide.getDefaultProject();
        }
        PropertyStorage ps = RunConfigurationReader.getActivePropertyStorage((Project)project, (Workspace)workspace, (String)DATA_KEY);
        HashStructure properties = ps.getProperties();
        HashStructure activeProperties = properties.getOrCreateHashStructure(DATA_KEY);
        RunConfigurationReader reader = new RunConfigurationReader(activeProperties);
        ListStructure runConfigurationList = reader.getRunConfigurationList();
        HashStructure runConfigurationDefinitions = reader.getRunConfigurationDefinitions();
        if (runConfigurationList == null || runConfigurationDefinitions == null) {
            if (useWorkspacePropertyStorage) {
                return ExtensionResources.get("RUN_CONFIGURATION_SHARED_NAME");
            }
            return ExtensionResources.get("RUN_CONFIGURATION_DEFAULT_NAME");
        }
        if (activeName == null || !runConfigurationList.contains((Object)activeName) || !runConfigurationDefinitions.containsKey(activeName)) {
            String string = activeName = useWorkspacePropertyStorage ? ExtensionResources.get("RUN_CONFIGURATION_SHARED_NAME") : ExtensionResources.get("RUN_CONFIGURATION_CUSTOM_NAME");
        }
        if (activeName == null || !runConfigurationList.contains((Object)activeName) || !runConfigurationDefinitions.containsKey(activeName)) {
            activeName = ExtensionResources.get("RUN_CONFIGURATION_DEFAULT_NAME");
        }
        if (activeName == null || !runConfigurationList.contains((Object)activeName) || !runConfigurationDefinitions.containsKey(activeName)) {
            int size = runConfigurationList.size();
            for (int i = 0; i < size; ++i) {
                String name = (String)runConfigurationList.get(i);
                if (!runConfigurationDefinitions.containsKey(name)) continue;
                activeName = name;
                break;
            }
        }
        return activeName;
    }

    @Deprecated
    static String getActiveRunConfigurationName(Project project) {
        String activeName;
        boolean useWorkspaceRunConfigurations = project == null ? false : SharedPropertiesManager.get().isUsingSharedProperties(project, DATA_KEY);
        String defaultName = ExtensionResources.get("RUN_CONFIGURATION_DEFAULT_NAME");
        if (project == null) {
            return defaultName;
        }
        RunConfigurationReader reader = null;
        List<String> runConfigNames = RunConfigurationReader.getRunConfigurationNames(project);
        HashStructure properties = project.getUserPropertiesOnly();
        if (useWorkspaceRunConfigurations) {
            Workspace workspace = project.getWorkspace();
            if (workspace == null) {
                workspace = Ide.getActiveWorkspace();
            }
            properties = workspace.getUserPropertiesOnly();
        }
        if (properties != null && properties.containsKey(DATA_KEY) && runConfigNames.contains(activeName = (reader = new RunConfigurationReader(properties.getHashStructure(DATA_KEY))).getActiveName())) {
            return activeName;
        }
        String customName = ExtensionResources.get("RUN_CONFIGURATION_CUSTOM_NAME");
        if (runConfigNames.contains(customName)) {
            return customName;
        }
        if (!runConfigNames.isEmpty()) {
            return runConfigNames.get(0);
        }
        return defaultName;
    }

    static boolean isRemoteDebuggingProfiling(Project project) {
        if (project == null) {
            return false;
        }
        HashStructure properties = project.getUserPropertiesOnly();
        if (properties == null || !properties.containsKey(DATA_KEY)) {
            return false;
        }
        RunConfigurationReader reader = null;
        reader = new RunConfigurationReader(properties.getHashStructure(DATA_KEY));
        return reader.isRemoteDebuggingProfiling();
    }

    private boolean isRemoteDebuggingProfiling() {
        Object object;
        if (this._hash.containsKey(REMOTE_DEBUGGING_PROFILING) && (object = this._hash.getObject(REMOTE_DEBUGGING_PROFILING)) instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    private String getActiveName() {
        if (this._hash.containsKey(RUN_CONFIGURATION_ACTIVE_NAME)) {
            return this._hash.getObject(RUN_CONFIGURATION_ACTIVE_NAME).toString();
        }
        return null;
    }

    private ListStructure getRunConfigurationList() {
        Object object;
        if (this._hash.containsKey(RUN_CONFIGURATION_LIST) && (object = this._hash.getObject(RUN_CONFIGURATION_LIST)) instanceof ListStructure) {
            return (ListStructure)object;
        }
        return null;
    }

    private HashStructure getRunConfigurationDefinitions() {
        Object object;
        if (this._hash.containsKey(RUN_CONFIGURATION_DEFINITIONS) && (object = this._hash.getObject(RUN_CONFIGURATION_DEFINITIONS)) instanceof HashStructure) {
            return (HashStructure)object;
        }
        return null;
    }
}

