/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import oracle.ide.net.FileNativeHelper;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFilenameFilter;
import oracle.ide.net.URLFilter;
import oracle.ide.nulls.NullPrintStream;
import oracle.javatools.buffer.MultiLock;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.javatools.net.EncoderUtils;
import oracle.javatools.util.ModelUtil;

final class FileURLFileSystemHelper
extends URLFileSystemHelper {
    static final String ICON_KEY_HARD_DRIVE = "FileView.hardDriveIcon";
    @CodeSharingSafe(value="StaticField")
    private static FileSystemView _fileSystemView;
    @CodeSharingSafe(value="StaticField")
    private static PrintStream _nullErrorStream;
    @CodeSharingSafe(value="StaticField")
    private static final boolean WINDOWS_OS;
    @CodeSharingSafe(value="StaticField")
    private static final boolean SYSTEM_DISPLAY_NAME_IS_BROKEN;
    private static final String RESERVED_FILENAMES_PROPERTY = "reserved_filenames";
    @CodeSharingSafe(value="StaticField")
    private static final String[] RESERVED_FILENAMES;

    FileURLFileSystemHelper() {
    }

    private static boolean initWindowOs() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Windows");
    }

    private static boolean initSystemDisplayNameBroken() {
        String jdkVersion = System.getProperty("java.version");
        return WINDOWS_OS && jdkVersion.startsWith("1.4.2") && jdkVersion.compareTo("1.4.2_06") >= 0;
    }

    @Override
    public URL canonicalize(URL url) {
        File resolved;
        if (URLFileSystem.isLocalFileSystemCaseSensitive()) {
            ArrayList pathElems = new ArrayList();
            StringBuffer newPath = new StringBuffer();
            String path = FileURLFileSystemHelper.url2Path(url);
            if (path.startsWith("/")) {
                newPath.append('/');
            }
            String resolvedPath = URLFactory.resolveRelative(pathElems, path, newPath);
            resolved = new File(resolvedPath);
        } else {
            File file = FileURLFileSystemHelper.url2File(url);
            try {
                resolved = file.getCanonicalFile();
            }
            catch (Exception e) {
                resolved = file.getAbsoluteFile();
            }
        }
        return this.isDirectoryPath(url) ? URLFactory.newDirURL(resolved) : URLFactory.newFileURL(resolved);
    }

    @Override
    public boolean canRead(URL url) {
        File file = FileURLFileSystemHelper.url2File(url);
        return file.canRead();
    }

    @Override
    public boolean canWrite(URL url) {
        File file = FileURLFileSystemHelper.url2File(url);
        return this.canWriteFileImpl(file);
    }

    @Override
    public boolean canCreate(URL url) {
        File file = FileURLFileSystemHelper.url2File(url);
        if (file.exists()) {
            return !this.isReservedFilename(url) && this.canWriteFileImpl(file);
        }
        File myParent = file.getParentFile();
        if (myParent == null) {
            return false;
        }
        ArrayList<File> deleteList = new ArrayList<File>();
        boolean isDir = file.isDirectory();
        boolean result = true;
        boolean myParentExists = false;
        if (myParent.exists()) {
            myParentExists = true;
            try {
                if (isDir) {
                    result = file.mkdir();
                } else if (this.canWriteFileImpl(myParent)) {
                    result = file.createNewFile();
                    deleteList.add(file);
                } else {
                    result = false;
                }
            }
            catch (IOException ex) {
                result = false;
            }
        }
        if (!result) {
            return result;
        }
        for (File parent = myParent; parent != null && !parent.exists(); parent = parent.getParentFile()) {
            deleteList.add(parent);
        }
        if (deleteList.size() > 0) {
            try {
                if (!myParentExists && (result = myParent.mkdirs())) {
                    result = isDir ? file.mkdir() : file.createNewFile();
                    deleteList.add(0, file);
                }
            }
            catch (Exception e) {
                result = false;
            }
            for (File item : deleteList) {
                if (!item.exists()) continue;
                item.delete();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(URL url) throws IOException {
        File file = FileURLFileSystemHelper.url2File(url);
        ReadWriteLock lock = FileURLFileSystemHelper.lockIfArchive(url, file);
        try {
            boolean success = file.delete();
            if (!success) {
                throw new IOException("Unable to delete " + file.getAbsolutePath());
            }
        }
        finally {
            FileURLFileSystemHelper.unlock(lock);
        }
    }

    @Override
    public boolean equals(URL url1, URL url2) {
        return ModelUtil.areEqual(FileURLFileSystemHelper.url2Path(url1), FileURLFileSystemHelper.url2Path(url2)) && ModelUtil.areEqual(url1.getUserInfo(), url2.getUserInfo()) && ModelUtil.areEqual(url1.getQuery(), url2.getQuery()) && ModelUtil.areEqual(url1.getRef(), url2.getRef());
    }

    @Override
    public int hashCode(URL url) {
        int code = 0;
        code = code * 37 + new File(url.getPath()).hashCode();
        code = code * 37 + this.code(url.getAuthority());
        code = code * 37 + this.code(url.getUserInfo());
        code = code * 37 + this.code(url.getQuery());
        code = code * 37 + this.code(url.getRef());
        return code;
    }

    @Override
    public boolean exists(URL url) {
        File file = FileURLFileSystemHelper.url2File(url);
        boolean ret = file.exists() && !this.isReservedFilename(url);
        return ret;
    }

    @Override
    public Icon getDefaultIcon(URL url) {
        if (URLFileSystem.isRoot(url)) {
            return UIManager.getIcon(ICON_KEY_HARD_DRIVE);
        }
        return super.getDefaultIcon(url);
    }

    @Override
    public long getLength(URL url) {
        File file = FileURLFileSystemHelper.url2File(url);
        FileNativeHelper fnh = FileNativeHelper.getInstance();
        if (fnh.isLoaded()) {
            return fnh.getLength(file);
        }
        return file.length();
    }

    @Override
    public URL getParent(URL url) {
        File file = FileURLFileSystemHelper.url2File(url);
        File parentFile = file.getParentFile();
        if (parentFile != null && !file.equals(parentFile)) {
            return URLFactory.newDirURL(parentFile);
        }
        return null;
    }

    @Override
    public String getPlatformPathName(URL url) {
        if (url == null) {
            return "";
        }
        File file = FileURLFileSystemHelper.url2File(url);
        String platformPath = file.getPath();
        return platformPath;
    }

    @Override
    public String getSystemDisplayName(URL url) {
        if (SYSTEM_DISPLAY_NAME_IS_BROKEN) {
            return super.getSystemDisplayName(url);
        }
        File file = FileURLFileSystemHelper.url2FsvFile(url);
        String name = FileURLFileSystemHelper.getFileSystemView().getSystemDisplayName(file);
        return ModelUtil.hasLength(name) ? name : file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Icon getSystemIcon(URL url) {
        Icon ret;
        File file = FileURLFileSystemHelper.url2FsvFile(url);
        PrintStream oldErr = System.err;
        try {
            System.setErr(FileURLFileSystemHelper.getNullErrorStream());
            ret = FileURLFileSystemHelper.getFileSystemView().getSystemIcon(file);
        }
        catch (Exception e) {
            ret = null;
        }
        finally {
            System.setErr(oldErr);
        }
        return ret != null ? ret : super.getSystemIcon(url);
    }

    @Override
    public boolean hasSuffix(URL url, String suffix) {
        if (URLFileSystem.isLocalFileSystemCaseSensitive()) {
            return super.hasSuffix(url, suffix);
        }
        String pathLower = url.getPath().toLowerCase();
        return pathLower.endsWith(suffix.toLowerCase());
    }

    @Override
    public boolean isBaseURLFor(URL url1, URL url2) {
        if (!this.isDirectoryPath(url1)) {
            return false;
        }
        String url1Path = URLFactory.resolveRelative(new ArrayList(), FileURLFileSystemHelper.url2Path(url1), new StringBuffer());
        String url2Path = URLFactory.resolveRelative(new ArrayList(), FileURLFileSystemHelper.url2Path(url2), new StringBuffer());
        return url2Path.regionMatches(!URLFileSystem.isLocalFileSystemCaseSensitive(), 0, url1Path, 0, url1Path.length());
    }

    @Override
    public boolean isDirectory(URL url) {
        File file = FileURLFileSystemHelper.url2File(url);
        return file.isDirectory();
    }

    @Override
    public boolean isHidden(URL url) {
        File file = FileURLFileSystemHelper.url2File(url);
        return file.isHidden();
    }

    @Override
    public boolean isRegularFile(URL url) {
        File file = FileURLFileSystemHelper.url2File(url);
        return file.isFile();
    }

    @Override
    public boolean isLocal(URL url) {
        return true;
    }

    @Override
    public long lastModified(URL url) {
        File file = FileURLFileSystemHelper.url2File(url);
        FileNativeHelper fnh = FileNativeHelper.getInstance();
        if (fnh.isLoaded()) {
            return fnh.lastModified(file);
        }
        long lastModified = file.lastModified();
        return lastModified != 0L ? lastModified : -1L;
    }

    @Override
    public boolean isReadOnly(URL url) {
        for (File file = FileURLFileSystemHelper.url2File(url); file != null; file = file.getParentFile()) {
            if (!file.exists()) continue;
            return !this.canWriteFileImpl(file);
        }
        return false;
    }

    @Override
    public URL[] list(URL url, URLFilenameFilter filter) {
        if (filter == null) {
            return this.list(url);
        }
        File file = FileURLFileSystemHelper.url2File(url);
        String[] names = file.list();
        if (names == null) {
            return null;
        }
        ArrayList<URL> results = new ArrayList<URL>(names.length);
        for (String filename : names) {
            if (!filter.accept(url, filename)) continue;
            File child = new File(file, filename);
            results.add(URLFactory.newFileURL(child));
        }
        return results.toArray(new URL[results.size()]);
    }

    @Override
    public URL[] list(URL url) {
        File file = FileURLFileSystemHelper.url2File(url);
        FileNativeHelper fnh = FileNativeHelper.getInstance();
        if (fnh.isLoaded()) {
            URLFileSystem.FileInfo[] list = fnh.ls(file);
            if (list == null) {
                return null;
            }
            URL[] urlList = new URL[list.length];
            for (int i = list.length - 1; i >= 0; --i) {
                urlList[i] = list[i].getURL();
            }
            return urlList;
        }
        File[] list = file.listFiles();
        if (list == null) {
            return null;
        }
        URL[] urlList = new URL[list.length];
        for (int i = list.length - 1; i >= 0; --i) {
            urlList[i] = URLFactory.newFileURL(list[i]);
        }
        return urlList;
    }

    @Override
    public URLFileSystem.FileInfo[] ls(URL url) {
        File file = FileURLFileSystemHelper.url2File(url);
        FileNativeHelper fnh = FileNativeHelper.getInstance();
        if (fnh.isLoaded()) {
            return fnh.ls(file);
        }
        File[] list = file.listFiles();
        if (list == null) {
            return null;
        }
        int fileCount = list.length;
        URLFileSystem.FileInfo[] infos = new URLFileSystem.FileInfo[fileCount];
        for (int i = 0; i < fileCount; ++i) {
            infos[i] = FileURLFileSystemHelper.createFileInfo(list[i]);
        }
        return infos;
    }

    @Override
    public URLFileSystem.FileInfo[] ls(URL url, URLFilter filter) {
        URLFileSystem.FileInfo[] list = this.ls(url);
        if (list == null || filter == null) {
            return list;
        }
        ArrayList<URLFileSystem.FileInfo> filteredList = new ArrayList<URLFileSystem.FileInfo>();
        for (int i = list.length - 1; i >= 0; --i) {
            URLFileSystem.FileInfo info = list[i];
            URL fileURL = info.getURL();
            if (!filter.accept(fileURL)) continue;
            filteredList.add(info);
        }
        return filteredList.toArray(new URLFileSystem.FileInfo[filteredList.size()]);
    }

    protected static URLFileSystem.FileInfo createFileInfo(File file) {
        if (file != null) {
            int attributes;
            long lastModified = file.lastModified();
            lastModified = lastModified != 0L ? lastModified : -1L;
            long fileLength = file.length();
            int n = attributes = file.isDirectory() ? 1 : 2;
            if (file.isHidden()) {
                attributes |= 4;
            }
            URL fileURL = URLFactory.newFileURL(file);
            return new URLFileSystem.FileInfo(fileURL, attributes, lastModified, fileLength);
        }
        return null;
    }

    @Override
    public boolean mkdir(URL url) {
        File file = FileURLFileSystemHelper.url2File(url);
        if (!file.exists()) {
            return file.mkdir();
        }
        return false;
    }

    @Override
    public boolean mkdirs(URL url) {
        File file;
        if (!this.isDirectoryPath(url)) {
            new Exception("Assertion failure -- the URL passed to mkdirs was not a directory URL: " + url).printStackTrace();
        }
        if (!(file = FileURLFileSystemHelper.url2File(url)).exists()) {
            return file.mkdirs();
        }
        return true;
    }

    @Override
    public URL createTempFile(String prefix, String suffix, URL directory) throws IOException {
        return directory != null ? URLFactory.newFileURL(File.createTempFile(prefix, suffix, new File(directory.getPath()))) : URLFactory.newFileURL(File.createTempFile(prefix, suffix));
    }

    @Override
    public InputStream openInputStream(URL url) throws IOException {
        File file = FileURLFileSystemHelper.url2File(url);
        return new FileInputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream openOutputStream(URL url) throws IOException {
        File file = FileURLFileSystemHelper.url2File(url);
        OutputStream out = null;
        ReadWriteLock lock = FileURLFileSystemHelper.lockIfArchive(url, file);
        try {
            out = new FileOutputStream(file);
            if (lock != null) {
                out = new LockOutputStream(out, lock);
            }
        }
        catch (FileNotFoundException e) {
            File dir = file.getParentFile();
            dir.mkdirs();
            out = new FileOutputStream(file);
            if (lock != null) {
                out = new LockOutputStream(out, lock);
            }
        }
        finally {
            if (lock != null && out == null) {
                lock.writeUnlock();
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(URL oldURL, URL newURL) throws IOException {
        File oldFile = FileURLFileSystemHelper.url2File(oldURL);
        File newFile = FileURLFileSystemHelper.url2File(newURL);
        File newDir = newFile.getParentFile();
        newDir.mkdirs();
        MultiLock lock = null;
        if (JarUtil.isArchive(oldFile.getPath())) {
            lock = MultiLock.getWriteLock(JarUtil.getLock(oldURL), JarUtil.getLock(newURL));
            lock.lock();
        }
        try {
            if (!oldFile.renameTo(newFile)) {
                throw new IOException("File.renameTo failed for " + oldFile.getAbsolutePath());
            }
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    @Override
    public boolean setLastModified(URL url, long time) {
        File file = FileURLFileSystemHelper.url2File(url);
        return file.setLastModified(time);
    }

    @Override
    public boolean setReadOnly(URL url, boolean readOnly) {
        File file = FileURLFileSystemHelper.url2File(url);
        return readOnly ? file.setReadOnly() : file.setWritable(true);
    }

    @Override
    public String toRelativeSpec(URL url, URL base, boolean mustConsumeBase) {
        String result = super.toRelativeSpec(url, base, mustConsumeBase);
        if (result == null) {
            return null;
        }
        boolean isUNC = result.startsWith("//");
        return isUNC ? url.toString() : result;
    }

    @Override
    public URL getBaseParent(URL url, String relativeSpec) {
        if (relativeSpec != null) {
            relativeSpec = relativeSpec.replace(File.separatorChar, '/');
            return super.getBaseParent(url, relativeSpec);
        }
        return null;
    }

    @Override
    public String getPath(URL url) {
        return FileURLFileSystemHelper.url2Path(url);
    }

    @Override
    protected boolean haveSameAuthority(URL url, URL base) {
        return true;
    }

    @Override
    protected boolean haveSamePath(URL url, URL base) {
        if (url == base) {
            return true;
        }
        if (url == null || base == null) {
            return false;
        }
        return this.areEqual(FileURLFileSystemHelper.url2Path(url), FileURLFileSystemHelper.url2Path(base));
    }

    @Override
    protected boolean areEqualPathElems(String urlElem, String baseElem) {
        File urlFile = new File(urlElem);
        File baseFile = new File(baseElem);
        return urlFile.equals(baseFile);
    }

    private boolean canWriteFileImpl(File file) {
        boolean canWrite;
        FileNativeHelper fnh = FileNativeHelper.getInstance();
        if (fnh.isLoaded()) {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkWrite(file.getPath());
            }
            canWrite = fnh.canWrite(file);
        } else {
            canWrite = file.canWrite();
        }
        return canWrite || WINDOWS_OS && file.isDirectory();
    }

    private static final String url2Path(URL url) {
        String path = url.getPath();
        try {
            path = EncoderUtils.decodeString(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String authority = url.getAuthority();
        if (authority != null && !authority.isEmpty()) {
            return "//" + authority + path;
        }
        return path;
    }

    static final File url2File(URL url) {
        return new File(FileURLFileSystemHelper.url2Path(url));
    }

    private static final File url2FsvFile(URL url) {
        String path = url.getPath();
        try {
            path = EncoderUtils.decodeString(path);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        return FileURLFileSystemHelper.getFileSystemView().createFileObject(path);
    }

    private static final FileSystemView getFileSystemView() {
        if (_fileSystemView == null) {
            _fileSystemView = FileSystemView.getFileSystemView();
        }
        return _fileSystemView;
    }

    private static final PrintStream getNullErrorStream() {
        if (_nullErrorStream == null) {
            _nullErrorStream = new NullPrintStream(System.err);
        }
        return _nullErrorStream;
    }

    private final boolean isReservedFilename(URL url) {
        if (RESERVED_FILENAMES.length > 0) {
            String fName = this.getFileName(url);
            int idx = fName.indexOf(46);
            if (idx != -1) {
                fName = fName.substring(0, idx);
            }
            if (!URLFileSystem.isLocalFileSystemCaseSensitive()) {
                fName = fName.toLowerCase();
            }
            for (int i = 0; i < RESERVED_FILENAMES.length; ++i) {
                if (!RESERVED_FILENAMES[i].equals(fName)) continue;
                return true;
            }
        }
        return false;
    }

    private static String[] initReservedFileNames() {
        String val = System.getProperty(RESERVED_FILENAMES_PROPERTY);
        if (val != null && val.length() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer t = new StringTokenizer(val, ",");
            while (t.hasMoreTokens()) {
                list.add(t.nextToken());
            }
            return list.toArray(new String[list.size()]);
        }
        return new String[0];
    }

    private static final ReadWriteLock lockIfArchive(URL url, File file) {
        ReadWriteLock lock = FileURLFileSystemHelper.getLockIfArchive(url, file);
        if (lock != null) {
            lock.writeLock();
        }
        return lock;
    }

    private static ReadWriteLock getLockIfArchive(URL url, File file) {
        return JarUtil.isArchive(file.getPath()) ? JarUtil.getLock(url) : null;
    }

    private static final void unlock(ReadWriteLock lock) {
        if (lock != null) {
            lock.writeUnlock();
        }
    }

    static {
        WINDOWS_OS = FileURLFileSystemHelper.initWindowOs();
        SYSTEM_DISPLAY_NAME_IS_BROKEN = FileURLFileSystemHelper.initSystemDisplayNameBroken();
        RESERVED_FILENAMES = FileURLFileSystemHelper.initReservedFileNames();
    }

    private final class LockOutputStream
    extends FilterOutputStream {
        private final ReadWriteLock lock;
        private volatile boolean closed;

        public LockOutputStream(OutputStream wrapped, ReadWriteLock lock) {
            super(wrapped);
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                LockOutputStream lockOutputStream = this;
                synchronized (lockOutputStream) {
                    if (!this.closed) {
                        FileURLFileSystemHelper.unlock(this.lock);
                        this.closed = true;
                    }
                }
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        protected void finalize() throws IOException {
            if (!this.closed) {
                this.close();
            }
        }
    }

    public static class SimpleFileInfo
    extends URLFileSystem.FileInfo {
        boolean _init = false;

        protected SimpleFileInfo(URL url, int attr) throws MalformedURLException {
            super(url, attr, -1L, -1L);
        }

        static SimpleFileInfo newFileInfo(String path, String name, boolean isdir) throws MalformedURLException {
            if (isdir) {
                return new SimpleFileInfo(URLFactory.newDirURL(path + name), 1);
            }
            return new SimpleFileInfo(URLFactory.newFileURL(path + name), 2);
        }

        @Override
        public boolean isHidden() {
            if (!this._init) {
                this.attributes |= URLFileSystem.isHidden(this.url) ? 4 : 0;
            }
            return (this.attributes & 4) != 0;
        }

        @Override
        public long lastModified() {
            if (this.lastModified == -1L) {
                this.lastModified = URLFileSystem.lastModified(this.url);
            }
            return this.lastModified;
        }

        @Override
        public long length() {
            if (this.length == -1L) {
                this.length = URLFileSystem.getLength(this.url);
            }
            return this.length;
        }
    }
}

