/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.GuardedException;
import oracle.javatools.buffer.GuardedTextBufferListener;
import oracle.javatools.buffer.OffsetRegion;
import oracle.javatools.buffer.OffsetRegionChain;
import oracle.javatools.buffer.ReadOnlyException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferDecorator;

public class GuardedTextBuffer
extends TextBufferDecorator {
    private boolean isActive = true;
    private OffsetRegionChain model = new OffsetRegionChain();
    private CopyOnWriteArrayList<GuardedTextBufferListener> listeners = new CopyOnWriteArrayList();

    public GuardedTextBuffer(TextBuffer textBuffer) {
        super(textBuffer);
    }

    public GuardedTextBuffer(TextBuffer textBuffer, boolean forwardListeners) {
        super(textBuffer, forwardListeners);
    }

    public void guard(int offset, int length) {
        this.model.addRegion(this, offset, offset + length - 1);
        for (GuardedTextBufferListener l : this.listeners) {
            l.guarded(offset, length);
        }
    }

    public void unguard(int offset, int length) {
        this.model.removeRegion(this, offset, offset + length - 1);
        for (GuardedTextBufferListener l : this.listeners) {
            l.unguarded(offset, length);
        }
    }

    public boolean isOffsetGuarded(int offset) {
        return this.isOffsetRangeGuarded(offset, 1);
    }

    public boolean isOffsetRangeGuarded(int offset, int count) {
        return this.isRangeGuarded(offset, count) != -1;
    }

    public int findInsertableOffset(int offset, int count, boolean admitInsertToGuardedBeginning) {
        int endOffset = offset + count - 1;
        for (OffsetRegion region : this.model.getRegions()) {
            if (region.getStartOffset() + (admitInsertToGuardedBeginning ? 1 : 0) > offset) {
                return offset;
            }
            offset = Math.max(offset, region.getEndOffset() + 1);
            if (region.getEndOffset() < endOffset) continue;
            return -1;
        }
        return offset;
    }

    public List<OffsetRegion> getRegions() {
        return Collections.unmodifiableList(this.model.getRegions());
    }

    public void setGuardActive(boolean isGuardActive) {
        this.isActive = isGuardActive;
    }

    public boolean isGuardActive() {
        return this.isActive;
    }

    private boolean isLineStart(int offset) {
        int line = this.getLineMap().getLineFromOffset(offset);
        int lineStart = this.getLineMap().getLineStartOffset(line);
        return offset == lineStart;
    }

    @Override
    public UndoableEdit insert(int offset, char[] data) throws IndexOutOfBoundsException, ReadOnlyException {
        if (this.isActive) {
            boolean nonEnter;
            boolean bl = nonEnter = data.length != 1 || data[0] != '\n';
            if (this.model.contains(offset) && (!this.model.isOffsetAtRegionStart(offset) || nonEnter && this.isLineStart(offset))) {
                this.throwGuarded(offset);
            }
        }
        return super.insert(offset, data);
    }

    @Override
    public UndoableEdit insert(int offset, Reader reader) throws IndexOutOfBoundsException, IOException, ReadOnlyException {
        if (this.isActive && this.model.contains(offset)) {
            this.throwGuarded(offset);
        }
        return super.insert(offset, reader);
    }

    @Override
    public UndoableEdit remove(int offset, int count) throws IndexOutOfBoundsException, ReadOnlyException {
        if (this.isActive) {
            int guardedIndex = this.isRangeGuarded(offset, count);
            if (guardedIndex > -1) {
                this.throwGuarded(guardedIndex);
            }
            if (this.model.isOffsetAtRegionStart(offset + count) && this.isLineStart(offset + count) && !this.isLineStart(offset)) {
                this.throwGuarded(offset + count);
            }
        }
        return super.remove(offset, count);
    }

    @Override
    public UndoableEdit removeToEnd(int offset) throws IndexOutOfBoundsException, ReadOnlyException {
        int guardedIndex;
        if (this.isActive && (guardedIndex = this.isRangeGuarded(offset, this.getLength() - offset)) > -1) {
            this.throwGuarded(guardedIndex);
        }
        return super.removeToEnd(offset);
    }

    private int isRangeGuarded(int offset, int count) {
        int endOffset = offset + count - 1;
        for (OffsetRegion region : this.model.getRegions()) {
            if (region.getStartOffset() <= offset && region.getEndOffset() >= endOffset) {
                return offset;
            }
            if (offset < region.getStartOffset() && endOffset >= region.getStartOffset()) {
                return region.getStartOffset();
            }
            if (offset > region.getEndOffset() || endOffset <= region.getEndOffset()) continue;
            return region.getEndOffset();
        }
        return -1;
    }

    private void throwGuarded(int offset) {
        throw new GuardedException("Attempt to modify a guarded section of a GuardedTextBuffer. Offset: " + offset, offset);
    }

    @Override
    public void read(Reader reader) throws IOException {
        this.model.removeRegion(this, 0, this.getLength());
        super.read(reader);
    }

    public void addGuardedTextBufferListener(GuardedTextBufferListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeGuardedTextBufferListener(GuardedTextBufferListener listener) {
        this.listeners.remove(listener);
    }
}

