/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.ForwardingTextBufferListener;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadOnlyException;
import oracle.javatools.buffer.ReadTextBufferDecorator;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.util.NullArgumentException;

public abstract class TextBufferDecorator
extends ReadTextBufferDecorator
implements TextBuffer {
    protected TextBuffer _tbuffer;
    protected ForwardingTextBufferListener _forwarder = new ForwardingTextBufferListener(this);

    public TextBufferDecorator(TextBuffer buffer) {
        this(buffer, false);
    }

    public TextBufferDecorator(TextBuffer buffer, boolean forwardListeners) {
        super(buffer);
        this._tbuffer = buffer;
        if (buffer != null && forwardListeners) {
            buffer.addTextBufferListener(this._forwarder);
        }
    }

    @Override
    public void beginEdit() throws ReadOnlyException {
        this._tbuffer.beginEdit();
    }

    @Override
    public UndoableEdit endEdit() {
        return this._tbuffer.endEdit();
    }

    @Override
    public UndoableEdit insert(int offset, char[] data) throws IndexOutOfBoundsException, ReadOnlyException {
        return this._tbuffer.insert(offset, data);
    }

    @Override
    public UndoableEdit append(char[] data) throws IndexOutOfBoundsException, ReadOnlyException {
        return this._tbuffer.append(data);
    }

    @Override
    public UndoableEdit remove(int offset, int count) throws IndexOutOfBoundsException, ReadOnlyException {
        return this._tbuffer.remove(offset, count);
    }

    @Override
    public UndoableEdit removeToEnd(int offset) throws IndexOutOfBoundsException, ReadOnlyException {
        return this._tbuffer.removeToEnd(offset);
    }

    @Override
    public LineMap getLineMap() {
        return this._tbuffer.getLineMap();
    }

    @Override
    public void addTextBufferListener(TextBufferListener listener) {
        this._forwarder.addTextBufferListener(listener);
    }

    @Override
    public void removeTextBufferListener(TextBufferListener listener) {
        this._forwarder.removeTextBufferListener(listener);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this._tbuffer.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() {
        return this._tbuffer.isReadOnly();
    }

    @Override
    public void writeLock() throws ReadOnlyException {
        this._tbuffer.writeLock();
    }

    @Override
    public void writeLockInterruptibly() throws InterruptedException, ReadOnlyException {
        this._tbuffer.writeLockInterruptibly();
    }

    @Override
    public void writeLock(boolean checkIfReadOnly) throws ReadOnlyException {
        this._tbuffer.writeLock(checkIfReadOnly);
    }

    @Override
    public boolean tryWriteLock() throws ReadOnlyException {
        return this._tbuffer.tryWriteLock();
    }

    @Override
    public void writeUnlock() {
        this._tbuffer.writeUnlock();
    }

    @Override
    public boolean addWriteLockRequestListener(WriteLockRequestListener listener) {
        if (listener == null) {
            throw new NullArgumentException("null listener");
        }
        return this._tbuffer.addWriteLockRequestListener(listener);
    }

    @Override
    public void removeWriteLockRequestListener(WriteLockRequestListener listener) {
        if (listener == null) {
            throw new NullArgumentException("null listener");
        }
        this._tbuffer.removeWriteLockRequestListener(listener);
    }

    @Override
    public OffsetMark addOffsetMark(int offset) {
        return this._tbuffer.addOffsetMark(offset);
    }

    @Override
    public OffsetMark addOffsetMark(int offset, boolean bias) {
        return this._tbuffer.addOffsetMark(offset, bias);
    }

    @Override
    public void removeOffsetMark(OffsetMark offsetMark) {
        this._tbuffer.removeOffsetMark(offsetMark);
    }

    @Override
    public boolean isModified() {
        return this._tbuffer.isModified();
    }

    @Override
    public void clearModified() {
        this._tbuffer.clearModified();
    }

    @Override
    public int getChangeId() {
        return this._tbuffer.getChangeId();
    }

    @Override
    public void read(Reader reader) throws IOException {
        this._tbuffer.read(reader);
    }

    @Override
    public UndoableEdit insert(int offset, Reader reader) throws IndexOutOfBoundsException, IOException, ReadOnlyException {
        return this._tbuffer.insert(offset, reader);
    }

    @Override
    public void write(Writer writer) throws IOException {
        this._tbuffer.write(writer);
    }

    @Override
    public void write(Writer writer, boolean clearModified) throws IOException {
        this._tbuffer.write(writer, clearModified);
    }

    @Override
    public String getPlatformEOLType() {
        return this._tbuffer.getPlatformEOLType();
    }

    @Override
    public String getEOLType() {
        return this._tbuffer.getEOLType();
    }

    @Override
    public void setEOLType(String eolType) throws ReadOnlyException {
        this._tbuffer.setEOLType(eolType);
    }

    protected void setTextBuffer(TextBuffer textBuffer) {
        this._tbuffer = textBuffer;
    }

    protected TextBuffer getTextBuffer() {
        return this._tbuffer;
    }
}

