/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.compare.CompareAlgorithm;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareMergeAlgorithm;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.algorithm.BaseCompareModel;
import oracle.javatools.compare.algorithm.directory.DirectoryCompareAlgorithm;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareAlgorithm;
import oracle.javatools.compare.algorithm.text.TextCompareAlgorithm;
import oracle.javatools.util.deferred.Thunk;

public final class CompareModelFactory {
    private static final Map<CompareType, Thunk<Class<? extends CompareAlgorithm>>> _algorithms = CompareModelFactory.initAlgorithms();

    private CompareModelFactory() {
    }

    private static Map<CompareType, Thunk<Class<? extends CompareAlgorithm>>> initAlgorithms() {
        HashMap<CompareType, Thunk<Class<? extends CompareAlgorithm>>> map = new HashMap<CompareType, Thunk<Class<? extends CompareAlgorithm>>>();
        map.put(CompareType.TEXT, Thunk.directReference(TextCompareAlgorithm.class));
        map.put(CompareType.CHARACTER, Thunk.directReference(SequenceCompareAlgorithm.class));
        map.put(CompareType.DIRECTORY, Thunk.directReference(DirectoryCompareAlgorithm.class));
        return map;
    }

    public static final void registerCompareAlgorithm(CompareType type, Class<? extends CompareAlgorithm> algorithmClass) {
        CompareModelFactory.registerCompareAlgorithm(type, Thunk.directReference(algorithmClass));
    }

    public static final void registerCompareAlgorithm(CompareType type, Thunk<Class<? extends CompareAlgorithm>> algorithmClass) {
        _algorithms.put(type, algorithmClass);
    }

    public static CompareModel createCompareModel(CompareContributor first, CompareContributor second) throws CompareFailedException {
        return CompareModelFactory.createCompareModel(first, second, CompareType.TEXT);
    }

    public static CompareModel createMergeModel(CompareContributor first, CompareContributor second, CompareContributor ancestor) throws CompareFailedException {
        return CompareModelFactory.createMergeModel(first, second, ancestor, CompareType.TEXT);
    }

    public static CompareModel createCompareModel(CompareContributor first, CompareContributor second, CompareType type) throws CompareFailedException {
        return CompareModelFactory.createCompareModel(first, second, type, CompareModelFactory.createCompareAlgorithm(type));
    }

    public static CompareModel createCompareModel(CompareContributor first, CompareContributor second, CompareType type, CompareAlgorithm compareAlgorithm) throws CompareFailedException {
        if (compareAlgorithm != null) {
            CompareModel compareModel = compareAlgorithm.compare(first, second);
            if (compareModel != null) {
                compareModel.setType(type);
            }
            if (compareModel instanceof BaseCompareModel) {
                ((BaseCompareModel)compareModel).extend();
            }
            return compareModel;
        }
        throw new IllegalArgumentException("cannot create compare model with " + first + " and " + second);
    }

    public static CompareModel createMergeModel(CompareContributor first, CompareContributor second, CompareContributor ancestor, CompareType type) throws CompareFailedException {
        CompareAlgorithm compareAlgorithm = CompareModelFactory.createCompareAlgorithm(type);
        if (compareAlgorithm instanceof CompareMergeAlgorithm) {
            CompareModel compareModel = ((CompareMergeAlgorithm)compareAlgorithm).merge(first, second, ancestor);
            if (compareModel != null) {
                compareModel.setType(type);
            }
            return compareModel;
        }
        throw new IllegalArgumentException("cannot create merge model with " + first + " and " + second);
    }

    public static final CompareAlgorithm createCompareAlgorithm(CompareType type) {
        CompareAlgorithm compareAlgorithm = null;
        Thunk<Class<? extends CompareAlgorithm>> algorithmClass = _algorithms.get(type);
        try {
            if (algorithmClass != null) {
                compareAlgorithm = algorithmClass.get().newInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return compareAlgorithm;
    }
}

