/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.generic;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.generic.Language;

public final class BraceHelper {
    private static final int CLOSE_ADJUSTMENT = 10000;
    public static final int INVALID_BRACE = -1;
    private String[] openBraceArray;
    private String[] closeBraceArray;

    public BraceHelper(Language language) {
        this(language.getBraces());
    }

    public BraceHelper(String[][] languageBraces) {
        int size = languageBraces != null ? languageBraces.length : 0;
        this.openBraceArray = new String[size];
        this.closeBraceArray = new String[size];
        for (int i = 0; i < size; ++i) {
            String[] braces = languageBraces[i];
            boolean hasOpen = braces != null && braces.length > 0;
            boolean hasClose = braces != null && braces.length > 1;
            this.openBraceArray[i] = hasOpen ? braces[0] : "";
            this.closeBraceArray[i] = hasClose ? braces[1] : "";
        }
    }

    private int findBrace(String[] braceArray, ReadTextBuffer buffer, int startOffset, int endOffset) {
        int size = braceArray.length;
        for (int i = 0; i < size; ++i) {
            if (!this.matchPattern(braceArray[i], buffer, startOffset, endOffset)) continue;
            return i;
        }
        return -1;
    }

    private boolean matchPattern(String pattern, ReadTextBuffer buffer, int startOffset, int endOffset) {
        if (pattern == null || pattern.length() == 0) {
            return false;
        }
        if (pattern.length() != endOffset - startOffset) {
            return false;
        }
        int patternLength = pattern.length();
        int patternOffset = 0;
        int offset = startOffset;
        while (patternOffset < patternLength) {
            char p_c;
            char tb_c;
            if ((tb_c = buffer.getChar(offset++)) == (p_c = pattern.charAt(patternOffset++))) continue;
            return false;
        }
        return true;
    }

    public boolean isOpenIndex(int index) {
        return index >= 0 && index < this.openBraceArray.length;
    }

    public boolean isCloseIndex(int index) {
        int realIndex = index - 10000;
        return this.isOpenIndex(realIndex);
    }

    public int getBraceLength(int index) {
        if (this.isOpenIndex(index)) {
            return this.openBraceArray[index].length();
        }
        if (this.isCloseIndex(index)) {
            return this.closeBraceArray[index - 10000].length();
        }
        return -1;
    }

    public int getBracePairsCount() {
        return this.openBraceArray.length;
    }

    public int getBraceIndex(ReadTextBuffer buffer, int startOffset, int endOffset) {
        int index = this.findBrace(this.openBraceArray, buffer, startOffset, endOffset);
        if (index == -1) {
            index = this.findBrace(this.closeBraceArray, buffer, startOffset, endOffset) + 10000;
        }
        return index;
    }

    public int getMatchingBraceIndex(int index) {
        if (this.isOpenIndex(index)) {
            return index + 10000;
        }
        if (this.isCloseIndex(index)) {
            return index - 10000;
        }
        return -1;
    }
}

