/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.VardeclSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.BlockStmt;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLambdaExpression;

public class VariableSym
extends ObjectSym
implements SourceVariable {
    public short varXDimension;
    public TypeSym varType;

    @Override
    public final SourceVariableDeclaration getOwningDeclaration() {
        return this.getOwningDeclarationSym();
    }

    public final VardeclSym getOwningDeclarationSym() {
        Sym parentSym = this.getParentSym();
        if (parentSym == null) {
            return null;
        }
        switch (parentSym.symKind) {
            case 9: 
            case 18: {
                return (VardeclSym)parentSym;
            }
        }
        return null;
    }

    public SourceBlock getOwningBlock() {
        Sym parentSym = this.getParentSym();
        switch (this.symKind) {
            case 17: {
                Sym sym = parentSym;
                while (sym != null) {
                    if (sym.symKind == 2) {
                        return (SourceBlock)((Object)sym);
                    }
                    sym = sym.symParent;
                }
                break;
            }
            case 13: {
                Sym sym = parentSym;
                while (sym != null) {
                    switch (sym.symKind) {
                        case 6: 
                        case 19: {
                            MethodSym methodSym = (MethodSym)sym;
                            return methodSym.getBlock();
                        }
                    }
                    sym = sym.symParent;
                }
                break;
            }
            case 28: {
                Sym sym = parentSym;
                while (sym != null) {
                    switch (sym.symKind) {
                        case 47: {
                            BlockStmt blockStmt = (BlockStmt)((TreeSym)sym).getChild((byte)45);
                            return blockStmt != null ? blockStmt.getBlock() : null;
                        }
                    }
                    sym = sym.symParent;
                }
                break;
            }
            case 31: {
                Sym sym = parentSym;
                while (sym != null) {
                    switch (sym.symKind) {
                        case 79: {
                            SourceElement body = ((SourceLambdaExpression)((Object)sym)).getBody();
                            return body.getSymbolKind() == 2 ? (SourceBlock)body : null;
                        }
                    }
                    sym = sym.symParent;
                }
                break;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    @Override
    public final TypeSym getTypeSym() {
        TypeSym typeSym = super.getTypeSym();
        if (typeSym != null) {
            return typeSym;
        }
        return this.varType;
    }

    @Override
    public void setTypeSym(TypeSym typeSym) {
        int found;
        if (typeSym == null) {
            throw new IllegalArgumentException();
        }
        if (typeSym.isSynthetic()) {
            typeSym = (TypeSym)typeSym.cloneSelf(this.symFile);
            typeSym.symAccess = (char)(typeSym.symAccess & 0xFFFFEFFF);
        }
        if ((found = this.indexOf((byte)27)) != -1) {
            this.replaceChild(found, typeSym);
            return;
        }
        VardeclSym owning = this.getOwningDeclarationSym();
        if (owning == null) {
            this.add(typeSym);
            return;
        }
        List<SourceVariable> vars = owning.getVariables();
        TypeSym owningType = owning.getTypeSym();
        if (vars.size() > 1) {
            String owningTypeName = owningType.getName();
            if (owningTypeName.equals(typeSym.getName())) {
                this.varType.typeXtraDimension = typeSym.typeXtraDimension;
                return;
            }
            this.separateSelf();
        }
        owning.setTypeSym(typeSym);
        if (this.varType == null) {
            this.buildSelf();
        }
        this.useType(typeSym);
    }

    @Override
    public SourceExpression getInitializer() {
        return this.getExpressionSym();
    }

    @Override
    public void setInitializer(SourceExpression e) {
        this.setExpressionSym((Expr)e);
    }

    @Override
    public Object getConstantValue() {
        if (!this.isFinal()) {
            return null;
        }
        Expr e = this.getExpressionSym();
        if (e == null) {
            return null;
        }
        if (e.getResolvedObject() == this) {
            return this;
        }
        return e.getConstantValue();
    }

    @Override
    protected void setModifiersImpl(char access) {
        VardeclSym owning;
        boolean setParentAccess;
        Sym parentSym = this.getParentSym();
        boolean bl = setParentAccess = parentSym != null && parentSym.symAccess != access;
        if (setParentAccess && (owning = this.getOwningDeclarationSym()) != null) {
            List<SourceVariable> vars = owning.getVariables();
            if (vars.size() > 1) {
                this.separateSelf();
            }
            owning.setModifiers(access);
            return;
        }
        this.setAccess(access);
    }

    @Override
    public void separateSelf() {
        this.separateSelfImpl();
    }

    public List<List<SourceAnnotation>> getExtraArrayDimensionsTypeAnnotations() {
        ArrayList listOfLists = null;
        List<SourceElement> children = this.getChildren(1);
        for (int i = 0; i < children.size(); ++i) {
            AnnotateSym annotateSym = (AnnotateSym)children.get(i);
            if (annotateSym.dimensionIndex <= 0) continue;
            if (listOfLists == null) {
                listOfLists = new ArrayList();
                for (int x = 0; x < this.varXDimension; ++x) {
                    listOfLists.add(new ArrayList());
                }
            }
            ((List)listOfLists.get(annotateSym.dimensionIndex - 1)).add(annotateSym);
        }
        return listOfLists;
    }

    @Override
    public String printCompiledInfo() {
        JavaType resolvedType = this.getResolvedType();
        if (resolvedType != null) {
            return "FieldSignature " + resolvedType.getTypeSignature();
        }
        return "FieldSignatrue <unknown>";
    }

    @Override
    protected void add(Sym child, byte filter) {
        VardeclSym vardecl;
        if (child != null && child.symKind == 1 && (vardecl = this.getOwningDeclarationSym()) != null) {
            vardecl.add(child, filter);
            return;
        }
        super.add(child, filter);
    }

    @Override
    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 27: {
                return 0;
            }
            case 20: {
                if (this.varType != null) {
                    return 0;
                }
                return 1;
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 20: 
            case 27: {
                return true;
            }
        }
        if (VariableSym.srcIsExpr(symKind)) {
            return true;
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected final void linkSelfTrigger(TreeSym parent, byte filter) {
        super.linkSelfTrigger(parent, filter);
    }

    @Override
    protected final void unlinkSelfTrigger(TreeSym parent, byte filter) {
        super.unlinkSelfTrigger(parent, filter);
    }

    @Override
    public void buildSelf() {
        VardeclSym owning = this.getOwningDeclarationSym();
        if (owning != null) {
            this.symAccess = (char)(this.symAccess | owning.symAccess);
            this.objectImplicit = owning.objectImplicit;
        }
        super.buildSelf();
        switch (this.symKind) {
            case 10: 
            case 17: {
                this.varType = (TypeSym)SymFactory.createNode(this.symFile, 27);
                SymFactory.setupSynthetic(this.varType, this, -1);
            }
        }
        if (this.varXDimension > 0) {
            TypeSym typeSym = this.getTypeSym();
            typeSym.typeXtraDimension = this.varXDimension;
            List<List<SourceAnnotation>> typeAnnotations = this.getExtraArrayDimensionsTypeAnnotations();
            if (typeAnnotations != null) {
                typeSym.setExtraArrayDimensionsTypeAnnotations(typeAnnotations);
            }
        }
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        VariableSym sym = (VariableSym)super.cloneSelf(targetFile);
        sym.varXDimension = this.varXDimension;
        if (this.varType != null) {
            sym.varType = (TypeSym)this.varType.cloneSelf(targetFile);
            sym.varType.symParent = this;
        }
        return sym;
    }

    @Override
    protected void adjustSelfImpl(Sym other) {
        super.adjustSelfImpl(other);
        if (this.varType != null && other instanceof VariableSym && ((VariableSym)other).varType != null) {
            this.varType.adjustSelfImpl(((VariableSym)other).varType);
        }
    }

    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        JavaElement result = super.compileImpl(compiler);
        if (!compiler.skipCompilations()) {
            compiler.compile(this);
        }
        return result;
    }

    @Override
    protected JavaElement resolveImpl(CompilerDriver compiler) {
        return compiler.resolve(this);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    private void print_initializer(PrintWriter out) {
        Sym initializer = this.getChild((byte)102);
        if (initializer != null) {
            out.print(" = ");
            initializer.print(out);
        }
    }

    @Override
    public void print(PrintWriter out, int argument) {
        switch (argument) {
            default: {
                this.print(out);
                break;
            }
            case 2: {
                VariableSym.print(this.getTypeSym(), out, argument);
                out.print(' ');
                VariableSym.print(this.getNameSym(), out);
                break;
            }
            case 1: {
                VariableSym.print(this.getNameSym(), out);
                for (int i = 0; i < this.varXDimension; ++i) {
                    out.print("[]");
                }
                this.print_initializer(out);
                break;
            }
            case 3: {
                VariableSym.print(this.getTypeSym(), out, argument);
            }
        }
    }

    protected void finishSynthetic(NameSym classNameSym) {
        if (this.varType == null) {
            VariableSym.panic();
        }
        SyntaxData data = new SyntaxData();
        data.addKid(classNameSym);
        this.varType.symData = data;
        this.varType.buildSelf();
    }

    protected void setupSynthetic(Sym offsetSym) {
        this.symAccess = (char)(this.symAccess | 0x1000);
        this.symStart = offsetSym.symStart;
        this.symEnd = offsetSym.symEnd;
        this.symFile = offsetSym.symFile;
        TypeSym typeSym = (TypeSym)SymFactory.createNode(this.symFile, 27);
        SymFactory.setupSynthetic(typeSym, this, offsetSym.symStart);
        this.varType = typeSym;
    }

    protected void useType(TypeSym base) {
        if (this.varType == null) {
            VariableSym.panic();
        }
        TypeSym typeSym = this.varType;
        typeSym.symStart = base.symStart;
        typeSym.symEnd = base.symEnd;
        typeSym.treeChildren = base.treeChildren;
        typeSym.typeBaseDimension = base.typeBaseDimension;
        typeSym.typeXtraDimension = this.varXDimension;
        typeSym.typeToken = base.typeToken;
    }

    private void separateSelfImpl() {
        int i;
        List<SourceVariable> cloneVariables;
        VardeclSym owningClone;
        List<SourceVariable> variables;
        int variableCount;
        TreeSym parent;
        VardeclSym oldOwning = this.getOwningDeclarationSym();
        if (oldOwning == null) {
            VariableSym.unsupported("No owning declaration");
        }
        if ((parent = (TreeSym)oldOwning.getParentSym()) == null) {
            VariableSym.errorNoParent();
        }
        if ((variableCount = (variables = oldOwning.getVariables()).size()) < 2) {
            return;
        }
        int variableIndex = variables.indexOf(this);
        if (variableIndex == -1) {
            VariableSym.panic();
        }
        if (variableIndex > 0) {
            owningClone = (VardeclSym)oldOwning.cloneSelf(this.symFile);
            owningClone.addSelfBefore(oldOwning);
            cloneVariables = owningClone.getVariables();
            for (i = variableCount - 1; i >= variableIndex; --i) {
                cloneVariables.remove(i);
            }
        }
        if (variableIndex != variableCount - 1) {
            owningClone = (VardeclSym)oldOwning.cloneSelf(this.symFile);
            owningClone.addSelfAfter(oldOwning);
            cloneVariables = owningClone.getVariables();
            for (i = variableIndex; i >= 0; --i) {
                cloneVariables.remove(i);
            }
        }
        for (int i2 = variableCount - 1; i2 >= 0; --i2) {
            if (i2 == variableIndex) continue;
            variables.remove(i2);
        }
    }
}

