/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.javatools.util.CollectionEvent;
import oracle.javatools.util.CollectionListener;
import oracle.javatools.util.ListenableCollection;

public class ListenableArrayList<E>
extends ArrayList<E>
implements ListenableCollection<E> {
    private final List<CollectionListener<E>> listeners = this.createListenerList();

    public ListenableArrayList(Collection<? extends E> collection) {
        super(collection);
    }

    public ListenableArrayList() {
    }

    public ListenableArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    protected List<CollectionListener<E>> createListenerList() {
        return new CopyOnWriteArrayList<CollectionListener<E>>();
    }

    @Override
    public void addListener(CollectionListener<E> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(CollectionListener<E> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean add(E e) {
        boolean ret = super.add(e);
        this.fireChange(CollectionEvent.Type.ADDITION, e, this.size() - 1);
        return ret;
    }

    @Override
    public void add(int index, E e) {
        super.add(index, e);
        this.fireChange(CollectionEvent.Type.ADDITION, e, index);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            this.add(e);
        }
        return !c.isEmpty();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        for (E e : c) {
            this.add(index, e);
            this.fireChange(CollectionEvent.Type.ADDITION, e, index);
            ++index;
        }
        return !c.isEmpty();
    }

    @Override
    public void clear() {
        Object[] objs = this.toArray();
        super.clear();
        int i = 0;
        for (Object obj : objs) {
            this.fireChange(CollectionEvent.Type.REMOVAL, obj, i++);
        }
    }

    @Override
    public E remove(int index) {
        Object e = super.remove(index);
        this.fireChange(CollectionEvent.Type.REMOVAL, e, index);
        return e;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        boolean ret = super.remove(o);
        if (ret) {
            this.fireChange(CollectionEvent.Type.REMOVAL, o, index);
        }
        return ret;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        Object[] objs = this.subList(fromIndex, toIndex).toArray();
        super.removeRange(fromIndex, toIndex);
        int index = fromIndex;
        for (Object obj : objs) {
            this.fireChange(CollectionEvent.Type.REMOVAL, obj, index++);
        }
    }

    protected void fireChange(CollectionEvent.Type type, E element, int index) {
        if (this.listeners != null) {
            CollectionEvent<E> event = new CollectionEvent<E>(this, type, element, index);
            for (CollectionListener<E> l : this.listeners) {
                l.collectionChanged(event);
            }
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return super.retainAll(c);
    }
}

