/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.Timer;
import java.util.TimerTask;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public class NamedTimer
extends Timer {
    @CodeSharingSafe(value="StaticField")
    private static NamedTimer _lowPriorityTimer;

    public NamedTimer(String name) {
        this(name, 5, false);
    }

    public NamedTimer(String name, int priority) {
        this(name, priority, false);
    }

    public NamedTimer(final String name, final int priority, boolean isDaemon) {
        super(isDaemon);
        if (priority != 5 && priority != 1 && priority != 10) {
            throw new IllegalArgumentException();
        }
        TimerTask initTask = new TimerTask(){

            @Override
            public void run() {
                Thread thread = Thread.currentThread();
                try {
                    thread.setName(name);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                try {
                    thread.setPriority(priority);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        };
        this.schedule(initTask, 0L);
    }

    public static NamedTimer getSharedLowPriorityTimer() {
        if (_lowPriorityTimer == null) {
            _lowPriorityTimer = new NonCancelableTimer();
        }
        return _lowPriorityTimer;
    }

    private static final class NonCancelableTimer
    extends NamedTimer {
        public NonCancelableTimer() {
            super("IdeMinPriorityTimer", 1, true);
        }

        @Override
        public void cancel() {
            new Exception("Cancel called on a shared Timer.").printStackTrace();
        }
    }
}

