/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbbridge;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.JAXBContext;
import oracle.ide.net.FileLocator;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegateHook;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;

public class IdeClassLoaderDelegateHook
implements ClassLoaderDelegateHook,
HookConfigurator {
    private static final String DUMP_CLASS = "oracle.dump.classloading.info.for.class";
    private static final String DUMP_BUNDLE = "oracle.dump.classloading.info.for.bundle";
    static Finder stackTraceCatcher;
    private AtomicInteger stackOverFlowProtectionCounter = new AtomicInteger(0);
    private static String jaxbContextFactory;
    private static List<String> RESOURCE_EXEMPT_PATHS;

    public Class<?> preFindClass(String string, BundleClassLoader bundleClassLoader, BundleData bundleData) throws ClassNotFoundException {
        String dumpBundle;
        String dumpClass = System.getProperty(DUMP_CLASS);
        if (dumpClass != null && dumpClass.equals(string) && ((dumpBundle = System.getProperty(DUMP_BUNDLE)) == null || bundleData.getSymbolicName().equals(dumpBundle))) {
            ArrayList classesOnStack = new ArrayList(Arrays.asList(stackTraceCatcher.getClassContext()));
            ArrayList<StackTraceElement> stackElements = new ArrayList<StackTraceElement>();
            for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                if (ste.isNativeMethod()) continue;
                stackElements.add(ste);
            }
            System.out.println("Dumping stacktrace classloading info for class " + dumpClass + ", when attempted " + "to load with classloader " + (dumpBundle != null ? dumpBundle : "'*'"));
            System.out.println("TCCL -> " + Thread.currentThread().getContextClassLoader());
            System.out.println("Start of stack trace ...");
            classesOnStack.remove(0);
            stackElements.remove(0);
            for (int i = 0; i < stackElements.size(); ++i) {
                StackTraceElement stElem = (StackTraceElement)stackElements.get(i);
                Class clazz = i < classesOnStack.size() ? (Class)classesOnStack.get(i) : null;
                System.out.println(stElem.toString() + "\n [ " + (clazz != null ? clazz.getClassLoader() : "NULL class") + " ]");
            }
            System.out.println("End of stack trace ...");
        }
        return null;
    }

    private static String getPackageFromFQN(String FQN) {
        int indexOfLastPackageDot = FQN.lastIndexOf(".");
        if (indexOfLastPackageDot != -1) {
            return FQN.substring(0, indexOfLastPackageDot);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Class<?> postFindClass(String name, BundleClassLoader bundleClassLoader, BundleData bundleData) throws ClassNotFoundException {
        if (name.equals(IdeClassLoaderDelegateHook.jaxbContextFactory)) {
            if (this.stackOverFlowProtectionCounter.getAndIncrement() == 0) {
                try {
                    br = bundleClassLoader.getBundle();
                    br.start();
                    bundleContext = br.getBundleContext();
                    ref = bundleContext.getServiceReference(PackageAdmin.class);
                    admin = (PackageAdmin)bundleClassLoader.getBundle().getBundleContext().getService(ref);
                    packageOfJAXBFactoryValue = IdeClassLoaderDelegateHook.getPackageFromFQN(IdeClassLoaderDelegateHook.jaxbContextFactory);
                    exportedPackage = admin.getExportedPackage(packageOfJAXBFactoryValue);
                    if (exportedPackage == null) ** GOTO lbl23
                    bundle = exportedPackage.getExportingBundle();
                    var11_16 = bundle.loadClass(name);
                    return var11_16;
                }
                catch (BundleException br) {
                }
                finally {
                    this.stackOverFlowProtectionCounter.getAndDecrement();
                }
            } else {
                this.stackOverFlowProtectionCounter.getAndDecrement();
            }
        }
lbl23:
        // 5 sources

        if (name.startsWith("oracle.xml.jaxp.")) {
            xmlparserBundleName = "oracle.external.xmlparser";
            br = bundleClassLoader.getBundle();
            bundleContext = br.getBundleContext();
            if (bundleContext == null) {
                try {
                    br.start();
                    bundleContext = br.getBundleContext();
                }
                catch (BundleException var7_9) {
                    // empty catch block
                }
            }
            if (bundleContext != null && !"oracle.external.xmlparser".equals(br.getSymbolicName())) {
                for (Bundle bundle : bundleContext.getBundles()) {
                    if (!bundle.getSymbolicName().equals("oracle.external.xmlparser")) continue;
                    return bundle.loadClass(name);
                }
            }
        }
        return null;
    }

    public URL preFindResource(String string, BundleClassLoader bundleClassLoader, BundleData bundleData) throws FileNotFoundException {
        if (string != null && string.endsWith("NativeLibLoader.class")) {
            try {
                URL untranslatedURL = bundleClassLoader.findLocalResource(string);
                return untranslatedURL != null ? FileLocator.resolve((URL)untranslatedURL) : untranslatedURL;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public URL postFindResource(String resPath, BundleClassLoader bundleClassLoader, BundleData bundleData) throws FileNotFoundException {
        IdeClassLoaderDelegateHook.checkIfResPathIsExempted(resPath);
        return null;
    }

    private static void checkIfResPathIsExempted(String resPath) throws FileNotFoundException {
        for (String resourceExemptPath : RESOURCE_EXEMPT_PATHS) {
            if (!resourceExemptPath.equals(resPath)) continue;
            throw new FileNotFoundException("not an error: this is used as flow control to skip buddy loading of resources");
        }
    }

    public Enumeration<URL> preFindResources(String string, BundleClassLoader bundleClassLoader, BundleData bundleData) throws FileNotFoundException {
        return null;
    }

    public Enumeration<URL> postFindResources(String resPath, BundleClassLoader bundleClassLoader, BundleData bundleData) throws FileNotFoundException {
        IdeClassLoaderDelegateHook.checkIfResPathIsExempted(resPath);
        return null;
    }

    public String preFindLibrary(String string, BundleClassLoader bundleClassLoader, BundleData bundleData) throws FileNotFoundException {
        return null;
    }

    public String postFindLibrary(String string, BundleClassLoader bundleClassLoader, BundleData bundleData) {
        return null;
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addClassLoaderDelegateHook((ClassLoaderDelegateHook)this);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                stackTraceCatcher = new Finder();
                return null;
            }
        });
        jaxbContextFactory = System.getProperty(JAXBContext.class.getName());
        RESOURCE_EXEMPT_PATHS = new ArrayList<String>();
        String buddyDelegationResourceExempts = System.getProperty("oracle.ide.osgi.buddy.delegate.resource.exempt.paths");
        if (buddyDelegationResourceExempts != null) {
            String[] exemptPaths;
            for (String exemptPath : exemptPaths = buddyDelegationResourceExempts.split(",")) {
                if (exemptPaths == null) continue;
                RESOURCE_EXEMPT_PATHS.add(exemptPath);
            }
        }
    }

    static final class Finder
    extends SecurityManager {
        Finder() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

