/* Copyright (c) 1986, 2015, Oracle and/or its affiliates. 
All rights reserved.*/

/*
NAME
  plsql.y : PLSQL parser
FUNCTION
  PLSQL language grammar for SLAX parser generator
NOTES
The 79 char ruler.
1234567890123456789012345678901234567890123456789012345678901234567890123456789
OWNER
  Jensen
DATE
 01/17/87
MODIFIED
    traney     09/26/15 - 21747846: JSON lob, date types
    wxli       09/22/15 - 20863220: collation compatibility check
    traney     09/03/15 - 21145550: json_object, json_array, sdo_geometry
    wxli       06/06/15 - 20863177: duplicated COLLATION declaration
    traney     04/30/15 - 20847305: fix json parser conflicts
    sagrawal   04/15/15 - Polymorphic Table Functions: syntax change
    traney     03/02/15 - Proj 47322: JSON
    mahrajag   03/18/15 - Avoid 5014 for P_COVERAGE
    jolkin     01/23/15 - add support for cast conversion error syntax
    sagrawal   01/15/15 - Polymorphic Table Functions: new syntax
    astocks    09/15/14 - Project 48745: Static constraints
    wxli       05/08/14 - add DEFAULT COLLATION syntax
    sagrawal   04/15/14 - Polymorphic Table Functions
    traney     06/27/11 - 38543: directory and credential support for libraries
    astocks    06/15/11 - proj 33067 - whitelist
    traney     02/26/10 - bug 7711101
    sagrawal   02/01/10 - bug 9322044:authid, parallel_enable ordering
    rdecker    10/12/08 - bug 7361575: assembly context clause
    sagrawal   01/29/09 - bug 7530795
    traney     08/18/08 - adding support for PLSQL_OWNER/TYPE
    brwolf     03/27/08 - RELIES_ON deprecated
    wxli       11/01/07 - bug 6281401: disallow direct call to internal 
               standard fuctions
    brwolf     10/02/06 - Bug 5577316: Clean up Result Cache syntax
    jmuller    08/03/06 - Fix bug 5242317: good idea, but can't break existing
                          Apps
    kmuthukk   06/24/06 - dont capture purge
    kmuthukk   12/15/05 - shared function result cache
    sagrawal   05/25/06 - Compound Triggers
    jmuller    05/18/06 - Fix bug 5218593: err 167->166
    rdecker    05/02/06 - enable wrap for assemblies
    rdecker    03/15/06 - Add DOTNET support
    mxyang     08/19/05 - remove PH1DTI
    gviswana   06/23/05 - More cleanups
    mxyang     09/20/04 - Add TOKEN_SEPARATOR_ and SQLOPT_HINT_
    mxyang     07/12/05 - fix lint errors
    jmuller    07/05/05 - Fix bug 4435282: dblink identifiers can be longer 
    sagrawal   06/15/05 - making more changes 
    sagrawal   03/24/04 - static dispatch of overriding methods 
    gviswana   11/24/04 - Mark builtins with PHD_BUILTIN_NAME
    jmuller    07/28/04 - Fix bug 3760768: reset layer if ADT was wrapped 
    mxyang     06/24/04 - fix rule "infinite_predicate;": remove ';'
    jmuller    05/24/04 - Fix bug 3626769: don't drop pragmas on the floor 
    wxli       04/06/04 - adding LIKE2, LIKE4 and LIKEC 
    mxyang     04/02/04 - Add preprocessing directives PP_IF_, PP_THEN_, etc.
    gviswana   02/26/04 - Remove string as RHS of dot operator 
    jmuller    03/02/04 - Rename scmfst 
    gviswana   01/12/04 - Set S_T_SPEC pointer for D_SUBTYP 
    jmuller    01/12/04 - Fix bug 3345089: update ph1tln/ph1tco in SQL intro 
    jmuller    10/09/03 - Fix bug 2699883: move IS OF ONLY bit to phdleafnam() 
    rpang      05/30/03 - Fixed line information for D_BLOCK's DS_ITEM
    dbronnik   02/25/03 - sparse collections
    cbarclay   11/07/02 - overlaps is phd_builtin_name
    cbarclay   11/27/02 - not submultiset
    cbarclay   10/25/02 - member of
    mxyang     12/04/02 - native syntax for binary_float/double trusted callout
    mxyang     11/25/02 - rename REMF to REMAINDER
    rpang      10/17/02 - Mark line and column no. for BEGIN keyword
    rpang      10/08/02 - Remove ph1null hack
    cbarclay   10/01/02 - alt_ty_options_for_alter_array
    eehrsam    10/11/02 - multiset enh
    sagrawal   09/25/02 - lint
    sagrawal   06/24/02 - Sparse collection support for bulk binds
    cbarclay   10/08/02 - tidy
    rdecker    06/18/02 - Add vararg support 
    cbarclay   09/03/02 - collection enhancements
    cbarclay   08/20/02 - alter varray
    cbarclay   08/19/02 - rope off alternatively quoted string_literal
    rpang      08/16/02 - Mark end column number for nodes with "END"
    rpang      08/16/02 - Fix line number for LOOP .. WHILE;
    gviswana   06/13/02 - phd_get_defn_3
    mxyang     07/10/02 - IS [NOT] NAN and IS [NOT] INFINITE
    gviswana   04/27/02 - phd_get_defn
    mxyang     04/11/02 - add REMF_
    rpang      05/09/02 - Mark end line number for nodes with "END"
    cbarclay   01/21/02 - new adt_constructor
    qyu        01/07/02 - fix bug2163473
    cbarclay   12/07/01 - is of
    cbarclay   10/28/01 - type operator IS OF
    sagrawal   10/29/01 - bug 2075024
    qyu        10/19/01 - change PSDSATR_ALT to OCCS compatible 
    ciyer      10/03/01 - user defined constructor - review comments
    lvbcheng   10/06/01 - 1960680: empty subtypes
    jmuller    09/27/01 - Fix bug 1987654: mishandling of string attributes in 
                          bind var processing
    cbarclay   07/05/01 - user defined constructor support
    qyu        09/13/01 - type evolution syntax
    cbarclay   09/07/01 - treat
    cbarclay   05/17/01 - treat ( <expr> as type )
    dbronnik   07/31/01 - associative arrays
    ciyer      06/15/01 - bug fix 1764948
    mxyang     06/06/01 - b759390: remove unused keyword DELAY_ and others
    jmuller    05/10/01 - Fix bug 1742457: extend 1484770 to
                          selector.name(datetimefield 
    rdani      04/20/01 - Fix 1643827.Handle ALTER TYPE in wrapped files
    mxyang     02/18/01 - lint
    rdani      01/31/01 - Chnages to final property fix
    rdani      01/25/01 - Fix final again
    rdani      01/23/01 - Fix final problem.Clear flag
    gviswana   01/26/01 - 1111555: Hidden columns
    gviswana   12/18/00 - Upsert -> Merge
    mxyang     01/16/01 - bug 1484770 reopen: '(' -> ASC_LPAREN
    gviswana   11/30/00 - ub4 for line numbers
    mxyang     12/26/00 - lrg52553_52554_52555
    rdani      11/30/00 - Fix RENAME METHOD core dump
    mxyang     12/04/00 - bug 1484770
    rdani      11/16/00 - Add PSDSATR_ALT_FINAL_PROP_CHANGED
    mmorsi     10/24/00 - Support for ORAData.
    dbronnik   09/27/00 - pnty callout args.
    rdani      10/03/00 - Fix 1401454
    rdani      09/28/00 - Fix 1420629 Issue PLS-00716
    jmuller    09/18/00 - Fix bug 1376685: return correct name of ROLLBACK via
                          v1v2 
    mmorsi     07/18/00 - Review comments.
    gviswana   06/30/00 - Common FE: COMMIT, ROLLBACK, etc.
    rdani      07/17/00 - ALTER TYPE RENAME attrib/method issue PLS 951
    asethi     07/12/00 - Bulk bind extensions
    mmorsi     06/21/00 - SQLJ support for Self as a result.
    asethi     06/30/00 - Dedicated agent and transactional extproc
    cbarclay   06/26/00 - daylight savings
    sagrawal   06/09/00 - ref cursor as callout arguments
    rdani      06/20/00 - Fix FINAL/INST syntax for ALTER TYPE
    wxli       06/17/00 - adding length qualifiers BYTE and CHAR
    mmorsi     06/15/00 - SQLJ types part 2.
    gviswana   05/09/00 - Common FE support for cursors
    asethi     06/09/00 - Pipelined and parallel support, part 3
    asethi     06/08/00 - Make PARALLEL_ENABLE extensions optional
    rdani      06/02/00 - Modify attribute. Errors ,etc.
    mmorsi     05/31/00 - SQLJ external types.
    mmorsi     05/15/00 - SQLJ changes for external variable name.
    ciyer      05/05/00 - support method modifiers
    asethi     06/01/00 - Pipelined and parallel support, part 2
    rdani      05/22/00 - Make FORCE generic rule
    rdani      05/21/00 - Fix order of added attributes
    rdani      05/19/00 - ALTER TYPE 8.2.0
    mmorsi     05/11/00 - SQLJ review comments.
    mmorsi     05/04/00 - Cleanup for code review.
    ciyer      05/01/00 - cleanup support for not instantiable types
    cbarclay   06/01/00 - ldi cleanup
    cbarclay   04/19/00 - ldi cleanup
    cbarclay   04/26/00 - introduce a_external for attribute
    cbarclay   04/24/00 - sqlj
    mmorsi     03/21/00 - SQLJ.extensions
    gviswana   04/29/00 - Common SQL parser support
    asethi     04/27/00 - Fixed pipelined and parallel support problems
    mxyang     04/27/00 - support PL/SQL CASE stmt/expr
    jjozwiak   03/10/00 - partition,cluster,order
    mxyang     03/08/00 - support PL/SQL CASE stmt/expr
    jmuller    02/01/00 - Fix bug 898860: TRENULL <> NULL
    sagrawal   01/29/00 - table function and ref cursor
    sokrishn   02/02/00 - FINAL, INSTANTIABLE flags.
    sokrishn   01/25/00 - change keyword EXTENDS to UNDER
    jmuller    11/16/99 - Fix bug 784046: allow f@x()
    sagrawal   11/09/99 - INSERT/UPDATE using %rowtype
    cbarclay   12/10/99 - extract(field from datetime)
    nle        11/09/99 - dynamic bulk sql support
    sagrawal   11/03/99 -  cursor subquery
    cbarclay   11/03/99 - merge datetime_literals fix forward
    cbarclay   11/03/99 - datetime literals without NLS
    cbarclay   10/27/99 - 
    dbronnik   09/30/99 - 999612: fix tree vs lisdef* mixup
    dbronnik   09/20/99 - 995153: labeled top-level
    rdani      09/21/99 - Clean up plsql.y
    gviswana   08/31/99 - Fix time and timestamp literal formats
    rdani      08/30/99 - TRIM/CAST capture.967837
    mxyang     08/30/99 - add datatype timestamp with local time zone
    rdani      08/24/99 - Fixing 940064,929035.TRIM bugs.
    wawu       06/28/99 - Add limit clause to BULK FETCH
    ciyer      07/20/99 - bug 919390: partition extended name in lock table
    dbronnik   06/28/99 - allow ORDER BY clause in subqueries
    nle        06/29/99  - dynamic returning clause
    cbarclay   06/29/99 - regen
    cbarclay   06/20/99 - interval literals of single field
    cbarclay   06/17/99 - datetime keyword capture fix
    ciyer      06/03/99  - bug 881430: support subpartition extended table name
    asethi     06/10/99 -  Bug 783235: added datetime/interval support to ILMS
    cbarclay   06/08/99 -  regen
    cbarclay   06/03/99 -  .iconstrt. for datetime
    cbarclay   05/14/99  - overlaps for datetime
    mxyang     05/24/99 - bug 881427: add support for sample clause
    mxyang     05/14/99 -  enable "delete from t1 return c1 into n"
    wawu       04/21/99 -  fix modification history
    cbarclay   05/14/99 - redo datetime literal
    sagrawal   05/14/99 - bug 838413
    cbarclay   05/12/99 - at time zone
    cbarclay   05/11/99 - undo datetime literal
    cbarclay   05/10/99 - regen in merge stage
    cbarclay   05/07/99 - backout captureable type name
    cbarclay   05/05/99 - cast to datetime multiword types
    cbarclay   05/05/99 - basic datetime literals
    cbarclay   04/23/99 - avoid datetime type capture
    wawu       02/02/99 -  bug 781291: schema-anchoring
    mxyang     01/02/99 -  bug 487834
    jmuller    10/06/98 -  Fix bug 732522: stripping(/rearranging?) optimizer
                           hints due to incorrect counting of DML level in
                           non-UPDATE-statement uses of UPDATE
    cbarclay   11/04/98 - remove interval from (d-d) interval <int type>
    cbarclay   11/03/98 - regen with plsql.recover updated with TRIM
    cbarclay   10/12/98 - simple trim() now in standard
    cbarclay   10/09/98 - sql92 trim
    nle        10/08/98 -  Bug 723708
    sokrishn   08/19/98 -  add wrap support for adt
    gviswana   09/16/98 -  Move V1-V2 hooks to phase 2
    sagrawal   08/17/98 -  TABLE subquery using nested TABLE locators
    gviswana   08/10/98 -  Remove SQL_NAME_RESOLVE
    nle        07/10/98 -  fix uninitialized variable
    nle        07/13/98 -  DETERMINISTIC, PARALLEL_ENABLE, TRUST
    nle        06/23/98 -  cleaning up frontend code for java project
    cbarclay   05/18/98 -  (datetime-datetime)interval<qual> syntax
    sagrawal   05/18/98 -  bug 671858
    cwethere   07/21/98 -  Adding in the changes which Gray Clossman made for t
    nle        05/13/98 -  merge from USUNDARA transaction for REPEATABLE
    bburshte   05/09/98 -  select from table
    cbarclay   05/06/98 -  datetime table_element
    nle        05/08/98 -  rope off client side for dynamic SQL
    cbarclay   05/04/98 -  regen
    cbarclay   05/04/98 -  remove obsolete renaming rule/tidy
    cbarclay   04/29/98 -  datetime as ty_mk
    lgammo     04/01/98 -  UROWID Support
    nle        04/16/98 -  autonomous transaction - delete assignment to
                           s_flags of D_BLOCK since it's already set to ZERO
    asethi     04/10/98 -  Bulk binds project, part 2
    dalpern    04/06/98 -  opaque object ddl and static methods
    nle        04/06/98 -  dynamic sql - revise and merge
    nle        03/30/98 -  autonomous transaction
    gviswana   03/15/98 -  IR: New Diana nodes
    bburshte   12/17/97 -  create operator spec
    gclossma   03/12/98 -  allow C and Java in type and pkg specs
    gclossma   03/16/98 -  merge-java-sdk
    asethi     03/03/98 -  Added NOCOPY support
    rhari      02/20/98 -  Disable default params in CALL-Specifications
    gclossma   02/07/98 -  lrg 20435
    rhari      01/27/98 -  CALL-Specification in specs
    gclossma   01/21/98 -  post-fs-review syntax for Java call-specs
    rhari      12/30/97 -  ILMS CALL-Specification syntax
    asethi     12/18/97 -  Added bulk bind support
    gviswana   01/14/98 -  Invoker's Rights Syntax
    gclossma   01/20/98 -  remove PFFOLJAVA from a_STYLE
    dalpern    01/12/98 -  inheritance, part 1
    nle        01/15/98 -  dynamic sql
    jweisz     01/07/98  - change fixed/varying prod
    rhari      12/30/97 -  ILMS CALL-Specification syntax
    edarnell   12/18/97 -  Remove: "type foo table of (n number)"
    edarnell   12/15/97 -  Properly set s_layer for ADT type name
    jweisz     12/17/97  - support varray compression: add fixed_varying prod
    gclossma   11/19/97 -  set L_RESTRICT_REFERENCES in Java covers
    gclossma   10/28/97 -  add user-named parms to DS_X_PARM
    nle        10/17/97 -  use slax_8.0.4 and linting error
    gviswana   09/24/97 -  V1-V2 converter: track all char declarations
    asethi     09/22/97 -  Bug 491827; deleted unnecessary token and production
    dalpern    09/05/97 -  bug 523301: extraneous diana nodes
    gviswana   07/17/97 -  499737: Add syntax to specify schema name
    cbarclay   05/14/97 -  fix compile errors for 2 a_FLAGS
    usundara   04/19/97 -  [dnizhego] insert into with alias (the only
                           generated file that's different is plsql.c)
    cbarclay   04/17/97 -  lismak->llismak for DS_STM/DS_ALTER
    cbarclay   04/03/97 -  remove_parenthesized_type_body_syntax
                        -  partition name accepts numeric literal
    cbarclay   03/21/97 -  bug 467024 WITH CHECK ONLY/WITH READ OPTION
    cbarclay   03/20/97 -  table partitions in insert stmt
    cbarclay   03/11/97 -  table partitions
    cbarclay   03/20/97 -  as object is mandatory not optional
    cbarclay   03/19/97 -  remove ref into clause
    cbarclay   03/14/97 -  singleton sql returning into
    gclossma   03/13/97 -  444115
    cbarclay   01/02/97 -  add optional AS in THE(subquery) AS alias
    usundara   12/31/96 -  incomplete and mutually-dependent types changes
                             bug 415560: call KGLSTPRP

    rhari      12/12/96 -  Wrap libraries
    dnizhego   12/04/96 -  parse IS DANGLING
    dalpern    12/04/96 -  nchar: D_CHARSET_SPEC reshape
    zwalcott   11/20/96 -  remove support for cfile, signed/unsigned binary int
    cbarclay   11/13/96 -  as object optionally
    dalpern    11/10/96 -  nchar: bind var, empty_clob(), chr()/translate()
    dalpern    11/01/96 -  nchar: bind var, empty_clob(), chr()/translate()
    mvemulap   10/28/96 -  oci renaming
    dalpern    09/18/96 -  diana v7<->v8 compatibility
    rhari      10/01/96 -  #407291, library names are not identifiers
    dnizhego   09/29/96 -  change meaning of MULTISET
    rhari      09/27/96 -  NCHAR support in external procedures
    dnizhego   09/25/96 -  new collection DML syntax
    zwalcott   09/24/96 -  pragma_rr: default case.
    dnizhego   08/31/96 -  cache REF to ADT as ADT_GET_CACHED_REF_ADT
    dalpern    07/12/96 -  nchar
    rhari      08/12/96 -  Switch datatype to PFFTINDSTRUCT if indicator + stru
    edarnell   08/13/96 -  remove d_array from typed table
    rhari      07/26/96 -  Callouts Composite Datatypes
    rhari      07/22/96 -  #377926, No PH1 error if null library filespec
    gclossma   06/19/96 -  for member procedures, self is IN OUT
    dnizhego   06/14/96 -  fix portability problem (ub4 vs pointers)
    zwalcott   06/13/96 -  pragma r_r. check map/order methods have one.
    dnizhego   06/01/96 -  put back support for INSERT (new edition)
    cbarclay   05/31/96 -  incomplete types
    rhari      05/20/96 -  STATIC and TRUSTED/UNTRUSTED for LIBRARY
    zwalcott   05/19/96 -  map and order methods
    zwalcott   05/06/96 -  signed/unsigned binary integer.
    rhari      05/13/96 -  Backout insert statement changes
    dnizhego   04/30/96 -  workaround for slax bug
                        -  until slax fixed, the number of nonterminal
                        -  should not exceed value of token `numeric_literal'
    dnizhego   04/23/96 -  rearranged parsing of SQL table options
    dnizhego   04/11/96 -  added support for INSERT ... REF INTO
    dnizhego   04/10/96 -  rewrote processing of INSERT statement
    dnizhego   04/10/96 -  removed a shift/reduce conflict
    dnizhego   04/09/96 -  CREATE LIBRARY top-level syntax added
    dunietis   12/01/95 -  foreign function support
    bburshte   09/26/85 -  hey, donno why, but no records of me modifying
                           for objects. So this is one.
    usundara   07/31/95 -  bugfix 280461 - continuation of 184183.
                           (merge from version /main/st_plsql_rel73/2)
    zwalcott   07/25/95 -  add semicolon to union
                           (merge from version /main/st_plsql_rel73/4)
    zwalcott   07/19/95 -  bugfix 288292
                           (merge from version /main/st_plsql_rel73/3)
    zwalcott   07/11/95 -  bugfix 275601: line numbers at block ends.
                           (merge from version /main/st_plsql_rel73/1)
    cbarclay   04/06/95 -  subquery in from clause for non-select stms
    usundara   03/28/95 -  bug 184183 - top-level stmt - merge rev 1.96.720.6
    usundara   01/18/95 -  bugfix 255455 - merge forward from rev 1.96.720.4
    usundara   12/01/94 -  bug 193202 - allow fully-qualified column names in
                           the insert and update column lists.  (depends on fix
                           for 252006).  Merge changes from rev 1.96.720.3
    usundara   11/30/94 -  bug 252006: insert_column_list=>insupd_column_list:
                           change production for set_clause_item to say
                           insupd_column_list instead of aggr. Merge 1.96.720.2
    usundara   11/30/94 -  work-around for bug in upgraded version of slax3 to
                           avoid gobbling up 1st character in lines of plsqax.c
                           merge changes from branch 1.96.720.1
    bburshte   08/29/94 -  new wrapped keyword
    bburshte   08/22/94 -  COMPRESS->COMPILED
    bburshte   08/19/94 -  REF
    cbarclay   07/18/94 -  fix for fetch/close
    usundara   06/09/94 -  try to make diana node-numbering independent of
                           C compilers ( calls to ph1dtn as arguments to other
                           functions affect diana node-numbering because
                           argument evaluation order is dependent on C
                           compiler implementations.)
    usundara   04/18/94 -  new slax
    sthakur    02/03/94 -  changing stdio.h include to conform to OCCS
    bburshte   12/09/93 -  fix open curs ref, avoid reduce/reduce conflict
    bburshte   11/30/93 -  for cursor ref
    bburshte   11/23/93 -  ref cursors
    bburshte   07/09/93 -  make ph1psq a function
    bburshte   06/14/93 -  proc/func call via connection qualifier
    bburshte   06/02/93 -  bugs 148256, 157869
    cbarclay   05/20/93 -  into clause optinal, remove query_expression from
                           compilation unit
    bburshte   05/17/93 -  merge p214 fixes into patch
    cbarclay   05/13/93 -  adding query_expression; to compilation_unit
    bburshte   04/28/93 -  the x constant:= 1; problem
    bburshte   04/09/93 -  bug ph1dtn
    bburshte   04/02/93 -  optional AS
    bburshte   03/30/93 -  put in optional AS keyword
    bburshte   03/18/93 -  bug 146196
    cbarclay   11/22/92 -  add 1715 :fips savepoint message
    jweisz     11/19/92 -  Insert many ub4 casts in ph1dtn calls
    CBARCLAY   11/12/92 -  add "for update nowait" and fix "savepoint"
    bburshte   11/11/92 -  bug 82520 - prohibit x constant:= 10;
    bburshte   11/10/92 -  remove ALL selector
    spuranik   11/09/92 -  Bug 137265: change ASSERT to PPPASR
    cbarclay   11/05/92 -  set transaction read write; also bug 118585
    bburshte   11/03/92 -  bug 115049 - allow start with - connect by
    cbarclay   10/13/92 -  fix  -- bug 130565 -- bug 129909
    cbarclay   08/31/92 -  fixing count again
    cbarclay   08/10/92 -  bug 99299
    cbarclay   07/13/92 -  allowing count and count(*)
    gclossma   06/05/92 -  oops, dyslexia strikes, 1459 => 220
    gclossma   06/02/92 -  err msg 1459 => 202
    sbhargav   02/23/92 -  allow multistatement hep macros
    tolkin     02/14/92 -  add long raw, double precision
    jmallory   02/02/92 -  Add PH1POP to with-interface (.interface.)
    sbhargav   01/20/92 -  Replace hepgro with hepnfp
    tolkin     01/08/92 -  allow qualified dblinks
    tolkin     11/20/91 -  allow long and long raw decls
    cbarclay   11/13/91 -  adding name_wo_function_call
    tolkin     10/10/91 -  remove distributed transaction syntax
    kjensen    09/16/91 -  someone else needs a_UP
    tolkin     09/12/91 -  recomp grammar
    kjensen    09/09/91 -  add a_UP for Q_SQL_ST
    tolkin     08/28/91 -  change type of terminal from word to ub2
    tolkin     08/23/91 -  fix with interface: use item_type for ty_mk
    tolkin     08/19/91 -         regen plsql with new SLAX interface
    tolkin     07/11/91 -         fix line nums for LOOPs
    llao       07/02/91 -         a
    llao       06/18/91 -         fix hshlyr for tables
    tolkin     06/11/91 -         fix line numbers for loops
    tolkin     06/05/91 -         apply ken's changes, move slax into new age
    llao       05/22/91 -         table column order
    llao       05/13/91 -         more q_synon
    kjensen    05/08/91 -         change arrays to be tables - index by
    tolkin     05/01/91 -         allow as for is in proc decls
    llao       04/29/91 -         more q_view
    jmuller    04/29/91 -         Linting
    tolkin     04/25/91 -         allow expressions in group by clause
    tolkin     04/19/91 -         create q_sql_st correctly for debugger
    jmuller    04/17/91 -         Linting
    llao       04/10/91 -         implement tables, sequences, views, synonyms
  Olkin      03/19/91 -         create diana for rpc with no args correctly
  Muller     03/12/91 - Hepdef Removal: Phase II
  Olkin      03/06/91 - final lint changes
  Olki      02/21/91 - regen without #line
  Muller     02/18/91 - Linting
  Muller     02/13/91 - Linting
  Olkin      02/06/91 - fix bug in building Diana for procedure calls
  Olkin      01/30/91 - fix procedure call syntax
  Olkin      01/16/91 - add new COMMIT/ROLLBACK syntax
  Olkin      01/11/91 - allow for update without column list
  Olkin      12/21/90 - allow table aliases in deletes again
  Barclay    12/14/90 - adding flag 1711
  Muller     12/06/90 - Linting'
  Barclay    11/29/90 - unimplemented flags implemented
  Barclay    11/21/90 - adding new FIPS flags
  Bhargav    11/10/90 - Add NEW type syntax
  Olkin      11/06/90 - remove comments around lexical
  Olkin      08/09/90 - modify for V7
  Olkin      07/10/90 - add WITH INTERFACE
  Olkin      05/25/90 - add nowait to for update clauses
  Olkin      05/22/90 - allow table-aliases in DELETE
  Olkin      03/20/90 - add assignment in subprg_d
  Olkin      03/14/90 - convert to SLAX - see slax_plsql_changes.txt
  Jensen     03/02/90 - fix D_EXCEPT bug
  Lao        10/04/89 - more fips flagger
  Lao        09/28/89 - fips flagger (table and column names)
  Lao        09/27/89 - more fips (section 8.12.7)
  Dufour     09/15/89 - more FIPS flagger stuff
  Dufour     09/08/89 - more flags
  Dufour     08/23/89 - Adding UNION ALL
  Jensen     05/03/89 - need to re-gen y_tab.c
  Dufour     05/01/89 - Changing [NOT]LIKE to have third argument
  Jensen     04/25/89 - allow FOR UPDATE in SELECT INTO
  Jensen     04/17/89 - call ph1typ on PRIVATE type too
  Dufour     04/04/89 - Adding an optional NOT in front of node rel
  Hughes     03/27/89 - fips flags
  Dufour     03/21/89 - exception stuff
  Dufour     03/21/89 - Fixing PH1FLAG usage
  Dufour     03/10/89 - Adding the first FIPS flag
  Jensen     02/26/89 - gen new for CMSMVS, lint
  Jensen     01/30/89 - fix e.* in select list
  Jensen     01/18/89 - remove name: syntax
  Clossma    12/01/88 - rebuild y_tab
  Clossma    12/01/88 - fix compilation errors after recompiling system
  Clossma    11/22/88 - propagate pga access thru arg PGAP
  Jensen     11/03/88 - into record changes
  Dufour     11/01/88 - lock table
  Dufour     10/18/88 - Adding DEFAULT in addition to ':=' for init values.
  Jensen     10/12/88 - add LOCK TABLE and %TYPE syntax
  Dufour     10/04/88 - remove D_CURSOR.
  Jensen     09/22/88 - fix ph1dti call (too late for keywords)
  Jensen     09/21/88 - make commit keyword
  Jensen     09/21/88 - fix commit work
  Jensen     08/23/88 - commit, rollback, abort
  Dufour     08/18/88 - Making MOD a prefix function.
  Clossma    08/12/88 - pcmmsg ==> PCMMSGS
  Jensen     08/11/88 - call to ph1msg needs to change
  Dufour     06/02/88 - Fixing <expr> in <aggr>.
  Jensen     06/01/88 - change 'IS_NULL' to 'IS NULL' ...
  Jensen     05/31/88 - fix select_stmt w/ no INTO clause
  Jensen     05/17/88 - outer joins
  Dufour     05/17/88 - Removing keywords LEVEL_ and ROWNUM_
  Jensen     05/04/88 - Wizard's challenge
  Jensen     04/27/88 - SET TRANSACTION READONLY
  Dufour     04/26/88 - Adding new cursor methods.
  Jensen     04/19/88 - new in line for-loop syntax (select..)
  Jensen     04/18/88 - identifier can be idq
  Dufour     04/05/88 - Fixing up attribute sql%rowcount
  Jensen     03/31/88 - new BIND
  Dufour     03/18/88 - Fixing that old x * -x problem.
  Jensen     02/17/88 - fix current of CURSOR c1
  Jensen     02/09/88 - INTO
  Jensen     01/19/88 - KNL
  Jensen     01/14/88 - YYDEBUG->0
  Jensen     01/13/88 - allow <> for != operator too
  Jensen     01/05/88 - FETCH
  Jensen     12/16/87 - optionalize WHERE clause on UPDATE
  Jensen     12/16/87 - fix optional FROM in DELETE
  Jensen     12/10/87 - current of cursor
  Jensen     12/09/87 - remove object_d_rhs : type-constructor...
  Jensen     12/04/87 - one comp-unit
  Jensen     11/18/87 - >ANY ... (use this rather than GREATER_ANY..
  Hughes     10/30/87 - tredef* ==> noddef
  Jensen     10/30/87 - fix NOT NOT ..
  Jensen     10/26/87 - add DATE_BASE, PSH/POP block decls
  Jensen     10/22/87 - add transaction syntax
  Jensen     10/08/87 - add SS_LIST (bind vars) to comp-u
  Jensen     10/06/87 id ... introduced bug
  Jensen     09/30/87 - stmts can be top level
  Jensen     09/18/87 - use real psdsbi
  Jensen     09/16/87 - case_stm bug
  Jensen     08/26/87 - add S_value to Q_BIND reduction
  Jensen     08/13/87 - remove exception init, add pragma
  Jensen     08/07/87 - add exception initialization
  Jensen     08/03/87 - change '/=' sym to '!='
  Jensen     07/20/87 - pragma w/ different did that unit?
  Jensen     07/19/87 - correct pragma in compilation units
  Jensen     07/18/87 - unary_add_op bug
  Jensen     07/17/87 - lint
  Jensen     07/16/87 - lint
  Jensen     07/08/87 - kjlj
  Jensen     06/24/87 - add Q_BIND
  Jensen     06/22/87 - not_null target is value
  Jensen     06/19/87 - inadvertently removed table aliases
  Jensen     06/18/87 - select didn't become Q_SQL_ST
  Jensen     06/17/87 - check on 'a,b,c INTEGER' syntax
  Jensen     06/12/87 - remove AT, add @, remove ADA records
                        removed all ':' in declarations, removed lists in
                        declarations, removed END RECORD syntax.
  Jensen     05/27/87 - ADA record syntax was wrong
  Jensen     05/14/87 - exceptions bug
  Jensen     05/12/87 - seq=>lis
  Jensen     05/06/87 - order_by w/o ASC or DESC
  Jensen     05/05/87 - tremak change
  Jensen     04/15/87 - Q_CONNEC
  Jensen     04/14/87 - try to avoid extra ph1inc
  Jensen     04/09/87 - add database as unit
  Jensen     04/08/87 - D_NAMED error in cmpon_asc
  Jensen     04/07/87 - add aliases to FROM clause
  Jensen     03/31/87 - PGAify
  Jensen     03/26/87 - add DROP table stmt
  Jensen     03/19/87 - aliases
  Jensen     03/17/87 - implicit for loop
  Jensen     03/10/87 - dev
  Jensen     03/10/87 - not null fix
  Jensen     02/12/87 - dev
  Jensen     02/10/87 - ph1mak => ph1mak
  Jensen     02/02/87 - fetch and close bnf error
  Jensen     01/28/87 - char and num production error
  Jensen     01/20/87 - dev
*/

/*
 * TMO: V7 Notes
 * I am changing the way we handle reserved words and keywords.  Currently,
 * we attempt to do this through the rules of the grammar.  I am going to
 * change this in the following way:
 *
 * - all keywords are initially treated as reserved words.  That is, when the
 *   lexical analyzer identifies a token as a reserved word, SLAX will treat
 *   it as such.
 * - If SLAX determines that a reserved word has caused a syntax error then
 *   SLAX will lookup this word in a table of keywords.  If the identifier is
 *   found (ie, it is a keyword), then SLAX will change the token type to that
 *   of an identifier.
 * - SLAX will then try to shift this new identifier.  If SLAX fails again,
 *   then an identifier was also not legal in the current production.
 *
 * Note that this assumes that when a keyword is used, it is first tried as
 * a reserved word and not an identifier.  That is, if a keyword is found in
 * state where an identifier is also legal, the keyword will be used as such.
 * From a languages point of view, this is the correct action to take.  Most
 * problems with keywords occur when an identifier is expected but a keyword
 * is given instead.
 * TMO - 08/09/90
 *
 ******************************************************************************
 * As of this writing (see below), the following PL/SQL syntax features are
 * not implemented:
 *
 * - SCHEMA definitions
 * - DATABASE definitions
 * - STATEMENT definitions
 * - any DDL
 * - DROP TABLE
 * - CASE statements
 *
 * TMO - 08/09/90
 ******************************************************************************
 * I have now removed the option of putting RELEASE after COMMIT and ROLLBACK.
 * I have added the syntax for distributed transactions for COMMIT and
 * ROLLBACK.
 * I have removed the syntax which allowed one to invoke a procedure and a
 * function with an empty agrument list.  This is not allowed in Ada and was
 * probably added to PL/SQL by mistake.
 *
 * TMO - 01/28/91
 */

/*
* There are two 'table_definition's - I removed the first (it really is
* not used, correct?) and  placed the other on RHS of sql_stmt.
* I've changed CHAR and NUMBER for paramters and... - change in doc.
* Changes for that and RAW changed again - need to add!
* It's unfortunate that we call hshnew once more than necessary, any
*   workaround?
* I added the parameterless function call - apparently a mistake in grammar?
*
* Put some thought into name,dotted_name,id stuff - make consistant.  (ie
* 6.5 will allow name, 6.7 won't, so I only changed 6.7
*/

/* why 7.1 diff between end and beginning names?
 * search condition is now an expression - shall I put it in though?
 * try factoring out the ';' into earlier productions
 * create table sim_n : name was too general (got in way of '(' later,
 * should it be an dotted_name ? that may not be true
 * temporary 'flags' will be #define'd (T_IN_OUT)
 */

/*****************************************************************************/
/*                                                                           */
/*                      This is an attempt to produce an                     */
/*                      an LALR(1) grammar for the COMBINATION               */
/*                        of ADA and SQL (PL/SQL+).  If this is              */
/*                        possible, then we can get PL/SQL by                */
/*                        restriction, knowing we can get 'back'.            */
/*                                                                           */
/*                        Comments about the differences between             */
/*                        PLSQL.Doc and this BNF (grammar issues)            */
/*                        are also included.                                 */
/*                                                                           */
/*****************************************************************************/
/*                        ADA changes :                                      */
/*                                                                           */
/*                        '               %                                  */
/*                                                                           */
/*                        AND THEN        AND                                */
/*                        OR ELSE         OR                                 */
/*                                                                           */

%{

#ifndef S_ORACLE
#include <s.h>
#endif

#define PPPASR_BASE PPPASR_Y_TAB

#ifndef  PH1DEF
#include <ph1def.h>
#endif

#ifndef HSHDEF
#include <hshdef.h>
#endif

#ifndef HEPDEF
#include <hepdef.h>
#endif

#ifndef PSDDEF
#include <psddef.h>                                    /* For SEVSEVER, etc. */
#endif

#ifndef PFF_ORACLE                           /* Foreign function definitions */
#include <pff.h>
#endif

#ifndef PSI
#include <psi.h>                            /* Flag test for CALL statement. */
#endif

#ifndef PLSFST_ORACLE
#include <plsfst.h>
#endif

#define Q_SQL_PA  D_ERROR                          /* probably won't be used */
#define ph1p ((ph1pgadf *)cs)


ub4 ph1psqfn (ph1pgadf* ph1pga, lisdef* lis)
{
  ph1pga->ph1seq = lis;
  return 1;
}

#define PH1PSQ(lis) ph1psqfn(ph1p,(lis))
#define  llismak()  PH1PSQ(lismak())
#define PPH1LINN(x,y) PH1PSQ(PH1LINN(x,y))
#define PPH1LCAT(x,y) PH1PSQ(PH1LCAT(x,y))
#define PPH1LAPN(x,y) PH1PSQ(PH1LAPN(x,y))

#define PXGETTOK (*mach->pxgett)                         /* copied from SLAX */

#define T_NONE   0                  /* note that no terminal has this value! */
#define T_FALSE  0
#define T_TRUE   1
#define T_IN     2
#define T_IN_OUT 3
#define T_OUT    4
#define T_NOT    5 
#define T_ONLY   6
#define T_OF     7
#define T_ALL    8
#define T_LIKE   9
#define T_LIKE2  10
#define T_LIKE4  11
#define T_LIKEC  12

/***** FOREIGN FUNCTION STUFF: For now. ******/
#define LOWER_CASE(x) x

%}

/* We should fix yacc sometime to output this IN y_tab.c ONLY WHEN it  */
/* DOESN"T produce the y_tab.h file. .... (put it back in if/when it's */
/* needed.                                                             */

%union
{
  ub2                        terminal;
  noddef                     tree;
  lisdef                     *seq;
  text                       *cnst;
  ub4                        number;
}

/*---------------------------- Punctuation. ---------------------------------*/

%token <terminal> ASSIGN_
%token <terminal> '.' '(' ')' ',' '*' '@' '%' '&' '|' '=' '-' '+' ':' ';' '<'
%token <terminal> '/' '>'

/*---------------------------- TERMINALS ------------------------------------*/

%token <terminal> BAD_ BAD_STRING_                           /* error tokens */

/*-------------------------- ADA-Terminals ----------------------------------*/

%token <terminal> ALL_            ARRAY_   
%token <terminal> AT_ BEGIN_  BODY_ CASE_  CONSTANT_
%token <terminal> DECLARE_ ELSE_ ELSIF_
%token <terminal> END_ EXCEPTION_ EXIT_ FOR_
%token <terminal> FUNCTION_ GOTO_ IF_ IN_  IS_ LIMITED_
%token <terminal> LOOP_ MOD_ REMAINDER_ NEW_ NOT_  NULL_ OF_ NAN_ INFINITE_
%token <terminal> OTHERS_ OUT_        PACKAGE_ PRAGMA_  PRIVATE_
%token <terminal> PROCEDURE_  RAISE_  RANGE_ RECORD_ REM_
%token <terminal> HASH_
%token <tree> RETURN_ RETURNING_
%token <terminal> SELECT_  SEPARATE_
%token <terminal> SUBTYPE_        THEN_
%token <terminal> TYPE_ UPDATE_ USE_ VARRAY_ WHEN_ WHILE_ WITH_

/* UPDATE_ terminal: if you're making new use of it, see bug 732522. */

%token <tree> id idq bind_var

%token <terminal> ARROW_ DBLDOT_ EXP_ NOTEQL_
%token <terminal> GTEQL_ LTEQ_ L_LBL_ R_LBL_ BOX_

/* unused terms */

%token <terminal> REVERSE_

/*------------------------ PL/SQL Terminals ---------------------------------*/

%token <tree>     AND_ OR_         /* actually NOW they aren't - but later.. */
%token <terminal> CHAR_BASE_  DEFAULT_ LIKE_ LIKE2_ LIKE4_ LIKEC_ NUMBER_BASE_
%token <terminal> DECIMAL_ DATE_BASE_ ESCAPE_
%token <terminal> CLOB_BASE_ BLOB_BASE_ BFILE_BASE_
%token <terminal> TABLE_ INTERFACE_
%token <terminal> AUTHID_
%token <terminal> ELLIPSIS_ 
%token <terminal> COLLATE_ COLLATION_
%token <tree>     CONTINUE_

/*----------------------- Other SQL Terminals -------------------------------*/

%token <terminal> ALTER_ ANY_ AS_ ASC_ AVG_
%token <terminal> BETWEEN_ BY_
%token <terminal> CALL_ CHECK_ CLOSE_ CLUSTER_ CLUSTERS_
%token <terminal> FINAL_ INSTANTIABLE_

/* COMMIT_ should be elsewhere, but we'd need to re-y_tab.h  */

%token <terminal> COLAUTH_ COLUMNS_ COMPRESS_ CONVERSION_ COUNT_
%token <terminal> CRASH_ CREATE_ CURRENT_ COMMENT_
%token <tree>     CURSOR_ 
%token <terminal> DEFINE_ DELETE_ DESC_ DISTINCT_
%token <terminal> DROP_ ERROR_ EXISTS_
%token <terminal> FETCH_ FORCE_ FROM_ LOCK_ MODE_ NOWAIT_ SHARE_ EXCLUSIVE_
%token <terminal> GRANT_ GROUP_
%token <terminal> HAVING_
%token <terminal> IDENTIFIED_ INDEX_ INDEXES_ INTO_ INSERT_ INTERSECT_
%token <terminal> MAX_ MIN_ MINUS_ NOCOMPRESS_
%token <terminal> ON_ OPEN_ OPTION_ ORDER_ OVERLAPS_ OVERRIDING_
%token <terminal> PARTITION_ PRIOR_ PUBLIC_
%token <terminal> RESOURCE_ REVOKE_
%token <terminal> ROLLBACK_ ROW_
%token <terminal> SAVEPOINT_ SEQUENCE_ SEGMENT_ SET_ SIZE_ SOME_
%token <terminal> SQL_ START_ STDDEV_ SUBPARTITION_ SUM_ SYNONYM_
%token <terminal> TO_ TABAUTH_ 
%token <terminal> UNION_ UNIQUE_ USING_ SELF_ RESULT_
%token <terminal> VALUES_ VARIABLE_ VARIANCE_ VIEW_ VIEWS_ WHERE_

%token <terminal> CONNECT_

%token <terminal> CAT_ INDICATOR_ DANGLING_

/*--------------------- followed are terminals for dynamic sql --------------*/

%token <tree> EXECUTE_
%token <terminal> IMMEDIATE_

/* Keywords - These types are special becuase we really want to treat the */
/* terminal as an identifier for phase 2.                                 */

%token <tree> LONG_ RAW_ DOUBLE_ PRECISION_

/*---------------------------- Keywords (not Reserved) ----------------------*/

%token <tree> TRANSAC_ READ_ ONLY_ WORK_ COMMIT_ WRITE_
%token <tree> REF_
%token <tree> COMPILED_
%token <tree> WRAPPED_
%token <terminal> ISOLATION_
%token <terminal> LEVEL_
%token <terminal> SERIALIZABLE_ SQLDATA_ CUSTOMDATUM_ ORADATA_
%token <terminal> COMMITTED_
%token <terminal> MULTISET_ THE_
%token <terminal> ORGANIZATION_ HEAP_
%type  <number> organization_opt index_or_heap
%token <terminal> BOTH_ LEADING_ TRAILING_

%token <tree> FORALL_
%token <terminal> BULK_ COLLECT_
%type <terminal> BULK_COLLECT_opt

%token <terminal> LIMIT_
%type  <tree> limit_clause_opt
%token <terminal> SAVE_ 
%type <terminal> save_exceptions_opt

%token <tree> NOCOPY_
%token <tree> MERGE_
%token <terminal> HIDDEN_
%type <tree> gen_call

/*------------------------ Common SQL front-end support ---------------------*/

/*
 * The basic token representing a static SQL statement - either a standalone
 * SQL statement or the entire query tree for a SQL statement in a cursor or
 * a FOR loop.
 */
%token <tree> SQL_STMT_

/*
 * The following non-terminals help communicate context from the parser
 * back to the scanner. For a detailed explanation, see the comments for
 * common SQL front-end support in ph1def.h
 */
%type <terminal> select_ update_ insert_ delete_ with_ set_ lock_
%type <terminal> savepoint_ commit_ rollback_
%type <terminal> ddl_start dml_start
%type <tree> merge_
%type <tree> mark_loop_sql_stmt mark_cursor_sql_stmt mark_sql_stmt
/* Standalone static SQL statement non-terminal */
%type <tree> static_ddl_stmt static_dml_stmt

/*------------------------ Foreign function support. ------------------------*/

%type <tree> external_library external_name c_external_ops external_parameter
%type <number> external_parameter_style_token external_calling_standard
%type <number> external_indicator_or_len external_indicator_token
%type <number> external_indicator_mode external_options external_type
%type <number> external_language
%type <tree> external_parm_list_name_and_indicator external_atr_opt
%type <tree> external_parameter_list external_parameter_list_opt
%type <tree> external_parm_list_entry 
%type <tree> external_language_decl external_name_ops java_external_ops
%type <tree> java_call_specification call_specification call_statement
%type <tree> sqlj_type_opt call_statement
%type <tree> dotnet_external_ops 
%type <tree> foreign_library_spec java_class_opt assembly_spec
%type <seq> external_parm_list_entry_opt
%token <terminal> EXTERNAL_ LIBRARY_ NAME_ PARAMETER_ STYLE_ GENERAL_ ORACLE_
%token <terminal> NATIVE_ LANGUAGE_ CALLING_ STANDARD_ TRUSTED_ UNTRUSTED_
%token <terminal> PARAMETERS_ CONTEXT_ LENGTH_ MAXLEN_ C_ PASCAL_
%token <terminal> TDO_ DURATION_ CHARSETID_ CHARSETFORM_ 
%token <terminal> ASSEMBLY_ DOTNET_ SECURITY_ IDENTITY_ 
%token <terminal> SAFE_ EXTERNAL_0_ EXTERNAL_1_ EXTERNAL_2_ UNSAFE_
%token <tree>     CHAR_
%token <terminal> SHORT_ INT_ SB1_ SB2_ SB4_ UB1_ UB2_ UB4_ FLOAT_
%token <terminal> OCINUMBER_ OCISTRING_ ORLVARY_ OCIRAW_ OCIDATE_ OCIROWID_
%token <terminal> OCIDATETIME_ OCIINTERVAL_ OCIREFCURSOR_
%token <terminal> ORLANY_ STRUCT_ VOID_ VALIST_ REFERENCE_ STRING_
%token <terminal> OCITYPE_ OCIDURATION_ OCIREF_ OCILOBLOCATOR_ OCICOLL_ SIZE_T_
%token <terminal> SQLCODE_ SQLSTATE_ SQLNAME_ STATIC_ JAVA_ BOUND_
%token <terminal> YEAR_ MONTH_ DAY_ HOUR_  MINUTE_ SECOND_ ZONE_  LOCAL_
%token <terminal> TIMEZONE_HOUR_  TIMEZONE_MINUTE_
%token <terminal> TIMEZONE_REGION_  TIMEZONE_ABBR_
%type <number> LOCAL_opt interval_literal_qualifier 
%token <tree> TIME_ TIMESTAMP_ INTERVAL_ DATE_
%type  <cnst>     static_or_string_literal
%type  <terminal> trusted_or_untrusted
%token <terminal> AGENT_ TRANSACTIONAL_ CREDENTIAL_
%type  <cnst>     agent_name_opt identity_opt assembly_context_opt
%type  <tree>     directory_name_opt credential_name_opt
%type  <terminal> transactional_opt security_opt



/*****************************************************************************/

%start compilation
%lexical ph1lex

%type <tree> relal_op binary_add_op unary_add_op mult_op
%type <tree> identifier bind_var.INDICATOR_id.

/*-------------------------------- ADA Baseline -----------------------------*/

/* these were going to remain terminals...? */

%type <terminal> mode UNION_ALL_opt is_or_as rep_type 
%type <tree> return_or_returning
%type <terminal> IN_opt

%type <tree> pragma pragma_arg basic_d object_d ty_d full_ty_d
%type <tree> nty_def ty_def subty_d constrained_type unconstrained_type
%type <tree> constraint cursor_ty_def func_return_prm_spec_unconstrained_type
%type <tree> range integer_ty_def real_ty_def
%type <tree> array_ty_def array_ty_initial_def
%type <tree> rec_ty_def
%type <tree> incomplete_ty_d
%type <tree> basic_decl_item later_decl_item
%type <tree> name name_wo_function_call prefix
%type <tree> function_call dotted_expr
%type <tree> attribute attribute_designator arg expr rel
%type <tree> assoc_arg paren_aggr
%type <tree> sim_expr term factor pri procedure_call
%type <tree> stmt labeled_nonblock_stmt labeled_block_stmt
%type <tree> sim_stmt
%type <tree> unlabeled_nonblock_stmt nonblock_compound_stmt
%type <tree> label null_stmt assignment_stmt if_stmt
%type <tree> loop_stmt iteration_scheme loop_prm_spec
%type <tree> block_stmt exit_stmt return_stmt goto_stmt
%type <tree> continue_stmt
%type <tree> pipe_stmt
%type <tree> subprg_d subprg_spec designator fml_part prm_spec
%type <tree> prm_spec_unconstrained_type adt_type_header ff_w_external 
%type <tree> ff_wo_external subprg_body_or_spec
%type <tree> subprg_body pkg_body
%type <tree> operator_definition
%type <tree> operator_signature binding_function
%type <seq>  basic_operator_decl_item_list
%type <tree> enum_ty_def enum_lit_spec
%type <tree> compilation_unit library_unit
%type <tree> excptn_handler excptn_d excptn_choice raise_stmt
%type <tree> seq_of_stmts
%type <tree> dotted_name link_expanded_n dblink dblink_alts
%type <tree> expanded_and_bind_n link_expanded_n_optional_partition
%type <tree> object_d_rhs sim_expr_DBLDOT__sim_expr
%type <tree> NOT_BOUND_opt

%type <tree> COMMA_sim_expr_opt select_item sel_expr
%type <tree> default_expr_opt constraint_opt
%type <tree> relal_op_sim_expr_opt
%type <tree> EXP_pri_opt
%type <tree> else_clause_opt
%type <tree> identifier_opt iteration_scheme_opt
%type <tree> exception_handlers_opt
%type <tree> dotted_name_opt WHEN_cond_opt expr_opt fml_part_opt
%type <tree> designator_opt
%type <tree> block_opt
%type <tree> empty_block
%type <tree> pkg_spec
%type <tree> arith_expr compilation

%type <tree> bulk_loop_stmt bulk_loop_rng int_pipe_tab_fun subprg_i

/*-------------------- Added for WITH INTERFACE -----------------------------*/

%type <tree> proc_interface_opt interface_proc_spec interface_fml_part
%type <tree> interface_prm_spec interface_indicator_opt
%type <tree> interface_constrained_type interface_constraint_opt

/*-------------------- Added for IS NOT OF -----------------------------*/

%type <tree> user_defined_type_name /* user_defined_type_specification */
%type <tree> is_of_predicate is_prefix 
%type <terminal> is_of_modifier 
/* %token <terminal> is_of_modifier */

%type <tree> DECLARE_decls_opt

%type <seq> interface_prm_spec_list_opt
%type <seq> ident pragma_args empty_parens_opt paren_expr_list
%type <seq> type_aggr user_defined_type_name_list
%type <seq> pragma_list_opt pragma_arg_list decl_list_opt
%type <seq> basic_decl_item_list later_decl_item_list
%type <seq> arg_list sim_expr_list select_item_list
%type <seq> stmt_list_opt label_list_opt elsif_clause_opt
%type <seq> excptn_handlers parm_list_opt
%type <seq> enum_lit_spec_list
%type <seq> excptn_choice_list_opt

%type <seq> decl_list

/*------------------------------ SQL additions ------------------------------*/

%type <tree> cursor_d
%type <tree> char_ty_def date_ty_def lob_ty_def
%type <tree> tbl_ty_def
%type <tree> field body_adt_field adt_field sql_stmt
%type <tree> bulk_executable_stmt sql_query_or_dml_stmt
%type <tree> delete_statement_positioned delete_statement_searched
%type <tree> update_statement_positioned update_statement_searched
%type <tree> insert_statement where_clause having_clause
%type <seq>  insert_stmt_values_seq
%type <tree> insert_stmt_values_expr
%type <tree> query_specification query_expression query_term
%type <tree> curs_spec curs_body
%type <tree> cast_expression_arg
%type <tree> cast_conversion_error
%type <seq>  cast_nls_params
%type <tree> select_statement table_definition
%type <tree> sequence_definition synonym_definition
%type <tree> adt_definition table_type_definition
%type <tree> set_function_specification
%type <tree> between_predicate table_expression from_clause
%type <tree> boolean_primary in_predicate
%type <tree> ordered_subquery table_subquery  cursor_subquery
%type <tree> plain_subquery new_subquery old_subquery with_subquery
%type <tree> flattened_subquery
%type <tree> table_subquery ordered_table_subquery
%type <tree> collection_value_constructor
%type <tree> collection_value_expression
%type <tree> value_expression
%type <tree> comparison_predicate like_predicate
%type <tree> null_predicate dangling_predicate
%type <tree> nan_predicate infinite_predicate
%type <tree> overlaps_predicate 
%type <tree> exists_predicate ESCAPE_sim_expr_opt
%type <tree> full_cursor_body open_statement fetch_statement close_statement
%type <tree> open_cursor_reference_statement cursor_open_statement
%type <tree> table_reference connect_by_clause table_function_call
%type <tree> link_expanded_n_optional_partition_or_subquery
%type <tree> table_reference_or_subquery
%type <seq> table_column_list
%type <tree> table_column default_opt
%type <number> column_property column_property_seq
%type <number> collate_opt
%type <tree> default_collation default_collation_opt
%type <tree> set_clause_item COMMENT_literal_opt
%type <tree> table_expression_clause
%type <tree> select_list
%type <tree> set_function_name group_by_clause sort_specification
%type <tree> lock_table_statement lockmode
%type <tree> NOWAIT_opt returning_into_clause returning_into_clause_opt

%type <seq>  insupd_column_list name_list column_name_list

%type <terminal> set_operator public_opt
%type <terminal> NOT_opt  NOT_NULL_opt like
%type <terminal> adt_flags adt_flag
%type <number> method_flags_opt
%type <terminal> NOT_opt_INSTANTIABLE NOT_opt_FINAL
%type <terminal> fixed_varying_opt

%type <tree> method_specification original_method_specification
%type <tree> original_method_body_specification

%type <tree> where_clause_opt COMMA_sim_expr_opt
%type <tree> NOT_opt_IN NOT_opt_BETWEEN NOT_opt_LIKE
%type <tree> return_type_opt
%type <tree> table_expression_clause_list set_operator_query_term_list
%type <tree> order_by_clause_opt for_update_clause_opt
%type <tree> order_by_clause for_update_clause

/* added for datetime */

%type <tree> datetime_d  interval_d interval_qualifier alldatetime_d
%type <tree> constrained_datetime_type  constrained_interval_type
%type <tree> constrained_interval_type_2 constrained_datetime_interval_type
%type <tree> iconstraint iconstraint_opt  unconstrained_type_wo_datetime
%type <tree> time_zone_specifier constrained_interval_return_type
%type <tree> captureable_datetime_identifiers
%type <tree> datetime_field interval_literal datetime_string_field 

/* For TRIM */

%type <tree> trim_options 
%type <seq>  trim_options_sim_expr

/* for subpartition extended table names */

%type <terminal> partition_or_subpartition

%type <seq>  field_list adt_field_list adt_field_list_opt body_adt_field_list
%type <seq>  table_reference_list
%type <seq> sort_specification_list
%type <seq> into_list_opt into_list
%type <seq> set_clause_item_list

%type <tree>  and_expr
%type <terminal> ALL_DISTINCT_opt ALL_DISTINCT
%type <terminal> WORK_opt SAVEPOINT_opt FROM_opt

%type <tree> ph1psh_
%type <tree> swallow
%type <tree> pragma_arg2
%type <tree> decl_id expr_id
%type <terminal> member_or_static
%type <tree> partition_name
%type <terminal> array_
%token <terminal> VALUE_ MEMBER_ OBJECT_ CONSTRUCTOR_
%token <terminal> STORED_ FIXED_ VARYING_
%token <tree> UNSIGNED_ BINARY_
%token <terminal> MAP_
%token <terminal> OPERATOR_

/*----------------------------- NATIVE SQL additions ------------------------*/

%type <tree> dsql_stmt
%type <tree> exec_immediate_statement
%type <tree> using_bind returning_clause_opt
%type <seq> using_clause_opt using_bind_list 

/* Support for verbose ANSI type names, character sets */

%token <tree> NATIONAL_ CHARACTER_ NCHAR_ LARGE_

/* Declared already but used this way too: CHAR_ VARYING_ BINARY_ OBJECT_. */
/* CHAR_ and BINARY_ must be declared <tree>.  LONG_, RAW_, DOUBLE_, and   */
/* PRECISION_ are similar; LONG_ and DOUBLE_ must be <tree>.               */

%token <tree> CHARSET_
%token <tree> nonnative_string_literal 
%type  <tree> charset_spec_opt charset_csname

%token <terminal> OPAQUE_ UNDER_
%type  <tree> object_kind opaque_size adt_type_spec 
%type  <tree> base_type_spec sub_type_spec
%type  <terminal> opaque_fixed_or_varying

/* Invoker's rights */

%type <tree> authid
%type <tree> subprg_properties subprg_property 
%type <tree> func_properties_opt

%type <tree> return_as_alias_table_reference_or_subquery
%type <tree> datetime_literal datetime_expanded_n datetime_link_expanded_n

/* added for sample clause */

%token  <tree> SAMPLE_
%token <terminal> BLOCK_
%type  <tree> sample_clause sample_percent table_reference_with_sample
%type <tree> from_table_reference_or_subquery
%type <seq>  ...from_table_reference_or_subquery..

/* added for case statement and case expression */
%type <tree> case_stmt case_stmt_alt
%type <seq>  case_stmt_alt_seq
%type <tree> case_expr case_expr_alt
%type <seq>  case_expr_alt_seq
%type <tree> ELSE_expr_opt

/* Special terminals. Until slax bug fixed (discovered on 4/30/96) the value */
/* of token numeric_literal will limit the number of nonterminals.           */

%token <cnst> numeric_literal string_literal

/* parallelism */

%token <tree>     PIPE_ /* Special handling to avoid name capture */
%token <terminal> DETERMINISTIC_ PARALLEL_ENABLE_ PIPELINED_ AGGREGATE_ 
%type  <tree>     partition_elaborator   partition_elaborator_opt
%type  <tree>     cluster_or_order_elaborator
%type  <number>   hash_or_range update_value_opt  with_external_context_opt 

/* adding BYTE_ for length semantics, CHAR_ already exists */
%token <tree> BYTE_

/* ALTER TYPE 8.2.0 */

%token <terminal> INVALIDATE_ CASCADE_ INCLUDING_ EXCEPTIONS_ ADD_ RENAME_
%token <terminal> MODIFY_ ATTRIBUTE_ DATA_ CONVERT_ SUBSTITUTABLE_

%type <seq> alt_ty_attr_names alt_ty_attr_nlist alt_ty_attrs
%type <seq> alt_ty_attr_list
%type <tree> alt_ty_attributes
%type <seq> alt_ty_attribs_list
%type <seq> alt_ty_meth_opt_pragma
%type <seq> alt_ty_methods_list
%type <terminal> alt_ty_data_opts force_opt alt_ty_excep_opt
%type <terminal> alt_ty_options 
%type <tree> alt_ty_a_statement
%type <seq> alt_ty_changes alt_ty_stmts
%type <seq> optional_alter_types

%type <tree> adt_specification adt_body

/* End ALTER TYPE */


/* For alternative quotes */
%token <tree> alternatively_quoted_nonnative_string_literal 
%token <cnst> alternatively_quoted_string_literal

/* ALTER TYPE (ARRAY or nested TABLE) */

%token <terminal> ELEMENT_ 
%type <tree> alter_type_prefix collection_limit
%type <tree> alt_array_a_statement alt_array_clause 
%type <seq> alt_array_change alt_array_stmts 
%type <seq> optional_alter_arrays 

/* End ALTER TYPE (ARRAY or nested TABLE) */

/* Sparse collection support for bulk binds */
%token <terminal> INDICES_
%type <tree> bulk_loop_bnds bulk_btwn

/*  collection enhancements */

%type <tree> empty_predicate set_predicate member_predicate 
%type <tree> submultiset_predicate multiset_op_union_except 
%type <tree> multiset_op_intersect multiset_boolean_expr 
%type <tree> multiset_term multiset_value_expression
%type <tree> multiset_primary multiset_term_or_primary 
%type <tree> combinable_multiset_term combinable_multiset_expr 
%type <tree> combinable_multiset_primary

%type <terminal> OF_opt ALL_opt
%token <terminal> A_ EMPTY_ EXCEPT_ SUBMULTISET_  

/* end of collection enhancements */

%token <terminal> SPARSE_

%token <terminal> PP_IF_ PP_THEN_ PP_ELSE_ PP_ELSIF_ PP_END_ PP_ERROR_
%token <terminal> TOKEN_SEPARATOR_ SQLOPT_HINT_

/* shared function result cache */

%token <terminal> RESULT_CACHE_ RELIES_ON_ NOW_
%token <tree>     PURGE_
%type  <tree>     result_cache_property
%type  <seq>      relies_on_clause result_cache_entries
%type  <tree>     purge_stmt purge_options
%type  <seq>      dotted_name_list_opt dotted_name_list

/* CompoundTriggers */ 
%token <terminal> COMPOUND_ TRIGGER_ BEFORE_ AFTER_ STATEMENT_ INSTEAD_
%token <terminal> EACH_ 

%type <tree>  compound_trg_body  before_or_after row_or_stmt table_stmt 
%type <seq>   cmp_trg_stmts_opt
%type <tree>  compound_trg_stmts

/* Whitelisting */
%token <terminal> ACCESSIBLE_
%type  <tree>     white_list
%type  <seq>      white_list_items
%type  <tree>     package_properties_opt
%type  <tree>     white_list_item
%type  <cnst>     white_list_type

/* ----------------- 12.2: Polymorphic Table Functions --------------------*/
%token <terminal> POLYMORPHIC_  LEAF_ REWRITE_ 
%type  <tree> polymorhic_elaborator

/* Project 47322: JSON */
%token <terminal> LAX_ STRICT_ WITHOUT_ KEYS_ JSON_ PRETTY_ ASCII_ WRAPPER_
%token <terminal> TRUE_ FALSE_ VARCHAR2_ CLOB_ BLOB_ NUMBER_ BOOLEAN_ BSON_
%token <terminal> CONDITIONAL_ UNCONDITIONAL_ ABSENT_ SDO_GEOMETRY_ FORMAT_
%token <tree> JSON_EXISTS_ JSON_VALUE_ JSON_QUERY_ JSON_OBJECT_ JSON_ARRAY_
%type  <number> is_json_options_opt lax_strict_opt unique_keys_opt
%type  <number> json_exists_error_opt json_null_opt strict_opt
%type  <seq>    json_value_error_opt json_name_value_pair_list
%type  <number> ascii_opt pretty_opt json_format_opt
%type  <tree>   is_json json_value json_query json_exists json_predicate
%type  <number> json_query_error_opt json_wrap_opt json_char_returning_opt
%type  <tree>   json_object json_array json_operator json_datetime_format_opt
%type  <seq>    json_name_value_pair json_array_expr_list
%type  <seq>    json_value_returning_opt
%%


/*---------------------------- Start of Rules -------------------------------*/

identifier:                 /* We could (should?) do this in the entokener  */
                            /* We assume for now that this is a USED_ID.If  */
                            /* later we find it is a DEF_ID, then we change */
  id
  {
    $$ = $1;
    L_defaul($$, (ub4)0);
  }
|
  idq
  {
    $$ = $1;
    L_defaul($$, PHD_QUOTED_ID);
  }
;

expr_id:
  identifier
/* Keywords that can begin statements */
|
  EXECUTE_
  {
    $$ = $1;
  }
|
  PURGE_
  {
    $$ = $1;
  }
|
  FORALL_
|
  merge_
|
  PIPE_
|
  CONTINUE_
|
/* Keywords that begin clauses */
  CURRENT_
  {
    $$ = ph1dti(ph1p, DI_U_NAM, (CONST text *) "CURRENT");
  }
;

/*
*  NOTES on keywords. When the entokener sees a keyword, it makes a new node
*  via ph1dti. If in fact this is NOT used as an identifier the space could
*  be reclaimed in the other useage of (for instance) TRANSAC). That is not
*  done currently. So far I've tried to turn these into keywords, but
*  conflicts seem to have arising. Can try again with the BLAH_KW methodology
*         AVG,COUNT,MAX,MIN,STDDEV,SUM,VARIANCE
*/

pragma:

  PRAGMA_ identifier pragma_args
  {
    ub4 tmp1 = (ub4)ph1dtr(ph1p, $2, DI_U_NAM);
    ub4 tmp2 = (ub4)ph1dtn(ph1p, DS_PARAM, 1, PH1PSQ($3));
    $$ = ph1dtn(ph1p,D_PRAGMA,2, tmp1, tmp2);
    
    if (!lstcmp(l_SYMREP(tmp1), (const oratext *)"RESTRICT_REFERENCES"))
      PH1WARN_DEPRECATED(l_SRCLIN($2), l_SRCCOL($2), PLSUNIQ(100),
                         "RESTRICT_REFERENCES", "11.2");

    /* Do not process pragmas here if in ALTER TYPE
     * We will do it later in ALTER TYPE rule
     */
    if (!bit(ph1p->ph1misc, PH1_IN_ALTER_TYPE))
      ph1prg(ph1p, $$, (noddef)0);
  }
;

decl_id:
  identifier
  {
    $$ = $1;
  }
|
  PRIOR_
  {
    $$ = ph1dti(ph1p, DI_U_NAM, (text *)"PRIOR");
  }
|
  EXISTS_
  {
    $$ = ph1dti(ph1p, DI_U_NAM, (text *)"EXISTS");
  }
|
  DELETE_
  {
    $$ = ph1dti(ph1p, DI_U_NAM, (text *)"DELETE");
    ph1p->ph1hnt--;
  }
|
  CURRENT_
  {
    $$ = ph1dti(ph1p, DI_U_NAM, (text *) "CURRENT");
  }
;

/* Note that a <name> is included in an <expr> ( <pri> ) */

pragma_arg:

  pragma_arg2
  {
    $$ = $1;
  }
|
  DEFAULT_
  {
    $$ = ph1dti(ph1p, DI_U_NAM, (text *)"DEFAULT");
  }
|
  identifier ARROW_ pragma_arg2
  {
    ub4 tmp1 = (ub4)ph1dtr(ph1p, $1, DI_ARGUM);
    $$ = ph1dtn(ph1p, D_ASSOC, 2, tmp1, (ub4)$3);
  }
;

pragma_arg2:

  decl_id
  {
    $$ = $1;
  }
|
  numeric_literal
  {
    $$ = ph1dti(ph1p, D_NUMERI, $1);
  }
|
  unary_add_op numeric_literal
  {
    noddef tmp0 = ph1dti(ph1p, D_NUMERI, $2);
    ub4 tmp1 = (ub4)ph1nfs(ph1p, PH1LINN(tmp0, lismak()), (ub4)D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, (ub4)$1, tmp1);
  }
|
  string_literal
  {
    $$ = ph1dti(ph1p, D_STRING, $1);
  }
;

basic_d:
                         /* This node simply collects the divergent subnodes */
  object_d
|
  ty_d
|
  subty_d
|
  subprg_i
|
  excptn_d
|
  cursor_d                                               /* Oracle additions */
;

object_d:

  ident object_d_rhs
  {
    AS_id($2, ph1nfs(ph1p, $1, TREKIN($2)));
    $$ = $2;
  }
;

object_d_rhs:

  constrained_type default_expr_opt
  {
    $$ = ph1dtn(ph1p, D_VAR, 3, (ub4)TRENULL, (ub4)$1, (ub4)$2);
  }
|
  CONSTANT_ constrained_type default_expr_opt
  {
    $$ = ph1dtn(ph1p, D_CONSTA, 3, (ub4)TRENULL, (ub4)$2, (ub4)$3);
  }

|
  tbl_ty_def
  {
    $$ = ph1dtn(ph1p, D_VAR, 3, (ub4)TRENULL, (ub4)$1, (ub4)TRENULL);
  }
;

ident:

  decl_id
  {
    $$ = PH1LINN($1, lismak());
  }
;

ty_d:

  full_ty_d
|
  incomplete_ty_d                                    /* we need for cursor ! */
|
  adt_specification                                     /* adt specification */
|
  adt_body                                                       /* adt body */
;

full_ty_d :

  TYPE_ identifier IS_ nty_def
  {
    $$ = ph1typ(ph1p, $2, $4);
  }
;

nty_def:

  ty_def
|
  NEW_ ty_def
  {
    $$ = ph1dtn(ph1p, D_DERIVE,1, (ub4)$2);
  }
;

ty_def:

  integer_ty_def
|
  enum_ty_def
|
  real_ty_def
|
  array_ty_def
|
  rec_ty_def
|
  char_ty_def                                            /* Oracle additions */
|
  tbl_ty_def
|
  date_ty_def
|
  lob_ty_def
|
  cursor_ty_def                                            /* for plsql v2.2 */
;

subty_d:

  SUBTYPE_ identifier IS_ constrained_type
  {
    ub4 tmp1 = (ub4)ph1dtr(ph1p, $2, DI_SUBTY);
    pht_set_decl_type(pgap, (ptnod) tmp1, $4);

    /* bug 7530795: Set the flag to detect the subtype loop */
    if (PTKIN($4) == D_CONSTR)
      S_flags($4, s_FLAGS($4) | PHD_CONSTR_NOT_DECLARED);

    $$ = ph1dtn(ph1p, D_SUBTYP, 2, tmp1, (ub4)$4);
  }
;

constrained_type:

  constrained_datetime_interval_type charset_spec_opt NOT_NULL_opt
  {
    A_cs($1, $2);
    A_not_nu($1, $3);
    $$ = $1;
  }
|
  unconstrained_type_wo_datetime constraint_opt charset_spec_opt NOT_NULL_opt
  {
    $$ = ph1dtn(ph1p, D_CONSTR, 3, (ub4)$1, (ub4)$2, (ub4)$4);
    A_cs($$, $3);
  }
;

fixed_varying_opt:

  /* Empty */
  {
    $$ = PHD_V8_VARRAY_NOFLAGS;
  }
|
  STORED_ FIXED_
  {
    $$ = PHD_V8_VARRAY_FIXNUM;
  }
|
  STORED_ VARYING_
  {
    $$ = PHD_V8_VARRAY_VARNUM;
  }
;

unconstrained_type_wo_datetime:

  link_expanded_n
  {
    $$ = ph1dtr(ph1p, $1, DI_U_NAM);
  }
|
  REF_ link_expanded_n
  {
    $$ = (ub4)ph1dtn(ph1p, D_T_REF, 1, $2);
  }

  /*
   * We have a problem with a general attribute
   *   a : a(b)%... (in object_d)
   * a can be either the beginning of an attribute, (as it is in this case)
   * a => name or it can be
  */

|
  datetime_link_expanded_n '%' attribute_designator
  {
    $$ = ph1dtn(ph1p, D_ATTRIB, 2, $1, $3);
  }
|
  link_expanded_n '%' attribute_designator
  {
    $$ = ph1dtn(ph1p, D_ATTRIB, 2, $1, $3);
  }
|
  LONG_
  {
    $$ = $1;
  }
|
  LONG_ RAW_
  {
    $$ = $1;
    L_symrep($$, ph1dte(ph1p, (CONST text *)"LONG RAW"));
  }
|
  DOUBLE_ PRECISION_
  {
    $$ = $1;
    L_symrep($$, ph1dte(ph1p, (CONST text *)"DOUBLE PRECISION"));
  }
|
  CHARACTER_
  {
    $$ = $1;
  }

|
  CHAR_
  {
    $$ = $1;
  }

|
  CHARACTER_ VARYING_
  {
    $$ = $1;
    L_symrep($$, ph1dte(ph1p, (CONST text *)"CHARACTER VARYING"));
  }

|
  CHAR_ VARYING_
  {
    $$ = $1;
    L_symrep($$, ph1dte(ph1p, (CONST text *)"CHAR VARYING"));
  }
|
  NATIONAL_ CHARACTER_
  {
    $$ = $1;
    L_symrep($$, ph1dte(ph1p, (CONST text *)"NATIONAL CHARACTER"));
  }
|
  NATIONAL_ CHAR_
  {
    $$ = $1;
    L_symrep($$, ph1dte(ph1p, (CONST text *)"NATIONAL CHAR"));
  }
|
  NCHAR_
  {
    $$ = $1;
  }
|
  NATIONAL_ CHARACTER_ VARYING_
  {
    $$ = $1;
    L_symrep($$, ph1dte(ph1p,
                        (CONST text *)"NATIONAL CHARACTER VARYING"));
  }
|
  NATIONAL_ CHAR_ VARYING_
  {
    $$ = $1;
    L_symrep($$, ph1dte(ph1p, (CONST text *)"NATIONAL CHAR VARYING"));
  }
|
  NCHAR_ VARYING_
  {
    $$ = $1;
    L_symrep($$, ph1dte(ph1p, (CONST text *)"NCHAR VARYING"));
  }
|
  CHARACTER_ LARGE_ OBJECT_
  {
    $$ = $1;
    L_symrep($$, ph1dte(ph1p, (CONST text *)"CHARACTER LARGE OBJECT"));
  }
|
  CHAR_ LARGE_ OBJECT_
  {
    $$ = $1;
    L_symrep($$, ph1dte(ph1p, (CONST text *)"CHAR LARGE OBJECT"));
  }
|
  NATIONAL_ CHARACTER_ LARGE_ OBJECT_
  {
    $$ = $1;

    /* Text trimmed (at OBJEC...) due to 30 byte limit! */
    L_symrep($$, ph1dte(ph1p, (CONST text *)"NATIONAL CHARACTER LARGE OBJEC"));
  }
|
  NCHAR_ LARGE_ OBJECT_
  {
    $$ = $1;
    L_symrep($$, ph1dte(ph1p, (CONST text *)"NCHAR LARGE OBJECT"));
  }
|
  BINARY_ LARGE_ OBJECT_
  {
    $$ = $1;
    L_symrep($$, ph1dte(ph1p, (CONST text *)"BINARY LARGE OBJECT"));
  }

  /* These are not our types, but we're not supposed to reserve the names, */
  /* so let 'em through.                                                   */

  /*
   * Note there is a shift/reduce conflict on NATIONAL; should the user try
   * to attach a character set constraint to a use of a type they've named
   * "national", they'll find "national character" is interpreted always as
   * the type mark, not as the start of "national character set XXX".
   */

|
  NATIONAL_
  {
    $$ = $1;
  }
|
  BINARY_
  {
    $$ = $1;
  }
|
  TABLE_ 
  {
    ptnod pkg_nod;
    ptnod sys_nod = ph1dti(ph1p, DI_U_NAM, P_SYS);
    ptnod dbms_tf_nod = ph1dti(ph1p, DI_U_NAM, P_DBMS_TF);
    ptnod table_nod = ph1dti(ph1p, DI_U_NAM, P_TABLE_T);

    L_defaul(table_nod, PHD_PTF_TABLE);
    
    /* create a node of predefined type in dbms_tf package */
    pkg_nod = ph1dtn(ph1p, D_S_ED, 2, sys_nod,  dbms_tf_nod);
    $$  = ph1dtn(ph1p, D_S_ED, 2,  pkg_nod, table_nod);
  }
|
  COLUMNS_
  {
    ptnod pkg_nod;
    ptnod sys_nod = ph1dti(ph1p, DI_U_NAM, P_SYS);
    ptnod dbms_tf_nod = ph1dti(ph1p, DI_U_NAM, P_DBMS_TF);
    ptnod column_nod = ph1dti(ph1p, DI_U_NAM, P_COLUMNS_T);

    L_defaul(column_nod, PHD_PTF_COLUMN);
    
     /* create a node of predefined type in dbms_tf package */
    pkg_nod = ph1dtn(ph1p, D_S_ED, 2, sys_nod,  dbms_tf_nod);
    $$  = ph1dtn(ph1p, D_S_ED, 2,  pkg_nod, column_nod);
  }
|
 COLUMNS_ WITH_ TYPE_
  {
    ptnod pkg_nod;
    ptnod sys_nod = ph1dti(ph1p, DI_U_NAM, P_SYS);
    ptnod dbms_tf_nod = ph1dti(ph1p, DI_U_NAM, P_DBMS_TF);
    ptnod column_nod = ph1dti(ph1p, DI_U_NAM, P_COLUMNS_WITH_TYPE_T);

    L_defaul(column_nod, PHD_PTF_COLUMN);
    
     /* create a node of predefined type in dbms_tf package */
    pkg_nod = ph1dtn(ph1p, D_S_ED, 2, sys_nod,  dbms_tf_nod);
    $$  = ph1dtn(ph1p, D_S_ED, 2,  pkg_nod, column_nod);
  }
;

unconstrained_type:

  unconstrained_type_wo_datetime
|
  alldatetime_d
;

charset_spec_opt:

  CHARACTER_ SET_ charset_csname
  {
    $$ = ph1dtn(ph1p, D_CHARSET_SPEC, 1, $3);
  }
|
  /* empty */
  {
    $$ = TRENULL;
  }
;

charset_csname:

  identifier
  {
    $$ = $1;
  }
|
  bind_var
  {
    $$ = $1;
  }
|
  link_expanded_n '%' CHARSET_
  {
    $$ = ph1dtn(ph1p, D_ATTRIB, 2, $1, $3);
  }
;

constraint:

  RANGE_ range
  {
    $$ = $2;
  }
|
  paren_expr_list
  {
    $$ = ph1dtn(ph1p, DS_APPLY, 1, PH1PSQ($1));
  }
|
  '(' sim_expr BYTE_ ')'
  {
    lisdef *seq = lismak();
    seq = PH1LINN($3, seq);
    $$ = ph1dtn(ph1p, DS_APPLY, 1, PH1PSQ(PH1LINN($2, seq)));
  }
|
  '(' sim_expr CHAR_ ')'
  {
    lisdef *seq = lismak();
    seq = PH1LINN($3, seq);
    $$ = ph1dtn(ph1p, DS_APPLY, 1, PH1PSQ(PH1LINN($2, seq)));
  }
;

range:                                            /* name collects attribute */

  name                                      /*? what else BESIDES attribute ?*/
  {
    $$ = $1;
  }
|
  sim_expr_DBLDOT__sim_expr
;

enum_ty_def:

  '(' enum_lit_spec enum_lit_spec_list ')'
  {
    $$ = ph1dtn(ph1p, DS_ENUM_, 1, (ub4)PPH1LINN($2, $3));
  }
;

enum_lit_spec:

  identifier
  {
    $$ = ph1dtr(ph1p, $1, DI_ENUM);
  }
;

char_ty_def:

  CHAR_BASE_ '(' sim_expr ')'
  {
    ub4 tmp1 = (ub4)ph1dtn(ph1p, D_RANGE, 2, (ub4)TRENULL, (ub4)$3);
    $$ = ph1dtn(ph1p, Q_CHAR, 1, tmp1);
  }
|
  CHAR_BASE_
  {
    $$ = ph1dtn(ph1p, Q_CHAR, 1, (ub4)TRENULL);
  }
;

integer_ty_def:

  RANGE_ range
  {
    $$ = ph1dtn(ph1p, D_INTEGE, 1, (ub4)$2);
  }
;

real_ty_def:                              /* make this a range in the Diana? */

  NUMBER_BASE_ '(' sim_expr COMMA_sim_expr_opt ')'
  {
    ub4 tmp1 = (ub4)ph1dtn(ph1p, D_RANGE, 2, (ub4)$3, (ub4)$4);
    $$ = ph1dtn(ph1p, Q_NUMBER, 1, tmp1);
  }
|
  NUMBER_BASE_
  {
    $$ = ph1dtn(ph1p, Q_NUMBER, 1, (ub4)TRENULL);
  }
|
  DECIMAL_ '(' sim_expr COMMA_sim_expr_opt ')'
  {
    $$ = ph1dtn(ph1p, Q_DECIMA, 2, (ub4)$3, (ub4)$4);
  }
;

date_ty_def:

  DATE_BASE_
  {
    $$ = ph1dtn(ph1p, Q_DATE, 0);
  }
;

lob_ty_def:

  CLOB_BASE_
  {
    $$ = ph1dtn(ph1p, Q_CLOB, 0);
  }
|
  BLOB_BASE_
  {
    $$ = ph1dtn(ph1p, Q_BLOB, 0);
  }

  /*  cfile removed for 8.0.2 - might come back in. */

/*
|
  CFILE_BASE_
  {
    $$ = ph1dtn(ph1p, Q_CFILE, 0);
  }
*/

|
  BFILE_BASE_
  {
    $$ = ph1dtn(ph1p, Q_BFILE, 0);
  }
;

/* Full definition for ARRAY. Alters could follow */
array_ty_def:

  array_ty_initial_def 

  optional_alter_arrays
  {
    noddef darray = $1;
    /* set line/col to the word 'type' */
    L_srclin(darray, ph1p->ph1tln);  
    L_srccol(darray, ph1p->ph1tco);

    /* List of ALTER TYPE s (d_an_alter nodes) */
    AS_alttyps(darray, $2);

    /*  Clear this. See ph1aat_attach_alter_types */
    bic (ph1p->ph1misc, PH1_IN_ALTER_TYPE);
    
    /* 
     *  We should check that this is not 
     *  package p is type t is varray(2) of number 
     *  alter type t modify limit 3;
     *  This is a syntax error.
     */
    
    if (!lisemp($2))
    {
      if (PL_TYP(plsclu) != KGLTTYPE) 
        /* Only on top-level types */
        PH1ERR(731, SEVSEVER, $1, PLSUNIQ(79));
      else 
      /* We make a call to PSDSATR like ph1aat_attach_alter_types */
      /* Send dependent type options to SQL via callback */
      if (PSDSATR_FPTR && CLIENTCO)
      {
        PSDSATR_REF(pgap, CLIENTCO, ph1p->exception_schema, 
                    ph1p->exception_table, ph1p->alt_ty_SQL_options);
      }
    }
    
    
    $$ = darray;
  }
;

/*
 * KJ-7May91: we now have no notion of 'array'.  They are always tables
 * indexed-by binary integer.  In order to keep things relatively simple,
 * I've kept the old node names, and the diana the same as for arrays.
 * from the syntax and semantics, the main difference is that they are
 * always 'uncnstrnd'.
 */


/* Initial definition for ARRAY. */
array_ty_initial_def:
  TABLE_ OF_ constrained_type INDEX_ BY_ constrained_type
  {
    noddef t_tree;
    noddef t_tree2;
    lisdef *seq = lismak();

    t_tree2 = ph1mak(ph1p, D_INDEX);
    A_name(t_tree2, $6);
    seq = PH1LINN(t_tree2, seq);
    t_tree = ph1mak(ph1p, DS_D_RAN);
    AS_list(t_tree, seq);
    $$ = ph1mak(ph1p, D_ARRAY);
    AS_dscrt($$, t_tree);
    A_constd($$,$3);
  }
|
  SPARSE_ TABLE_ OF_ constrained_type INDEX_ BY_ constrained_type
  {
    noddef t_tree;
    noddef t_tree2;
    lisdef *seq = lismak();

    t_tree2 = ph1mak(ph1p, D_INDEX);
    A_name(t_tree2, $7);
    seq = PH1LINN(t_tree2, seq);
    t_tree = ph1mak(ph1p, DS_D_RAN);
    AS_list(t_tree, seq);
    $$ = ph1mak(ph1p, D_ARRAY);
    AS_dscrt($$, t_tree);
    A_constd($$,$4);
    A_tflag($$, a_TFLAG($$) | V10_SPARSE_TABLE);
  }
|
  TABLE_ OF_ constrained_type                        /* v8-table -no index by*/
  {
    /*
     * this will need semantic checking to make sure it is an table of adt
     * type, or ref adt type. For now, no distinction between this and
     * table_of_type in the diana.
     */

    noddef t_tree;
    noddef t_tree2;
    noddef t_tree3;
    noddef t_tree4;

    lisdef *seq = lismak();

    /* fake out the  indexing to make it look as above. */

    t_tree3 = ph1mak(ph1p, DI_U_NAM);
    L_symrep(t_tree3, (text *) "BINARY_INTEGER");
    t_tree2 = ph1mak(ph1p, D_INDEX);
    A_name(t_tree2, t_tree3);
    seq = PH1LINN(t_tree2, seq);
    t_tree = ph1mak(ph1p, DS_D_RAN);
    AS_list(t_tree, seq);
    t_tree4 = ph1mak(ph1p, D_ARRAY);
    AS_dscrt(t_tree4, t_tree);
    A_constd(t_tree4, $3);
    A_tflag(t_tree4, (ub4)V8_TABLE);
    $$ = t_tree4;
  }
|
  array_ '(' collection_limit ')' OF_ constrained_type fixed_varying_opt
  {
    ptnod tree1 = ph1dti(ph1p, D_NUMERI, (CONST text *) "1");
    ptnod tree = ph1dtn(ph1p, D_RANGE, 2, (ub4)tree1, (ub4)$3);
    ptnod limit = (ub4)ph1dtn(ph1p, DS_D_RAN, 1, PPH1LINN(tree, lismak()));
    $$ = ph1dtn(ph1p, D_ARRAY, 2, limit, (ub4)$6);
    A_tflag($$, V8_ARRAY | $7);
  }
;



array_:

  ARRAY_
  {
    $$ = FIXED_ARRAY;
  }
|
  FIXED_ ARRAY_
  {
    $$ = FIXED_ARRAY;
  }
|
  VARRAY_
  {
    $$ = VARYING_ARRAY;
  }
|
  VARYING_ ARRAY_
  {
    $$ = VARYING_ARRAY;
  }
;

rec_ty_def:                                       /* split into two versions */

  RECORD_ { PH1PSH; } '(' field_list ')'
  {
    $$ = ph1dtn(ph1p, D_R_, 1, PH1PSQ($4));

    /* PH1LYR/s_layer is used in ph1typ for full_ty_d */
    /* Do before PH1POP */

    S_layer($$, ph1p->ph1cly);
    PH1FLAG(1469, $$);                     /* this is a FIPS flag for records*/
    PH1POP;
  }
;


field_list:
  field
  {
    $$ = PH1LINN($1, lismak());
  }
|
  field_list ',' field
  {
    $$ = PH1LAPN($3, $1);
  }
;

adt_field_list_opt:
  /* Empty */
  { 
    /* [1960680]: null if no attributes and methods are provided */
    $$ = lismak();
  }
|
  adt_field_list
;

adt_field_list:
  adt_field
  { 
    $$ = PH1LINN($1, lismak());
  }
|
  adt_field_list ',' adt_field
  {
    $$ = PH1LAPN($3,$1);
  }
;

body_adt_field_list:
  body_adt_field
  {
    $$ = PH1LINN($1, lismak());
  }
|
  body_adt_field_list body_adt_field
  {
    $$ = PH1LAPN($2, $1);
  }
;


external_atr_opt:

  {
    $$ = TRENULL;
  }
|
   EXTERNAL_ NAME_ string_literal
  {
    ptnod atr_ext_name = ph1dti(ph1p, D_STRING, $3);
    $$  = (ub4)ph1dtn(ph1p, D_EXTERNAL, 7, (ub4)atr_ext_name, (ub4)TRENULL,
                      (ub4)TRENULL, (ub2)PFFOCUNSP, (ub2)PFFOLJAVA,
                      (ub2)PFFOLJAVA, (ub4)PFFOMISCUNSP);
  }
;

field:

  ident constrained_type external_atr_opt default_expr_opt
  {
    ub4 tmp1 = (ub4)ph1nfs(ph1p, $1, D_VAR);
    $$ = ph1dtn(ph1p, D_VAR, 3, tmp1, (ub4)$2, (ub4)$4);
    A_external($$,$3); /* external attribute name */
  }
;

adt_field:

  field
|
  method_specification
|
  pragma
;

method_specification:

  original_method_specification
  {
    $$ = $1;
  }
|
  OVERRIDING_ original_method_specification
  {
    $$ = ph1smf_set_method_flags(ph1p, $2, (ub4)0, PHD_METHOD_IS_OVERRIDING);
  }
;

original_method_specification:

  method_flags_opt member_or_static  subprg_i
  {
    $$ = ph1smf_set_method_flags(ph1p, $3, $1,
                                 ((STATIC_ == $2) ?
                                   PHD_METHOD_IS_STATIC : (ub4)0));
  }
|
  method_flags_opt MAP_ MEMBER_ subprg_d
  {
    $$ = ph1smf_set_method_flags(ph1p, $4, $1, PHD_MAP_METHOD);
  }
|
  method_flags_opt ORDER_ MEMBER_ subprg_d
  {
    $$ = ph1smf_set_method_flags(ph1p, $4, $1, PHD_ORDER_METHOD);
  }
|
  method_flags_opt CONSTRUCTOR_ subprg_d
  {
    $$ = ph1smf_set_method_flags(ph1p, $3, $1, PHD_CONSTRUCTOR_METHOD);
  }
;

body_adt_field:

  pragma
|
  original_method_body_specification
|
  OVERRIDING_ original_method_body_specification
  {
    $$ = ph1smf_set_method_flags(ph1p, $2, (ub4)0, PHD_METHOD_IS_OVERRIDING);
  }
;

original_method_body_specification:

  method_flags_opt member_or_static subprg_body_or_spec
  {
    $$ = ph1smf_set_method_flags(ph1p, $3, $1,
                                 ((STATIC_ == $2) ?
                                   PHD_METHOD_IS_STATIC : (ub4)0));
  }
|
  method_flags_opt MAP_ MEMBER_ subprg_body_or_spec
  {
    $$ = ph1smf_set_method_flags(ph1p, $4, $1, PHD_MAP_METHOD);
  }
|
  method_flags_opt ORDER_ MEMBER_ subprg_body_or_spec
  {
    $$ = ph1smf_set_method_flags(ph1p, $4, $1, PHD_ORDER_METHOD);
  }
|
  method_flags_opt CONSTRUCTOR_ subprg_body_or_spec
  {
    $$ = ph1smf_set_method_flags(ph1p, $3, $1, PHD_CONSTRUCTOR_METHOD);
  }
;

method_flags_opt:

  adt_flags
  {
    $$ = $1;
  }
;

member_or_static:

  MEMBER_
  {
    $$ = MEMBER_;
  }
|
  STATIC_
  {
    $$ = STATIC_;
  }
;

subprg_body_or_spec:
  subprg_body
|
  subprg_d ';'
;

incomplete_ty_d:

  TYPE_   identifier 
  {
    $$ = ph1typ(ph1p, $2, TRENULL);
  }
;

decl_list:

  basic_decl_item_list
|
  basic_decl_item_list subprg_body later_decl_item_list
  {
    $$ = PH1LCAT(PH1LAPN($2, $1), $3);
  }
;

basic_decl_item:

  basic_d ';'
|
  full_cursor_body
|
  /* [5242317, 3647002] The pragma has always been hooked in correctly. */
  pragma  ';'
;

later_decl_item:

  subprg_body
|
  subprg_i ';'
|
  /* [5242317, 3647002] The pragma has always been hooked in correctly. */
  pragma ';'
;

name:

  name_wo_function_call
|
  function_call
  {
    $$ = $1;
    if (PTKIN($$) == D_F_CALL && PTKIN(a_NAME($$)) == D_USED_O &&
        !lstcmp(l_SYMREP(a_NAME($$)), (text *) "(+)"))
      ;
    else
      PH1FLAG(1416, $$);
  }
;

name_wo_function_call:

  expr_id
|
  bind_var.INDICATOR_id.
|
  dotted_expr
|
  attribute
  { 
    $$ = $1; 
    PH1FLAG(1417, $$); 
  } 
;

bind_var.INDICATOR_id.:

  bind_var
|
  bind_var INDICATOR_ id
  {
    /* will change at wave 2. */

    text *tmp;

    if ( l_INDREP($1) )
      PCMMSGS(204, SEVERROR, l_SRCLIN($1), l_SRCCOL($1),
              PLSUNIQ(1), l_SYMREP($1));

    tmp = (text *)hepnfp(plskgp, plschp, strlen((char *)l_SYMREP($3))+1,
                         TRUE, "PLSQL.Y: INDICATOR");
    DISCARD(strcpy((char *)tmp, (char *)l_SYMREP($3)));

    L_indrep($1, tmp);

    if (!l_INDREP(phd_get_defn(pgap, $1, 0)))
      L_indrep(phd_get_defn(pgap, $1, 0), l_INDREP($1));

    $$ = $1;
  }
|
  bind_var INDICATOR_ bind_var
  {
    /* will change at wave 2. */

    text *tmp;

    PH1FLAG(1712, $3);
    if ( l_INDREP($1) )
      PCMMSGS(204, SEVERROR, l_SRCLIN($1), l_SRCCOL($1),
              PLSUNIQ(2), l_SYMREP($1));

    tmp = (text *)hepnfp(plskgp, plschp, strlen((char *)l_SYMREP($3))+1,
                         TRUE, "PLSQL.y: BIND VAR");
    DISCARD(strcpy((char *)tmp, (char *)l_SYMREP($3)));

    L_indrep($1, tmp);

    if (!l_INDREP(phd_get_defn(pgap, $1, 0)))
      L_indrep(phd_get_defn(pgap, $1, 0), l_INDREP($1));

    $$ = $1;
  }
;

prefix:

  name
  {
    pxtokn *la1, *la2;
    b2 tokid = (b2) ph1p->ph1tot;

    /* bugs 1484770/1742457: as of 12/04/00, the valid lookaheads (FOLLOW set)
     * of prefix is '%',  '(', and '.'. If the current lookahead is '(', we
     * need to look forward to avoid the capture problem of some keywords.
     */
    if (tokid == ASC_LPAREN)
    {
      ptnty trekind = TREKIN($1);

      /* Look one token ahead. Note that we are doing a hack which relies
       * on the fact that the PL/SQL scanner ph1lex does not use its
       * first parameter filobj, hence we can pass (pgstrm *)0. The filobj
       * (a parameter of function pxnmove) is not available at this point,
       * and it in turn originates from the call to function plsql, where
       * (pgstrm *)0 is passed as the argument for filobj.
       */ 
      la1 = PXGETTOK((pgstrm *)0, cs, PXGETNEXT);
      tokid = pxtgid(la1);

      /* The only EXTRACT we need to care about is the simple identifier.  No
       * prefixed identifier can refer to 'the' EXTRACT. 
       */
      if (trekind == DI_U_NAM &&
          strcmp((char *)l_SYMREP($1), (char *)P_EXTRACT) == 0)
      {
        /* prefix is EXTRACT, however we should not capture the following
         * datetime keywords unless they are followed by FROM; and we should
         * not capture the TRIM keywords ever.
         */
        la2 = PXGETTOK((pgstrm *)0, cs, PXGETNEXT);

        if (pxtgid(la2) != FROM_ &&
            (PLSISA8(tokid, YEAR_, MONTH_, DAY_, HOUR_, MINUTE_, SECOND_,
                            TIMEZONE_HOUR_, TIMEZONE_MINUTE_) ||
             PLSISA2(tokid, TIMEZONE_REGION_, TIMEZONE_ABBR_)) ||
            PLSISA3(tokid, LEADING_, TRAILING_, BOTH_))
          pxtgid(la1) = id;

        /* push back the second lookahead */
        DISCARD PXGETTOK((pgstrm *)0, cs, PXUNGET, la2);
      }

      /* Similarly here.  Note that STANDARD.TRIM != 'the' TRIM! */
      /* prefix is TRIM, however we should not capture the following
       * datetime keywords.
       */
      else if (trekind == DI_U_NAM &&
               strcmp((char *)l_SYMREP($1), (char *)P_TRIM) == 0)
      {
        if (PLSISA8(tokid, YEAR_, MONTH_, DAY_, HOUR_, MINUTE_, SECOND_,
                           TIMEZONE_HOUR_, TIMEZONE_MINUTE_) ||
            PLSISA2(tokid, TIMEZONE_REGION_, TIMEZONE_ABBR_))
          pxtgid(la1) = id;
      }

      else
      {
        /* prefix is not EXTRACT or TRIM, do not capture EXTRACT keywords
         * (YEAR_, MONTH_, DAY_, HOUR_, MINUTE_, SECOND_, TIMEZONE_HOUR_,
         * TIMEZONE_MINUTE_, TIMEZONE_REGION_, TIMEZONE_ABBR_) or TRIM
         * keywords (LEADING_, TRAILING_, BOTH_)
         */ 
        if (PLSISA8(tokid, YEAR_, MONTH_, DAY_, HOUR_, MINUTE_, SECOND_,
                           TIMEZONE_HOUR_, TIMEZONE_MINUTE_) ||
            PLSISA2(tokid, TIMEZONE_REGION_, TIMEZONE_ABBR_) ||
            PLSISA3(tokid, LEADING_, TRAILING_, BOTH_))
          pxtgid(la1) = id;
      }

      /* push back the first lookahead */
      DISCARD PXGETTOK((pgstrm *)0, cs, PXUNGET, la1);
    }
    $$ = $1;
  }
;

/* This is a generalized invocation */
gen_call:
      '(' expr AS_ unconstrained_type ')'  '.' procedure_call 
    {
      ub2 flags = 0;
      ptnod gexpr;
      ptnod new_call;

      bis(flags, PHD_CONVER_GENERALIZED_INVOCATION);
      gexpr = ph1dtn(ph1p, D_CONVER, 5, (ub4)$4, (ub4)$2, (ub4)TRENULL,
                     (ub4)0, (ub2) flags);
      if (PLSISA3(PTKIN($7), D_F_CALL, D_P_CALL, D_APPLY))
      {
        new_call = ph1dtn(ph1p, D_S_ED, 2, (ub4)gexpr, a_NAME($7));
        A_name($7, new_call);
        $$ = $7;
      }
      else
      {
        new_call = ph1dtn(ph1p, D_S_ED, 2, (ub4)gexpr, $7);
        $$ = new_call;
      }
    }
;
/* A procedure invokation is a list of qualified identifiers followed */
/* optionally by a node name followed optionally by an argument list. */

procedure_call:

  name_wo_function_call '@' dblink empty_parens_opt
  {
    ub4 tmp1;
    noddef t_tree;

    t_tree = ph1mak(ph1p, Q_LINK);
    A_name(t_tree, $1);
    A_id(t_tree, $3);
    PH1FLAG(1460, t_tree);
    tmp1 = (ub4)ph1dtn(ph1p, DS_APPLY, 1, PH1PSQ($4));
    $$ = ph1dtn(ph1p, D_APPLY, 2, (ub4)t_tree, tmp1);
  }
|
  name
  {
    $$ = $1;
  }
|
  name_wo_function_call '@' dblink paren_expr_list
  {
    ub4 tmp1;
    noddef t_tree;

    t_tree = ph1mak(ph1p, Q_LINK);
    A_name(t_tree, $1);
    A_id(t_tree, $3);
    PH1FLAG(1460, t_tree);
    tmp1 = (ub4)ph1dtn(ph1p, DS_APPLY, 1, PH1PSQ($4));

    /* $$$ - might have to change this also (like just name) */
    $$ = ph1dtn(ph1p, D_APPLY, 2, (ub4)t_tree, tmp1);
  }
;

/* slice  :  prefix '(' dscr_rng ')'  included under "function_call". */

function_call:

  prefix paren_expr_list                  /* function call or array indexing */
  {
    ub4 tmp1 = ph1dtn(ph1p, DS_APPLY, 1, PH1PSQ($2));
    $$ = ph1dtn(ph1p, D_APPLY, 2, $1, tmp1);
  }
|
  MOD_ paren_expr_list
  {
    /*
     * This rule was added as a special case, because MOD must
     * be a terminal, but it must also be possible to call it
     * as a prefix function (according to SQL). -- Pierre
     */

    ub4 tmp1 = (ub4)ph1dti(ph1p, D_USED_O, (text *)"MOD");
    ub4 tmp2 = (ub4)ph1dtn(ph1p, DS_APPLY, 1, PH1PSQ($2));
    $$ = ph1dtn(ph1p, D_F_CALL, 2, tmp1, tmp2);
  }
|
  prefix '(' ')'                              /* parameterless function call */
  {
    $$ = ph1dtn(ph1p, D_F_CALL, 2, (ub4)$1, ph1nfs(ph1p, lismak(), D_F_CALL));
  }
|
  prefix '(' expr USING_ charset_csname ')'        /* CHR/TRANSLATE w/ USING */
  {
    ub4 fname = TRENULL;
    ub4 csarg;

    if (TREKIN($1) == DI_U_NAM)
      if (lstcmp(l_SYMREP($1), P_CHR) == 0) 
      {
        fname = ph1dti(ph1p, DI_U_NAM, P_STANDARD_CHR);
        L_defaul(fname, PHD_BUILTIN_NAME); 
      }
      else if (lstcmp(l_SYMREP($1), P_TRANSLATE) == 0)
      {
        fname = ph1dti(ph1p, DI_U_NAM, P_STANDARD_TRANSLATE);
        L_defaul(fname, PHD_BUILTIN_NAME); 
      }

    if (!fname)
    {
      PH1ERRS(122, SEVERROR, $1, PLSUNIQ(3), P_USING);
      fname = $1;
    }
    csarg = ph1mak(ph1p, D_NULL_A);
    A_cs(csarg, ph1dtn(ph1p, D_CHARSET_SPEC, 1, $5));
    $$ = ph1dtn(ph1p, D_F_CALL, 2, fname,
                ph1nfs(ph1p, PH1LINN($3,
                                     PH1LINN(csarg, lismak())), D_F_CALL));
  }
|
  prefix '(' cast_expression_arg AS_ unconstrained_type ')'
  {
    if (TREKIN($1) != DI_U_NAM)
      PH1ERRS(122, SEVERROR, $1, PLSUNIQ(47), P_AS);
    else if (lstcmp(l_SYMREP($1), P_TREAT) == 0)
    {
      L_symrep($1, P_SYS_TREAT); 
      L_defaul($1, PHD_BUILTIN_NAME);

      $$ = ph1dtn(ph1p, D_F_CALL, 2, $1,
                  ph1nfs(ph1p, PH1LINN($3, PH1LINN($5, lismak())), D_F_CALL));
    }
    else
    {
      ub4 kind = phd_lookup_cast_oper(l_SYMREP($1));
      
      if (kind == PHD_CAST_OPER_CAST ||
          kind == PHD_CAST_OPER_VALIDATE_CONVERSION)
        $$ = ph1dtn(ph1p, D_CONVER, 7, (ub4)$5, (ub4)$3, (ub4)TRENULL, (ub2) 0,
                    (ub2) 0, (ub4)TRENULL, kind);
      else
        PH1ERRS(122, SEVERROR, $1, PLSUNIQ(48), P_AS);
    }
  }
  
|
  prefix '(' cast_expression_arg AS_ unconstrained_type
             cast_conversion_error ')'
  {
    if (TREKIN($1) != DI_U_NAM)
      PH1ERRS(122, SEVERROR, $1, PLSUNIQ(49), P_AS);
    else
    {
      ub4 kind = phd_lookup_cast_oper(l_SYMREP($1));

      if (kind == PHD_CAST_OPER_CAST)
        $$ = ph1dtn(ph1p, D_CONVER, 7, (ub4)$5, (ub4)$3, (ub4)TRENULL, (ub2)0,
                    (ub2)0, (ub4)$6, kind);
      else
        PH1ERRS(122, SEVERROR, $1, PLSUNIQ(50), P_AS);
    }
  }
  
|
  prefix '(' cast_expression_arg AS_ unconstrained_type cast_nls_params ')'
  {
    if (!TREKIN($1) == DI_U_NAM)
      PH1ERRS(122, SEVERROR, $1, PLSUNIQ(51), P_AS);
    else
    {
      ub4 kind = phd_lookup_cast_oper(l_SYMREP($1));
      const text *to_oper = phd_lookup_to_oper(l_SYMREP($5));

      if (to_oper && (kind == PHD_CAST_OPER_CAST ||
                      kind == PHD_CAST_OPER_VALIDATE_CONVERSION))
      {
        ptnod wrapped = ph1_build_cast_call(ph1p, $3, to_oper, $6);

        if (kind == PHD_CAST_OPER_CAST)
          $$ = wrapped;
        else if (kind == PHD_CAST_OPER_VALIDATE_CONVERSION)
        {
          bis(kind, PHD_CAST_OPER_IS_WRAPPED);
          $$ = ph1dtn(ph1p, D_CONVER, 7, (ub4)$5, wrapped, (ub4)TRENULL,
                      (ub2)0, (ub2)0, (ub4)TRENULL, kind);
        }
      }
      else
        PH1ERRS(122, SEVERROR, $1, PLSUNIQ(52), P_AS);
    }
  }
    
|
  prefix '(' cast_expression_arg AS_ unconstrained_type
             cast_conversion_error cast_nls_params ')'
  {
    if (TREKIN($1) != DI_U_NAM)
      PH1ERRS(122, SEVERROR, $1, PLSUNIQ(53), P_AS);
    else
    {
      ub4 kind = phd_lookup_cast_oper(l_SYMREP($1));
      const text *to_oper = phd_lookup_to_oper(l_SYMREP($5));

      if (to_oper && kind == PHD_CAST_OPER_CAST)
      {
        ptnod wrapped = ph1_build_cast_call(ph1p, $3, to_oper, $7);
        ptnod wrapped2 = ph1_build_cast_call(ph1p, $6, to_oper, $7);

        bis(kind, PHD_CAST_OPER_IS_WRAPPED);
        $$ = ph1dtn(ph1p, D_CONVER, 7, (ub4)$5, wrapped, (ub4)TRENULL, (ub2)0,
                    (ub2)0, wrapped2, kind);
      }
      else
        PH1ERRS(122, SEVERROR, $1, PLSUNIQ(54), P_AS);
    }
  }

|
  prefix '(' sim_expr cast_conversion_error ')'
  {
    if (TREKIN($1) != DI_U_NAM)
      PH1ERR(220, SEVERROR, $1, PLSUNIQ(55));
    else
    {
      const text *to_oper = l_SYMREP($1);
      ub4 kind = phd_lookup_cast_oper(to_oper);

      if (kind != PHD_CAST_OPER_NOT_A_CAST_OPERATOR &&
          kind != PHD_CAST_OPER_CAST &&
          kind != PHD_CAST_OPER_VALIDATE_CONVERSION)
      {
        ptnod wrapped = ph1_build_cast_call(ph1p, $3, to_oper, lismak());
        ptnod wrapped2 = ph1_build_cast_call(ph1p, $4, to_oper, lismak());

        bis(kind, PHD_CAST_OPER_IS_WRAPPED);
        $$ = ph1dtn(ph1p, D_CONVER, 7, (ub4)TRENULL, wrapped, (ub4)TRENULL,
                    (ub2)0, (ub2)0, wrapped2, kind);
      }
      else
        PH1ERR(220, SEVERROR, $1, PLSUNIQ(56));
    }
  }

|
  prefix '(' sim_expr cast_conversion_error cast_nls_params ')'
  {
    if (TREKIN($1) != DI_U_NAM)
      PH1ERR(220, SEVERROR, $1, PLSUNIQ(57));
    else
    {
      const text *to_oper = l_SYMREP($1);
      ub4 kind = phd_lookup_cast_oper(to_oper);

      if (kind != PHD_CAST_OPER_NOT_A_CAST_OPERATOR &&
          kind != PHD_CAST_OPER_CAST &&
          kind != PHD_CAST_OPER_VALIDATE_CONVERSION)
      {
        ptnod wrapped = ph1_build_cast_call(ph1p, $3, to_oper, $5);
        ptnod wrapped2 = ph1_build_cast_call(ph1p, $4, to_oper, $5);

        bis(kind, PHD_CAST_OPER_IS_WRAPPED);
        $$ = ph1dtn(ph1p, D_CONVER, 7, (ub4)TRENULL, wrapped, (ub4)TRENULL,
                    (ub2)0, (ub2)0, wrapped2, kind);
      }
      else
        PH1ERR(220, SEVERROR, $1, PLSUNIQ(58));
    }
  }

  /*
   * Package standard functions " SYS$STANDARD_TRIM", TRIM,LTRIM,RTRIM
   * implement TRIM functionality in PLSQL.  Space before SYS in the
   * name of the function is to help avoid name capture problems.
   *
   * " SYS$STANDARD_TRIM is implemented as icd function pestrim.Third
   * argument indicates leading,trailing or both and the ANSI TRIM
   * compliance (i.e. TRIM set can not be more than one char long.)
   * The last 3 bits of the 3rd numeric argument are for ANSI, LEADING
   * or LEFT and RIGHT or TRAILING.In future the syntax may be extended
   * to allow more than one character long trim set. Code already
   * provides for doing so, but for now we have only one char trim set
   * version. The macros for the trim options (PHD_..) are in phd.h
   */

|
  prefix '(' trim_options_sim_expr FROM_ sim_expr ')'
  {
    ub4     tmp;
    lisdef *lis;

    if ((TREKIN($1) == DI_U_NAM) &&
        (lstcmp(l_SYMREP($1), P_TRIM) == 0))
    {
      L_symrep($1, P_STANDARD_TRIM);
      L_defaul($1, PHD_BUILTIN_NAME);
    }
    else
    {
      PH1ERRS(122, SEVERROR, $1, PLSUNIQ(5), P_FROM);
    }
    lis = PH1LINN($5, $3);
    tmp = (ub4) ph1nfs(ph1p, lis, D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, $1, tmp);
  }
| 
  prefix  '(' datetime_field FROM_ sim_expr ')' 
  {    
    if ( (TREKIN($1) == DI_U_NAM) && 
         (strcmp((char *)l_SYMREP($1),(char *)P_EXTRACT) == 0))
      { 
        ub4 name = (ub4) ph1dti(ph1p, DI_U_NAM, P_SYS_EXTRACT_FROM);
        lisdef *lis = PH1LINN($5,PH1LINN($3,lismak()));
        ub4 call = (ub4) ph1nfs(ph1p,lis, D_F_CALL);
        L_defaul(name, PHD_BUILTIN_NAME);
        $$ = ph1dtn(ph1p,D_F_CALL,2, name, call);
      }
    else
      {/* error prefix not extract */
        PH1ERRS(122, SEVERROR, $1, PLSUNIQ(6), P_FROM);
      }
  }/**/
| 
  prefix  '(' datetime_string_field FROM_ sim_expr ')' 
  {    
    if ( (TREKIN($1) == DI_U_NAM) && 
         (strcmp((char *)l_SYMREP($1),(char *)P_EXTRACT) == 0))
      { 
        ub4 name = (ub4) ph1dti(ph1p, DI_U_NAM, P_SYS_EXTRACT_STRING_FROM);
        lisdef *lis = PH1LINN($5,PH1LINN($3,lismak()));
        ub4 call = (ub4) ph1nfs(ph1p,lis, D_F_CALL);
        L_defaul(name, PHD_BUILTIN_NAME);
        $$ = ph1dtn(ph1p,D_F_CALL,2, name, call);
      }
    else
      {/* error prefix not extract */
        PH1ERRS(122, SEVERROR, $1, PLSUNIQ(7), P_FROM);
      }
  }/**/
|
  prefix '(' '+' ')'                          /* column name with outer join */
  {
    ub4 tmp1 = (ub4)ph1dti(ph1p, D_USED_O, (text *)"(+)");
    ub4 tmp2 = (ub4)ph1nfs(ph1p, PH1LINN($1, lismak()), D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, tmp1, tmp2);
  }
|
  json_operator
;


datetime_field :
     YEAR_
      { $$ = ph1dti(ph1p,D_STRING, P_YEAR); }
   | MONTH_
     { $$ = ph1dti(ph1p,D_STRING, P_MONTH); }
   | DAY_
     { $$ = ph1dti(ph1p,D_STRING, P_DAY); }
   | HOUR_
     { $$ = ph1dti(ph1p,D_STRING, P_HOUR); }
   | MINUTE_
     { $$ = ph1dti(ph1p,D_STRING, P_MINUTE); }
   | SECOND_
     { $$ = ph1dti(ph1p,D_STRING, P_SECOND); }
   | TIMEZONE_HOUR_
     { $$ = ph1dti(ph1p,D_STRING, P_TZ_HOUR); }
   | TIMEZONE_MINUTE_
     { $$ = ph1dti(ph1p,D_STRING, P_TZ_MINUTE); }
;

datetime_string_field :
     TIMEZONE_REGION_
     { $$ = ph1dti(ph1p,D_STRING, P_TZ_REGION); }
   | TIMEZONE_ABBR_
     { $$ = ph1dti(ph1p,D_STRING, P_TZ_ABBR); }
;  


trim_options_sim_expr:

  trim_options sim_expr
  {
    lisdef *lis;

    lis = PH1LINN($1, lismak());
    $$  = PH1LINN($2, lis);
  }
|
  trim_options
  {
    $$ = PH1LINN($1, lismak());
  }
|
  sim_expr
  {
    lisdef *lis;
    ub4     tmp;

    tmp = (ub4) ph1dti(ph1p, D_NUMERI, PHD_BOTH_ONLY_ONE_CHR_TRIMSET);
    lis = PH1LINN(tmp, lismak());
    $$  = PH1LINN($1, lis);
  }
;

trim_options:

  LEADING_
  {
    $$ = (ub4) ph1dti(ph1p, D_NUMERI, PHD_LEADING_ONLY_ONE_CHR_TRIMSET);
  }
|
  TRAILING_
  {
    $$ = (ub4) ph1dti(ph1p, D_NUMERI, PHD_TRAILING_ONLY_ONE_CHR_TRIMSET);
  }
|
  BOTH_
  {
    $$ = (ub4) ph1dti(ph1p, D_NUMERI, PHD_BOTH_ONLY_ONE_CHR_TRIMSET);
  }
;

dotted_expr:

  prefix '.' decl_id
  {
    /* 499737: Check for schema-qualified name.This code will only trigger
     * if P_SCHEMA_PREFIX is the leftmost id in a dotted name.We want this
     * behavior only when SQL calls PL/SQL; the closest approximation
     * available is anonymous blocks on the server. kglhdnsp == KGLNCRSR
     * test weeds out client-side libunits which look like anonymous blocks.
     *
     * bug 781291: check for a schema-qualified name for each component of
     * a table or view.It is used to skip the plscope prefix lookup in name
     * resolution.
     */

    if ((((plsclu->kglhdnsp == KGLNCRSR) &&
          (plsclu->kglhdobj->kglobtyp == KGLTCRSR)) ||
         (plsclu->kglhdobj->kglobtyp == KGLTTABL ||
          plsclu->kglhdobj->kglobtyp == KGLTVIEW)) &&
        (PTKIN($1) == DI_U_NAM) &&
        !strcmp((char *) l_SYMREP($1), (char *) P_SCHEMA_PREFIX))
    {
      $$ = $3;
      L_defaul($$, l_DEFAUL($$) | PHD_SCHEMA_QUALIFIER);
    }
    else
    {
      $$ = ph1dtn(ph1p, D_S_ED, 2, $1, $3);
      L_srclin($$, l_SRCLIN($3));
      L_srccol($$, l_SRCCOL($3));

      if (PTKIN($3) == DI_U_NAM)
        L_defaul($3, PHD_NAME_RHS);

      if (ph1nln(ph1p, $1) >= 3)
        PH1FLAG(1456, $$);
    }
  }
;

/* This is a change from ADA - no way around this.Note that the % doesn't */
/* need to be contiguous - do we wish to allow this?                      */

attribute:

  prefix '%' attribute_designator
  {
    $$ = ph1dtn(ph1p, D_ATTRIB, 2, $1, $3);
  }
|
  SQL_ '%' attribute_designator
  {
    $$ = ph1dtn(ph1p, D_ATTRIB, 2, TRENULL, $3);
  }
;

/*  This can be an attribute, idxed cmpon, slice, or subprg call. */

attribute_designator:

  identifier
|
  TYPE_
  {
    /* pretend this is a sim_n */
    $$ = ph1dti(ph1p, DI_U_NAM, (text *)"TYPE");
    L_defaul($$, PHD_QUOTED_ID);
  }
;

empty_parens_opt:

  /* empty */
  {
    $$ = lismak();
  }
|
  '(' ')'
  {
    $$ = lismak();
  }
;



/************ IS [NOT] OF **************/

is_of_modifier : 

  /* empty */ 
  { 
    $$ = T_NONE; 
  } 
| 
  ONLY_ 
  { 
    $$ = T_ONLY; 
  } 
; 

user_defined_type_name : 

  is_of_modifier dotted_name 
  { 
    /* Bug 2699883: move location of ONLY bit to phdleafnam() */
    ptnod typename = phdleafnam(pgap, $2); 

    if (T_ONLY == $1) 
      L_defaul(typename, (l_DEFAUL(typename) | PHD_ONLY_MODIFIER)); 

    $$ = $2; 
  } 
| 
  /* 
   * Without this rule, when the parser sees an 
   * ONLY (in is_of_modifier above), it will expect
   * to see a typename. Thus we have to have a special case rule for 
   * "IS OF (ONLY)", 
   * where "ONLY" need (in ph2imx.c) be an ADT.
   * We build a DI_U_NAM("ONLY") for this case.
   */
  ONLY_ 
  { 
    $$ = ph1dti(ph1p, DI_U_NAM, P_ONLY); 
  } 
; 

user_defined_type_name_list : 

  user_defined_type_name 
  { 
    $$ = PH1LINN($1, lismak()); 
  } 
| 
  user_defined_type_name_list ',' user_defined_type_name 
  { 
    $$ = PH1LAPN($3, $1); 
  } 
; 
  

type_aggr: 

  '(' user_defined_type_name_list ')' 
  { 
    $$ = $2; 
  } 
; 

is_of_predicate: 

  is_prefix NOT_opt OF_ type_aggr 
  { 
    ptnod callname; 
    ptnod args;

    if ($2 == T_NOT) /* unless we make this not(is of()) */ 
      callname = ph1dti(ph1p, DI_U_NAM, (text *)P_IS_NOT_OF); 
    else 
      callname = ph1dti(ph1p, DI_U_NAM, (text *)P_IS_OF); 
    L_defaul(callname, PHD_BUILTIN_NAME); 

    args = (ptnod)ph1nfs(ph1p, PH1LINN($1, $4), D_F_CALL); 

    $$ = ph1dtn(ph1p, D_F_CALL, 2, callname, args); 
  } 
; 

/******************** end of IS OF *******************/


paren_expr_list:

  /* when this is used in other contexts, must rename or perhaps inspect the */
  /* first one - yes oops, we return list - it's up to someone else          */

  '(' arg arg_list ')'
  {
    $$ = PH1LINN($2, $3);
  }
;

/* the new aggr that includes interval expression */

paren_aggr:

  '(' assoc_arg arg_list ')'
  {
    $$ = ph1ncg(ph1p, PH1LINN($2, $3), D_PARENT);
  }
|
  '(' expr arg_list ')'
  {
    $$ = ph1ncg(ph1p,PH1LINN($2,$3),D_PARENT);
  }
|
  '(' expr arg_list ')' constrained_interval_return_type
  {
    /* code is similar to translate.Note that we ignore the constraint */
    ptnod tree;

    /* $3 better be null, it is only there for s/r conflicts we should check */
    /* that the original operator is '-' and that this was a call            */

    if ($3 || PTKIN($2) != D_F_CALL ||
        (strcmp((char*)l_SYMREP(a_NAME($2)), (char *)P_SUBTRACT)))
    {
      /* get errors by setting arg list null */
      tree = ph1mak(ph1p, DS_P_ASS);
      AS_list(tree, lismak());
    }
    else
      tree = as_P_ASS($2);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, $5, tree);
  }
;


arg:

  expr
|
  assoc_arg
;

assoc_arg:

  sim_expr ARROW_ expr
  {                         /* assume that its an assoc if only one 'choice' */
    $$ = ph1dtn(ph1p, D_ASSOC, 2, (ub4)$1, (ub4)$3);
  }
|
  cursor_subquery
;

/* Multiset Enhancements */

multiset_value_expression : 
  combinable_multiset_expr multiset_op_union_except multiset_term_or_primary
  {
    ub4 tmp1 = (ub4)ph1nfs(ph1p,
                           PH1LINN($1, PH1LINN($3, lismak())),
                                   (ub4)D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, (ub4)$2, tmp1);
  }
|
  multiset_term
  ;  


multiset_term_or_primary:
  multiset_term
|
  multiset_primary
;


multiset_term:
  combinable_multiset_term multiset_op_intersect multiset_primary
  {
    ub4 tmp1 = (ub4)ph1nfs(ph1p,
                           PH1LINN($1, PH1LINN($3, lismak())),
                                   (ub4)D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, (ub4)$2, tmp1);
  }
;


combinable_multiset_expr:
  combinable_multiset_expr multiset_op_union_except combinable_multiset_term
  {
    ub4 tmp1 = (ub4)ph1nfs(ph1p,
                           PH1LINN($1, PH1LINN($3, lismak())),
                                   (ub4)D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, (ub4)$2, tmp1);
  }
 |
  combinable_multiset_term
  ;  


combinable_multiset_term:
 
 combinable_multiset_term multiset_op_intersect combinable_multiset_primary
  {
    ub4 tmp1 = (ub4)ph1nfs(ph1p,
                           PH1LINN($1, PH1LINN($3, lismak())),
                                   (ub4)D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, (ub4)$2, tmp1);
  }
 |
 combinable_multiset_primary
;


combinable_multiset_primary:
  multiset_primary MULTISET_
  ;

multiset_primary:
  pri
  {
    $$ = $1;
  }
;




/* this is the common expression syntax we might use other techniques for   */
/* this well (if too large)                                                 */

/* subquery will now be different than a sim_expr (although we may (later?) */
/* allow a subquery to BE a sim_expr)                                       */

/* The AND THEN and OR ELSE constructs are now AND and OR.Note that we      */
/* haven't included the other AND,OR and XOR here */

expr:

  expr OR_ and_expr
  {
    ub4 tmp1 = (ub4)ph1dtn(ph1p, D_OR_ELS, 0);
    $$ = ph1dtn(ph1p, D_BINARY, 3, (ub4)$1, tmp1, (ub4)$3);
  }
|
  and_expr
  {
    $$ = $1;
  }
;

and_expr:

  and_expr AND_ rel
  {
    ub4 tmp1 = (ub4)ph1dtn(ph1p, D_AND_TH, 0);
    $$ = ph1dtn(ph1p, D_BINARY, 3, (ub4)$1, tmp1, (ub4)$3);
  }
|
  rel
  {
    $$ = $1;
  }
;

rel:

  boolean_primary
  {
    $$ = $1;
  }
|
  NOT_ boolean_primary
  { 
    ub4 tmp1 = (ub4)ph1dti(ph1p, D_USED_O, (text *)"NOT");
    ub4 tmp2 = (ub4)ph1nfs(ph1p, PH1LINN($2, lismak()), D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, tmp1, tmp2);
  }
;

boolean_primary:         /* these are booleans in the non-trivial derivation */

  sim_expr relal_op_sim_expr_opt
  {
    if ( $2 == TRENULL )
    {
      $$ = $1;
    }
    else
    {
      /* a function call is already constructed - add param */
      AS_list(as_P_ASS($2), PH1LINN($1, as_LIST(as_P_ASS($2))));
      $$ = $2;
    }
  }
|
  member_predicate
|
  comparison_predicate
|
  between_predicate                            /* alternative to .. notation */
|
  in_predicate
|
  like_predicate
|
  null_predicate
|
  is_of_predicate
|
  dangling_predicate

  /* quantified covered in relal_op's */
|
  exists_predicate
|
  overlaps_predicate
|
  nan_predicate
|
  infinite_predicate
|
  multiset_boolean_expr
|
  json_predicate
;


member_predicate:
  sim_expr MEMBER_ OF_opt sim_expr
  {
    ub4 fn_name = ph1dti(ph1p, DI_U_NAM, (text *)"MEMBER OF");
    L_defaul(fn_name, PHD_BUILTIN_NAME);
    $$ = ph1dtn(ph1p,D_MEMBER, 3, (ub4)$1, fn_name, (ub4)$4);
  } 
|
  sim_expr  NOT_ MEMBER_ OF_opt sim_expr
  { 
    /* Create NOT(sim_expr member_of_ sim_expr) */
    ub4 fn_name = ph1dti(ph1p, DI_U_NAM, (text *)"MEMBER OF");
    ub4 member_fn = ph1dtn(ph1p,D_MEMBER, 3, (ub4)$1, fn_name, (ub4)$5);
    ub4 not_id = (ub4)ph1dti(ph1p, D_USED_O, (text *)"NOT");
    ub4 arg_list = (ub4)ph1nfs(ph1p, PH1LINN(member_fn, lismak()), D_F_CALL);

    L_defaul(fn_name, PHD_BUILTIN_NAME);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, not_id, arg_list);
  }
;

multiset_boolean_expr:
 set_predicate
|
 empty_predicate
|
 submultiset_predicate 

 /* |  2 r/r if here rather than relop 
 member_predicate   */
;


sim_expr:

  multiset_value_expression
  {
    $$ = $1;
  }
|
  arith_expr
  {
    $$ = $1;
  }
;

term:

  factor
|
  term mult_op factor
  {
      ub4 tmp1 = (ub4)ph1nfs(ph1p,
                             PH1LINN($1, PH1LINN($3, lismak())),
                             D_F_CALL);
      $$ = ph1dtn(ph1p, D_F_CALL, 2, (ub4)$2, tmp1);
  }
;

factor:

  pri EXP_pri_opt
  {
    if ($2 == TRENULL)
    {
      $$ = $1;
    }
    else
    {
      ub4 tmp1 = (ub4)ph1dti(ph1p, D_USED_O, (text *)"**");
      ub4 tmp2 = (ub4)ph1nfs(ph1p,
                             PH1LINN($1,
                                     PH1LINN($2, lismak())), (ub4)D_F_CALL);
      $$ = ph1dtn(ph1p, D_F_CALL, 2, tmp1, tmp2);
    }
  }
|
  pri AT_ time_zone_specifier
  {
    /* AT is a terminal and thus there is no capture issue for */
    /*        select ename at from dual...                     */
    /*     as AT cannot be an id in pl/sql.                    */

    ub4 tmp1 = (ub4)ph1dti(ph1p, DI_U_NAM, (text *)"SYS_AT_TIME_ZONE");
    ub4 tmp2 = (ub4)ph1nfs(ph1p,
                           PH1LINN($1,
                                   PH1LINN($3, lismak())), (ub4)D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, tmp1, tmp2);
  }
|
  unary_add_op factor
  {
    ub4 tmp1 = (ub4)ph1nfs(ph1p, PH1LINN($2, lismak()), (ub4)D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, (ub4)$1, tmp1);
  }
;

cast_expression_arg:

  collection_value_expression
;

cast_conversion_error:
  DEFAULT_ sim_expr ON_ CONVERSION_ ERROR_
  {
    $$ = $2;
  }
;

cast_nls_params:
  ',' sim_expr
  {
    $$ = PH1LINN($2, lismak());
  }
|
  ',' sim_expr ',' sim_expr
  {
    $$ = PH1LINN($2, PH1LINN($4, lismak()));
  }
;

pri:

  numeric_literal
  {
    $$ = ph1dti(ph1p, D_NUMERI, $1);
  }
|
  alternatively_quoted_string_literal 
  {
    $$ = ph1dti(ph1p, D_STRING, $1);
  }
|
  string_literal 
  {
    $$ = ph1dti(ph1p, D_STRING, $1);
  }
|
  alternatively_quoted_nonnative_string_literal
  {
    $$ = $1;
  }
|
  nonnative_string_literal
  {
    $$ = $1;
  }
|
  datetime_literal
  {
    $$ = $1;
  }
|
  NULL_
  {
    $$ = ph1mak(ph1p, D_NULL_A);
    PH1FLAG(1413, $$);
  }
|
  procedure_call
  {
    /*
     * A procedure call in an expression looks syntactically like a
     * function call which is what we are looking for here.  A procedure_
     * call node will build a D_APPLY and the name will be a Q_LINK node
     * in the case where it is a remote function call and just a regular
     * name node in the non-remote case.Note that an identifier is covered
     * as procedure_call->name->name_wo_function_call->sim_n->identifier
     */

    $$ = $1;
  }
| 
  NEW_ 
  {
    /* This rule is for NEW adt_constructor or NEW.captured... */
    pxtokn *la;

    /* first assert that ph1p->ph1tot = NEW_ */
    PPPASR((ph1p->ph1tot == NEW_),PLSUNIQ(98));

    /* Take a peek at next symbol and then push it back */
    la = PXGETTOK((pgstrm *)0, cs, PXGETNEXT);
    DISCARD PXGETTOK((pgstrm *)0, cs, PXUNGET, la);

    /* 
       This is not  NEW_ id or NEW_ idq 
       ie it is new( or new; new., new +-*
       */
    if (PLSISA8(pxtgid(la), id, idq, 
                NEW_, MERGE_, FORALL_, PIPE_, EXECUTE_, PURGE_)) 
    {
      $1 = NEW_;
    }
    else 
    {
      /* Saw a new but not a constructor */ 
   
      /* turn this NEW_ into an id, push it back so that it can be
       * shifted as id
       */
      pxtokn *current =
        (pxtokn *)hepnff(plskgp, plschp, (b4)sizeof(pxtokn),
                         FALSE, "plsql.y:NEW_");
      ph1p->ph1tot = id;
      ph1p->ph1ytr = ph1dti(ph1p, DI_U_NAM, (const text *)"NEW");
      ph1mtk(ph1p, current);
      current->column = (ub2)SRCLINE(1);
      current->line = SRCCOL(1);
      DISCARD PXGETTOK((pgstrm *)0, cs, PXUNGET, current);
      $1 = id;
    }
    /* end of NEW_ */
  }
 procedure_call 
 { 
   if ($1 == NEW_) /* NEW adt_constructor */ 
     { 
       ptnod name = PHD_CALL_NAME($3);
       if (name) L_defaul(name, PHD_NEW_MODIFIER);  
     } 
   $$ = $3; 
 }
|
  paren_aggr
  {
    /* the paranthesized expression */
    $$ = $1;
    PH1FLAG(1415, $$);
  }
|
  set_function_specification
| 
  case_expr
|
  '(' expr AS_ unconstrained_type ')'
   {
     ub2 flags = 0;
     bis(flags, PHD_CONVER_GENERALIZED_INVOCATION);
     $$ = ph1dtn(ph1p, D_CONVER, 5, (ub4)$4, (ub4)$2, (ub4)TRENULL, (ub4)0,
                 (ub2) flags);
   }
|
  gen_call 
;

comparison_predicate:

  sim_expr relal_op old_subquery
  {
    ub4 tmp1 = (ub4)ph1nfs(ph1p,
                           PH1LINN($1, PH1LINN($3, lismak())),
                                   (ub4)D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, (ub4)$2, tmp1);
  }
;

json_predicate:
  is_json
;

is_json_options_opt:
  /* empty */
  {
    $$ = 0;
  }
|
  '(' lax_strict_opt unique_keys_opt ')'
  {
    $$ = $2 | $3;
  }
;

lax_strict_opt:
  /* empty */
  {
    $$ = 0;
  }
|
  LAX_
  {
    $$ = PLS_JSON_LAX;
  }
|
  STRICT_
  {
    $$ = PLS_JSON_STRICT;
  }
;

unique_keys_opt:
  /* empty */
  {
    $$ = 0;
  }
|
  WITH_ UNIQUE_ KEYS_
  {
    $$ = PLS_JSON_UNIQUE_KEYS;
  }
|
  WITHOUT_ UNIQUE_ KEYS_
  {
    $$ = 0;
  }
;

is_json:
  is_prefix NOT_opt JSON_ is_json_options_opt
  {
    ptnod            fname   = ph1dti(ph1p, DI_U_NAM, P_SYS_STANDARD_JSON);
    ub4              options = PLS_JSON_RET_BOOL | $4;
    ptnod            call;
    ptnod            opcode_node;
    ptnod            options_node;
    pls_json_subcode op;

    if ($2 == T_NOT)
      op = PLS_JSON_ISNOTJSON;
    else
      op = PLS_JSON_ISJSON;

    opcode_node  = phd_build_int(pgap, SRCLINE(1), SRCCOL(1), (sb4)op);
    options_node = phd_build_int(pgap, SRCLINE(4), SRCCOL(4), (sb4)options);

    L_defaul(fname, PHD_BUILTIN_NAME);

    /* The arguments to the JSON operator function are the operator subcode,
     * the JSON string, the path expression, the return format string, the
     * default on error string, and flags.
     */
    call = ph1nfs(ph1p, PH1LINN(opcode_node,
                        PH1LINN($1,
                        PH1LINN(ph1mak(ph1p, D_NULL_A),
                        PH1LINN(ph1mak(ph1p, D_NULL_A),
                        PH1LINN(ph1mak(ph1p, D_NULL_A),
                        PH1LINN(options_node, lismak())))))),
                  D_F_CALL);
    $$   = ph1dtn(ph1p, D_F_CALL, 2, fname, call);
  }
;

json_operator:
  json_value
|
  json_exists
|
  json_query
|
  json_object
|
  json_array
;

json_format_opt:
  /* empty */
  {
    $$ = PLS_JSON_FORMAT_JSON;
  }
|
  FORMAT_ BSON_
  {
    $$ = PLS_JSON_FORMAT_BSON;
  }
|
  FORMAT_ JSON_
  {
    $$ = PLS_JSON_FORMAT_JSON;
  }
;

json_exists_error_opt:
  /* empty */
  {
    $$ = PLS_JSON_FALSE_ON_ERROR;
  }
|
  ERROR_ ON_ ERROR_
  {
    $$ = PLS_JSON_ERROR_ON_ERROR;
  }
|
  TRUE_ ON_ ERROR_
  {
    $$ = PLS_JSON_TRUE_ON_ERROR;
  }
|
  FALSE_ ON_ ERROR_
  {
    $$ = PLS_JSON_FALSE_ON_ERROR;
  }
;

json_exists:
  JSON_EXISTS_ '(' expr json_format_opt ',' expr json_exists_error_opt ')'
  {
    ptnod            fname   = ph1dti(ph1p, DI_U_NAM, P_SYS_STANDARD_JSON);
    ub4              options = PLS_JSON_RET_BOOL | $4 | $7;
    ptnod            call;
    ptnod            opcode_node;
    ptnod            options_node;
    pls_json_subcode op = PLS_JSON_EXISTS;

    opcode_node  = phd_build_int(pgap, SRCLINE(1), SRCCOL(1), (sb4)op);
    options_node = phd_build_int(pgap, SRCLINE(7), SRCCOL(7), (sb4)options);

    L_defaul(fname, PHD_BUILTIN_NAME);

    /* The arguments to the JSON operator function are the operator subcode,
     * the JSON string, the path expression, the return format string, the
     * default on error string, and flags.
     */
    call = ph1nfs(ph1p, PH1LINN(opcode_node,
                        PH1LINN($3,
                        PH1LINN($6,
                        PH1LINN(ph1mak(ph1p, D_NULL_A),
                        PH1LINN(ph1mak(ph1p, D_NULL_A),
                        PH1LINN(options_node, lismak())))))),
                  D_F_CALL);
    $$   = ph1dtn(ph1p, D_F_CALL, 2, fname, call);
  }
;

json_datetime_format_opt:
  /* empty */
  {
    $$ = ph1mak(ph1p, D_NULL_A);
  }
|
  FORMAT_ string_literal
  {
    $$ = ph1dti(ph1p, D_STRING, $2);
  }
;

json_value_returning_opt:
  /* empty */
  {
    $$ = PH1LINN(ph1mak(ph1p, D_NULL_A),
                 PH1LINU(PLS_JSON_RET_VC2,
                         lismak()));
  }
|
  RETURNING_ VARCHAR2_
  {
    $$ = PH1LINN(ph1mak(ph1p, D_NULL_A),
                 PH1LINU(PLS_JSON_RET_VC2,
                         lismak()));
  }
|
  RETURNING_ RAW_
  {
    $$ = PH1LINN(ph1mak(ph1p, D_NULL_A),
                 PH1LINU(PLS_JSON_RET_RAW,
                         lismak()));
  }
|
  RETURNING_ NUMBER_
  {
    $$ = PH1LINN(ph1mak(ph1p, D_NULL_A),
                 PH1LINU(PLS_JSON_RET_NUM,
                         lismak()));
  }
|
  RETURNING_ BOOLEAN_
  {
    $$ = PH1LINN(ph1mak(ph1p, D_NULL_A),
                 PH1LINU(PLS_JSON_RET_BOOL,
                         lismak()));
  }
|
  RETURNING_ SDO_GEOMETRY_
  {
    $$ = PH1LINN(ph1mak(ph1p, D_NULL_A),
                 PH1LINU(PLS_JSON_RET_SDO_GEOMETRY,
                         lismak()));
  }
|
  RETURNING_ BLOB_
  {
    $$ = PH1LINN(ph1mak(ph1p, D_NULL_A),
                 PH1LINU(PLS_JSON_RET_BLOB,
                         lismak()));
  }
|
  RETURNING_ CLOB_
  {
    $$ = PH1LINN(ph1mak(ph1p, D_NULL_A),
                 PH1LINU(PLS_JSON_RET_CLOB,
                         lismak()));
  }
|
  RETURNING_ DATE_ json_datetime_format_opt
  {
    $$ = PH1LINN($3,
                 PH1LINU(PLS_JSON_RET_DATE,
                         lismak()));
  }
|
  RETURNING_ TIMESTAMP_ json_datetime_format_opt
  {
    $$ = PH1LINN($3,
                 PH1LINU(PLS_JSON_RET_TSTP,
                         lismak()));
  }
|
  RETURNING_ TIMESTAMP_ WITH_ TIME_ ZONE_ json_datetime_format_opt
  {
    $$ = PH1LINN($6,
                 PH1LINU(PLS_JSON_RET_TSTZ,
                         lismak()));
  }
;

ascii_opt:
  /* empty */
  {
    $$ = 0;
  }
|
  ASCII_
  {
    $$ = PLS_JSON_ASCII;
  }
;

json_value_error_opt:
  /* empty */
  {
    $$ = PH1LINN(ph1mak(ph1p, D_NULL_A),
                 PH1LINU(PLS_JSON_NULL_ON_ERROR,
                         lismak()));
  }
|
  ERROR_ ON_ ERROR_
  {
    $$ = PH1LINN(ph1mak(ph1p, D_NULL_A),
                 PH1LINU(PLS_JSON_ERROR_ON_ERROR,
                         lismak()));
  }
|
  NULL_ ON_ ERROR_
  {
    $$ = PH1LINN(ph1mak(ph1p, D_NULL_A),
                 PH1LINU(PLS_JSON_NULL_ON_ERROR,
                         lismak()));
  }
|
  DEFAULT_ expr ON_ ERROR_
  {
    $$ = PH1LINN($2,
                 PH1LINU(PLS_JSON_DEFAULT_ON_ERROR,
                         lismak()));
  }
;

json_value:
  JSON_VALUE_ '(' expr json_format_opt ',' expr json_value_returning_opt
                  ascii_opt json_value_error_opt ')'
  {
    ptnod            fname   = ph1dti(ph1p, DI_U_NAM, P_SYS_STANDARD_JSON);
    ub4              options = $4 | liscau(liscdr($7)) | $8 |
                               liscau(liscdr($9));
    ptnod            call;
    ptnod            opcode_node;
    ptnod            options_node;
    pls_json_subcode op = PLS_JSON_VALUE;

    opcode_node  = phd_build_int(pgap, SRCLINE(1), SRCCOL(1), (sb4)op);
    options_node = phd_build_int(pgap, SRCLINE(7), SRCCOL(7), (sb4)options);

    L_defaul(fname, PHD_BUILTIN_NAME);

    /* The arguments to the JSON operator function are the operator subcode,
     * the JSON string, the path expression, the return format string, the
     * default on error string, and flags.
     */
    call = ph1nfs(ph1p, PH1LINN(opcode_node,
                        PH1LINN($3,
                        PH1LINN($6,
                        PH1LINN(liscar($7),
                        PH1LINN(liscar($9),
                        PH1LINN(options_node, lismak())))))),
                  D_F_CALL);
    $$   = ph1dtn(ph1p, D_F_CALL, 2, fname, call);
  }
;

json_char_returning_opt:
  /* empty */
  {
    $$ = PLS_JSON_RET_VC2;
  }
|
  RETURNING_ VARCHAR2_
  {
    $$ = PLS_JSON_RET_VC2;
  }
|
  RETURNING_ RAW_
  {
    $$ = PLS_JSON_RET_RAW;
  }
|
  RETURNING_ BLOB_
  {
    $$ = PLS_JSON_RET_BLOB;
  }
|
  RETURNING_ CLOB_
  {
    $$ = PLS_JSON_RET_CLOB;
  }
;

pretty_opt:
  /* empty */
  {
    $$ = 0;
  }
|
  PRETTY_
  {
    $$ = PLS_JSON_PRETTY;
  }
;

json_query_error_opt:
  /* empty */
  {
    $$ = PLS_JSON_EMPTY_ON_ERROR;
  }
|
  ERROR_ ON_ ERROR_
  {
    $$ = PLS_JSON_ERROR_ON_ERROR;
  }
|
  NULL_ ON_ ERROR_
  {
    $$ = PLS_JSON_EMPTY_ON_ERROR;
  }
;

json_wrap_opt:
  /* empty */
  {
    $$ = 0;
  }
|
  WITHOUT_ ARRAY_ WRAPPER_
  {
    $$ = 0;
  }
|
  WITHOUT_ WRAPPER_
  {
    $$ = 0;
  }
|
  WITH_ UNCONDITIONAL_ ARRAY_ WRAPPER_
  {
    $$ = PLS_JSON_UC_WRAPPER;
  }
|
  WITH_ UNCONDITIONAL_ WRAPPER_
  {
    $$ = PLS_JSON_UC_WRAPPER;
  }
|
  WITH_ ARRAY_ WRAPPER_
  {
    $$ = PLS_JSON_UC_WRAPPER;
  }
|
  WITH_ WRAPPER_
  {
    $$ = PLS_JSON_UC_WRAPPER;
  }
|
  WITH_ CONDITIONAL_ ARRAY_ WRAPPER_
  {
    $$ = PLS_JSON_C_WRAPPER;
  }
|
  WITH_ CONDITIONAL_ WRAPPER_
  {
    $$ = PLS_JSON_C_WRAPPER;
  }
;

json_query:
  JSON_QUERY_ '(' expr json_format_opt ',' expr json_char_returning_opt
                  pretty_opt ascii_opt json_wrap_opt json_query_error_opt ')'
  {
    ptnod            fname   = ph1dti(ph1p, DI_U_NAM, P_SYS_STANDARD_JSON);
    ub4              options = $4 | $7 | $8 | $9 | $10 | $11;
    ptnod            call;
    ptnod            opcode_node;
    ptnod            options_node;
    pls_json_subcode op = PLS_JSON_QUERY;

    opcode_node  = phd_build_int(pgap, SRCLINE(1), SRCCOL(1), (sb4)op);
    options_node = phd_build_int(pgap, SRCLINE(7), SRCCOL(7), (sb4)options);

    L_defaul(fname, PHD_BUILTIN_NAME);

    /* The arguments to the JSON operator function are the operator subcode,
     * the JSON string, the path expression, the return format string, the
     * default on error string, and flags.
     */
    call = ph1nfs(ph1p, PH1LINN(opcode_node,
                        PH1LINN($3,
                        PH1LINN($6,
                        PH1LINN(ph1mak(ph1p, D_NULL_A),
                        PH1LINN(ph1mak(ph1p, D_NULL_A),
                        PH1LINN(options_node, lismak())))))),
                  D_F_CALL);
    $$   = ph1dtn(ph1p, D_F_CALL, 2, fname, call);
  }
;

json_name_value_pair:
  is_prefix expr
  {
    $$ = PH1LINN($1, PH1LINN($2, lismak()));
  }
;

json_name_value_pair_list:
  json_name_value_pair
  {
    $$ = $1;
  }
|
  json_name_value_pair_list ',' json_name_value_pair
  {
    $$ = PH1LCAT($1, $3);
  }
;

json_null_opt:
  /* empty */
  {
    $$ = 0;
  }
|
  NULL_ ON_ NULL_
  {
    $$ = 0;
  }
|
  ABSENT_ ON_ NULL_
  {
    $$ = PLS_JSON_ABSENT_ON_NULL;
  }
;

strict_opt:
  /* empty */
  {
    $$ = 0;
  }
|
  STRICT_
  {
    $$ = PLS_JSON_STRICT;
  }
;

json_object:
  JSON_OBJECT_ '(' json_name_value_pair_list json_null_opt
                   json_char_returning_opt strict_opt ')'
  {
    ptnod            fname   = ph1dti(ph1p, DI_U_NAM, P_SYS_STANDARD_JSON);
    ub4              options = $4 | $5 | $6;
    ptnod            call;
    ptnod            opcode_node;
    ptnod            options_node;
    pls_json_subcode op = PLS_JSON_OBJECT;

    opcode_node  = phd_build_int(pgap, SRCLINE(1), SRCCOL(1), (sb4)op);
    options_node = phd_build_int(pgap, SRCLINE(4), SRCCOL(4), (sb4)options);

    L_defaul(fname, PHD_BUILTIN_NAME);

    /* The arguments to the JSON operator function are the operator subcode,
     * the JSON string, the path expression, the return format string, the
     * default on error string, and flags.
     * JSON_OBJECT and JSON_ARRAY use the JSON string slot for the expression
     * vector.
     */
    call = ph1nfs(ph1p, PH1LINN(opcode_node,
                        PH1LCAT($3,
                        PH1LINN(ph1mak(ph1p, D_NULL_A),
                        PH1LINN(ph1mak(ph1p, D_NULL_A),
                        PH1LINN(ph1mak(ph1p, D_NULL_A),
                        PH1LINN(options_node, lismak())))))),
                  D_F_CALL);
    $$   = ph1dtn(ph1p, D_F_CALL, 2, fname, call);
  }
;

json_array_expr_list:
  expr
  {
    $$ = PH1LINN($1, lismak());
  }
|
  json_array_expr_list ',' expr
  {
    $$ = PH1LAPN($3, $1);
  }
;

json_array:
  JSON_ARRAY_ '(' json_array_expr_list json_null_opt json_char_returning_opt 
                  strict_opt ')'
  {
    ptnod            fname   = ph1dti(ph1p, DI_U_NAM, P_SYS_STANDARD_JSON);
    ub4              options = $4 | $5 | $6;
    ptnod            call;
    ptnod            opcode_node;
    ptnod            options_node;
    pls_json_subcode op = PLS_JSON_ARRAY;

    opcode_node  = phd_build_int(pgap, SRCLINE(1), SRCCOL(1), (sb4)op);
    options_node = phd_build_int(pgap, SRCLINE(4), SRCCOL(4), (sb4)options);

    L_defaul(fname, PHD_BUILTIN_NAME);

    /* The arguments to the JSON operator function are the operator subcode,
     * the JSON string, the path expression, the return format string, the
     * default on error string, and flags.
     * JSON_OBJECT and JSON_ARRAY use the JSON string slot for the expression
     * vector.
     */
    call = ph1nfs(ph1p, PH1LINN(opcode_node,
                        PH1LCAT($3,
                        PH1LINN(ph1mak(ph1p, D_NULL_A),
                        PH1LINN(ph1mak(ph1p, D_NULL_A),
                        PH1LINN(ph1mak(ph1p, D_NULL_A),
                        PH1LINN(options_node, lismak())))))),
                  D_F_CALL);
    $$   = ph1dtn(ph1p, D_F_CALL, 2, fname, call);
  }
;

datetime_literal :

  datetime_link_expanded_n  /* avoiding captures */
|
  TIME_ string_literal 
  {
    ptnod name, call;
    lisdef *lis;
    const oratext *function = P_LITERALTOTIME;
    LdiDateTime value;
    
    /* Check literal for correctness */
    if (LdiDateFromLiteral(plslan, plsnglo, plsovr, $2,
                           (ub4) strlen((char *) $2),
                           LDITIME, &value, plsdst) != LDI_SUCCESS)
      PH1ERR(166, SEVSEVER, $1, PLSUNIQ(8));
    else if (value.type_LdiDateTime == LDITZTIME)
      {
        function = P_LITERALTOTZTIME;
      }
    
    name = ph1dti(ph1p, DI_U_NAM, function);
    L_defaul(name, PHD_BUILTIN_NAME);
    
    /* Build the argument list */
    lis = PH1LINN(ph1dti(ph1p, D_STRING, $2) ,lismak());
    
    call = ph1nfs(ph1p, lis, D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, (ub4) name, (ub4) call);
  }
| 
  TIMESTAMP_ string_literal 
  {
    ptnod name, call;
    lisdef *lis;
    const oratext *function = P_LITERALTOTIMESTAMP;
    LdiDateTime value;
    
    /* Check literal for correctness */
    if (LdiDateFromLiteral(plslan, plsnglo, plsovr, $2,
                           (ub4) strlen((char *) $2),
                           LDISTAMP, &value, plsdst) != LDI_SUCCESS)
      PH1ERR(166, SEVSEVER, $1, PLSUNIQ(9));
    else if (value.type_LdiDateTime == LDITZSTAMP)
      {
        function = P_LITERALTOTZTIMESTAMP;
      }
    
    name = ph1dti(ph1p, DI_U_NAM, function);
    L_defaul(name, PHD_BUILTIN_NAME);
    
    /* Build the argument list */
    lis = PH1LINN(ph1dti(ph1p, D_STRING, $2) ,lismak());
    
    call = ph1nfs(ph1p, lis, D_F_CALL);
    $$ = ph1dtn(ph1p,D_F_CALL, 2, (ub4) name, (ub4) call);
  }
| 
  DATE_ string_literal 
  {
    ptnod name, call;
    lisdef *lis;
    LdiDateTime value;
    
    /* Check the literal for correctness */
    if (LdiDateFromLiteral(plslan, plsnglo, plsovr, $2,
                           (ub4) strlen((char *) $2),
                           LDIDATE, &value, plsdst) != LDI_SUCCESS)
      PH1ERR(166, SEVSEVER, $1, PLSUNIQ(10));
    
    name = ph1dti(ph1p, DI_U_NAM, P_LITERALTODATE);
    L_defaul(name, PHD_BUILTIN_NAME);
    
    /* Build the argument list */
    lis = PH1LINN(ph1dti(ph1p, D_STRING, $2) ,lismak());
    
    call = ph1nfs(ph1p, lis, D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, (ub4) name, (ub4) call);
  }
| 
  interval_literal;

/* I have removed iconstraint_opt from second and interval_range_qualifier 
   until we find a way to enforce them in literals (return values) */

interval_literal_qualifier : 
  YEAR_ TO_ MONTH_  
  { 
    $$ = LDIINTYEARMONTH; 
  }
| 
  DAY_ TO_ SECOND_
  { 
    $$ = LDIINTDAYSECOND; 
  }
| 
  YEAR_
  { 
    $$ = LDIINTYEAR; 
  }
|
  MONTH_ 
  {
    $$ = LDIINTMONTH; 
  }
|
  DAY_ 
  {
    $$ = LDIINTDAY; 
  }
|
  HOUR_ 
  {
    $$ = LDIINTHOUR;
  }
|
  MINUTE_
  {
    $$ = LDIINTMINUTE; 
  }
|
  SECOND_  
  { 
    $$ = LDIINTSECOND;
  };

interval_literal  :
  INTERVAL_ string_literal interval_literal_qualifier
  { 
    ptnod fieldarg,stringarg,name,call;
    lisdef *lis;
    LdiInterval value;       
    CONST text *field;
    CONST text *callname;

    switch ($3)
    {
    case LDIINTYEARMONTH: 
      field = P_YEAR_TO_MONTH; callname = P_LITERALTOYMINTERVAL; break;
    case LDIINTDAYSECOND: 
      field = P_DAY_TO_SECOND; callname = P_LITERALTODSINTERVAL; break;
    case LDIINTYEAR  :  
      field = P_YEAR; callname = P_LITERALTOYMINTERVAL; break;
    case LDIINTMONTH :  
      field = P_MONTH; callname = P_LITERALTOYMINTERVAL; break;
    case LDIINTDAY    :  
      field = P_DAY; callname = P_LITERALTODSINTERVAL; break;
    case LDIINTHOUR   :  
      field = P_HOUR; callname = P_LITERALTODSINTERVAL; break;
    case LDIINTMINUTE :  
      field = P_MINUTE; callname = P_LITERALTODSINTERVAL; break;
    case LDIINTSECOND :  
      field = P_SECOND; callname = P_LITERALTODSINTERVAL; break;
    default : PPPASR(FALSE,PLSUNIQ(99)); /* NOTREACHED */
    }
 
    name = ph1dti(ph1p, DI_U_NAM, callname); 
    L_defaul(name, PHD_BUILTIN_NAME);
 
    fieldarg = ph1dti(ph1p,D_STRING,field);
  
    /* Check literal for correctness */
    if (LdiInterFromString(plslan, plsnglo,  
                           $2, (ub4) strlen((char *) $2),
                           LDIPOSITIVE, (ub1) $3, &value) 
        != LDI_SUCCESS)
      PH1ERR(166, SEVSEVER, $1, PLSUNIQ(11));

    stringarg = (ub4)ph1dti(ph1p,D_STRING,$2); 
    lis = PH1LINN(stringarg,PH1LINN(fieldarg,lismak()));
    call=  ph1nfs(ph1p,lis, D_F_CALL);
    $$ = ph1dtn(ph1p,D_F_CALL,2, name, (ub4)call);
  }
;

relal_op:

  /* We include the quantified operators (ANY, SOME, etc.) here as well.They */
  /* may be used in inappropriate contexts, and caught during semantics      */

  '='
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"=");
  }
|
  NOTEQL_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"!=");
    PH1FLAG(1473, $$);
  }
|
  BOX_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"!=");
  }
|
  '<'
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"<");
  }
|
  LTEQ_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"<=");
  }
|
  '>'
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)">");
  }
|
  GTEQL_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)">=");
  }
|
  '=' ANY_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"=ANY");
  }
|
  NOTEQL_ ANY_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"!=ANY");
    PH1FLAG(1473, $$);
  }
|
  BOX_ ANY_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"!=ANY");
  }
|
  '<' ANY_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"<ANY");
  }
|
  LTEQ_ ANY_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"<=ANY");
  }
|
  '>' ANY_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)">ANY");
  }
|
  GTEQL_ ANY_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)">=ANY");
  }
|
  '=' ALL_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"=ALL");
    PH1FLAG(1414, $$);
  }
|
  NOTEQL_ ALL_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"!=ALL");
    PH1FLAG(1773, $$);                   /* this dosent exist in scmmtb.h !!!*/
    PH1FLAG(1414, $$);
  }
|
  BOX_ ALL_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"!=ALL");
    PH1FLAG(1414, $$);
  }
|
  '<' ALL_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"<ALL");
    PH1FLAG(1414, $$);
  }
|
  LTEQ_ ALL_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"<=ALL");
    PH1FLAG(1414, $$);
  }
|
  '>' ALL_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)">ALL");
    PH1FLAG(1414, $$);
  }
|
  GTEQL_ ALL_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)">=ALL");
    PH1FLAG(1414, $$);
  }
|
  '=' SOME_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"=SOME");
    PH1FLAG(1414, $$);
  }
|
  NOTEQL_ SOME_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"!=SOME");
    PH1FLAG(1473, $$);
    PH1FLAG(1414, $$);
  }
|
  BOX_ SOME_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"!=SOME");
    PH1FLAG(1414, $$);
  }
|
  '<' SOME_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"<SOME");
    PH1FLAG(1414, $$);
  }
|
  LTEQ_ SOME_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"<=SOME");
    PH1FLAG(1414, $$);
  }
|
  '>' SOME_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)">SOME");
    PH1FLAG(1414, $$);
  }
|
  GTEQL_ SOME_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)">=SOME");
    PH1FLAG(1414, $$);
  }
;

submultiset_predicate :

  sim_expr   SUBMULTISET_ OF_opt sim_expr
  {
    ub4 fn_name = ph1dti(ph1p, D_USED_O, (text *)"SUBMULTISET");
    ub4 args =
      (ub4)ph1nfs(ph1p, PH1LINN($1, PH1LINN($4, lismak())), D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, fn_name, args);
  } 
|
  sim_expr  NOT_ SUBMULTISET_ OF_opt sim_expr
  { 
    /* Create NOT(sim_expr SUBMULTISET_ OF_opt sim_expr) */
    ub4 fn_name = ph1dti(ph1p, D_USED_O, (text *)"SUBMULTISET");
    ub4 args =
      (ub4)ph1nfs(ph1p, PH1LINN($1, PH1LINN($5, lismak())), D_F_CALL);
    ub4 subm_fn =  ph1dtn(ph1p, D_F_CALL, 2, fn_name, args);
    ub4 not_id = (ub4)ph1dti(ph1p, D_USED_O, (text *)"NOT");
    ub4 not_arg_list = 
      (ub4)ph1nfs(ph1p, PH1LINN(subm_fn, lismak()), D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, not_id, not_arg_list);
  }
; /* missing! */

/* Only Submultiset. Member Of is done elsewhere 
multiset_op_boolean :
 multiset_op_submultiset
;
*/

multiset_op_union_except :

 UNION_ ALL_opt  
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"MULTISET_UNION_ALL");
  }
|
 UNION_ DISTINCT_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"MULTISET_UNION_DISTINCT");
  }
|
 EXCEPT_ ALL_opt
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"MULTISET_EXCEPT_ALL");
  }
|
 EXCEPT_ DISTINCT_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"MULTISET_EXCEPT_DISTINCT");
  }
;

multiset_op_intersect :
  INTERSECT_ ALL_opt
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"MULTISET_INTERSECT_ALL");
  }
|
  INTERSECT_ DISTINCT_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"MULTISET_INTERSECT_DISTINCT");
  } 
;


binary_add_op:

  '+'
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"+");
  }
|
  '-'
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"-");
  }
|
  '&'
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"&");
    PH1FLAG(1408, $$);
  }
|
  CAT_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"||");
    PH1FLAG(1400, $$);
  }
;

unary_add_op:

  '+'
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"+");
  }
|
  '-'
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"-");
  }
|
  PRIOR_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"PRIOR");
    PH1FLAG(1409, $$);
  }
;

mult_op:

  '*'
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"*");
  }
|
  '/'
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"/");
  }
|
  MOD_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"MOD");
    PH1FLAG(1410, $$);
  }
|
  REMAINDER_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"REMAINDER");
    PH1FLAG(1410, $$);
  }
|
  REM_
  {
    $$ = ph1dti(ph1p, D_USED_O, (text *)"REM");
    PH1FLAG(1411, $$);
  }
;

seq_of_stmts:

  pragma_list_opt stmt stmt_list_opt
  {
    /* [5242317, 3647002] The pragma has always been hooked in correctly. */
    $$ = ph1dtn(ph1p, DS_STM, 1, (ub4)PPH1LCAT($1, PH1LINN($2, $3)));
  }
;

unlabeled_nonblock_stmt:

  sim_stmt
  {
    $$ = $1;
  }
|
  nonblock_compound_stmt
  {
    $$ = $1;
  }
|
  sql_stmt ';'
  {
    if (PLSISA2(PTKIN($1), Q_SQL_ST, Q_DSQL_ST))
      $$ = $1;
    else
      $$ = ph1dtn(ph1p, Q_SQL_ST, 2, (ub4)TRENULL, (ub4)$1);
  }
|
  dsql_stmt ';'
  {
    $$ = ph1dtn(ph1p, Q_DSQL_ST, 1, $1);
  }
|
  static_dml_stmt ';'
|
  static_ddl_stmt ';'
;

/*
 * static_dml_stmt and static_ddl_stmt represent opaque SQL statements whose
 * text has been copied in the scanner and will be processed by the common
 * SQL front-end.
 */

static_dml_stmt:

  dml_start SQL_STMT_
  {
    $$ = $2;
  }
|
  merge_ SQL_STMT_         /* MERGE is special because it returns a <tree> */
  {
    $$ = $2;
  }
;

static_ddl_stmt:

  ddl_start SQL_STMT_
  {
    $$ = $2;
  }
;

dml_start:

  select_
|
  update_
|
  delete_
|
  insert_
|
  with_
;

ddl_start:

  set_
|
  commit_
|
  rollback_
|
  savepoint_
|
  lock_
;

/*
 * The following non-terminals provide feedback to the scanner indicating
 * the beginning of a free-standing SQL statement. These non-terminals should
 * only be used in places where a SQL statement starting with one of these
 * tokens and ending with a semicolon is expected.
 */

select_:

  mark_sql_stmt SELECT_
  {
    /*
     * Work around a SLAX bug. SLAX sets the line and column of select_ from
     * mark_sql_stmt, but mark_sql_stmt itself doesn't have a valid position.
     * Copy it over from SELECT_ here.
     * Bug 3345089.  Fix ph1p->ph1t*, which were set badly just before this
     * action. 
     */
    ph1p->ph1tln = SRCLINE(1) = SRCLINE(2); 
    ph1p->ph1tco = SRCCOL(1) = SRCCOL(2);
    $$ = $2;
  }
;

delete_:

  mark_sql_stmt DELETE_
  {
    ph1p->ph1tln = SRCLINE(1) = SRCLINE(2); 
    ph1p->ph1tco = SRCCOL(1) = SRCCOL(2);
    $$ = $2;
  }
;

insert_:

  mark_sql_stmt INSERT_
  {
    ph1p->ph1tln = SRCLINE(1) = SRCLINE(2); 
    ph1p->ph1tco = SRCCOL(1) = SRCCOL(2);
    $$ = $2;
  }
;

update_:

  mark_sql_stmt UPDATE_
  {
    ph1p->ph1tln = SRCLINE(1) = SRCLINE(2); 
    ph1p->ph1tco = SRCCOL(1) = SRCCOL(2);
    $$ = $2;
  }
;

merge_:

  mark_sql_stmt MERGE_
  {
    ph1p->ph1tln = SRCLINE(1) = SRCLINE(2); 
    ph1p->ph1tco = SRCCOL(1) = SRCCOL(2);
    $$ = $2;
  }
;

with_:

  mark_sql_stmt WITH_
  {
    ph1p->ph1tln = SRCLINE(1) = SRCLINE(2); 
    ph1p->ph1tco = SRCCOL(1) = SRCCOL(2);
    $$ = $2;
  }
;  

set_:

  mark_sql_stmt SET_
  {
    ph1p->ph1tln = SRCLINE(1) = SRCLINE(2); 
    ph1p->ph1tco = SRCCOL(1) = SRCCOL(2);
    $$ = $2;
  }
;

lock_:

  mark_sql_stmt LOCK_
  {
    ph1p->ph1tln = SRCLINE(1) = SRCLINE(2); 
    ph1p->ph1tco = SRCCOL(1) = SRCCOL(2);
    $$ = $2;
  }
;

commit_:

  mark_sql_stmt COMMIT_
  {
    ph1p->ph1tln = SRCLINE(1) = SRCLINE(2); 
    ph1p->ph1tco = SRCCOL(1) = SRCCOL(2);
    $$ = COMMIT_;
  }
;

rollback_:

  mark_sql_stmt ROLLBACK_
  {
    ph1p->ph1tln = SRCLINE(1) = SRCLINE(2); 
    ph1p->ph1tco = SRCCOL(1) = SRCCOL(2);
    $$ = $2;
  }
;

savepoint_:

  mark_sql_stmt SAVEPOINT_
  {
    ph1p->ph1tln = SRCLINE(1) = SRCLINE(2); 
    ph1p->ph1tco = SRCCOL(1) = SRCCOL(2);
    $$ = $2;
  }
;

/*
 * The following 3 empty non-terminals provide feedback to the scanner
 * indicating a context where different kinds of SQL statements are expected.
 */

mark_cursor_sql_stmt:
  /* Empty */
  {
    ph1p->ph1csf_context = ph1csf_cursor;
  }
;

mark_loop_sql_stmt :
  /* Empty */
  {
    ph1p->ph1csf_context = ph1csf_loop;
  }
;

mark_sql_stmt :
  /* Empty */
  {
    ph1p->ph1csf_context = ph1csf_stmt;
  }
;

labeled_nonblock_stmt:

  label_list_opt unlabeled_nonblock_stmt
  {
    if ( lisemp($1) )
    {
      $$ = $2;
    }
    else
    {
      ub4 tmp1 = (ub4)ph1dtn(ph1p, DS_ID, 1, PH1PSQ($1));
      $$ = ph1dtn(ph1p, D_LABELE, 2, tmp1, (ub4)$2);
    }
  }
;

labeled_block_stmt:

  label_list_opt block_stmt
  {
    if ( lisemp($1) )
    {
      $$ = $2;
    }
    else
    {
      ub4 tmp1 = (ub4)ph1dtn(ph1p, DS_ID, 1, PH1PSQ($1));
      $$ = ph1dtn(ph1p, D_LABELE, 2, tmp1, (ub4)$2);
    }
  }
;

stmt:

  labeled_nonblock_stmt
  {
    $$ = $1;
  }
|
  labeled_block_stmt
  {
    $$ = $1;
  }
;

sim_stmt:

  null_stmt
|
  assignment_stmt
|
  exit_stmt
|
  continue_stmt
|
  pipe_stmt
|
  return_stmt
|
  goto_stmt
|
  raise_stmt

  /*
   * We need to use a more descriptive nonterminal for procedure calls in
   * order to deal with remote procedure call syntax.  The valid syntax of
   * procedure calls is:
   *     proc_call ::= [ <id> .]* <procedure> [ @ <nodename> ] [ <args> ] ;
   * This used to be <name>.  I (TMO) now (23-Jan-91) change this.
   */

|
  procedure_call ';'
  {
    $$ = ph1nca(ph1p, $1, D_P_CALL);                   /* convert apply node */
    if ((TREKIN($1) == DI_U_NAM) &&
        !strcmp((char *)l_SYMREP($1), (char *)P_COMMIT))
      PH1FLAG(1702, $$);
    if ((TREKIN($1) == DI_U_NAM) &&
        !strcmp((char *)l_SYMREP($1), (char *)P_ROLLBACK))
      PH1FLAG(1701, $$);
  }
|
  gen_call ';'
   {
     $$ = ph1nca(ph1p, $1, D_P_CALL); /* This is a procedure call */
    } 
|
  purge_stmt ';'
;

/* Procedure and ent call stmts are included under "name".   */

nonblock_compound_stmt:

  if_stmt
  {
    $$ = $1;
  }
|
  loop_stmt
  {
    $$ = $1;
  }
|
  bulk_loop_stmt
  {
    $$ = $1;
  }
| case_stmt
;

label:

  L_LBL_ identifier R_LBL_
  {
    $$ = ph1dtr(ph1p, $2, DI_LABEL);
  }
;

null_stmt:

  NULL_ ';'
  {
    $$ = ph1dtn(ph1p, D_NULL_S, 0);
  }
;

assignment_stmt:

  name ASSIGN_ expr ';'
  {
    $$ = ph1dtn(ph1p, D_ASSIGN, 2, $1, $3);
  }
;

if_stmt:

  IF_ expr THEN_
             seq_of_stmts
          elsif_clause_opt
          else_clause_opt
  END_ IF_ ';'
  {
    noddef tmp1 = (ub4)ph1dtn(ph1p,D_COND_C,2,(ub4)$2,(ub4)$4);
    noddef tmp2, tmp3;

    if ($6 == TRENULL)
      tmp2 = TRENULL;
    else
      tmp2 = ph1dtn(ph1p,D_COND_C,2,(ub4)TRENULL,(ub4)$6);
    tmp3 = (ub4)PPH1LINN(tmp1, (tmp2==TRENULL ? ($5) : PH1LAPN(tmp2,$5)));
    $$ = ph1dtn(ph1p,D_IF,1, tmp3);
    A_endlin($$, SRCLINE(7));
    A_endcol($$, SRCCOL(7));
  }
;

ph1psh_:

  /* NULL */
  {
    PH1PSH;
    $$ = TRENULL;
  }
;

loop_stmt:

  ph1psh_
          iteration_scheme_opt LOOP_
             seq_of_stmts
          END_ LOOP_ identifier_opt ';'
  {
    $$ = ph1dtn(ph1p, D_LOOP, 2, (ub4)$2, (ub4)$4);
    L_srclin($$, ($2 == TRENULL) ? SRCLINE(3) : l_SRCLIN($2));
    L_srccol($$, ($2 == TRENULL) ? SRCCOL(3)  : l_SRCCOL($2));
    A_endlin($$, SRCLINE(5));
    A_endcol($$, SRCCOL(5));
    PH1POP;
  }
;

iteration_scheme:

  WHILE_ expr
  {
    $$ = ph1dtn(ph1p, D_WHILE, 1, (ub4)$2);
  }
|
  FOR_ identifier mark_loop_sql_stmt IN_ loop_prm_spec
  {
    $$ = $5;
    DISCARD(ph1dtr(ph1p, $2, DI_ITERA));
    L_srccol($$, ph1p->ph1tco);
    L_srclin($$, ph1p->ph1tln);
    A_id($$, $2);
  }
;

/* I had conflict on .AT. and .REVERSE. that required reducing them here. */

loop_prm_spec:

  range
  {
    $$ = ph1dtn(ph1p, D_FOR, 2, 0, (ub4)$1);
  }
|
  REVERSE_ range
  {
    $$ = ph1dtn(ph1p, D_REVERS, 2, 0, (ub4)$2);
  }
|
  '(' curs_spec ')'
  {
    $$ = ph1dtn(ph1p, D_FOR, 2, 0, (ub4)$2);
  }
|
  SQL_STMT_
  {
    $$ = ph1dtn(ph1p, D_FOR, 2, 0, (ub4)$1);
  }
;


bulk_loop_stmt:

  FORALL_ ph1psh_ identifier bulk_loop_rng save_exceptions_opt
    bulk_executable_stmt ';'
  {
    ub4 tmp1;

    DISCARD(ph1dtr(ph1p, $3, DI_BULK_ITER));
    tmp1 = (ub4)ph1dtn(ph1p, D_FORALL, 2, (ub4)$3, (ub4)$4);

    /*
     * Remember whether or not the user wants to continue past errors
     * in the FORALL statement. 
     */
    S_flags(tmp1, $5);

    /*
     * Embed the bulk_executable_stmt within a D_LOOP node in order to
     * simplify handling in phase 2 and COG.
     */
    $$ = ph1dtn(ph1p, D_LOOP, 2, tmp1,
                (ub4)ph1dtn(ph1p, DS_STM, 1, (ub4)PPH1LINN($6, lismak())));

    if ($4 == TRENULL)
    {
      L_srccol($$, ph1p->ph1tco);
      L_srclin($$, ph1p->ph1tln);
    }
    else
    {
      L_srccol($$, l_SRCCOL($4));
      L_srclin($$, l_SRCLIN($4));
    }
    PH1POP;
  }
;

bulk_loop_rng:

  IN_ bulk_loop_bnds
  {
    $$ = $2;
  }
;
bulk_loop_bnds:
  sim_expr_DBLDOT__sim_expr
  {
    $$ = $1;
    L_srccol($$, ph1p->ph1tco);
    L_srclin($$, ph1p->ph1tln);
  }
|
  INDICES_ OF_ sim_expr bulk_btwn 
  {
    ub2 flags =0;
   
    $$ = $4;
    flags = s_BLKFLG($$);
    bis(flags, PHD_SPARSE_COLLECTION);
    S_blkflg($$, flags);
    L_srccol($$, ph1p->ph1tco);
    L_srclin($$, ph1p->ph1tln);
    S_indcol($$, $3);
  }
|
  VALUES_ OF_ sim_expr
  {
    ub2 flags =0;
    $$ = ph1dtn(ph1p, D_RANGE, 2, 
                ph1dti(ph1p, D_NUMERI,(const oratext *) "0"), 
                ph1dti(ph1p, D_NUMERI,(const oratext *)"0"));
    flags = s_BLKFLG($$);
    bis(flags, PHD_SPARSE_INDEX);

    S_indcol($$, $3);
    S_blkflg($$, flags);
  }
;

bulk_btwn:
 /* empty */
  { 

    $$ = ph1dtn(ph1p, D_RANGE, 2, 
                ph1dti(ph1p, D_NUMERI,(const oratext *) "0"), 
                ph1dti(ph1p, D_NUMERI,(const oratext *)"65535"));
  }
|

  BETWEEN_  sim_expr AND_ sim_expr
  {
    ub2 flags =0;
    $$ = ph1dtn(ph1p, D_RANGE, 2, (ub4)$2, (ub4)$4);
    flags = s_BLKFLG($$);
    bis(flags, PHD_BULK_BETWEEN);
    S_blkflg($$,flags );  }
;

/* Bulk-able statement */
bulk_executable_stmt :
  sql_query_or_dml_stmt
  {
    $$ = $1;
  }
|
  exec_immediate_statement
  {
    $$ = ph1dtn(ph1p,Q_DSQL_ST,1,$1);
  }
|
  static_dml_stmt
;

block_stmt:

  ph1psh_
         DECLARE_decls_opt
          BEGIN_
             seq_of_stmts
          exception_handlers_opt
             END_ identifier_opt ';'
  { 
    $$ = ph1dtn(ph1p, D_BLOCK, 3, (ub4)$2, (ub4)$4, (ub4)$5);

    if ((l_SRCLIN($2) == 0) && (l_SRCCOL($2) == 0))
    {
      L_srclin($2, SRCLINE(3));  L_srccol($2, SRCCOL(3));
      L_srclin($$, SRCLINE(3));  L_srccol($$, SRCCOL(3));
    }
    else
    {
      L_srclin($$, SRCLINE(2));  L_srccol($$, SRCCOL(2));
    }
    A_beglin($$, SRCLINE(3));  A_begcol($$, SRCCOL(3));
    A_endlin($$, SRCLINE(6));  A_endcol($$, SRCCOL(6));

    PH1POP;
  }
;

exit_stmt:

  EXIT_ dotted_name_opt WHEN_cond_opt ';'
  {
    $$ = ph1dtn(ph1p, D_EXIT, 2, (ub4)$2, (ub4)$3);
  }
;

/* The CONTINUE statement differs from the EXIT statement because the simplest
   case -- CONTINUE; -- is taken care of by a different mechanism. It looks 
   like a parameterless procedure call. Therefore we have three productions
   here and the parts are not optional (as in EXIT) but each production 
   specifies one of the possible patterns.
*/

continue_stmt:
  CONTINUE_ dotted_name ';'
  {
    $$ = ph1dtn(ph1p, D_CONTINUE, 2, (ub4) $2, TRENULL);
  }
|
  CONTINUE_ WHEN_ expr ';'
  {
    $$ = ph1dtn(ph1p, D_CONTINUE, 2, TRENULL, (ub4) $3);
  }
|
  CONTINUE_ dotted_name WHEN_ expr ';'
  {
    $$ = ph1dtn(ph1p, D_CONTINUE, 2, (ub4) $2, (ub4) $4);
  }
;

pipe_stmt:

  PIPE_ ROW_ '(' expr ')' ';'
  {  
    /* Allowed only in table functions */
    $$ = ph1dtn(ph1p, D_PIPE, 1, (ub4)$4);
  }
;

return_stmt:

  RETURN_ expr_opt ';'
  {
    $$ = ph1dtn(ph1p, D_RETURN, 1, (ub4)$2);
  }
;

goto_stmt:

  GOTO_ dotted_name ';'
  {
    $$ = ph1dtn(ph1p, D_GOTO, 1, $2);
  }
;

purge_stmt :

  PURGE_ RESULT_CACHE_ result_cache_entries purge_options
  {
    /* make the D_PURGE diana node */
    $$ = ph1dtn(ph1p, D_PURGE, 0);

    /* what flavor of purge is it? "ON COMMIT" or "NOW" */
    if (COMMIT_ == $4) 
      A_flags($$, PHD_PURGE_ON_COMMIT);

    /* the list of function results to purge */
    AS_results($$, $3);
  }
;

result_cache_entries :
   result_cache_entries ',' name
   {
     $$ = PH1LAPN($3, $1);                                 /* append to list */
   }
 | 
   name
   {
     $$ = PH1LINN($1, lismak());
   }
;

purge_options :
  ON_ COMMIT_
  { 
    $$ = COMMIT_;
  }
|
  NOW_
  {
    $$ = NOW_;
  }
;


operator_signature:

  OPERATOR_  designator
  {
    $2 = ph1dtr(ph1p, $2, DI_FUNCT);
    PH1PSH;
  }
  fml_part_opt RETURN_ prm_spec_unconstrained_type
  {
    $$ = ph1dtn(ph1p, D_S_OPER, 3, (ub4)$2,
                (ub4)ph1dtn(ph1p, D_F_, 2, (ub4)$4, (ub4)$6), (ub4)0);
    PH1POP;
  }
;

binding_function:

  FUNCTION_ dotted_name { PH1PSH; }
  fml_part_opt RETURN_ prm_spec_unconstrained_type
  {
    $$ = ph1dtn(ph1p, D_S_DECL, 3, (ub4)$2,
                (ub4)ph1dtn(ph1p, D_F_, 2, (ub4)$4, (ub4)$6), (ub4)TRENULL);
    PH1POP;
  }
;

subprg_d:

  subprg_spec
  {
    PH1POP;
    $$ = $1;
  }
|
  ff_wo_external
  {
    PH1POP;
    $$ = $1;
  }
;

subprg_i:
  subprg_d
  {
    $$ = $1;
  }
|
  int_pipe_tab_fun
  { 
     $$ = $1;
  }
;

int_pipe_tab_fun:
   subprg_spec USING_ link_expanded_n 
  {
    ptnod parallel_spec;
    ptnod type_node;

    /*
     * Ensure that the USING_ <type> clause is only used with the
     * table functions (a_parallel_spec is not NULL in this case).
     *
     * There is another test a few lines later than enforces that
     * only interface-style table functions and aggregate functions
     * use the "USING <type>" clause.
     */
    if (!((TREKIN($1) == D_S_DECL) &&
          (TREKIN(a_HEADER($1)) == D_F_) &&
          (a_PARALLEL_SPEC(a_D_($1)) != TRENULL))) 
    {
      PH1ERR(624, SEVERROR, $3, PLSUNIQ(25));
    }
    else
    {
      parallel_spec = a_PARALLEL_SPEC(a_D_($1));

      /*
       * If the function is neither a pipelined table function nor an
       * aggregate function or a polymorphic table function, report an 
       * error. Note that the previous production (see non-terminal 
       * subprg_properties) always marks pipelined functions with 
       * PCIPIPEP because there is no way to know whether or not a body 
       * is specified at that time. The code below unsets the PCIPIPEP 
       * bit and sets the PCIPIPEI bit.
       *
       * In addition, it picks up the type name and hook it up with the rest
       * of the diana tree.
       */
      
      if (!(bit(a_BITFLAGS(parallel_spec), PCIPIPEP) ||
            bit(a_BITFLAGS(parallel_spec), PCIAGGR)  ||
            PCIPROP_IS_POLYMORPHIC(a_BITFLAGS(parallel_spec))))
      {
        PH1ERR(624, SEVERROR, $3, PLSUNIQ(26));
      }
      else
      {
        /*
         * Create a new diana node to capture the "body" (function logic)
         * provided by the "USING <type>" clause.
         */
        type_node = ph1dtn(ph1p, D_IMPL_BODY, 1, 
                           ph1dtr(ph1p, (ub4)$3, DI_U_NAM));
        L_srclin(type_node, SRCLINE(1));  L_srccol(type_node, SRCCOL(1));
  
        A_type_body(a_PARALLEL_SPEC(a_D_($1)), type_node);
  
        /*
         * Unset the PCIPIPEP bit and set PCIPIPEI bit to indicate that this
         * function corresponds to a interface-style PL/SQL function.
         *
         * If the function corresponds to an aggregate function, nothing needs
         * to be done.
         */
        /* 12.2: Don't clear it for polymorphic table functions */
        if (bit(a_BITFLAGS(parallel_spec), PCIPIPEP) && 
            ! PCIPROP_IS_POLYMORPHIC(a_BITFLAGS(parallel_spec)))
        {
          ub4 properties = a_BITFLAGS(a_PARALLEL_SPEC(a_D_($1)));
          properties = properties ^ PCIPIPEP; /* Clear out the PCIPIPEP bit */
          properties = properties | PCIPIPEI; /* Set the PCIPIPEI bit */
          A_bitflags(parallel_spec, properties);
        }
    
        $$ = ph1dtn(ph1p, D_S_BODY, 3, 
                    (ub4)a_D_($1), (ub4)a_HEADER($1), (ub4)type_node);
        tredes(pgap, $1);
        PH1POP;
      }
    }
  }
;

subprg_spec:              /* I don't understand the subprogram_def attribute */
                          /* yet, that's why it's null now                   */

  PROCEDURE_ decl_id
  {
    ph1pp_set_unit_info(ph1p, (oratext *)l_SYMREP($2), (oratext *)"PROCEDURE");
    $2 = ph1dtr(ph1p, $2, DI_PROC);
    PH1PSH;
  }
             fml_part_opt subprg_properties proc_interface_opt
  {
    /* A hack on sequence depends on this diana structure. Changes */
    /* sequence_definition as well if this is changed.             */

    ub4 tmp1 = (ub4)ph1dtn(ph1p, D_P_, 3, (ub4)$4, (ub4)0, (ub4)$6);
    $$ = ph1dtn(ph1p, D_S_DECL, 3, (ub4)$2, tmp1, (ub4)TRENULL);
    if (PTKIN($2) == DI_PROC)
    {
      ub4 property = ($5 != TRENULL) ? a_BITFLAGS($5) : 0;
      L_restrict_references($2, property);
      if (ph1p->ph1cly == 1)           /* Only on top-level */
        AS_whtlst($2, ph1p->ph1whitelist);
    }
  }
|
  FUNCTION_  designator
  {
    ph1pp_set_unit_info(ph1p, (oratext *)l_SYMREP($2), (oratext *)"FUNCTION");
    $2 = ph1dtr(ph1p, $2, DI_FUNCT);
    PH1PSH;
  }
  fml_part_opt RETURN_ func_return_prm_spec_unconstrained_type 
  subprg_properties func_properties_opt
  {
    ub4 bitflag_7 = ($7 != TRENULL ? a_BITFLAGS($7) : (ub4)0);
    ub4 bitflag_8 = ($8 != TRENULL ? a_BITFLAGS($8) : (ub4)0);
    ub4 property_union = bitflag_7 | bitflag_8;

    /*
     * $8 corresponds to AGGREGATE and related clauses only. Aggregate
     * functions cannot be pipelined. 
     */
    if (bit(bitflag_7, PCIPIPEP) && bit(bitflag_8, PCIAGGR))
    {
      PCMMSGS(371, SEVERROR, ph1p->ph1sln, ph1p->ph1sco,
              PLSUNIQ(12), (text *) "PIPELINED or AGGREGATE");
      PH1SEVA(SEVERROR);
    }

    /* A hack on sequence depends on this diana structure. Changes */
    /* sequence_definition as well if this is changed.             */

    $$ = ph1dtn(ph1p, D_S_DECL, 3,
                (ub4)$2,
                (ub4)ph1dtn(ph1p, D_F_, 2, (ub4)$4, (ub4)$6),
                (ub4)TRENULL
               );

    if (PTKIN($2) == DI_FUNCT)
    {
      L_restrict_references($2, property_union);
      if (ph1p->ph1cly == 1)              /* Only on top-level functions */
        AS_whtlst($2, ph1p->ph1whitelist);

      /*
       * func_properties_opt corresponds to the PIPELINED and AGGREGATE
       * function specifications. If the non-terminal is not NULL, fold
       * in the information into the tree corresponding to the
       * subprg_properties non-terminal.
       */
      if ($7 != TRENULL)
      {
        if ($8 != TRENULL)
        {
          A_bitflags($7, (a_BITFLAGS($7) | a_BITFLAGS($8)));
        }
        A_parallel_spec($2, (ub4)$7);
      }
      else if ($8 != TRENULL) /* we know that $7 == TRENULL */
      {
        A_parallel_spec($2, (ub4)$8);
      }
    }
  }
;

subprg_properties:

  /* Empty */
  {
    $$ = TRENULL;
  }
|
  subprg_properties subprg_property 
  {
    /* Check for duplicate property declarations */
    ub4 bitflag_1 = ($1 != TRENULL ? a_BITFLAGS($1) : (ub4)0);
    ub4 bitflag_2 = ($2 != TRENULL ? a_BITFLAGS($2) : (ub4)0);
    ub4 common = bitflag_1 & bitflag_2;
    ub4 union_prop  = bitflag_1 | bitflag_2;

    /*
     * Error cases:
     * -- Can't have duplicate declarations.
     * -- Can't have the same function marked as both pipelined and as 
     *    aggregate function.
     * -- Can't have multiple parallel properties.
     */
    if (common != 0 ||
        ($1 != TRENULL && $2 != TRENULL &&
         (bit(bitflag_1, PCIAGGR) && bit(bitflag_2, PCIPIPEP)) ||
         (bit(bitflag_2, PCIAGGR) && bit(bitflag_1, PCIPIPEP))))
    {
      PCMMSGS(371, SEVERROR, ph1p->ph1sln, ph1p->ph1sco,
              PLSUNIQ(13),
              bit(common, PCIDET) ? (text *) "DETERMINISTIC" :
              bit(common, PCIPIPEP) ? (text *) "PIPELINED"     :
              bit(common, PCIAGGR) ? (text *) "AGGREGATE"     :
              bit(common, PCICLUS) ? (text *) "CLUSTER BY"     :
              bit(common, PCIORDER) ? (text *) "ORDER BY"     :
              bit(common, PCIPAR) ? (text *) "PARALLEL_ENABLE" :
              bit(common, PCIRCF) ? (text *) "RESULT_CACHE" :
              (text *) ""); /* empty output string if none of the above */
      PH1SEVA(SEVERROR);
    }
    else
    {
      if ($2 != TRENULL)
      {
        /*
         * Union both set of properties ($1 and $2) into $2.
         * Note that the above test ensures that there are no duplicate
         * properties and there are no clashes. So, the following code
         * happily unions all the properties.
         */
        A_bitflags($2, union_prop);
  
        /*
         * We are guaranteed that either $1 or $2 (but not both) will have
         * not NULL partitioning and/or clustering/ordering options.
         * If $2's partitioning/clustering/ordering clause is not NULL, no 
         * need to do anything. If $1's clauses are not NULL, copy over the
         * info to $2.
         */
        if ($1 != TRENULL && a_PARTITIONING($1) != TRENULL)
        {
          PPPASR(a_PARTITIONING($2) == TRENULL, PLSUNIQ(37));
          A_partitioning($2, (ub4)a_PARTITIONING($1));
        }
    
        if ($1 != TRENULL && a_STREAMING($1) != TRENULL) 
        {
          PPPASR(a_STREAMING($2) == TRENULL, PLSUNIQ(38));
          A_streaming($2, (ub4)a_STREAMING($1));
        }

        /* We have already ensured that there can be at most
           one RESULT_CACHE subclause for a subprogram. We
           must copy over the RELIES ON list from $1 to $2.
         */
        if ($1 != TRENULL && (!lisemp(ss_LIST($1, AS_RELIES_ON))))
        {
          PPPASR(lisemp(ss_LIST($2, AS_RELIES_ON)), PLSUNIQ(39));
          SS_list($2, AS_RELIES_ON, ss_LIST($1, AS_RELIES_ON));
        }
     
      }
    }

    $$ = $2;
  }
;

subprg_property:

  authid
  {
    if (ph1p->ph1cly != 1)                    /* Only on top-level functions */
    {
      PH1ERRS(157, SEVSEVER, $1, PLSUNIQ(14), (text *) "AUTHID");
    }
    else 
    {
      if (ph1p->ph1authid)          /* Don't allow duplicate declarations */
      {
        PH1ERRS(371, SEVERROR, $1, PLSUNIQ(15), (text *) "AUTHID");
      }
      else
      {
        ph1p->ph1authid = (text *) l_SYMREP($1);
      }
    }

    /* bug 9322044: returning a TRENULL was eating away
    ** the bits in D_SUBPROG_PROP, if authid clause
    ** comes after for example PARALLEL_ENABLE or DETERMISTIC.
    */
    $$ = ph1dtn(ph1p, D_SUBPROG_PROP, 4,
                (ub4)(0), 
                (ub4)TRENULL, (ub4)TRENULL, (ub4)TRENULL);;
  }
|
 REWRITE_
  {
     $$ = ph1dtn(ph1p, D_SUBPROG_PROP, 4, 
                (ub4)(PCISQLFUNC), /* SQL language macro function */
                (ub4)TRENULL, (ub4)TRENULL, (ub4)TRENULL);
  }
|
  DETERMINISTIC_
  {
    $$ = ph1dtn(ph1p, D_SUBPROG_PROP, 4,
                (ub4)(PCIDET), 
                (ub4)TRENULL, (ub4)TRENULL, (ub4)TRENULL);

  }
|
  PARALLEL_ENABLE_ partition_elaborator_opt
  {
    $$ = ph1dtn(ph1p, D_SUBPROG_PROP, 4, 
                (ub4)(PCIPAR | ($2 != TRENULL ? a_BITFLAGS($2) : (ub4)0)),
                (ub4)($2), (ub4)TRENULL, (ub4)TRENULL);
  }
| 
  cluster_or_order_elaborator
  {
    $$ = ph1dtn(ph1p, D_SUBPROG_PROP, 4,
                (ub4)(a_BITFLAGS($1)), 
                (ub4)TRENULL, (ub4)($1), (ub4)TRENULL);
  }
|
  PIPELINED_  
  {
    /*
     * Note that here we don't know whether the declaration is for
     * interface-style pipelined or native PL/SQL pipelined function;
     * set it to PCIPIPEP (native PL/SQL); the bit is changed to
     * PCIPIPEI if the USING_ clause is encountered.
     * (see "subprg_spec USING_ dotted_name" production).
     */
    
    $$ = ph1dtn(ph1p, D_SUBPROG_PROP, 4, 
                (ub4)(PCIPIPEP), /* assume native pipelined */
                (ub4)TRENULL, (ub4)TRENULL, (ub4)TRENULL);
  }
|
  default_collation
  {
    $$ = ph1dtn(ph1p, D_SUBPROG_PROP, 4,
                (ub4)(0),
                (ub4)TRENULL, (ub4)TRENULL, (ub4)TRENULL);
  }
|
  white_list
  {
    if (ph1p->ph1cly != 1)                    /* Only on top-level functions */
    {
      PH1ERRS(157, SEVSEVER, TRENULL, PLSUNIQ(41), (text *) "ACCESSIBLE BY");
    }
    else 
    {
      if (ph1p->ph1whitelist)          /* Don't allow duplicate declarations */
      {
        PH1ERRS(371, SEVERROR, $1, PLSUNIQ(42), (text *) "ACCESSIBLE BY");
      }
      else
      {
        ph1p->ph1whitelist = $1;
      }
    }

    /* bug 9322044: returning a TRENULL was eating away
    ** the bits in D_SUBPROG_PROP, if authid clause
    ** comes after for example PARALLEL_ENABLE or DETERMISTIC.
    */
    $$ = ph1dtn(ph1p, D_SUBPROG_PROP, 4,
                (ub4)(0), 
                (ub4)TRENULL, (ub4)TRENULL, (ub4)TRENULL);;
  }
|
  result_cache_property
|
  PIPELINED_  polymorhic_elaborator 
  /* Polymorphic Table functions */
  {
   $$ = ph1dtn(ph1p, D_SUBPROG_PROP, 7, 
               (ub4)(PCIPOLYFN |  a_BITFLAGS($2) ),
               (ub4)($2), (ub4)TRENULL, (ub4)TRENULL,
               (ub4)TRENULL, (ub4)TRENULL, (ub4)  a_BITFLAGS2($2) );
  }

;

polymorhic_elaborator:

TABLE_ POLYMORPHIC_
 {
   $$ = ph1dtn(ph1p, D_ELAB, 5, (ub4) 0, 
               (ub4)TRENULL, (ub4)TRENULL, (ub4)TRENULL, (ub4)PCI2TABSEM); 
 }
|
ROW_ POLYMORPHIC_
 {
   $$ = ph1dtn(ph1p, D_ELAB, 5, (ub4)0 , 
               (ub4)TRENULL, (ub4)TRENULL, (ub4)TRENULL, (ub4)PCI2ROWSEM  ); 
 }
|
LEAF_ POLYMORPHIC_
 {
   $$ = ph1dtn(ph1p, D_ELAB, 5, (ub4)0 , 
               (ub4)TRENULL, (ub4)TRENULL, (ub4)TRENULL, (ub4)PCI2LEAF ); 
 }  
;

func_properties_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  AGGREGATE_  update_value_opt with_external_context_opt
  {
    $$ = ph1dtn(ph1p, D_SUBPROG_PROP, 4, 
                (ub4)($2 | $3 | PCIAGGR),
                (ub4)TRENULL, (ub4)TRENULL, (ub4)TRENULL);
  }
;


partition_elaborator_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  '(' partition_elaborator ')'
  {
    $$ = $2;
  }
;

white_list:
  ACCESSIBLE_ BY_ '(' white_list_items ')'
  {
    $$ = ph1dtn(ph1p, DS_WHTLST,  1, PH1PSQ($4));
  }
;

white_list_items:
  white_list_item
  {
    $$ = PH1LAPN($1, lismak());
  }
|  white_list_items ',' white_list_item
  {
    $$ = PH1LAPN($3, $1);
  }
;

white_list_item:
  /* Unit-type unit-name */
  white_list_type identifier '.' identifier
  {
    ptnod  type_node = ph1dti(ph1p, DI_U_NAM, $1);

    $$ = ph1dtn(ph1p, D_WHTLST, 3, type_node, $2, $4);
  }
| white_list_type identifier
  {
    ptnod  type_node = ph1dti(ph1p, DI_U_NAM, $1);
    $$ = ph1dtn(ph1p, D_WHTLST, 3, type_node, (ptnod)0, $2);
  }
| identifier '.' identifier
  {
    $$ = ph1dtn(ph1p, D_WHTLST, 3, (ptnod)0, $1, $3);
  }
| identifier
  {
    $$ = ph1dtn(ph1p, D_WHTLST, 3, (ptnod)0, (ptnod)0, $1);
  }
;

white_list_type:
  FUNCTION_
 {
   $$ = (oratext *)"FUNCTION";
  }
|
  PROCEDURE_
 {
    $$ = (oratext *)"PROCEDURE";
  }
|
  PACKAGE_
 {
    $$ = (oratext *)"PACKAGE";
  }
|
  TRIGGER_
 {
    $$ = (oratext *)"TRIGGER";
  }
|
  TYPE_
 {
    $$ = (oratext *)"TYPE";
  }
;

result_cache_property:
  RESULT_CACHE_
  {
    $$ = ph1dtn(ph1p, D_SUBPROG_PROP, 1, (ub4)PCIRCF);   /* result cached fn */
  }
|
  RESULT_CACHE_ relies_on_clause
  {
    $$ = ph1dtn(ph1p, D_SUBPROG_PROP, 1, (ub4)PCIRCF);   /* result cached fn */
    SS_list($$, AS_RELIES_ON, ($2));       /* relies on clause (may be NULL) */
  }
;

relies_on_clause:
  RELIES_ON_ '(' dotted_name_list_opt ')'
  {
    PH1WARN_DEPRECATED(SOURCE_LINE, SOURCE_COL, PLSUNIQ(40),
                       "RELIES_ON", "11.2");
    $$ = $3;
  }
;


dotted_name_list_opt:
  /* empty */
  {
    $$ = lismak();
  }
|
  dotted_name_list
;

dotted_name_list:
  dotted_name
  {
    $$ = PH1LAPN($1, lismak());
  }
|
  dotted_name_list ',' dotted_name
  {
    $$ = PH1LAPN($3, $1);
  }
;

partition_elaborator:

  PARTITION_  identifier  BY_       ANY_                     
  { 
    $$ = ph1dtn(ph1p, D_ELAB, 3, (ub4)(PCIANY | PCIPART), 
                (ub4)($2), (ub4)TRENULL); 
  }
|  
  PARTITION_ identifier BY_ hash_or_range '(' sort_specification_list ')' 
  { 
    ptnod partition_tree;

    partition_tree = ph1mak(ph1p, DS_EXP);
    AS_list(partition_tree, $6);

    $$ = ph1dtn(ph1p, D_ELAB, 3, (ub4)(($4) | PCIPART), 
                (ub4)($2), (ub4)partition_tree);
  }
;


cluster_or_order_elaborator:

  ORDER_ identifier BY_ '(' sort_specification_list ')'
  { 
    ptnod sort_tree;

    sort_tree = ph1mak(ph1p, DS_EXP);
    AS_list(sort_tree, $5);

    $$ = ph1dtn(ph1p, D_ELAB, 3, (ub4)(PCIORDER), (ub4)($2), (ub4)sort_tree);
  }
|
  CLUSTER_ identifier BY_ '(' sort_specification_list ')'
  { 
    ptnod sort_tree;

    sort_tree = ph1mak(ph1p, DS_EXP);
    AS_list(sort_tree, $5);

    $$ = ph1dtn(ph1p, D_ELAB, 3, (ub4)(PCICLUS), (ub4)($2), (ub4)sort_tree);
  }
;


hash_or_range:

   HASH_                          { $$ = (ub4)PCIHASH; }
|  RANGE_                         { $$ = (ub4)PCIRANGE; }
|  VALUE_                         { $$ = (ub4)PCIPMOD; }
;


update_value_opt:

  /* empty */                     { $$ = (ub4)0; }
| UPDATE_ VALUE_                  { $$ = (ub4)PCIUPDTVAL; }
;


with_external_context_opt:

  /* empty */                     { $$ = (ub4)0; }
| WITH_ EXTERNAL_ CONTEXT_        { $$ = (ub4)PCIXTCNTXT; }
;


ff_w_external:

  subprg_spec is_or_as EXTERNAL_ c_external_ops
  /* OLD Foreign Function Syntax */
  {
    /* If NAME not specified extract from PLSQL name. */
    if (!a_NAME($4))
    {
      ptnod tmp        = $1;
      ptnod tmp1       = a_D_(tmp);
      CONST text *name = l_SYMREP(tmp1);
      ptnod newname    = ph1dti(ph1p, D_STRING, name);

      A_name($4, newname);
    }
    $$ = ph1dtn(ph1p, D_S_BODY, 3, (ub4)a_D_($1), (ub4)a_HEADER($1), $4);
    tredes(pgap, $1);
  }
;

ff_wo_external:

  subprg_spec is_or_as call_specification
  {
    /* Oracle 8.1 call specification for C and Java */

    /* If NAME not specified and language is C or UNSPECIFIED */
    /* (default to * C) then extract from PLSQL name.         */

    if (((a_LANG($3) == PFFOLC) || (a_LANG($3) == PFFOLUNSP)) &&
        !a_NAME($3))
    {
      ptnod tmp        = $1;
      ptnod tmp1       = a_D_(tmp);
      CONST text *name = l_SYMREP(tmp1);
      ptnod newname    = ph1dti(ph1p, D_STRING, name);

      A_name($3, newname);
    }

    /* set the new CALL-Specification syntax flag. PH2 may need it */
    {
      ub2 flags = a_FLAGS($3);

      bis(flags, PFFOMCALLSPECSYNTAX);
      A_flags($3, flags);
    }
    $$ = ph1dtn(ph1p, D_S_BODY, 3, (ub4)a_D_($1), (ub4)a_HEADER($1), $3);
    L_srclin($3, SRCLINE(1));  L_srccol($3, SRCCOL(1));
    tredes(pgap, $1);
  }
|
  subprg_spec java_call_specification
  {
    /* Oracle 8.1 call specification for C and Java */

    /* If NAME not specified and language is C or UNSPECIFIED */
    /* (default to * C) then extract from PLSQL name.         */

    if (((a_LANG($2) == PFFOLC) || (a_LANG($2) == PFFOLUNSP)) &&
        !a_NAME($2))
    {
      ptnod tmp        = $1;
      ptnod tmp1       = a_D_(tmp);
      CONST text *name = l_SYMREP(tmp1);
      ptnod newname    = ph1dti(ph1p, D_STRING, name);

      A_name($2, newname);
    }

    /* set the new CALL-Specification syntax flag. PH2 may need it */
    {
      ub2 flags = a_FLAGS($2);

      bis(flags, PFFOMCALLSPECSYNTAX);
      A_flags($2, flags);
    }
    $$ = ph1dtn(ph1p, D_S_BODY, 3, (ub4)a_D_($1), (ub4)a_HEADER($1), $2);
    tredes(pgap, $1);
  }

;

/* Oracle 8.1 CALL Specification for C or Java */

java_call_specification:
  EXTERNAL_  NAME_ string_literal 
  {
    ptnod signature = ph1dti(ph1p, D_STRING, $3);
    $$  = (ub4)ph1dtn(ph1p, D_EXTERNAL, 7, (ub4)signature, (ub4)TRENULL,
                      (ub4)TRENULL, (ub2)PFFOCUNSP, (ub2)PFFOLJAVA,
                      (ub2)PFFOLJAVA, (ub4)PFFOMISCUNSP);
  }
|
  EXTERNAL_ VARIABLE_ NAME_ string_literal 
  {
    ptnod static_member = ph1dti(ph1p, D_STRING, $4);
    $$  = (ub4)ph1dtn(ph1p, D_EXTERNAL, 7, (ub4)static_member, (ub4)TRENULL,
                      (ub4)TRENULL, (ub2)PFFOCUNSP, (ub2)PFFOLJAVA,
                      (ub2)PFFOLJAVA, (ub4)PFFOMVARFNC);
  }
;

call_specification:

  LANGUAGE_ external_language_decl
  {
    $$ = $2;
  }
;

/*
 * WITH INTERFACE is a new clause on procedure specs which are not used
 * within PL/SQL itself.  Other tools such as the new code generator will
 * use the contents of WITH INTERFACE to build procedures in 3GL's. The
 * syntax of a WITH INTERFACE is exactly that of a procedure declaration
 * except for the treatment of indicator variables.
 */

proc_interface_opt:

  WITH_ INTERFACE_ interface_proc_spec
  {
    PH1POP;
    $$ = $3;
  }
|
  /* empty */
  {
    $$ = TRENULL;
  }
;

interface_proc_spec:

  PROCEDURE_ identifier
  {
    $2 = ph1dtr(ph1p, $2, DI_PROC);
    PH1PSH;
  }
             interface_fml_part
  {
    ub4 tmp1 = (ub4)ph1dtn(ph1p, D_P_, 2, (ub4)$4, (ub4)TRENULL);
    $$ = ph1dtn(ph1p, D_S_DECL, 3, (ub4)$2, tmp1, (ub4)TRENULL);
  }
;

interface_fml_part:

  '(' interface_prm_spec interface_prm_spec_list_opt ')'
  {
    ub4 tmp1 = (ub4)PPH1LINN($2, $3);
    $$ = ph1dtn(ph1p, DS_PARAM, 1, tmp1);
  }
;

interface_prm_spec:

  ident interface_constrained_type interface_indicator_opt
  {
    ub4 tmp1 = (ub4)ph1nfs(ph1p, $1, D_IN_OUT);
    $$ = ph1dtn(ph1p, D_IN_OUT, 4, tmp1, (ub4)$2, (ub4)TRENULL, (ub4)$3);
  }
;

/*
 * Note that the reason we don't use constrained_type straight-away is that we 
 * get a conflict from the RANGE constraint which is illegal in this context
 * anyway. This interface_constraint only allows parameterized constraints.
 * (i.e., constraints withins parens as in char(5)).
 */

interface_constrained_type:

  unconstrained_type interface_constraint_opt NOT_NULL_opt
  {
    $$ =  ph1dtn(ph1p, D_CONSTR, 3, (ub4)$1, (ub4)$2, (ub4)$3);
  }
;

interface_constraint_opt:

  paren_expr_list
  {
    $$ = ph1dtn(ph1p, DS_APPLY, 1, PH1PSQ($1));
  }
|
  /* empty */
  {
    $$ = TRENULL;
  }
;

interface_indicator_opt:

  INDICATOR_ identifier
  {
    /* Put identifier into indicator attribute for this node. */
    $$ = $2;
  }
|
  /* empty */
  {
    $$ = TRENULL;
  }
;

interface_prm_spec_list_opt:

  interface_prm_spec_list_opt ',' interface_prm_spec
  {
    $$ = PH1LAPN($3, $1);
  }
|
  /* empty */
  {
    $$ = lismak();
  }
;

designator:

  decl_id
|
  string_literal
  {
    $$ = ph1dti(ph1p, D_DEF_OP, $1);
  }
;

fml_part:

  '(' prm_spec parm_list_opt ')'
  {
    noddef tree = liscar(as_LIST(as_ID($2)));
    lisdef *lis;
    lis = $3;
    tree = $2;
    $$ = ph1dtn(ph1p, DS_PARAM, 1, (ub4)PPH1LINN(tree, lis));
  }
;

func_return_prm_spec_unconstrained_type:

  SELF_ AS_ RESULT_
  {
    /*
     * SELF AS RESULT is valid as a return type only in ADTs - if we are in
     * a ADT context here, setup the ADT itself as the return type. If not,
     * this usage is erroneous, setup SELF as the return type and let PH2
     * deal with it.
     */
    $$ = ph1dti(ph1p, DI_U_NAM,
                ph1p->ph1adt ? l_SYMREP(ph1p->ph1adt) : P_SELF);
    L_defaul($$, PHD_SELF_AS_RESULT);
  }
|
  prm_spec_unconstrained_type
  {
      $$ = $1;
  }
;

prm_spec_unconstrained_type:

  unconstrained_type charset_spec_opt
  {
    if ($2 == TRENULL)
    {
      $$ = $1;
    }
    else
    {
      $$ = ph1dtn(ph1p, D_CONSTR, 3, (ub4)$1, (ub4)TRENULL, (ub4)0);
      A_cs($$, $2);
    }
  }
;

prm_spec:

  ident mode prm_spec_unconstrained_type default_expr_opt
  {
    if ( $2 == T_IN )
    {
      ub4 param = (ub4)ph1nfs(ph1p, $1, D_IN);
      $$ = ph1dtn(ph1p, D_IN, 4, param, (ub4)$3, (ub4)$4, (ub4)TRENULL);
    }
    else if ( $2 == T_IN_OUT )
         {
           ub4 param = (ub4)ph1nfs(ph1p, $1, D_IN_OUT);
           $$ = ph1dtn(ph1p, D_IN_OUT, 4, param, (ub4)$3,
                       (ub4)$4, (ub4)TRENULL);
         }
         else if ( $2 == T_OUT )
              {
                ub4 param = (ub4)ph1nfs(ph1p, $1, D_OUT);
                $$ = ph1dtn(ph1p, D_OUT, 4,
                            param, (ub4)$3, (ub4)$4, (ub4)TRENULL);
              }
  }
|
  ident IN_ OUT_ NOCOPY_ unconstrained_type charset_spec_opt default_expr_opt
  {
    ub4 param;
    ub4 type_tree;

    ub2 prev_aflags;

    lisdef* ident_list;
    noddef ident;

    param = (ub4)ph1nfs(ph1p, $1, D_IN_OUT);

    /*
     * For every identifier in the 'ident' list, set the NOCOPY_MODIFIER
     * bit to indicate that the compiler should attempt to pass the argument
     * by reference.
     */

    for (ident_list = $1; lismor(ident_list); ident_list = liscdr(ident_list))
    {
      ident = (noddef) liscar(ident_list);

      prev_aflags = a_FLAGS(ident);
      bis(prev_aflags, PHD_NOCOPY_MODIFIER);
      A_flags(ident, prev_aflags);
    }
    /*
     * Process the "type charset_spec_opt" part of the production (that is,
     * construct the tree for the type and incorporate the char set
     * specification.The work done here is similar to that done in the
     * production:
     *              prm_spec_unconstrained_type : type charset_spec_opt
     * These two productions should be kept in sync;I had to introduce this
     * production because when NOCOPY_ needs to be treated as a type, type
     * needs to be empty; changing prm_spec_unconstrained_type will break
     * other code.
     */

    if ($6 == TRENULL)
    {
      type_tree = $5;
    }
    else
    {
      type_tree = ph1dtn(ph1p, D_CONSTR, 3, (ub4)$5, (ub4)TRENULL, (ub4)0);
      A_cs(type_tree, $6);
    }

    $$ = ph1dtn(ph1p, D_IN_OUT, 4, param, type_tree, (ub4)$7, (ub4)TRENULL);
  }
|
  ident OUT_ NOCOPY_ unconstrained_type charset_spec_opt default_expr_opt
  {
    ub4 param;
    ub4 type_tree;

    ub2 prev_aflags;

    lisdef* ident_list;
    noddef ident;

    param = (ub4)ph1nfs(ph1p, $1, D_OUT);

    /*
     * For every identifier in the 'ident' list, set the NOCOPY_MODIFIER
     * bit to indicate that the compiler should attempt to pass the argument
     * by reference.
     */

    for (ident_list = $1; lismor(ident_list); ident_list = liscdr(ident_list))
    {
      ident = (noddef) liscar(ident_list);

      prev_aflags = a_FLAGS(ident);
      bis(prev_aflags, PHD_NOCOPY_MODIFIER);
      A_flags(ident, prev_aflags);
    }

    /* See comment Process the "type charset_spec_opt.. in above procduction */
    if ($5 == TRENULL)
    {
      type_tree = $4;
    }
    else
    {
      type_tree = ph1dtn(ph1p, D_CONSTR, 3, (ub4)$4, (ub4)TRENULL, (ub4)0);
      A_cs(type_tree, $5);
    }

    $$ = ph1dtn(ph1p, D_OUT, 4, param, type_tree, (ub4)$6, (ub4)TRENULL);
  }
|
  ident IN_ OUT_ NOCOPY_ charset_spec_opt default_expr_opt
  {
    /* Treat NOCOPY as an user-specified type. */
    ub4 param;
    ub4 type_tree;

    param = (ub4)ph1nfs(ph1p, $1, D_IN_OUT);

    /* See comment Process the "type charset_spec_opt.. in above procduction */
    if ($5 == TRENULL)
    {
      type_tree = $4;
    }
    else
    {
      type_tree = ph1dtn(ph1p, D_CONSTR, 3, (ub4)$4, (ub4)TRENULL, (ub4)0);
      A_cs(type_tree, $5);
    }

    $$ = ph1dtn(ph1p, D_IN_OUT, 4, param, type_tree, (ub4)$6, (ub4)TRENULL);
  }
|
  ident OUT_ NOCOPY_ charset_spec_opt default_expr_opt
  {
    /* Treat NOCOPY as an user-specified type. */
    ub4 param;
    ub4 type_tree;

    param = (ub4)ph1nfs(ph1p, $1, D_OUT);

    /* See comment Process the "type charset_spec_opt.. in above production */
    if ($4 == TRENULL)
    {
      type_tree = $3;
    }
    else
    {
      type_tree = ph1dtn(ph1p, D_CONSTR, 3, (ub4)$3, (ub4)TRENULL, (ub4)0);
      A_cs(type_tree, $4);
    }

    $$ = ph1dtn(ph1p, D_OUT, 4, param, type_tree, (ub4)$5, (ub4)TRENULL);
  }
|
  ident ELLIPSIS_
  {      
    /* ellipsis type */
    ub4 param = (ub4)ph1nfs(ph1p, $1, D_IN);
    ptnod ellip = ph1dti(ph1p, D_ELLIPSIS, (text *)"ELLIPSIS");
    $$ = ph1dtn(ph1p, D_IN, 2, param, ellip);
  }
/*
|
  ident ':' mode unconstrained_type default_expr_opt
  {
    if ( $3 == T_IN )
      $$ = ph1dtn(ph1p, D_IN, 3,
                  (ub4)ph1nfs(ph1p, $1, D_IN), (ub4)$4, (ub4)$5);
    else if ( $3 == T_IN_OUT )
      $$ = ph1dtn(ph1p, D_IN_OUT, 3,
                  (ub4)ph1nfs(ph1p, $1, D_IN_OUT), (ub4)$4, (ub4)$5);
    else if ( $3 == T_OUT )
      $$ = ph1dtn(ph1p, D_OUT, 3,
                  (ub4)ph1nfs(ph1p, $1, D_OUT), (ub4)$4, (ub4)$5);
  }
*/

;

mode:

  IN_opt
  {
    $$ = T_IN;
  }
|
  IN_ OUT_
  {
    $$ = T_IN_OUT;
  }
|
  OUT_
  {
    $$ = T_OUT;
  }
;

is_or_as:

  IS_
|
  AS_
;


/* external... rules are Foreign Function Syntax */

external_name:

  identifier
  {
    $$ = $1;
  }
;

external_library:

  name
  {
    $$ = $1;
  }
;

external_parameter:

  identifier
  {
    $$ = $1;
  }
;

external_parameter_style_token:

  ORACLE_
  {
    $$ = PFFOPORACLE;
  }
|
  NATIVE_
  {
    $$ = PFFOPNATIVE;
  }
|
  SQL_
  {
    $$ = PFFOPSQL;
  }
|
  GENERAL_
  {
    $$ = PFFOPGENERAL;
  }
;

external_language:

  C_
  {
    $$ = PFFOLC;
  }
;

external_calling_standard:

  C_
  {
    $$ = PFFOCC;
  }
|
  PASCAL_
  {
    $$ = PFFOCPASCAL;
  }
;

external_indicator_token:

  INDICATOR_                       /* INDICATOR keyword in parameters clause */
  {
    $$ = PFFEIINDICATOR;
  }
|
  LENGTH_                             /* LENGTH keyword in parameters clause */
  {
    $$ = PFFEILENGTH;
  }
|
  MAXLEN_                             /* MAXLEN keyword in parameters clause */
  {
    $$ = PFFEIMAXLEN;
  }
|
  TDO_                                   /* TDO keyword in parameters clause */
  {
    /* TDO is shared with LENGTH, bit PFFEF2OVERLOAD also set */
    $$ = PFFEITDO | PFFEF2OVERLOAD;
  }
|
  DURATION_                         /* DURATION keyword in parameters clause */
  {
    /* DURATION is shared with MAXLENGTH, bit PFFEF2OVERLOAD also set */
    $$ = PFFEIDURATION | PFFEF2OVERLOAD;
  }
|
  CHARSETID_                       /* CHARSETID keyword in parameters clause */
  {
    $$ = PFFEIID;
  }
|
  CHARSETFORM_                   /* CHARSETFORM keyword in parameters clause */
  {
    $$ = PFFEIFORM;
  }
;

external_indicator_mode:

  /* empty */
  {
    $$ = PFFEMUNSP;
  }
|
  IN_
  {
    $$ = PFFEMIN;
  }
|
  OUT_
  {
    $$ = PFFEMOUT;
  }
|
  IN_ OUT_
  {
    $$ = PFFEMIO;
  }
;

external_indicator_or_len:

  /* empty */
  {
    $$ = PFFEIMUNSP;
  }
|
  external_indicator_token external_indicator_mode
  {
    $$ = $1 | $2;
  }
|
  NATIVE_
  {
    $$ = PFFEF2PNTY;
  }
;

external_type:

  /* empty */
  {
    $$ = PFFTUNSP;
  }
|
  CHAR_
  {
    $$ = PFFTCHAR;
  }
|
  SHORT_
  {
    $$ = PFFTSHORT;
  }
|
  INT_
  {
    $$ = PFFTINT;
  }
|
  LONG_
  {
    $$ = PFFTLONG;
  }
|
  SB1_
  {
    $$ = PFFTSB1;
  }
|
  SB2_
  {
    $$ = PFFTSB2;
  }
|
  SB4_
  {
    $$ = PFFTSB4;
  }
|
  UNSIGNED_ CHAR_
  {
    $$ = PFFTUCHAR;
  }
|
  UNSIGNED_ SHORT_
  {
    $$ = PFFTUSHORT;
  }
|
  UNSIGNED_ INT_
  {
    $$ = PFFTUINT;
  }
|
  UNSIGNED_ LONG_
  {
    $$ = PFFTULONG;
  }
|
  UB1_
  {
    $$ = PFFTUB1;
  }
|
  UB2_
  {
    $$ = PFFTUB2;
  }
|
  UB4_
  {
    $$ = PFFTUB4;
  }
|
  SIZE_T_
  {
    $$ = PFFTSIZE_T;
  }
|
  DOUBLE_
  {
    $$ = PFFTDOUBLE;
  }
|
  DOUBLE_ NATIVE_
  {
    $$ = PFFTLDOUBLE;
  }
|
  FLOAT_
  {
    $$ = PFFTFLOAT;
  }
|
  FLOAT_ NATIVE_
  {
    $$ = PFFTLFLOAT;
  }
|
  OCINUMBER_
  {
    $$ = PFFTOCINUMBER;
  }
|
  OCISTRING_
  {
    $$ = PFFTOCISTRING;
  }
|
  ORLVARY_
  {
    $$ = PFFTORLVARY;
  }
|
  OCIRAW_
  {
    $$ = PFFTOCIRAW;
  }
|
  OCIDATE_
  {
    $$ = PFFTOCIDATE;
  }
|
  ORLANY_
  {
    $$ = PFFTORLANY;
  }
|
  RAW_
  {
    $$ = PFFTRAW;
  }
|
  STRING_
  {
    $$ = PFFTSTRING;
  }
|
  STRUCT_
  {
    $$ = PFFTSTRUCT;
  }
|
  ARRAY_
  {
    $$ = PFFTARRAY;
  }
|
  VOID_
  {
    $$ = PFFTVOID;
  }
|
  VALIST_
  {
    $$ = PFFTVALIST;
  }
|
  OCITYPE_
  {
    $$ = PFFTOCITYPE;
  }
|
  OCIDURATION_
  {
    $$ = PFFTOCIDURATION;
  }
|
  OCILOBLOCATOR_
  {
    $$ = PFFTOCILOBLOCATOR;
  }
|
  OCICOLL_
  {
    $$ = PFFTOCICOLL;
  }
|
  OCIREF_
  {
    $$ = PFFTOCIREF;
  }
|
  OCIROWID_
  {
    $$ = PFFTOCIUROWID;
  }
|
  OCIDATETIME_
  {
    $$ = PFFTOCIDATETIME;
  }
|
  OCIINTERVAL_
  {
    $$ = PFFTOCIINTERVAL;
  }
|
  OCIREFCURSOR_
  {
    $$ = PFFTOCIREFCURSOR ;
  }
;

external_options:

  /* empty */
  {
    $$ = PFFEFUNSP;
  }
|
  BY_ VALUE_
  {
    $$ = PFFEFVALUE | PFFEFVBIT;
  }
|
  BY_ REFERENCE_
  {
    $$ = PFFEFVBIT;
  }
;

external_parm_list_name_and_indicator:

  SQLCODE_
  {
    $$ = ph1dtn(ph1p, D_X_CODE, 2, PFFEUNSP, PFFTUNSP);
  }
|
  SQLSTATE_
  {
    $$ = ph1dtn(ph1p, D_X_STAT, 2, PFFEUNSP, PFFTUNSP);
  }
|
  SQLNAME_
  {
    $$ = ph1dtn(ph1p, D_X_NAME, 2, PFFEUNSP, PFFTUNSP);
  }
|
  CONTEXT_
  {
    $$ = ph1dtn(ph1p, D_X_CTX, 2, PFFEUNSP, PFFTUNSP);
  }
|
  RETURN_ external_indicator_or_len
  {
    $$ = ph1dtn(ph1p, D_X_RETN, 2, $2, PFFTUNSP);
  }
|
  external_parameter external_indicator_or_len
  {
    $$ = ph1dtr(ph1p, $1, D_X_FRML);
    A_flags($$, (ub2) $2);
    A_ext_ty($$, PFFTUNSP);
  }
;

external_parm_list_entry:

  external_parm_list_name_and_indicator external_options external_type
  {
    ub2 tmp = a_FLAGS($1);
    ub2 extty;

    /*
     * This is a hack to parse --> INDICATOR [STRUCT] STRUCT is a datatype
     * as well as qualifier for INDICATOR and with the way the grammar is
     * now, I could not add a production without creating a shift-reduce
     * conflict. Hence this hack.we check if we found an indicator and the
     * user had mentioned STRUCT the we turn it around and set the
     * COMPOSITE bit
     */

    if (((tmp & PFFEIMASK) == PFFEIINDICATOR) && ($3 == PFFTSTRUCT))
    {
      extty = PFFTINDSTRUCT;                     /* Type is indicator struct */
      PFF_SET_OVERLOADED(tmp);                        /* Set Overloaded flag */
    }
    else
    {
      extty = (ub2) $3;
    }

    bis(tmp, (ub2) $2);
    A_flags($1, tmp);
    A_ext_ty($1, extty);
    $$ = $1;
  }
;

external_parm_list_entry_opt:

  /* empty */
  {
    $$ = lismak();
  }
|
  external_parm_list_entry_opt ',' external_parm_list_entry
  {
    $$ = PH1LAPN($3, $1);
  }
;

external_parameter_list:

  '(' external_parm_list_entry external_parm_list_entry_opt ')'
  {
    $$ = ph1dtn(ph1p, DS_X_PARM, 1, (ub4)PPH1LINN($2, $3));
  }
;

external_parameter_list_opt:

  /* empty */
  /* the lack of external parm list entries means the ff takes no parms*/
  {
    $$ = ph1dtn(ph1p, DS_X_PARM, 1, (ub4)llismak());
  }
|
  external_parameter_list
;


/* C External Procedures Syntax */

c_external_ops:

  /* Empty */
  {
    $$  = (ub4)ph1dtn(ph1p, D_EXTERNAL, 7, (ub4)TRENULL, (ub4)TRENULL,
                     (ub4)TRENULL, (ub2)PFFOLUNSP, (ub2)PFFOCUNSP,
                     (ub2)PFFOPUNSP, (ub4)PFFOMISCUNSP);
  }
|
  c_external_ops external_name_ops              /* NAME <name-of-c-function> */
  {
    ptnod newname = ph1dti(ph1p, D_STRING, l_SYMREP($2));

    if (!(l_DEFAUL($2) & PHD_QUOTED_ID))                    /* Not quoted ID */
      DISCARD(LOWER_CASE(l_SYMREP(newname)));

    $$ = $1;
    if (a_NAME($1))
    {
      PH1ERR(139, SEVERROR, $1, PLSUNIQ(16));
    }
    else
    {
      A_name($$, newname);
    }
  }
|
  c_external_ops LIBRARY_ external_library          /* External LIBRARY name */
  {
    $$ = $1;
    if (a_LIB($1))
    {
      PH1ERR(140, SEVERROR, $1, PLSUNIQ(17));
    }
    else
    {
      A_lib($$, $3);
    }
  }
|
  c_external_ops PARAMETER_ STYLE_ external_parameter_style_token
  /* Parameter style */
  {
    $$ = $1;
    if (a_STYLE($1))
    {
      PH1ERR(141, SEVERROR, $1, PLSUNIQ(18));
    }
    else
    {
      A_style($$, (ub2) $4);
    }
  }
|
  c_external_ops PARAMETERS_ external_parameter_list_opt/* parameters clause */
  {
    $$ = $1;
    if (as_PARMS($1))
    {
      PH1ERR(142, SEVERROR, $1, PLSUNIQ(19));
    } else
    {
      AS_parms($$, $3);
    }
  }
|
  c_external_ops LANGUAGE_ external_language                     /* Language */
  {
    $$ = $1;
    if (a_LANG($1))
    {
      PH1ERR(143, SEVERROR, $1, PLSUNIQ(20));
    }
    else
    {
      A_lang($$, (ub2) $3);
    }
  }
|
  c_external_ops CALLING_ STANDARD_ external_calling_standard
  /* calling standard */
  {
    $$ = $1;
    if (a_CALL($1))
    {
      PH1ERR(144, SEVERROR, $1, PLSUNIQ(21));
    }
    else
    {
      A_call($$, (ub2) $4);
    }
  }
|
  c_external_ops WITH_ CONTEXT_                              /* with context */
  {
    ub2 tmp = a_FLAGS($1);
    $$ = $1;
    if (bit(tmp, PFFOMBITWITHCONTEXT))
    {
      PH1ERR(145, SEVERROR, $1, PLSUNIQ(22));
    }
    else
    {
      bis(tmp, PFFOMWITHCONTEXT | PFFOMBITWITHCONTEXT);
      A_flags($$, tmp);
    }
  }
|
  c_external_ops AGENT_ IN_ '(' identifier ')'
  {
    ub2 flags = a_FLAGS($1);

    $$ = $1;

    if (a_AGENT($1))
    {
      PH1ERR(171, SEVERROR, $1, PLSUNIQ(23));
    }
    else
    {
      A_agent($$, (ub4)$5);

      /* Set the flag to indicate that a agent was specified */
      bis(flags, PFFOMEPAGTARG);
      A_flags($$, flags);
    }
  }
;

/* Java external procedures syntax */

java_external_ops:

  NAME_ string_literal                              /* java method signature */
  {
    ptnod signature = ph1dti(ph1p, D_STRING, $2);
    $$  = (ub4)ph1dtn(ph1p, D_EXTERNAL, 7, (ub4)signature, (ub4)TRENULL,
                      (ub4)TRENULL, (ub2)PFFOCUNSP, (ub2)PFFOLJAVA,
                      (ub2)PFFOPUNSP, (ub4)PFFOMISCUNSP);
  }
;

/* DOTNET external procedures syntax */

dotnet_external_ops:

  /* Empty */
  {
    $$  = (ub4)ph1dtn(ph1p, D_EXTERNAL, 7, (ub4)TRENULL, (ub4)TRENULL,
                      (ub4)TRENULL, (ub2)PFFOLUNSP, (ub2)PFFOLDOTNET,
                      (ub2)PFFOPUNSP, (ub4)PFFOMISCUNSP, (ub4)TRENULL,
                      (ub2)PFFDNSLVL0);
  }
|
  dotnet_external_ops NAME_ string_literal  /* NAME <sig-of-dotnet-function> */
  {
    ptnod newname;

    $$ = $1;
    if (a_NAME($1))
    {
      PH1ERR(139, SEVERROR, $1, PLSUNIQ(16));
    }
    else
    {
      newname = ph1dti(ph1p, D_STRING, $3);
      A_name($$, newname);
    }
  }
|
  dotnet_external_ops ASSEMBLY_ dotted_name  /* External ASSEMBLY name */
  {
    $$ = $1;
    /* Save the assembly in the library field */
    if (a_LIB($1))
    {
      PH1ERR(1915, SEVERROR, $1, PLSUNIQ(16));
    }
    else
    {
      A_lib($$, $3);
    }
  }
|
  dotnet_external_ops SECURITY_ SAFE_                 /* Safe security level */
  {
    $$ = $1;
    if (a_SECURITY($1))
    {
      PH1ERR(1914, SEVERROR, $1, PLSUNIQ(24));
    }
    else
    {
      A_security($$, PFFDNSLVL0);
    }
  }
|
  dotnet_external_ops SECURITY_ EXTERNAL_0_     /* External 0 security level */
  {
    $$ = $1;
    if (a_SECURITY($1))
    {
      PH1ERR(1914, SEVERROR, $1, PLSUNIQ(24));
    }
    else
    {
      A_security($$, PFFDNSLVL1);
    }
  }
|
  dotnet_external_ops SECURITY_ EXTERNAL_1_     /* External 1 security level */
  {
    $$ = $1;
    if (a_SECURITY($1))
    {
      PH1ERR(1914, SEVERROR, $1, PLSUNIQ(24));
    }
    else
    {
      A_security($$, PFFDNSLVL2);
    }
  }
|
  dotnet_external_ops SECURITY_ EXTERNAL_2_     /* External 2 security level */
  {
    $$ = $1;
    if (a_SECURITY($1))
    {
      PH1ERR(1914, SEVERROR, $1, PLSUNIQ(24));
    }
    else
    {
      A_security($$, PFFDNSLVL3);
    }
  }
|
  dotnet_external_ops SECURITY_ UNSAFE_             /* UnSafe security level */
  {
    $$ = $1;
    if (a_SECURITY($1))
    {
      PH1ERR(1914, SEVERROR, $1, PLSUNIQ(24));
    }
    else
    {
      A_security($$, PFFDNSLVL4);
    }
  }

;

/* External Procedures NAME clause */

external_name_ops:

  NAME_ external_name
  {
    $$ = $2;
  }
;

/* CALL-Specification Syntax : LANGUAGE < C | JAVA | DOTNET > .... */

external_language_decl:

  C_ c_external_ops
  {
    /* $2 is a D_EXTERNAL diana node */
    $$ = $2;
    if (a_LANG($2))
    {
      PH1ERR(143, SEVERROR, $2, PLSUNIQ(24));
    }
    else
    {
      A_lang($$, PFFOLC);
    }
  }
|
  JAVA_ java_external_ops
  {
    /* $2 is a D_EXTERNAL diana node */
    $$ = $2;
  }
|
  DOTNET_ dotnet_external_ops
  { 
    /* $2 is a D_EXTERNAL diana node */
    $$ = $2;
  }
;

subprg_body:

  /* subprg_spec is already constructed here.Rather than change the syntax, */
  /* we just decompose it and eat the components                            */

  subprg_spec is_or_as
    decl_list_opt
  BEGIN_
    seq_of_stmts
  exception_handlers_opt
    END_ designator_opt ';'
  {
    ub4 tmp1;
    ub4 tmp2;

    ph1chk(ph1p, $8, a_D_($1));
    tmp1 = (ub4)ph1dtn(ph1p, DS_ITEM, 1, PH1PSQ($3));
    tmp2 = (ub4)ph1dtn(ph1p, D_BLOCK, 3, tmp1, (ub4)$5, (ub4)$6);
    $$ = ph1dtn(ph1p, D_S_BODY, 3, (ub4)a_D_($1), (ub4)a_HEADER($1), tmp2);
    tredes(pgap, $1);

    L_srclin(tmp2, SRCLINE(1));  L_srccol(tmp2, SRCCOL(1));
    A_beglin(tmp2, SRCLINE(4));  A_begcol(tmp2, SRCCOL(4));
    A_endlin(tmp2, SRCLINE(7));  A_endcol(tmp2, SRCCOL(7));

    L_srclin($$, SRCLINE(1));  L_srccol($$, SRCCOL(1));
    A_beglin($$, SRCLINE(4));  A_begcol($$, SRCCOL(4));
    A_endlin($$, SRCLINE(7));  A_endcol($$, SRCCOL(7));

    PH1POP;

   pgap->_plsprslen = LXPD(ph1p->ph1stp, plsnglo);
  }
|
  ff_w_external ';'
  {
    $$ = $1;
    PH1POP;
  }
;

/* Invoker's rights additions */

authid:

  AUTHID_ identifier
  {
    $$ = $2;
  }
;

package_properties_opt:

  /* Empty */
  {
    $$ = TRENULL;
  }
|
  package_properties_opt authid
  {
    if (ph1p->ph1authid)          /* Don't allow duplicate declarations */
    {
      PH1ERRS(371, SEVERROR, $2, PLSUNIQ(45), (text *) "AUTHID");
    }
    else
    {
      ph1p->ph1authid = (text *) l_SYMREP($2);
    }
    $$ = TRENULL;
  }
|
  package_properties_opt white_list
  {
    if (ph1p->ph1whitelist)          /* Don't allow duplicate declarations */
    {
      PH1ERRS(371, SEVERROR, $2, PLSUNIQ(46), (text *) "ACCESSIBLE BY");
    }
    else
    {
      ph1p->ph1whitelist = $2;
    }
    $$ = TRENULL;
  }
|
  package_properties_opt default_collation
  {
    $$ = TRENULL;
  }
;

operator_definition:

  OPERATOR_ identifier is_or_as
    {
      $2 = ph1dtr(ph1p, $2, DI_OPSP);
      ph1p->ph1operator = $2;
      PH1PSH;
    }
    basic_operator_decl_item_list
  END_ identifier_opt
  {
    ub4 tmp1;
    ub4 tmp2;
    ub4 tmp3;

    ph1chk(ph1p, $7, $2);
    PH1POP;
    tmp1 = (ub4)ph1dtn(ph1p, DS_DECL, 1, PH1PSQ($5));
    tmp2 = (ub4)ph1dtn(ph1p, DS_DECL, 1, PH1PSQ(lismak()));
    tmp3 = (ub4)ph1dtn(ph1p, D_P_SPEC, 2, tmp1, tmp2);
    $$ = ph1dtn(ph1p, D_P_DECL, 2, (ub4)$2, tmp3);
    A_endlin($$, SRCLINE(6));
    A_endcol($$, SRCCOL(6));
  }
;

pkg_spec:

  PACKAGE_ identifier package_properties_opt is_or_as
    {
      ph1pp_set_unit_info(ph1p, (oratext *)l_SYMREP($2), 
                          (oratext *)"PACKAGE"); 
      $2 = ph1dtr(ph1p, $2, DI_PACKA);
      AS_whtlst($2, ph1p->ph1whitelist);
      PH1PSH;
    }
    basic_decl_item_list
  END_ identifier_opt
  {
    ub4 tmp1;
    ub4 tmp2;
    ub4 tmp3;

    ph1chk(ph1p, $8, $2);
    PH1POP;
    tmp1 = (ub4)ph1dtn(ph1p, DS_DECL, 1, PH1PSQ($6));
    tmp2 = (ub4)ph1dtn(ph1p,DS_DECL,1,PH1PSQ(lismak()));
    tmp3 = (ub4)ph1dtn(ph1p,D_P_SPEC,2, tmp1, tmp2);
    $$ = ph1dtn(ph1p,D_P_DECL,2, (ub4)$2, tmp3);
    A_endlin($$, SRCLINE(7));
    A_endcol($$, SRCCOL(7));
  }
;

cmp_trg_stmts_opt:

 compound_trg_stmts
 {
      $$ =  PH1LAPN($1 , lismak());
 }
|
 cmp_trg_stmts_opt  compound_trg_stmts
  { 
   
      $$ = PH1LAPN($2 , $1);
  }
;


before_or_after:
  BEFORE_
  {
    ptnod node = ph1dti(ph1p,
                        DI_U_NAM,
                        (text *)"BEFORE");
    L_defaul(node, PHD_CMP_TRG_BEFORE );
    $$= node;
  }
|
  AFTER_
  {
    ptnod node = ph1dti(ph1p,
                        DI_U_NAM,
                        (text *)"AFTER");
    L_defaul(node,  PHD_CMP_TRG_AFTER );
    $$= node;
  }
;
row_or_stmt:
    EACH_ ROW_
     {
    ptnod node = ph1dti(ph1p,
                        DI_U_NAM,
                        (text *)"ROW");
    L_defaul(node, PHD_CMP_TRG__ROW);
    $$= node;
  }
|
  STATEMENT_
  {
   ptnod node = ph1dti(ph1p,
                        DI_U_NAM,
                        (text *)"STATEMENT");
   L_defaul(node, PHD_CMP_TRG_STATEMENT );
   $$= node;
  }
;
table_stmt:
   before_or_after row_or_stmt IS_
   {
     ub4 bf_flags = l_DEFAUL($1); /* before/after flags */
     ub4 rs_flags = l_DEFAUL($2); /* row/statement flags */
     kktCompoundTriggerStates state = kktInvalid_Trigger;

     /* Create new scope for before/after row/statements */
     PH1PSH;
   
     if (bit(bf_flags, PHD_CMP_TRG_BEFORE ) && 
         bit(rs_flags, PHD_CMP_TRG__ROW ))
     {
       bic(ph1p->ph1misc, PH1_AFTER_ROW_SECTION);
       state = kktBefore_Row;
       bis(ph1p->ph1misc, PH1_BEFORE_ROW_SECTION);
     }

     if (bit(bf_flags, PHD_CMP_TRG_AFTER  ) && 
         bit(rs_flags, PHD_CMP_TRG__ROW ))
     {
       bic(ph1p->ph1misc, PH1_BEFORE_ROW_SECTION);
       state = kktAfter_Row;
       bis(ph1p->ph1misc, PH1_AFTER_ROW_SECTION);
     }

     if ( PSDSETTRGCBSTS_FPTR && CLIENTCO)
       PSDSETTRGCBSTS_REF(CLIENTCO, state);
   }
   decl_list_opt
   BEGIN_
   seq_of_stmts
   exception_handlers_opt
 
 END_ before_or_after row_or_stmt ';'
 {
   ub4 bf_flags = l_DEFAUL($1); /* before/after flags */
   ub4 rs_flags = l_DEFAUL($2); /* row/statement flags */
   ub2 block_flags = 0;
   ub4 tmp1;


   tmp1 = (ub4)ph1dtn(ph1p, DS_ITEM, 1, PH1PSQ($5));
 
 
   $$ = (ub4)ph1dtn(ph1p, D_BLOCK, 3, (ub4)tmp1, (ub4)$7, (ub4)$8);
   
   L_srclin($$, SRCLINE(1));  L_srccol($$, SRCCOL(1));
   A_beglin($$, SRCLINE(4));  A_begcol($$, SRCCOL(4));
   A_endlin($$, SRCLINE(7));  A_endcol($$, SRCCOL(7));
   

   if (bit(bf_flags, PHD_CMP_TRG_BEFORE ) && 
       bit(rs_flags, PHD_CMP_TRG_STATEMENT))
     bis ( block_flags, PHD_BEFORE_STATEMENT );

   if (bit(bf_flags, PHD_CMP_TRG_BEFORE ) && 
       bit(rs_flags, PHD_CMP_TRG__ROW     ))
     bis ( block_flags,  PHD_BEFORE_ROW   );
   
   if (bit(bf_flags, PHD_CMP_TRG_AFTER  ) && 
       bit(rs_flags, PHD_CMP_TRG__ROW     ))
     bis ( block_flags,  PHD_AFTER_ROW  );
   
   if (bit(bf_flags, PHD_CMP_TRG_AFTER  ) && 
       bit(rs_flags,    PHD_CMP_TRG_STATEMENT ))
     bis ( block_flags,  PHD_AFTER_STATEMENT  );
   
   A_flags($$, block_flags);
   ph1chk(ph1p, $1, $10);
   ph1chk(ph1p, $2, $11);
   /* Pop scope for before/after row/statements */
   PH1POP;
 }
;

compound_trg_stmts:
  table_stmt 
  {
    $$= $1;
  }
|
  INSTEAD_ OF_ EACH_ ROW_ IS_
   {
     /* Create new scope for instead of */
     PH1PSH;
   }
   decl_list_opt
   BEGIN_
   seq_of_stmts
   exception_handlers_opt
   
 END_ INSTEAD_ OF_ EACH_ ROW_ ';'
   {
     ub2 block_flags = 0;
     ub4 tmp1;
     

     tmp1 = (ub4)ph1dtn(ph1p, DS_ITEM, 1, PH1PSQ($7));
  
  
     $$ = (ub4)ph1dtn(ph1p, D_BLOCK, 3, (ub4)tmp1, (ub4)$9, (ub4)$10);
     
     L_srclin($$, SRCLINE(1));  L_srccol($$, SRCCOL(1));
     A_beglin($$, SRCLINE(4));  A_begcol($$, SRCCOL(4));
     A_endlin($$, SRCLINE(7));  A_endcol($$, SRCCOL(7));
     bis ( block_flags,    PHD_INSTEAD_OF_ROW    );
     A_flags($$, block_flags);
     /* Pop scope for instead of row */
     PH1POP;
     
   }
;
compound_trg_body:     

  COMPOUND_ TRIGGER_  
  {
    /* Create new scope for Compound Trigger as whole */
     PH1PSH;
  }
  decl_list_opt 
  {
    /* Create new scope for Compound Trigger body */
     PH1PSH;
  }
  cmp_trg_stmts_opt 

  END_ identifier_opt ';'
  { 
    ub4 tmp1;
    ub4 tmp2;
    ub2 flags = 0;
    ub4 tmp3;
    size_t   len;
    text *name;
    kglna   *na;

    tmp1 = (ub4)ph1dtn(ph1p, DS_ITEM, 1, PH1PSQ($4));
    tmp2 = (ub4)ph1dtn(ph1p, DS_STM,  1, PH1PSQ($6));

    /* Create an empty exception handler list to keep
    ** the semantic analysis happy 
    */
    tmp3 = ph1dtn(ph1p, DS_ALTER, 1, (ub4)llismak());
    
    $$   = (ub4)ph1dtn(ph1p, D_BLOCK, 3, tmp1, tmp2 , tmp3);
    bis(flags, PHD_COMPOUND_TRIGGER);
    A_flags($$, flags);

    /* Check if the trigger name matches with the optional identifier */
    na = plsclu->kglhdnam;
    
    len = na->kglnaobl;
    name = KGLNAOBJ(na);
    
    
    if (len > 0)
    {
      text *tmp;
      ptnod node;
      
      tmp = (text *)hepnfp(plskgp, plschp, len + 1, TRUE, 
                           "Compound Trigger Name");
      
      DISCARD(strncpy((char *)tmp, (char *)name, len));
      tmp[len] = 0;
      
      node = ph1dti(ph1p,
                    DI_U_NAM,
                    (text *)tmp);
      ph1chk(ph1p, $8, node);
    }

    A_beglin($$, SRCLINE(1));  A_begcol($$, SRCCOL(1));
    A_endlin($$, SRCLINE(7));  A_endcol($$, SRCCOL(7));

    /* Pop scope for Compound Trigger body */
    PH1POP;
    /* Pop scope for Compound Trigger as whole */
    PH1POP;
  }
;

pkg_body:          /* insert the decl part in already constructed block stub */

  PACKAGE_ BODY_ identifier is_or_as
    {
      ph1pp_set_unit_info(ph1p, (oratext *)l_SYMREP($3),
                          (oratext*)"PACKAGE BODY");
      DISCARD(ph1dtr(ph1p, $3, DI_PACKA));
      PH1PSH;
    }
    decl_list_opt
    block_opt
  END_ identifier_opt ';'
  {
    noddef tmp1;

    ph1chk(ph1p, $9, $3);
    PH1POP;
    tmp1 = ph1dtn(ph1p, DS_ITEM, 1, PH1PSQ($6));
    AS_item($7, tmp1);
    $$ = ph1dtn(ph1p, D_P_BODY, 2, (ub4)$3, (ub4)$7);
    if ($7 != TRENULL)
    {
      A_beglin($$, l_SRCLIN($7));  A_begcol($$, l_SRCCOL($7));

      L_srclin($7, SRCLINE(1));  L_srccol($7, SRCCOL(1));
      A_endlin($7, SRCLINE(8));  A_endcol($7, SRCCOL(8));
    }
    A_endlin($$, SRCLINE(8));  A_endcol($$, SRCCOL(8));
  }
;

/* Break out header to allow AuthID, white list without further conflicts.
   There are many conflicts around "TYPE identifier ...." 
   TODO: rules should be rewriten to eleminate all those shift/reduction
   conflicts. It is too hard to add any elements further. It might have to 
   to change the rules at higher levels.
*/

adt_type_header:

    TYPE_ identifier force_opt default_collation_opt adt_type_spec 
    {
       $$ = $5;
       ph1p->ph1adt = $2;
    }
 |
    TYPE_ identifier force_opt default_collation_opt authid adt_type_spec
    {
       $$ = $6;
       ph1p->ph1adt = $2;
       ph1p->ph1authid = (text *) l_SYMREP($5);
    } 
 |
    TYPE_ identifier force_opt default_collation_opt white_list adt_type_spec
    {
       $$ = $6;
       ph1p->ph1adt = $2;
       AS_whtlst($$, $5);
    } 
 |
    TYPE_ identifier force_opt default_collation_opt authid white_list adt_type_spec
    {
       $$ = $7;
       ph1p->ph1adt = $2;
       ph1p->ph1authid = (text *) l_SYMREP($5);
       AS_whtlst($$, $6);
    } 
 |
    TYPE_ identifier force_opt default_collation_opt white_list authid adt_type_spec
    {
       $$ = $7;
       ph1p->ph1adt = $2;
       ph1p->ph1authid = (text *) l_SYMREP($6);
       AS_whtlst($$, $5);
    } 
;

/* Adt Flags FINAL, INSTANTIABLE */

adt_flags:

  {
    $$ = 0;
  }
|
  adt_flags adt_flag
  {
    /* Check for error conditions */
    ph1padtf_process_adt_flags(ph1p, $1, $2);
    $$ = $1 | $2;
  }
;

adt_flag:

  NOT_opt_INSTANTIABLE
  {
    $$ = $1;
  }
|
  NOT_opt_FINAL 
  {
    $$ = $1;
  }
;


rep_type:

  SQLDATA_
  {
    $$ = SQLDATA_;
  }
| 
  CUSTOMDATUM_
  {
    $$ = CUSTOMDATUM_;
  }
| 
  SERIALIZABLE_
  {
    $$ = SERIALIZABLE_;
  }
|
  ORADATA_
  {
    $$ = ORADATA_;
  }
;

sqlj_type_opt:
  {
    $$ = TRENULL;
  }
|
   EXTERNAL_ NAME_ string_literal LANGUAGE_ JAVA_ USING_ rep_type 
  {
    ptnod class_nm ;
    ub2 tmp;
    if (SQLDATA_ == $7)
        tmp = (ub4)PFFOMSQLDATA;
    if (SERIALIZABLE_ == $7)
        tmp = (ub4)PFFOMSERIALIZED;
    if (CUSTOMDATUM_ == $7)
        tmp = (ub4)PFFOMCUSTOMDATUM;
    if (ORADATA_ == $7)
        tmp = (ub4)PFFOMORADATA;
    class_nm = ph1dti(ph1p, D_STRING, $3);
    $$  = (ub4)ph1dtn(ph1p, D_EXTERNAL, 7, (ub4)class_nm, (ub4)TRENULL,
                      (ub4)TRENULL, (ub2)PFFOCUNSP, (ub2)PFFOLJAVA,
                      (ub2)PFFOPUNSP, (ub4)tmp);
  }
;

adt_specification:

  adt_type_header sqlj_type_opt NOT_BOUND_opt java_class_opt
  {
    ph1p->ph1adtov = PH1ADTOBJECT;
    PH1PSH;
    /* now: ph1cly == PH1LYR */
  }
  '(' adt_field_list_opt ')'
  adt_flags
  {
    /*
     * Remember the FINAL INSTANTIABLE property before processing any changes
     * to the properties by ALTER TYPE statements. This is needed to correctly
     * set the PSDSATR_ALT_FINAL_PROP_CHANGED.
     */
    ph1iatf_init_alter_type_flags(ph1p, (noddef)0, (ub4)($9));
  }
  optional_alter_types
  {
    noddef dr = $1;
    L_srclin(dr, ph1p->ph1tln);           /* set line/col to the word 'type' */
    L_srccol(dr, ph1p->ph1tco);

    /* Now attach the alter types to the D_R_ */
    ph1aat_attach_alter_types(ph1p, dr, $11);

    {
     /*
      * Set AS_LIST of the D_R_ to the list of attributes, methods and
      * pragmas.  For each item in the list, set A_UP to point back to the
      * D_R_.  If we had passed the list to ph1dtn() when creating the
      * D_R_, it would have set the A_UP values for us; AS_list() used
      * directly isn't so nice, and we need to do this ourselves.
      */
      lisdef * l;

      AS_list(dr, $7);
      for (l = $7; !lisemp(l); l = liscdr(l))
      {
        if (liscar(l) && PTATTGOT(plsdiana, liscar(l), A_UP))
          A_up(liscar(l), dr);
      }
    }

     /* ph1cly is layer enclosed by object as set in PH1PSH.PH1LYR is */
     /* meaningless here.See bug 591512, 12/97, ~edarnell             */
     /* ph1cly == PH1LYR from after PH1PSH */
 
     S_layer(dr, ph1p->ph1cly);
     PH1POP;
     $$ = ph1typ(ph1p, ph1p->ph1adt, dr);            /* gets s_layer from dr */

     if (PCIJ_NOT_BOUND == $3)
       A_tflag(dr, a_TFLAG(dr) | PHD_ADT_NOT_BOUND);
     A_name(dr, $4);                          /* optional name of Java class */
     A_external_class(dr, $2);                /* optional name of SQLJ class */
     A_up(dr, $$);

     {
       noddef type_defoccur_name = a_ID($$);
       noddef type_name = ph1dti(ph1p,
                                 DI_U_NAM,
                                 (text *)l_SYMREP(type_defoccur_name));
       noddef ref_type  =  ph1dtn(ph1p, D_T_REF, 1, type_name);
 
       /* make the ref to appear as it was placed textually after type */
       /* definition name                                              */
 
       L_srclin(type_name, ph1p->ph1sln);
       L_srclin(ref_type,  ph1p->ph1sln);
       L_srccol(type_name, ph1p->ph1sco);
       L_srccol(ref_type,  ph1p->ph1sco);
 
       S_record(dr, ref_type);             /* indicates an ADT, not a RECORD */
     }

     /* PH1FLAG(1469, $$); no FIPS flag for adts yet */
     ph1p->ph1adt = 0;
  }
;

adt_body:

  /* new style  body t is ... end; */

  TYPE_ BODY_ identifier is_or_as
  {
      ph1pp_set_unit_info(ph1p, (oratext *)l_SYMREP($3),
                          (oratext *)"TYPE BODY");
      ph1p->ph1adt = $3;
      DISCARD(ph1dtr(ph1p, $3, DI_PACKA));
      PH1PSH;
  }
  body_adt_field_list
  END_ ';'
  {
    ub4 tmp1;
    ub4 tmp2 = (ub4)ph1dtn(ph1p, DS_STM, 1, (ub4)llismak());
    ub4 tmp3 = (ub4)ph1dtn(ph1p, DS_ALTER, 1, (ub4)llismak());
    ub4 blk;

    /* D_BLOCK was created previously by         */
    /* empty_block */

    /*
     * Bug 723078: D_BLOCK should be created before calling to PH1POP.When
     * D_BLOCK diana is created, S_LAYER is filled during the creation and
     * its value would be wrong if we POP before creating this node.
     */

    blk = ph1dtn(ph1p, D_BLOCK, 3, (ub4)0, tmp2, tmp3);
    PH1POP;
    tmp1 = ph1dtn(ph1p, DS_ITEM, 1, PH1PSQ($6));
    AS_item(blk, tmp1);
    $$ = ph1dtn(ph1p, D_P_BODY, 2, (ub4)$3, (ub4)blk);

    A_endlin(blk, SRCLINE(7));  A_endcol(blk, SRCCOL(7));
    A_endlin($$,  SRCLINE(7));  A_endcol($$,  SRCCOL(7));
  }
;

adt_type_spec:

   base_type_spec
|
   sub_type_spec
;

base_type_spec:

  is_or_as object_kind 
  {
    $$ = $2;
  }
;

sub_type_spec:

  UNDER_ dotted_name
  {
     $$ = ph1dtn(ph1p, D_R_, 0);
     A_supertype($$, $2);
  }
;

NOT_opt_INSTANTIABLE:

  NOT_opt INSTANTIABLE_
  {
    $$ = ($1 == T_NOT) ? PH1_NOT_INSTANTIABLE : PH1_INSTANTIABLE;
  }
;

NOT_opt_FINAL:

  NOT_opt FINAL_ 
  {
    $$ = ($1 == T_NOT) ? PH1_NOT_FINAL : PH1_FINAL;
  }
;

object_kind:

  OBJECT_
  {
    $$ = ph1dtn(ph1p, D_R_, 0);
  }
|
  OPAQUE_ opaque_fixed_or_varying '(' opaque_size ')'
  USING_ LIBRARY_ dotted_name
  {
    $$ = ph1dtn(ph1p, D_R_, 0);
    A_tflag($$, a_TFLAG($$) | PHD_ADT_OPAQUE);
    if (FIXED_ == $2)
      A_tflag($$, a_TFLAG($$) | PHD_ADT_OPAQUE_FIXEDLEN);
    A_opaque_size($$, $4);
    A_opaque_uselib($$, $8);
  }
;

opaque_fixed_or_varying:

  FIXED_
  {
    $$ = FIXED_;
  }
| VARYING_
  {
    $$ = VARYING_;
  }
;

opaque_size:

  numeric_literal
  {
    $$ = ph1dti(ph1p, D_NUMERI, $1);
  }
|
  '*'
  {
    $$ = TRENULL;
  }
;

/* 
 * ASSEMBLY <assemblyname> 'filespec';
 */

assembly_spec:

  ASSEMBLY_ identifier is_or_as string_literal identity_opt security_opt
  agent_name_opt assembly_context_opt 
  {
    noddef assembly_name = ph1dtr(ph1p, $2, DI_ASSEMBLY);
    noddef file_name    = TRENULL;
    ub4    flags        = NULLV(ub4);
    noddef identity     = TRENULL;

    file_name = ph1dti(ph1p, D_STRING, $4);
    identity = ph1dtdi(ph1p, D_STRING, $5, $8, $7);

    /* Set "overloaded identity" bit */
    PFFLSETovlident(flags);

    if (NULLP(text) != $7)
    {
      PFFLSETlibdedagt(flags);
    }

    $$ = ph1dtn(ph1p, D_ASSEMBLY, 5, (ub4)assembly_name,
                (ub4)file_name, (ub4)flags, (ub4)identity, $6);
  }
;

/* 
 * LIBRARY <libname> [[un]trusted] is|as STATIC|'filespec' [IN directory_name]
 *   [AGENT 'agent_name'] [CREDENTIAL credential_name] [TRANSACTIONAL]; 
 */

foreign_library_spec:

  LIBRARY_ identifier trusted_or_untrusted is_or_as
  static_or_string_literal directory_name_opt agent_name_opt
  credential_name_opt transactional_opt
  {
    noddef library_name    = ph1dtr(ph1p, $2, DI_LIBRARY);
    noddef file_name       = TRENULL;
    noddef agent_name      = TRENULL;
    ptnod  directory_name  = TRENULL;
    ptnod  credential_name = TRENULL;
    ub4    flags           = NULLV(ub4);

    /* If token was TRUSTED, set the trusted flag */
    if (TRUSTED_ == $3)
      PFFLSETtrusted(flags);

    /* Check if STATIC was specified */
    if (NULLP(text) != $5)
      file_name = ph1dti(ph1p, D_STRING, $5);
    else
      PFFLSETstatic(flags);
    
    if ($6)
    {
      directory_name = $6;
      PFFLSETlibdir(flags);
    }

    if (NULLP(text) != $7)
    {
      agent_name = ph1dti(ph1p, D_STRING, $7);
      PFFLSETlibdedagt(flags);
    }
    
    if ($8)
    {
      credential_name = $8;
      PFFLSETlibcred(flags);
    }

    if ($9 != 0)
    {
      PFFLSETlibtxn(flags);
    }
   
    $$ = ph1dtn(ph1p, D_LIBRARY, 6, (ub4)library_name,
                (ub4)file_name, (ub4)flags, (ub4)agent_name,
                (ub4)directory_name, (ub4)credential_name);
  }
;


trusted_or_untrusted:

  /* empty */
  {
    /* default is UNTRUSTED */
    $$ = UNTRUSTED_;
  }
|
  TRUSTED_
  {
    $$ = TRUSTED_;
  }
|
  UNTRUSTED_
  {
    $$ = UNTRUSTED_;
  }
;


static_or_string_literal:

  STATIC_
  {
    /* Pass up a null string as an indication that this was STATIC */
    $$ = NULLP(text);
  }
|
  string_literal
  {
    text *tmpstr;

    /* Although it is an error to give a zero length string i.e. '' */
    /* The Check for a zero length string will be made later in PH2 */

    /* allocate some memory */
    tmpstr = (text *)hepnfp(plskgp,
                            plschp,                             /* call heap */
                            strlen((char *)$1) + 1,      /* +1 for null term */
                            TRUE,                    /* clear out the memory */
                            "plsql.y: static_or_string_literal");

    DISCARD strcpy ((char *)tmpstr, (char *)$1);
    $$ = tmpstr;
  }
;

directory_name_opt:
  /* empty */
  {
    $$ = TRENULL;
  }
|
  IN_ identifier
  {
    $$ = $2;
  }
;

agent_name_opt:
  /* empty */
  {
    /*
     * Pass up a null string as an indication that explicit agent name
     * was not specified.
     */
    $$ = NULLP(text);
  }
|
  AGENT_ static_or_string_literal
  {
    text *tmpstr;

    /*
     * It is an error to give a zero length string i.e. ''... let's
     * go ahead and allocate spcae.
     * The check for a zero length string will be made later in PH2.
     */

    /* allocate some memory */
    tmpstr = (text *)hepnfp(plskgp,
                            plschp,                             /* call heap */
                            strlen((char *)$2) + 1,      /* +1 for null term */
                            TRUE,                    /* clear out the memory */
                            "plsql.y: static_or_string_literal");

    DISCARD strcpy ((char *)tmpstr, (char *)$2);
    $$ = tmpstr;
  }
;

credential_name_opt:
  /* empty */
  {
    $$ = TRENULL;
  }
|
  CREDENTIAL_ dotted_name
  {
    $$ = $2;
  }
;


transactional_opt:
  /* empty */
  {
    /*
     * Let's just pass 0; the "create library ..." production
     * sets the appropriate flags based on this.
     */
    $$ = 0;
  }
|
  TRANSACTIONAL_
  {
    $$ = TRANSACTIONAL_;
  }
;


identity_opt:
  /* empty */
  {
    /*
     * Pass up a null string as an indication that explicit identity
     * was not specified.
     */
    $$ = NULLP(text);
  }
|
  IDENTITY_ string_literal
  {
    text *tmpstr;

    /*
     * It is an error to give a zero length string i.e. ''... let's
     * go ahead and allocate spcae.
     * The check for a zero length string will be made later in PH2.
     */

    /* allocate some memory */
    tmpstr = (text *)hepnfp(plskgp,
                            plschp,                             /* call heap */
                            strlen((char *)$2) + 1,      /* +1 for null term */
                            TRUE,                    /* clear out the memory */
                            "plsql.y: identity string_literal");

    DISCARD strcpy ((char *)tmpstr, (char *)$2);
    $$ = tmpstr;
  }
;

assembly_context_opt:
  /* empty */
  {
    /*
     * Pass up a null string as an indication that explicit context
     * was not specified.
     */
    $$ = NULLP(text);
  }
|
  CONTEXT_ string_literal
  {
    text *tmpstr;

    /*
     * It is an error to give a zero length string i.e. ''... let's
     * go ahead and allocate spcae.
     * The check for a zero length string will be made later in PH2.
     */

    /* allocate some memory */
    tmpstr = (text *)hepnfp(plskgp,
                            plschp,                             /* call heap */
                            strlen((char *)$2) + 1,      /* +1 for null term */
                            TRUE,                    /* clear out the memory */
                            "plsql.y: context string_literal");

    DISCARD strcpy ((char *)tmpstr, (char *)$2);
    $$ = tmpstr;
  }
;

security_opt:
  /* empty */
  {
    $$ = PFFDNSLVL0;                                      /* Default to SAFE */
  }
|
  SECURITY_ SAFE_                                     /* SAFE security level */
  {
    $$ = PFFDNSLVL0;
  }
|
  SECURITY_ EXTERNAL_0_                         /* External 0 security level */
  {
    $$ = PFFDNSLVL1;
  }
|
  SECURITY_ EXTERNAL_1_                         /* External 1 security level */
  {
    $$ = PFFDNSLVL2;
  }
|
  SECURITY_ EXTERNAL_2_                         /* External 2 security level */
  {
    $$ = PFFDNSLVL3;
  }
|
  SECURITY_ UNSAFE_                                 /* UnSafe security level */
  {
    $$ = PFFDNSLVL4;
  }
;

compilation:

  compilation_unit                                     /*..compilation_unit..*/
  {
    ph1p->ph1crt = $1;
  }
;

compilation_unit:

  pragma_list_opt library_unit
  {
    noddef tree;

    $$ = ph1dtn(ph1p, D_COMP_U, 2,
                ph1dtn(ph1p, D_CONTEX, 1, PH1PSQ(lismak())), (ub4)$2);
    tree = ph1mak(ph1p, DS_PRAGM);
    AS_list(tree, $1);
    AS_pragm($$, tree);
    A_authid($$, ph1p->ph1authid);

    /* attach symbol table */
    if ( $2 != TRENULL )                              /* else error occurred */
      ph1sat(ph1p, $$);
  }
|
  pragma_list_opt pkg_body
  {
    noddef tree;

    $$ = ph1dtn(ph1p, D_COMP_U, 2,
                ph1dtn(ph1p, D_CONTEX, 1, PH1PSQ(lismak())), (ub4)$2);
    tree = ph1mak(ph1p, DS_PRAGM);
    AS_list(tree, $1);
    AS_pragm($$, tree);
    A_authid($$, ph1p->ph1authid);

    /* attach symbol table */
    if ( $2 != TRENULL )                              /* else error occurred */
      ph1sat(ph1p, $$);
  }
 |
  pragma_list_opt compound_trg_body
  {
    noddef tree;

     $$ = ph1dtn(ph1p, D_COMP_U, 2,
                ph1dtn(ph1p, D_CONTEX, 1, PH1PSQ(lismak())), (ub4)$2);

     tree = ph1mak(ph1p, DS_PRAGM);
     AS_list(tree, $1);
     AS_pragm($$, tree);
     A_authid($$, ph1p->ph1authid);

     /* attach symbol table */
     if ( $2 != TRENULL )                             /* else error occurred */
      ph1sat(ph1p, $$);
  }
|
  pragma_list_opt PACKAGE_ identifier
  {
    ph1p->ph1shnam = l_SYMREP($3);
  }
  swallow shrinkwd
  {
    $$ = $5;
  }
|
  pragma_list_opt TYPE_ identifier
  {
    ph1p->ph1shnam = l_SYMREP($3);
    ph1p->ph1adt   = $3;
  }
  swallow shrinkwd
  {
    noddef dr_node;

    /*
     * Remember the FINAL INSTANTIABLE property before processing any changes
     * to the properties by ALTER TYPE statements. This is needed to correctly
     * set the PSDSATR_ALT_FINAL_PROP_CHANGED.
     */
    ph1iatf_init_alter_type_flags(ph1p, $5, (ub4)0);

    /*
     * Bug 3760768.  After swallowing (which eats an entire compilation),
     * ph1p->ph1cly == 0.  Reset it to the D_R_'s layer before processing the
     * alter types.
     */
    /* Get to the D_R_ node of the type from diana root */
    dr_node = a_TYPE_S(a_EXP(a_UNIT_B($5)));
    ph1p->ph1cly = (hshlyrdf)s_LAYER(dr_node);
  }
  optional_alter_types
  {
    noddef dr_node;

    /* Get to the D_R_ node of the type from diana root */
    dr_node = a_TYPE_S(a_EXP(a_UNIT_B($5)));

    /* Now attach the alter types to the D_R_ */
    ph1aat_attach_alter_types(ph1p, dr_node, $8);

    $$ = $5;
 }
|
  pragma_list_opt PROCEDURE_ identifier
  {
    ph1p->ph1shnam = l_SYMREP($3);
  }
  swallow shrinkwd
  {
    $$ = $5;
  }
|
  pragma_list_opt FUNCTION_ identifier
  {
    ph1p->ph1shnam = l_SYMREP($3);
  }
  swallow shrinkwd
  {
    $$ = $5;
  }
|
  pragma_list_opt PACKAGE_ BODY_ identifier
  {
    ph1p->ph1shnam = l_SYMREP($4);
  }
  swallow shrinkwd
  {
    $$ = $6;
  }
|
  pragma_list_opt TYPE_ BODY_ identifier
  {
    ph1p->ph1shnam = l_SYMREP($4);
    ph1p->ph1adt   = $4;
  }
  swallow shrinkwd
  {
    $$ = $6;
  }
|
  pragma_list_opt LIBRARY_ identifier
  {
    ph1p->ph1shnam = l_SYMREP($3);
  }
  swallow shrinkwd
  {
    $$ = $5;
  }
|
  pragma_list_opt ASSEMBLY_ identifier
  {
    ph1p->ph1shnam = l_SYMREP($3);
  }
  swallow shrinkwd
  {
    $$ = $5;
  }

;

shrinkwd:

  COMPRESS_ {}
|
  COMPILED_ {}
|
  WRAPPED_  {}
;

swallow:

 { $$ = ph1shk(ph1p); }
;

library_unit:

  subprg_i ';'
|
  pkg_spec ';'
|
  subprg_body
|
  TABLE_ ident tbl_ty_def ';'
  {
    noddef ttree;

    ttree = ph1dtn(ph1p, D_VAR, 3, (ub4)TRENULL, (ub4)$3, (ub4)TRENULL);
    AS_id(ttree, ph1nfs(ph1p, $2, TREKIN(ttree)));
    $$ = ttree;
  }
|
  labeled_block_stmt
  {
    $$ = $1;
  }
|
  label_list_opt ph1psh_ unlabeled_nonblock_stmt
  {
    ptnty trekind = TREKIN($3);
    ub4   srclin, srccol, endlin, endcol;

    srclin = l_SRCLIN($3); srccol = l_SRCCOL($3);

    switch (trekind)
    {
    case D_IF:
    case D_CASE:
    case D_CASE_EXP:
    case D_LOOP:
    case D_BLOCK:
    case D_S_BODY:
    case D_P_DECL:
    case D_P_BODY:
    case D_F_DECL:
    case D_F_BODY:
    case Q_C_BODY:
      endlin = a_ENDLIN($3);  endcol = a_ENDCOL($3);
      break;
    default:
      endlin = srclin;        endcol = srccol;
      break;
    }

    /*
     * allow top-level statements; for Oracle Procedure Builder.This feature
     * can be tested only on the client-side using pls stand-alone or Oracle
     * Procedure Builder, etc.Note that this won't make a difference to
     * SQLDBA which passes on stuff to SQL/us only if it sees the CREATE or
     * DECLARE keywords.
     */
    /* 995153: label top-level stmt itself, not dummy block. 
     *         call ph1ily to increment layer number
     *         of each DI_LABEL. hack? you bet!
     */
    if ( ! lisemp($1) )
    {
      ub4 tmp1 = (ub4)ph1dtn(ph1p,DS_ID,1,PH1PSQ($1));
      $3 = ph1dtn(ph1p,D_LABELE,2, tmp1, (ub4)$3);
      ph1ily_increment_layer(ph1p, $3);
    }
    /* wrap a D_BLOCK node around the statement */
    $$ = ph1dtn(ph1p,
                D_BLOCK,
                3,
                (ub4)ph1dtn(ph1p, DS_ITEM, 1, (ub4)llismak()),
                (ub4)ph1dtn(ph1p, DS_STM, 1, PH1PSQ(PH1LINN($3, lismak()))),
                (ub4)ph1dtn(ph1p, DS_ALTER, 1, (ub4)llismak()) );

    L_srclin($$, srclin);  L_srccol($$, srccol);
    A_beglin($$, srclin);  A_begcol($$, srccol);
    A_endlin($$, endlin);  A_endcol($$, endcol);
    S_flags($$, PHD_FBTLSTMT);

    PH1POP;
  }

  /* a body-less block.  Here since it can't exist except for top level */
  /* removed for bug 99299 */

|
  table_definition ';'
|
  synonym_definition ';'
|
  sequence_definition ';'
|
  call_statement ';'

  /* sqldba cannot add ';' at the end, so we have two rules for now */

|
  adt_definition ';'
|
  DEFINE_ adt_definition ';'
  {
    $$ = $2;
  }
|
  adt_definition
|
  DEFINE_ adt_definition
  {
    $$ = $2;
  }
|
  table_type_definition ';'
|
  table_type_definition
|
  foreign_library_spec ';'
|
  foreign_library_spec
|
  operator_definition ';'
|
  operator_definition
|
  assembly_spec ';'
|
  assembly_spec
;

excptn_d:

  ident EXCEPTION_
  {
    ub4 tmp1 = (ub4)ph1nfs(ph1p, $1, D_EXCEPT);
    $$ = ph1dtn(ph1p, D_EXCEPT, 2, tmp1, (ub4)TRENULL);
  }
;

excptn_handler:

  WHEN_ excptn_choice excptn_choice_list_opt THEN_ seq_of_stmts
  {
    ub4 tmp1 = (ub4)ph1dtn(ph1p, DS_CHOIC, 1, (ub4)PPH1LINN($2, $3));
    $$ = ph1dtn(ph1p, D_ALTERN, 2, tmp1, (ub4)($5));
  }
;

excptn_choice:

  dotted_name
|
  OTHERS_
  {
    $$ = ph1dtn(ph1p, D_OTHERS, 0);
  }
;

raise_stmt:

  RAISE_ dotted_name_opt ';'
  {
    $$ = ph1dtn(ph1p, D_RAISE, 1, (ub4)$2);
  }
;

/************************************************************************/
/*        E.                PL/SQL Syntax, Oracle Additions             */
/************************************************************************/

cursor_ty_def:

  REF_ CURSOR_ return_type_opt
  {
    $$ = ph1mak(ph1p, Q_CURSOR);
    A_name_v($$, $3);
  }
;


cursor_d:

  CURSOR_ identifier
    {
      $2 = ph1dtr(ph1p, $2, QI_CURSO);
      PH1PSH;
    }
  fml_part_opt return_type_opt
  {
    noddef tree;

    $$ = ph1mak(ph1p, Q_C_DECL);
    A_d_($$, $2);
    A_up($2, $$);
    A_header($$, tree = ph1mak(ph1p, Q_CURSOR));
    AS_p_(tree, $4);
    A_name_v(tree, $5);
    PH1POP;
  }
;

return_type_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  RETURN_ unconstrained_type
  {
    $$ = $2;
  }
;

full_cursor_body:

  cursor_d mark_cursor_sql_stmt IS_ curs_body ';'
  {
    noddef tree;
    noddef ttree;
    lisdef *seq;

    $$ = ph1mak(ph1p, Q_C_BODY);
    A_d_($$, a_D_($1));
    A_header($$, a_HEADER($1));
    A_up(a_D_($1), $$);
    A_endlin($$, SRCLINE(5));
    A_endcol($$, SRCCOL(5));

    seq = lismak();
    seq = PH1LINN($4, seq);
    tree = ph1dtn(ph1p, DS_STM, 1, PH1PSQ(seq));
    ttree = ph1dtn(ph1p, D_BLOCK, 2, (ub4)TRENULL, (ub4)tree);

    seq = lismak();
    tree = ph1mak(ph1p, DS_ALTER);
    AS_list(tree, seq);
    AS_alter(ttree, tree);

    seq = lismak();

    tree = ph1mak(ph1p, DS_ITEM);
    AS_list(tree, seq);
    AS_item(ttree, tree);
    A_up(tree, ttree);
    A_block_($$, ttree);
    A_up(ttree, $$);

    tredes(pgap, $1);
  }
;

curs_body:

  curs_spec
|
  SQL_STMT_
;

curs_spec:

  query_expression order_by_clause for_update_clause_opt
  {
    noddef ttree;

    ttree = ph1mak(ph1p, Q_SELECT);
    A_exp(ttree, $1);
    AS_into_(ttree, TRENULL);
    AS_order(ttree, $2);
    AS_name(ttree, $3);

    $$ = ph1mak(ph1p, Q_SQL_ST);
    A_stm($$, ttree);

    /* The table specified by the cursor is not updatable if the cursor */
    /* specification contains a UNION or ORDER_BY.                      */

    if ((TREKIN($1) == Q_BINARY) && ($3 != TRENULL))
      PH1FLAG(1705, $$);
  }
|
  query_expression for_update_clause order_by_clause_opt
  {
    noddef ttree;

    ttree = ph1mak(ph1p, Q_SELECT);
    A_exp(ttree, $1);
    AS_into_(ttree, TRENULL);
    AS_order(ttree, $3);
    AS_name(ttree, $2);

    $$ = ph1mak(ph1p, Q_SQL_ST);
    A_stm($$, ttree);

    /* The table specified by the cursor is not updatable if the cursor */
    /* specification contains a UNION or ORDER_BY.                      */

    if ((TREKIN($1) == Q_BINARY) || ($3 != TRENULL))
      PH1FLAG(1705, $$);
  }
|
  query_expression
  {
    noddef ttree;

    ttree = ph1mak(ph1p, Q_SELECT);
    A_exp(ttree, $1);
    AS_into_(ttree, TRENULL);
    AS_order(ttree, TRENULL);
    AS_name(ttree, TRENULL);

    $$ = ph1mak(ph1p, Q_SQL_ST);
    A_stm($$, ttree);
  }
;

open_statement:                          /* name includes the parameter list */

  OPEN_ name
  {
    noddef tree;

    $$ = ph1mak(ph1p, Q_SQL_ST);
    tree = ph1nca(ph1p, $2, Q_OPEN_S);                /* convert apply node */
    A_stm($$, tree);
  }
;

open_cursor_reference_statement:

  OPEN_ name_wo_function_call FOR_ cursor_open_statement
  {
    ptnod stmt = a_STM($4);
    $$ = $4;
    L_srclin($$, SOURCE_LINE); L_srccol($$, SOURCE_COL);
    A_name(stmt, $2);
  }
;

cursor_open_statement:

  select_statement 
  {
    noddef tree;
    $$ = ph1mak(ph1p, Q_SQL_ST);
    tree = ph1mak(ph1p, Q_OPEN_S);
    AS_p_ass(tree, $1);
    A_stm($$, tree);
  }
|
  select_ SQL_STMT_
  {
    noddef tree;
    $$ = ph1mak(ph1p, Q_SQL_ST);
    tree = ph1mak(ph1p, Q_OPEN_S);
    AS_p_ass(tree, $2);
    A_stm($$, tree);
  }
|
  with_ SQL_STMT_
  {
    noddef tree;
    $$ = ph1mak(ph1p, Q_SQL_ST);
    tree = ph1mak(ph1p, Q_OPEN_S);
    AS_p_ass(tree, $2);
    A_stm($$, tree);
  }
|
  expr using_clause_opt
  {
    ptnod using = TRENULL;
    ptnod stmt = ph1mak(ph1p, Q_DOPEN_STM);
    A_stm_string(stmt, $1);
    if (!lisemp($2))
    {
      using = ph1mak(ph1p, DS_USING_BIND);
      AS_list(using, $2);
    }
    AS_using_(stmt, using);
    $$ = ph1dtn(ph1p, Q_DSQL_ST, 1, stmt);
  }
;

expanded_and_bind_n:

  dotted_name
|
  bind_var
;

fetch_statement:

  FETCH_  expanded_and_bind_n BULK_COLLECT_opt INTO_ name_list
  limit_clause_opt
  {
    noddef tree;

    $$ = ph1mak(ph1p, Q_SQL_ST);
    tree = ph1mak(ph1p, Q_FETCH_);

    /*
     * Set the 's_flags' field to indicate whether the compiler should bulk
     * interpret the parameters in the name_list. This test is
     * done in phase 2 (ph2sicm_into_clause_mapping).
     */
    S_flags(tree, $3);

    /* set the limit clause : bulk bind enhancement */
    A_limit(tree, $6);

    A_name(tree, $2);
    if (lismor(liscdr($5)))
    {
      /* an aggregate fetch */
      noddef ttree;

      ttree = ph1mak(ph1p, D_AGGREG);
      AS_list(ttree, $5);
      A_id(tree, ttree);
    }
    else
    {
      /* POTENTIALLY a RECORD fetch.If PH2 determines it is not (by type */
      /* analysis) then it must convert into a D_AGGREG node             */
      A_id(tree, (noddef)liscar($5));
    }
    A_stm($$, tree);
  }
;

close_statement:

  CLOSE_ expanded_and_bind_n
  {
    noddef tree;

    $$ = ph1mak(ph1p, Q_SQL_ST);
    tree = ph1mak(ph1p, Q_CLOSE_);
    A_name(tree, $2);
    A_stm($$, tree);
    if (ph1nln(ph1p, $2) > 1)
      PH1FLAG(1703 , $$);
  }
;

/*
 * KJ-7May91: I'm splitting tbl_ty_def into this and array type because
 * at least for right now, I want to generate different diana.These really
 * should be better combined though.
 */

tbl_ty_def:

  TABLE_ { PH1PSH; } field_list
  {
    PH1POP;
    $$ = ph1mak(ph1p, Q_TABLE);
    AS_list($$, $3);
  }
;

COMMENT_literal_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  COMMENT_ string_literal
  {
    noddef ttree;

    $$ = ph1mak(ph1p, DS_APPLY);
    ttree = ph1dti(ph1p, D_STRING, $2);
    AS_list($$, PH1LINN(ttree, lismak()));
  }
;

/* TMO=> We will no longer allow RELEASE in COMMIT or ROLLBACK. */
/* This will be flagged as a syntax error.                      */

sql_stmt:

  close_statement
|
  fetch_statement
|
  open_statement
|
  open_cursor_reference_statement
|
  commit_ WORK_opt COMMENT_literal_opt
  {
    if ($3 == TRENULL)
    {
      $$ = ph1mpc(ph1p, (text *)"COMMIT");
    }
    else
    {
      $$ = ph1mpc(ph1p, (text *)"COMMIT_CM");
      AS_p_ass($$, $3);
    }
    if ($2 == TRENULL || $3 != TRENULL )
      PH1FLAG(1702, $$);
  }
|
  set_ TRANSAC_ READ_ ONLY_
  {
    $$ = ph1mak(ph1p, Q_GENSQL);
    L_defaul($$, (ub4)Q_SETTRO);
  }
|
  set_ TRANSAC_ READ_ WRITE_
  {
    $$ = ph1mak(ph1p, Q_GENSQL);
    L_defaul($$, (ub4)Q_SETTRW);
  }
|
  set_ TRANSAC_ USE_ ROLLBACK_ SEGMENT_ identifier
  {
    ptnod tree, ttree;
    $$ = ph1mpc(ph1p, (text *)"SET_TRANSACTION_USE");
    tree = ph1mak(ph1p, DS_APPLY);
    ttree = ph1dti(ph1p, D_STRING, l_SYMREP($6));
    AS_list(tree, PH1LINN(ttree, lismak()));
    AS_p_ass($$, tree);
    PH1FLAG(1701, $$);
  }
|
  set_ TRANSAC_ ISOLATION_ LEVEL_ SERIALIZABLE_
  {
    $$ = ph1mak(ph1p, Q_GENSQL);
    L_defaul($$, (ub4)Q_SETTRI);
  }
|
  set_ TRANSAC_ ISOLATION_ LEVEL_ READ_ COMMITTED_
  {
    $$ = ph1mak(ph1p, Q_GENSQL);
    L_defaul($$, (ub4)Q_SETTRR);
  }
|
  rollback_ WORK_opt /*.RELEASE.*/ COMMENT_literal_opt
  {
    if ($3 == TRENULL)
    {
      $$ = ph1mpc(ph1p, (text *)"ROLLBACK_NR");
    }
    else
    {
      $$ = ph1mpc(ph1p, (text *)"ROLLBACK_CM");
      AS_p_ass($$, $3);
    }
    L_defaul(a_NAME($$), PHD_STANDARD_RENAME);
    if (($3 != TRENULL) || ($2 == TRENULL))
      PH1FLAG(1701, $$);
  }
|
  rollback_ WORK_opt TO_ SAVEPOINT_opt identifier
  {
    noddef tree;
    noddef ttree;

    $$ = ph1mpc(ph1p, (text *)"ROLLBACK_SV");
    tree = ph1mak(ph1p, DS_APPLY);

    /*
     * kludge due to no defining occurance of identifier.Note that we should
     * attempt to reclaim space of unused DI_U_NAM $5 also note that this
     * may screw up other definitions!
     */
    ttree = ph1dti(ph1p, D_STRING, l_SYMREP($5));
    AS_list(tree, PH1LINN(ttree, lismak()));
    AS_p_ass($$, tree);
    PH1FLAG(1701, $$);
  }
|
  savepoint_ identifier
  {
    noddef tree;
    noddef ttree;

    $$ = ph1mpc(ph1p, (text *)"SAVEPOINT");
    tree = ph1mak(ph1p, DS_APPLY);

    /*
     * kludge due to no defining occurance of identifier.Note that we should
     * attempt to reclaim space of unused DI_U_NAM $2 also note that this
     * may screw up other definitions!
     */

    ttree = ph1dti(ph1p, D_STRING, l_SYMREP($2));
    AS_list(tree, PH1LINN(ttree, lismak()));
    AS_p_ass($$, tree);
    PH1FLAG(1715, $$);
  }
|
  lock_table_statement
|
  sql_query_or_dml_stmt
;

sql_query_or_dml_stmt:

  delete_statement_positioned
|
  delete_statement_searched
|
  insert_statement
|
  select_statement
|
  update_statement_positioned
|
  update_statement_searched
;

/* Dynamic SQL statements - fetch and close statements are the */
/* same static SQL, so their syntax rules are not defined here */

dsql_stmt:

  exec_immediate_statement
  {
    $$ = $1;
  }
/*
|
  prepare_statement
|
  exec_statement
|
  deallocate_statement
*/

;

exec_immediate_statement:

  EXECUTE_ IMMEDIATE_ expr BULK_COLLECT_opt into_list_opt
  using_clause_opt returning_clause_opt
  {
    $$ = ph1dqei_exec_immediate(ph1p, $3, $5, $6, $7, $4);
  }
;

returning_clause_opt:
  /* empty */
  {
    $$ = TRENULL;
  }
|
  return_or_returning BULK_COLLECT_opt into_list
  {
    ptnod tree;
    $$ = ph1mak(ph1p, Q_RTNING);
    tree = ph1mak(ph1p, DS_NAME);
    AS_list(tree, $3);
    AS_into_($$, tree);
    S_flags($$, $2);
  }
;

using_clause_opt:

  /* empty */
  { $$ = lismak(); }
|
  USING_ using_bind_list
  { $$ = $2; }
;

using_bind_list:

  using_bind
  {
    $$ = PH1LINN($1, lismak());
  }
|
  using_bind_list ',' using_bind
  {
    $$ = PH1LAPN($3, $1);
  }
;

using_bind:

  IN_opt expr
  {
    $$ = ph1mak(ph1p, D_IN_BIND);
    A_exp($$, $2);
  }
|
  OUT_ name
  {
    $$ = ph1mak(ph1p, D_OUT_BIND);
    A_name($$, $2);
  }
|
  IN_ OUT_ name
  {
    $$ = ph1mak(ph1p, D_IN_OUT_BIND);
    A_name($$, $3);
  }
;

set_function_specification:

  /*
   * I generalized Count(*) to avoid SR conflict.Neither kernel nor ANSI
   * allows set_function_name(*) other than so I extracted COUNT from
   * set_function_name.
   */

  COUNT_ '(' '*' ')'
  {
    $$ = ph1mak(ph1p, Q_F_CALL);
    A_name($$, ph1dti(ph1p, DI_U_BLT, (text *)"COUNT"));
    /* Others default correctly */
  }
|
  COUNT_
  {
    $$ = ph1mak(ph1p, Q_F_CALL);
    A_name($$, ph1dti(ph1p, DI_U_BLT, (text *)"COUNT"));
    /* Others default correctly */
  }
|
  COUNT_ '(' ALL_DISTINCT_opt sim_expr ')'
  {
    $$ = ph1mak(ph1p, Q_F_CALL);
    A_name($$, ph1dti(ph1p, DI_U_BLT, (text *)"COUNT"));
    L_defaul($$, (ub4)$3);
    A_exp_vo($$, $4);
    if ($3 != 2)                              /* keyword distinct is missing */
      PH1FLAG(1471, $$);
  }
|
  set_function_name '(' ALL_DISTINCT_opt sim_expr ')'
  {
    $$ = ph1mak(ph1p, Q_F_CALL);
    A_name($$, $1);
    L_defaul($$, (ub4)$3);
    A_exp_vo($$, $4);
  }

  /*
   * Attempted to unreserve function names (AVG, MAX , etc.) by making
   * them regular identifiers.However, an unresolvable reduce/reduce
   * conflict arose which caused me to revert back.
   */
;

set_function_name:

  AVG_
  {
    $$ = ph1dti(ph1p, DI_U_BLT, (text *)"AVG");
  }
|
  MAX_
  {
    $$ = ph1dti(ph1p, DI_U_BLT, (text *)"MAX");
  }
|
  MIN_
  {
    $$ = ph1dti(ph1p, DI_U_BLT, (text *)"MIN");
  }
|
  SUM_
  {
    $$ = ph1dti(ph1p, DI_U_BLT, (text *)"SUM");
  }
|
  STDDEV_
  {
    $$ = ph1dti(ph1p, DI_U_BLT, (text *)"STDDEV");
    PH1FLAG(1463, $$);
  }
|
  VARIANCE_
  {
    $$ = ph1dti(ph1p, DI_U_BLT, (text *)"VARIANCE");
    PH1FLAG(1464, $$);
  }
;

ALL_DISTINCT_opt:

  /* empty */
  {
    $$ = T_NONE;
  }
|
  ALL_DISTINCT
;

ALL_DISTINCT:

  ALL_
  {
    $$ = Q_EXP_FILTER_ALL;
  }
|
  DISTINCT_
  {
    $$ = Q_EXP_FILTER_DISTINCT;
  }
|
  UNIQUE_
  {
    $$ = Q_EXP_FILTER_UNIQUE;
  }
;

between_predicate:                     /* same semantics as '[NOT] IN range' */

  sim_expr NOT_opt_BETWEEN sim_expr AND_ sim_expr
  {
    noddef tree;

    $$ = ph1mak(ph1p, D_MEMBER);
    A_exp($$, $1);
    A_member($$, $2);
    tree = ph1mak(ph1p, D_RANGE);
    A_exp1(tree, $3);
    A_exp2(tree, $5);
    A_type_r($$, tree);
  }
;


in_predicate:
                        /* We use aggr for simple_expresion_list, not doing  */
                        /* so would cause SR-conflict.An aggr IS a Diana EXP */

  sim_expr NOT_opt_IN old_subquery
  {
    $$ = ph1dtn(ph1p,D_MEMBER, 3, (ub4)$1, (ub4)$2, (ub4)$3);
  }
|
  sim_expr NOT_opt_IN paren_expr_list
  {
    noddef ttree;

    ttree = ph1mak(ph1p, D_AGGREG);
    AS_list(ttree, $3);
    $$ = ph1dtn(ph1p, D_MEMBER, 3, (ub4)$1, (ub4)$2, (ub4)ttree);
  }
;

ESCAPE_sim_expr_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  ESCAPE_ sim_expr
  {
    $$ = $2;
  }
;

like_predicate:    /* I make this a function call rather than a membership
                    * because membership (always?) can be done with relation
                    * operators actually the difference between these two
                    * nodes eludes me at the moment
                    */

  sim_expr NOT_opt_LIKE sim_expr ESCAPE_sim_expr_opt
  {
    if (TRENULL == $4)
    {
      ub4 tmp1 = (ub4)ph1nfs(ph1p,
                             PH1LINN($1, PH1LINN($3, lismak())), D_F_CALL);
      $$ = ph1dtn(ph1p, D_F_CALL, 2, (ub4)$2, tmp1);
    }
    else
    {
      ub4 tmp1 = (ub4)ph1nfs(ph1p,
                             PH1LINN($1, PH1LINN($3, PH1LINN($4, lismak()))),
                             D_F_CALL);
      $$ = ph1dtn(ph1p, D_F_CALL, 2, (ub4)$2, tmp1);
    }
  }
;


/* We use this to get around a slax bug */
is_prefix: 
 sim_expr IS_ 
;

null_predicate:
  is_prefix NOT_opt NULL_
  {
    ub4 tmp1, tmp2;

    if ($2 == T_NOT)
      tmp1 = (ub4)ph1dti(ph1p, D_USED_O, (text *)"IS NOT NULL");
    else
      tmp1 = (ub4)ph1dti(ph1p, D_USED_O, (text *)"IS NULL");

    tmp2 = (ub4)ph1nfs(ph1p, PH1LINN($1, lismak()), D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, tmp1, tmp2);
  }
;

nan_predicate:
  is_prefix NOT_opt NAN_
  {
    ub4 tmp1, tmp2;

    if ($2 == T_NOT)
      tmp1 = (ub4)ph1dti(ph1p, D_USED_O, (text *)"IS NOT NAN");
    else
      tmp1 = (ub4)ph1dti(ph1p, D_USED_O, (text *)"IS NAN");

    tmp2 = (ub4)ph1nfs(ph1p, PH1LINN($1, lismak()), D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, tmp1, tmp2);
  }
;

infinite_predicate:
  is_prefix NOT_opt INFINITE_
  {
    ub4 tmp1, tmp2;

    if ($2 == T_NOT)
      tmp1 = (ub4)ph1dti(ph1p, D_USED_O, (text *)"IS NOT INFINITE");
    else
      tmp1 = (ub4)ph1dti(ph1p, D_USED_O, (text *)"IS INFINITE");

    tmp2 = (ub4)ph1nfs(ph1p, PH1LINN($1, lismak()), D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, tmp1, tmp2);
  }
;

dangling_predicate:

  is_prefix NOT_opt DANGLING_
  {
    ub4 tmp1, tmp2;

    if ($2 == T_NOT)
      tmp1 = (ub4)ph1dti(ph1p, D_USED_O, (text *)"IS NOT DANGLING");
    else
      tmp1 = (ub4)ph1dti(ph1p, D_USED_O, (text *)"IS DANGLING");
    tmp2 = (ub4)ph1nfs(ph1p, PH1LINN($1, lismak()), D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, tmp1, tmp2);
  }
;

ALL_opt:   

  /* empty */
  {
    $$ = T_NONE;
  }
|
  ALL_
  { 
    $$ = T_ALL; 
  }
;

OF_opt:   

  /* empty */
  {
    $$ = T_NONE;
  }
|
  OF_
  { 
    $$ = T_OF;
  }
;



set_predicate:

  is_prefix NOT_opt A_ SET_
  {
    ub4 tmp1, tmp2;

    if ($2 == T_NOT)
      tmp1 = (ub4)ph1dti(ph1p, D_USED_O, (text *)"IS NOT A SET");
    else
      tmp1 = (ub4)ph1dti(ph1p, D_USED_O, (text *)"IS A SET");
    tmp2 = (ub4)ph1nfs(ph1p, PH1LINN($1, lismak()), D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, tmp1, tmp2);
  }
;


empty_predicate:

  is_prefix NOT_opt EMPTY_
  {
    ub4 tmp1, tmp2;

    if ($2 == T_NOT)
      tmp1 = (ub4)ph1dti(ph1p, D_USED_O, (text *)"IS NOT EMPTY");
    else
      tmp1 = (ub4)ph1dti(ph1p, D_USED_O, (text *)"IS EMPTY");
    tmp2 = (ub4)ph1nfs(ph1p, PH1LINN($1, lismak()), D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, tmp1, tmp2);
  }
;


exists_predicate:                                        /* note lex problem */

  EXISTS_ old_subquery
  {
    ub4 tmp1 = (ub4)ph1dtn(ph1p, D_USED_O, 1, "EXISTS");
    ub4 tmp2 = (ub4)ph1nfs(ph1p, PH1LINN($2, lismak()), D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, tmp1, tmp2);
  }
;

overlaps_predicate:                                                /* sql 92 */

  paren_aggr  OVERLAPS_  paren_aggr
  {
    /* paren_aggr should be d_aggregate */
    ub4 tmp1 = (ub4)ph1dti(ph1p, DI_U_NAM, (text *) "SYS_OVERLAPS");
    ub4 tmp2 = (ub4)ph1nfs(ph1p, PH1LCAT(as_LIST($1), as_LIST($3)), D_F_CALL);
    L_defaul(tmp1, PHD_BUILTIN_NAME);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, tmp1, tmp2);
  }
;

table_expression:

  from_clause table_expression_clause_list
  {
    $$ = $2;
    AS_from($$, $1);
    if ( as_GROUP($2) == TRENULL )
    {
      noddef ttree;

      ttree = ph1mak(ph1p, DS_EXP);
      AS_list(ttree, lismak());
      AS_group($2, ttree);
    }
  }
;

table_expression_clause:

  /*
   * I need to use these strange temps because of the difference of this
   * production, and the fact that a where_clause and a having_clause are
   * both simply EXPs.Also note that the assumption that the next production
   * reduced is table_expression_clause_list and therfore I don't need to
   * worry about recursion - test this
   */

  where_clause
  {
    temp = 1;
    $$ = $1;
  }
|
  connect_by_clause
  {
    temp = 2;
    $$ = $1;
  }
|
  group_by_clause
  {
    temp = 3;
    $$ = $1;
  }
|
  having_clause
  {
    temp = 4;
    $$ = $1;
  }
;

table_expression_clause_list:

  /* empty */
  {
    $$ = ph1mak(ph1p, Q_TBL_EX);
  }
|
  table_expression_clause_list table_expression_clause
  {
    /* Put in tests for multiple clauses */
    ph1fsc(ph1p, $1, temp);
    switch ( temp )
    {
      case 1 :
        A_where($1, $2);
        break;
      case 2 :
        A_connec($1, $2);
        break;
      case 3 :
        AS_group($1, $2);
        break;
      case 4 :
        A_having($1, $2);
        break;
      default:
        break;
    }
    $$ = $1;
  }
;

from_clause:

  FROM_ from_table_reference_or_subquery ...from_table_reference_or_subquery..
  {
    $$ = ph1mak(ph1p, DS_NAME);
    AS_list($$, PH1LINN($2, $3));
    if (ph1nln(ph1p, $2) > 2)
      PH1FLAG(1457, $2);
  }
;

from_table_reference_or_subquery:

  table_reference_or_subquery
|
  table_reference_with_sample
;

table_reference:

  /* bug 919390: permit partition/subpartition extended names */

  link_expanded_n_optional_partition
  {
    $$ = $1;
    if (ph1nln(ph1p, $1) > 2)
    PH1FLAG(1457, $1);
  }
|
  link_expanded_n_optional_partition identifier
  {
    $$ = ph1mak(ph1p, Q_ALIAS_);
    A_name($$, $1);
    A_name_v($$, $2);
    if (ph1nln(ph1p, $1) > 2)
      PH1FLAG(1457, $1);
  }
;

table_reference_list:

  /* empty */
  {
    $$ = lismak();
  }
|
  table_reference_list ',' table_reference
  {
    $$ = PH1LAPN($3, $1);
    if (ph1nln(ph1p, $3) > 2)
      PH1FLAG(1457, $3);
  }
;

/* see the comment for bug 487834 in rule for delete_statement_searched */

return_as_alias_table_reference_or_subquery:

  link_expanded_n_optional_partition_or_subquery return_or_returning
  {
    $$ = ph1mak(ph1p, Q_ALIAS_);
    A_name($$, $1);
    A_name_v($$, $2);
    if (ph1nln(ph1p, $1) > 2)
      PH1FLAG(1457, $1);
  }
;

table_reference_or_subquery:

  link_expanded_n_optional_partition_or_subquery
  {
    $$ = $1;
    if (ph1nln(ph1p, $1) > 2)
      PH1FLAG(1457, $1);
  }
|
  link_expanded_n_optional_partition identifier
  {
    $$ = ph1mak(ph1p, Q_ALIAS_);
    A_name($$, $1);
    A_name_v($$, $2);
    if (ph1nln(ph1p, $1) > 2)
      PH1FLAG(1457, $1);
  }
|
  new_subquery identifier
  {
    $$ = ph1mak(ph1p, Q_ALIAS_);
    A_name($$, $1);
    A_name_v($$, $2);
    if (ph1nln(ph1p, $1) > 2)
      PH1FLAG(1457, $1);
  }
|
  flattened_subquery _as_ identifier
  {
    $$ = ph1mak(ph1p, Q_ALIAS_);
    A_name($$, $1);
    A_name_v($$, $3);
    if (ph1nln(ph1p, $1) > 2)
      PH1FLAG(1457, $1);
  }
|
  table_function_call
  {
    $$ = $1;
  }
|
  table_function_call _as_ identifier
  {
    $$ = ph1mak(ph1p, Q_ALIAS_);
    A_name($$, $1);
    A_name_v($$, $3);
  }
;

table_reference_with_sample:

  link_expanded_n_optional_partition sample_clause
  {
    $$ = ph1mak(ph1p, D_SAMPLE);
    A_name($$, $1);
    A_sample($$, $2);
    if (ph1nln(ph1p, $1) > 2)
      PH1FLAG(1457, $1);
  }
|
  link_expanded_n_optional_partition SAMPLE_
  {
    $$ = ph1mak(ph1p, Q_ALIAS_);
    A_name($$, $1);
    A_name_v($$, $2);
    if (ph1nln(ph1p, $1) > 2)
      PH1FLAG(1457, $1);
  }
|
  link_expanded_n_optional_partition sample_clause identifier
  {
    noddef tmp = ph1mak(ph1p, D_SAMPLE);
    A_name(tmp, $1);
    A_sample(tmp, $2);
    $$ = ph1mak(ph1p, Q_ALIAS_);
    A_name($$, tmp);
    A_name_v($$, $3);
    if (ph1nln(ph1p, $1) > 2)
      PH1FLAG(1457, $1);
   }
;

sample_clause:

  SAMPLE_ '(' sample_percent ')'
  {
    $$ = ph1mak(ph1p, D_PERCENT);
    A_percent($$, $3);
    A_flags($$, PHD_ROW_SAMPLE);
  }
|
  SAMPLE_ BLOCK_ '(' sample_percent ')'
  {
    $$ = ph1mak(ph1p, D_PERCENT);
    A_percent($$, $4);
    A_flags($$, PHD_BLOCK_SAMPLE);
  }
;

sample_percent:

  numeric_literal
  {
    $$ = ph1dti(ph1p, D_NUMERI, $1);
  }
;

table_function_call:

  /* for V8.0. In the future, consider value_expression here */
  TABLE_ '(' sim_expr ')'
  {
    ub4 fname = (ub4)ph1dti(ph1p, DI_U_NAM, (text *)"TABLE");
    ub4 expr = (ub4)ph1nfs(ph1p, PH1LINN($3, lismak()), (ub4)D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, fname, expr);
  }
;

link_expanded_n_optional_partition_or_subquery:

  link_expanded_n_optional_partition
|
  table_subquery
;

/* partition name  -- name or index number */

partition_name:

  identifier
|
  numeric_literal
  {
    $$ = ph1dti(ph1p, D_NUMERI, $1);
  }
;

link_expanded_n_optional_partition:

  link_expanded_n partition_or_subpartition '(' partition_name ')'
  {
    ub2  flags;

    $$ = ph1mak(ph1p, D_S_PT);
    A_name($$, $1);
    /* must be one of the two */
    flags = (SUBPARTITION_ == $2) ? PHD_SUBPARTITION_EXTENDED : 0;
    A_flags($$, flags);
    A_partn($$, $4);
  }
|
  link_expanded_n
;

partition_or_subpartition:

  PARTITION_
  {
    $$ = PARTITION_;
  }
|
  SUBPARTITION_
  {
    $$ = SUBPARTITION_;
  }
;

...from_table_reference_or_subquery..:

  /* empty */
  {
    $$ = lismak();
  }
|
  ...from_table_reference_or_subquery.. ','
  from_table_reference_or_subquery
  {
    $$ = PH1LAPN($3, $1);
    if (ph1nln(ph1p, $3) > 2)
      PH1FLAG(1457, $3);
  }
;

where_clause:

  WHERE_ expr
  {
    $$ = $2;
  }
;

group_by_clause:

  /* column_specification included under expanded_n */
  /* was:         GROUP_ BY_ dotted_name dotted_name_list */

  GROUP_ BY_ sim_expr sim_expr_list
  {
    $$ = ph1mak(ph1p, DS_EXP);
    AS_list($$, PH1LINN($3, $4));
  }
;

having_clause:

  HAVING_ expr
  {
    $$ = $2;
  }
;

/*
 * old_subquery is used where SQL does not allow WITH READ ONLY,
 * WITH CHECK OPTION, and ORDER BY clauses. PLSQL allowed
 * WITH clauses (erroneusly), this will have be fixed in semantics
 * analysis bacause we have to provide backout switch.
 *
 * The list below tells which rule to use depending on combination
 * of clauses supported. If you don't find your combination in
 * the table adding some new syntax with subquery - either create
 * a new rule of split your new rules.
 *
 * TAGS:
 * O - ORDER BY allowed
 * W - WITH allowed
 * P - plain query without ORDER BY or WITH allowed
 *
 * P   - plain_subquery
 * W   - with_subquery
 * PO  - ordered_subquery
 * PW  - old_subquery
 * PWO - new_subquery
 *
 * Note: currently SQL does not allow code both WITH and ORDER BY,
 *       watch out for changes.
*/

old_subquery:

  plain_subquery
|
  with_subquery
;

new_subquery:

  ordered_subquery
|
  with_subquery
;

plain_subquery:

  '(' query_expression ')'
  {
    if (TREKIN($2) != Q_SUBQUE )
    {
      $$ = ph1fms_make_subquery(ph1p, $2,
                                Q_EXP_CONVERSION_DEFAULT,
                                Q_EXP_CONSTRUCTOR_NONE);
      ph1fsq(ph1p, $$);
    }
    else
    {
      $$ = $2;
    }
  }
;

with_subquery:

  '(' query_expression  WITH_ READ_ ONLY_ ')'
  {
    if (TREKIN($2) != Q_SUBQUE )
    {
      $$ = ph1fms_make_subquery(ph1p, $2,
                                Q_EXP_CONVERSION_DEFAULT,
                                Q_EXP_CONSTRUCTOR_NONE);
      ph1fsq(ph1p, $$);
    }
    else
    {
      $$ = $2;
    }
    /*  sql syntax -- emit in unparser */
    A_flags($$, PHD_WITH_READ_OPTION);
  }
|
  '(' query_expression WITH_ CHECK_ OPTION_ ')'
  {
    if (TREKIN($2) != Q_SUBQUE )
    {
      $$ = ph1fms_make_subquery(ph1p, $2,
                                Q_EXP_CONVERSION_DEFAULT,
                                Q_EXP_CONSTRUCTOR_NONE);
      ph1fsq(ph1p, $$);
    }
    else
    {
      $$ = $2;
    }
    /*  sql syntax -- emit in unparser */
    A_flags($$, PHD_WITH_CHECK_ONLY);
  }
;

ordered_subquery:

  '(' query_expression order_by_clause_opt ')'
  {
    if (TREKIN($2) != Q_SUBQUE )
    {
      $$ = ph1fms_make_subquery(ph1p, $2,
                                Q_EXP_CONVERSION_DEFAULT,
                                Q_EXP_CONSTRUCTOR_NONE);
      ph1fsq(ph1p, $$);
    }
    else
    {
      $$ = $2;
    }
    AS_order($$, $3);
  }
;

/* ANSI SQL-compliant node */

table_subquery:

  new_subquery
|
  flattened_subquery
;

ordered_table_subquery:

  ordered_subquery
|
  flattened_subquery
;

cursor_subquery :
   prefix
/* like ordered_subquery */
    '(' query_expression order_by_clause_opt ')'
        {
          if ((TREKIN($1) == DI_U_NAM) &&
              (strcmp((char *)l_SYMREP($1), (char *)P_CURSOR_SUB) == 0))
          {
            $$ = ph1fms_make_subquery(ph1p, $3,
                                      Q_EXP_CONVERSION_DEFAULT,
                                      Q_EXP_CONSTRUCTOR_CURSOR);
            AS_order($$, $4);
          }
          else
          {
            PH1ERRS(122, SEVERROR, $1, PLSUNIQ(27), P_CURSOR_SUB);
          }
        }
      ;
/* ANSI SQL-compliant node */

flattened_subquery:

  THE_ '(' query_specification ')'
  /* for Oracle 8.0. In future, may be widened to query_expression */
  {
    $$ = ph1fms_make_subquery(ph1p, $3,
                              Q_EXP_CONVERSION_THE,
                              Q_EXP_CONSTRUCTOR_NONE);
  }
|
  TABLE_ '(' query_specification ')'
  /* for Oracle 8.1 TABLE also has THE functionality. THE may be deprecated 
   * later
   */
  {
    $$ = ph1fms_make_subquery(ph1p, $3,
                              Q_EXP_CONVERSION_TABLE,
                              Q_EXP_CONSTRUCTOR_NONE);
  }
;

/* ANSI SQL-compliant node */

collection_value_expression:

  sim_expr
|
  /* for Oracle 8.0. In future, may be widened to table_subquery */
  flattened_subquery
|
  collection_value_constructor
;

/* ANSI SQL-compliant node */

collection_value_constructor:

  MULTISET_ ordered_table_subquery
  {
    $$ = ph1fms_make_subquery(ph1p, $2,
                              Q_EXP_CONVERSION_DEFAULT,
                              Q_EXP_CONSTRUCTOR_MULTISET);
  }
;

query_expression:                                   /* see sqldiana for expl */

  query_term set_operator_query_term_list
  {
    if ( $2 == TRENULL )
    {
      $$ = $1;
    }
    else
    {
      /* the tree is construced earlier */
      A_exp1($2, $1);
      $$ = $2;
    }
  }
;

query_term:

  query_specification
|
  '(' query_expression ')'
  {
    $$ = ph1fms_make_subquery(ph1p, $2,
                              Q_EXP_CONVERSION_DEFAULT,
                              Q_EXP_CONSTRUCTOR_NONE);
  }
;

set_operator_query_term_list:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  set_operator query_term set_operator_query_term_list
  {
    if (2 == $1 || 3 == $1)
    {
      PH1FLAG(1420, $2);
    }
    if ( $3 == TRENULL )
    {
      $$ = ph1mak(ph1p, Q_BINARY);
      L_defaul($$, (ub4)$1);
      A_exp2($$, $2);
    }
    else
    {
      A_exp1($3, $2);
      $$ = ph1mak(ph1p, Q_BINARY);
      L_defaul($$, (ub4)$1);
      A_exp2($$, $3);
    }
  }
;

UNION_ALL_opt:

  UNION_
  {
    $$ = Q_EXP_OPERATION_UNION;
  }
|
  UNION_ ALL_
  {
    $$ = Q_EXP_OPERATION_UNION_ALL;
  }
;

set_operator:

  UNION_ALL_opt
  {
    $$ = $1;
  }
|
  INTERSECT_
  {
    $$ = Q_EXP_OPERATION_INTERSECT;
  }
|
  MINUS_
  {
    $$ = Q_EXP_OPERATION_MINUS;
  }
;

query_specification:

  SELECT_ ALL_DISTINCT_opt select_list table_expression
  {
    $$ = ph1mak(ph1p, Q_EXP);
    L_defaul($$, (ub4)$2);
    AS_exp($$, $3);
    A_exp($$, $4);
    ph1p->ph1hnt--;
  }
;

select_list:

  select_item select_item_list
  {
    $$ = ph1mak(ph1p, DS_EXP);
    AS_list($$, PH1LINN($1, $2));
  }
|
  '*'
  {
    $$ = ph1mak(ph1p, DS_EXP);
    AS_list($$, lismak());
  }
;

/* ANSI SQL-compliant node */

value_expression :

  /* for Oracle 8.0. IN future, may be widened to subquery */
  sim_expr
|
  flattened_subquery
|
  prefix '.' '*'
  {
    $$ = ph1mak(ph1p, D_S_ED);
    A_name($$, $1);
    A_d_char($$, ph1mak(ph1p, D_ALL));
  }
;

sel_expr:                                          /* Select list expression */

  value_expression
 | cursor_subquery 
;

select_item:                /* Notation for Aliases : ONLY in select list! */

  sel_expr
|
  sel_expr _as_ identifier
  {
    $$ = ph1mak(ph1p, Q_ALIAS_);
    A_name($$, $1);
    A_name_v($$, $3);
  }
 |
/*  sel_expr _as_ MULTISET_ */
  combinable_multiset_expr
  {
    $$ = ph1mak(ph1p, Q_ALIAS_);
    A_name($$, $1);
    A_name_v($$, ph1dti(ph1p, DI_U_NAM, (text *)"MULTISET"));
  }
;

_as_:

  /* empty */
|
  AS_
;

select_item_list:

  /* empty */
  {
    $$ = lismak();
  }
|
  select_item_list ',' select_item
  {
    $$ = PH1LAPN($3, $1);
  }
;

connect_by_clause:

  CONNECT_ BY_ expr
  {
    $$ = ph1mak(ph1p, Q_CONNEC);
    A_exp1($$, $3);
    PH1FLAG(1425, $$);
  }
|
  CONNECT_ BY_ expr START_ WITH_ expr
  {
    $$ = ph1mak(ph1p, Q_CONNEC);
    A_exp1($$, $3);
    A_exp2($$, $6);
    PH1FLAG(1425, $$);
  }
|
  START_ WITH_ expr CONNECT_ BY_ expr
  {
    $$ = ph1mak(ph1p, Q_CONNEC);
    A_exp1($$, $6);
    A_exp2($$, $3);
    PH1FLAG(1425, $$);
  }
;

table_definition:                /* again, should we use name ...name gen.? */

  DEFINE_ TABLE_ identifier ph1psh_ '(' table_column_list ')'
  organization_opt
  {
    ptnod q_table = ph1mak(ph1p, Q_TABLE);
    ptlis *regular, *prev = NULLP(ptlis); 

    PH1POP;
 
    /* Remove hidden columns from the beginning of the list */
    for (regular = $6; regular; prev = regular, regular = regular->lisnxt)
    {
      ptnod var = liscar(regular);
      ptnod di_var = PTDGSND(as_SEQ(as_ID(var)), 0);

      if (!bit(l_DEFAUL(di_var), PHD_HIDDEN_COLUMN))
        break;
    }

    AS_list(q_table, regular);

    /* Terminate the hidden column list and link it in */
    if (prev)
    {
      prev->lisnxt = NULLP(ptlis);
      SS_list(q_table, AS_HIDDEN, $6);
    }

    $$ = ph1mak(ph1p, Q_CREATE);
    DISCARD ph1nfi(ph1p, $3, D_VAR);
    A_name($$, $3);
    A_exp($$, q_table);

    /* set the organization flag */
    A_tflag(q_table, $8);
  }
|
  DEFINE_ TABLE_ dotted_name OF_ constrained_type
  {
    noddef t_tree;
    /* now make the Q_TABLE and attach the type to the a_type_s attribute. */
    /* We leave the as_list free for the time being.                       */
    t_tree = ph1mak(ph1p, Q_TABLE);
    $$ = ph1mak(ph1p, Q_CREATE);
    A_exp($$, t_tree);
    DISCARD(ph1nfi(ph1p, (TREKIN($3)==D_S_ED)?a_D_CHAR($3):$3, D_VAR));
    A_name($$, $3);
    A_type_s(t_tree, $5);
  }
;

organization_opt:
  /* empty */
  {
    $$ = PHD_TABLE_HEAP_ORGANIZED;
  }
|
  ORGANIZATION_ index_or_heap
  {
    $$ = $2;
  }
;

index_or_heap:

  INDEX_
  {
    $$ = PHD_TABLE_INDEX_ORGANIZED;
  }
|
  HEAP_
  {
    $$ = PHD_TABLE_HEAP_ORGANIZED;
  }
;


table_column_list:
  table_column
  {
    $$ = PH1LINN($1, lismak());
  }
|
  table_column_list ',' table_column
  {
    /* Hidden columns always go at the beginning of the list */
    if (bit(l_DEFAUL(PTDGSND(as_SEQ(as_ID($3)), 0)), PHD_HIDDEN_COLUMN))
      $$ = PH1LINN($3, $1);
    else
      $$ = PH1LAPN($3, $1);
  }
;


table_column:

  identifier unconstrained_type_wo_datetime constraint_opt
    default_opt column_property_seq collate_opt
  {
    ub4 tmp1 = (ub4)ph1nfs(ph1p, PH1LINN($1, lismak()), D_VAR);
    ub4 tmp2 = (ub4)ph1dtn(ph1p, D_CONSTR, 3, (ub4)$2, (ub4)$3, (ub4)TRENULL);
    if ($6!=LX_COLLATION_NLS_COMP)
      S_flags(tmp2, s_FLAGS(tmp2) | PHD_CONSTR_NOT_USING_NLS_COMP);
    $$ = ph1dtn(ph1p, D_VAR, 3, tmp1, tmp2, (ub4)$4);
    L_defaul($1, l_DEFAUL($1) | $5);
  }
|
  identifier constrained_datetime_interval_type default_opt column_property_seq
  {
    /* Partially implemented -- as above */
    ub4 tmp1 = (ub4)ph1nfs(ph1p, PH1LINN($1, lismak()), D_VAR);
    ub4 tmp2 = $2;
    $$ = ph1dtn(ph1p, D_VAR, 3, tmp1, tmp2, (ub4)$3);
    L_defaul($1, l_DEFAUL($1) | $4);
  }
;

default_collation_opt:
  /* empty */
  {
    $$ = TRENULL;
  }
|
  default_collation
  {
    $$ = $1;
  }
;

default_collation:
  DEFAULT_ COLLATION_ 
    {
      boolean val1 = TRUE; /* raise error if fails */
      DISCARD PSDGSHV_REF(plskgp, PSDEGSH_collation_check_compatible,
            (void *)&val1 , (void *) 0, (void *) 0, (void *) 0);
      bis(ph1p->ph1misc, PH1_PARSING_COLLATION);
    }
  identifier
  {
    /* check if it is top level */
    if (ph1p->ph1cly > 1)
    {
      PH1ERRS(157,SEVSEVER,TRENULL,PLSUNIQ(83), (text *)P_DEFAULT_COLLATION);
    }

    /* disallow duplicate declaration */
    if (bit(ph1p->ph1misc, PH1_COLLATION_DECLARED))
      PH1ERRS(371, SEVERROR,TRENULL,PLSUNIQ(46), (text *)P_DEFAULT_COLLATION);
    bis(ph1p->ph1misc, PH1_COLLATION_DECLARED);

    if (PSI_CLIENT_IS_RDBMS)
    {
      QCLDCDDCOLL(plsclu->kglhdobj) = 
               lxGetCollationID(l_SYMREP($4), lstlen(l_SYMREP($4)), plsnglo);
      bis(plsclu->kglhdobj->kglobfl2, KGLOBDCL);
    }

    $$ = TRENULL;
    bic(ph1p->ph1misc, PH1_PARSING_COLLATION);
  }
;

collate_opt:
  /* empty */
  {
    $$ = LX_COLLATION_NLS_COMP; /* assume to be USING_NLS_COMP */
  }
| 
  COLLATE_ 
    {
      bis(ph1p->ph1misc, PH1_PARSING_COLLATION);
    }
  identifier
  {
    /* passing up collation id */
    $$ =  lxGetCollationID(l_SYMREP($3), lstlen(l_SYMREP($3)), plsnglo); 
    bic(ph1p->ph1misc, PH1_PARSING_COLLATION);
  }
;

default_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  DEFAULT_ pri
  {
    $$ = $2;
  }
;

column_property_seq:
  /* empty */
  {
    $$ = 0;
  }
|
  column_property_seq column_property
  {
    $$ = $1 | $2;
  }
;

column_property:
  HIDDEN_
  {
    $$ = PHD_HIDDEN_COLUMN;
  }
|
  NOT_ NULL_
  {
    /* NOT NULL is ignored on table columns */
    $$ = 0;
  }
;

/* allow all "array defs" - table for now.Catch in semantic * analysis. */

table_type_definition:

  TYPE_ identifier force_opt default_collation_opt is_or_as array_ty_def
  {
    $$ = ph1typ(ph1p, $2, $6);
  }
|
  DEFINE_ TYPE_ identifier force_opt default_collation_opt is_or_as array_ty_def
  {
    noddef t_tree;

    $$ = ph1mak(ph1p, Q_CREATE);
    t_tree = ph1typ(ph1p, $3, $7);
    DISCARD(ph1nfi(ph1p, ((TREKIN($3)==D_S_ED)?a_D_CHAR($3): $3), D_VAR));
    A_name($$, $3);
    /* create a D_TYPE to hold the adt type. */
    A_exp($$, t_tree);
  }
;

/* Adding SEQUENCE and SYNONYM definitions */

synonym_definition:

  DEFINE_ public_opt SYNONYM_ dotted_name FOR_ link_expanded_n
  {
    noddef ttree = ph1mak(ph1p, Q_SYNON);
    $$ = ph1mak(ph1p, Q_CREATE);
    DISCARD(ph1nfi(ph1p, ((TREKIN($4)==D_S_ED)?a_D_CHAR($4): $4), D_VAR));
    A_exp($$, ttree);
    A_name($$, $4);
    A_exp(ttree, $6);
    L_defaul(ttree, (ub4)$2);
  }
;

public_opt:

  PUBLIC_
  {
    $$ = 1;
  }
|
  /* empty */
  {
    $$ = 0;
  }
;

sequence_definition:

  DEFINE_ SEQUENCE_ dotted_name
  {
    noddef ttree, ttree2, ttree3;
    ub4 tmp1;
    ub4 tmp2;

    ttree3 = ph1mak(ph1p, Q_SEQUE);
    $$ = ph1mak(ph1p, Q_CREATE);
    A_exp($$, ttree3);
    DISCARD(ph1nfi(ph1p, ((TREKIN($3)==D_S_ED) ?a_D_CHAR($3) :$3), D_VAR));
    A_name($$, $3);

    PH1PSH;

    ttree = ph1dti(ph1p, DI_U_NAM, (text *)"CURRVAL");
    ttree = ph1dtr(ph1p, ttree, DI_FUNCT);

    tmp1 = ph1mak(ph1p, DS_PARAM);
    tmp2 = (ub4)ph1dtn(ph1p, DI_U_NAM, 1, (text*)"NUMBER");
    ttree2 = ph1dtn(ph1p, D_F_, 2, tmp1, tmp2);

    ttree = ph1dtn(ph1p, D_S_DECL, 2, (ub4)ttree, (ub4)ttree2);
    A_exp(ttree3, ttree);

    ttree = ph1dti(ph1p, DI_U_NAM, (text *)"NEXTVAL");

    ttree = ph1dtr(ph1p, ttree, DI_FUNCT);

    tmp1 = (ub4)ph1mak(ph1p, DS_PARAM);
    tmp2 = (ub4)ph1dtn(ph1p, DI_U_NAM, 1, (text*)"NUMBER");
    ttree2 = ph1dtn(ph1p, D_F_, 2, tmp1, tmp2);

    ttree = ph1dtn(ph1p, D_S_DECL, 2, (ub4)ttree, (ub4)ttree2);
    A_exp2(ttree3, ttree);

    PH1POP;
  }
;

adt_definition:

  adt_specification
  {
    PH1POP;
    if ( TREKIN($1) == D_TYPE )
    {
      noddef tmp = ph1dtn(ph1p, DI_U_NAM, 1, l_SYMREP(a_ID($1)));
      L_defaul(tmp, ph1p->ph1adtov);
      $$ = ph1mak(ph1p, Q_CREATE);
      A_exp($$, $1);
      A_name($$, tmp);
    }
    else
    {
      $$ = $1;
    }
  }
|
  adt_body
  {
     PH1POP;
     $$ = $1;
  }
|
  incomplete_ty_d
  /* this allows [define] type <name>; a forward adt decl */
  {
    PH1POP;
    if ( TREKIN($1) == D_TYPE )
    {
      noddef tmp = ph1dtn(ph1p, DI_U_NAM, 1, l_SYMREP(a_ID($1)));
      L_defaul(tmp, ph1p->ph1adtov);
      $$ = ph1mak(ph1p, Q_CREATE);
      A_exp($$, $1);
      A_name($$, tmp);
    }
    else
    {
      $$ = $1;
    }
  }
;

lock_table_statement:

  lock_ TABLE_ table_reference table_reference_list
  IN_ lockmode MODE_ NOWAIT_opt
  {
    $$ = ph1mak(ph1p, Q_LOCK_T);
    AS_list($$, PH1LINN($3, $4));
    L_defaul($$, (ub4)($6 + $8));
    if (ph1nln(ph1p, $3) > 2)
      PH1FLAG(1457, $3);
  }
;

lockmode:

  ROW_ SHARE_
  {
    $$ = 1;
  }
|
  ROW_ EXCLUSIVE_
  {
    $$ = 2;
  }
|
  SHARE_ UPDATE_
  {
    $$ = 3;
    ph1p->ph1hnt--;               /* Fix bug 732522: not an UPDATE statement */
  }
|
  SHARE_
  {
    $$ = 4;
  }
|
  SHARE_ ROW_ EXCLUSIVE_
  {
    $$ = 5;
  }
|
  EXCLUSIVE_
  {
    $$ = 6;
  }
;

NOWAIT_opt:

  /* empty */
  {
    $$ = 0;
  }
|
  NOWAIT_
  {
    $$ = 6;
  }
;

return_or_returning:

  RETURNING_
|
  RETURN_
;

returning_into_clause:

  return_or_returning select_list BULK_COLLECT_opt INTO_ name_list
  {
    noddef tree;
    $$ = ph1mak(ph1p, Q_RTNING);

    /*
     * Set the 's_flags' field to indicate whether or not the compiler
     * should bulk interpret the parameters in the name_list.
     * This test is done in phase 2 (ph2sicm_into_clause_mapping).
     */
    S_flags($$, $3);

    /* select .... */
    AS_exp($$, $2);                                         /* $2 = DS_EXP_S */

    /* into ... */
    tree = ph1mak(ph1p, DS_NAME);
    AS_list(tree, $5);                                 /* $4 = seq of D_NAME */
    AS_into_($$, tree);
  }
;

returning_into_clause_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  returning_into_clause
  {
    $$ = $1;
  }
;

delete_statement_positioned:

  delete_ FROM_opt table_reference_or_subquery
  WHERE_ CURRENT_ OF_ name
  {
    noddef tree;

    $$ = ph1mak(ph1p, Q_DELETE);
    A_name($$, $3);
    tree = ph1mak(ph1p, Q_CURREN);
    A_name(tree, $7);
    A_exp_vo($$, tree);
    if (ph1nln(ph1p, $7) > 1)
      PH1FLAG(1710, $7);
    if (ph1nln(ph1p, $3) > 2)
      PH1FLAG(1457, $3);
    $$ = ph1dtn(ph1p, Q_SQL_ST, 2, (ub4)TRENULL, (ub4)$$);
    ph1p->ph1hnt--;
  }
;

delete_statement_searched:

  delete_ FROM_opt table_reference_or_subquery
  where_clause_opt returning_into_clause_opt
  {
    $$ = ph1mak(ph1p, Q_DELETE);
    A_name($$, $3);
    A_exp_vo($$, $4);
    A_rtning($$, $5);
    if (ph1nln(ph1p, $3) > 2)
      PH1FLAG(1457, $3);
    $$ = ph1dtn(ph1p, Q_SQL_ST, 2, (ub4)TRENULL, (ub4)$$);
    ph1p->ph1hnt--;
  }
|
  /*
   * bug 487834: this alternative is added to match SQL statement like
   * delete from emp return; where 'return' is used as a table alias name
   * instead of starting a returning_into_clause. This and the next
   * alternatives cause two shift/reduce conflicts.
   */

  delete_ FROM_opt return_as_alias_table_reference_or_subquery
  where_clause_opt returning_into_clause_opt
  {
    $$ = ph1mak(ph1p, Q_DELETE);
    A_name($$, $3);
    A_exp_vo($$, $4);
    A_rtning($$, $5);
    if (ph1nln(ph1p, $3) > 2)
      PH1FLAG(1457, $3);
    $$ = ph1dtn(ph1p, Q_SQL_ST, 2, (ub4)TRENULL, (ub4)$$);
    ph1p->ph1hnt--;
  }
|
  /*
   * the following alternative intends to match SQL statement like
   * delete from emp return empno into num; however, SLAX won't pass the
   * following SQL statement: delete from emp return return into num;
   * assuming table emp has a column called 'return'. The reason is that
   * SLAX shifts the first 'return' as a table alias name and expects the
   * second 'return' to begin a returning into clause.
   */

  delete_ FROM_opt link_expanded_n_optional_partition_or_subquery
  returning_into_clause
  {
    $$ = ph1mak(ph1p, Q_DELETE);
    A_name($$, $3);
    A_exp_vo($$, TRENULL);
    A_rtning($$, $4);
    if (ph1nln(ph1p, $3) > 2)
      PH1FLAG(1457, $3);
    $$ = ph1dtn(ph1p, Q_SQL_ST, 2, (ub4)TRENULL, (ub4)$$);
    ph1p->ph1hnt--;
  }
;

/*
 * SQl DML INSERT statement.
 *
 * Comments:
 *
 * The actions block is pretty much repeated 4 times -
 * the right approach here would be to call an external  function.
 *
 * The rules are ugly because the productions are not factored into
 * sub-nonterminals. This happens because the insupd_column_list and
 * the subquery cause reduce/shift conflicts on open paren. More
 * elegant parser would  require extra routines to inflate
 * some 'shallow' syntax and not worth the effort.
*/

insert_statement:

  insert_
  INTO_
  table_reference_or_subquery
  insupd_column_list
  VALUES_
  insert_stmt_values_seq
  returning_into_clause_opt
  {
    noddef tree;

    $$ = ph1mak(ph1p, Q_INSERT);
    A_name($$, $3);
    tree = ph1mak(ph1p, DS_NAME);
    AS_list(tree, $4);
    AS_name($$, tree);
    tree = ph1mak(ph1p, D_AGGREG);
    AS_list(tree, $6);
    A_exp($$, tree);
    A_rtning($$, $7);                    /* returning into clause (optional) */
    $$ = ph1dtn(ph1p, Q_SQL_ST, 2, (ub4)TRENULL, (ub4)$$);
    ph1p->ph1hnt--;
  }
|
  insert_
  INTO_
  table_reference_or_subquery
  insupd_column_list
  query_expression
  returning_into_clause_opt
  {
    noddef tree;

    $$ = ph1mak(ph1p, Q_INSERT);
    A_name($$, $3);
    tree = ph1mak(ph1p, DS_NAME);
    AS_list(tree, $4);
    AS_name($$, tree);
    A_exp($$, $5);
    A_rtning($$, $6);                    /* returning into clause (optional) */
    $$ = ph1dtn(ph1p, Q_SQL_ST, 2, (ub4)TRENULL, (ub4)$$);
    ph1p->ph1hnt--;
  }
|
  insert_
  INTO_
  table_reference_or_subquery
  query_expression
  returning_into_clause_opt
  {
    noddef tree;

    $$ = ph1mak(ph1p, Q_INSERT);
    A_name($$, $3);
    tree = ph1mak(ph1p, DS_NAME);
    AS_list(tree, lismak());
    AS_name($$, tree);
    A_exp($$, $4);
    A_rtning($$, $5);                    /* returning into clause (optional) */
    $$ = ph1dtn(ph1p, Q_SQL_ST, 2, (ub4)TRENULL, (ub4)$$);
    ph1p->ph1hnt--;
  }
|
  insert_
  INTO_
  table_reference_or_subquery
  VALUES_
  insert_stmt_values_seq
  returning_into_clause_opt
  {
    noddef tree;

    $$ = ph1mak(ph1p, Q_INSERT);
    A_name($$, $3);
    tree = ph1mak(ph1p, DS_NAME);
    AS_list(tree, lismak());
    AS_name($$, tree);
    tree = ph1mak(ph1p, D_AGGREG);
    AS_list(tree, $5);
    A_exp($$, tree);
    A_rtning($$, $6);                    /* returning into clause (optional) */
    $$ = ph1dtn(ph1p, Q_SQL_ST, 2, (ub4)TRENULL, (ub4)$$);
    ph1p->ph1hnt--;
  }
;

/*
 * insert_stmt_values_seq: in the upcoming ANSI SQL, this is a
 * comma-separated list of expressions, while in traditional SQL and
 * in Oracle 6... 8.0 it is a _single_ aggregate value.
 *
 * The rules below support the ANSI syntax as well as the traditional
 * syntax.
*/

insert_stmt_values_seq:

  insert_stmt_values_expr
  {
    $$ = PH1LINN($1, lismak());
  }
|
  insert_stmt_values_seq ',' insert_stmt_values_expr
  {
    $$ = PH1LAPN($3, $1);
  }
;

/*
 * insert_stmt_values_expr: for Oracle 6 - 8.0 this is just
 * an aggregate. For Oracle 8.x and ANSI SQL this is an expression.
 *
 * Dmitry: Note we can not easily use 'expr' here since 'aggr' is
 * disallowed under FIPS as part of 'expr' syntax and thus FIPS flag
 * would cause most normal cases fail. This can be addressed by moving
 * FIPS flagging out of 'pri' parsing into the semantical
 * analyzer. The other obstacle is that the reduction of 'aggr' to 'pri'
 * causes D_AGGREG be replaced by D_PARENT, and we'd have to revert it
 * here for INSERT. The code to do that has once been checked-in and
 * can be found in version main/130 of this file.
 *
 * Currently, we've taken a simplified approach allowing only extended names,
 * procedure_calls and aggregates here, thus avoiding the 2 hazards mentioned
 * above.
*/

insert_stmt_values_expr:

  paren_expr_list
  {
    $$ = ph1mak(ph1p, D_AGGREG);
    AS_list($$, $1);
  }
|
  procedure_call
  {
    $$ = $1;
  }
;

insupd_column_list:

  '(' column_name_list ')'
  {
    $$ = $2;
  }
;

column_name_list:

  link_expanded_n
  {
    $$ = PH1LINN($1, lismak());
  }
|
  column_name_list ',' link_expanded_n
  {
    $$ = PH1LAPN($3, $1);
  }
;

select_statement:

  select_ ALL_DISTINCT_opt select_list
  BULK_COLLECT_opt into_list_opt
  table_expression set_operator_query_term_list order_by_clause_opt
  for_update_clause_opt
  {
    noddef tree;

    $$ = ph1mak(ph1p, Q_SELECT);

    /*
     * Set the 's_flags' field to indicate whether or not the compiler
     * should bulk interpret the parameters in the name_list.
     * This test is done in phase 2 (ph2sicm_into_clause_mapping).
     */

    S_flags($$, $4);

    tree = ph1mak(ph1p, Q_EXP);
    L_defaul(tree, (ub4)($2));
    AS_exp(tree, $3);
    A_exp(tree, $6);
    if ( $7 != TRENULL )
    {
      A_exp1($7, tree);
      tree = $7;
    }
    A_exp($$, tree);
    tree = ph1mak(ph1p, DS_NAME);
    AS_list(tree, $5);
    AS_into_($$, tree);
    AS_order($$, $8);
    /* fips flag 1711 */
    if ($8 != TRENULL ) PH1FLAG(1711, $8);
    if (!lisemp(as_LIST(as_GROUP($6))))
      PH1FLAG(1711, as_GROUP($6));
    if (a_HAVING($6) != TRENULL)
      PH1FLAG(1711, a_HAVING($6));
    AS_name($$, $9);
    $$ = ph1dtn(ph1p, Q_SQL_ST, 2, (ub4)TRENULL, (ub4)$$);
    ph1p->ph1hnt--;
  }
;

BULK_COLLECT_opt:

  /* empty */
  {
    $$ = (ub2)0;
  }
|
  BULK_ COLLECT_
  {
    $$ = PHD_MULTI_ROW;
  }
;

limit_clause_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  LIMIT_  sim_expr
  {
    $$ = $2;
  }
;

save_exceptions_opt:

  /* empty */
  {
    $$ = (ub2)0;
  }
|
  SAVE_ EXCEPTIONS_
  {
    $$ = PHD_SAVE_EXCEPTIONS;
  }
;

into_list_opt :

  /* empty */
  { $$ = lismak(); }
|
  into_list
  { $$ = $1; }
;

into_list :

  INTO_ name_list
  { $$ = $2; }
;

order_by_clause_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  order_by_clause
;

order_by_clause:

  ORDER_ BY_ sort_specification_list
  {
    $$ = ph1mak(ph1p, DS_EXP);
    AS_list($$, $3);
  }
;

sort_specification:

  sim_expr
  {
    $$ = ph1mak(ph1p, Q_ORDER_);
    L_defaul($$, PHD_ASCENDING); /* could use diff value for unparse */
    A_exp($$, $1);
  }
|
  sim_expr ASC_
  {
    $$ = ph1mak(ph1p, Q_ORDER_);
    L_defaul($$, PHD_ASCENDING);
    A_exp($$, $1);
  }
|
  sim_expr DESC_
  {
    $$ = ph1mak(ph1p, Q_ORDER_);
    L_defaul($$, PHD_DESCENDING);
    A_exp($$, $1);
  }
;

sort_specification_list:

  sort_specification
  {
    $$ = PH1LINN($1, lismak());
  }
|
  sort_specification_list ',' sort_specification
  {
    $$ = PH1LAPN($3, $1);
  }
;

for_update_clause_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  for_update_clause
;

for_update_clause:

  FOR_ UPDATE_ NOWAIT_opt
  {
    if ($3)
      $$ = ph1mak(ph1p, DS_UPDNW);
    else
      $$ =  ph1mak(ph1p, DS_FORUP);
    ph1p->ph1hnt--;               /* Fix bug 732522: not an UPDATE statement */
  }
|
  FOR_ UPDATE_ OF_ select_list NOWAIT_opt
  {
    $$ = $4;
    if ($5)
      TRERIN($$, DS_UPDNW);
    else
      TRERIN($$, DS_NAME);
    PH1FLAG(1421, $$);
    ph1p->ph1hnt--;               /* Fix bug 732522: not an UPDATE statement */
  }
;

update_statement_positioned:

  update_ table_reference_or_subquery
  SET_ set_clause_item_list WHERE_ CURRENT_ OF_ name
  {
    noddef tree;

    $$ = ph1mak(ph1p, Q_UPDATE);
    A_name($$, $2);
    tree = ph1mak(ph1p, QS_SET_C);
    AS_list(tree, $4);
    AS_set_c($$, tree);
    tree = ph1mak(ph1p, Q_CURREN);
    A_name(tree, $8);
    A_exp_vo($$, tree);
    if (ph1nln(ph1p, $8) > 1)
      PH1FLAG(1710, $8);
    $$ = ph1dtn(ph1p, Q_SQL_ST, 2, (ub4)TRENULL, (ub4)$$);
    ph1p->ph1hnt--;
  }
;

set_clause_item:

  link_expanded_n '=' sim_expr
  {
    $$ = ph1mak(ph1p, Q_SET_CL);
    A_name($$, $1);
    A_exp($$, $3);
    /* sim_expr must be null or a column name */
    if (ph1nln(ph1p, $1) != 1)
      PH1FLAG(1458, $1);
    ph1fsf(ph1p, $3);
  }
|
  link_expanded_n '=' old_subquery
  {
    $$ = ph1mak(ph1p, Q_SET_CL);
    A_name($$, $1);
    A_exp($$, $3);
    if (ph1nln(ph1p, $1) != 1)
      PH1FLAG(1458, $1);
    PH1FLAG(1423, $$);
  }
|
  insupd_column_list '=' old_subquery
  {
    noddef tree;

    $$ = ph1mak(ph1p, Q_SET_CL);
    tree = ph1mak(ph1p, D_AGGREG);
    AS_list(tree, $1);
    A_name($$, tree);
    A_exp($$, $3);
    PH1FLAG(1423, $$);
  }
|
  identifier '(' identifier ')' '=' sim_expr
  {
    ptnod lhs;
    $$ = ph1mak(ph1p, Q_SET_CL);
    lhs = ph1dtn(ph1p, D_F_CALL, 2, $1,
                 ph1nfs(ph1p, PH1LINN($3,  lismak()), D_F_CALL));
    A_name($$, lhs);
    A_exp($$, $6);
    ph1fsf(ph1p, $6);
    if (ph1nln(ph1p, $3) != 1)
      PH1FLAG(1458, $3);
  }
|
  identifier '(' identifier ')' '=' old_subquery
  {
    ptnod lhs;
    $$ = ph1mak(ph1p, Q_SET_CL);
    lhs = ph1dtn(ph1p, D_F_CALL, 2, $1,
                 ph1nfs(ph1p, PH1LINN($3,  lismak()), D_F_CALL));
    A_name($$, lhs);
    A_exp($$, $6);
    ph1fsf(ph1p, $6);
    if (ph1nln(ph1p, $3) != 1)
      PH1FLAG(1458, $3);
    PH1FLAG(1423, $$);
  }
/* This is a new syntax as per ANSI. SQL does not support it yet.
** PL/SQL will support it, and it will be converted into
** set of SET statements in phase II. Also, note that rhs is 
** less resdrictive then ANSI. It includes, variable of PL/SQL types
** and PL/SQL functions returning those types. ROW constructors using
** subqueries, or using explicit ROW value constructors are not supported.
** They will be supported, when ANSI will finalize its semantics.
**/
    | ROW_ '=' procedure_call
                {
                noddef tree;
                $$ = ph1mak(ph1p,Q_SET_CL);
                tree = ph1mak(ph1p, DI_U_NAM);
                L_symrep(tree,(text *)"ROW");

                A_name($$,tree);
                A_exp($$,$3);
                ph1fsf(ph1p, $3);
                }
      | insupd_column_list '=' procedure_call
                {
                  noddef tree;

                $$ = ph1mak(ph1p,Q_SET_CL);
                tree = ph1mak(ph1p,D_AGGREG);
                AS_list(tree,$1);
                A_name($$,tree);
                A_exp($$,$3);
                }
;

set_clause_item_list:

  set_clause_item
  {
    $$ = PH1LINN($1, lismak());
  }
|
  set_clause_item_list ',' set_clause_item
  {
    $$ = PH1LAPN($3, $1);
  }
;

update_statement_searched:

  update_ table_reference_or_subquery SET_ set_clause_item_list
  where_clause_opt returning_into_clause_opt
  {
    noddef tree;

    $$ = ph1mak(ph1p, Q_UPDATE);
    A_name($$, $2);
    tree = ph1mak(ph1p, QS_SET_C);
    AS_list(tree, $4);
    AS_set_c($$, tree);
    A_exp_vo($$, $5);
    A_rtning($$, $6);
    $$ = ph1dtn(ph1p, Q_SQL_ST, 2, (ub4)TRENULL, (ub4)$$);
    ph1p->ph1hnt--;
  }
;

/*  The CALL statement is a new feature added in 8.1. For 8.1, this
 *  feature is being made available in SQL and Pro*C, but not in PL/SQL.
 *  However, because Pro*C uses client-side PL/SQL to do semantic
 *  analysis on all SQL statements, we implement it here to allow Pro*C
 *  semantic analysis to happen.
 *
 *  The fragment
 *
 *     CALL proc(args...);
 *
 *  is transformed into
 *
 *      BEGIN proc(args...) END;
 *
 *  by wrapping a block around the procedure call (a similar transform
 *  occurs in the function call version).
 *
 *  This transform is sufficient for Pro*C semantic analysis. However,
 *  when (and if) CALL is implemented in PL/SQL, the semantics will be
 *  a little more complicated because name resolution rules differ
 *  depending on whether the appearance is in a SQL scope or not. The
 *  differences may be more apparent in an invoker's rights procedure.
 *
 *  The call statement is only available from within Pro*C. Other uses
 *  must raise a serious semantic error at this time.
*/

call_statement:

  CALL_ procedure_call
  {
    /* wrap a D_BLOCK node around the statement */
    ptnod call;
    call = (ptnod) ph1nca(ph1p, $2, D_P_CALL);
    $$ = ph1dtn(ph1p, D_BLOCK, 3,
                (ub4) ph1dtn(ph1p, DS_ITEM, 1, (ub4) llismak()),
                (ub4) ph1dtn(ph1p, DS_STM, 1,
                             PH1PSQ(PH1LINN(call, lismak()))),
                (ub4) ph1dtn(ph1p, DS_ALTER, 1, (ub4) llismak()));
    if (!PSI_CLNT_BHVR_IS_SERVER_COMPAT)
      PH1ERR(165, SEVERROR, $$, PLSUNIQ(28));
  }
|
  CALL_ procedure_call INTO_ name
  {
    /* wrap a D_BLOCK node around the statement */
    ptnod call;
    call = (ptnod) ph1dtn(ph1p, D_ASSIGN, 2, $4, $2);
    $$ = ph1dtn(ph1p, D_BLOCK, 3,
                (ub4) ph1dtn(ph1p, DS_ITEM, 1, (ub4) llismak()),
                (ub4) ph1dtn(ph1p, DS_STM, 1,
                             PH1PSQ(PH1LINN(call, lismak()))),
                (ub4) ph1dtn(ph1p, DS_ALTER, 1, (ub4) llismak()));
    if (!PSI_CLNT_BHVR_IS_SERVER_COMPAT)
      PH1ERR(165, SEVERROR, $$, PLSUNIQ(29));
  }
;

sim_expr_list:

  /* empty */
  {
    $$ = lismak();
  }
|
  sim_expr_list ',' sim_expr
  {
    $$ = PH1LAPN($3, $1);
  }
;

where_clause_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  WHERE_ expr
  {
    $$ = $2;
  }
;

/************************************************************************/
/* The following rules define semantically qualified symbols under more */
/* general categories.                                                  */
/************************************************************************/

/***************************** Oracle additions *************************/

name_list:

  name
  {
    $$ = PH1LINN($1, lismak());
  }
|
  name_list ',' name
  {
    $$ = PH1LAPN($3, $1);
  }
;

COMMA_sim_expr_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  ',' sim_expr
  {
    $$ = $2;
  }
;

NOT_NULL_opt:

  /* empty */
  {
    $$ = 0;
  }
|
  NULL_
  {
    $$ = Q_NULL;
  }
|
  NOT_ NULL_
  {
    $$ = Q_NOT_NU;
  }
;

NOT_BOUND_opt:

  /* empty */
  {
    $$ = 0;
  }
|
  BOUND_
  {
    $$ = PCIJ_BOUND;
  }
|
  NOT_ BOUND_
  {
    $$ = PCIJ_NOT_BOUND;
  }
;

java_class_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  JAVA_ identifier
  {
    $$ = $2;
  }
;

WORK_opt:

  /* empty */
  {
    $$ = T_NONE;
  }
|
  WORK_
  {
    $$ = WORK_;
  }
;

SAVEPOINT_opt:

  /* empty */
  {
    $$ = T_NONE;
  }
|
  SAVEPOINT_
;

FROM_opt:

  /* empty */
  {
    $$ = T_NONE;
  }
|
  FROM_
;

pragma_list_opt:

  /* empty */
  {
    $$ = lismak();
  }
|
  pragma_list_opt pragma ';'
  {
    $$ = PH1LAPN($2,$1);
  }
;

pragma_args:

  /* empty */
  {
    $$ = lismak();
  }
|
  '(' pragma_arg_list ')'
  {
    $$ = $2;
  }
;

pragma_arg_list:

  pragma_arg
  {
    $$ = PH1LINN($1, lismak());
  }
|
  pragma_arg_list ',' pragma_arg
  {
    $$ = PH1LAPN($3, $1);
  }
;

/* "name" is included under "expr"      */

/*  "defer_const_d" is included under "object_d".*/

default_expr_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  ASSIGN_ expr
  {
    $$ = $2;
  }
|
  DEFAULT_ expr
  {
    $$ = $2;
  }
;

constraint_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  constraint
;

/* "idx_c" and "discr_c" are included under the class "aggr". */

link_expanded_n:

  dotted_name
  /* was:   |        expanded_n '@' identifier         */
  /* Now, you can have quakified names as in a.b@c.d.e */
|
  dotted_name '@' dblink
  {
    $$ = ph1mak(ph1p, Q_LINK);
    A_name($$, $1);
    A_id($$, $3);
    PH1FLAG(1460, $$);
  }
;

dblink_alts:

  dotted_name
|
  dotted_name '@' identifier
  {
    $$ = ph1dtn(ph1p, D_S_ED, 2, $1, $3);
    L_defaul($3, l_DEFAUL($3) | PHD_NAME_RHS);
    /* name length not more than 3 */
    L_defaul($3, l_DEFAUL($3) | PHD_CONNECTION_QUALIFIER);
    if (ph1nln(ph1p, $1) == 3)                              /* flag only once*/
      PH1FLAG(1456, $$);
  }
|
  '@' identifier
  {
    L_defaul($2, l_DEFAUL($2) | PHD_CONNECTION_QUALIFIER);
    $$ = $2;
  }
;

dblink:
  
  {
    bis(ph1p->ph1misc, PH1_PARSING_DBLINK);
  }
  dblink_alts
  {
    $$ = $2;
    bic(ph1p->ph1misc, PH1_PARSING_DBLINK);
  }
;  

dotted_name:

/*
 * dotted_name's seem to be only applicable in situations where we know the
 * context from a prior keyword.  They are most often structural things
 * (block names, procedure names..)  An exception is like a variable, except
 * it too is only applicable in limited contexts.  Therefore, a dotted_expr
 * does not cause a conflict.
*/

  identifier
|
  dotted_name '.' identifier
  {
    /* 499737: Check for schema-qualified name.This code will only trigger
     * if P_SCHEMA_PREFIX is the leftmost id in a dotted name.We want this
     * behavior only when SQL calls PL/SQL; the closest approximation
     * available is anonymous blocks on the server. The kglhdnsp == KGLNCRSR
     * test weeds out client-side libunits which also look like anonymous
     * blocks.
    */

    /* bug 781291: check for a schema-qualified name for each component of a
     * table or view.It is used to skip the plscope prefix lookup in name
     * resolution.
    */

    if ((((plsclu->kglhdnsp == KGLNCRSR) &&
          (plsclu->kglhdobj->kglobtyp == KGLTCRSR)) ||
          (plsclu->kglhdobj->kglobtyp == KGLTTABL ||
           plsclu->kglhdobj->kglobtyp == KGLTVIEW)) &&
          (PTKIN($1) == DI_U_NAM) &&
          !strcmp((char *) l_SYMREP($1), (char *) P_SCHEMA_PREFIX))
    {
      $$ = $3;
      L_defaul($$, l_DEFAUL($$) | PHD_SCHEMA_QUALIFIER);
    }
    else
    {
      L_defaul($3, l_DEFAUL($3) | PHD_NAME_RHS);
      $$ = ph1dtn(ph1p, D_S_ED, 2, $1, $3);
      /* name length not more than 3 */
      if (ph1nln(ph1p, $1) == 3)                            /* flag only once*/
        PH1FLAG(1456, $$);
    }
  }
;

/* a simpler form of [link_]expanded_n to avoid capture by datetime keywords */

/* as link_expanded_n */

datetime_link_expanded_n:

  datetime_expanded_n
|
  datetime_expanded_n '@' dblink
  {
    $$ = ph1mak(ph1p, Q_LINK);
    A_name($$, $1);
    A_id($$, $3);
    PH1FLAG(1460, $$);
  }
;

datetime_expanded_n:

  captureable_datetime_identifiers
|
  datetime_expanded_n '.' identifier
  {
    L_defaul($3, l_DEFAUL($3) | PHD_NAME_RHS);
    $$ = ph1dtn(ph1p, D_S_ED, 2, $1, $3);
    /* name length not more than 3 */
    if (ph1nln(ph1p, $1) == 3)                              /* flag only once*/
      PH1FLAG(1456, $$);
  }
;

captureable_datetime_identifiers:

  DATE_
  {
    $$ = $1;
  }
|
  TIME_
  {
    $$ = $1;
  }
|
  TIMESTAMP_
  {
    $$ = $1;
  }
|
  INTERVAL_
  {
    $$ = $1;
  }
;

/* This simply factors out a common subrule */

sim_expr_DBLDOT__sim_expr  :

  sim_expr DBLDOT_ sim_expr
  {
    $$ = ph1dtn(ph1p, D_RANGE, 2, (ub4)$1, (ub4)$3);
  }
;

/* This generalizes "rng" so that it may include ty and subty names.*/

enum_lit_spec_list:

  /* empty */
  {
    $$ = lismak();
  }
|
  enum_lit_spec_list ',' enum_lit_spec
  {
    $$ = PH1LAPN($3, $1);
  }
;

/* The "sim_expr" by itself may be a "dscr_rng" or a "cmpon_sim_n". */

/*
 * A_ body is the only later_decl_item that is not also a
 * basic_decl_item.            It is therefore used as the dividing
 * point between the two lists of decl items.
 */

basic_decl_item_list:
  /* Empty */
  {
    $$ = lismak();
  }
|
  basic_decl_item_list basic_decl_item
  {
    $$ = PH1LAPN($2, $1);
  }
;

later_decl_item_list:
  /* Empty */
  {
    $$ = lismak();
  }
|
  later_decl_item_list later_decl_item
  {
    $$ = PH1LAPN($2, $1);
  }
;

basic_operator_decl_item_list:
  /* Empty */
  {
    $$ = lismak();
  }
|
  basic_operator_decl_item_list
  operator_signature is_or_as binding_function ';'
  {
    A_bind($2, $4);
    $$ = PH1LAPN($2, $1);
  }
;

/*
 * Reserved word attribute designators are included in the rules as a
 * convenience.  Alternativly, since an attribute designator is always preced
 * by an apostrophe, as noted in the RR_ 4.1.4, such usage may be detected
 * during lexical analysis thus obviating the need for special rules.
 *
 * The univ static expr of an attribute designator is reduced
 * as an "idxed_cmpon".
 */

arg_list:

  /* empty */
  {
    $$ = lismak();
  }
|
  arg_list ',' arg
  {
    $$ = PH1LAPN($3, $1);
  }
;

relal_op_sim_expr_opt:
  /* empty */
  {
    $$ = TRENULL;
  }
|
  relal_op sim_expr
  {
    ub4 tmp1 = (ub4)ph1nfs(ph1p, PH1LINN($2, lismak()), D_F_CALL);
    $$ = ph1dtn(ph1p, D_F_CALL, 2, (ub4)$1, tmp1);
  }
;



NOT_opt:        /* make sure the above is the only usage of this non-term */

  /* empty */
  {
    $$ = T_NONE;
  }
|
  NOT_
  {
    $$ = T_NOT;
  }
;

like: 
  LIKE_
  {
      $$ = T_LIKE;
  }
|
  LIKE2_
  {
      $$ = T_LIKE2;
  }
|
  LIKE4_
  {
      $$ = T_LIKE4;
  }
|
  LIKEC_
  {
      $$ = T_LIKEC;
  }
;

NOT_opt_IN:

  NOT_opt IN_
  {
    if ( $1 == T_NONE )
     $$ = ph1mak(ph1p, D_IN_OP);
    else
      $$ = ph1mak(ph1p, D_NOT_IN);
  }
;

NOT_opt_BETWEEN:

  NOT_opt BETWEEN_
  {
    if ( $1 == T_NONE )
      $$ = ph1mak(ph1p, D_IN_OP);
    else
      $$ = ph1mak(ph1p, D_NOT_IN);
  }
;

NOT_opt_LIKE:

  NOT_opt like
  {
    if ( $1 == T_NONE )
    {
      if ($2 == T_LIKE)
        $$ = ph1dtn(ph1p, D_USED_O, 1, (text *)P_LIKE);
      else if ($2 == T_LIKE2)
        $$ = ph1dtn(ph1p, D_USED_O, 1, (text *)P_LIKE2);
      else if ($2 == T_LIKE4)
        $$ = ph1dtn(ph1p, D_USED_O, 1, (text *)P_LIKE4);
      else if ($2 == T_LIKEC)
        $$ = ph1dtn(ph1p, D_USED_O, 1, (text *)P_LIKEC);
    }
    else
    {
      if ($2 == T_LIKE)
        $$ = ph1dtn(ph1p, D_USED_O, 1, (text *)P_NOT_UNDER_LIKE);
      else if ($2 == T_LIKE2)
        $$ = ph1dtn(ph1p, D_USED_O, 1, (text *)P_NOT_LIKE2);
      else if ($2 == T_LIKE4)
        $$ = ph1dtn(ph1p, D_USED_O, 1, (text *)P_NOT_LIKE4);
      else if ($2 == T_LIKEC)
        $$ = ph1dtn(ph1p, D_USED_O, 1, (text *)P_NOT_LIKEC);
    }
  }
;

arith_expr:

  term
  {
    $$ = $1;
  }
|
  arith_expr binary_add_op term
  {
      ub4 tmp1 = (ub4)ph1nfs(ph1p,
                             PH1LINN($1, PH1LINN($3, lismak())),
                             D_F_CALL);
      $$ = ph1dtn(ph1p, D_F_CALL, 2, (ub4)$2, tmp1);
   }
;

EXP_pri_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  EXP_ pri
  {
    $$ = $2;
    PH1FLAG(1412, $$);
  }
;


stmt_list_opt:

  pragma_list_opt
  {
    /* [5242317, 3647002] The pragma has always been hooked in correctly. */
    $$ = $1;
  }
|
  stmt_list_opt stmt pragma_list_opt
  {
    /* 
     * [5242317, 3647002] This is the one remaining place we may not have
     * previously hooked pragmas in correctly.  Any pre-11g pragma is invalid
     * here, and would (if hooked in correctly) be flagged by PH1 and/or PH2.
     * So, we simplify, and flag them all here (so we don't need to deal with
     * issuing severe warnings in PH2 just on the pragmas from this location.)
     */
    lisdef *pragma_list = $3;
    
    while (!lisemp(pragma_list))
    {
            ptnod  d_pragma = liscar(pragma_list);
            ptnod  iden     = a_ID(d_pragma);
      const text  *name     = l_SYMREP(iden);
  
      /* If not an 11g-era pragma... */
      if (!(!strcmp((char *)name, (char *)P_INLINE)          ||
            !strcmp((char *)name, (char *)P_ORIGINAL_SOURCE) ||
            !strcmp((char *)name, (char *)P_DEPRECATE)       ||
            !strcmp((char *)name, (char *)P_COVERAGE)))
      {
        ub4 flags = l_DEFAUL(iden);

        PH1ERRT(5014, SEVERWARN, iden, PLSUNIQ(36), iden); 
        
        bis(flags, PHD_BAD_PRAGMA);
        L_defaul(iden, flags);
      }
      pragma_list = liscdr(pragma_list);
    }
    
    $$ = PH1LCAT(PH1LAPN($2, $1), $3);
  }
;

label_list_opt:

  /* empty */
  {
    $$ = lismak();
  }
|
  label_list_opt label
  {
    $$ = PH1LAPN($2, $1);
  }
;

elsif_clause_opt:

  /* empty */
  {
    $$ = lismak();
  }
|
  elsif_clause_opt
  ELSIF_ expr THEN_
  seq_of_stmts
  {
    $$ = PH1LAPN(ph1dtn(ph1p, D_COND_C, 2, (ub4)($3), (ub4)$5), $1);
  }
;

else_clause_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  ELSE_
  seq_of_stmts
  {
    $$ = $2;
  }
;

identifier_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  identifier
;

iteration_scheme_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  iteration_scheme
;

DECLARE_decls_opt:

  /* empty */
  {
    $$ = ph1dtn(ph1p, DS_ITEM, 1, llismak());
    L_srclin($$, 0);  L_srccol($$, 0);
  }
|
  DECLARE_
  decl_list
  {
    $$ = ph1dtn(ph1p, DS_ITEM, 1, PH1PSQ($2));
  }
;

exception_handlers_opt:

  /* empty */
  {
    $$ = ph1dtn(ph1p, DS_ALTER, 1, (ub4)llismak());
  }
|
  EXCEPTION_
  pragma_list_opt excptn_handlers
  {
    /* Bug 3626769.  We have no place to hang the pragmas since we have to
       return a node (a DS_ALTER), not a sequence.  So, throw an implementation
       restriction severe warning [5242317] if there are any pragmas.  
       JM-05/24/04, 08/09/06 */ 
    if (!lisemp($2))
      PH1ERRS(5999, SEVERWARN, liscar($2), PLSUNIQ(35), 
              (const text *)"Pragma not allowed in this location");
    $$ = ph1dtn(ph1p, DS_ALTER, 1, PH1PSQ($3));
  }
;

excptn_handlers:

  excptn_handler
  {
    $$ = PH1LINN($1, lismak());
  }
|
  excptn_handlers excptn_handler
  {
    $$ = PH1LAPN($2, $1);
  }
;

dotted_name_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  dotted_name
;

WHEN_cond_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  WHEN_ expr
  {
    $$ = $2;
  }
;

expr_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  expr
;

fml_part_opt:

  /* empty */               /* the lack of a formal part means no parameters */
  {
    $$ = ph1dtn(ph1p, DS_PARAM, 1, (ub4)llismak());
  }
|
  fml_part
;

parm_list_opt:

  /* empty */
  {
    $$ = lismak();
  }
|
  parm_list_opt ',' prm_spec
  {
    $$ = PH1LAPN($3, $1);
  }
;

IN_opt:

  /* empty */
  {
    $$ = T_FALSE;
  }
|
  IN_
  {
    $$ = T_TRUE;
  }
;

decl_list_opt:

  decl_list
;

/* A_ "decl_part" may be empty. */

designator_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  designator
;

empty_block:

  {
    ub4 tmp1 = (ub4)ph1dtn(ph1p, DS_ITEM, 1, (ub4)llismak());
    ub4 tmp2 = (ub4)ph1dtn(ph1p, DS_STM, 1, (ub4)llismak());
    ub4 tmp3 = (ub4)ph1dtn(ph1p, DS_ALTER, 1, (ub4)llismak());
    $$ = ph1dtn(ph1p, D_BLOCK, 3, tmp1, tmp2, tmp3);
  }
;

block_opt:

  /* note that we pass back an incomplete tree */
  /* empty */
  empty_block
|
  BEGIN_
    seq_of_stmts
  exception_handlers_opt
  {
    ub4 tmp1 = (ub4)ph1dtn(ph1p, DS_ITEM, 1, (ub4)llismak());
    $$ = ph1dtn(ph1p, D_BLOCK, 3, tmp1, (ub4)$2, (ub4)$3);
    A_beglin($$, SRCLINE(1));  A_begcol($$, SRCCOL(1));
  }
;

/* "subprg_body" is already contained in the class "library_unit". */

excptn_choice_list_opt:

  /* empty */
  {
    $$ = lismak();
  }
|
  excptn_choice_list_opt OR_ excptn_choice
  {
    $$ = PH1LAPN($3, $1);
  }
;

time_zone_specifier:
  LOCAL_
  {
    $$ = ph1dti(ph1p, D_STRING, (text *)P_SYS_LOCAL);
  }
  /* same as time zone "SYS_LOCAL", pesblt looks */
  /* the string in the implementation            */
|
  TIME_ ZONE_ pri
  {
    $$ = $3;
  }
;

LOCAL_opt:

  /* empty */
  {
    $$ = 0;
  }
|
  LOCAL_
  {
    $$ = 1;
  }
;

constrained_datetime_type:

  datetime_link_expanded_n constraint_opt
  {
    $$ = ph1dtn(ph1p, D_CONSTR, 2, (ub4)$1, (ub4)$2) ;
  }
|
  datetime_link_expanded_n constraint_opt WITH_ LOCAL_opt TIME_ ZONE_
  {
    if (PTKIN($1) !=  DI_U_NAM)                  /* eg time.t with time zone */
    {
      PH1ERR(125, SEVSEVER, $1, PLSUNIQ(30));
    }
    if (!strcmp((char *) l_SYMREP($1), (char *)P_TIME))
    {
      if (!$4)
        L_symrep($1, ph1dte(ph1p, P_TIME_WITH_TIME_ZONE));
      else
        /* raise error for time with local time zone */
        PH1ERR(125, SEVSEVER, $1, PLSUNIQ(31));
    }
    else if (!strcmp((char *) l_SYMREP($1), (char *)P_TIMESTAMP))
    {
      if (!$4)
        L_symrep($1, ph1dte(ph1p, P_TIMESTAMP_WITH_TIME_ZONE));
      else
        L_symrep($1, ph1dte(ph1p, P_TIMESTAMP_WITH_LOCAL_TIME_ZONE));
    }
    else
    {
      PH1ERR(125, SEVSEVER, $1, PLSUNIQ(32));
    }

    $$ = ph1dtn(ph1p, D_CONSTR, 2, (ub4)$1, (ub4)$2);
  }
;

datetime_d:

  datetime_link_expanded_n
|
  TIME_ WITH_ TIME_ ZONE_
  {
    $$ = ph1dti(ph1p, DI_U_NAM, P_TIME_WITH_TIME_ZONE);
  }
|
  TIMESTAMP_ WITH_ LOCAL_opt TIME_ ZONE_
  {
    if ($3)
      $$ = ph1dti(ph1p, DI_U_NAM, P_TIMESTAMP_WITH_LOCAL_TIME_ZONE);
    else
      $$ = ph1dti(ph1p, DI_U_NAM, P_TIMESTAMP_WITH_TIME_ZONE);
  }
;

/*
 * The problem with constraint_opt is that it will give us back a
 * D_APPLY in the simple case and it creates a D_RANGE if
 * it gets (a, b) which we shouldn't have here
 * Thus this simple interval constraint is born
*/

iconstraint_opt:

  iconstraint
|
  /* null */
  {
    $$ = TRENULL;
  }
;

iconstraint:

  '(' sim_expr ')'
  {
    $$ = $2;
  }
;

/* We should change other constraint_opt's to iconstraint_opt for datetime
 * Then we should make a ds_apply for all these and
 * change the positioning of ph2dtc in ph2con where we add
 * a case for datetime/interval
*/

constrained_interval_type_2:

  YEAR_ iconstraint_opt TO_ MONTH_
  {
    ub4 typnam = (ub4) ph1dti(ph1p, DI_U_NAM, P_INTERVAL_YEAR_TO_MONTH);
    ub4 range  = ph1dtn(ph1p, D_RANGE, 2, (ub4)$2, (ub4)TRENULL);
    $$ = ph1dtn(ph1p, D_CONSTR, 2, typnam, range);
  }
|
  DAY_ iconstraint_opt TO_ SECOND_ iconstraint_opt
  {
    ub4 typnam = (ub4) ph1dti(ph1p, DI_U_NAM, P_INTERVAL_DAY_TO_SECOND);
    ub4 range  = ph1dtn(ph1p, D_RANGE, 2, (ub4)$2, (ub4)$5);
    $$ = ph1dtn(ph1p, D_CONSTR, 2, typnam, range) ;
  }
;

/* we should sanity check constraints.  This is like                         */
/* constrained_interval_type_2 except we don't make and then throwaway diana */
/* nodes                                                                     */

constrained_interval_return_type:

  YEAR_ iconstraint_opt TO_ MONTH_
  {
    $$ = ph1dti(ph1p, DI_U_NAM, P_YMINTERVALSUBTRACT);
    L_defaul($$, PHD_BUILTIN_NAME);
  }
|
  DAY_ iconstraint_opt TO_ SECOND_ iconstraint_opt
  {
    $$ = ph1dti(ph1p, DI_U_NAM, P_DSINTERVALSUBTRACT);
    L_defaul($$, PHD_BUILTIN_NAME);
  }
;

interval_qualifier:

  YEAR_  TO_ MONTH_
  {
    $$ = ph1dti(ph1p, DI_U_NAM, P_INTERVAL_YEAR_TO_MONTH);
  }
|
  DAY_  TO_ SECOND_
  {
    $$ = ph1dti(ph1p, DI_U_NAM, P_INTERVAL_DAY_TO_SECOND);
  }
;

constrained_interval_type:

   INTERVAL_ constrained_interval_type_2
   {
     $$ = $2;
   }
;

interval_d:

   INTERVAL_ interval_qualifier
   {
     $$ = $2;
   }
;

alldatetime_d:

  interval_d
|
  datetime_d
;

constrained_datetime_interval_type:

  constrained_interval_type
|
  constrained_datetime_type
;

/* case statement */
case_stmt:

  CASE_ expr_opt
  case_stmt_alt_seq
  else_clause_opt
  END_ CASE_ identifier_opt ';'
  {
    noddef tmp;
    if ($4)
      tmp = ph1dtn(ph1p,D_ALTERN,2,(ub4)TRENULL,(ub4)$4);
    else
    {
      /* make an implicit ELSE RAISE CASE_NOT_FOUND statement */
      tmp = ph1dti(ph1p, DI_U_NAM, (text *) "CASE_NOT_FOUND");
      L_defaul(tmp, PHD_BUILTIN_NAME);
      tmp = ph1dtn(ph1p,D_RAISE,1,tmp);
      tmp = ph1dtn(ph1p,DS_STM,1,(ub4)PPH1LINN(tmp,lismak()));
      tmp = ph1dtn(ph1p,D_ALTERN,2,(ub4)TRENULL,(ub4)tmp);
    }
    $$ = ph1dtn(ph1p,D_CASE,2,(ub4)$2,
                (ub4)ph1dtn(ph1p,DS_ALTER,1, (ub4)PPH1LAPN(tmp,$3)));
    A_endlin($$, SRCLINE(5));
    A_endcol($$, SRCCOL(5));
  }
;

case_stmt_alt_seq:

  case_stmt_alt
  { 
    $$ = PH1LAPN($1, lismak());
  }
|
  case_stmt_alt_seq case_stmt_alt
  {
    $$ = PH1LAPN($2, $1);
  }
;

case_stmt_alt:

  WHEN_ expr THEN_
  seq_of_stmts
  {
    $$ = ph1dtn(ph1p,D_ALTERN,2,
                (ub4)ph1dtn(ph1p,DS_CHOIC,1,(ub4)PPH1LINN($2,lismak())),$4);
  }
;

/* case expression */
case_expr:

  CASE_ expr_opt
  case_expr_alt_seq
  ELSE_expr_opt
  END_
  {
    noddef tmp;
    if ($4)
      tmp = ph1dtn(ph1p,D_ALTERN_EXP,2,(ub4)TRENULL,(ub4)$4);
    else
    {
      /* make an implicit ELSE NULL expression */
      tmp = ph1mak(ph1p,D_NULL_A);
      tmp = ph1dtn(ph1p,D_ALTERN_EXP,2,(ub4)TRENULL,(ub4)tmp);
    }
    $$ = ph1dtn(ph1p,D_CASE_EXP,2,(ub4)$2, (ub4)PPH1LAPN(tmp,$3));
    A_endlin($$, SRCLINE(5));
    A_endcol($$, SRCCOL(5));
  }
;

case_expr_alt_seq:

  case_expr_alt
  { 
    $$ = PH1LAPN($1, lismak());
  }
|
  case_expr_alt_seq case_expr_alt
  {
    $$ = PH1LAPN($2, $1);
  }
;

case_expr_alt:

  WHEN_ expr THEN_
  expr
  {
    $$ = ph1dtn(ph1p,D_ALTERN_EXP,2,
                (ub4)ph1dtn(ph1p,DS_CHOIC,1,(ub4)PPH1LINN($2,lismak())),$4);
  }
;

ELSE_expr_opt:

  /* empty */
  {
    $$ = TRENULL;
  }
|
  ELSE_ expr
  {
    $$ = $2;
  }
;

/* List of ADT attribute names */
alt_ty_attr_names:

  identifier
  {
    $$ = PH1LINN($1, lismak());
  }
|
  '(' alt_ty_attr_nlist ')'
  {
    $$ = $2;
  }
;

/* ADT attribute names separated by commas used in alt_ty_attr_names */
alt_ty_attr_nlist:

  identifier
  {
    $$ = PH1LINN($1, lismak());
  }
|
  identifier ',' alt_ty_attr_nlist 
  {
    $$ = PH1LAPN($1, $3);
  }
;

/* A single ADT attribute specification or a paranthesized list of them. */
alt_ty_attrs:

  field
  {
    $$ = PH1LINN($1, lismak());
  }
|
  '(' alt_ty_attr_list ')'
  {
    $$ = $2;
  }
;

/* List of ADT attribute specifications used in alt_ty_attrs */
alt_ty_attr_list:

  field
  {
    $$ = PH1LINN($1, lismak());
  }
|
  field ',' alt_ty_attr_list 
  {
    $$ = PH1LINN($1, $3);
  }
;

/* Index Limit For Collections */
collection_limit:
  sim_expr
  {
    $$ = $1;
  }
;

/* ADD, DROP, MODIFY or RENAME of attributes of an ADT */
alt_ty_attributes:

  ADD_ ATTRIBUTE_ alt_ty_attrs
  {
    $$ = ph1mak(ph1p, D_ALT_TYPE);
    AS_alters($$, $3);
    A_alteract($$, PHD_ALTER_TYPE_ADD_ATTRIBUTE);
  }
|
  DROP_ ATTRIBUTE_ alt_ty_attr_names
  {
    $$ = ph1mak(ph1p, D_ALT_TYPE);
    AS_alters($$, $3);
    A_alteract($$, PHD_ALTER_TYPE_DROP_ATTRIBUTE);
  }
|
  MODIFY_ ATTRIBUTE_ alt_ty_attrs
  {
    $$ = ph1mak(ph1p, D_ALT_TYPE);
    AS_alters($$, $3);
    A_alteract($$, PHD_ALTER_TYPE_MODIFY_ATTRIBUTE);
  }
|
  RENAME_ ATTRIBUTE_ alt_ty_attr_names TO_ alt_ty_attr_names
  {
    $$ = ph1mak(ph1p, D_ALT_TYPE);
    AS_alters($$, PH1LCAT ($3, $5));
    A_alteract($$, PHD_ALTER_TYPE_RENAME_ATTRIBUTE);
    /* RENAME is not supported yet (8.2.0) so error */
    PH1ERRS(951, SEVERROR, $$, PLSUNIQ(33), (text *)"RENAME");
  }
;


/*
 * Comma separated multiple ADD, DROP, MODIFY or renames of attributes.
 * Just makes a list of d_alt_type nodes.
 */
alt_ty_attribs_list:

  alt_ty_attributes
  {
    $$ = PH1LINN($1, lismak());
  }
|
  alt_ty_attribs_list ',' alt_ty_attributes
  {
    $$ = PH1LCAT($1, PH1LINN($3, lismak()));
  }
;

/* ADD, DROP or RENAME methods and pragmas comma separated list */
alt_ty_methods_list:

  ADD_ method_specification alt_ty_meth_opt_pragma
  {   
    noddef tempnode = ph1mak(ph1p, D_ALT_TYPE);
    AS_alters(tempnode, PH1LINN ($2, lismak()));
    A_alteract(tempnode, PHD_ALTER_TYPE_ADD_METHOD);
    $$ = PH1LINN(tempnode, lismak());
    if (!lisemp($3))
    {
      $$ = PH1LCAT($$, $3);
    }
  }
|
  DROP_ method_specification alt_ty_meth_opt_pragma
  {    
    noddef tempnode = ph1mak(ph1p, D_ALT_TYPE);
    AS_alters(tempnode, PH1LINN ($2, lismak()));
    A_alteract(tempnode, PHD_ALTER_TYPE_DROP_METHOD);
    $$ = PH1LINN(tempnode, lismak());
    if (!lisemp($3))
    {
      $$ = PH1LCAT($$, $3);
    }
  }
|
  RENAME_ method_specification TO_ identifier alt_ty_meth_opt_pragma
  {
    noddef tempnode = ph1mak(ph1p, D_ALT_TYPE);
    AS_alters(tempnode,
              PH1LCAT((PH1LINN($2, lismak())), (PH1LINN($4, lismak()))));   
    A_alteract(tempnode, PHD_ALTER_TYPE_RENAME_METHOD);
    $$ = PH1LINN(tempnode, lismak());
    if (!lisemp($5))
    {
      $$ = PH1LCAT($$, $5);
    }
    /* RENAME is not supported yet (8.2.0) so error */
    PH1ERRS(951, SEVERROR, tempnode, PLSUNIQ(34), (text *)"RENAME");
  }
;

/* Optional purity pragmas for alter type add/drop methods go here */
alt_ty_meth_opt_pragma:

  /* Empty */
  {
    $$ = lismak();
  }
|
  ',' pragma alt_ty_meth_opt_pragma
  {
    noddef tempnode = ph1mak(ph1p, D_ALT_TYPE);
    AS_alters(tempnode, PH1LINN($2, lismak()));
    A_alteract(tempnode, PHD_ALTER_TYPE_PRAGMA);
    $$ = PH1LINN(tempnode, lismak());
    $$ = PH1LCAT($$, $3);
  }
|
  ',' alt_ty_methods_list
  {
    $$ = $2;
  }
;


/*
 * alt_ty_data_opts: Option indicating whether the ALTER TYPE changes should
 * immediately convert the data in tables or columns of this ADT type to the
 * new version. The default is to convert table data.
 */
alt_ty_data_opts:
  /* empty */
  {
    bis(ph1p->alt_ty_SQL_options, PSDSATR_ALT_TYPE_TABLE_DATA);
    $$ = T_NONE;    
  }
|
  NOT_opt INCLUDING_ TABLE_ DATA_
  {
    if ($1 == T_NOT)
    {
      bic(ph1p->alt_ty_SQL_options, PSDSATR_ALT_TYPE_TABLE_DATA);
      $$ = T_NOT;
    }
    else
    {
      bis(ph1p->alt_ty_SQL_options, PSDSATR_ALT_TYPE_TABLE_DATA);
      $$ = T_NONE;
    }
    $$ = T_NONE;
  }
|
  CONVERT_ TO_ SUBSTITUTABLE_
  {
    bis(ph1p->alt_ty_SQL_options, PSDSATR_ALT_TYPE_TO_SUBS);
    $$ = T_NONE;
  }
;

/*
 * force_opt: Option indicating ignore errors from dependent entities and
 * force the ALTER TYPE to take effect on the type being ALTERED.
 */
force_opt:
  /* empty */
  {
    $$ = T_NONE;
  }
|
  FORCE_
  {
    $$ = T_TRUE;
  }
;

/*
 * alt_ty_excep_opt: Option to put the errors raised during propagation of
 * changes to the dependent entities. We pick up the table name in which
 * these errors should be inserted by SQL and pass this name to SQL at the
 * end of parsing ALTER TYPE.
 */
alt_ty_excep_opt:
  /* empty */
  {
    ph1p->exception_table  = (text *)0;
    ph1p->exception_schema = (text *)0;

    $$ = T_NONE;
  }
|
  force_opt EXCEPTIONS_ INTO_ dotted_name
  {
    if ($1 == T_TRUE)
      bis(ph1p->alt_ty_SQL_options, PSDSATR_ALT_TYPE_FORCE);
    else
      bic(ph1p->alt_ty_SQL_options, PSDSATR_ALT_TYPE_FORCE);
 
    if (PTKIN($4) == D_S_ED)
    {
      ph1p->exception_table  = (text *)(l_SYMREP(a_D_CHAR($4)));
      ph1p->exception_schema = (text *)(l_SYMREP(a_NAME($4)));
    }
    else
    {
      ph1p->exception_table  = (text *)(l_SYMREP($4));
      ph1p->exception_schema = (text *) 0;
    }
    $$ = T_NONE;
  }
;

/*
 * alter type options:
 * alt_ty_data_opts, alt_ty_force_opt and alt_ty_excep_opt are various
 * options to ALTER TYPE statement that are used by SQL/RDBMS to decide
 * and modify database entities like tables of type, sub types of the
 * type being altered, etc.
 *
 * We parse them but have no use for them. We just pass them back to SQL
 * through the PSDSATR callback in optional_alter_type grammar rule.
 */
alt_ty_options:
  /* empty */
  {
    $$ = T_NONE;
  }
|
  INVALIDATE_                              /* Just invalidate all dependents */
  {
    bis(ph1p->alt_ty_SQL_options, PSDSATR_ALT_TYPE_INVALIDATE);
    $$ = T_NONE;
  }
|
  CASCADE_ alt_ty_data_opts alt_ty_excep_opt
  {
    bis(ph1p->alt_ty_SQL_options, PSDSATR_ALT_TYPE_CASCADE);
    $$ = T_NONE;
  }
;
/* The ALTER TYPE statement */

/* The common terminal prefix */
alter_type_prefix:
  ALTER_ TYPE_ 
  {
    /*
     * Stop putting symbols in symbol table during ALTER TYPES. We will do
     * it explicitly in phase2 (ph2process_alter_type)
     */
    bis(ph1p->ph1misc, PH1_IN_ALTER_TYPE);
    
    /* Set the default values for dependent objects options */
    bic(ph1p->alt_ty_SQL_options,
        (PSDSATR_ALT_TYPE_FORCE |
         PSDSATR_ALT_TYPE_CASCADE |
         PSDSATR_ALT_TYPE_INVALIDATE | PSDSATR_ALT_TYPE_TO_SUBS));

    /* default is to update table data */
    bis(ph1p->alt_ty_SQL_options, PSDSATR_ALT_TYPE_TABLE_DATA);

    bic(ph1p->alt_ty_SQL_options, PSDSATR_ALT_TYPE_ATTR_CHANGED);
    bic(ph1p->alt_ty_SQL_options, PSDSATR_ALT_FINAL_PROP_CHANGED);

    ph1p->exception_table  = (text *)0;
    ph1p->exception_schema = (text *)0;
  }
;


alt_ty_a_statement:
  alter_type_prefix 
  dotted_name 
  alt_ty_changes
  {
    $$ = ph1mak(ph1p, D_AN_ALTER);
    AS_alts($$, $3);
  }
;

alt_ty_changes:

  alt_ty_attribs_list  alt_ty_options               /* Changes to attributes */
  {
    $$ = $1;
    if (!lisemp($$)) 
      bis((ph1p->alt_ty_SQL_options), PSDSATR_ALT_TYPE_ATTR_CHANGED);
  }
|
  alt_ty_methods_list  alt_ty_options                  /* Changes to methods */
  {
    /* Process the purity pragmas here for methods added using ALTER
     * TYPE
     */
    ph1altprg(ph1p, $1);
    $$ = $1;
  }
|
  adt_flags  alt_ty_options             /* Alter FINAL/INSTANTIABLE property */
  {
    /*
     * Set the properties of the type. ph1p->ph1misc is used to track the
     * type's  current properties - this is toggled by successive ALTER
     * TYPE statements that modify these properties.
     *
     * The latest i.e. the current ALTER TYPE statement will be the last one
     * to set these properties and then they can be applied to the ADT in
     * adt_specification rule.
     */
    if (bit($1, PH1_NOT_FINAL))
    {
      /*
       * If this type is being altered from being FINAL to NOT FINAL
       * remember that in ph1p->alt_ty_SQL_options
       */
      if (!bit(ph1p->ph1misc, PH1_ALT_TY_NOT_FINAL))
      {
        bis(ph1p->alt_ty_SQL_options, PSDSATR_ALT_FINAL_PROP_CHANGED);
        bis(ph1p->ph1misc, PH1_ALT_TY_NOT_FINAL);
      }
    }
    else if (bit($1, PH1_FINAL))
    {
      /*
       * If this type is being altered from being NOT FINAL to FINAL
       * remember that in ph1p->alt_ty_SQL_options
       */
      if (bit(ph1p->ph1misc, PH1_ALT_TY_NOT_FINAL))
      {
        bis(ph1p->alt_ty_SQL_options, PSDSATR_ALT_FINAL_PROP_CHANGED);
        bic(ph1p->ph1misc, PH1_ALT_TY_NOT_FINAL);
      }
    }

    if (bit($1, PH1_NOT_INSTANTIABLE))
      bis(ph1p->ph1misc, PH1_ALT_TY_NOT_INSTANTIABLE);
    else if (bit($1, PH1_INSTANTIABLE))
      bic(ph1p->ph1misc, PH1_ALT_TY_NOT_INSTANTIABLE);

    $$ = lismak();
  }
;

/* One or more ALTER TYPE statements for structured ADTs */
alt_ty_stmts:

  alt_ty_a_statement
  {
    $$ = PH1LINN($1, lismak());
  }
|
  alt_ty_stmts
  alt_ty_a_statement
  {
    $$ = PH1LCAT($1, PH1LINN($2, lismak()));
  }
;

/*
 * Optional ALTER TYPE statements following the original CREATE TYPE
 * statement. SQL just appends ALTER TYPE to original CREATE TYPE and
 * sends to PLSQL for compiling. PLSQL sees original CREATE TYPE
 * followed by all historical ALTERS followed by current ALTER.
 */
optional_alter_types:

    /* empty */
  {
    $$ = lismak();
  }
|
  alt_ty_stmts
  {
    /* Finishing ALTER TYPES now okay to enter symbols in symbol
     * table.
     */
    bic(ph1p->ph1misc, PH1_IN_ALTER_TYPE);

    $$ = $1;
  }
;

/* ALTER ARRAY/Nested Table  */

/* This is exactly the same syntax as alt_ty_a_statement, 
   but it follows CREATE TYPE AS VARRAY/TABLE not OBJECT */
alt_array_a_statement:
  alter_type_prefix 
  dotted_name 
  alt_array_change
  {
    $$ = ph1mak(ph1p, D_AN_ALTER);
    AS_alts($$, $3);
  }
;


/* We only allow a single clause per alt_array_change for now */
/* It returns a list of single alt_array_clause               */
/* This is a list to mimic alt_type_changes                   */
alt_array_change :
 alt_array_clause alt_ty_options
 { 
   /* Set the fact that the type has been changed */
   bis((ph1p->alt_ty_SQL_options), PSDSATR_ALT_TYPE_ATTR_CHANGED);
   $$ = PH1LINN($1,lismak());
 } 
;


alt_array_clause :
  MODIFY_ LIMIT_  collection_limit
  {
    $$ = ph1mak(ph1p, D_ALT_TYPE);
    AS_alters($$, PH1LINN($3,lismak()));
    A_alteract($$, PHD_ALTER_ARRAY_MODIFY_LIMIT);
  }
|
  MODIFY_ ELEMENT_ TYPE_ constrained_type
  {
    $$ = ph1mak(ph1p, D_ALT_TYPE);
    AS_alters($$, PH1LINN($4,lismak()));
    A_alteract($$, PHD_ALTER_ARRAY_MODIFY_ELT_TYPE);
  }
;


/* One or more ALTER TYPE statements for arrays */
alt_array_stmts:

  alt_array_a_statement
  {
    $$ = PH1LINN($1, lismak());
  }
|
  alt_array_stmts
  alt_array_a_statement
  {
    $$ = PH1LCAT($1, PH1LINN($2, lismak()));
  }
;

optional_alter_arrays:

  /* empty */
  {
    $$ = lismak();
  }
|
  alt_array_stmts
  {
    $$ = $1;
  }
;

%%
