<?xml version="1.0"?>
<!--
NAME
    sxmltable.xsl
DESCRIPTION
    Convert sxml TABLE document to TABLE with sorted columns document

MODIFIED        MM/DD/YY
    hakali      09/12/06 - 
    abodge      08/25/06 - 
    abodge      08/25/06 - 
    rpattabh    08/09/06 - Add stylesheet to make sxml understandible to CMDiff
    rpattabh    08/01/06 - Initial version
 -->
<xsl:stylesheet xmlns:sxml="http://xmlns.oracle.com/ku"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" 
                exclude-result-prefixes="sxml">
                
 <xsl:output indent="no" method="xml" omit-xml-declaration="yes"/>
 <xsl:strip-space elements="*"/>
 
<!-- Comparison Directives -->
<xsl:param name="COLUMN_SORTBY">sxml:NAME</xsl:param>
<xsl:param name="IGNORE_NAME_DIFFERENCES">1</xsl:param>
<xsl:param name="INCLUDE_STATISTICS">0</xsl:param>
 <xsl:param name="MATCH_COLUMN_BY_NAME">1</xsl:param>
<xsl:param name="MATCH_CONSTR_BY_DEFINITION">1</xsl:param>

    <!-- root template -->
    <xsl:template match="/">
      <xsl:apply-templates select="*"/>
      </xsl:template>

    <xsl:template match="*">
      <xsl:element name="{local-name()}">
        <xsl:apply-templates select="*"/>
      </xsl:element>
      </xsl:template>

    <!-- Handle constraint nodes (no need to sort) -->
    <xsl:template match="sxml:PRIMARY_KEY_CONSTRAINT_LIST_ITEM|sxml:UNIQUE_KEY_CONSTRAINT_LIST_ITEM|sxml:FOREIGN_KEY_CONSTRAINT_LIST_ITEM|sxml:CHECK_CONSTRAINT_LIST_ITEM">
      <xsl:element name="{local-name()}">
      <xsl:attribute name="NAME">
        <xsl:value-of select="sxml:NAME">
        </xsl:value-of>
        </xsl:attribute>
      <xsl:attribute name="MATCH_CONSTR_BY_DEFINITION">
      <xsl:value-of select="$MATCH_CONSTR_BY_DEFINITION"/>
      </xsl:attribute>
      <xsl:attribute name="IGNORE_NAME_DIFFERENCES">
      <xsl:value-of select="$IGNORE_NAME_DIFFERENCES"/>
      </xsl:attribute>
      <xsl:apply-templates select="sxml:NAME" />
      <xsl:apply-templates select="sxml:COL_LIST" />
      <xsl:apply-templates select="sxml:REFERENCES" />
      <xsl:apply-templates select="sxml:CONDITION" />
      <xsl:apply-templates select="xml:USING_INDEX|sxml:ENABLE|sxml:VALIDATE" />
      </xsl:element>
      </xsl:template>

    <!-- For below nodes do nothing, just copy everything over -->
    <xsl:template match="sxml:NAME|sxml:USING_INDEX|sxml:ENABLE|sxml:VALIDATE|sxml:SCHEMA|sxml:NAME|sxml:RELATIONAL_TABLE/sxml:PHYSICAL_PROPERTIES|sxml:PHYSICAL_PROPERTIES|sxml:TABLE_PROPERTIES|sxml:INDEX_ATTRIBUTES|sxml:LOCAL_PARTITIONING|sxml:GLOBAL_PARTITIONING">
      <xsl:copy-of select="."/>
      </xsl:template>

    <!-- For constraint columns flagg their defn elems for differ to use -->
    <xsl:template match="sxml:ON_TABLE|sxml:TABLE_INDEX">
      <xsl:element name="{local-name()}">
      <xsl:apply-templates select="sxml:NAME|sxml:SCHEMA"/>
      <xsl:apply-templates select="sxml:COL_LIST"/>
      <xsl:apply-templates select="sxml:INDEX_ATTRIBUTES|sxml:LOCAL_PARTITIONING|sxml:GLOBAL_PARTITIONING"/>
      </xsl:element>
      </xsl:template>

    <!-- For check constraints flagg their defn elems for differ to use -->
    <xsl:template match="sxml:ON_TABLE/sxml:NAME|sxml:ON_TABLE/sxml:SCHEMA">
      <xsl:element name="{local-name()}">
      <xsl:attribute name="COMPUTE_CONSTR_DEF">TRUE</xsl:attribute>
      </xsl:element>
      </xsl:template>

    <!-- For constraint columns flagg their defn elems for differ to use -->
    <xsl:template match="sxml:REFERENCES">
      <REFERENCES>
      <xsl:apply-templates select="sxml:NAME|sxml:SCHEMA"/>
      <xsl:apply-templates select="sxml:COL_LIST"/>
      </REFERENCES>
      </xsl:template>

    <!-- For check constraints flagg their defn elems for differ to use -->
    <xsl:template match="sxml:REFERENCES/sxml:NAME|sxml:REFERENCES/sxml:SCHEMA">
      <xsl:element name="{local-name()}">
      <xsl:attribute name="COMPUTE_CONSTR_DEF">TRUE</xsl:attribute>
      </xsl:element>
      </xsl:template>

    <!-- For constraint columns flagg their defn elems for differ to use -->
    <xsl:template match="sxml:COL_LIST">
      <COL_LIST COMPUTE_CONSTR_DEF="TRUE">
      <xsl:copy-of select="*"/>
      </COL_LIST>
      </xsl:template>

    <!-- For check constraints flagg their defn elems for differ to use -->
    <xsl:template match="sxml:CONDITION">
      <CONDITION COMPUTE_CONSTR_DEF="TRUE">
      <xsl:copy-of select="*"/>
      </CONDITION>
      </xsl:template>

    <!-- Handle table columns need to sort and add name attribute -->
    <xsl:template match="sxml:RELATIONAL_TABLE/sxml:COL_LIST">
      <COL_LIST>
      <xsl:for-each select="sxml:COL_LIST_ITEM">
        <xsl:sort select="$COLUMN_SORTBY"/>
        <COL_LIST_ITEM>
        <xsl:attribute name="NAME">
        <xsl:value-of select="sxml:NAME">
        </xsl:value-of>
        </xsl:attribute>
        <xsl:copy-of select="*"/>
        </COL_LIST_ITEM>
        </xsl:for-each>
      </COL_LIST>
      </xsl:template>

</xsl:stylesheet> 
