<?xml version="1.0"?>
<!-- 
NAME
    kuquetab.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_queue_table_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    tbhukya     04/30/09 - Bug 8475565: add double quote in CREATE_QUEUE_TABLE
                           for schame and object name
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    htseng      04/08/04 - bug 3554691 : add storage_clause 
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    htseng      01/10/02 - make all DBMS_AQ_IMP_INTERNAL calls in 
			   one begin/end block.
    htseng 	10/22/01 - change EXECUTE to BEGIN/END.
    htseng 	09/19/01 - Merged htseng_add_xsl_stylesheets
    htseng	08/01/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="QUETAB_T">
  <xsl:if test="$EXPORT=0">
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">DBMS_AQADM.CREATE_QUEUE_TABLE</xsl:with-param>
    <xsl:with-param name="ObjectType">AQ_QUEUE_TABLE</xsl:with-param>
    <!-- xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/ -->
    <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
    <xsl:with-param name="BaseSchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
    <xsl:with-param name="BaseNameNode" select="SCHEMA_OBJ/NAME"/>
    <xsl:with-param name="BaseObjectType" select="SCHEMA_OBJ/TYPE"/>
   </xsl:call-template>
   <xsl:text> BEGIN DBMS_AQADM.CREATE_QUEUE_TABLE(</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>Queue_table        => '</xsl:text>
   <xsl:call-template name="QuoteObject">
    <xsl:with-param name="Schema" select="SCHEMA_OBJ/OWNER_NAME"/>
    <xsl:with-param name="Object" select="SCHEMA_OBJ/NAME"/>
   </xsl:call-template>
   <xsl:text>',</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>Queue_payload_type => '</xsl:text>
   <xsl:choose>
    <xsl:when test="UDATA_TYPE=1">
     <xsl:value-of select="OBJECT_TYPE"/>
    </xsl:when>
    <xsl:when test="UDATA_TYPE=2">
     <xsl:text>VARIANT</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>RAW</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:text>',</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>storage_clause     => '</xsl:text>
   <xsl:text>PCTFREE </xsl:text>
   <xsl:value-of select="STORAGE_CLAUSE/PCT_FREE"/>
   <xsl:text> PCTUSED </xsl:text>
   <xsl:value-of select="STORAGE_CLAUSE/PCT_USED"/>
   <xsl:text> INITRANS </xsl:text>
   <xsl:value-of select="STORAGE_CLAUSE/INITRANS"/>
   <xsl:text> MAXTRANS </xsl:text>
   <xsl:value-of select="STORAGE_CLAUSE/MAXTRANS"/>
   <xsl:text> TABLESPACE </xsl:text>
   <xsl:value-of select="STORAGE_CLAUSE/TS_NAME"/>
   <xsl:text>'</xsl:text>
   <xsl:if test="SORT_COLS !=0">
    <xsl:text>,</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;     </xsl:text>
    </xsl:if>
    <xsl:text>Sort_list          => '</xsl:text>
    <xsl:choose>
     <xsl:when test="SORT_COLS =1">
      <xsl:text>PRIORITY</xsl:text>
     </xsl:when>
     <xsl:when test="SORT_COLS =2">
      <xsl:text>ENQ_TIME</xsl:text>
     </xsl:when>
     <xsl:when test="SORT_COLS =3">
      <xsl:text>PRIORITY,ENQ_TIME</xsl:text>
     </xsl:when>
     <xsl:when test="SORT_COLS =7">
      <xsl:text>ENQ_TIME,PRIORITY</xsl:text>
     </xsl:when>
    </xsl:choose>
    <xsl:text>'</xsl:text>
   </xsl:if>
   <xsl:if test="FLAGS mod 2 = 1">
    <xsl:text>,</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;     </xsl:text>
    </xsl:if>
    <xsl:text>Multiple_consumers =>  TRUE</xsl:text>
   </xsl:if>
   <xsl:if test="FLAGS mod 4 >= 2">
    <xsl:text>,</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;     </xsl:text>
    </xsl:if>
    <xsl:text>Message_grouping   =>  1</xsl:text>
   </xsl:if>
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:choose>
    <xsl:when test="FLAGS mod 16 >= 8">
     <xsl:text>Compatible         => '8.1.3'</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>Compatible         => '8.0.3'</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="string-length(TABLE_COMMENT)!=0">
    <xsl:text>,</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;     </xsl:text>
    </xsl:if>
    <xsl:text>comment            => '</xsl:text>
    <xsl:value-of select="TABLE_COMMENT"/>
    <xsl:text>'</xsl:text>
   </xsl:if>
   <xsl:if test="PRIMARY_INSTANCE!=0">
    <xsl:text>,</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;     </xsl:text>
    </xsl:if>
    <xsl:text>primary_instance   => </xsl:text>
    <xsl:value-of select="PRIMARY_INSTANCE"/>
   </xsl:if>
   <xsl:if test="SECONDARY_INSTANCE!=0">
    <xsl:text>,</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;     </xsl:text>
    </xsl:if>
    <xsl:text>secondary_instance => </xsl:text>
    <xsl:value-of select="SECONDARY_INSTANCE"/>
   </xsl:if>
   <xsl:text>)</xsl:text>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
   </xsl:if>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> END</xsl:text>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
   </xsl:if>
  </xsl:if>
  <!-- $EXPORT=0 -->
  <xsl:if test="$EXPORT=1">
   <xsl:if test="FLAGS mod 16 >=8">
    <xsl:call-template name="DoParse">
     <xsl:with-param name="Verb">DBMS_AQ_IMP_INTERNAL</xsl:with-param>
     <xsl:with-param name="ObjectType">AQ_QUEUE_TABLE</xsl:with-param>
     <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
     <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
    </xsl:call-template>
    <xsl:text> BEGIN </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text>     SYS.DBMS_AQ_IMP_INTERNAL.IMPORT_QUEUE_TABLE('</xsl:text>
    <xsl:value-of select="SCHEMA_OBJ/NAME"/>
    <xsl:text>', </xsl:text>
    <xsl:value-of select="UDATA_TYPE"/>
    <xsl:text>,</xsl:text>
    <xsl:value-of select="FLAGS"/>
    <xsl:if test="FLAGS mod 2 =1">
     <xsl:text>+4</xsl:text>
    </xsl:if>
    <xsl:if test="FLAGS mod 2=1 and FLAGS mod 16 >=8">
     <xsl:text>+112</xsl:text>
     <!-- 16+32+64 -->
    </xsl:if>
    <xsl:text>,</xsl:text>
    <xsl:value-of select="SORT_COLS"/>
    <xsl:text>,</xsl:text>
    <xsl:value-of select="PRIMARY_INSTANCE"/>
    <xsl:text>,</xsl:text>
    <xsl:value-of select="SECONDARY_INSTANCE"/>
    <xsl:text>,'</xsl:text>
    <xsl:value-of select="TABLE_COMMENT"/>
    <xsl:text>')</xsl:text>
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>;</xsl:text>
    </xsl:if>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:if test="FLAGS mod 2 = 1 and FLAGS mod 16 >= 8">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:text>     SYS.DBMS_AQ_IMP_INTERNAL.IMPORT_SUBSCRIBER_TABLE('AQ$_</xsl:text>
     <xsl:value-of select="SCHEMA_OBJ/NAME"/>
     <xsl:text>_S') </xsl:text>
     <xsl:if test="$SQLTERMINATOR=1">
      <xsl:text>;</xsl:text>
     </xsl:if>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:text>     SYS.DBMS_AQ_IMP_INTERNAL.IMPORT_TIMEMGR_TABLE('AQ$_</xsl:text>
     <xsl:value-of select="SCHEMA_OBJ/NAME"/>
     <xsl:text>_T') </xsl:text>
     <xsl:if test="$SQLTERMINATOR=1">
      <xsl:text>;</xsl:text>
     </xsl:if>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:text>     SYS.DBMS_AQ_IMP_INTERNAL.IMPORT_HISTORY_TABLE('AQ$_</xsl:text>
     <xsl:value-of select="SCHEMA_OBJ/NAME"/>
     <xsl:text>_H') </xsl:text>
     <xsl:if test="$SQLTERMINATOR=1">
      <xsl:text>;</xsl:text>
     </xsl:if>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
    </xsl:if>
    <xsl:if test="FLAGS mod 2 = 1 ">
     <xsl:text>     SYS.DBMS_AQ_IMP_INTERNAL.IMPORT_SIGNATURE_TABLE('AQ$_</xsl:text>
     <xsl:value-of select="SCHEMA_OBJ/NAME"/>
     <xsl:text>_NR') </xsl:text>
     <xsl:if test="$SQLTERMINATOR=1">
      <xsl:text>;</xsl:text>
     </xsl:if>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:text>     SYS.DBMS_AQ_IMP_INTERNAL.IMPORT_INDEX_TABLE('AQ$_</xsl:text>
     <xsl:value-of select="SCHEMA_OBJ/NAME"/>
     <xsl:text>_I') </xsl:text>
     <xsl:if test="$SQLTERMINATOR=1">
      <xsl:text>;</xsl:text>
     </xsl:if>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
    </xsl:if>
    <xsl:text> END </xsl:text>
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>;</xsl:text>
    </xsl:if>
   </xsl:if>
  </xsl:if>
  <!-- $EXPORT=1 -->
 </xsl:template>
</xsl:stylesheet>
