/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.extension.spi;

import java.util.HashMap;
import java.util.Map;
import javax.ide.extension.BooleanVisitor;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.I18NStringVisitor;


/**
 * Deprecated since 12.1.3. Usages greatly reduced post 11.1.2 as  
 * the 'feature' hook covers what this one did and more.
 * 
 * @deprecated replaced by the feature hooks
 */
@Deprecated
public final class FeatureHook extends ExtensionHook
{
  public static final ElementName ELEMENT = new ElementName( 
    MANIFEST_XMLNS, "feature-hook" );
  private static final ElementName LICENSE = new ElementName(
    MANIFEST_XMLNS, "license" );
  private static final ElementName COPYRIGHT = new ElementName(
    MANIFEST_XMLNS, "copyright" );
  private static final ElementName ICONPATH = new ElementName(
    MANIFEST_XMLNS, "iconpath" );
  private static final ElementName DESCRIPTION = new ElementName( 
    MANIFEST_XMLNS, "description" );
  private static final ElementName OPTIONAL = new ElementName(
    MANIFEST_XMLNS, "optional" );
  private static final ElementName PART_OF = new ElementName(
    MANIFEST_XMLNS, "part-of" );

  private ElementVisitor _copyrightHandler = new CopyrightHandler();
  private ElementVisitor _descriptionHandler = new DescriptionHandler();
  private ElementVisitor _licenseHandler = new LicenseHandler();
  private ElementVisitor _iconpathHandler = new IconPathHandler();
  private ElementVisitor _optionalHandler = new OptionalHandler();
  private ElementVisitor _partOfHandler = new PartOfHandler();
  
  private String KEY_FEATURE = "featurehook.feature";
  
  
  private Map _featureMap = new HashMap();
  
  public Map getFeatures()
  {
    return _featureMap;
  }
  
  /**
   * Handle the start of an XML element.
   * 
   * @param context a context object.
   */
  public void start( ElementStartContext context ) 
  {      
    context.registerChildVisitor( COPYRIGHT, _copyrightHandler );
    context.registerChildVisitor( DESCRIPTION, _descriptionHandler );
    context.registerChildVisitor( ICONPATH, _iconpathHandler );
    context.registerChildVisitor( LICENSE, _licenseHandler );
    context.registerChildVisitor( OPTIONAL, _optionalHandler );
    context.registerChildVisitor( PART_OF, _partOfHandler );

    Feature feature = new Feature();
    context.getScopeData().put( KEY_FEATURE, feature );
  }

  /**
   * Handle the end of an XML element.
   * 
   * @param context a context object.
   */
  public void end( ElementEndContext context ) 
  {
    _featureMap.put( super.getExtension( context ).getID(), 
      getFeature( context ) );
  }
  
  private Feature getFeature( ElementContext context )
  {
    return (Feature)context.getScopeData().get( KEY_FEATURE );
  }
  
  class LicenseHandler extends I18NStringVisitor
  {
    protected void string( ElementContext context, 
      String translatedString )  
    {
      getFeature( context ).setLicense( translatedString );
    }
  } 
  
  class CopyrightHandler extends I18NStringVisitor
  {
    protected void string( ElementContext context, 
      String translatedString )
    {
      getFeature( context ).setCopyright( translatedString );
    }
  }


  class DescriptionHandler extends I18NStringVisitor
  {
    protected void string( ElementContext context, 
      String translatedString )
    {
      getFeature( context ).setDescription( translatedString );  
    }
  }
  

  class IconPathHandler extends I18NStringVisitor
  {
    protected void string( ElementContext context, 
      String translatedString )
    {
      //TODO: Assign Image
    }
  }

  class PartOfHandler extends ElementVisitor
  { 
    public void end( ElementEndContext context ) 
    {
      getFeature( context ).setPartOf( context.getText() );
    }
  }  
  
  class OptionalHandler extends  BooleanVisitor
  {
    public void booleanValue( ElementContext context, boolean value ) 
    {
      getFeature( context ).setOptional( value );
    }
  }
    
}
