/*
 * @(#)LocalVariableT.java
 */

package javax.ide.model.java.source.tree;

/**
 * A local variable, not a parameter. <p/>
 *
 * @author Andy Yu
 * */
public interface LocalVariableT
  extends VariableT
{
  // ----------------------------------------------------------------------

  static final LocalVariableT[] EMPTY_ARRAY =
    new LocalVariableT[ 0 ];


  // ----------------------------------------------------------------------

  /**
   * Gets the owning block.
   *
   * @return The code block that this variable is declared to be used in.
   *
   * Local variables return the owning block.
   *
   * Formal parameters return the owning method's block. Null if the method
   * is abstract.
   *
   * Exception parameters return the owning catch clause's block.
   */
  public BlockT getOwningBlock();


  // ----------------------------------------------------------------------
}
