/*
 * @(#)NewClassExpressionT.java
 */

package javax.ide.model.java.source.tree;

/**
 * An expression creating a new instance of a class. Class creators come
 * two flavors: normal and anonymous class. <p/>
 *
 * @author Andy Yu
 * */
public interface NewClassExpressionT
  extends InvokeExpressionT
{
  // ----------------------------------------------------------------------

  /**
   * @return The special ClassT object representing the anonymous
   * class body. Null if no class body was declared.
   */
  public ClassT getAnonymousClass();
  
  /**
   * Gets the type reference for this element.
   *
   * @return This element's type reference.
   */
  public TypeReferenceT getType();


  /**
   * Unlinks the current source type and links the input element.
   * 
   * @param type The new type reference.
   *
   * @throws IllegalStateException if the input type is already linked.
   */
  public void setType( TypeReferenceT type );

}
